<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieViewconfig extends JView
{
	/**
	 * The default method that will display the output of this view which is called by
	 * Joomla
	 * 
	 * @param	string template	Template file name
	 **/	 	
	function display( $tpl = null )
	{
		//Load pane behavior
		jimport('joomla.html.pane');

		//initialise variables
		$document	= & JFactory::getDocument();
		$tabs 		= & JPane::getInstance('tabs');
		$params 	=& JComponentHelper::getParams('com_lyftenbloggie');
		$acl		=& JFactory::getACL();
		
		JHTML::_('behavior.tooltip');
		
		//add stuff to document
		$document->addStyleSheet('components/com_lyftenbloggie/assets/css/style.css');	
		$document->addScript('components/com_lyftenbloggie/assets/js/help.js');	
		
		//create the toolbar		
		JToolBarHelper::title( JText::_( 'CONFIG' ), 'lbconfig' );
		JToolBarHelper::save();
        JToolBarHelper::apply();
        JToolBarHelper::divider();
        JToolBarHelper::cancel();
        JToolBarHelper::spacer();

		//Create posting control HTML list
		$postingcontrol		= explode(",",$params->get('PostingControl'));
		array_walk($postingcontrol,"trim");
		
		$gtree = $acl->get_group_children_tree( null, 'USERS', false );
		$lists['PostingControl']  		= '<select name="PostingControl[]" multiple="multiple" size="7">';
		$sel 							= (in_array('0',$postingcontrol))?' selected="selected"':'';
		$lists['PostingControl']  		.= '<option value="0"' . $sel . '>None</option>';		
		foreach($gtree as $row) {
			$sel 		= (in_array($row->value,$postingcontrol))?' selected="selected"':'';
			$lists['PostingControl']  	.= '	<option value="'.$row->value.'"' . $sel . '>'.$row->text.'</option>';
		}
		$lists['PostingControl']  		.= '</select>';

		//Create publish control HTML list
		$publishcontrol		= explode(",",$params->get('PublishControl'));
		array_walk($publishcontrol,"trim");
		
		$gtree = $acl->get_group_children_tree( null, 'USERS', false );
		$lists['PublishControl']  		= '<select name="PublishControl[]" multiple="multiple" size="7">';
		$sel 							= (in_array('0',$publishcontrol))?' selected="selected"':'';
		$lists['PublishControl']  		.= '<option value="0"' . $sel . '>None</option>';
		foreach($gtree as $row) {
			$sel 		= (in_array($row->value,$publishcontrol))?' selected="selected"':'';
			$lists['PublishControl']  	.= '<option value="'.$row->value.'"' . $sel . '>'.$row->text.'</option>';
		}
		$lists['PublishControl']  		.= '</select>';

		// build the html for Avatar		
		$avatarused[] = JHTML::_('select.option',  '0', 			JText::_( 'Default' ) );
		$avatarused[] = JHTML::_('select.option',  'brezza', 		JText::_( 'Brezza' ) );
		$avatarused[] = JHTML::_('select.option',  'combuilder', 	JText::_( 'Community Builder' ) );
		$avatarused[] = JHTML::_('select.option',  'jomsocial', 	JText::_( 'jomSocial' ) );
		$lists['avatarused'] = JHTML::_('select.genericlist', $avatarused, 'params[avatarUsed]', 'class="inputbox" id="paramsavatarUsed"', 'value', 'text', $params->get('avatarUsed', '0') );	

		// build the html for Editor		
		$editorUsed[] = JHTML::_('select.option',  '0', JText::_( 'Joomla Default' ) );
		$editorUsed[] = JHTML::_('select.option',  '1', JText::_( 'Lyften Bloggie' ) );
		$lists['editorUsed'] = JHTML::_('select.genericlist', $editorUsed, 'params[editorUsed]', 'class="inputbox" id="paramsavatarUsed"', 'value', 'text', $params->get('editorUsed', '0') );	

		//assign data to template
		$this->assignRef('lists'				, $lists);
		$this->assignRef('tabs'					, $tabs);
		$this->assignRef('params'				, $params);

		parent::display($tpl);
	}
}
