<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0.0
 */
class LyftenBloggieViewSettings extends JView
{
	/**
	 * The default method that will display the output of this view which is called by
	 * Joomla
	 * 
	 * @param	string template	Template file name
	 **/	 	
	function display( $tpl = null )
	{
		//Load pane behavior
		jimport('joomla.html.pane');

		//initialise variables
		$document	= & JFactory::getDocument();
		$tabs 		= & JPane::getInstance('tabs');
		$params 	=& JComponentHelper::getParams('com_lyftenbloggie');
		$acl		=& JFactory::getACL();

		// Lets get some HELP!!!!
		require_once (JPATH_COMPONENT.DS.'helper.php');
		
		JHTML::_('behavior.tooltip');
		
		//add stuff to document
		$document->addStyleSheet('components/com_lyftenbloggie/assets/css/style.css');	
		$document->addScript('components/com_lyftenbloggie/assets/js/help.js');	
		
		//create the toolbar		
		JToolBarHelper::title( JText::_( 'SETTINGS' ), 'lbconfig' );
		JToolBarHelper::save();
        JToolBarHelper::apply();
        JToolBarHelper::divider();
        JToolBarHelper::cancel();
        JToolBarHelper::spacer();

		//Create posting control HTML list
		$postingcontrol		= explode(",",$params->get('PostingControl'));
		array_walk($postingcontrol,"trim");
		
		$gtree = $acl->get_group_children_tree( null, 'USERS', false );
		$lists['PostingControl']  		= '<select name="PostingControl[]" multiple="multiple" size="7">';
		$sel 							= (in_array('0',$postingcontrol))?' selected="selected"':'';
		$lists['PostingControl']  		.= '<option value="0"' . $sel . '>None</option>';		
		foreach($gtree as $row) {
			$sel 		= (in_array($row->value,$postingcontrol))?' selected="selected"':'';
			$lists['PostingControl']  	.= '	<option value="'.$row->value.'"' . $sel . '>'.$row->text.'</option>';
		}
		$lists['PostingControl']  		.= '</select>';

		//Create publish control HTML list
		$publishcontrol		= explode(",",$params->get('PublishControl'));
		array_walk($publishcontrol,"trim");
		
		$gtree = $acl->get_group_children_tree( null, 'USERS', false );
		$lists['PublishControl']  		= '<select name="PublishControl[]" multiple="multiple" size="7">';
		$sel 							= (in_array('0',$publishcontrol))?' selected="selected"':'';
		$lists['PublishControl']  		.= '<option value="0"' . $sel . '>None</option>';
		foreach($gtree as $row) {
			$sel 		= (in_array($row->value,$publishcontrol))?' selected="selected"':'';
			$lists['PublishControl']  	.= '<option value="'.$row->value.'"' . $sel . '>'.$row->text.'</option>';
		}
		$lists['PublishControl']  		.= '</select>';

		// build the html for Avatar		
		$avatarused[] = JHTML::_('select.option',  'default', 		JText::_( 'DEFAULT' ) );
		$avatarused[] = JHTML::_('select.option',  'brezza', 		JText::_( 'BREZZA' ) );
		$avatarused[] = JHTML::_('select.option',  'combuilder', 	JText::_( 'COMMUNITY BUILDER' ) );
		$avatarused[] = JHTML::_('select.option',  'jomsocial', 	JText::_( 'JOMSOCIAL' ) );
		$avatarused[] = JHTML::_('select.option',  'juser', 		JText::_( 'JUSER' ) );
		$lists['avatarused'] = JHTML::_('select.genericlist', $avatarused, 'params[avatarUsed]', 'class="inputbox" id="paramsavatarUsed"', 'value', 'text', $params->get('avatarUsed', 'default') );	

		// build the html for Comment Systems		
		$commentsys[] = JHTML::_('select.option',  '0', 	JText::_( 'DISABLED' ) );
		$commentsys[] = JHTML::_('select.option',  '1', 	JText::_( 'LYFTENBLOGGIE' ) );
		$commentsys[] = JHTML::_('select.option',  '2', 	JText::_( 'JCOMMENTS' ) );
		$commentsys[] = JHTML::_('select.option',  '3', 	JText::_( 'JOMCOMMENTS' ) );
		$lists['commentsys'] = JHTML::_('select.genericlist', $commentsys, 'params[typeComments]', 'class="inputbox" id="paramstypeComments"', 'value', 'text', $params->get('typeComments', '1') );	

		// build the html for Editor		
		$editorUsed[] = JHTML::_('select.option',  '0', JText::_( 'JOOMLA DEFAULT' ) );
		$editorUsed[] = JHTML::_('select.option',  '1', JText::_( 'LYFTENBLOGGIE' ) );
		$lists['editorUsed'] = JHTML::_('select.genericlist', $editorUsed, 'params[editorUsed]', 'class="inputbox" id="paramsavatarUsed"', 'value', 'text', $params->get('editorUsed', '0') );	
		//Get access levels
		$levels 	= $this->get('Accesslevels');
		$checked 	= ($params->get('authorDel')) ? ' checked="checked"' : '';
		$allowDel 	= '<input type="checkbox" style="vertical-align:top;margin-left:20px;"'.$checked.' name="params[authorDel]" value="1">'.JText::_('ALLOWED TO DELETE');
		$checked 	= ($params->get('authorPub')) ? ' checked="checked"' : '';
		$allowPub 	= '<input type="checkbox" style="vertical-align:top;margin-left:0px;"'.$checked.' name="params[authorPub]" value="1">'.JText::_('ALLOWED TO PUBLISH');	
		$lists['authorLevel'] = JHTML::_('select.genericlist',   $levels, 'params[authorLevel]', 'class="inputbox" id="paramsauthorLevel"', 'value', 'text', $params->get('authorLevel', '0'), '', 1 );
		
		$lists['authorDefaults'] = $allowPub.$allowDel;
		
		$lists['adminLevel'] = JHTML::_('select.genericlist',   $levels, 'params[adminLevel]', 'class="inputbox" id="paramsauthorLevel"', 'value', 'text', $params->get('adminLevel', '0'), '', 1 );
		
		//assign data to template
		$this->assignRef('lists'				, $lists);
		$this->assignRef('tabs'					, $tabs);
		$this->assignRef('params'				, $params);

		parent::display($tpl);
	}
	
	/**
	 * Creates the buttons view
	 **/
	function addIcon( $image , $view, $text)
	{
		$db    = & JFactory::getDBO();
		$query = 'SELECT value'
				. ' FROM #__jomprod_settings'
				. ' WHERE name = '.$db->Quote($view)
			;
		$db->setQuery($query);
		$last = $db->loadResult();
		$last = ($last)?JHTML::_('date', $last, '%b %d, %Y'):JText::_('NEVER');
	?>
		<div style="float:left'; ?>;">
			<div class="icon">
				<a href="#" onclick="javascript:doTask('<?php echo $view; ?>');return false;">
					<?php echo JHTML::_('image', 'administrator/components/com_brezza/assets/images/icon-48-'.$image.'.png' , NULL, NULL, $text ); ?>
					<span><?php echo $text; ?></span></a>
					<br><p style="font-size:10px;background:#ccc;float:left;margin:0 auto;text-align:center;width:100%;"><?php echo JText::_('LAST').': '.$last; ?></p>
			</div>
		</div>
	<?php
	}
}
