<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view' );

/**
 * @package Joomla
 * @subpackage Brezza
 * @since 1.0.2
 */
class LyftenBloggieViewUpdate extends JView
{
	/**
	 * @param	string template	Template file name
	 **/	 	
	function display( $tpl = null )
	{
		//initialise variables
		$document	= & JFactory::getDocument();
		$params 	=& JComponentHelper::getParams('com_lyftenbloggie');
		$task		= JRequest::getVar('task');

		// Lets get some HELP!!!!
		require_once (JPATH_COMPONENT.DS.'helper.php');
		
		//add stuff to document
		$document->addStyleSheet('components/com_lyftenbloggie/assets/css/style.css');	
		$document->addScript('components/com_lyftenbloggie/assets/js/help.js');	

		//Get data from the model
		$rows    	= BlogSystemFun::getUpdateData();
		$version	= & $this->get( 'LocalVersion' );
		$newVersion = ($version < $rows['version']);

		//assign data to template
		$this->assignRef('rows'				, $rows);
		$this->assignRef('params'			, $params);
		$this->assignRef('newVersion'		, $newVersion);
		
		if(!$task) {
			//create the toolbar		
			JToolBarHelper::title( JText::_( 'SETTINGS' ).': '.JText::_('UPDATES'), 'lbconfig' );
			if(isset($rows['auto_upgrade']))
				JToolBarHelper::makeDefault('update', 'Update');
			JToolBarHelper::divider();
			JToolBarHelper::deleteList();
			JToolBarHelper::spacer();
		}else{
			//create the toolbar
			JToolBarHelper::title( JText::_( 'SETTINGS' ).': '.JText::_('EDIT THEMES'), 'lbconfig' );

			// get params definitions
			$params = new JParameter( $rows->attribs, JPATH_COMPONENT_SITE.DS.'addons'.DS.'themes'.DS.$rows->name.DS.$rows->name.'.xml' );

			$lists['default'] = JHTML::_('select.booleanlist',  'is_default', 'class="inputbox"', $rows->is_default );
			
			//assign data to template
			$this->assignRef('lists'			, $lists);
			$this->assignRef('params'			, $params);

			JToolBarHelper::save();
			JToolBarHelper::apply();
			JToolBarHelper::divider();
			JToolBarHelper::cancel();
			JToolBarHelper::spacer();		
		}
		parent::display($tpl);
	}
}
