<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * Main Component Controller
 **/
class LyftenBloggieController extends JController
{

	/**
	 * Constructor
	**/
	function __construct()
	{
		parent::__construct();
	}

	/**
	 * Display the view
	**/
	function display()
	{
		$document 		=& JFactory::getDocument(); 
		$viewName 		= JRequest::getVar('view', 'lyftenbloggie');
		$viewLayout		= JRequest::getCmd( 'layout', 'default' );
		$views 			= array('comments', 'entry', 'lyftenbloggie', 'mydetails', 'myentries');
		$layouts 		= array('default', 'form');
		
		// validate view
		if (!in_array($viewName, $views)) $viewName = 'lyftenbloggie';
		if (!in_array($viewLayout, $layouts)) $viewLayout = 'default';

		$viewType 		= $document->getType(); 
		$view 			= &$this->getView($viewName, $viewType); 
		$model 			=&$this->getModel( $viewName, 'LyftenBloggieModel' );
		if (!in_array($viewName, $views)) $viewName = 'lyftenbloggie';

		if (!JError::isError( $model )) { 
			$view->setModel( $model, true ); 
		}

		$view->setLayout($viewLayout); 
		$view->display(); 
	}

	/**
	* Edits an item
	**/
	function feed()
	{
		global $mainframe;

		$type = JArrayHelper::getValue( $_REQUEST, 'type', 'rss' );

		//include the Feed helper
		require_once (JPATH_COMPONENT.DS.'helpers'.DS.'feed.php');
		
		$params 		= & $mainframe->getParams();
		$model 			= & $this->getModel('lyftenbloggie');
		$title 			= $params->get('title');
		$description 	= $params->get('mainBlogDesc');
		$rows 			= & $model->getFeed();
		$lg 			= &JFactory::getLanguage();
		$language 		= $lg->get('name');
		$feedURL 		= JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute($type));
		$rss 			= new LDBlogFeed($title, $description);

		if(is_callable( array( $rss, $type ))) {
			$rss->$type($rows);
		}else{
			$rss->rss($rows);
		}
		
		$mainframe->close();
	}
	
	/**
	* Get list of images
	* @since 1.0.3
	**/
	function viewImages()
	{
		// Get Author
		$user = EntriesHelper::getAuthor();

		//general access check
		if (!$user->permission) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE"));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}

		// Load the Media helper
		require_once( JPATH_COMPONENT.DS.'helpers'.DS.'media.php' );

		// Initialize variables
		$view 	= & $this->getView('media', 'html');
		
		// Set the path definitions
		define('COM_MEDIA_BASE',    JPath::clean(JPATH_ROOT.DS.'images'.DS.'lyftenbloggie'.DS.$user->user_id));
		define('COM_MEDIA_BASEURL', JURI::root(true).'/images/lyftenbloggie/'.$user->user_id);

		// Get/Create the model
		$model = & $this->getModel('media');
		
		// Push the model into the view (as default)
		$view->setModel($model, true);
		
		// Display the view
		$view->display();
	}

	/**
	* Upload File
	* @since 1.0.3
	**/
	function uploadfile()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		//initialize variables
		$user 				= EntriesHelper::getAuthor();
		$type 				= JRequest::getVar( 'type', 'image');
		$CKEditor 			= JRequest::getVar( 'CKEditor', 'text');
		$CKEditorFuncNum 	= JRequest::getVar( 'CKEditorFuncNum', '1');
		$langCode 			= JRequest::getVar( 'langCode', 'en');

		// validate type
		$types = array('image', 'flash');
		if (!in_array($type, $types)) $type = 'image';
			
		//general access check
		if (!$user->permission) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE"));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}

		// Load the Media helper
		require_once( JPATH_COMPONENT.DS.'helpers'.DS.'media.php' );

		// Set the path definitions
		define('COM_MEDIA_BASE',    JPath::clean(JPATH_ROOT.DS.'images'.DS.'lyftenbloggie'.DS.$user->user_id));
		define('COM_MEDIA_BASEURL', JURI::root(true).'/images/lyftenbloggie/'.$user->user_id);

		// Get/Create the model
		$model = & $this->getModel('media');
		
		// Upload file
		$msg = $model->upload(false);
		$msg = ($msg) ? '&msg='.urlencode($msg) : '';

		$link = JRoute::_('index.php?option=com_lyftenbloggie&task=viewImages&tmpl=component&CKEditor='.$CKEditor.'&CKEditorFuncNum='.$CKEditorFuncNum.'&langCode='.$langCode.'&type='.$type.$msg, false);
		$this->setRedirect($link);
	}

	/**
	* Upload File
	* @since 1.0.3
	**/
	function ajaxuploadfile()
	{
		// Check for request forgeries
		$token	= JUtility::getToken();
		if(!JRequest::getVar( $token )) {
			$session = JFactory::getSession();
			if(!$session->isNew()) {
				echo JText::_('SESSION_EXPIRED');
				$mainframe->close();
			} else {
				echo JText::_('Invalid Token');
				$mainframe->close();
			}
		}

		// Get Author
		$user = EntriesHelper::getAuthor();

		//general access check
		if (!$user->permission) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE"));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}

		// Load the Media helper
		require_once( JPATH_COMPONENT.DS.'helpers'.DS.'media.php' );

		// Set the path definitions
		define('COM_MEDIA_BASE',    JPath::clean(JPATH_ROOT.DS.'images'.DS.'lyftenbloggie'.DS.$user->user_id));
		define('COM_MEDIA_BASEURL', JURI::root(true).'/images/lyftenbloggie/'.$user->user_id);

		// Get/Create the model
		$model = & $this->getModel('media');
		
		// Upload file
		$model->upload();

		$mainframe->close();
	}

	/**
	 * Logic to save a author
	 **/
	function saveauthor()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
	
		//Sanitize
		$post = JRequest::get( 'post' );
		
		$user =& JFactory::getUser();

		$model = $this->getModel('mydetails');

		if ( $model->store($post) ) {
			$msg 	= JText::_( 'AUTHOR SAVED' );
			$cache 	= &JFactory::getCache('com_lyftenbloggie');
			$cache->clean();
		} else {
			$msg 	= JText::_( 'ERROR SAVING AUTHOR' );
		}

		$link = JRoute::_('index.php?option=com_lyftenbloggie&view=mydetails&id='.(int)$user->get('id'), false);
		$this->setRedirect($link, $msg);
	}

	/**
	* Edits an article
	* @since	1.0.0
	*/
	function edit()
	{
		// Create the view
		$view = & $this->getView('entry', 'html');

		// Get/Create the model
		$model = & $this->getModel('entry');

		// Push the model into the view (as default)
		$view->setModel($model, true);

		// Set the layout
		$view->setLayout('form');

		// Display the view
		$view->display();
	}

	/**
	* Saves the item
	**/
	function save()
	{
		global $mainframe;

		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize variables
		$db			= & JFactory::getDBO();
		$user		= EntriesHelper::getAuthor();

		//get model
		$model = $this->getModel('entry');

		//get data from request
		$post = JRequest::get('post');
		
		// Must be logged in
		if ($user->user_id == 'no') {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("PLEASE LOGIN"));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}

		//perform access checks
		$isNew = ((int) $post['id'] < 1);

		//Access check
		if (!$user->permission) {
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE"));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}

		if (!$model->store($post)) {
			$msg = JText::_( 'ERROR STORING ITEM' );
			JError::raiseError( 500, $model->getError() );
		}

		$model->checkin();

		if ($isNew) {

			$entryID = (int) $model->get('id');
			
			//Get category for email
			$query = 'SELECT DISTINCT c.id, c.title,'
			. ' FROM #__bloggies_entries AS e'
			. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
			. ' WHERE e.id = '.$entryID
			;
			$db->setQuery( $query );
			$category = $db->loadResult();
			$category = ($category)?$category:JText::_('UNCATEGORIZED');
			
			//Get tags for email
			$query = 'SELECT DISTINCT t.name'
			. ' FROM #__bloggies_entries AS c'
			. ' LEFT JOIN #__bloggies_relations AS rel ON rel.entry = c.id'
			. ' LEFT JOIN #__bloggies_tags AS t ON t.id = rel.tag'
			. ' WHERE rel.entry = '.$entryID
			;

			$db->setQuery( $query );
			$tags = $db->loadObjectList();
			//loop through the tags to create a string
			$n = count($tags);
			$i = 0;
			$tagstring = '';
			foreach ($tags as $tag) {
				$tagstring .= $tag->name;
				$i++;
				if ($i != $n) {
					$tagstring .= ', ';
				}
			}

			//get list of admins who receive system mails
			$query = 'SELECT id, email, name' .
			' FROM #__users' .
			' WHERE sendEmail = 1';
			$db->setQuery($query);
			if (!$db->query()) {
				JError::raiseError( 500, $db->stderr(true));
				return;
			}
			$adminRows = $db->loadObjectList();

			require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_messages'.DS.'tables'.DS.'message.php');

			// send email notification to admins
			foreach ($adminRows as $adminRow) {

				//Send a message to the admins personal message boxes
				$message = new TableMessage($db);
				$message->send($user->user_id, $adminRow->id, JText::_('NEW ENTRY'), JText::sprintf('MESS NEW ENTRY DESC', $user->username, $post['title'], $category, $tagstring));
			}

		} else {
			// If the item isn't new, then we need to clean the cache so that our changes appear realtime
			$cache = &JFactory::getCache('com_lyftenbloggie');
			$cache->clean();
		}

		//Check to see if the user is allowed to post
		if ($user->allowpub)
		{
			$msg = JText::_( 'ENTRY SAVED' );
		}
		else
		{
			$msg = JText::_('BLOG ENTRY REVIEW');
		}

		//Return to MyEntries if started there
		if($post['inmyent']){
			$link = JRoute::_(JURI::base().'index.php?option=com_lyftenbloggie&view=myentries', false);
		}else{
			$link = JRoute::_(JURI::base().'index.php?option=com_lyftenbloggie&view=entry'.$model->get('archive').'&id='.$model->get('slug'), false);
		}

		$this->setRedirect($link, $msg);
	}
	
	/**
	 * Logic to delete entries
	 **/
	function remove()
	{
		global $mainframe;

		// Check for request forgeries
		$token	= JUtility::getToken();
		if(!JRequest::getVar( $token )) {
			$session = JFactory::getSession();
			if($session->isNew()) {
				//Redirect to login screen
				$return = JRoute::_('index.php');
				$mainframe->redirect($return, JText::_('SESSION_EXPIRED'));
				$mainframe->close();
			} else {
				jexit( 'Invalid Token' );
			}
		}
	
		$id		= JArrayHelper::getValue( $_REQUEST, 'id', 0 );
		$msg	= '';

		if (!$id) {
			$msg = JText::_( 'SELECT A BLOG ENTRY TO DELETE' );
		}
		
		if(!$msg)
		{
			$model = $this->getModel('entry');

			$action = $model->delete($id);
			
			switch ($action['task'])
			{
				case 'error' :
					$msg = $action['msg'];
					break;

				case 'change' :
					$msg = $action['msg'];
					break;
					
				case 'remove' :
					$msg 	= JText::_('ENTRY DELETED');
					$cache 	= &JFactory::getCache('com_lyftenbloggie');
					$cache->clean();
					break;
					
				default :
					$msg = JText::_('AN ERROR ACCURED');
					break;
			}			
		}

		$link = JRoute::_('index.php?option=com_lyftenbloggie&view=myentries', false);
		$this->setRedirect($link, $msg);
	}
	
	/**
	* Cancels an edit item operation
	**/
	function cancel()
	{
		// Initialize some variables
		$user	= & JFactory::getUser();
		$db 	= & JFactory::getDBO();
		
		// Get an item table object and bind post variabes to it
		$item = & JTable::getInstance('entries', 'Table');
		$item->bind(JRequest::get('post'));

		//Check to see if the user is allowed to post
		$query = 'SELECT user_id'
				.' FROM #__bloggies_authors'
				.' WHERE user_id = '.$user->get('id')
				.' AND published = 1';
		$db->setQuery($query);
		
		// todo: add task checks
		if ($db->loadResult()) {
			$item->checkin();
		}

		// If the task was edit or cancel, we go back to the item
		$referer = JRequest::getString('referer', JURI::base(), 'post');
		$this->setRedirect($referer);
	}

	/**
	*  Handle Trackbacks and Pingbacks sent to LyftenBloggie
	**/
	function trackback()
	{
		global $mainframe;
		
		// trackback is done by a POST
		$posts = JRequest::get('post');
		if (empty($posts)) {
			$component =& JComponentHelper::getComponent('com_lyftenbloggie');
			$menus	= &JApplication::getMenu('site', array());
			$items	= $menus->getItems('componentid', $component->id);
			$this->setRedirect('index.php?option=com_lyftenbloggie&Itemid='.$items[0]->id);
			return;
		}

		//Get entry ID
		if ( !isset( $_GET['tb_id'] )) {
			$tb_id	= explode('/', $_SERVER['REQUEST_URI']);
			$tb_id	= intval( $tb_id[ count($tb_id) - 1 ] );
		}
		if (!$tb_id) {
			$a = explode('&', $_SERVER['REQUEST_URI']);
			$i = 0;
			while ($i < count($a)) {
			    $b = split('=', $a[$i]);
					if (strtolower($b[0]) == 'id')
						$tb_id = $b[1];
			    $i++;
			}
		}
		
		if ( !intval( $tb_id ) )
			$this->_response(1, 'I really need an ID for this to work.');
			
		$tb_url  = JArrayHelper::getValue( $_REQUEST, 'url', '' );
		$charset = JArrayHelper::getValue( $_REQUEST, 'charset', '' );

		// These three are stripslashed here so that they can be properly escaped after mb_convert_encoding()
		$title     = stripslashes(JArrayHelper::getValue( $_REQUEST, 'title', '' ));
		$excerpt   = stripslashes(JArrayHelper::getValue( $_POST, 'excerpt', '' ));
		$blog_name = stripslashes(JArrayHelper::getValue( $_REQUEST, 'blog_name', '' ));

		if ($charset)
			$charset = strtoupper( trim($charset) );
		else
			$charset = 'ASCII, UTF-8, ISO-8859-1, JIS, EUC-JP, SJIS';

		// No valid uses for UTF-7
		if ( false !== strpos($charset, 'UTF-7') )
			die;

		// For international trackbacks
		if ( function_exists('mb_convert_encoding') ) {
			$title     	= mb_convert_encoding($title, 'UTF-8', $charset);
			$excerpt   	= mb_convert_encoding($excerpt, 'UTF-8', $charset);
			$blog_name 	= mb_convert_encoding($blog_name, 'UTF-8', $charset);
			$tb_url 	= mb_convert_encoding($tb_url, 'UTF-8', $charset);
		}

		//initialize variables
		$db 		= & JFactory::getDBO(); 
		$params 	= & $mainframe->getParams('com_lyftenbloggie');	
		
		// Now that mb_convert_encoding() has been given a swing, we need to escape these three
		$title     	= $db->getEscaped($title, true );
		$excerpt   	= $db->getEscaped($excerpt, true );
		$blog_name 	= $db->getEscaped($blog_name, true );
		$tb_url 	= $db->getEscaped($tb_url, true );

		if (empty($title) && empty($tb_url) && empty($blog_name)) {
			$this->setRedirect(JRoute::_('index.php?view=entry&id='. $tb_id, false), $msg );
			return;
		}

		if ( !empty($tb_url) && !empty($title) ) {
			header('Content-Type: text/xml; charset=utf-8' );

			if ( !$params->get('allowTrackbacks') )
				$this->_response(1, 'Sorry, trackbacks are closed for this item.');

			$title =  $this->_makeExcerpt( $title, 250 ).'...';
			$excerpt = $this->_makeExcerpt( $excerpt, 252 ).'...';
			$datenow =& JFactory::getDate();

			$entry_id 		= (int) $tb_id;
			$author 		= $blog_name;
			$author_email 	= '';
			$author_url 	= $tb_url;
			$content 		= "<strong>$title</strong>\n\n$excerpt";
			$type 			= '2';
			$date			= $datenow->toMySQL();

			//Get make use this isn't a duplicate
			$query = 'SELECT COUNT(id)' .
			' FROM #__bloggies_comments' .
			' WHERE author='.$db->Quote($author, false ) .
			' AND author_url='.$db->Quote($author_url, false )
			;
			$db->setQuery($query);
			if (!$db->query()) {
				$this->_response(1, $db->getErrorMsg());
			}
			$total = $db->loadResult();

			if ( $total )
				$this->_response(1, 'We already have a ping from that URL for this post.');

			$query = "INSERT INTO `#__bloggies_comments` SET `entry_id`='$entry_id',`author`='$author',`author_email`='$author_email',`author_url`='$author_url',`content`='$content',`type`='$type',`date`='$date'";
			$db->setQuery($query);
			if (!$db->query()) {
				$this->_response(1, $db->getErrorMsg());
			}
			$this->_response(0);
		}
	}
	
	/**
	 * Method to respond with error or success XML message
	 **/
	function _response($error = 0, $error_message = '')
	{
		global $mainframe;
		header('Content-Type: text/xml; charset=utf-8' );
		if ($error) {
			echo '<?xml version="1.0" encoding="utf-8"?'.">\n";
			echo "<response>\n";
			echo "<error>1</error>\n";
			echo "<message>$error_message</message>\n";
			echo "</response>";
			die();
		} else {
			echo '<?xml version="1.0" encoding="utf-8"?'.">\n";
			echo "<response>\n";
			echo "<error>0</error>\n";
			echo "</response>";
		}
		
		$mainframe->close();
	}
	
	/**
	 * Safely extracts not more than the first $count characters from html string
	 **/
	function _makeExcerpt( $str, $count )
	{
		$str = strip_tags( $str );
		$str = mb_strcut( $str, 0, $count );
		// remove part of an entity at the end
		$str = preg_replace( '/&[^;\s]{0,6}$/', '', $str );
		return $str;
	}
	
	/**
	 * Method to save report
	 **/
	function reportsubmit()
	{
		global $mainframe;
		
		//include jQuery Class
		require_once (JPATH_COMPONENT.DS.'libraries'.DS.'jQuery.php');

		//initialize variables
		$db 			= & JFactory::getDBO(); 
		$user 			= &JFactory::getUser();
		$comment_id 	= (int)JArrayHelper::getValue( $_REQUEST, 'reportid', 0 );	
		$reason			= JArrayHelper::getValue( $_REQUEST, 'reportReason', 0 );	
		$desc 			= JArrayHelper::getValue( $_REQUEST, 'reportDescription', 0 );	
		$datenow 		= & JFactory::getDate();
		$date			= $datenow->toMySQL();
		$jQuery			= new jQuery();
		$msg 			= '';
		$error			= '';

		$error .= (!$comment_id)?'<li>'.JText::_('AN ERROR HAS OCCURRED').'</li>':'';
		$error .= (!$reason)?'<li>'.JText::_('PLEASE SELECT A REASON').'</li>':'';
		$error .= (!$desc)?'<li>'.JText::_('PLEASE ENTER SOME SMALL DETAILS').'</li>':'';
		
		if(!$error) {

			if($user->id) {
				$query = "INSERT INTO `#__bloggies_reports` SET `user_id`='$user->id',`comment_id`='$comment_id',`reason`='$reason',`date`='$date'";
				$db->setQuery($query);

				if (!$db->query()) {
					$msg = 'An Error Occured!';
				}else{
					$msg = 'Report Sent!';
				}
			}else{
				$msg = 'Report Not Sent!<br>You need to be logged in';
			}
			$jQuery->manipulate('html', '#popbox .resultmsg', $msg);
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');
			
			$jQuery->effect('slideUp', '#popbox .box-details');
			$jQuery->effect('slideUp', '.footer');
			$jQuery->effect('fadeIn', '#popbox .sent-footer', array('speed' => 'slow'));
			$jQuery->effect('fadeIn', '#popbox .sent-details', array('speed' => 'slow'));

			$jQuery->addAction('jQuery("#facebox_overlay").click(function () {jQuery(document).trigger(\'close.facebox\');});');
		}else{
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');
			$jQuery->manipulate('html', '#facebox .submit-result', '<ul style="color:#ff0000;">'.$error.'</ul>');
			$jQuery->show('#facebox .submit-result');
		}
		
		$jQuery->getResponse();
		
		$mainframe->close();
	}
	
	/**
	 * Method to show report form
	 **/
	function report()
	{
		global $mainframe;
		
		//initialize variables
		$user 		= &JFactory::getUser();		
		$id 		= JArrayHelper::getValue( $_REQUEST, 'id', 0 );				
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		
		if($user->guest) {
			if($params->get('loginform')) {
				$this->_LoginForm('report', $id);
			}else{
				$this->_LoginMessage();
			}
		}
		
		?>
		<div id="popbox" class="popbox">
		<h2 class="dialog_title"><span><?php echo JText::_('REPORT AS INAPPROPRIATE'); ?></span></h2>

		<form id="form" onsubmit="formAjax();return false;">
		<input type="hidden" name="reportid" value="<?php echo $id; ?>"/>
		<input type="hidden" name="task" value="reportsubmit"/>
			<fieldset class="box-details">
			<ul class="settings">
				<li>
					<p><label for="report-reason" class="required"><?php echo JText::_('REASON'); ?>:</label></p>
					<select id="report-reason" name="reportReason" size="1" onchange="abuseReporter.validateReason();">
					<option value="" selected="selected"><?php echo JText::_('CHOOSE REASON'); ?></option>
					<option value="offensive"><?php echo JText::_('COMMENT IS OFFENSIVE'); ?></option>
					<option value="off-topic"><?php echo JText::_('COMMENT IS OFF-TOPIC'); ?></option>
					<option value="spam"><?php echo JText::_('COMMENT IS SPAM'); ?></option>
					<option value="not-listed"><?php echo JText::_('MY REASON IS NOT LISTED HERE'); ?></option>
					</select>
				</li>
				<li>
					<p><label for="report-desc" class="required"><?php echo JText::_('DETAILS'); ?>:</label></p>
					<textarea id="report-desc" name="reportDescription" cols="30" rows="4"></textarea>
				</li>
			</ul>
			</fieldset>
			<fieldset class="sent-details" style="display:none;">
				<h2 class="resultmsg"><?php echo JText::_('REPORT SENT'); ?></h2>
			</fieldset>
			<div class="footer">
				<div class="submit-result" style="display:none;"></div>
				<div class="boxctrls">
					<a href="javascript:void(null);" onclick="javascript:formAjax();return false;" class="rbutton" id="reportsubmit"><?php echo JText::_('SUBMIT'); ?></a> <a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_('CANCEL'); ?></a>
				</div>
			</div>
			<div class="sent-footer" style="display:none;">
				<a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_('OKAY'); ?></a>
			</div>
			<div class="example" id="testform"></div>
		</form>
		</div>
		<?php

		$mainframe->close();
	}

	/**
	 * Method to save comment
	 **/
	function postComment()
	{
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );

		// Initialize variables
		$db			= & JFactory::getDBO();
		$msg 		= JText::_( 'COMMENT SAVED' );
		$return		= '';

		//get model
		$model = $this->getModel('comments');

		//get data from request
		$post = JRequest::get('post');
		
		if (!$model->store($post) ) {
			$msg = '';
			$return = $model->_return;
		}


		if (JRequest::getVar('view') == 'comments') {
			$link = JRoute::_('index.php?option=com_lyftenbloggie&view=comments'.$model->get('archive').'&id='.$model->get('slug').$return, false);
		}else{
			$link = JRoute::_('index.php?option=com_lyftenbloggie&view=entry'.$model->get('archive').'&id='.$model->get('slug').$return, false);
		}
		$this->setRedirect($link, $msg);
	}

	/**
	 * Method to save comment
	 **/
	function postCommentAjax()
	{
		global $mainframe;
	
		//include jQuery Class
		require_once (JPATH_COMPONENT.DS.'libraries'.DS.'jQuery.php');

		//initialize variables
		$db 			= & JFactory::getDBO();
		$author			= EntriesHelper::getAuthor();
		$params 		= & $mainframe->getParams('com_lyftenbloggie');
		$userid 		= (int)JArrayHelper::getValue( $_REQUEST, 'userid', 0 );	
		$entryid 		= (int)JArrayHelper::getValue( $_REQUEST, 'entryid', 0 );	
		$comment 		= JArrayHelper::getValue( $_REQUEST, 'comment', 0 );	
		$homepage 		= JArrayHelper::getValue( $_REQUEST, 'homepage', 0 );	
		$datenow 		= & JFactory::getDate();
		$date			= $datenow->toMySQL();
		$msg 			= '';
		$error			= '';
		$jQuery			= new jQuery();
			
		// Handle Captcha
		if($params->get('enableCaptcha')) {
			$captcha 	= EntriesHelper::checkCaptcha();
			$error 		.= (!$captcha)?'<li>'.JText::_('CAPTCHA CODE IS INCORRECT').'</li>':'';
		}
		
		$error .= (!$entryid)?'<li>'.JText::_('AN ERROR HAS OCCURRED').'</li>':'';
		$error .= (!$comment)?'<li>'.JText::_('PLEASE ENTER A COMMENT').'</li>':'';

		if(!$error) {
			//filter comment if enabled
			if($params->get( 'enableBadWord' )) {
				$comment = EntriesHelper::checkCommentPost($comment, $params);
			}

			$query = "INSERT INTO `#__bloggies_comments` SET `entry_id`='$entryid',`user_id`='$userid',`author_email`='',`author_url`='$homepage',`content`='$comment',`type`='1',`date`='$date'";
			$db->setQuery($query);
			if (!$db->query()) {
				$msg 	=  $db->getErrorMsg();
				$id 	= 0;
			}else{
				$msg 	= JText::_('COMMENT ADDED');
				$id 	= $db->insertId();
			}
			echo $db->getErrorMsg();
			//If there was an error do not show new comment right away
			if ($id)
			{
				$theme 		= new TemplateEngine();
				$homepage	= ($homepage)?'<li><a href="'.stripslashes($homepage).'" target="_blank">'.JText::_('HOMEPAGE').'</a></li>':'';
				$avatar 	= ($author->avatar)?$author->avatar:COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';
	
				$addcom = "<li id=\"comment-".$id."\" class=\"singleComment\">	 
			<div class=\"singleComment-header\"> 		
				<table> 			
					<tbody>
						<tr> 				
							<td class=\"singleComment-poster\"> 					
								<span class=\"commentPoster-avatar\">
									<img src=\"".$avatar."\" alt=\"\" class=\"avatar\">
								</span>";				
								if($homepage) {
								$addcom .= "<ul class=\"commentPoster-links\">".$homepage."</ul>";
								}
							$addcom .= "</td> 				
							<td class=\"singleComment-header-meta\"> 			 
								<span class=\"entryComment-header-author\">".$author->username."</span>
								<span class=\"entryComment-header-time\">".JHTML::_('date', $date, '%b %d, %Y')."</span> 
							</td> 		
							<td class=\"singleComment-header-actions\">";
							
							if(!$params->get('commentStyle', 0)) {
								if($params->get('allowReport')) {
								$addcom .= "<a href=\"report\" class=\"report-comment\"></a>";
								}
								$addcom .= "<a href=\"ratedwn\" class=\"ratedwn-comment\"></a>
								<a href=\"rateup\" class=\"rateup-comment\"></a>";
								}else{
								$addcom .= "<span id=\"rate-result-".$id."\" class=\"rateMsg\"></span>";
								if($params->get('allowReport')) {
								$addcom .= "<a href=\"#\" onclick=\"jQuery.facebox({ ajax: '".JRoute::_('index.php?&option=com_lyftenbloggie&task=report&id='.$id)."' });return false;\" class=\"report-comment\" title=\"".JText::_('REPORT AS INAPPROPRIATE')."\"><img src=\"".COM_LYFTENBLOGGIE_ASSETS."/images/blank.gif\"></a>";
								}
								$addcom .= "<a href=\"#\" onclick=\"javascript:jQuery.php(url,{'option':'com_lyftenbloggie','task':'rateAjax','rate':'0','id':'".$id."'});return false;\" id=\"rate-dwn-".$id."\" class=\"ratedwn-comment\" title=\"".JText::_('RATE DOWN')."\"><img src=\"".COM_LYFTENBLOGGIE_ASSETS."/images/blank.gif\"></a>
								<a href=\"#\" onclick=\"javascript:jQuery.php(url,{'option':'com_lyftenbloggie','task':'rateAjax','rate':'1','id':'".$id."'});return false;\" id=\"rate-up-".$id."\" class=\"rateup-comment\" title=\"".JText::_('RATE UP')."\"><img src=\"".COM_LYFTENBLOGGIE_ASSETS."/images/blank.gif\"></a>";
								}
							$addcom .= "</td> 		
						</tr> 		
					</tbody>
				</table> 		
			</div>
			<img src=\"".$theme->themeURL."/images/tip.gif\" class=\"comment-tip\">

			<div class=\"singleComment-body\">
				<div class=\"singleComment-message\">
					".$comment."
				</div>	 
			</div> 
		</li>";		
				$jQuery->manipulate('prepend', '#entryContainer', $addcom);
			}
			$jQuery->manipulate('html', '#popbox .resultmsg', $msg);
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');
			
			$jQuery->effect('slideUp', '#popbox .box-details');
			$jQuery->effect('slideUp', '.footer');
			$jQuery->effect('fadeIn', '#popbox .sent-footer', array('speed' => 'slow'));
			$jQuery->effect('fadeIn', '#popbox .sent-details', array('speed' => 'slow'));

			$jQuery->addAction('jQuery("#facebox_overlay").click(function () {jQuery(document).trigger(\'close.facebox\');});');
		}else{
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');
			$jQuery->manipulate('html', '#facebox .submit-result', '<ul style="color:#ff0000;">'.$error.'</ul>');
			$jQuery->show('#facebox .submit-result');
		}	
		$jQuery->getResponse();
		
		$mainframe->close();
	}
	
	/**
	 * Method to show Comment form
	 **/
	function comment()
	{
		global $mainframe;
		
		//initialize variables
		$user 		= &JFactory::getUser();		
		$id 		= JArrayHelper::getValue( $_REQUEST, 'id', JArrayHelper::getValue( $_REQUEST, 'cid', 0 ) );				
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
	
		if($user->guest) {
			if($params->get('loginform')) {
				$this->_LoginForm('comment', $id);
			}else{
				$this->_LoginMessage();
			}
		}

		// Handle Captcha
		if($params->get('enableCaptcha')) {
			$captcha 	= EntriesHelper::getCaptcha();
		}
		
		?>
		<div id="popbox" class="popbox">
		<h2 class="dialog_title"><span><?php echo JText::_( 'POST A COMMNET' ); ?></span></h2>
		<form id="form" onsubmit="formAjax();return false;">
		<input type="hidden" name="entryid" value="<?php echo $id; ?>"/>
		<input type="hidden" name="userid" value="<?php echo $user->get('id'); ?>"/>
		<input type="hidden" name="task" value="postCommentAjax"/>
		<?php echo JHTML::_( 'form.token' ); ?>
			<fieldset class="box-details">
			<ul class="settings">
				<li>
					<p><label><?php echo JText::_( 'USERNAME' ); ?>:</label> <input name="username" id="username" disabled="true" value="<?php echo $user->get('username'); ?>" class="inputbox" type="text"></p>
				</li>
				<li>
					<p><label><?php echo JText::_( 'HOMEPAGE' ); ?>:</label> <input name="homepage" id="homepage" value="" class="inputbox" type="text"></p>
				</li>
				<li style="margin-top:5px;">
					<p><label for="post-comment" class="required"><?php echo JText::_( 'COMMENT' ); ?>: <span class="asterisk">*</span></label></p>
					<textarea id="post-comment" name="comment" cols="37" rows="4"></textarea>
				</li>
		<?php if(isset($captcha)) { ?>
				<SCRIPT><!--
				function JGetElementById( s ) {
					var o = (document.getElementById ? document.getElementById(s)
					: document.all[s]);
					return ((o == null) ? false : o);
				}
				function reloadCaptcha() {
					var ocap = JGetElementById( 'captchaimage');
					if (ocap) {
						var today = new Date(); 
						ocap.setAttribute( 'src', '<?php echo $captcha['url_imagecore']; ?>' + today.getTime() + '<?php echo str_replace( '&amp;', '&',  $captcha['image_params'] ); ?>' );
					}
					var ocapc = JGetElementById( 'captchacode');
					ocapc.value="";
					ocapc.focus();
				}
				--></SCRIPT>
				<li style="margin-top:5px;">
					<input type="hidden" name="captchasessionid" value="<?php echo $captcha['captchasessionid']; ?>" />
					<p><label for="post-captcha" class="required"><?php echo JText::_( 'CAPTCHA' ); ?>: <span class="asterisk">*</span> 
					<input id="captchacode1" type="text" name="captchacode" class="captchainputbox required" size="10" value="" style="width:90px;"/>
					<img id="captchaimage" src="<?php echo $captcha['url_image']; ?>1" title="<?php echo JText::_( 'CAPTCHACODE_TEXT' ) ?>" alt="<?php echo JText::_( 'CAPTCHACODE_TEXT' ) ?>" onclick="reloadCaptcha()" style="cursor: pointer;"></label></p>
				</li>
			<?php } ?>
					</ul>
			</fieldset>
			<fieldset class="sent-details" style="display:none;">
				<h2 class="resultmsg"><?php echo JText::_( 'COMMENT POSTED' ); ?></h2>
			</fieldset>
			<div class="footer">
				<div class="submit-result" style="display:none;"></div>
				<div class="boxctrls">
					<a href="javascript:void(null);" onclick="javascript:formAjax();return false;" class="rbutton" id="reportsubmit"><?php echo JText::_( 'POST' ); ?></a> <a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_( 'CANCEL' ); ?></a>
				</div>
			</div>
			<div class="sent-footer" style="display:none;">
				<a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_( 'OK' ); ?></a>
			</div>
			<div class="example" id="testform"></div>
		</form>
		</div>
		<?php
		$mainframe->close();
	}
	
	/**
	 * Method to show Login Form
	 **/
	function _LoginMessage()
	{
		global $mainframe;

		$usersConfig = &JComponentHelper::getParams( 'com_users' );
		?>
		<div id="popbox" class="popbox">
		<h2 class="dialog_title"><span><?php echo JText::_('PLEASE LOGIN'); ?></span></h2>
			<fieldset class="sent-details">
				<h2 class="resultmsg"><?php echo JText::_('PLEASE SIGN REGISTER.'); ?>
				<?php
				if ($usersConfig->get('allowUserRegistration')) : ?>
					<br><a href="<?php echo JRoute::_( 'index.php?option=com_user&task=register' ); ?>"><?php echo JText::_('REGISTER FOR A NEW ACCOUNT'); ?></a>
				<?php endif; ?>				
				</h2>
			</fieldset>
			<div class="sent-footer">
				<a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_( 'OK' ); ?></a>
			</div>
		</div>
		<?php		
		$mainframe->close();
	}
	
	/**
	 * Method to show Login Form
	 **/
	function _LoginForm($action=0, $id=0)
	{
		global $mainframe;
		
		$params 		= & $mainframe->getParams('com_lyftenbloggie');
		$usersConfig 	= &JComponentHelper::getParams( 'com_users' );
		
		if(JPluginHelper::isEnabled('authentication', 'openid')) :
				$lang->load( 'plg_authentication_openid', JPATH_ADMINISTRATOR );
				$langScript = 	'var JLanguage = {};'.
								' JLanguage.WHAT_IS_OPENID = \''.JText::_( 'WHAT_IS_OPENID' ).'\';'.
								' JLanguage.LOGIN_WITH_OPENID = \''.JText::_( 'LOGIN_WITH_OPENID' ).'\';'.
								' JLanguage.NORMAL_LOGIN = \''.JText::_( 'NORMAL_LOGIN' ).'\';'.
								' var modlogin = 1;';
				$document = &JFactory::getDocument();
				$document->addScriptDeclaration( $langScript );
				JHTML::_('script', 'openid.js');		
		endif; ?>
		<div id="popbox" class="popbox">
		<h2 class="dialog_title"><span><?php echo JText::_('PLEASE LOGIN'); ?></span></h2>
		<form id="form" onsubmit="formAjax();return false;">		
		<input type="hidden" name="task" value="dologin"/>
		<input type="hidden" name="todo" value="<?php echo $action; ?>" />
		<input type="hidden" name="id" value="<?php echo $id; ?>" />
		<?php echo JHTML::_( 'form.token' ); ?>
			<fieldset class="box-details">
			<ul class="settings">
				<li>
					<p><label for="modlgn_username"><?php echo JText::_('USERNAME') ?></label><input id="modlgn_username" type="text" name="username" class="inputbox" alt="username" size="18" /></p>
				</li>
				<li>
					<p><label for="modlgn_passwd"><?php echo JText::_('PASSWORD') ?></label><input id="modlgn_passwd" type="password" name="passwd" class="inputbox" size="18" alt="password" /></p>
				</li>
				<li style="margin-top:5px;">
					<div style="float:right;font-size: 10px;padding-right:30px;" class="login-result"></div>
					<p><label for="modlgn_remember"><?php echo JText::_('REMEMBER ME') ?></label> <input id="modlgn_remember" style="width:10px;" type="checkbox" name="remember" class="inputbox" value="yes" alt="Remember Me" /></p>
				</li>
			</ul>
			</fieldset>
			<fieldset class="sent-details" style="display:none;">
				<h2 class="resultmsg"><?php echo JText::_('COMMENT POSTED'); ?></h2>
			</fieldset>
			<div class="footer">
				<div class="submit-result">
				<ul>
					<li>
						<a href="<?php echo JRoute::_( 'index.php?option=com_user&view=reset' ); ?>">
						<?php echo JText::_('FORGOT YOUR PASSWORD'); ?></a>
					</li>
					<li>
						<a href="<?php echo JRoute::_( 'index.php?option=com_user&view=remind' ); ?>">
						<?php echo JText::_('FORGOT YOUR USERNAME'); ?></a>
					</li>
				</ul>				
				</div>
				<div class="boxctrls">
					<?php
					if ($usersConfig->get('allowUserRegistration')) : ?>
					<a href="<?php echo JRoute::_( 'index.php?option=com_user&task=register' ); ?>" class="rbutton"><?php echo JText::_('REGISTER'); ?></a> 
					<?php endif; ?>					
					<a href="javascript:void(null);" onclick="javascript:formAjax();return false;" class="rbutton"><?php echo JText::_('LOGIN'); ?></a> <a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_('CANCEL'); ?></a>
				</div>
			</div>
			<div class="sent-footer" style="display:none;">
				<a href="javascript:void(null);" class="rbutton" onclick="javascript:jQuery.facebox.close();"><?php echo JText::_('OK'); ?></a>
			</div>
		</form>
		</div>
		<?php
		
		$mainframe->close();
	}
	
	function dologin()
	{
		// Check for request forgeries
		JRequest::checkToken('request') or jexit( 'Invalid Token' );
		
		global $mainframe;
		
		//include jQuery Class
		require_once (JPATH_COMPONENT.DS.'libraries'.DS.'jQuery.php');

		// Initialize variables
		$action 		= JArrayHelper::getValue( $_REQUEST, 'todo', 0 );
		$id 			= JArrayHelper::getValue( $_REQUEST, 'id', 0 );
		$jQuery			= new jQuery();
		$options 		= array();
		$credentials 	= array();
		
		$options['remember'] 		= JRequest::getBool('remember', false);
		$credentials['username'] 	= JRequest::getVar('username', '', 'method', 'username');
		$credentials['password'] 	= JRequest::getString('passwd', '', 'post', JREQUEST_ALLOWRAW);

		//preform the login action
		$error = $mainframe->login($credentials, $options);

		if(!JError::isError($error))
		{
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');

			if($action && $id) {
				$link = JURI::base().'index.php?option=com_lyftenbloggie&task='.$action.'&id='.$id;
				$jQuery->addAction('jQuery.facebox({ ajax: \''.$link.'\' })');
			}else{
				$jQuery->manipulate('html', '#popbox .resultmsg', JText::_('LOGGED IN'));
				$jQuery->effect('slideUp', '#popbox .box-details');
				$jQuery->effect('slideUp', '.footer');
				$jQuery->effect('fadeIn', '#popbox .sent-footer', array('speed' => 'slow'));
				$jQuery->effect('fadeIn', '#popbox .sent-details', array('speed' => 'slow'));
				$jQuery->addAction('jQuery("#facebox_overlay").click(function () {jQuery(document).trigger(\'close.facebox\');});');
			}
		}else{
			$jQuery->hide('#boxoverlay');
			$jQuery->hide('#facebox .loader');
			$jQuery->manipulate('html', '#facebox .submit-result', '<ul style="color:#ff0000;">'.$error->message.'</ul>');
			$jQuery->show('#facebox .submit-result');
		}
		
		$jQuery->getResponse();
		
		$mainframe->close();
	}
	
	/**
	 *  Method of the voting
	**/
	function rateAjax()
	{
		global $mainframe;

		//include jQuery Class
		require_once (JPATH_COMPONENT.DS.'libraries'.DS.'jQuery.php');

		// Initialize variables
		$id 		= JRequest::getInt('id', 0);
		$rating		= JRequest::getInt('rate', 0);
		$session 	=& JFactory::getSession();
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$user 		= &JFactory::getUser();		
		$jQuery		= new jQuery();

		if(!$user->guest) {
			
			$cookieName	= JUtility::getHash( $mainframe->getName() . 'lyftenbloggierating' . $id );
			$rated = JRequest::getVar( $cookieName, '0', 'COOKIE', 'INT');

			$ratingcheck = false;
			if ($session->has('rating', 'lyftenbloggie')) {
				$ratingcheck = $session->get('rating', 0,'lyftenbloggie');
				$ratingcheck = in_array($id, $ratingcheck);
			}

			if ( $rated || $ratingcheck )	{
				$msg = JText::_('ALREADY RATED');
			} else {
				setcookie( $cookieName, '1', time()+1*24*60*60*60 );

				$stamp = array();
				$stamp[] = $id;
				$session->set('rating', $stamp, 'lyftenbloggie');

				$model 	= $this->getModel('comments');
				if ($model->storeRating($id, $rating)) {
					$msg = JText::_( 'RATED' );
				} else {
					$msg = JText::_( 'RATING FAILED' );
				}
			}
			
			$cache = &JFactory::getCache('com_lyftenbloggie');
			$cache->clean();
		} else {
			$msg = JText::_('YOU MUST LOGIN');
		}

		//Send Result thru jQuery
		$jQuery->hide('#rate-up-'.$id);
		$jQuery->hide('#rate-dwn-'.$id);
		$jQuery->manipulate('html', '#rate-result-'.$id, $msg);
		$jQuery->addAction('jQuery(\'#rate-result-'.$id.'\').fadeIn("slow");');
		$jQuery->getResponse();
		
		$mainframe->close();
	}
	
	/**
	 *  Method of the voting
	**/
	function rate()
	{
		global $mainframe;

		$id 		= JRequest::getInt('id', 0);
		$rating		= JRequest::getInt('rate', 0);
		$entry		= JRequest::getInt('entry', 0);
		$limitstart	= JRequest::getInt('limitstart');
		$session 	=& JFactory::getSession();
		$user 		= &JFactory::getUser();
		$year		= JRequest::getInt('year', 0);
		$month		= JRequest::getInt('month', 0);
		$day		= JRequest::getInt('day', 0);
		$category	= JRequest::getInt('category', 0);

		//Make a Sluggie-Pooh
		if($year && $day)
		{
			$sluggie = '&year='.$year.'&month='.$month.'&day='.$day.'';
		}else{
			$sluggie = '&category='.$category;
		}
		
		if(!$user->guest)
		{
			$cookieName	= JUtility::getHash( $mainframe->getName() . 'lyftenbloggierating' . $id );
			$rated 		= JRequest::getVar( $cookieName, '0', 'COOKIE', 'INT');

			$ratingcheck = false;
			if ($session->has('rating', 'lyftenbloggie')) {
				$ratingcheck = $session->get('rating', 0,'lyftenbloggie');
				$ratingcheck = in_array($id, $ratingcheck);
			}

			if ( $rated || $ratingcheck )	{
				$msg = JText::_('ALREADY RATED');
			} else {
				setcookie( $cookieName, '1', time()+1*24*60*60*60 );

				$stamp = array();
				$stamp[] = $id;
				$session->set('rating', $stamp, 'lyftenbloggie');

				$model 	= $this->getModel('comments');
				if ($model->storeRating($id, $rating)) {
					$msg = JText::_( 'RATED' );
				} else {
					$msg = JText::_( 'RATING FAILED' );
				}
			}
			
			$cache = &JFactory::getCache('com_lyftenbloggie');
			$cache->clean();
		} else {
			$msg = JText::_('YOU MUST LOGIN');
		}
		
		if (JRequest::getVar('view') == 'comments') {
			$limitstart = ($limitstart) ? '&limitstart='.$limitstart: '';
			$link = JRoute::_('index.php?option=com_lyftenbloggie&view=comments'.$sluggie.'&id='.$entry.$limitstart, false);
		}else{
			$link = JRoute::_('index.php?option=com_lyftenbloggie&view=entry'.$sluggie.'&id='.$entry, false);
		}
		
		$this->setRedirect($link, $msg);
	}

}
?>