<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

class LDBlogFeed
{

	var $_escape 	= 'htmlspecialchars';
	var $_charset 	= 'UTF-8';
	var $_title 	= null;
	var $_desc 		= null;

    function LDBlogFeed($title, $desc, $_charset = "UTF-8")
    {
        $this->_title 		= $title;
        $this->_desc 		= $desc;
        $this->_charset 	= $_charset; 
    } 
	
	/**
	 * Creates RSS 0.92 Feed View
	 **/
	function RSS($rows)
	{
		global $mainframe;
		
		$lg 		= &JFactory::getLanguage();
		$language 	= $lg->get('name');
		$feedURL 	= trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('atom'));
		$params 	= & $mainframe->getParams();
		$createdate = & JFactory::getDate();
		$date 		= (isset($rows[0]->created))?$rows[0]->created:$createdate->toUnix();

		header('Content-Type: text/xml; charset=' . $this->_charset, true);
		$feed = "<?xml version=\"1.0\" encoding=\"".$this->_charset."\"?>\n";
		$feed .= "<rss version=\"0.92\">\n";
		$feed .= "<channel>\n";
			$feed .= "<title>".$this->_title."</title>\n";
			$feed .= "<link>".JURI::base()."</link>\n";
			$feed .= "<description>".$this->_desc."</description>\n";
			$feed .= "<lastBuildDate>".$date."</lastBuildDate>\n";
			$feed .= "<docs>http://backend.userland.com/rss092</docs>\n";
			$feed .= "<language>".$language."</language>\n";

		foreach ( $rows as $row )
		{
			// strip html from feed item title
			$title = $this->escape( $row->title );
			$title = html_entity_decode( $title );
				
			// url link to entry
			$archive	= ($row->created) ? JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d') : '&category='.$row->catslug;
			$link 		= htmlentities( JRoute::_(LyftenBloggieHelperRoute::getEntryRoute($archive, $row->slug)) );

			// fixes a problem when Search Engine Friendly URLs are activated
			$row->introtext = $this->_fixImage($row->introtext);
			$row->fulltext 	= $this->_fixImage($row->fulltext);

			$desc 			= strip_tags( $this->_makeContent($row) );
			$desc 			= substr( $desc, 0, 240 );
				
			$feed .= "<item>\n";
			$feed .= "<title>".$title."</title>\n";
			$feed .= "<description><![CDATA[".$desc."]]></description>\n";
			$feed .= "<link>".$link."</link>\n";
			$feed .= "</item>\n";
		}
		$feed .= "</channel>\n";
		$feed .= "</rss>\n";
		echo $feed;
	}

	/**
	 * Creates RSS 2 Feed View
	 **/
	function RSS2($rows)
	{
	
		global $mainframe;
		
		$lg 		= &JFactory::getLanguage();
		$language 	= $lg->get('name');
		$feedURL 	= trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('rss'));
		$params 	= & $mainframe->getParams();
		$createdate = & JFactory::getDate();
		$date 		= (isset($rows[0]->created))?$rows[0]->created:$createdate->toUnix();		
		
		header('Content-Type: text/xml; charset='.$this->_charset, true);
		$feed = "<?xml version=\"1.0\" encoding=\"".$this->_charset."\"?>\n";
		
		$feed .= "<rss version=\"2.0\"
		xmlns:content=\"http://purl.org/rss/1.0/modules/content/\"
		xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\"
		xmlns:dc=\"http://purl.org/dc/elements/1.1/\"
		xmlns:atom=\"http://www.w3.org/2005/Atom\"
		xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\">\n";	
		$feed .= "<channel>\n";
		$feed .= "<title>".$this->_title."</title>\n";
		$feed .= "<atom:link href=\"".JURI::base()."\" rel=\"self\" type=\"application/rss+xml\" />\n";
		$feed .= "<link>".$feedURL."</link>\n";
		$feed .= "<description>".$this->_desc."</description>\n";
		$feed .= "<pubDate>".$date."</pubDate>\n";
		$feed .= "<language>".$language."</language>\n";
		$feed .= "<sy:updatePeriod>hourly</sy:updatePeriod>\n";
		$feed .= "<sy:updateFrequency>1</sy:updateFrequency>\n";

		foreach ( $rows as $row ) {
			// strip html from feed item title
			$title = $this->escape( $row->title );
			$title = html_entity_decode( $title );

			$category 		= ($row->cattitle)?$row->cattitle:JText::_('UNCATEGORIZED');
				
			// url link to entry
			$archive		= ($row->created) ? JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d') : '&category='.$row->catslug;
			$link 			= htmlentities( JRoute::_(LyftenBloggieHelperRoute::getEntryRoute($archive, $row->slug)) );
			$comfeedlink 	= htmlentities( trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getCommentFeedRoute($row->id, 'rss2')) );

			// fixes a problem when Search Engine Friendly URLs are activated
			$row->introtext = $this->_fixImage($row->introtext);
			$row->fulltext 	= $this->_fixImage($row->fulltext);
			
			$author			= $row->created_by_alias ? $row->created_by_alias : $row->author;
			@$created 		= ( $row->created ? date( 'r', strtotime($row->created) ) : '' );			
			@$modified 		= ( $row->modified ? date( 'r', strtotime($row->modified) ) : $created );
			$desc 			= ( $params->get('feedSummarize', 0) )?$this->_makeContent($row):'';
			$summary		= strip_tags( substr($row->introtext, 0, 240) );

			$feed .= "<item>\n";
			$feed .= "<title>".$title."</title>\n";
			$feed .= "<link>".$link."</link>\n";
			$feed .= "<comments>".$link."#comment</comments>\n";
			$feed .= "<dc:creator>".$author."</dc:creator>\n";
			$feed .= "<category><![CDATA[".$category."]]></category>\n";
			
			if (!$desc) {
				$feed .= "<description>".$summary."</description>\n";
			} else {
				$feed .= "<description>".$summary."</description>\n";
				$feed .= "<content:encoded>".$desc."</content:encoded>\n";
			}
			
			$feed .= "<pubDate>".$created."</pubDate>\n";
			$feed .= "<guid isPermaLink=\"false\">".$link."</guid>\n";
			$feed .= "<wfw:commentRss>".$comfeedlink."</wfw:commentRss>\n";
			$feed .= "</item>\n";
		}
		$feed .= "</channel>\n";
		$feed .= "</rss>\n";
		
		echo $feed;
	}
	
	/**
	 * Creates Atom Feed View
	 **/
	function Atom($rows)
	{
		global $mainframe;

		$lg 		= &JFactory::getLanguage();
		$language 	= $lg->get('name');
		$feedURL 	= trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('atom'));
		$params 	= & $mainframe->getParams();
		header('Content-Type: application/atom+xml; charset='.$this->_charset, true);
		$feed = "<?xml version=\"1.0\" encoding=\"".$this->_charset."\"?>\n";
		$feed .= "<feed
		  xmlns=\"http://www.w3.org/2005/Atom\"
		  xmlns:thr=\"http://purl.org/syndication/thread/1.0\"
		  xml:lang=\"".$language."\"
		  xml:base=\"".$feedURL."\">\n";		  
		$feed .= "<title type=\"text\">".$this->_title."</title>\n";
		$feed .= "<subtitle type=\"text\">".$this->_desc."</subtitle>\n";

		if($rows[0]->created)	$feed .= "<updated>".$rows[0]->created."</updated>\n";
			
		$feed .= "<generator uri=\"http://lyften.com\" version=\"1.0\">LyftenBloggie</generator>\n";

		$feed .= "<link rel=\"alternate\" type=\"text/html\" href=\"".JURI::base()."\" />\n";
		$feed .= "<id>".$feedURL."</id>\n";
		$feed .= "<link rel=\"self\" type=\"application/atom+xml\" href=\"".$feedURL."\" />\n";

		foreach ( $rows as $row ) {
			// strip html from feed entry title
			$title = $this->escape( $row->title );
			$title = html_entity_decode( $title );

			$category 		= ($row->cattitle)?$row->cattitle:JText::_('UNCATEGORIZED');
			$categorylink 	= htmlentities( trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getCategoryRoute($row->catslug)) );
				
			// url link to entry
			$archive		= ($row->created) ? JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d') : '&category='.$row->catslug;
			$link 			= htmlentities( JRoute::_(LyftenBloggieHelperRoute::getEntryRoute($archive, $row->slug)) );
			$comfeedlink 	= htmlentities( trim(JURI::base(), '/').JRoute::_(LyftenBloggieHelperRoute::getCommentFeedRoute($row->id, 'atom')) );
				
			// fixes a problem when Search Engine Friendly URLs are activated
			$row->introtext = $this->_fixImage($row->introtext);
			$row->fulltext 	= $this->_fixImage($row->fulltext);

			$author			= $row->created_by_alias ? $row->created_by_alias : $row->author;
			@$created 		= ( $row->created ? date( 'r', strtotime($row->created) ) : '' );			
			@$modified 		= ( $row->modified ? date( 'r', strtotime($row->modified) ) : $created );
			$desc 			= ( $params->get('feedSummarize', 0) )?$this->_makeContent($row):'';
			$summary		= substr($row->introtext, 0, 800);
				
			$feed .= "<entry>\n";
			$feed .= "<author>\n";
			$feed .= "<name>".$author."</name>\n";
			$feed .= "</author>\n";
			$feed .= "<title type=\"html\"><![CDATA[".$title."]]></title>\n";
			$feed .= "<link rel=\"alternate\" type=\"text/html\" href=\"".$link."\" />\n";
			$feed .= "<id>".$link."</id>\n";
			$feed .= "<updated>".$modified."</updated>\n";
			$feed .= "<published>".$created."</published>\n";
			$feed .= "<category scheme=\"".$categorylink."\" term=\"".$category."\" />\n";
			$feed .= "<summary type=\"html\"><![CDATA[".$summary."]]></summary>\n";
				
			if ( $desc ) {
				$feed .= "<content type=\"html\" xml:base=\"".$link."\"><![CDATA[".$desc."]]></content>\n";
			}
				
			$feed .= "<link rel=\"replies\" type=\"text/html\" href=\"".$link."#comment\" thr:count=\"".$row->comcount."\"/>\n";
			$feed .= "<link rel=\"replies\" type=\"application/atom+xml\" href=\"".$comfeedlink."\" thr:count=\"".$row->comcount."\"/>\n";
			$feed .= "<thr:total>".$row->comcount."</thr:total>\n";
			$feed .= "</entry>\n";
		}
		$feed .= "</feed>\n";
		echo $feed;
	}
	
	/**
	* Escapes a value for output in a view script.
	*/
	function escape($var)
	{
		if (in_array($this->_escape, array('htmlspecialchars', 'htmlentities'))) {
			return call_user_func($this->_escape, $var, ENT_COMPAT, $this->_charset);
		}
	
		return call_user_func($this->_escape, $var);
	}
	
	/**
	* Escapes a value for output in a view script.
	*/
	function _fixImage($text='')
	{
		$base 		= trim(JURI::base(true), '/');
		$text 	= str_replace('src="images/', 'src="'.JURI::base().'images/', $text);
		$text 	= str_replace('src="/images/', 'src="'.JURI::base().'images/', $text);
		$text 	= str_replace($base.'/'.$base, $base, $text);
		
		return $text;
	}
	
	/**
	* Escapes a value for output in a view script.
	*/
	function _makeContent($row)
	{
		global $mainframe;
			
		// Get the component configuration
		$params 		= $mainframe->getParams('com_lyftenbloggie');
		
		if($params->get('feedSummarize')){
			if(empty($row->fulltext)){
				$ending = strpos($row->introtext, '</p>');
				
				$pos=-1;
				$pos_array = array();
				while (($pos=strpos($row->introtext,'</p>',$pos+1))!==false) 
					$pos_array[]=$pos;
				
				$pNum = $params->get('feedLength');
				if (count($pos_array) <= $pNum) {
				   $text 			= $row->introtext;
				} else {
					$ending 		= $pos_array[$pNum-1];
					$row->introtext = substr($row->introtext, 0, $ending + 4);
					$row->introtext = EntriesHelper::cleanHTML(preg_replace('#\s*<[^>]+>?\s*$#','',$row->introtext));
				}
			}
			else if( !empty($row->fulltext) && empty($row->introtext) )
			{
				// Strip x paragraphs
				$ending = strpos($row->fulltext, '</p>');
				
				$pos=-1;
				$pos_array = array();
				while (($pos=strpos($row->fulltext,'</p>',$pos+1))!==false) 
				$pos_array[]=$pos;
				
				$pNum = $params->get('feedLength');
				if (count($pos_array) <= $pNum) {
					$text 			= $row->fulltext;
				} else {
					$ending = $pos_array[$pNum-1];
					$row->fulltext 	= substr($row->fulltext, 0, $ending + 4);
					$row->fulltext 	= EntriesHelper::cleanHTML(preg_replace('#\s*<[^>]+>?\s*$#','',$row->fulltext));
				}
			}
			
			$text =( empty($row->introtext) )?$row->fulltext:$row->introtext;

		} else{

			$text = (empty($row->introtext))?$row->fulltext:$row->introtext;

		}
		
		// Clean up the final text
		$text 	= str_replace(array('{mosimage}', '{mospagebreak}', '{readmore}'), '', $text);
		return $text;
	}
}