<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

class EntriesHelper
{
	function getAuthor($userID=null)
	{
		global $mainframe;

		// Initialize variables
		$db 			= & JFactory::getDBO();
		$user			=& JFactory::getUser($userID);
		$params			=& $mainframe->getParams('com_lyftenbloggie');
		$authorLevel	= $params->get('authorLevel', '0');
		$adminLevel		= $params->get('adminLevel', '0');
		$allowed		= new stdClass();
		$allowed->admin	= false;
		$feeds			= null;
		$about			= null;

		//Find out if user is an Admin
		if(!$userID && $adminLevel !=  'LB' && $adminLevel <=  $user->get('gid'))
		{
			$allowed->user_id 		= ($user->get('id')) ? $user->get('id') : 'no';
			$allowed->username 		= $user->get('name');
			$allowed->admin		 	= true;
			$allowed->permission 	= true;
			$allowed->allowpub	 	= true;
			$allowed->allowdelete 	= true;
			$allowed->avatar		= LDHTML::genAvatarURL($allowed->user_id, $params->get('avatarUsed', '0') );
			$allowed->attribs 		= '';
			return $allowed;
		}

		//Get Author/Admin Settings for user
		if($userID)
		{
			//Check to see if the user is allowed to post
			$query = 'SELECT about, attribs'
					.' FROM #__bloggies_authors'
					.' WHERE user_id = '.$user->get('id')
					.' AND published = 1';
			$db->setQuery($query);
			if($LBData = $db->loadObject())
			{
				//Get Feeds
				$attribs 	= new JParameter( $LBData->attribs );
				$feeds 		= ($attribs->get('facebookURL'))?'<a href="'.$attribs->get('facebookURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/facebook.gif" border="0"></a>':'';
				$feeds 		.= ($attribs->get('diggURL'))?'<a href="'.$attribs->get('diggURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/digg.png" border="0"></a>':'';
				$feeds 		.= ($attribs->get('deliciousURL'))?'<a href="'.$attribs->get('deliciousURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/delicious.gif" border="0"></a>':'';
				$feeds 		.= ($attribs->get('technoratiURL'))?'<a href="'.$attribs->get('technoratiURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/technorati.png" border="0"></a>':'';
				$feeds 		.= ($attribs->get('twitterURL'))?'<a href="'.$attribs->get('twitterURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/twitter.gif" border="0"></a>':'';
				$feeds 		.= ($attribs->get('flickrURL'))?'<a href="'.$attribs->get('flickrURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/flickr.gif" border="0"></a>':'';
				$feeds 		.= ($attribs->get('mybloglogURL'))?'<a href="'.$attribs->get('mybloglogURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/mybloglog.png" border="0"></a>':'';
				$feeds 		.= ($attribs->get('ffindURL'))?'<a href="'.$attribs->get('ffindURL').'" target="_blank"><img src="'.COM_LYFTENBLOGGIE_ASSETS.'/images/social/ffind.jpg" border="0"></a>':'';

				//Set About
				$about	= $LBData->about;
			}
			$allowed->feeds 	= $feeds;
			$allowed->about		= $about;
		}else{
		
			//Get Author Data
			$query = 'SELECT a.about, a.attribs, a.permissions'
					.' FROM #__bloggies_authors AS a'
					.' WHERE a.user_id = '.$user->get('id')
					.' AND a.published = 1';
			$db->setQuery($query);
			$LBData = $db->loadObject();

			if(!empty($LBData))
			{
				//Set Parameters
				$permissions 			= new JParameter( $LBData->permissions );

				//Set permission
				$allowed->admin		 	= $permissions->get('admin', 0);
				$allowed->permission 	= true;
				$allowed->allowpub	 	= $permissions->get('allowpub', 1);
				$allowed->allowdelete 	= $permissions->get('allowdelete', 1);
				$allowed->attribs		= $LBData->attribs;
				$allowed->about			= $LBData->about;
			}else{
				//What can the author do
				if($authorLevel ==  $user->get('gid')){
					$allowed->permission 	= true;
					$allowed->allowpub 		= $params->get('authorPub');
					$allowed->allowdelete 	= $params->get('authorDel');
				}else{
					$allowed->permission 	= false;
					$allowed->allowpub	 	= false;
					$allowed->allowdelete 	= false;
				}
			}
		}
		
		$allowed->user_id 		= ($user->get('id')) ? $user->get('id') : 'no';
		$allowed->username 		= $user->get('name');
		$allowed->avatar		= LDHTML::genAvatarURL($allowed->user_id, $params->get('avatarUsed', '0') );

		return $allowed;
	}
	
	/**
	 * Returns the SEF URL
	 **/ 
	function getSEFLink($url='')
	{
		global $mainframe;
		
		if(!$url) return;
		
		$uri 		=& JURI::getInstance();
		$baseURL 	= $uri->toString( array('scheme', 'host', 'port'));
		
        // Do not run plugin if SEF is disabled
        $config =& JFactory::getConfig();
        if ($config->getValue('sef'))
		{
			// check if joomsef is enabled
			$path = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_sef'.DS.'classes'.DS.'config.php';
			if(file_exists($path)) {
				require_once( $path );
				require_once( JPATH_ROOT.DS.'components'.DS.'com_sef'.DS.'sef.router.php' );
				$sefConfig =& SEFConfig::getConfig();
				if ($sefConfig->enabled) {
					$router = new JRouterJoomsef();
					$newurl	= $router->build($url);
					$url 	= $newurl->_uri;
				}else{
					$router = JSite::getRouter();
					$newurl	= $router->build($url);
					$url 	= $baseURL.'/'.trim($newurl->_path, '/');
					if($mainframe->isAdmin()) {
						$url 	= str_replace( '/administrator', '', $url );
					}
				}
			}else{
				$router = JSite::getRouter();
				$newurl	= $router->build($url);
				$url 	= $baseURL.'/'.trim($newurl->_path, '/');
				if($mainframe->isAdmin()) {
					$url 	= str_replace( '/administrator', '', $url );
				}
			}
		}else{
			$url 	= $baseURL.JURI::base(true).'/'.$url;
		}

		return $url;
	}
	
	/**
	 *	Get a list of categories for a content.
	 */ 
	function getCatLinks($id, $linkCats = true) {

		$database = & JFactory::getDBO();
		
		$query = 'SELECT id, title, slug'
				.' FROM #__bloggies_categories'
				.' WHERE id = ' . $id
				;
		$database->setQuery($query);
		$cat 	= $database->loadObject();
		if ($cat) {
			if ($linkCats) {
				$link = '<a href="'.JRoute::_(LyftenBloggieHelperRoute::getCategoryRoute($cat->slug)).'" title="View all posts in '.$cat->title.'" rel="category">'.$cat->title.'</a>';				
			} else {
				$link = $cat->name;
			}
		} else {
				$link = '<a href="'.JRoute::_(LyftenBloggieHelperRoute::getCategoryRoute(JText::_('UNCATEGORIZED'))).'" title="View all posts in '.JText::_('UNCATEGORIZED').'" rel="category">'.JText::_('UNCATEGORIZED').'</a>';
		}
		
		return $link;
	}

	/**
	 *	Get a list of categories for a content.
	 */ 
	function getTagLinks($id, $linkTags = true) {
		$database = & JFactory::getDBO();
		
		$query = 'SELECT t.name, t.slug'
				.' FROM #__bloggies_relations AS r'
				.' LEFT JOIN #__bloggies_tags AS t ON t.id = r.tag'
				.' WHERE r.entry='.$id;
		$database->setQuery($query);
		$used = $database->loadObjectList();

		$tags = '';
		$n = count($used);
		for( $i = 0, $n; $i < $n; $i++ ){
			$tag = $used[$i];
			if ($linkTags) {
				$tags .= ', <a href="'.JRoute::_(LyftenBloggieHelperRoute::getTagRoute($tag->slug)).'" rel="tag">'.$tag->name.'</a>';
			} else {
				$tags .= $cat->name;
			}
		}

		return trim($tags, ',');
	}

	/**
	 * Method to fetch the subcategories
	 **/
	function getBookmarks(&$entry, $id=0, $addThisPubId=null)
	{
		global $mainframe;
		$uri    	=& JURI::getInstance();
		$database 	= & JFactory::getDBO();
		$entryID 	= $entry->id;
		$title		= $entry->title;
		$desc		= $entry->metadesc;
		
		$query = 'SELECT type, html'
					. ' FROM #__bloggies_bookmarks'
					. ' WHERE published = 1'
					. ' GROUP BY id'
					;
		$database->setQuery($query);
		$Bmarks = $database->loadObjectList();
		
		//clean url
		$url = LyftenBloggieHelperRoute::getEntryRoute($entry->archive, $entry->slug);

		//Make URL SEF
        $url = EntriesHelper::getSEFLink($url);

		// Build html for top and bottom button groups
		$badge 	= '';
		$button = '';
		$tt		=1;
		$i		=0;
		foreach ($Bmarks as $Bmark)
		{
				if ($Bmark->type == 'badge')
				{
					if($badge) $badge .= '<br />';
					$badge .= $Bmark->html;
				}
				else
				{
					$button .= $Bmark->html;
					if($tt==9) {
						$button .= '</p><p>';
						$tt=0;
					}
					$tt++;
					$i++;
				}
		}
		
		if($i > 5) $button = '<a href="javascript:showlayer(\'shareme'.$id.'\');" class="rss-button">Share Me!</a><div style="display: none;" id="shareme'.$id.'" class="shareme"><h2>Share Me!</h2><p>'.$button .= '</p></div>';

		// Replace keystrings in badge and button html
		$bookmarks['badge'] 	= EntriesHelper::_replaceParams($badge, $url, $title, $desc, $addThisPubId);
		$bookmarks['button'] 	= EntriesHelper::_replaceParams($button, $url, $title, $desc, $addThisPubId);
		
		return $bookmarks;
	}

	function _replaceParams($text, $url, $title, $desc, $addThisPubId=null)
	{
		$text = str_replace('***url***', str_replace("'", "", $url), $text);
		$text = str_replace('***url_encoded***', "' + encodeURIComponent('". str_replace("'", "", $url) ."') + '", $text);
		$text = str_replace('***title***', str_replace("'", "", $title), $text);
		$text = str_replace('***title_encoded***', "' + encodeURIComponent('". str_replace("'", "", $title) ."') + '", $text);
		$text = str_replace('***description***', str_replace("'", "", $desc), $text);
		$text = str_replace('***description_encoded***', "' + encodeURIComponent('". str_replace("'", "", $desc) ."') + '", $text);
		$text = str_replace('***imageDirectory***', JURI::base() .'components/com_lyftenbloggie/assets/images/bookmarks', $text);
		$text = str_replace('***bgcolor***', '#ffffff', $text);
		$text = str_replace('***addThisPubId***', $addThisPubId, $text);
		
		return $text;
	}
	
	/**
	 *	Filter BadWords
	 **/ 
	function checkCommentPost($text, $params)
	{
		//makes sure the badword filter is on
		if(!$params->get( 'enableBadWord' )) return $text;
	
		// Initialize variables
		$words			= $params->get( 'theBadWords' );
		$replace_str	= $params->get( 'replaceBadWords', "@#$*!" );
		
		//Return if there are no words
		if(!$words) return $text;

		$bad_words = explode(',', $words);

		for ($x=0; $x < count($bad_words); $x++)
		{
			$fix = isset($bad_words[$x]) ? $bad_words[$x] : '';
			$_replace_str = $replace_str;
			if (strlen($replace_str)==1)
			{
				$_replace_str = str_pad($_replace_str, strlen($fix), $replace_str);
			}

			$text = preg_replace('/'.$fix.'/i', $_replace_str, $text);
		}

        return $text;		
	}
	
	/**
	 * Method to get Captcha
	 **/
	function getCaptcha()
	{
		global $mainframe;
		static $captchasessionid = '';
		
		$doc = &JFactory::getDocument();

		$length = 6; // TODO throus function parameter
		$captchaalphanumeric  = '0123456789'; // no 'l', '1', 'o', '0' - trouble for distinct
		$captchanumeric  = '0123456789'; // sound captcha
		$captchalen = strlen( $captchaalphanumeric ) - 1;
		$captchaslist = array();
		$captchareloads = min( 5, 20 );
		for ( $j = 0; $j < $captchareloads; $j++ ) {
			$char = '';
			$number = '';
			for ( $i = 0; $i < $length; $i++ ) {
				$char .= substr( $captchaalphanumeric, mt_rand( 0, $captchalen ), 1 );        
				$number .= substr( $captchanumeric, mt_rand( 0, 9 ), 1 );        
			}
			$captchaslist[] = $number;
		}
	
		// Session >>>
		$lastsession = $_SESSION;
		$lastsessionid = session_id();
		session_write_close();
		
		// captcha session
		ini_set( 'session.save_handler', 'files' );
		if (!$captchasessionid == '') {
			@session_id( $captchasessionid );
			session_start();
		} else {
			session_start();
			session_regenerate_id();
			$captchasessionid = session_id();
			$_SESSION = array();
		}
		
		$_SESSION [ 'captchaslist' ] = $captchaslist;

		session_write_close();
		
		// restore previous session
		$conf = &JFactory::getConfig();
		$handler =  $conf->getValue('config.session_handler', 'none');
		if ($handler == 'none') {
			ini_set( 'session.save_handler', 'files' );
		} else {
			ini_set( 'session.save_handler', 'user' );
			$sessionstorage = new JSessionStorageDatabase();
		}
		session_id($lastsessionid);
		session_start();
		
		$_SESSION [ 'captchasessionid' ] = $captchasessionid;
		setcookie( 'jsid', $captchasessionid, time() + 3600, '/' ); // TODO
		
		// URLs		
		$captcha_URI = JURI::root() . 'components/com_lyftenbloggie/helpers/';
		$image_URI   = $captcha_URI . 'captcha.php?';
		$url_imagecore   = JRoute::_( $image_URI );
		$image_params   = '&amp;sid='.$captchasessionid.'&amp;crt=0';
		$url_image   = $url_imagecore.time().$image_params;

		$captcha = array('url_imagecore'	=>$url_imagecore,
						"image_params" 		=> $image_params,
						"url_image" 		=> $url_image,
						"captchasessionid" 	=> $captchasessionid
						) ;
						
		return $captcha;
	}
	
	/**
	 * Method to check Captcha code
	 **/	
	function checkCaptcha()
	{
		$usersecurecode 	= strtolower(JRequest::getVar( 'captchacode', '', 'post' ));
		$captchasessionid 	= JRequest::getVar( 'captchasessionid', '', 'post' );
		$captcha 			= '';
		$captchasesfrmcurs	= '';
	
		// close and save previous session
		if (session_id()) {
		
			// for backward compatibility
			// will be deprecated in 5.0.0 or wil be used for hi security
			@$captchasesfrmcurs .= $_SESSION['captchasessionid'];
			$lastsession = $_SESSION;
			$lastsessionid = session_id();
		}
		session_write_close();
		
		if ($captchasessionid == '') $captchasessionid = $captchasesfrmcurs;

		// captcha session
		if ( $captchasessionid ) {
			ini_set( 'session.save_handler', 'files' );
			@session_id( $captchasessionid );
			session_start();
			@$captcha = $_SESSION [ 'captcha' ] ;
			session_write_close();
		}

		// restore previous session
		$conf = &JFactory::getConfig();
		$handler =  $conf->getValue('config.session_handler', 'none');
		if ($handler == 'none') {
			ini_set( 'session.save_handler', 'files' );
		} else {
			ini_set( 'session.save_handler', 'user' );
			$sessionstorage = new JSessionStorageDatabase();
		}
		session_id($lastsessionid);
		session_start();
		
		// <<<<< Sessions
		if (($captcha == $usersecurecode) && ( $usersecurecode != '' )) {
			return true;
		}
		return false;		
	}
	
	/**
	 * Closes any open HTML Tags
	* */ 
	function cleanHTML($var){
		preg_match_all("#<([a-z]+)( .*)?(?!/)>#iU",$var,$opened);
		preg_match_all("#</([a-z]+)>#iU",$var,$closed);
		$OpenedCount = count($opened[1]);
		
		if(count($closed[1]) == $OpenedCount) return $var;
		
		$opened = array_reverse($opened[1]);
		for($i=0;$i < $OpenedCount;$i++) {
			if (!in_array($opened[$i],$closed[1]) && $opened[$i] != 'img'){
				$var .= '</'.$opened[$i].'>';
			} else {
				unset($closed[1][array_search($opened[$i],$closed[1])]);
			}
		}
		return $var;
	}

	function getFirstImage($text)
	{
		$return = array();

		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $text, $matches);

		//If no image check for object
		if(!isset($matches[1][0]))
		{
			$mediaSearch = preg_match_all('/<object[0-9 a-z_?*=\":\-\/\.#\,<>\\n\\r\\t]+<\/object>/smi', $text, $matches2);
			if(isset($matches2[1][0])){
				$return['type'] = 'object';
				$return['src'] 	= $matches2[1][0];
				$return['text'] = preg_replace('/<object[0-9 a-z_?*=\":\-\/\.#\,<>\\n\\r\\t]+<\/object>/smi', '', $text, 1);
			}
		}else{
			//Return First Image
			$return['type'] = 'image';
			$return['src'] 	= $matches[1][0];
			$return['text'] = preg_replace('/<img[^>]+\>/i', '', $text, 1);
		}		

		return $return;
	}
}

class LDHTML
{
	/**
	* Method to get the default theme
	**/
	function setCommentStyle($id=0, $closed=1, $total=0)
	{
		global $mainframe;
	
		//Commenting closed
		if(!$closed) {
			if($total) echo '<div class="post-comment">'.JText::_('COMMENTING CLOSED').'</div>';
			return;
		}

		//No ID set
		if(!$id) return;

		// Initialize variables
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$document 	= & JFactory::getDocument();
		$user		= & JFactory::getUser();
		$uri     	=& JFactory::getURI();
		$action		= $uri->toString();

		// Handle Captcha
		if($params->get('enableCaptcha')) {
			$captcha 	= EntriesHelper::getCaptcha();
		}

		//Get Posted Data
		$data 			= array();
		$data['show']	= false;
		
		if($data['comment'] = JRequest::getVar('comment')){
			$data['comment'] = base64_decode($data['comment']);
			$data['show']	= true;
		}else{
			$data['comment'] = JText::_('COMMENT');
		}
		
		if($data['website'] = JRequest::getVar('website')){
			$data['website'] = base64_decode($data['website']);
			$data['show']	= true;
		}else{
			$data['website'] = JText::_('WEBSITE OPTIONAL');
		}
		
		if($data['email'] = JRequest::getVar('email')){
			$data['email'] = base64_decode($data['email']);
			$data['show']	= true;
		}else{
			$data['email'] = JText::_('EMAIL OPTIONAL');
		}

		//Add Javascript
		if(!$params->get('commentStyle', 0) && $params->get('typeComments', '1')) {
			$document->addCustomTag('<script type="text/javascript" src="'.JURI::base().'components/com_lyftenbloggie/assets/js/lyftenbloggie.js"></script>');
		}
		if($params->get('useJquery', 0) && $params->get('commentStyle', 0) && $params->get('typeComments', 1)) {
			$document->addCustomTag('<script type="text/javascript" src="'.JURI::base().'components/com_lyftenbloggie/assets/js/jquery-1.2.6.js"></script>');
		}
		
		if($params->get('usePHPjquery', 0) && $params->get('commentStyle', 0) && $params->get('typeComments', 1)) {
			$document->addCustomTag('<script type="text/javascript" src="'.JURI::base().'components/com_lyftenbloggie/assets/js/jquery.php.js"></script>');
			$document->addCustomTag('<script type="text/javascript" src="'.JURI::base().'components/com_lyftenbloggie/assets/js/jquery.form.js"></script>');
			$js = "<script type=\"text/javascript\">
			var url = \"".JURI::base()."index.php?option=com_lyftenbloggie\";
			formAjax = function () {
			if(jQuery(\"#boxoverlay\").css('display') == \"block\") return false;
			jQuery.php(url, jQuery('form#form').formToArray(true));
			jQuery('#boxoverlay').css({'display':'block',
			'opacity':'0.1','width':'100%','height':'100%'}).fadeIn();
			jQuery('#facebox .loader').css(\"display\", \"block\");
			return false;

			// do an ajax post request
			jQuery.ajax({
			url: url,
			type: \"POST\",
			data: jQuery('form#form').formToArray(true),
			dataType : \"json\",
				/* Handlers */
				// Handle the beforeSend event
				beforeSend: function(){
				return php.beforeSend();
			},

			// Handle the success event
			success: function(data, textStatus){
				return php.success(data, textStatus);
			}, error: function (xmlEr, typeEr, except) {
				return php.error(xmlEr, typeEr, except);
			},
			
			// Handle the complete event
			complete: function (XMLHttpRequest, textStatus) {
				return php.complete(XMLHttpRequest, textStatus);
			}});
			return false;}
		</script>";

			$document->addCustomTag($js);
		}
		
		if($params->get('commentStyle', 0) && $params->get('typeComments', 1)) {
			$document->addCustomTag('<script type="text/javascript" src="'.JURI::base().'components/com_lyftenbloggie/assets/js/facebox.js"></script>');
		}
		if($params->get('commentStyle', 0)) {
			if(!$user->guest || $params->get('loginform', 1) ) {
			?>
			<div class="post-comment"><a href="#" onclick="jQuery.facebox({ ajax: '<?php echo JRoute::_('index.php?&option=com_lyftenbloggie&task=comment&id='.$id); ?>' });return false;"><?php echo Jtext::_('LEAVE A COMMENT'); ?></a></div>
			<?php
			}else{
				$url  		= JRoute::_('index.php?option=com_user&view=login&return='.base64_encode($action));			
				echo '<div class="post-comment"><a href="'.$url.'">'.JText::_('PLEASE LOGIN TO COMMENT').'</a></div>';
			}
		}else{
			if(!$user->guest) {
			?>
			<div class="post-comment"><a href="#" onclick="showHiddenDiv('entryComment');return false;" id="entryComment"><?php echo JText::_('LEAVE A COMMENT'); ?></a></div>
			<div class="entryComment" id="entryComment_hidden" style="display:<?php echo ($data['show']) ? 'block' : 'none'; ?>;"> 		
				<div class="entryComment_post">
					<form action="<?php echo $action; ?>" method="post" name="adminForm"> 		
					<h3><?php echo Jtext::_('ADD NEW COMMENT'); ?></h3> 			
					<div class="entryComment_top"> 				
						<div class="inputshadow">
							<textarea name="comment" cols="30" rows="6" onblur="if(this.value=='') this.value='<?php echo JText::_('COMMENT'); ?>';" onfocus="if(this.value=='<?php echo JText::_('COMMENT'); ?>') this.value='';"><?php echo $data['comment']; ?></textarea>
						</div> 			
					</div> 			
					<div class="entryComment_middle"> 				
						<table> 					
							<tbody>
								<tr> 						
									<td class="entryComment_middle_l">
										<div class="inputshadow">
											<input id="name" disabled="true" value="<?php echo $user->get('name'); ?>" type="text">
										</div>
									</td> 						
									<td class="entryComment_middle_r">
										<div class="inputshadow">
											<input id="website" name="website" value="<?php echo $data['website']; ?>" onblur="if(this.value=='') this.value='<?php echo JText::_('WEBSITE OPTIONAL'); ?>';" onfocus="if(this.value=='<?php echo JText::_('WEBSITE OPTIONAL'); ?>') this.value='';" type="text">
										</div>
									</td> 					
								</tr> 					
								<tr> 						
									<td class="entryComment_middle_l">
										<div class="inputshadow">
											<input id="email" name="email" value="<?php echo $data['email']; ?>" onblur="if(this.value=='') this.value='<?php echo JText::_('EMAIL OPTIONAL'); ?>';" onfocus="if(this.value=='<?php echo JText::_('EMAIL OPTIONAL'); ?>') this.value='';" type="text">
										</div>
									</td> 						
									<td class="entryComment_middle_r"> 
									<?php if(isset($captcha)) { ?>
											<SCRIPT><!--
											function JGetElementById( s ) {
												var o = (document.getElementById ? document.getElementById(s)
												: document.all[s]);
												return ((o == null) ? false : o);
											}
											function reloadCaptcha() {
												var ocap = JGetElementById( 'captchaimage');
												if (ocap) {
													var today = new Date(); 
													ocap.setAttribute( 'src', '<?php echo $captcha['url_imagecore']; ?>' + today.getTime() + '<?php echo str_replace( '&amp;', '&',  $captcha['image_params'] ); ?>' );
												}
												var ocapc = JGetElementById( 'captchacode');
												ocapc.value="";
												ocapc.focus();
											}
											--></SCRIPT>
											<div class="inputshadow">
												<span class="commentCaptcha"><img id="captchaimage" src="<?php echo $captcha['url_image']; ?>1" title="<?php echo JText::_( 'CAPTCHACODE_TEXT' ) ?>" alt="<?php echo JText::_( 'CAPTCHACODE_TEXT' ) ?>" onclick="reloadCaptcha()" style="cursor: pointer;"></span><input id="captchacode1" value="Captcha" name="captchacode" onblur="if(this.value=='') this.value='Captcha';" onfocus="if(this.value=='Captcha') this.value='';" type="text">
												<input type="hidden" name="captchasessionid" value="<?php echo $captcha['captchasessionid']; ?>" />
											</div>	
										<?php } ?>
									</td> 					
								</tr> 				
							</tbody>
						</table>
					</div>
					<div class="entryComment_footer"> 				
						<button class="entry_button" id="dsq-post-button" onclick="showHiddenDiv('entryComment');return false;">
							<span><?php echo JText::_( 'Cancel' ) ?></span>
						</button>
						<button class="entry_button" id="dsq-post-button" onclick="document.adminForm.submit();">
							<span><?php echo JText::_( 'Post' ) ?></span>
						</button>
					</div>
					<input type="hidden" name="id" value="<?php echo $id; ?>" />
					<input type="hidden" name="referer" value="<?php echo @$_SERVER['HTTP_REFERER']; ?>" />
					<?php echo JHTML::_( 'form.token' ); ?>
					<input type="hidden" name="task" value="postComment" />					
					</form> 
				</div>
			</div>	
			<?php
			}else{
				$url  		= JRoute::_('index.php?option=com_user&view=login&return='.base64_encode($action));			
				echo '<div class="post-comment"><a href="'.$url.'">'.JText::_('Please login to comment').'</a></div>';
			}
		}
	}

	/**
	 * Creates the Avatar URL
	 **/
	function genAvatarURL( $userid, $avatarUsed='default' )
	{
		global $mainframe;
		$db 		= &JFactory::getDBO();
		
		//Just in cause it's call from another component
		if (!defined('COM_LYFTENBLOGGIE_ASSETS')) {
			define('COM_LYFTENBLOGGIE_ASSETS',    JURI::base().'components/com_lyftenbloggie/assets');
		}

		if( $avatarUsed == 'none' )
		{
			$avatar = COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';

		} elseIf( $avatarUsed == 'default' ){
			$query = 'SELECT c.avatar'
						. ' FROM #__bloggies_authors AS c'
						. ' WHERE c.user_id = '. (int)$userid
						;
	        $db->setQuery($query);
	        $avatar = $db->loadResult();
			$avatar = ($avatar)?COM_LYFTENBLOGGIE_ASSETS.'/avatars/'.$avatar:COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';

		} elseIf( $avatarUsed == 'jomsocial' ){
			//Ensure jomSocial is installed
			if(!is_dir(JPATH_SITE.DS.'components'.DS.'com_community'))
				return COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';

	        $query = 'SELECT a.avatar FROM #__community_users AS a WHERE a.userid = '.(int)$userid;
	        $db->setQuery($query);
	        $data = ($data = $db->loadObject()) ? $data : array();
			$avatar =  JURI::base().'components/com_community/assets/default.jpg';
	        if( isset($data->avatar) ) {
				$avatar = $data->avatar ;
	        }

		} elseIf( $avatarUsed == 'brezza' ){
			//Ensure Brezza is installed
			if(!is_dir(JPATH_SITE.DS.'components'.DS.'com_brezza'))
				return COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';
				
			$params	= $mainframe->getParams('com_brezza');

	        $query 	= 'SELECT a.avatar'.
	                  ' FROM #__jomprod_customers AS a' .
					  ' WHERE a.user_id = '.(int)$userid ;
	        $db->setQuery($query);
	        $data 	= ($data = $db->loadObject()) ? $data : array();
			$avatar = JURI::base().$params->get('avatarPath', 'images/brezza/avatars').'/'.(isset($data->avatar)?$data->avatar:'default.png');
			
        } elseIf( $avatarUsed == 'combuilder' ){
			//Ensure combuilder is installed
			if(!is_dir(JPATH_SITE.DS.'components'.DS.'com_comprofiler'))
				return COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';
				
			$query = 'SELECT a.avatar, a.avatarapproved '.
	                 	'FROM #__comprofiler AS a ' .
	                 	'WHERE a.user_id = '.(int)$userid ;
	        $db->setQuery($query);
	        $data = ($data = $db->loadObject()) ? $data : array();
			$avatar = JURI::base().'components/com_comprofiler/plugin/templates/default/images/avatar/nophoto_n.png';
	        if( isset($data->avatarapproved) && $data->avatarapproved == 1 && isset($data->avatar)) {
				$avatar = JURI::base().'images/comprofiler/' . $data->avatar ;
	        }
		}elseIf( $avatarUsed == 'juser' ){
			
			//Ensure JUser is installed
			if(!is_dir(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_juser'))
				return COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';

			//Get Avatar
			$query = 'SELECT avatar'.
				'FROM #__juser_users_additional_data'.
				'WHERE `user_id` = '.(int)$userid;
			$db->setQuery( $query );
			$data = $db->loadResult();
		
			$avatar = JURI::base().'administrator/components/com_juser/img/default_avatar.jpg';
			if($data){
				$query = "SELECT `selected` FROM #__je_config WHERE `section` = 'general' AND name = 'uploaded_avatar_directory'";
				$db->setQuery( $query );
				$path = $db->loadResult();
				
				//Create avatar
				$path		= str_replace('\\','/',$path);
				$path		= str_replace($mosConfig_absolute_path,$mosConfig_live_site,$path);
				$avatar 	= $path.'/user_'.(int)$userid.strtolower(strrchr($data,'.'));
			}
		}
		
		return $avatar;
	}
}
?>