<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.filesystem.path');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0.4
 */
class TemplateEngine
{
	var $output		 		= true;
	var $_db		 		= NULL;
	var $_escape	 		= 'htmlspecialchars';
	var $_charset 			= 'UTF-8';
	var $themeURL 	 		= NULL;
	var $themePath  		= NULL;
	var $_themeName  		= NULL;
	var $_themeParams  		= NULL;
	var $_filename 			= NULL;

	/**
	 * Constructor
	 **/
	function TemplateEngine( $filename='', $output=false )
	{
		$this->_db 		= & JFactory::getDBO();

		//set the view name
		if (!$this->_themeName)
		{
			$this->getName();
		}
	}

	/**
	* Sets the layout name to use
	*
	* @access	public
	* @param	string $template The template name.
	* @return	string Previous value
	* @since	1.5
	*/
	function setLayout($layout)
	{
		$this->_layout = $layout;

		return true;
	}

	/**
	 * Load a template file -- first look in the templates folder for an override
	 *
	 * @access	public
	 * @param string $tpl The name of the template source file ...
	 * automatically searches the template paths and compiles as needed.
	 * @return string The output of the the template script.
	 */
	function loadTemplate( $layout = null)
	{
		global $mainframe, $option;

		// clear prior output
		$this->_output = null;

		$file = isset($layout) ? $layout : $this->_layout;
		
		// clean the file name
		$file = preg_replace('/[^A-Z0-9_\.-]/i', '', $file);

		// load the template script
		$this->_filename = JPath::find($this->themePath, $file.'.php');

		if ($this->_filename != false)
		{
			// unset so as not to introduce into template scope
			unset($tpl);
			unset($file);

			// never allow a 'this' property
			if (isset($this->this)) {
				unset($this->this);
			}

			// start capturing output into a buffer
			ob_start();
			// include the requested template filename in the local scope
			// (this will execute the view logic).
			include $this->_filename;

			// done with the requested template; get the buffer and
			// clear it.
			$this->_output = ob_get_contents();
			ob_end_clean();

			return $this->_output;
		}
		else {
			return JError::raiseError( 500, 'Layout "' . $file . '" not found' );
		}
	}

	/**
	 * Gets the parameter object for the component
	 *
	 * @access public
	 * @param string $name The component name
	 * @return object A JParameter object
	 */
	function &get( $name, $default=0 )
	{
		static $instances;
		if (!isset( $instances[$name] ))
		{
			$instances[$name] = $this->_themeParams->get($name, $default);
		}
		return $instances[$name];
	}

	/**
	 * Method to get the theme's name
	 *
	 * @access	public
	 * @return	string The name of the model
	 * @since	1.0.4
	 */
	function getName()
	{
		if (!$this->_themeName)
		{
			$query = 'SELECT name, attribs'
					. ' FROM #__bloggies_themes'
					. ' WHERE is_default = 1'
					;
			$this->_db->setQuery( $query );
			$theme = $this->_db->loadObject();
			
			//Ensure there is a theme set
			if(!empty($theme)){
				$this->_themeParams = new JParameter($theme->attribs);
				$this->_themeName 	= strtolower($theme->name);
			}else{
				$this->_themeParams = new JParameter();
				$this->_themeName 	= 'default';
			}
			
			//Set themes URL & Path
			$this->themeURL 	= JURI::base().'components/com_lyftenbloggie/addons/themes/'.$this->_themeName;
			$this->themePath 	= JPATH_SITE.DS.'components'.DS.'com_lyftenbloggie'.DS.'addons'.DS.'themes'.DS.$this->_themeName.DS;
		}

		return $this->_themeName;
	}

	/**
	* Method to get the default theme
	**/
	function setHeader()
	{
		static $headerAdded;

		if(!$headerAdded)
		{
			$document =& JFactory::getDocument();

			//Add CSS file
			if(file_exists($this->themePath.'css'.DS.'style.css')) {
				$document->addStyleSheet(COM_LYFTENBLOGGIE_ASSETS.'/css/layout.css');
				$document->addStyleSheet($this->themeURL.'/css/style.css');
			}else{
				return JError::raiseError( 500, 'Theme "' . $this->_themeName . '" not found' );
			}
			
			$headerAdded = true;
		}
		return true;
	}

	/**
	 *	Creates a template variable. If a param already exists it will be
	 *	overwritten
	 *
	 *	@param String $key the name of the variable
	 *	@param String $val the value of the variable
	 *	@return mixed a reference to the new template variable
	 */
	function addData( $key, &$val )
	{
		if (is_string($key) && substr($key, 0, 1) != '_')
		{
			$this->$key =& $val;
			return true;
		}
		return false;
	}

	/**
     * Escapes a value for output in a view script.
     *
     * If escaping mechanism is one of htmlspecialchars or htmlentities, uses
     * {@link $_encoding} setting.
     *
     * @param  mixed $var The output to escape.
     * @return mixed The escaped value.
     */
    function escape($var)
    {
        if (in_array($this->_escape, array('htmlspecialchars', 'htmlentities'))) {
            return call_user_func($this->_escape, $var, ENT_COMPAT, $this->_charset);
        }

        return call_user_func($this->_escape, $var);
    }

	/**
	 *	Returns HTML
	 *
	 *	@return mixed 
	 */
	function display()
	{
		//Set Headers
		$this->setHeader();

		return $this->loadTemplate();
	}

}