<?php
/**
 * jQuery Class - Just Simple
 *
 * @version 0.1
 * @created Fri Oct 09 11:00:27 EST 2009
 *
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/

// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

class JQuery
{
	var $_idList	= array();
	var $response	= array( 'a' => array(), 'q' => array() );

	/**
	 * jQuery Effects
	 **/
	function effect($name,$element,$options=null)
	{
		//Initialize Arrays
		$effect		='';
		$speed    	= isset($options['speed'])?(is_numeric($options['speed'])?$options['speed']:'"'.$options['speed'].'"'):'"normal"';
		$callback 	= (isset($options['callback']))?',function(){'.$options['callback'].'})':')';
		
		//Determine effect
		switch($name) {
			case 'animate'	:
				$params = $this->_javascriptOptions($options,array('hide','show','toggle'));
				$effect ='jQuery("'.$element.'").animate({'.$params.'},'.$speed.','.(isset($options['easing'])?'"'.$options['easing'].'"':'"linear"').$callback;
				break;
			case 'fadeIn':
			case 'fadeOut':
			case 'slideDown':
			case 'slideToggle':
			case 'slideUp':
				$effect = 'jQuery("'.$element.'").'.$name.'('.$speed.$callback;
				break;
			case 'hide':
			case 'show':
			case 'toggle':
				$effect = 'jQuery("'.$element.'").'.$name.'()';
				break;
			case 'fadeTo':
				$effect = 'jQuery("'.$element.'").fadeTo('.$speed.','.$options['opacity'].$callback;
				break;
		}
		
		$this->addAction($effect);
	}

	/**
	 * jQuery Show
	 **/
	function show($id)
	{
		return $this->effect('show',$id);
	}

	/**
	 * jQuery Toggle
	 **/
	function toggle($id)
	{
		return $this->effect('toggle',$id);
	}

	/**
	 * jQuery Hide
	 **/
	function hide($id)
	{
		return $this->effect('hide',$id);
	}

	/**
	 * jQuery Manipulation
	 *
	 * @functions: html, text, append, appendTo, prepend, wrap, wrapAll, wrapInner
	 *             prependTo, after, before, insertAfter, insertBefore, replaceWith
	 *             replaceAll
	 **/
	function manipulate($position,$id,$html)
	{
		//Initialize Arrays
		$method = array();
		$args = array();
		
		//Set Arrays
		$method[] 	= $position;
		$args[] 	= $html;

		$this->addQuerie($id, $method, $args);
	}

	/**
	 * jQuery Replace
	 **/
	function replace($id,$html,$type='html')
	{
		$html_val= (($type=='html')?'"'.$html.'"':$html);
		$this->addAction('jQuery("'.$id.'").replace('.$html_val.')');
	}

	/**
	 * jQuery Remove
	 **/
	function remove($id,$expr=false)
	{
		$expr = (($expr)?'"'.$expr.'"':'');
		$this->addAction('jQuery("'.$id.'").remove('.$expr.')');
	}

	/**
	 * jQuery Empty
	 **/
	function clean($id)
	{
		$this->addAction('jQuery("'.$id.'").empty()');
	}

	/**
	 * Compile Response
	 * @return json encoded
	 **/
	function getResponse()
    {
		if(!function_exists('json_encode'))
			require_once (JPATH_COMPONENT.DS.'libraries'.DS.'json.php');

        echo json_encode($this->response);
        exit();
    }

	/**
	 * Add Action to Response
	 **/
	function addAction($code)
	{
		if(!$code) return;
		
		//Create Object
		$effectObj = new stdClass();
		$effectObj->foo = $code;
		
		//Store Object		
		$this->response['a']['evalScript'][] = $effectObj;
	}

	/**
	 * Add Querie to Response
	 **/
	function addQuerie($id, $method, $args)
	{
		if(!$id) return;
		
		//Create Object
		$effectObj = new stdClass();
		$effectObj->s = $id;
		$effectObj->m = $method;
		$effectObj->a = $args;
		
		//Store Object		
		$this->response['q'][] = $effectObj;
	}

	/**
	 * Create Javascript Options
	 * @return string
	 **/
	function _javascriptOptions($options,$constants=false)
	{
		$return_val='';
		
		if (is_array($options))
		{
			foreach ($options as $var=>$val)
			{
				if (!empty($return_val)) $return_val.=', ';
				if(!$constants)$return_val.="$var: $val";
				else  {
					$return_val.= $var.' : '.((in_array($val,$constants))?'"'.$val.'"':$val);
				}
			}
		}		
		return $return_val;
	}
	
}
