<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class LyftenBloggieModelComments extends JModel
{

	var $_entry 		= null;
	var $_tags 			= null;
	var $_id 			= null;
	var $_position 		= null;
	var $_return 		= null;
	
	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();
		
		global $mainframe;
		
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$limitstart	= JRequest::getInt('limitstart');
		$limit 		= $params->get('commentlistLimit', 5);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$id = JRequest::getVar('id', 0, '', 'int');
		$this->setId((int)$id);
	}

	/**
	 * Method to set the faq id
	 **/
	function setId($id)
	{
		// Set new faq ID
		$this->_id			= $id;
		$this->_entry		= null;
	}

	/**
	 * Overridden get method to get properties from the entry
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadEntry()) {
			if(isset($this->_entry->$property)) {
				return $this->_entry->$property;
			}
		}
		return $default;
	}
	
	/**
	 * Overridden set method to pass properties on to the entry
	 **/
	function set( $property, $value=null )
	{
		if ($this->_loadEntry()) {
			$this->_entry->$property = $value;
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Method to get data for the entry view
	 **/
	function &getEntry( )
	{
		/*
		* Load the entry data
		*/
		if ($this->_loadEntry())
		{
			$user	= & JFactory::getUser();

			// Do we have access to the category?
			if (($this->_entry->access > $user->get('aid')) && $this->_entry->catid)
			{
				JError::raiseError( 403, JText::_("ALERTNOTAUTH") );
			}
		}

		return $this->_entry;
	}

	/**
	 * Method to load required data
	 **/
	function _loadEntry()
	{
		if($this->_id == '0') {
			return false;
		}

		if (empty($this->_entry))
		{
			global $mainframe;

			$user			=& JFactory::getUser();
			$params 		= $mainframe->getParams('com_lyftenbloggie');
		
			$query = 'SELECT e.id, e.title, e.created, e.created_by, e.created_by, e.attribs, e.metadesc, e.metakey, e.metadata, e.metadata, e.access,'
			. ' u.name AS author, u.usertype, c.title as cattitle,'
			. ' CASE WHEN CHAR_LENGTH(e.alias) THEN CONCAT_WS(":", e.id, e.alias) ELSE e.id END as slug,'
			. ' CASE WHEN CHAR_LENGTH(c.slug) THEN c.slug ELSE 0 END as catslug'
			. ' FROM #__bloggies_entries AS e'
			. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
			. ' LEFT JOIN #__users AS u ON u.id = e.created_by'
			. ' WHERE e.id = '.$this->_id
			;
			$this->_db->setQuery($query);
			$this->_entry = $this->_db->loadObject();
			
			$pparams						= new JParameter($this->_entry->attribs);
			$this->_entry->cattitle 		= ($this->_entry->cattitle)?$this->_entry->cattitle:JText::_('UNCATEGORIZED');
			$this->_entry->catslug 			= ($this->_entry->catslug)?$this->_entry->catslug:strtolower(JText::_('UNCATEGORIZED'));
			$this->_entry->allowComments	= $pparams->get('allow_comments');
			$this->_entry->archive			= (!empty($this->_entry)) ? JHTML::_('date',  $this->_entry->created, '&year=%Y&month=%m&day=%d') : '';
			$this->_entry->CommentReport	= $params->get('allowReport');
			
			return (boolean) $this->_entry;
		}
		return true;
	}
	
	/**
	 * Method to get data
	 **/
	function getComments()
	{
		global $mainframe;

		// Lets load the files if it doesn't already exist
		if (empty($this->_data))
		{
			$params	= & $mainframe->getParams('com_lyftenbloggie');
			$query 	= $this->_buildCommentQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
			$n = count($this->_data);
			for($i=0; $i<$n; $i++)
			{
				//Checks comment type (1=user, 2=trackback)
				if($this->_data[$i]->type == 2) {
					$this->_data[$i]->avatar = COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';
				}else{
					$this->_data[$i]->avatar = LDHTML::genAvatarURL($this->_data[$i]->user_id, $params->get('avatarUsed', 'default') );
				}
			}
		}
			
		return $this->_data;
	}
	
	/**
	 * Method to get the total
	 **/
	function getTotal()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildCommentQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}
	
	/**
	 * Method to get a pagination object
	 **/
	function getPagination()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	/**
	 * Method to build the query
	 **/
	function _buildCommentQuery()
	{
		$query = 'SELECT c.*, u.name AS poster'
					. ' FROM #__bloggies_comments AS c'
					. ' LEFT JOIN #__bloggies_authors AS a ON a.user_id = c.user_id'
					. ' LEFT JOIN #__users AS u ON u.id = c.user_id'
					. ' WHERE c.entry_id = '. $this->_entry->id
					. ' AND state = 1'
					. ' ORDER BY c.date DESC'
					;
		return $query;
	}

	/**
	 * Method to store comment
	 **/
	function store($data)
	{
		global $mainframe;

		//initialize variables
		$params 		= & $mainframe->getParams('com_lyftenbloggie');
		$user			= & JFactory::getUser();	
		$userid			= $user->get('id');	
		$entryid 		= (int)$data['id'];	
		$datenow 		= & JFactory::getDate();
		$date			= $datenow->toMySQL();
		$error			= false;

		//Verify Post Data
		$comment 		= (isset($data['comment']) && $data['comment'] != 'Comment') 			? $data['comment'] 	: '';
		$website 		= (isset($data['website']) && $data['website'] != 'Website (optional)') ? $data['website'] 	: '';
		$email 			= (isset($data['email']) && $data['email'] 	!= 'Email (optional)') 		? $data['email'] 	: '';

		// Handle Captcha
		if($params->get('enableCaptcha')){
			if(!$captcha = EntriesHelper::checkCaptcha()) {
				JError::raiseNotice('SOME_ERROR_CODE', JText::_('CAPTCHA CODE IS INCORRECT'));
				$error = true;
			}
		}
		
		if($user->guest){
			JError::raiseNotice('SOME_ERROR_CODE', JText::_('YOU NEED TO BE LOGGED IN TO COMMENT'));
			$error = true;
		}
		if(!$entryid){
			JError::raiseNotice('SOME_ERROR_CODE', JText::_('AN ERROR HAS OCCURRED'));
			$error = true;
		}
		if(!$comment){
			JError::raiseNotice('SOME_ERROR_CODE', JText::_('PLEASE ENTER A COMMENT'));
			$error = true;
		}
		
		//Return if errors
		if($error == true) {
			$this->_return = '&comment='.base64_encode($comment).'&website='.base64_encode($website).'&email='.base64_encode($email);
			return false;
		}

		//filter comment if enabled
		if($params->get( 'enableBadWord' )) {
			$comment = EntriesHelper::checkCommentPost($comment, $params);
		}

		$query = "INSERT INTO `#__bloggies_comments` SET `entry_id`='$entryid',`user_id`='$userid',`author_email`='$email',`author_url`='$website',`content`='$comment',`type`='1',`date`='$date'";
		$this->_db->setQuery($query);
		if (!$this->_db->query()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		
		return true;
	}
	
	/**
	 * Method to store karma
	 **/
	function storeRating($id, $rating)
	{
		if ($rating == 1) {
			$rate = '+ 1';
		} elseif ($rating == 0) {
			$rate = '- 1';
		} else {
			return false;
		}

		$query = 'UPDATE #__bloggies_comments'
		.' SET karma = ( karma '.$rate.' )'
		.' WHERE id = '.(int)$id
		;
		$this->_db->setQuery($query);
		$this->_db->query();

		return true;
	}
}
?>