<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class LyftenBloggieModelEntry extends JModel
{

	var $_entry 		= null;
	var $_tags 			= null;
	var $_id 			= null;
	var $_author		= null;
	var $_position 		= null;
	
	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();
		
		global $mainframe;
		
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$limitstart	= JRequest::getInt('limitstart');
		$limit 		= $params->get('commentEntryLimit', 5);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		
		$id 	= JRequest::getVar('id', 0, '', 'int');
		$this->setId((int)$id);
	}

	/**
	 * Method to set the entry id
	 **/
	function setId($id)
	{
		$this->_id			= $id;
		$this->_entry		= null;
	}

	/**
	 * Overridden get method to get properties from the entry
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadEntry()) {
			if(isset($this->_entry->$property)) {
				return $this->_entry->$property;
			}
		}
		return $default;
	}
	
	/**
	 * Overridden set method to pass properties on to the entry
	 **/
	function set( $property, $value=null )
	{
		if ($this->_loadEntry()) {
			$this->_entry->$property = $value;
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Method to get data for the entry view
	 **/
	function &getEntry( )
	{
		global $mainframe;
		
		/*
		* Load the entry data
		*/
		if ($this->_loadEntry())
		{
			global $mainframe;
			$user	= & JFactory::getUser();

			//Check to see if the user is allowed
			if (($this->_entry->access > $user->get('aid')))
			{
				JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("ALERTNOTAUTH"));
				$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
			}
			$this->prepareEntry();
			
		}
		else
		{
			$user 	=& JFactory::getUser();
			$params = $mainframe->getParams('com_lyftenbloggie');
			$entry 	=& JTable::getInstance('entries', 'Table');
			if ($user->authorize('com_lyftenbloggie', 'state'))	{
				$entry->state = 1;
			}
			$entry->id					= 0;
			$entry->author				= null;
			$entry->created_by			= $user->get('id');
			$entry->text				= '';
			$entry->title				= null;
			$entry->meta_description	= '';
			$entry->meta_keywords		= '';
			$entry->modified 			= $this->_db->getNullDate();
			$entry->attribs				= "allow_comments=".($params->get('typeComments'))."\n";
			$this->_entry				= $entry;
		}

		return $this->_entry;
	}

	/**
	 * Method to load required data
	 **/
	function _loadEntry()
	{
		if($this->_id == '0') {
			return false;
		}

		if (empty($this->_entry))
		{
			$catView		= JRequest::getVar('category');

			$query = 'SELECT e.*, u.name AS author, u.usertype, c.title as cattitle,'
			. ' CASE WHEN CHAR_LENGTH(e.alias) THEN CONCAT_WS(":", e.id, e.alias) ELSE e.id END as slug,'
			. ' CASE WHEN CHAR_LENGTH(c.slug) THEN c.slug ELSE 0 END as catslug'
			. ' FROM #__bloggies_entries AS e'
			. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
			. ' LEFT JOIN #__users AS u ON u.id = e.created_by'
			. ' WHERE e.id = '.$this->_id
			;
			$this->_db->setQuery($query);
			$this->_entry = $this->_db->loadObject();

			$this->_entry->archive		= (!empty($this->_entry)) ? JHTML::_('date',  $this->_entry->created, '&year=%Y&month=%m&day=%d') : '';
			$this->_entry->archive		= ($catView) ? '&category='.$catView : $this->_entry->archive;
			
			return (boolean) $this->_entry;
		}
		return true;
	}
	
	/**
	 * Method to get all Categories
	 **/
	function getCategories()
	{
		if(!$this->_entry->catid)
		{
			$query = 'SELECT id' .
					' FROM #__bloggies_categories' .
					' WHERE `default` = 1';
			$this->_db->setQuery($query);
			$this->_entry->catid = $this->_db->loadResult();
		}
		
		$query = 'SELECT id, title' .
				' FROM #__bloggies_categories' .
				' ORDER BY ordering';
		$this->_db->setQuery($query);

		$category[] 	= JHTML::_('select.option', '0', JText::_('UNCATEGORIZED'), 'id', 'title');
		$categories 	= array_merge($this->_db->loadObjectList(), $category);
		$categories 	= JHTML::_('select.genericlist',  $categories, 'catid', 'class="inputbox" size="1"', 'id', 'title', intval($this->_entry->catid));	
		
		return $categories;
	}

	/**
	 * Method to get all Sections and Categories
	 **/	
	function getTagsList(){

		$alltags 	= $this->gettags();
		$used 		= $this->getusedtags($this->_entry->id);

		if(!is_array($used)){
			$used = array();
		}

		$tags = '';
		$n = count($alltags);
		for( $i = 0, $n; $i < $n; $i++ ){
			$tag = $alltags[$i];
			$tags .=  '<li><label><input id="tag[]" name="tag[]" type="checkbox" value="'.$tag->id.'"' . (in_array($tag->id, $used) ? 'checked="checked"' : '') . ' />'.$tag->name.'</label></li>';
		}

		return $tags;
	}
	
	/**
	 * Method to get all Sections and Categories
	 **/	
	function getTags(){
		$query = 'SELECT *'
				.' FROM #__bloggies_tags';
		$this->_db->setQuery($query);
		$tags = $this->_db->loadObjectList();
		return $tags;
	}
	
	/**
	 * Method to get all Sections and Categories
	 **/	
	function getUsedTags($id){
		
		$used = '';
		$query = 'SELECT DISTINCT tag'
				.' FROM #__bloggies_relations'
				.' WHERE entry='.$id;
		$this->_db->setQuery($query);
		$used = $this->_db->loadResultArray();
		return $used;
	}

	/**
	 * Method to increment the hit counter for the entry
	 **/
	function hit()
	{
		if ($this->_id)
		{
			$entry = & JTable::getInstance('entries', 'Table');
			$entry->hit($this->_id);
			return true;
		}
		return false;
	}

	/**
	 * Tests if entry is checked out
	 **/
	function isCheckedOut( $uid=0 )
	{
		if ($this->_loadEntry())
		{
			if ($uid) {
				return ($this->_entry->checked_out && $this->_entry->checked_out != $uid);
			} else {
				return $this->_entry->checked_out;
			}
		} elseif ($this->_id < 1) {
			return false;
		} else {
			JError::raiseWarning( 0, 'Unable to Load Data');
			return false;
		}
	}

	/**
	 * Method to checkin/unlock the entry
	 **/
	function checkin()
	{
		if ($this->_id)
		{
			$entry = & JTable::getInstance('entries', 'Table');
			return $entry->checkin($this->_id);
		}
		return false;
	}

	/**
	 * Method to checkout/lock the entry
	 **/
	function checkout($uid = null)
	{
		if ($this->_id)
		{
			// Make sure we have a user id to checkout the entry with
			if (is_null($uid)) {
				$user	=& JFactory::getUser();
				$uid	= $user->get('id');
			}
			// Lets get to it and checkout the thing...
			$entry = & JTable::getInstance('entries', 'Table');
			return $entry->checkout($uid, $this->_id);
		}
		return false;
	}
	
	/**
	 * Method to store the entry
	 **/
	function store($data)
	{
		$row  		=& JTable::getInstance('entries', 'Table');
		$user		= EntriesHelper::getAuthor();
		$cparams 	= & JComponentHelper::getParams('com_lyftenbloggie');

		// Bind the form fields to the table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		$created = $data['aa'].'-'.$data['mm'].'-'.$data['jj'].' '.$data['hh'].':'.$data['mn'].':00';

		// sanitise id field
		$row->id = (int) $row->id;

		$isNew = ($row->id < 1);

		if ($isNew)
		{
			$row->created 	= $created;
			$row->created_by 	= $user->user_id;
		}
		else
		{
			$row->modified 	= gmdate('Y-m-d H:i:s');
			$row->modified_by = $user->user_id;

			$query = 'SELECT hits, created, created_by, version' .
			' FROM #__bloggies_entries' .
			' WHERE id = '.(int) $row->id;

			$this->_db->setQuery($query);
			$result = $this->_db->loadObject();

			$row->hits 	= $result->hits;
			
			$row->created = $created;
			$row->created_by = $result->created_by;
			
			$row->version = $result->version;
			$row->version++;

			if (!$user->allowpub){
				$row->state = $result->state;
			}
		}

		// Set to pending if user is not allowed to publish
		if (!$user->allowpub)
		{
			$row->state = 2;
		}
		
		// Get parameter variables from the request
		$params		= JRequest::getVar( 'params', null, 'post', 'array' );		
		
		// Build parameter INI string
		if (is_array($params))
		{
			$txt = array ();
			foreach ($params as $k => $v) {
				$txt[] = "$k=$v";
			}
			$row->attribs = implode("\n", $txt);
		}

		// Get metadata string
		$metadata = JRequest::getVar( 'meta', null, 'post', 'array');
		if (is_array($metadata))
		{
			$txt = array();
			foreach ($metadata as $k => $v) {
				if ($k == 'description') {
					$row->metadesc = $v;
				} elseif ($k == 'keywords') {
					$row->metakey = $v;
				} else {
					$txt[] = "$k=$v";
				}
			}
			$row->metadata = implode("\n", $txt);
		}

		// Get a Tag variables from the request
		$tags 		= JRequest::getVar( 'tag', array(), 'post', 'array');

		$query = 'DELETE FROM #__bloggies_relations WHERE entry = '.$row->id;
		$this->_db->setQuery($query);
		$this->_db->query();

		foreach($tags as $tag)
		{
			$query = 'INSERT INTO #__bloggies_relations (`entry`, `tag`) VALUES('.$row->id.', '.$tag.')';
			$this->_db->setQuery($query);
			$this->_db->query();
		}
		
		// Prepare the entry for saving to the database
		require_once( JPATH_COMPONENT_ADMINISTRATOR.DS.'helper.php' );
		EntryHelper::saveEntryPrep( $row );

		// Make sure the data is valid
		if (!$row->check()) {
			$this->setError($row->getError());
			return false;
		}
		
		// Get trackback string
		$trackbacks = $data['trackbacks'];
		
		//Do that Pinginginginginging
		if ($trackbacks and $trackbacks != "")
		{
			//get ping class
			include_once JPATH_COMPONENT_SITE.DS.'helpers'.DS.'ping.php';

			// Bind the trackback link
			$slug 			= $row->id.':'.$row->alias;
			$archive 		= JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d');
			$row->pinged 	= BlogPing::doTrackback($trackbacks, $row, $archive, $slug);
		}

		// Ping Update services
		if ($cparams->get('useUpdateServices')) {
			include_once JPATH_COMPONENT_SITE.DS.'helpers'.DS.'ping.php';
			$services	= $cparams->get('updateServices');
			BlogPing::pingUpdate($services);
		}		
		
		// Store the article table to the database
		if (!$row->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		if ($isNew)
		{
			$this->_id = $row->_db->insertId();
		}

		$this->_entry			=& $row;
		$this->_entry->slug		=$this->_entry->id.':'.$this->_entry->alias;
		$this->_entry->archive	= JHTML::_('date',  $this->_entry->created, '&year=%Y&month=%m&day=%d');

		return true;
	}

	/**
	 * Method to remove
	 **/
	function delete($id)
	{		
		$user	= EntriesHelper::getAuthor();
		$action = array();

		if($user->user_id == 'no') {
			$action['task'] = 'error';
			$action['msg']	= JText::_('YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE');
			return $action;
		}	

		$query = 'SELECT id, title'
				.' FROM #__bloggies_entries'
				.' WHERE created_by = '.$user->user_id
				.' AND id = '.$id;
		$this->_db->setQuery($query);
		$entry = $this->_db->loadObject();
		
		if(empty($entry)) {
			$action['task'] = 'error';
			$action['msg']	= JText::_('YOU ARE NOT THE AUTHOR OF THIS ENTRY');
			return $action;
		}	
		
		if(!$user->allowdelete)
		{
			//get list of admins who receive system mails
			$query = 'SELECT id, email, name'
					.' FROM #__users'
					.' WHERE sendEmail = 1';
					
			$this->_db->setQuery($query);
			if (!$this->_db->query()) {
				$action['task'] = 'error';
				$action['msg']	= JText::_('UNABLE TO FIND ADMINS TO EMAIL');
				return $action;
			}
			$adminRows = $this->_db->loadObjectList();

			require_once (JPATH_ADMINISTRATOR.DS.'components'.DS.'com_messages'.DS.'tables'.DS.'message.php');

			// send email notification to admins
			foreach ($adminRows as $adminRow) {

				//Send a message to the admins personal message boxes
				$message = new TableMessage($this->_db);
				$message->send($user->user_id, $adminRow->id, JText::_('DELETE ENTRY'), JText::sprintf('MESS DELETE ENTRY', $user->username, $entry->title));
			}
			
			$query = 'UPDATE #__bloggies_entries'
					. ' SET state = 3'
					. ' WHERE id = '.$id;
			$this->_db->setQuery($query);
			if (!$this->_db->query()) {
				$action['task'] = 'error';
				$action['msg']	= JText::_('UNABLE CHANGE STATE OF ENTRY');
				return $action;
			}
			
			$action['task'] = 'change';
			$action['msg']	= JText::_('ENTRY SET PENDING DELETION');
			return $action;			
		}	
	
		$query = 'DELETE FROM #__bloggies_entries'
				. ' WHERE id = '. $id;

		$this->_db->setQuery( $query );
		if(!$this->_db->query()) {
			$action['task'] = 'error';
			$action['msg']	= $this->_db->getErrorMsg();
			return $action;
		}

		$query = 'DELETE FROM #__bloggies_relations'
				.' WHERE entry = '. $id;
		$this->_db->setQuery($query);
		if(!$this->_db->query()) {
			$action['task'] = 'error';
			$action['msg']	= $this->_db->getErrorMsg();
			return $action;
		}

		$action['task'] = 'remove';
		return $action;
	}
	
	/**
	 * Clean up all entries for tge display
	 **/
	function prepareEntry()
	{
		global $mainframe;

		// Get the page/component configuration
		$params 		= $mainframe->getParams('com_lyftenbloggie');
		$addThisPubId 	= $params->get('addThisPubId');
		$user			= EntriesHelper::getAuthor();
		$pparams		= new JParameter($this->_entry->attribs);	
	
		// Change all relative url to absolute url
		$this->_entry->introtext 		= str_replace('src="images', 'src="'. JURI::base() .'/images', $this->_entry->introtext);
		$this->_entry->fulltext  		= str_replace('src="images', 'src="'. JURI::base() .'/images',  $this->_entry->fulltext);
		
		$this->_entry->cattitle 		= ($this->_entry->cattitle)?$this->_entry->cattitle:JText::_('UNCATEGORIZED');
		$this->_entry->catslug 			= ($this->_entry->catslug)?$this->_entry->catslug:strtolower(JText::_('UNCATEGORIZED'));
		$this->_entry->author			= EntriesHelper::getAuthor($this->_entry->created_by);
		$this->_entry->category	 		= EntriesHelper::getCatLinks($this->_entry->catid, true);
		$this->_entry->tags		 		= EntriesHelper::getTagLinks($this->_entry->id, true);
		$this->_entry->created			= JHTML::_('date',  $this->_entry->created, '%B %d, %Y');
		$this->_entry->bookmarks		= EntriesHelper::getBookmarks($this->_entry, 0, $addThisPubId);
		$this->_entry->allowComments	= $pparams->get('allow_comments');
		$this->_entry->CommentReport	= $params->get('allowReport');
		$this->_entry->trackback		= (!$params->get('allowTrackbacks', 1)) ? '' : JRoute::_('index.php?option=com_lyftenbloggie&task=trackback'.$this->_entry->archive.'&id='. $this->_entry->slug);

		//check if we have an id(edit) and check if we have global edit rights or if we are allowed to edit own entrys.
		$this->_entry->editable = ( (($this->_entry->id > 0) && ($this->_entry->created_by == $user->user_id)) || $user->admin );

		//check session if uservisit already recorded
		$session 	=& JFactory::getSession();
		$hitcheck = false;
		if ($session->has('hit', 'lyftenbloggie')) {
			$hitcheck 	= $session->get('hit', 0, 'lyftenbloggie');
			$hitcheck 	= in_array($this->_entry->id, $hitcheck);
		}
		if (!$hitcheck) {
			//record hit
			$this->hit();
			$stamp = array();
			$stamp[] = $this->_entry->id;
			$session->set('hit', $stamp, 'lyftenbloggie');
		}
			
		// Setup text
		$this->_entry->text = $this->_entry->introtext.$this->_entry->fulltext;	

		//$avatar	= new $avatar($this->_entry->created_by);
		//$this->_entry->avatar	= $avatar->get();
		
	
		// Clean up the final text
		$this->_entry->text 	= str_replace(array('{mosimage}', 
			'{mospagebreak}', 
			'{readmore}'), '', $this->_entry->text);
	}
	
	/**
	 * Method to get data
	 **/
	function getComments()
	{
		global $mainframe;
		
		// Lets load the files if it doesn't already exist
		if (empty($this->_data))
		{
			$params 	= $mainframe->getParams('com_lyftenbloggie');
		
			$query = $this->_buildCommentQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
			
			$n = count($this->_data);
			for($i=0; $i<$n; $i++)
			{
				//Checks comment type (1=user, 2=trackback)
				if($this->_data[$i]->type == 2) {
					$this->_data[$i]->avatar = COM_LYFTENBLOGGIE_ASSETS.'/avatars/default.png';
				}else{
					$this->_data[$i]->avatar = LDHTML::genAvatarURL($this->_data[$i]->user_id, $params->get('avatarUsed', 'default') );
				}
			}
		}
			
		return $this->_data;
	}
	
	/**
	 * Method to get the total
	 **/
	function getTotal()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildCommentQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}
	
	/**
	 * Method to get the total
	 **/
	function getCreated()
	{
		$month[] = JHTML::_('select.option',  '01', JText::_( 'JANUARY' ) );
		$month[] = JHTML::_('select.option',  '02', JText::_( 'FEBRUARY' ) );
		$month[] = JHTML::_('select.option',  '03', JText::_( 'MARCH' ) );
		$month[] = JHTML::_('select.option',  '04', JText::_( 'APRIL' ) );
		$month[] = JHTML::_('select.option',  '05', JText::_( 'MAY' ) );
		$month[] = JHTML::_('select.option',  '06', JText::_( 'JUNE' ) );
		$month[] = JHTML::_('select.option',  '07', JText::_( 'JULY' ) );
		$month[] = JHTML::_('select.option',  '08', JText::_( 'AUGUST' ) );
		$month[] = JHTML::_('select.option',  '09', JText::_( 'SEPTEMBER' ) );
		$month[] = JHTML::_('select.option',  '10', JText::_( 'OCTOBER' ) );
		$month[] = JHTML::_('select.option',  '11', JText::_( 'NOVEMBER' ) );
		$month[] = JHTML::_('select.option',  '12', JText::_( 'DECEMBER' ) );
		$month 	 = JHTML::_('select.genericlist', $month, 'mm', 'class="inputbox" size="1"', 'value', 'text', JHTML::_('date', $this->_entry->created, '%m') );
		
	$return =  $month.'<input id="jj" name="jj" value="'.JHTML::_('date', $this->_entry->created, '%d').'" size="2" maxlength="2" tabindex="4" type="text">, <input id="aa" name="aa" value="'.JHTML::_('date', $this->_entry->created, '%Y').'" size="4" maxlength="5" tabindex="4" type="text"> @ <input id="hh" name="hh" value="'.JHTML::_('date', $this->_entry->created, '%H').'" size="2" maxlength="2" tabindex="4" autocomplete="off" type="text"> : <input id="mn" name="mn" value="'.JHTML::_('date', $this->_entry->created, '%M').'" size="2" maxlength="2" tabindex="4" type="text">';
	
		return $return;
	}

	/**
	 * Method to get a pagination object
	 **/
	function getPagination()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	/**
	 * Method to build the query
	 **/
	function _buildCommentQuery()
	{
		$query = 'SELECT c.*, u.name AS poster'
					. ' FROM #__bloggies_comments AS c'
					. ' LEFT JOIN #__users AS u ON u.id = c.user_id'
					. ' WHERE c.entry_id = '. $this->_entry->id
					. ' AND state = 1'
					. ' ORDER BY c.date DESC'
					;
		return $query;
	}
}
?>