<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class LyftenBloggieModelLyftenBloggie extends JModel
{
	var $_data 			= null;
	var $_total 		= null;
	var $_searchby		= null;
	var $_position		= null;
	var $_addThisPubId	= null;
	var $_imageLocation	= null;
	var $_tag			= null;
	var $_category		= null;
	var $_author		= null;

	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();

		global $mainframe;
		//set limits
		$params 			= $mainframe->getParams('com_lyftenbloggie');
		$limit 				= $params->get('entrylistLimit');
		$limitstart			= JRequest::getInt('limitstart');
		$this->_tag			= JRequest::getVar( 'tag' );
		$this->_category	= JRequest::getVar( 'category' );
		$this->_author		= JRequest::getVar( 'author' );

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);		
		
		
		if ($this->_category != '') {
				$category = strval(urldecode($this->_category));
				$category = str_replace("+", " ", $category);
				$this->_searchby['category'] = $category;
		}

		//Get Year/Month/Day
		$year 		= JRequest::getInt('year');
		$month 		= JRequest::getInt('month');
		if ($year && $month) {
			$this->_searchby['archive']['year']		= $year;
			$this->_searchby['archive']['month']	= $month;
			$this->_searchby['archive']['day']		= JRequest::getInt('day');
		}
	}

	/**
	 * Method to get Data
	 **/
	function getData()
	{
		// Lets load the categories if it doesn't already exist
		if (empty($this->_data))
		{
			$this->_data = $this->_getList( $this->_buildQuery(), $this->getState('limitstart'), $this->getState('limit') );
			$this->_position = 1;
			array_walk($this->_data, array($this, '_prepareEntry') );
		}

		return $this->_data;
	}
	
	/**
	 * Method to build the Categories query
	 **/
	function _buildQuery()
	{
		// Get the WHERE, and ORDER BY clauses for the query
		$tags				= $this->_buildEntriesTags();
		$where				= $this->_buildEntriesWhere();
		
		$query = 'SELECT e.*, COUNT(c.entry_id) AS comcount,'
				.' CASE WHEN CHAR_LENGTH(e.alias) THEN CONCAT_WS(":", e.id, e.alias) ELSE e.id END as slug,'
				.' CASE WHEN CHAR_LENGTH(cat.slug) THEN cat.slug ELSE 0 END as catslug'
				.' FROM #__bloggies_entries AS e'
				.' LEFT JOIN #__bloggies_comments AS c ON c.entry_id = e.id'
				.' LEFT JOIN #__bloggies_categories AS cat ON cat.id = e.catid'
				.$tags
				.$where
				.' GROUP BY e.id'				
				.' ORDER BY e.created DESC'
				;
		return $query;
	}
	
	/**	
	 * Method to build the where clause of the query
	 **/
	function _buildEntriesTags()
	{
		return ($this->_tag)?' LEFT JOIN #__bloggies_tags AS t ON t.slug = '.$this->_db->Quote( $this->_db->getEscaped( $this->_tag, true ), false ).' LEFT JOIN #__bloggies_relations AS r ON r.tag = t.id':'';
	}
	
	/**
	 * Method to build the where clause of the query
	 **/
	function _buildEntriesWhere()
	{
		global $mainframe, $option;

		$user		= & JFactory::getUser();
		$gid 		= $user->get('aid');
		$authorid 	= isset($this->_searchby['authorid']) 	 ? $this->_db->getEscaped($this->_searchby['authorid']): "";
		$search 	= isset($this->_searchby['search']) 	 ? $this->_db->getEscaped($this->_searchby['search']): "";
		$archive 	= isset($this->_searchby['archive']) 	 ? $this->_searchby['archive']: "";

		//Set category
		if(isset($this->_searchby['category']) && $this->_searchby['category'] && ($this->_searchby['category'] != strtolower(JText::_('UNCATEGORIZED'))) ) 
		{
			$category 	= $this->_db->getEscaped($this->_searchby['category']);
			$where[] = 'e.catid = cat.id';
			$where[] = 'cat.title = \''.$category.'\'';
		}elseIf(isset($this->_searchby['category']) && $this->_searchby['category'] == strtolower(JText::_('UNCATEGORIZED'))){
			$category 	= strtolower(JText::_('UNCATEGORIZED'));
			$where[] 	= 'e.catid = 0';
		}

		$where[] = 'e.state=1';
		
		$where[] = "e.access <= " . $gid;
		
		if (!empty ($authorid) or $authorid == "0") {
			$where[] = 'e.created_by IN (' . $authorid . ')';
		}

		if (!empty ($search)) {
			$where[] = 'match (e.title,e.fulltext,e.introtext) against (\'' . $search . '\' in BOOLEAN MODE)\'';
		}
		
		if ($this->_tag) {
			$where[] = 'r.entry = e.id';
		}
		
		if ($this->_author) {
			$where[] = 'e.created_by = '.$this->_author;
		}
	
		if (!empty ($archive)) {
			if($archive['day']){
				$arDate = date("Y-m-d", strtotime($archive['year'].'-'.$archive['month'].'-'.$archive['day']));
				$where[] = 'DATE( e.created ) = ' . $this->_db->Quote( $arDate );
			}else{
				$where[] 	= 'e.created BETWEEN ' . $this->_db->Quote(date("Ym", strtotime($archive['year'].'-'.$archive['month'])).'00000000').' AND '.$this->_db->Quote(date("Ym", strtotime($archive['year'].'-'.$archive['month'].'+1 month')).'00000000');
			}
		}
		$where 		= ( count( $where ) ? ' WHERE ' . implode( ' AND ', $where ) : '' );

		return $where;
	}
	
	/**
	 * Total nr of Categories
	 **/
	function getTotal()
	{
		// Lets load the total nr if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}
	
	function _replaceParams($text, $url, $title, $desc)
	{
		$text = str_replace('***url***', str_replace("'", "", $url), $text);
		$text = str_replace('***url_encoded***', "' + encodeURIComponent('". str_replace("'", "", $url) ."') + '", $text);
		$text = str_replace('***title***', str_replace("'", "", $title), $text);
		$text = str_replace('***title_encoded***', "' + encodeURIComponent('". str_replace("'", "", $title) ."') + '", $text);
		$text = str_replace('***description***', str_replace("'", "", $desc), $text);
		$text = str_replace('***description_encoded***', "' + encodeURIComponent('". str_replace("'", "", $desc) ."') + '", $text);
		$text = str_replace('***imageDirectory***', $this->_imageLocation, $text);
		$text = str_replace('***bgcolor***', '#ffffff', $text);
		$text = str_replace('***addThisPubId***', $this->_addThisPubId, $text);
		
		return $text;
	}
	
	/**
	 * Get the feed data
	 **/
	function getFeed()
	{
		global $mainframe;
		
		$params 	= $mainframe->getParams('com_lyftenbloggie');
		$limit 		= $params->get('entrylistLimit');		
		
		$query = 'SELECT DISTINCT e.*, c.title AS cattitle, COUNT(com.entry_id) AS comcount, u.name as author, c.slug as catslug,'
		. ' CASE WHEN CHAR_LENGTH(e.alias) THEN CONCAT_WS(\':\', e.id, e.alias) ELSE e.id END as slug'
		. ' FROM #__bloggies_entries AS e'
		. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
		. ' LEFT JOIN #__users AS u ON u.id = e.created_by'
		. ' LEFT JOIN #__bloggies_comments AS com ON com.entry_id = e.id'
		. ' WHERE e.state=1'
		. ' GROUP BY e.created'				
		. ' ORDER BY e.created DESC'
		. ' LIMIT '. $limit
		;

		$this->_db->setQuery($query);
		$feed = $this->_db->loadObjectList();

		return $feed;
	}
	
	/**
	 * Get the feed data
	 **/
	function getCategoryInfo()
	{
		if(!$this->_category) return;

		if (strtolower($this->_category) == strtolower(JText::_('UNCATEGORIZED'))) return JText::_('UNCATEGORIZED');
		
		$query = 'SELECT title'
		. ' FROM #__bloggies_categories'
		. ' WHERE slug = '.$this->_db->Quote( $this->_db->getEscaped( $this->_category, true ), false )
		;
		$this->_db->setQuery($query);
		$category = $this->_db->loadResult();
		
		return $category;
	}
	
	/**
	 * Get the feed data
	 **/
	function getTagInfo()
	{
		if(!$this->_tag) return;
		
		$query = 'SELECT name'
		. ' FROM #__bloggies_tags'
		. ' WHERE slug = '.$this->_db->Quote( $this->_db->getEscaped( $this->_tag, true ), false )
		;
		$this->_db->setQuery($query);
		$tag = $this->_db->loadResult();
		return $tag;
	}
	
	/**
	 * Clean up all entries for tge display
	 **/
	function _prepareEntry(&$row, $key)
	{
		global $mainframe;

		// Get the page/component configuration
		$params 		= $mainframe->getParams('com_lyftenbloggie');
		$addThisPubId 	= $params->get('addThisPubId');
		$user			= EntriesHelper::getAuthor();
		$pparams		= new JParameter($row->attribs);
		$dispatcher		= & JDispatcher::getInstance();
		$template		= new TemplateEngine();
		$mainDisplay	= array();
		
		// Change all relative url to absolute url
		$row->introtext 	= str_replace('src="images', 'src="'. JURI::base() .'/images', $row->introtext);
		$row->fulltext  	= str_replace('src="images', 'src="'. JURI::base() .'/images',  $row->fulltext);
		$created_by			= EntriesHelper::getAuthor($row->created_by);
		$row->author		= $created_by->username;
		$row->category	 	= EntriesHelper::getCatLinks($row->catid, true);
		$row->tags		 	= EntriesHelper::getTagLinks($row->id, true);
		$row->created_m		= JHTML::_('date',  $row->created, '%b');
		$row->created_d		= JHTML::_('date',  $row->created, '%d');
		$row->created		= JHTML::_('date',  $row->created, '%B %d, %Y');
		$archive 			= JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d');
		$row->archive		= ($this->_category) ? '&category='.$this->_category : $archive;
		$row->trackback		= (!$params->get('allowTrackbacks', 1)) ? '' : JRoute::_('index.php?option=com_lyftenbloggie&task=trackback'.$archive .'&id='. $row->slug);
		$row->bookmarks		= EntriesHelper::getBookmarks($row, $this->_position, $addThisPubId);
		$row->allowComments	= $pparams->get('allow_comments');

		//check if we have an id(edit) and check if we have global edit rights or if we are allowed to edit own entrys.
		$row->editable = ( ($row->id > 0 && $row->created_by == $user->user_id && $user->permission) || $user->admin);
	
		// Add readmore link if necessary
		$row->readmore	= '1';
		if($params->get('necessaryReadmore') == '1')
		{
			if($row->introtext && empty($row->fulltext) )
			{
				$position = -1;
				$count	  = 0;
				while( ( $position = strpos($row->introtext , '</p>' , $position + 1) ) !== false )
				{
					$count++;
				}

				if( $count <= $params->get('autoReadmorePCount') )
				{
					$row->readmore = '0';
				}
			}
			else
			{
				$position = -1;
				$count	  = 0;
				while( ( $position = strpos($row->fulltext , '</p>' , $position + 1) ) !== false )
				{
					$count++;
				}				
				if( $count <= $params->get('autoReadmorePCount') )
				{
					$row->readmore = '0';
				}
			}
		}
				
		if($params->get('useIntrotext')){
			if(empty($row->fulltext)){
				$ending = strpos($row->introtext, '</p>');
				
				$pos=-1;
				$pos_array = array();
				while (($pos=strpos($row->introtext,'</p>',$pos+1))!==false) 
					$pos_array[]=$pos;
				
				$pNum = $params->get('autoReadmorePCount');
				if (count($pos_array) <= $pNum) {
				   $row->text 		= $row->introtext;
				} else {
					$ending 		= $pos_array[$pNum-1];
					$row->introtext = substr($row->introtext, 0, $ending + 4);
					$row->introtext = EntriesHelper::cleanHTML(preg_replace('#\s*<[^>]+>?\s*$#','',$row->introtext));
				}
			}
			else if( !empty($row->fulltext) && empty($row->introtext) )
			{
				// Strip x paragraphs
				$ending = strpos($row->fulltext, '</p>');
				
				$pos=-1;
				$pos_array = array();
				while (($pos=strpos($row->fulltext,'</p>',$pos+1))!==false) 
				$pos_array[]=$pos;
				
				$pNum = $params->get('autoReadmorePCount');
				if (count($pos_array) <= $pNum) {
					$row->text 		= $row->fulltext;
				} else {
					$ending 		= $pos_array[$pNum-1];
					$row->fulltext 	= substr($row->fulltext, 0, $ending + 4);
					$row->fulltext 	= EntriesHelper::cleanHTML(preg_replace('#\s*<[^>]+>?\s*$#','',$row->fulltext));
				}
			}
			
			$row->text =( empty($row->introtext) )?$row->fulltext:$row->introtext;

		} else{

			$row->text = (empty($row->introtext))?$row->fulltext:$row->introtext;
		}

		// Clean up the final text
		unset($row->fulltext);
		$row->text 	= str_replace(array('{mosimage}', '{mospagebreak}', '{readmore}'), '', $row->text);

		//Add bookmarks badge
		if(isset($row->bookmarks['badge'])){
			$isPara = substr($row->text,0,3);
			if(strtolower($isPara) == "<p>") {
				$row->text = substr($row->text, 3);
			}
			
			$row->text = '<p><span class="bookmarkbadge">'.$row->bookmarks['badge'].'</span>'.$row->text;
		}

		//Get Main Image
		if($template->get('alignFirstIMG', 0)){
			$mainDisplay = EntriesHelper::getFirstImage($row->text);
		}

		if(!empty($mainDisplay)) {
			if($mainDisplay['type'] == 'image'){
				$row->text 		= $mainDisplay['text'];
				$row->mainImage = '<img src="'.$mainDisplay['src'].'" alt="'.$row->title.'">';
			}else{
				$row->text 		= $mainDisplay['text'];
				$row->mainImage = $mainDisplay['src'];
			}
		}else{
			$row->mainImage = '<img src="'.$template->themeURL.'/images/default_entry.png" alt="'.$row->title.'">';
		}

		// Process the prepare content plugins
		JPluginHelper::importPlugin('content');
		$results = $dispatcher->trigger('onPrepareContent', array (& $row, & $params, $this->getState('limitstart')));

		// Handle display events
		$row->event = new stdClass();
		$results = $dispatcher->trigger('onAfterDisplayTitle', array ($row, &$params, $this->getState('limitstart')));
		$row->event->afterDisplayTitle = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onBeforeDisplayContent', array (& $row, & $params, $this->getState('limitstart')));
		$row->event->beforeDisplayContent = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onAfterDisplayContent', array (& $row, & $params, $this->getState('limitstart')));
		$row->event->afterDisplayContent = trim(implode("\n", $results));

		$this->_position++;
	}
}
?>