<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

class LyftenBloggieModelMyEntries extends JModel
{

	var $_entries 		= null;
	var $_id 			= null;
	var $_position		= null;
	var $_allowed		= null;
	
	/**
	 * Constructor
	 **/
	function __construct()
	{
		parent::__construct();
		
		global $mainframe;

		//Ensures the user is the author
		$user =& JFactory::getUser();
		if($user->guest) return false;
		$this->_id = $user->get('id');

		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$limitstart	= JRequest::getInt('limitstart');
		$limit 		= $params->get('commentlistLimit', 5);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
	}

	/**
	 * Overridden get method to get properties from the entry
	 **/
	function get($property, $default=null)
	{
		if ($this->_loadEntry()) {
			if(isset($this->_entries->$property)) {
				return $this->_entries->$property;
			}
		}
		return $default;
	}
	
	/**
	 * Overridden set method to pass properties on to the entry
	 **/
	function set( $property, $value=null )
	{
		if ($this->_loadEntry()) {
			$this->_entries->$property = $value;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * Method to get data
	 **/
	function getMyEntries()
	{
		
		// Lets load the files if it doesn't already exist
		if (empty($this->_entries))
		{
			$query = $this->_buildEntriesQuery();
			$this->_entries = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
			array_walk($this->_entries, array($this, '_prepareEntry') );
		}
			
		return $this->_entries;
	}
	
	/**
	 * Method to get the total
	 **/
	function getTotal()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildEntriesQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}
	
	/**
	 * Method to get a pagination object
	 **/
	function getPagination()
	{
		// Lets load the files if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	/**
	 * Method to load required data
	 **/
	function _buildEntriesQuery()
	{
	
		$query = 'SELECT e.id, e.title, e.hits, e.state, e.created_by, e.catid, e.created, e.created_by, e.attribs, e.metadesc, e.metakey, e.metadata, e.metadata, e.access,'
			. ' c.title as cattitle, COUNT(com.id) as totalcoms,'
			. ' CASE WHEN CHAR_LENGTH(e.alias) THEN CONCAT_WS(":", e.id, e.alias) ELSE e.id END as slug,'
			. ' CASE WHEN CHAR_LENGTH(c.slug) THEN c.slug ELSE 0 END as catslug'
			. ' FROM #__bloggies_entries AS e'
			. ' LEFT JOIN #__bloggies_categories AS c ON c.id = e.catid'
			. ' LEFT JOIN #__bloggies_comments AS com ON com.entry_id = e.id'
			. ' LEFT JOIN #__bloggies_authors AS a ON a.user_id = e.created_by'
			. ' WHERE a.user_id = '.$this->_id
			.' GROUP BY e.id'				
			.' ORDER BY e.created DESC'
			;

		return $query;
	}

	/**
	 * Clean up all entries for tge display
	 **/
	function _prepareEntry(&$row, $key)
	{
		global $mainframe;

		// Get the page/component configuration
		$params 		= $mainframe->getParams('com_lyftenbloggie');
		$pparams		= new JParameter($row->attribs);	
		$catView		= JRequest::getVar('category');
		$user			= EntriesHelper::getAuthor();

		$row->category	 	= EntriesHelper::getCatLinks($row->catid, true);
		$row->tags		 	= EntriesHelper::getTagLinks($row->id, true);
		$row->created		= JHTML::_('date',  $row->created, '%B %d, %Y');
		$row->allowComments	= $pparams->get('allow_comments');
		$row->archive		= ($catView) ? '&category='.$catView : JHTML::_('date',  $row->created, '&year=%Y&month=%m&day=%d');

		//check if we have an id(edit) and check if we have global edit rights or if we are allowed to edit own entrys.
		$row->editable = ( (($row->id > 0) && ($row->created_by == $user->user_id)) || $user->admin );
		
		$this->_position++;
	}
}
?>