<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieViewEntry extends JView
{
	/**
	 * Creates the Entry page
	 **/
	function display( $tpl = null )
	{
		global $mainframe;

		//initialize variables
		$document 	= & JFactory::getDocument();
		$user		= & JFactory::getUser();
		$dispatcher = & JDispatcher::getInstance();
		$params 	= & $mainframe->getParams('com_lyftenbloggie');
		$uri     	=& JFactory::getURI();
		$template	= new TemplateEngine();

		// Get the menu item object
		$menus = &JSite::getMenu();
		$menu  = $menus->getActive();

		//Get Data data
		if (JRequest::getInt('year') && JRequest::getInt('month') && JRequest::getInt('day')) {
			$year 		= JRequest::getInt('year');
			$month 		= JRequest::getInt('month');
			$archive 	= JHTML::_('date', strtotime($year.'-'.$month), '%B %Y'); 
		}

		//Load route helper
		require_once (JPATH_SITE.DS.'components'.DS.'com_lyftenbloggie'.DS.'helpers'.DS.'route.php');

		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		$cid		= JRequest::getInt('cid', 0);

		if($this->getLayout() == 'form') {
			$this->_displayForm($tpl);
			return;
		}

		//get faq Entry data
		$entryData 	= & $this->get('Entry');

		//Assign Comment form
		if($entryData->allowComments) {
			$this->assign('action', $uri->toString());
		}
		
		$iparams	=& $entryData->attribs;
		$params->merge($iparams);
		
		if (($entryData->id == 0))
		{
			$id	= JRequest::getInt('id', 0);
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::sprintf( 'ENTRY BLANK NOT FOUND', $id ));
			$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
		}
		
		//pathway
		$pathway 	= & $mainframe->getPathWay();
		if(is_object($menu) && !isset($menu->query['category'])) {
			if(isset($archive)) {
				$pathway->addItem( $this->escape($archive), JRoute::_('index.php?option=com_lyftenbloggie&year='.$year.'&month='.$month.'&day=0'));
			}else{
				$pathway->addItem( $this->escape($entryData->cattitle), JRoute::_('index.php?category='.$entryData->catslug));
			}
		}
		$pathway->addItem( $this->escape($entryData->title), JRoute::_('index.php?view=entry&id='.$entryData->id));
		
		/*
		 * Handle the metadata
		 */
		if (is_object($menu)) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	$entryData->title);
			}
		} else {
			$params->set('page_title',	$entryData->title);
		}

		//Create the document
		$doc_title = $params->get( 'page_title' );
		
		$document->setTitle($doc_title);
		
		if ($entryData->metadesc) {
			$document->setDescription( $entryData->metadesc );
		}
		
		if ($entryData->metakey) {
			$document->setMetadata('keywords', $entryData->metakey);
		}
		
		if ($mainframe->getCfg('MetaTitle') == '1') {
			$mainframe->addMetaTag('title', $entryData->title);
		}
		
		if ($mainframe->getCfg('MetaAuthor') == '1') {
			$mainframe->addMetaTag('author', $entryData->author->username);
		}

		$mdata = new JParameter($entryData->metadata);
		$mdata = $mdata->toArray();
		foreach ($mdata as $k => $v)
		{
			if ($v) {
				$document->setMetadata($k, $v);
			}
		}

		// Process the prepare content plugins
		JPluginHelper::importPlugin('content');
		$results = $dispatcher->trigger('onPrepareContent', array (& $entryData, & $params, $limitstart));

		// Handle display events
		$entryData->event = new stdClass();
		$results = $dispatcher->trigger('onAfterDisplayTitle', array ($entryData, &$params, $limitstart));
		$entryData->event->afterDisplayTitle = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onBeforeDisplayContent', array (& $entryData, & $params, $limitstart));
		$entryData->event->beforeDisplayContent = trim(implode("\n", $results));

		$results = $dispatcher->trigger('onAfterDisplayContent', array (& $entryData, & $params, $limitstart));
		$entryData->event->afterDisplayContent = trim(implode("\n", $results));
		
		//No reason to look for comments if not using them
		if ($params->get('typeComments', '1') == '1') {
		
			//get comments
			$commentsData	= & $this->get('Comments');
			$pageNav 		= & $this->get( 'Pagination' );
			$totalcoms		= & $this->get('Total');
			$commentStyle	= $params->get('commentStyle', 0);

			//Set Theme Data
			$view	= '';
			$template->addData('commentsData' , 	$commentsData);
			$template->addData('pageNav' , 			$pageNav);
			$template->addData('totalcoms' , 		$totalcoms);
			$template->addData('entry' , 			$entryData);
			$template->addData('user' ,				$user);
			$template->addData('commentStyle' , 	$commentStyle);
			$template->addData('view' ,			 	$view);
		}

		//Set Theme Data
		$template->addData('entryData' , 	$entryData);
		
		//Set theme layout
		$template->setLayout('entry');

		//assign variables to template
		$this->assignRef('template' , 		$template);
		$this->assignRef('params' , 		$params);
		$this->assignRef('entryTitle' ,		$entry->title);
		$this->assignRef('entryID' ,		$entry->id);
		$this->assignRef('allowComments' ,	$entry->allowComments);
		
		parent::display($tpl);
	}
	
	/**
	 * Creates the entry submit form
	 **/
	function _displayForm($tpl)
	{
		global $mainframe;

		//Load pane behavior
		jimport('joomla.html.pane');

		//Initialize variables
		$document	=& JFactory::getDocument();
		$user		= EntriesHelper::getAuthor();
		$db  		= & JFactory::getDBO();
		$params		=& $mainframe->getParams('com_lyftenbloggie');
		$nullDate 	= $db->getNullDate();	
		$lists 		= array();
		$disabled	= '';
		$uri     	=& JFactory::getURI();
		$inMyEnt	= JRequest::getInt('myent');
		$template	= new TemplateEngine();

		// Must be logged in
		if ($user->user_id == 'no' && !$user->username) {
			$return		= $uri->toString();
			$url  		= 'index.php?option=com_user&view=login&return='.base64_encode($return);
			$mainframe->redirect( $url, JText::_("PLEASE LOGIN") );
		}

		//Add the js includes to the document <head> section
		JHTML::_('behavior.formvalidation');
		JHTML::_('behavior.tooltip');

		// fail if checked out not by 'me'
		$model			= & $this->getModel();
		$row     		= & $this->get( 'Entry' );

		// fail if checked out not by 'me'		
		if ($row->id) {
			if ($model->isCheckedOut( $user->user_id )) {
				JError::raiseWarning( 'SOME_ERROR_CODE', '<b>'.$row->title.'</b> '.JText::_( 'EDITED BY ANOTHER ADMIN' ));
				$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie&view=entry&id='.$row->id, false) );
			}
		}

		//check if we can edit an entry
		if( !$user->admin ) {
			if( !$user->permission) {
				JError::raiseWarning( 'SOME_ERROR_CODE', JText::_("YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE"));
				$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
			}elseIf($row->created_by != $user->user_id){
				JError::raiseWarning( 'SOME_ERROR_CODE', JText::sprintf('NOT THE AUTHOR', $row->title));
				$mainframe->redirect( JRoute::_('index.php?option=com_lyftenbloggie', false) );
			}
		}

		//Set theme
		$template->setHeader();

		//add header tags
		$document->addScript(JURI::base().'components/com_lyftenbloggie/assets/js/tabber.js');

		//add Java Declaration
		$js = "document.write('<style type=\"text/css\">.tabber{display:none;}<\/style>');";
		$document->addScriptDeclaration($js);
				
		//Get more data from the model
		$lists['catid']   	= & $this->get( 'Categories' );
		$lists['tags']		= & $this->get( 'TagsList' );	
		$lists['created']	= & $this->get( 'Created' );	
		
		// build the html for published		
		$states[] = JHTML::_('select.option',  '1', JText::_( 'PUBLISHED' ) );
		$states[] = JHTML::_('select.option',  '2', JText::_( 'PENDING REVIEW' ) );
		$states[] = JHTML::_('select.option',  '-1', JText::_( 'UNPUBLISHED' ) );
		$states[] = JHTML::_('select.option',  '3', JText::_( 'PENDING DELETION' ) );		
		if (!$user->allowpub) {
			$disabled 	= ' disabled="true"';
			$row->state = 2;
		}
		$lists['state'] = JHTML::_('select.genericlist', $states, 'state', 'class="inputbox" size="1"'.$disabled.'', 'value', 'text', $row->state );

		// build the html for access		
		$access[] = JHTML::_('select.option',  '0', JText::_( 'PUBLIC' ) );
		$access[] = JHTML::_('select.option',  '1', JText::_( 'REGISTERED' ) );
		$access[] = JHTML::_('select.option',  '2', JText::_( 'SPECIAL' ) );
		$lists['access'] = JHTML::_('select.genericlist', $access, 'access', 'class="inputbox" size="1"', 'value', 'text', $row->access );

		// Create the form
		$form = new JParameter('', JPATH_COMPONENT_ADMINISTRATOR.DS.'models'.DS.'entry.xml');
		
		// Advanced Group
		$form->loadINI($row->attribs);
		$form->loadINI($row->metadata);
		
		// Enabled/Disabled
		$enabled[] = JHTML::_('select.option',  '0', JText::_( 'DISABLED' ) );
		$enabled[] = JHTML::_('select.option',  '1', JText::_( 'ENABLED' ) );

		$lists['comments'] 		= ($params->get('typeComments')) ? JHTML::_('select.genericlist', $enabled, 'params[allow_comments]', 'class="inputbox" size="1"', 'value', 'text', $form->get('allow_comments') ) : '';
		$lists['ratings'] 		= JHTML::_('select.genericlist', $enabled, 'params[show_vote]', 'class="inputbox" size="1"', 'value', 'text', $form->get('show_vote') );
		$lists['hits'] 			= JHTML::_('select.genericlist', $enabled, 'params[show_hits]', 'class="inputbox" size="1"', 'value', 'text', $form->get('show_hits') );
		$lists['favourites'] 	= JHTML::_('select.genericlist', $enabled, 'params[show_favourites]', 'class="inputbox" size="1"', 'value', 'text', $form->get('show_favourites') );

		// Make trackback list
		if($row->pinged) {
			$pinged 		= trim($row->pinged);
			$row->pinged 	= explode("\n", $pinged);
		}
		
		//Load the Editor
		if(!$params->get( 'frontEditor', 0 ))
		{
			//include the needed helper
			require_once (JPATH_COMPONENT.DS.'helpers'.DS.'texteditor.php');
			$editor = new EntrieTextEditor($params->get('frontUploads', 0));
			
		}else{
			$editor =& JFactory::getEditor();
		}
		
		//Build the page title string
		$title = $row->id ? JText::_('EDIT ENTRY') : JText::_('NEW ENTRY');

		// Set page title
		// because the application sets a default page title, we need to get it
		// right from the menu item itself
		// Get the menu item object
		$menus = &JSite::getMenu();
		$menu  = $menus->getActive();
		$params->set( 'page_title', $params->get( 'page_title' ) );
		if (is_object( $menu )) {
			$menu_params = new JParameter( $menu->params );
			if (!$menu_params->get( 'page_title')) {
				$params->set('page_title',	$title);
			}
		} else {
			$params->set('page_title', $title);
		}
		$document->setTitle( $params->get( 'page_title' ) );
		
		//Set page title
		$document->setTitle($title);

		//get pathway
		$pathway =& $mainframe->getPathWay();
		$pathway->addItem($title, '');

		// Unify the introtext and fulltext fields and separated the fields by the readmore tag
		if (JString::strlen($row->fulltext) > 1) {
			$row->text = $row->introtext."<hr id=\"system-readmore\" />".$row->fulltext;
		} else {
			$row->text = $row->introtext;
		}

		//Ensure the row data is safe html
		JFilterOutput::objectHTMLSafe( $row );
		$this->assign('action'				, $uri->toString());
		$this->assignRef('form'				, $form);
		$this->assignRef('nullDate'			, $nullDate);		
		$this->assignRef('row'				, $row);
		$this->assignRef('params'			, $params);
		$this->assignRef('lists'			, $lists);
		$this->assignRef('title'			, $title);
		$this->assignRef('editor'			, $editor);
		$this->assignRef('inmyent'			, $inMyEnt);
		$this->assignRef('editType'			, $params->get( 'frontEditor', 0 ));
		
		parent::display($tpl);
	}
}
?>