<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class LyftenBloggieViewLyftenBloggie extends JView
{
	/**
	 * Creates the Forms for the View
	 **/
	function display( $tpl = null )
	{
		global $mainframe;

		//initialize variables
		$document 	= & JFactory::getDocument();
		$tag		= JArrayHelper::getValue( $_REQUEST, 'tag', 0 );
		$category	= JArrayHelper::getValue( $_REQUEST, 'category', 0 );
		$author 	= JRequest::getVar('author', 0, '', 'int');
		$template	= new TemplateEngine();

		// Get the menu item object
		$menus = &JSite::getMenu();
		$menu  = $menus->getActive();
		
		//Get Data data
		if (JRequest::getInt('year') && JRequest::getInt('month')) {
			$year 		= JRequest::getInt('year');
			$month 		= JRequest::getInt('month');
			$archive 	= JHTML::_('date', strtotime($year.'-'.$month), '%B %Y'); 
		}

		// Get the page/component configuration
		$params = $mainframe->getParams('com_lyftenbloggie');

		//Get Data
		$limitstart	= JRequest::getInt('limitstart');
		$limit 		= $params->get('entrylistLimit');
		$total		= $this->get('Total');
		$entries	= & $this->get('Data');
	
		/*
		* Handle the metadata for the entries list
		*/
		$document->setTitle($params->get('page_title'));
		$document->setMetadata( 'keywords' , $params->get('page_title') );

		if ($mainframe->getCfg('MetaTitle') == '1') {
				$mainframe->addMetaTag('title', $params->get('page_title'));
		}
				
		if ($params->get('useRSSFeed')) {
			//add alternate feed link
			if ($params->get('useRSS1')) {
				$document->addCustomTag( '<link href="'.JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('rss')).'" rel="alternate" type="application/rss+xml" title="RSS 1.0" />' );
			}
			if ($params->get('useRSS2')) {
				$document->addCustomTag( '<link href="'.JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('rss2')).'" rel="alternate" type="application/rss+xml" title="RSS 2.0" />' );
			}
			if ($params->get('useAtom')) {
				$document->addCustomTag( '<link href="'.JRoute::_(LyftenBloggieHelperRoute::getBlogFeedRoute('atom')).'" rel="alternate" type="application/atom+xml" title="Atom 1.0" />' );		
			}
		}

		//pathway
		$pathway 	= & $mainframe->getPathWay();
		$viewType 	= array();
		if($tag) {
			$viewType['type'] = 'tag';
			$viewType['text'] = $tag;
			$tagname = & $this->get('TagInfo');
			$tagname = ($tagname) ? $tagname : JText::_('NOT FOUND');
			$pathway->addItem( $this->escape($tagname), JRoute::_('index.php?option=com_lyftenbloggie&tag='.$tag));
		}
		if($category) {
			$viewType['type'] = 'category';
			$viewType['text'] = $category;
			$categoryname = & $this->get('CategoryInfo');
			if(is_object($menu) && !isset($menu->query['category'])) {
				$pathway->addItem( $this->escape($categoryname), JRoute::_('index.php?option=com_lyftenbloggie&category='.$category));
			}
		}
		if(isset($archive)) {
			$viewType['type'] = 'archiveurl';
			$viewType['text'] = $archive;
			$pathway->addItem( $this->escape($archive), JRoute::_('index.php?option=com_lyftenbloggie&year='.$year.'&month='.$month.'&day=0'));
		}
		if($author){
			$author_data = EntriesHelper::getAuthor($author);
			$viewType['type'] = 'author';
			$viewType['text'] = $author_data->username;
			$pathway->addItem( JText::_('AUTHORS') );
			$pathway->addItem( $this->escape($author_data->username), JRoute::_('index.php?option=com_lyftenbloggie&author='.$author));
		}
		
		// Create the pagination object
		jimport('joomla.html.pagination');

		$pageNav 	= new JPagination($total, $limitstart, $limit);

		//Set Theme Data
		$template->addData('params' , 			$params);
		$template->addData('entries' , 			$entries);

		//Set theme layout
		$template->setLayout('entries');
		
		//Send data to Joomla's view
		$this->assignRef('params' , 		$params);
		$this->assignRef('template' , 		$template);
		$this->assignRef('total' , 			count($entries));
		$this->assignRef('pageNav' , 		$pageNav);
		$this->assignRef('viewType' , 		$viewType);

		parent::display($tpl);
	}
}
?>