<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class LyftenBloggieViewMyDetails extends JView {

	function display($tpl = null)
	{
		global $mainframe;

		//initialise variables
		$document 	= & JFactory::getDocument();		
		$user 		= EntriesHelper::getAuthor();
		$uri     	= & JFactory::getURI();
		$params 	= & $mainframe->getParams('com_lyftenbloggie', '0');
		$avatarUsed	= $params->get('avatarUsed');
		$template	= new TemplateEngine();

		//Make sure user is logged it
		if (($user->user_id == 'no'))
		{
			$return		= $uri->toString();
			$url  		= 'index.php?option=com_user&view=login&return='.base64_encode($return);
			$mainframe->redirect($url, JText::_('PLEASE LOGIN TO EDIT YOUR DETAILS') );
		}
		
		//Load route helper
		require_once (JPATH_SITE.DS.'components'.DS.'com_lyftenbloggie'.DS.'helpers'.DS.'route.php');
	
		//Make sure author is there
		if (!$user->permission)
		{
				JError::raiseWarning( 'SOME_ERROR_CODE', JText::_( 'YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE' ));
				$mainframe->redirect( 'index.php?option=com_lyftenbloggie' );
		}

		//Set theme
		$template->setHeader();
		
		//Get Data
		$author		= & $this->get('Author');
		
		//pathway
		$pathway 	= & $mainframe->getPathWay();
		$pathway->addItem( JText::_('MY DETAILS'));
		
		//assign vars to view
		JFilterOutput::objectHTMLSafe( $row );
		
		$this->assign('action'			, $uri->toString());		
		$this->assignRef('author'      	, $author);
		$this->assignRef('user'      	, $user);
		$this->assignRef('avatarUsed'  	, $avatarUsed);

		parent::display($tpl);
	}
}
?>