<?php
/**
 * LyftenBloggie 1.0 - Joomla! Blog Manager
 * @package LyftenBloggie 1.0
 * @copyright (C) 2009 Lyften Designs
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.lyften.com/ Official website
 **/
 
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

/**
 * @package Joomla
 * @subpackage LyftenBloggie
 * @since 1.0
 */
class LyftenBloggieViewMyEntries extends JView
{
	/**
	 * Creates the comments page
	 **/
	function display( $tpl = null )
	{
		global $mainframe;

		//initialize variables
		$document 	= & JFactory::getDocument();
		$user 		= EntriesHelper::getAuthor();
		$uri     	=& JFactory::getURI();
		$template	= new TemplateEngine();
		
		//Make sure user is logged it
		if (($user->user_id == 'no'))
		{
			$return		= $uri->toString();
			$url  		= 'index.php?option=com_user&view=login&return='.base64_encode($return);
			$mainframe->redirect($url, JText::_('PLEASE LOGIN TO EDIT YOUR ENTRIES') );
		}
		
		//Load route helper
		require_once (JPATH_SITE.DS.'components'.DS.'com_lyftenbloggie'.DS.'helpers'.DS.'route.php');

		//Set theme
		$template->setHeader();

		//Make sure entry is there
		if (!$user->permission)
		{	
			JError::raiseWarning( 'SOME_ERROR_CODE', JText::_( 'YOU MUST BE AN AUTHOR TO VIEW THIS RESOURCE' ));
			$mainframe->redirect( 'index.php?option=com_lyftenbloggie' );
		}
		
		$entries		= & $this->get('MyEntries');
		$totalentries	= & $this->get('Total');
		$pageNav 		= & $this->get( 'Pagination' );
		
		/*
		 * Create the document title
		 **/
		$document->setTitle($user->username.'\'s '.JText::_('ENTRIES'));
		
		//pathway
		$pathway 	= & $mainframe->getPathWay();
		$pathway->addItem( $this->escape($user->username.'\'s '.JText::_('ENTRIES')) );

		//assign variables to template
		$this->assignRef('entries' , 		$entries);
		$this->assignRef('totalentries' , 	$totalentries);
		$this->assignRef('pageNav' ,		$pageNav);
		$this->assignRef('authorname' , 	$user->username);
		$this->assignRef('lists' , 			$lists);
		
		parent::display($tpl);

	}
}
?>