/*
 * Copyright 2005-2007 Gerald Schmidt.
 *
 * This file is part of Xml Copy Editor.
 *
 * Xml Copy Editor is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * Xml Copy Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Xml Copy Editor; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef HOUSESTYLEENGINE_H
#define HOUSESTYLEENGINE_H

#include <string>
#include <vector>
#include <set>
#include <map>
#include <utility>
#include <boost/shared_ptr.hpp>
#include "contexthandler.h"
#include "xmlrulereader.h"
#include "housestylereader.h"
#include "casehandler.h"

class HouseStyleEngine
{
	public:
		HouseStyleEngine (
			const std::string& ruleDirectoryParameter,
			const std::string& ruleFileParameter,
			const std::string& pathSeparatorParameter,
			int contextRangeParameter );
		~HouseStyleEngine();
		bool createReport( const std::vector<std::pair<std::string, unsigned> >& nodeVector );
		std::string getLastError();
		std::vector<ContextMatch> getMatchVector();
	private:
		int type;
		std::string
		buffer,
		ruleDirectory,
		ruleFile,
		pathSeparator,
		error;
		int contextRange;
		boost::shared_ptr<std::vector<boost::shared_ptr<Rule> > > ruleVector;
		std::vector<ContextMatch> matchVector;
		void collectRules (
		    string& fileName,
		    boost::shared_ptr<std::vector<boost::shared_ptr<Rule> > > ruleVector,
		    std::set<string>& excludeSet,
		    int *ruleCount );
		int updateRules();
};

#endif
