﻿<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="../tree-view.xsl"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes" />
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				<link rel="stylesheet" type="text/css" href="../default.css" />
				<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
				<title>House style report for <xsl:value-of select="/report/header/file" /></title>
			</head>
			<body>
				<h2>House style report for <xsl:value-of select="/report/header/file" /></h2>
				<xsl:variable name="href">../styles/<xsl:value-of select="/report/header/style" /></xsl:variable>
				<p class="heading">Style: <a href="{$href}"><xsl:value-of select="/report/header/style" /></a></p>
				
				<table>
					<tr><th align="right">No.</th><th>Problem</th><th>Suggestion</th><th>Comment</th></tr>
					<xsl:for-each select="//record">
						<tr>
							<td align="right"><xsl:value-of select="count" /></td>
							<td class="matchstyle"><font color="#E65B00"><xsl:value-of select="match" /></font></td>
							<td><xsl:value-of select="replacement" /></td>
							<td><xsl:value-of select="comment" /></td>
						</tr>
					</xsl:for-each>
				</table>
				<p class="heading"><br /><xsl:value-of select="/report/header/errors" /> potential problem(s)</p>
				<p class="heading"><a href="../index.php">Back to form</a></p>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
