<html>
<?php

error_reporting ( E_ALL );
	
$file = $tempFile = $style = $xpath = $format = $hiddenFile = $hiddenTempFile = "";
if (isset($_FILES['file'])) $file = $_FILES['file']['name'];
if (isset($_FILES['file'])) $tempFile = $_FILES['file']['tmp_name'];
if (isset($_POST['style'])) $style = $_POST['style'];
if (isset($_POST['xpath'])) $xpath = $_POST['xpath'];
if (isset($_POST['format'])) $format = $_POST['format'];

if (isset($_POST['hidden_files_file_name']) ) { $hiddenFile = $_POST['hidden_files_file_name']; }
if (isset($_POST['hidden_files_file_tmp_name'])) { $hiddenTempFile = $_POST['hidden_files_file_tmp_name']; }

$relTempDir = "./tmp";

if (!strlen ( $file ) && !strlen ( $tempFile )  && strlen ( $hiddenFile) && strlen ( $hiddenTempFile ) )
{
	$file = $hiddenFile;
	$tempFile = $hiddenTempFile;
}

$styleDirectory = "./styles/";
$formatDirectory = "./formats/";

$mtime = filemtime("index.php");
$mtimeString = date("F jS Y", $mtime);
$mtimeString = "Last modified " . $mtimeString;
	
function extractFilesFromDir ( $dir, $extension, $choice, $default )
{
	$dirHandle = opendir ( realpath ( $dir) );
	if ( $dirHandle )
	{
		$fileArray = array();
		while ( $myFile = readdir ( $dirHandle ) )
		{
			$fileArray[] = $myFile;
		}
		sort ( $fileArray );
		foreach ( $fileArray as $item)
		{
			if ( preg_match ("/\w+\." . $extension . "$/i", $item) )
			{
				$show = $item;
				$show = str_replace ( "_", " ", $show );
				$show = str_replace ( "." . $extension, "", $show );
				$insertion = itemSelection ( $choice, $item, $default );
				echo "<option value=\"" . $item . "\"" . $insertion . ">" . $show . "</option>";
			}
		}
	}
}

function itemSelection ( $choice, $item, $default )
{
	if (!strlen ( $choice ))
		return ($item == $default) ? " selected" : "";
	else
		return ($item == $choice) ? " selected" : "";
}

function purgeTempDir ( $dir )
{
	$dirHandle = opendir ( realpath ( $dir) );
	if ( $dirHandle )
	{
		$currentTime = time();
		$fileArray = array();
		while ( $myFile = readdir ( $dirHandle ) )
		{
			if ( ( strncmp ( $myFile, "hs", 2 ) ) ||
				! $fileTime = filemtime ( $dir . "/" . $myFile ) )
				continue;

			if ( $fileTime < $currentTime - 3600 )
			{
				unlink ( $dir . "/" . $myFile );
			}
		}
	}
}

?>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<link rel="stylesheet" type="text/css" href="default.css" />
		<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
		<title>
<?php
	if (strlen ($file) )
		{ echo $file . " - House Style"; }
	else { echo "House Style"; }
?>
	</title>
	</head>
<body>
<div id="header">
		<h1><a href="http://www.open.ac.uk"><img src="images/oulogo_hor.gif" alt="Open University logo" border="0" /></a>&nbsp;&nbsp;<a href="http://sourceforge.net/projects/housestyle/">House Style</a></h1>
</div>
<div id="menu">
	<ul>
		<li class="first"><a href="http://sourceforge.net/forum/forum.php?forum_id=813268">Help forum</a></li>
		<li><a href="https://sourceforge.net/users/gnschmidt/">Contact</a></li>
	</ul>
</div>
<div id="content">
<div id="columnA">
<?php

	purgeTempDir ( $relTempDir );
	print "<h2>House style check for XML documents</h2>";

	if (is_uploaded_file ( $tempFile ) || strlen ( $hiddenTempFile ))
	{
			$app = "./cgi-bin/housestyle";
			$rawOutputFile = tempnam ( $relTempDir, "hsr" );
			$formattedOutputFile = tempnam ( $relTempDir, "hsf" );

			echo "<p>Scanning " . $file . "...</p>";
			
			$xPathComponent = (!strlen ( $xpath ) ) ? "//text()" : $xpath;

			$command = realpath ( $app ) . " " .
					$tempFile . " " . 
					realpath ( $styleDirectory ) . "/ " .
					$style . " \"" .
					$xPathComponent . "\" " .
					realpath ( $formatDirectory . $format ) . " " .
					$rawOutputFile . " " .
					$formattedOutputFile . " " .
					$file; 

			echo "<p class=\"heading\">";
			$line = system ( $command, $return ); // automatic echo
			echo "</p>";
			

			if ( $return == 0 )
			{
				if ($format == "Default_format.xsl") // this is the only format to be displayed in the form
				{
						readfile ( $formattedOutputFile );
				}
				else
				{
					$extension = ( $format == "Data_only.xsl") ? ".xml" : ".html";
					$compositeFormattedOutputFile = $formattedOutputFile . $extension;
					system ( "mv " . $formattedOutputFile . " " . $compositeFormattedOutputFile );
					//echo "<p class=\"heading\"><a href=\"" . "tmp/" . basename ( $compositeFormattedOutputFile ) . "\">View report</a></p>";
					echo "<p class=\"heading\"><a href=\"" . $relTempDir . "/" . basename ( $compositeFormattedOutputFile ) . "\">View report</a></p>";
				}
			}
		
			else
			{
				//echo "<p>Command failed: " . $command . "</p>"; // debug
			}
			echo "<h2>Update form</h2>";
	}
?>
			<form enctype="multipart/form-data" action="index.php" method="post">
	<!--<p class="submitstyle"><input type="submit" value="View report" /></p>-->
	<p class="heading">Document to check
<?php
	if ( !strlen ( $file ) && !strlen ( $hiddenFile )  && isset ( $_FILES['file']) )
	{
		echo " <span class=\"matchstyle\"> (required field)</span>";
	}
	else if (strlen ( $file ) && strlen ( $tempFile ) )
	{
		echo " (leave blank for " . $file . ")";
		echo "<input type=\"hidden\" name=\"hidden_files_file_name\" value=\"" . $file . "\" />";
		$persistentTempFile = tempnam ( $relTempDir, "hsh" );
		system ( "cp " . $tempFile . " " . $persistentTempFile );
		echo "<input type=\"hidden\" name=\"hidden_files_file_tmp_name\" value=\"" . $persistentTempFile . "\" />";
		
	}

?>
				<br/>
				<!--<input type="hidden" name="MAX_FILE_SIZE" value="10240" />-->
				<input type="file" size="40" maxlength="127" name="file" />
		</p>
		<p class="heading">Using style<br/>
			<select size="1" maxlength="127" name="style" />
		
			<?php extractFilesFromDir ( $styleDirectory, "xml", $style, "Default_style.xml" ); ?>
			</select>
		</p>
	<p class="heading">Report format<br/>
		<select size="1" maxlength="127" name="format" />
			<?php extractFilesFromDir ( $formatDirectory, "xsl", $format, "Default_format.xsl" ); ?>
		</select>
	</p>
	<p class="heading">Document subset (leave blank for whole document)<br/>
	<input type="text" size="40" maxlength="127" name="xpath" value="<?php echo $xpath ?>" /></p>
	<p class="submitstyle"><br/>
		<input type="submit" value="Check document" />
	</p>
	</form>
</div>

<div id="columnB">
	<h2>Resources</h2>
	<p><a href="styles">Available styles</a></p>
	<p><a href="formats">Report formats</a></p>
	<p><a href="http://housestyle.svn.sourceforge.net/viewvc/housestyle/">Browse source code</a></p>
	</table>
</div>
	<div style="clear: both;">&nbsp;</div>
</div>
<div id="footer">
	<p><?php print $mtimeString; ?>. Web interface copyright &copy; 2008 The Open University. Source code copyright &copy; 2005&ndash;2008 Gerald Schmidt. Design based on a template by <a href="http://www.freecsstemplates.org" class="link1">Free CSS Templates</a>.</p>
</div>
  </body>
</html>
