$(function(){
	initFileEditor();
});
function initFileEditor(){
	initTabs();
	initHistory();
	initEditor();
}

function initEditor(){
	$('.ckEditor').each(function(){
		var selfBlockEditor = $(this);
		$('.editor:first',selfBlockEditor).each(function(){

			//calculate the editor height
			var iEditorHeight = (window.top.document.documentElement)?window.top.document.documentElement.clientHeight:$(window.top.document).outerHeight();
			iEditorHeight -= 350;
			iEditorHeight = (iEditorHeight>400)?iEditorHeight:400;
			
			if($.browser.safari) iEditorHeight -= 15;
			if($.browser.msie) iEditorHeight -= 10;

			CKEDITOR.instances.page_content && CKEDITOR.remove(CKEDITOR.instances.page_content);
			CKEDITOR.config.height=iEditorHeight;
			
			//page style
			current_page = $("input[name='page_path']",selfBlockEditor).val();
			CKEDITOR.config.contentsCss = SITE_URL+'ckeditor.css?page_path='+current_page;
			CKEDITOR.config.stylesCombo_stylesSet = 'my_styles:'+SITE_URL+'ckstyles.js';
			CKEDITOR.config.templates = 'mytpl';
			CKEDITOR.config.templates_files = [SITE_URL+'cktemplates.js'];
			
			
			var strHtml = $(this).val().replace(/mytextarea/gi,'textarea');
			$(this).val(strHtml);

			CKEDITOR.replace( this,{
					customConfig : SITE_URL+'ckconfig.js?page_path='+current_page,
					on:{
						instanceReady : function( ev ){
							window.top.oDialogAdmin && window.top.oDialogAdmin.dialog('resizeAuto');
			            	var rulesblock={
			            			indent : true,
			                        breakBeforeOpen : true,
			                        breakAfterOpen : true,
			                        breakBeforeClose : true,
			                        breakAfterClose : true
			                };
			                this.dataProcessor.writer.setRules( 'p',rulesblock);
			                this.dataProcessor.writer.setRules( 'div',rulesblock);
			                this.dataProcessor.writer.setRules( 'h1',rulesblock);
			                this.dataProcessor.writer.setRules( 'h2',rulesblock);
			                this.dataProcessor.writer.setRules( 'h3',rulesblock);
			                this.dataProcessor.writer.setRules( 'h4',rulesblock);
			                
			                var oBodyEditor = $(".ckEditor iframe").contents().find('body');
			                oBodyEditor.attr('id',this.config.bodyid);
						}
					}
			});

		});
	});
}	

function initTabs() {
	$("#tabPageEditor").tabs({
		show:function(ui){
			window.top.oDialogAdmin && !window.top.oDialogAdmin.dialog('isFullScreen') && window.top.oDialogAdmin.dialog('resizeAuto',false);
		}
	});
}

function initHistory(){
	/* tiroir historique */
	var oHistBlock = $(".panelHistory");
	if(oHistBlock.length > 0){
		var oEditor = $(".ckEditor");
		var openTab = $('<div class="openTabs"></div>');
		oHistBlock.before(openTab);
//		oHistBlock.css('display','none');
		var resizeEditorFrame = function (){
			oEditor.find('iframe:first').width(oEditor.width()-15);
		}
		$(".openTabs").toggle(function(){
			oHistBlock.css('display','block');
			oEditor.animate({width: oEditor.width()-201}, 'fast');
			$(this).css({"backgroundImage": "url(theme/images/admin/sidebar2.gif)"});
	
		},function(){			
			oEditor.animate({width: '100%'}, 'fast', function(){oHistBlock.css('display','none');} );
			$(this).css({"backgroundImage": "url(theme/images/admin/sidebar.gif)"});		
		});	
	}
}


/**
 * Callback call when the user click on the cancel button in the editor view
 */
function MyCancel(){
	//if user has clicked on the ctrl+e close the window
	if(tabMyBack.length<2){
		if(window.top != window){
			window.top.oDialogAdmin.dialog('close');
		}
	}else {
		myGoBack();	
	}
}


/**
 * This function is called each time an input text is modified in the config file editor view
 * It reset the hidden textarea before be saved
 */
function reloadFileConfigTextArea(formId){
	var strValue="";
	var oForm = $("#"+formId);
	$("[id^=field_]", oForm).each(function(iIndex){
		var self = $(this);
		if((strVal=self.attr("value"))==undefined)
			strVal="";
		strValue+=self.attr("name")+'="'+strVal+'"';
		strValue+="\n";
	});
	$("textarea#srcParams", oForm).attr("value",strValue);
}

function toggleShowConfigEditor(myForm){
	oTextArea = $('textarea#srcParams',myForm);
	oListParams = $('#listParams',myForm);
	
	if(!oTextArea.is(':visible')){
		reloadFileConfigTextArea($(myForm).attr('id'));
		oTextArea.css('height', oListParams.outerHeight()).slideDown('fast');
		oListParams.slideUp('fast');
	}
	else{
		oListParams.slideDown('fast');
		oTextArea.slideUp('fast');
	}
}
function actionClickOnSaveConfig(formId, strFile, strSection){
	
	var oForm=$("#"+formId);
	if(!$('textarea#srcParams', oForm).is(':visible'))
		reloadFileConfigTextArea(formId);
	
	var strTextValue = $('textarea#srcParams', oForm).attr("value");
	ajaxAction('saveconfigfile',{file:strFile,text:strTextValue,section:strSection},null,function(data){
		notify(data);
	});
	return false;
}

function actionClickOnSaveHtml(o, strUrl, strFile){
	reloadFileConfigTextArea("form_editor_config");

	//the config
	var strTextValueConfig = $('textarea',"#form_editor_config").attr("value");
	
	//get html text
	var bView= $('#'+o.id).find("input[name='view']").attr("value");
	var strEditorContent = CKEDITOR.instances.page_content.getData();
	
	ajaxAction('savepage',{file:strFile,text:strEditorContent,textConfig:strTextValueConfig},null,function(data){
		notify(data);
		(bView == "true") && setTimeout(function(){window.top.location=strUrl},1000);
	});
	return false;
}
/**
	Reload Html Editor from history
*/
function loadHistoryPage(strPage, myLink) {
	var oLink = $(myLink);
	var oEditor = CKEDITOR.instances.page_content;
	if(!oEditor) return;
	
	ajaxAction('loadhistorypage', {'strPage':strPage}, null, function(data){
			var strResultCode =  data.replace(/:.*$/,'').replace(/\n/g,'');
			var strResult =  data.replace(/^.*:/,'');
			if( strResultCode == "error" ){
				return msgBoxError(strResult);
			}
			oEditor.setData(data);
			oLink.parents('ul').find('a').removeClass('selected');
			oLink.addClass('selected');
	});	
}