//<?php
var myWinSelect = null;
var myMoveFile ='' ;

$(function(){
	initFileBrowser();
});

//all the functions needed by the file browser
function initFileBrowser(){

	initContextMenu();
	initSortable();
	initError();
	initFancyZoom();
	initRenameCursor();
	initMedias();
	initRender();

}

function initRender(){
	var objToRender = $('dl.render');
	var tabRender = new Array;
	objToRender.each(function(){
		tabRender[tabRender.length]=new renderObj($(this));
	});
	(tabRender.length>0) && renderElems(tabRender);
}

function renderOneElem(fileId){
	var objToRender=$('dl.file[id$="'+fileId+'"]');
	objToRender && (objToRender.length > 0) && objToRender.addClass('render') && initRender();
}

function renderObj(oDl){
	var oImg = $('img',oDl);
	var strImgSrc = oImg.attr('src');
	oImg.attr('src',SITE_URL+'core/admin/theme/images/admin/pageloader.gif');

	this.imgSrc = strImgSrc;
	this.obj = oDl;
	return this;
}

function renderElems(tabRender,iIndex){
	if(!iIndex) iIndex = 0;
	if(iIndex >= tabRender.length) return;

	var oRender = tabRender[iIndex];
	var oDl = oRender.obj;
	var strImgSrc = oRender.imgSrc;
	var oImg = $('img',oDl);
	
	ajaxAction('render_file',{id:oDl.attr('id'),size:oDl.metadata().thumb_size},null,function(data){
		if( data.length == 0 || $(data).is(".error") ){
			oImg.attr('src',strImgSrc);
			(data.length == 0) && msgBoxError(_('can not render the file '+oDl.attr('id')));
			$(data).is(".error") && msgBoxError($(data).html());
		}else{
			(data.length > 0) && oImg.attr('src',data);
		}
		oDl.removeClass('render');
		renderElems(tabRender,(iIndex+1));
	});	
}

function initFancyZoom(){
	if(!$.fn.fancyzoom)
		return;
	$.fn.fancyzoom.defaultsOptions.imgDir=SITE_URL+'vendors/jscripts/jqueryplugins/fancyzoom_images/';
	$('a','#browser').fancyzoom();
}

//This is the rename fonction
function initRenameCursor(){
	elBrowser=$("#browser:first, #listModels:first");
	if(elBrowser.size()>0 && elBrowser.is('.renamable') ){
		var opts = {
			indicator: _('Loading ...'),
			cssclass:'inputrename',
   			select:false,
   			onblur:'cancel',
  			height:'none',
   			width:80
		};
		$("dl[id^='filename']",elBrowser).find('dd').each(function(){
			var self=$(this);
			self.editable(
				function(value,settings){
					ajaxAction('renamefile',$.extend({'value':value},settings.submitdata));
				},$.extend(
					{
						submitdata:{filename:self.parent().attr('id').replace(/^filename=/,'')},
	   					data:function(self){return $(self).text();}
					},opts)
			);
		});
	}
}

function initMedias(){
	$(".media","#browser").click(function(){return play_media(this);});
}

function play_media(mediaLink){
	if(!$.fn.media)
		return true;
	
	var dlg = $('<div></div>')
		.append('<div style="text-align:center;margin-top:0px;"><center><a id="player" href='+mediaLink.href+'></a></center></div>')
		.dialog({
			title:_('Playing media'),
			label: _('Media'),
			position:'center',
			modal:true,
			autoOpen:false,
			width:400,
			buttons: {
				'Close':function(){dlg.dialog('close');}
			}
		})
		.bind('dialogclose',function(){$(this).dialog('destroy').remove()})
	;
	$('button:first',dlg.parents('.ui-dialog:first')).text(_('Close'));

	$.fn.media.defaults.flvPlayer = SITE_URL+'vendors/jscripts/jqueryplugins/jquerymedia/player.swf';
	$.fn.media.defaults.mp3Player = $.fn.media.defaults.flvPlayer;
	
	var opts = {
		params:{allowfullscreen:"true",allowscriptaccess:"always"},
		flashvars:{'autostart':true},
		width:380,
		height:380*3/4
	};
	if($(mediaLink).hasClass('audio')) {$('div:first',dlg).css('margin-top','20px');opts = $.extend({},opts,{height:20});}
	if($(mediaLink).hasClass('video')) {opts.flashvars = $.extend({},opts.flashvars,{'controlbar':'over'});}
	
	$("a",dlg).each(function(){
		var self = $(this);
		if( $(mediaLink).hasClass('video') ){
			ajaxAction('generate_videopreview',{fileid:$(mediaLink).parents('dl:first').attr('id')},null,function(data){
				self.attr('href',data).media(opts);
				dlg.dialog('open');
			});
		}else{
			self.media(opts);
			dlg.dialog('open');
		}
	});
	return false;
}

function initSortable(){
	var el = $("#browser,#listModels");
	//only apply sortable in file management not in file browser
	if(el.length > 0 && el.is('.sortable')){
		el.sortable({
			items:'dl',
			containment: el,
			revert: true,
			placeholder: 'ui-state-highlight',
			start:function(event, ui){
				bBeingSort=true;
			},
			stop:function(event,ui){
				bBeingSort=false;
			},
			update: function(e,ui){
				var strSort = $(this).sortable('serialize',{attribute:'id',expression:'(.+)[=](.+)'});
				msgStatus('Loading ....');
				$.ajax({
					url:'admin_ajax.php?action=sortpages&'+strSort,
					type:'GET',
					error:function(HTTPRequest, textStatus, errorThrown){msgBoxError($(HTTPRequest.responseText).html());},
					complete:function(){msgStatus();}
				});
			}
		});
	}
}


function initContextMenu(){
	var strIdentifier="context_menu_";
	var o = {
		theme:'osx',
		offsetX:-2,
		shadowWidthAdjust:8,
		shadowOffsetX:-4,
		shadowHeightAdjust:4,
		shadowOffsetY:0,
		shadowOpacity: 0.1,
		itemHoverClassName:'ui-state-hover'
	};
	$("dl.folder, dl.file",$("div.withcontextmenu")).each(function(){
		var objImg = $(this).find("img[id^='"+strIdentifier+"']");
		if(objImg.length==1){
			strMenuId = "menu_"+objImg.attr("id").substring(strIdentifier.length);
			objImg.contextMenu('#'+strMenuId,o);
		}
	});
	($("#menu_browser").length > 0) && $("#browser").contextMenu('#menu_browser',o);

}

function checkName($strName){
	if($strName == '')
		return _('Name can not be empty.');
	return true;
}

function createPage(strCurrDir,bUseModel){

	var winDlgCreatePage=$('<div><div style="padding:0px 10px"><input type="hidden" id="pagemodelselected" value="empty" />'+_('Page name:')+' <input type="text" value="" id="pageName" size="'+20+'"/></div><div id="listModels"></div>')
	var fctDialog = function(){
		winDlgCreatePage.dialog({
			title:_('Create a page'),
			label: _('Page name:'),
			modal:true,
			width:500,
			buttons: {
				'Ok': function() {
					var strPageName = $('input#pageName',this).val();
					var strPageModel = $("#pagemodelselected",this).val();
	
					if( (msg= checkName(strPageName))!==true){
						msgBoxError(msg);
						return false;
					}
					ajaxAction('createfile',{'CURRENT_DIR':strCurrDir,'NEW_FILE':strPageName,'PAGE_MODEL':strPageModel},$(this));
				},
				'Cancel':function(){
					
					$(this).dialog('destroy').remove();
				}
			}
		});
		var objDlg = winDlgCreatePage.parents('.ui-dialog:first');
		var btnOk = $('button:first',objDlg).text(_('Ok'));
		var btnCancel = $('button:last',objDlg).text(_('Cancel'));
		$('input',objDlg).focus().keypress(function (e) {
				var key = e.charCode ? e.charCode : e.keyCode ? e.keyCode : 0;
				(key == 13) && btnOk.trigger('click');
		});
	}
	if(bUseModel){
		var oListModels = $("#listModels",winDlgCreatePage);
		fctDialog();
		oListModels.html(_('Loading models ....'));
		ajaxAction('getpagemodelslist',{},null,function(data){
			if(data){
				var oData = $(data);
				$('a',oData).click(function(){
					var oDl = $(this).parents('dl:first');
					var bSelect = (oDl.hasClass('ui-state-highlight'))?false:true;
					//unselect all
					$('dl',oListModels).removeClass('ui-state-highlight');
					oDl.addClass('ui-state-highlight');
					bSelect && $("#pagemodelselected",winDlgCreatePage).val($(this).attr('href').replace(/.*#/,''));
					
					return false;
				});
				$('a.fileLink:first',oListModels.html(oData)).trigger('click');
				initRender();
			}else{
				oListModels.css('display','none');
			}
		});
	}else{
		$("#listModels",winDlgCreatePage).css('display','none');
		fctDialog();
	}
	//return false;	
}

function createDir(strCurrDir){
	inputDlg(_('Create a directory'),_('Directory name:'),function(value,dlg){
		if( (msg= checkName(value))!==true) {msgBoxError(msg);}
		else {
			ajaxAction('createdir',{'CURRENT_DIR':strCurrDir,'NEW_DIR':value},dlg);
		}
	});
}

function createLink(strCurrPage){
	ajaxAction('createlink',{'CURRENT_PAGE':encodeURIComponent(strCurrPage)});
}



function fileRenameAjax(idBlockFile){
	$("dl[id='"+idBlockFile+"']").find('dd').trigger('click');
}

function copy(strFileRelativePath,strFileName) {
	inputDlg(_('Copy'),_('Copy name :'),function(value, dlg){
			if( (msg= checkName(value))!==true) {msgBoxError(msg);}
			else {ajaxAction('copyfile',{'FILE_RELATIVE_PATH':encodeURIComponent(strFileRelativePath),'COPY_NAME':encodeURIComponent(value)},dlg);}				
			
		},
		null,_('copy')+' '+strFileName);
}
var selectorvar=null;
var oSelectTarget=null;
var oSelectRoot=null;

function move(strCurrFile, current_dir, rootpath) {
	selectorvar='move';
	myMoveFile = encodeURIComponent(strCurrFile);	
	myWinSelect=PopupCentrer("admin_file_selector.php?current_dir="+encodeURIComponent(current_dir)+"&rootpath="+encodeURIComponent(rootpath),800,600,'resizable=no, location=no, menubar=no, status=no, scrollbars=yes, menubar=no');
}
function selectFile(rootpath,objTarget){
	selectorvar='select';
	oSelectTarget = $(objTarget);
	oSelectRoot = rootpath;
	myWinSelect=PopupCentrer("admin_file_selector.php?rootpath="+encodeURIComponent(rootpath),800,600,'resizable=no, location=no, menubar=no, status=no, scrollbars=yes, menubar=no');
}
//use by move, this is the name of the function call by the file selector
function SetUrl(dest){
		if(selectorvar=='move')
		ajaxAction('movefile',{'FILE_RELATIVE_PATH':myMoveFile,'TARGET_DIR':encodeURIComponent(dest)});
		if(selectorvar=='select'){
			if( dest.indexOf(oSelectRoot) != -1 )
				dest = dest.substring(oSelectRoot.length+1,dest.length,dest);
			oSelectTarget.attr('value',dest);
		}
		selectorvar=null;
}

function resizeimage(strFilePath){
	inputDlg(_('Image Resize'),_('New Size (in px):'),function(value, dlg){
			if( (msg= checkName(value))!==true) {msgBoxError(msg);}
			else {ajaxAction('resizeimage',{'FILE_RELATIVE_PATH':encodeURIComponent(strFilePath),'NEW_SIZE':value},dlg);}		
		}
		,null,"800");
}

function deleteFile(strFileRelativePath, strFileName, type){
	confirmDlg(_('Do you really want to delete ')+type+' '+strFileName+' ?',function() { 
		ajaxAction('deletefile',{'FILE_RELATIVE_PATH':strFileRelativePath},$(this));
	});
}

function setPageConfigVar(strFileRelativePath, strVarName, value){
	ajaxAction('setpageconfigvar',{'FILE_RELATIVE_PATH':encodeURIComponent(strFileRelativePath),'VAR_NAME':strVarName,'VAR_VALUE':value});
}

//?>