<?php
if(!defined("PPAGEMODEL")){
define("PPAGEMODEL",1);
require(SITE_PATH.'core/lib/ppage.php');

/**
 * Class PPAGEMODEL.
 * This class is used to manipulate pages models.
 */

class PPageModel extends PPage {

	function PPageModel($strPath){
		parent::PPage($strPath);
	}
	
	function Display($thumb_size=120,$url=false,$oRootDir=false){
		return parent::Display($thumb_size,$url,$oRootDir);
	}
	
	function getMenuSpecificsItems(){
		$strMenu = '';
		if($this->getThumbFile(100))
			$strMenu .= "\n".'<div class="context-menu-item" onClick="renderOneElem(\''.str_replace(SLASH,'/',$this->getRelativePath()).'\');return false;">'._('Refresh render').'</div>';
		return $strMenu;
	}
	
	function getThumbUrl($thumb_size,$onlyContent=false){
		if(!$onlyContent)
			$onlyContent = !$this->isPageModel() && $this->isContentModel();
		return parent::getThumbUrl($thumb_size,$onlyContent);
	}
	function getThumbFile($thumb_size,$onlyContent=false){
		if(!$onlyContent)
			$onlyContent = !$this->isPageModel() && $this->isContentModel();
		return parent::getThumbFile($thumb_size,$onlyContent);
		
	}
	function getRenderImageFile($onlyContent=false){
		if(!$onlyContent)
			$onlyContent = !$this->isPageModel() && $this->isContentModel();
		return parent::getRenderImageFile($onlyContent);		
	}	
	
	function getUrl(){
		$strUrl = parent::getUrl();
		$strUrl .= (strpos($strUrl,'?') !== FALSE)?'&type=model':'?type=model';
		return $strUrl;
	}
	
	function isPageModel(){
		return ($this->getConfig("IS_PAGE_MODEL") === "true")?true:false;
	}
	function isContentModel(){
		return ($this->getConfig("IS_PAGE_CONTENT_MODEL") === "true")?true:false;
	}
	function getModelDescription(){
		$descr = $this->getConfig('MODEL_DESCRIPTION');
		return ($descr)?$descr:'';
	}
	
	function getTabGuidage(){
		$tabReturn=array();
		$strPath = $this->path;

		while(PAGES_MODELS_PATH != $strPath ){
			$o = new PDirCategory($strPath);
			if(!preg_match('/index/',$o->getName())){
				$tabReturn[] = array('NAME'=>$o->getMenuName(),'URL'=>$o->getUrl());
			}
			$strPath=$o->getParentPath();
		}
		return array_reverse($tabReturn);
	}
	
	function DisplayEditor(){
		return parent::DisplayEditor($pagemodel=true);		
	}
}
}//END DEFINE
?>