<?php
if(!defined("PVIDEO")){
define("PVIDEO",0);

class PVideo extends PFile {

	function PVideo($strPath){
		parent::PFile($strPath);
	}

	function Display($thumb_size,$url=false,$oRootDir=false){
		$strReturn='';
		if(!$url) $url=$this->getDisplayUrl();
		
		$objThumb = $this->getThumbFile($thumb_size);
		$strClassRender = ( $objThumb && (!is_file($objThumb->path)  || filemtime($this->path) > filemtime($objThumb->path)) )?'render':'';
				
		$strReturn .= '<dl class="file '.$strClassRender.' {thumb_size:\''.$thumb_size.'\'}" id="filename='.str_replace(SLASH,'/',$this->getRelativePath()).'">'."\n"; 
		$strReturn .= $this->DisplayMenu(($oRootDir?$oRootDir->getRelativePath():''));

		$strReturn .= "\t".'<dt>'."\n\t\t".'<a class="media video" href='.$url.'>';
		$strReturn .= "<img src='".$this->getMimeIconUrl($thumb_size)."'"; 
		$strReturn .= " id=\"context_menu_".$this->getIdName()."\" ";
 		$strReturn .= " />";
 		$strReturn .= "</a>\n\t</dt>\n";
		$strReturn .= "\t<dd><span>".$this->getPrintedName()."</span></dd>\n";
		$strReturn .= "</dl>\n";

		return $strReturn;
	}
	
	function getDisplayUrl(){
		return parent::getDisplayUrl();
	}
	
	function Delete(){
		if(!$this->_deleteCache())
			return false;
		return parent::Delete();
	}
	function  Rename($strNewName, $destDir=false){
		$this->_deleteCache();
		return parent::Rename($strNewName,$destDir);
	}
	
	function _deleteCache(){
		$objRender = $this->getRenderImageFile();
		if($objRender && is_file($objRender->path))
			$objRender->Delete();
			
		$objThumb = $this->getThumbFile();	
		if($objThumb && is_file($objThumb->path))
			$objThumb->Delete();
			
		$objPreview = $this->getPreviewObj();
		if($objPreview && $objPreview->path != $this->path)
			$objPreview->Delete();
		
		return true;
	}
	
	function getMimeIconFile($thumb_size){
		$objThumb = $this->getThumbFile($thumb_size);
		if( $objThumb && is_file($objThumb->path) && filemtime($objThumb->path) > filemtime($this->path))
			return $objThumb;

		return parent::getMimeIconFile($thumb_size);
	}
		
	function getThumbFile($thumb_size){
		if(!$objRender = $this->getRenderImageFile())
			return false;
		return $objRender->getThumbFile($thumb_size);
	}
	
	function getThumbUrl($thumb_size=70){
		if(!$objRender = $this->createScreenshot())
			return false;
		if(!is_file($objRender->path))
			return false;
		return $objRender->getThumbUrl($thumb_size);
		
	}
	
	function getRenderImageFile(){
		if( !defined('FFMPEG_PATH') || !is_file(FFMPEG_PATH))
			return false;
		
		$oDirParent = new PDir($this->getParentPath());
		$oThumbDir = new PDir(CACHE_DIR.'thumbnails'.SLASH.'videosthumb'.SLASH.$oDirParent->getRelativePath(SITE_PATH.SITE.SLASH.PAGES.SLASH));
		
		return  new PImage($oThumbDir->path.SLASH.$this->getNameWithoutExt().".jpg");
		
	}
	
	/**
	*  Function createScreenshot
	*  Generate an image of the video file using ffmpeg command line.
	*  
	*
	* return , objThumb if suceed, else false.
	*/
	function createScreenshot(){
		if(!($objthmb = $this->getRenderImageFile()))
			return false;
		$oThumbDir = new PDir($objthmb->getParentPath());		
		if(!is_dir($oThumbDir->path) && !$oThumbDir->mkdir())
		return false;
		
		//if thumb image not exists, try to generate it using FFMPEG command
		if((!is_file($objthmb->path) || filemtime($objthmb->path) < filemtime($this->path))  /*&& is_file(FFMPEG_PATH)*/){
 		   $options = "-y -ss 00:00:4 -t 00:00:01 -r 1 -an -sameq -f mjpeg";
			$command=FFMPEG_PATH." -i \"".$this->path."\" ".$options." \"".$objthmb->path."\"";
			exec($command);
		}
		if(is_file($objthmb->path) && getimagesize($objthmb->path)) {
/*			if(max($objthmb->getWidth(),$objthmb->getHeight()) != $thumb_size){	
			$objthmb->createTumb($objthmb,$thumb_size);
			}
*/			return $objthmb;					
		}
		return setError("can not create video thumb: ".$this->getName());
	}
	
	function getPreviewObj(){
		if( $this->getExtension() == 'flv' ) 
			return $this;

		$oDirParent = new PDir($this->getParentPath());
		$oThumbDir = new PDir(CACHE_DIR.'thumbnails'.SLASH.'videosthumb'.SLASH.$oDirParent->getRelativePath(SITE_PATH.SITE.SLASH.PAGES.SLASH));

		$sVideoPreviewName=	$this->getNameWithoutExt().".flv";
		$objPreview = 	new PFile($oThumbDir->path.SLASH.$sVideoPreviewName);

		return $objPreview;	
	}
	#ffmpeg -i vr_vracvinz.mp4 -acodec mp3 -ab 32 -f flv -s 320x240 -ar 22050 -aspect 4:3 -pass 1 -b 256 -r 15 -y vr_vracvinz.flv	
	function getVideoPreview(){
		if( $this->getExtension() == 'flv' ) 
			return $this;

		if( !defined('FFMPEG_PATH') || !is_file(FFMPEG_PATH))
			return setError(_('Video is not managed by your installation'));

		$objPreview = $this->getPreviewObj();
		$objDir = new PDir($objPreview->getParentPath());
		if(!$objDir->mkdir()){
			return false;		
		}
		#-f flv -s 320x240  -acodec libmp3lame -ab 56 -ar 22050  -b 400k -y
		if((!is_file($objPreview->path) || filemtime($objPreview->path) < filemtime($this->path))  /*&& is_file(FFMPEG_PATH)*/){
			$cmdline=	FFMPEG_PATH." -i \"".$this->path."\" -acodec mp3 -b 400k -ar 22050 -f flv -s 320x240  -y \"".$objPreview->path."\"";	
			exec($cmdline);
		}
		if(is_file($objPreview->path)) return $objPreview;
		return false;
	}
	
}//end class
}//end def
