<?php
/**
 * FILE: MAIN.PHP
 * This is the main of the cms core.
 * Build the site object and if page exists display it.
 *
 * If the page is sitemap.xml, disable cache and display the specific google site map template
 * If the page is not found, try to find the 404.html file in the site dir 
 * if not found redirect index of the web site (SITE_URL).
 * 
 * Copyright 2005, 2008 Mathieu Vilaplana
 */
$timestart = time()+microtime();

require 'config.inc.php';
require 'lib/lib_error.php';
require 'lib/pollencms.php';
require 'lib/ppage.php';
require 'lib/plink.php';

if(is_file(SITE_PATH.'checkinstall.php'))
	header('location:checkinstall.php');

	
$site = new PPollenCMS();
$site->loadExtraFilters();

//if no page selected, try to load the first page
if(!isset($_GET["page"])){
	//if no page was selected, take the first page
	$oPage=$site->getFirstPage($dirSearch=false,isConnected());
	
}else {
	//get the page as parameter, decode it and replace - by \s
	$page =stripslashes(rawurldecode($_GET["page"]));
	/**
		EXTRA PAGES
	*/
	switch($page){
		case 'config.js':
			header ('Content-Type: text/javascript;');
			header("Cache-Control: no-cache");//sinon bug ie
			$site->loadDefaultFilters();
			$site->display(SITE_PATH.'core'.SLASH.'templates'.SLASH.'config_js.tpl');
			die();
		case 'ckconfig.js':
			header ('Content-Type: text/javascript;');
			header("Cache-Control: no-cache");//sinon bug ie
			$site->loadDefaultFilters();
			$site->display(SITE_PATH.'core'.SLASH.'templates'.SLASH.'ckconfig.tpl');
			die();		
		case 'ckeditor.css':
			header('content-type: text/css');
			$site->loadDefaultFilters();
			$site->display(SITE_PATH.'core'.SLASH.'templates'.SLASH.'ckcss.tpl');
			die();
		case 'ckstyles.js':
			header ('Content-Type: text/javascript;');
			header("Cache-Control: no-cache");//sinon bug ie
			$site->loadDefaultFilters();
			$site->display(SITE_PATH.'core'.SLASH.'templates'.SLASH.'ckstyles.tpl');
			die();		
		case 'cktemplates.js':
			header ('Content-Type: text/javascript;');
			header("Cache-Control: no-cache");//sinon bug ie
			$site->loadDefaultFilters();
			$site->display(SITE_PATH.'core'.SLASH.'templates'.SLASH.'cktemplates.tpl');
			die();		
		case 'ajaxaction':
			include('core/admin/admin_ajax.php');
			die();
	}
	/*for safety reasons, if user try to go out pages dir, go to first page*/
	if(strstr('..',$page)){$oPage=$site->getFirstPage();}
	else {$oPage=$site->getPage($page, isConnected());}
	
}
//if find has not been found and model is set, find page model
if( isset($_GET['type']) && $_GET['type']=="model"){
	$oPage=&getFileObject(PAGES_MODELS_PATH.SLASH.$page);
	if(!is_file($oPage->path))
		$oPage = false;
}
//die(var_dump($_GET));

//if page has not been found, load the extra page event
if(!$oPage){
	$bRes = doEventAction('extrapage', array(&$page, &$site));
	if($bRes !==true)
		$oPage = &$bRes; 
}

if(!$oPage){
	header("HTTP/1.0 404 Not Found");
	die(_('404 - Page not found'));
}


//display the page
$bOnlyContent = (isset($_GET['onlycontent']))?true:false;
$site->displayPage($oPage,$bOnlyContent);
setDebug('Generate page in '.(time()+microtime()-$timestart).' s');
//var_dump($oGlobalEventsManager->_events);
if(DEBUG)
	printDebug();
?>