<?php
//addPollenPlugin('addPluginsTabs','designer_config');

addPollenPlugin('extrapage','designer_extrapage_css');
addPollenPlugin('extrapage','designer_extrapage_logosite');
addPollenPlugin('extrapage','designer_extrapage_adminpage');

addPollenPlugin('fckcss','designer_fckcss');
addPollenPlugin('adminmainmenu','designer_mainadminpanel_btn');



addSmartyPlugin('output','designer_output');


function designer_output($source, $smarty){
	$strNewHead = '
	<!-- Add By Designer Plugin -->
		<link rel="stylesheet" href="'.SITE_URL.'designer.css" />
	<!-- End Designer  -->	
	';
	
	return preg_replace('/\<\/head\>/i',$strNewHead.'</head>',$source);
}

function designer_config($tabExtraPlugins){
	
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oDesignerConfigFile = &$oPlugin->oConfig;
	
	$tabExtraPlugins[]=array(
		'FRAG_NAME'=>'plugins_designer',
		'TAB_NAME'=>_('Designer'),
		'TAB_CONTENT'=>$oDesignerConfigFile->DisplayEditor()
	);	
	
	return true;
	
}

function _designer_getCss(){
		$oPlugin = new PPluginDir(dirname(__FILE__));
		$oDesignerConfigFile = &$oPlugin->oConfig;
		$tab = $oDesignerConfigFile->getTabParams();
		//.menu_top li a
		
		foreach($tab as $name=>$value){
			switch($name){
				case 'BACKGROUND_IMAGE':
					$pdirMedias = new PDir(MEDIAS_PATH);
					$strMediasUrl = $pdirMedias->getUrl();
					$strCss .= 'body{background-image:url('.$strMediasUrl.'designer/background/'.$value.');}'."\n";				
				break;
				case 'BACKGROUND_COLOR':
					$strCss .= 'body{background-color:'.$value.';}'."\n";				
				break;
				case 'BORDER_COLOR':
					$strCss .= '.container{border-color:'.$value.';}'."\n";
				break;
				case 'BORDER_WIDTH':
					$strCss .= '.container{border-width:'.$value.'px;}'."\n";
				break;
				case 'MENU_BACKGROUND_COLOR':
					$strCss .= '.menu_top {background-color:'.$value.';}'."\n";
				break;
				case 'MENU_COLOR':
					$strCss .= '.menu_top li a{color:'.$value.';}'."\n";
				break;
				case 'MENU_SIZE':
					$strCss .= '.menu_top li a{font-size:'.$value.'px;}'."\n";
				break;
				case 'MENU_FONT':
					$strCss .= '.menu_top li a{font-family:'.$value.';}'."\n";
				break;
				case 'MENU_COLOR_SELECTED':
					$strCss .= '.menu_top li.selected a{color:'.$value.';}'."\n";
				break;

				case 'LINK_COLOR':
					$strCss .= 'a{color:'.$value.';}'."\n";
				break;
				
				case 'H1_COLOR':
					$strCss .= 'h1 {color:'.$value.';}'."\n";
				break;
				case 'H1_SIZE':
					$strCss .= 'h1 {font-size:'.$value.'px;}'."\n";
				break;
				case 'H2_COLOR':
					$strCss .= 'h2,h3 {color:'.$value.';}'."\n";
				break;
				case 'H2_SIZE':
					$strCss .= 'h2,h3 {font-size:'.$value.'px;}'."\n";
				break;
					
			}
		}
		return $strCss;
}

function designer_fckcss(&$extra){
	$extra .= _designer_getCss().'
	body{background:#FFF;}
	';	
	return true;
}

function designer_extrapage_logosite($strPage, &$site){
	if( $strPage != 'designerlogosite.jpg' )
	return false;
	
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oDesignerConfigFile = &$oPlugin->oConfig;

	$strImage = $oDesignerConfigFile->getDirectParam('LOGO_IMAGE');
	
	$oImage = new PImage(MEDIAS_PATH.SLASH.'designer'.SLASH.'logo'.SLASH.$strImage);
	if(!is_file($oImage->path))
		return false;
	$strExt = $oImage->getExtension();

	if(preg_match('/png/i',$strExt))
		header("Content-type: image/png");
	else if(preg_match('/gif/i',$strExt))
		header("Content-type: image/gif");
	else
		header("Content-type: image/jpeg");

	readfile($oImage->path);
	return true;
}

function designer_extrapage_css($strPage, &$site){
	if($strPage == 'designer.css'){
		
		header("Content-type: text/css");
		echo _designer_getCss();
		
		return true;
	}
	return false;
}

function designer_extrapage_adminpage($strPage, &$site){
	
	if( !isConnected() )
		return false;
	
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oDesignerConfigFile = &$oPlugin->oConfig;

	if($strPage == 'designer_adminpage.html'){
		echo '
		<div id="contentAdmin">
		<h2>Configuration du design du site</h2>
		<div class="ui-widget-content" style="padding:4px">
			'.$oDesignerConfigFile->DisplayEditor().'
		</div>
		</div>
		';
		return true;
	}
	return false;
}

function designer_mainadminpanel_btn(){

	$oPlugin = new PPluginDir(dirname(__FILE__));
	
	return '
		<td>
		<a href="'.SITE_URL.'designer_adminpage.html" class="panel-link infobulles" id="designer_admin">
		<img src="'.$oPlugin->getUrl().'img/designer.jpg" />
			<span>
				<h3> Design du site </h3>
				<p>Cette section vous permet de configurer le design du site.</p>
			</span>
		</a>
		</td>
	';
	
}


?>