<?php
addSmartyPlugin('output','output_jqtransform');
addPollenPlugin('addPluginsTabs','config_jqtransform');

function config_jqtransform($tabExtraPlugins){
	
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oApplyFile = new PTextFile($oPlugin->path.SLASH.'lib/apply-jqtransform.js');
	
	$tabExtraPlugins[]=array(
		'FRAG_NAME'=>'plugin_jqtransform',
		'TAB_NAME'=>_('JQTransform'),
		'TAB_CONTENT'=>'<h2>File apply-jqtransform.js</h2>'.$oApplyFile->DisplayEditor()
	);	
	return true;
}


function output_jqtransform($source, &$smarty){

	$oDir = new PDir(dirname(__FILE__));
	
	$strJqtransformCssUrl=$oDir->getUrl().'lib/jqtransform.css';
	$strJqtransformJsUrl=$oDir->getUrl().'lib/jquery.jqtransform.min.js';
	$strJqtransformJsApply=$oDir->getUrl().'lib/apply-jqtransform.js';
	
	$strNewHead = '
		<!-- Add By Pollen CMS JQTransform plugin -->
			<link rel="stylesheet" href="'.$strJqtransformCssUrl.'" />
			<script src="'.$strJqtransformJsUrl.'"></script>
			<script src="'.$strJqtransformJsApply.'"></script>	
		<!-- End JQ Transform -->
	';
	
	return preg_replace('/\<\/head\>/i',$strNewHead.'</head>',$source);		
	
	
}
?>