<?php
addPollenPlugin('addPluginsTabs','mediaplayer_tabconfig');
addPollenPlugin('fckcss','mediaplayer_fckcss');
addPollenPlugin('ckstyles','mediaplayer_ckstyles');

addSmartyPlugin('output','mediaplayer_addjavascript');

function mediaplayer_fckcss(&$extra_css){
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oConfigFile = &$oPlugin->oConfig;
	
	$iVideoWidth = $oConfigFile->getDirectParam('VIDEO_PLAYER_WIDTH');
	if(!$iVideoWidth)
		$iVideoWidth=380;
	$iVideoHeight=intval(380*3/4);

	$iAudioWidth = $oConfigFile->getDirectParam('AUDIO_PLAYER_WIDTH');
	if(!$iAudioWidth)
		$iAudioWidth=300;
	
	$extra_css.='
		.mediavideo{background:#CCC;height:'.$iVideoHeight.'px;width:'.$iVideoWidth.'px;}
		.popup_mediavideo{background:#CCC;}
		.mediaaudio{background:#CCC;height:20px;width:'.$iAudioWidth.'px;}
	';
	return true;
}

function mediaplayer_ckstyles(&$extra_styles){

	$extra_styles.='
		{ name : "Popup Media Video"	, element : "div", attributes : { "class" : "popup_mediavideo" } },
		{ name : "Media Video"	, element : "div", attributes : { "class" : "mediavideo" } },
		{ name : "Media Audio"	, element : "div", attributes : { "class" : "mediaaudio" } },
	';
	
	return true;
}


function mediaplayer_addjavascript($source, &$smarty){
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oConfigFile = &$oPlugin->oConfig;
	
	$bVideoAutoStart = $oConfigFile->getDirectParam('VIDEO_AUTOSTART');
	$iVideoWidth = $oConfigFile->getDirectParam('VIDEO_PLAYER_WIDTH');
	if(!$iVideoWidth)
		$iVideoWidth=380;

	$iAudioWidth = $oConfigFile->getDirectParam('AUDIO_PLAYER_WIDTH');
	if(!$iAudioWidth)
		$iAudioWidth=300;
	
	
	$strNewHead='
		<!-- added by mediaplayer plugin -->
			<script languae="JavaScript" src="'.$oPlugin->getUrl().'js/jquerymedia/jquery.media.js"></script>
			<script language="JavaScript">
				$(function(){
					$.fn.media.defaults.flvPlayer = "'.$oPlugin->getUrl().'js/jquerymedia/player.swf";
					$.fn.media.defaults.mp3Player = $.fn.media.defaults.flvPlayer;
					
					var optVideos = {
						params:{allowfullscreen:"true",allowscriptaccess:"always"},
						flashvars:{"autostart":'.$bVideoAutoStart.',"controlbar":"over"},
						width:'.$iVideoWidth.',
						height:'.intval(($iVideoWidth*3/4)).',
						caption:false
					};
					
					var optAudio = {
						params:{allowfullscreen:"false",allowscriptaccess:"always"},
						flashvars:{"autostart":false},
						width:'.$iAudioWidth.',
						height:20,
						caption:false
					};
					
					$("a",".mediavideo").media(optVideos);
					$("a",".mediaaudio").media(optAudio);
					$("a",".popup_mediavideo").each(function(){
						var self = $(this);
						self.click(function(){pmp_popup(self,optVideos);return false;});
					});
					
					var pmp_popup = function(oLink,optVideos){
						if(!$.fn.dialog){
							var	tabLoad = new Array(SITE_URL+"vendors/jscripts/jqueryui/jquery-ui-1.7.1.js");
							loadJS(tabLoad,function(){pmp_popup(oLink,optVideos)});
						}else {
							var win = $("<div></div>").append("<a href=\""+oLink.attr("href")+"\">");
							optVideos.flashvars.autostart=true;
							$("a",win).media(optVideos);
							var strTitle = oLink.attr("title")?oLink.attr("title"):(oLink.text())?oLink.text():"Video Player";
							var oFlash = $("embed, object").css("visibility","hidden");
							win.dialog({
								title:strTitle,
								width:(optVideos.width+28),
								bgiframe:true,
								modal:true,
								close: function(){oFlash.css("visibility","visible");win.dialog("destroy").remove();},
								buttons: { "Fermer": function() { $(this).dialog("close");}}
							});
						}
					};//END POPUP
				});
			</script>
		<!-- end add by mediaplayer plugin -->
';
	return preg_replace('/\<\/head\>/i',$strNewHead.'</head>',$source);			
}

function mediaplayer_tabconfig($tabExtraPlugins){
	
	$oPlugin = new PPluginDir(dirname(__FILE__));
	$oConfigFile = &$oPlugin->oConfig;
	
	$tabExtraPlugins[]=array(
		'FRAG_NAME'=>'plugins_mediaplayer',
		'TAB_NAME'=>_('Media Player'),
		'TAB_CONTENT'=>$oConfigFile->DisplayEditor()
	);

	return true;
	
}
?>