/**
 * Copyright (c)2005-2009 Matt Kruse (javascripttoolbox.com)
 * 
 * Dual licensed under the MIT and GPL licenses. 
 * This basically means you can use this code however you want for
 * free, but don't claim to have written it yourself!
 * Donations always accepted: http://www.JavascriptToolbox.com/donate/
 * 
 * Please do not link to the .js files on javascripttoolbox.com from
 * your site. Copy the files locally to your server instead.
 * 
 */
/**
 * jquery.contextmenu.js
 * jQuery Plugin for Context Menus
 * http://www.JavascriptToolbox.com/lib/contextmenu/
 *
 * Copyright (c) 2008 Matt Kruse (javascripttoolbox.com)
 * Dual licensed under the MIT and GPL licenses. 
 *
 * @version 1.0
 * @history 1.0 2008-10-20 Initial Release
 * @todo slideUp doesn't work in IE - because of iframe?
 * @todo Hide all other menus when contextmenu is shown?
 * @todo More themes
 * @todo Nested context menus
 */
;(function($){
	$.contextMenu = {
		oParentMenu:null,
		oParentElem:null,
		oHtmlElems:null,
		oHtmlElemSelected:null,

		shadow:true,
		shadowOffset:0,
		shadowOffsetX:5,
		shadowOffsetY:5,
		shadowWidthAdjust:-3,
		shadowHeightAdjust:-3,
		shadowOpacity:.2,
		shadowClass:'context-menu-shadow',
		shadowColor:'black',

		offsetX:0,
		offsetY:0,
		appendTo:'body',
		direction:'down',
		constrainToScreen:true,
		zindex:9999,
				
		showTransition:'show',
		hideTransition:'hide',
		showSpeed:'',
		hideSpeed:'',
		showCallback:null,
		hideCallback:null,
		
		className:'context-menu',
		itemClassName:'context-menu-item',
		itemHoverClassName:'context-menu-item-hover',
		disabledItemClassName:'context-menu-item-disabled',
		disabledItemHoverClassName:'context-menu-item-disabled-hover',
		separatorClassName:'context-menu-separator',
		innerDivClassName:'context-menu-item-inner',
		themePrefix:'context-menu-theme-',
		theme:'default',

		separator:'context-menu-separator', // A specific key to identify a separator
		target:null, // The target of the context click, to be populated when triggered
		menu:null, // The jQuery object containing the HTML object that is the menu itself
		shadowObj:null, // Shadow object
		bgiframe:null, // The iframe object for IE6
		shown:false, // Currently being shown?
		useIframe:/*@cc_on @*//*@if (@_win32) true, @else @*/true,/*@end @*/ // This is a better check than looking at userAgent!
		
		// Create the menu instance
		create: function(menu,opts) {
			var cmenu = $.extend({},this,opts,{oHtmlElems:null,oHtmlElemSelected:null}); // Clone all default properties to created object
			// If a selector has been passed in, then use that as the menu
			if (typeof menu=="string" || cmenu.oParentMenu) {
				cmenu.menu = cmenu.createMenuFromElem($(menu).css('display','block'),cmenu);
			} 
			// If a function has been passed in, call it each time the menu is shown to create the menu
			else if (typeof menu=="function") {
				cmenu.menuFunction = menu;
			}
			// Otherwise parse the Array passed in
			else {
				cmenu.menu = cmenu.createMenu(menu,cmenu);
			}
			if (cmenu.menu) {
				cmenu.menu.css({display:'none'});
				$(cmenu.appendTo).append(cmenu.menu);
			}
			
			// Create the shadow object if shadow is enabled
			if (cmenu.shadow) {
				cmenu.createShadow(cmenu); // Extracted to method for extensibility
				if (cmenu.shadowOffset) { cmenu.shadowOffsetX = cmenu.shadowOffsetY = cmenu.shadowOffset; }
			}
			//$('body').bind('contextmenu',function(){cmenu.hide();}); // If right-clicked somewhere else in the document, hide this menu
			return cmenu;
		},
		
		// Create an iframe object to go behind the menu
		createIframe: function() {
		    return $('<iframe frameborder="0" tabindex="-1" src="javascript:false" style="display:block;position:absolute;z-index:-1;filter:Alpha(Opacity=0);"/>');
		},
		
		createMenuFromElem: function(elem,cmenu){
			var className = cmenu.className;
			$.each(cmenu.theme.split(","),function(i,n){elem.addClass(cmenu.themePrefix+n);});
			// We wrap a table around it so width can be flexible
			// the table do not porpagate the click event, block the click if user click on separator
			var $t = $('<table cellspacing=0 cellpadding=0 class="cmenu"></table>')
			.click(function(){return false;/*cmenu.hide(); return false;*/});
			var $tr = $('<tr></tr>');
			var $td = $('<td></td>');
			var $div = elem;
			
			cmenu.oHtmlElems = $div.children('div.'+cmenu.itemClassName);
			$div.children('*').hover(function(){cmenu.unselectElem();});
				
			cmenu.oHtmlElems.each(function(){
				cmenu.createMenuItemFromElem($(this));				
			});
			cmenu.useIframe  && $td.append(cmenu.createIframe());
			$t.append($tr.append($td.append($div)));
			return $t;
		},
		//unselect the current elem and hide its submenu if exists
		unselectElem: function(){
			var cmenu = this;
			if(cmenu.oHtmlElemSelected){
				cmenu.oHtmlElemSelected.cmenu && cmenu.oHtmlElemSelected.cmenu.hide();
				cmenu.hoverItemOut.call(cmenu.oHtmlElemSelected,(cmenu.isItemDisabled(cmenu.oHtmlElemSelected))?cmenu.disabledItemHoverClassName:cmenu.itemHoverClassName);
			}
		},
		// Accept an Array representing a menu structure and turn it into HTML
		createMenu: function(menu,cmenu) {
			var $div = $('<div></div>');
			
			// Each menu item is specified as either:
			//     title:function
			// or  title: { property:value ... }
			for (var i=0; i<menu.length; i++) {
				var m = menu[i];
				if (m==$.contextMenu.separator) {
					$div.append(cmenu.createSeparator());
				}
				else {
					for (var opt in menu[i]) {
						$div.append(cmenu.createMenuItem(opt,menu[i][opt])); // Extracted to method for extensibility
					}
				}
			}
			return cmenu.createMenuFromElem($div,cmenu);
		},
		createMenuItemFromElem : function (elem){
			var cmenu = this;
			
			var o = {
				hoverClassName:cmenu.itemHoverClassName,
				hoverItem:cmenu.hoverItem,
				hoverItemOut:cmenu.hoverItemOut
			}
			var bHasSubMenu = (elem.children('.submenu').length > 0);
			elem.hover( function(){
					cmenu.oHtmlElemSelected=this;
						o.hoverItem.call(this,(cmenu.isItemDisabled(this))?cmenu.disabledItemHoverClassName:o.hoverClassName);
						},
				function(){
					//o.hoverItemOut.call(this,(cmenu.isItemDisabled(this))?cmenu.disabledItemHoverClassName:o.hoverClassName);
				}
				).click(function(e){
					if(bHasSubMenu) return false;
					//if click, hide all contextmenus
					var bEnable = !cmenu.isItemDisabled(this);
					bEnable && $('body').trigger('click');
					
					var subLink = $('a:first',elem);
					if(subLink.length>0){
						!bEnable && subLink.click(function(){return false;});
						if(bEnable){
							subLink.trigger('click');
							cmenu.hide();
							return (cmenu.hide() || true);
						}
					}
					return (!bEnable)?false:(cmenu.hide() || true);
				});
				$('a:first',elem).css('pointer','default').click(function(e){cmenu.hide();return false;});	
			
			bHasSubMenu && elem.contextMenu(elem.children('.submenu:first'),$.extend({},cmenu,{oParentMenu:cmenu,oParentElem:$(elem),zindex:(cmenu.zindex+1)}));

			var $idivsubico = $("<div></div>").addClass("context-menu-item-inner-withsub");
			bHasSubMenu && elem.wrapInner($idivsubico);

			var $idiv = $("<div></div>").addClass(cmenu.innerDivClassName);
			bHasSubMenu && $idiv.css('padding-right','0px');
			(elem.children("div."+cmenu.innerDivClassName).length == 0) && 
			elem.wrapInner($idiv);


			return elem;
		},
		// Create an individual menu item
		createMenuItem: function(label,obj) {
			var cmenu = this;
			if (typeof obj=="function") { obj={onclick:obj}; } // If passed a simple function, turn it into a property of an object
			// Default properties, extended in case properties are passed
			var o = $.extend({
				onclick:function() { },
				className:'',
				hoverClassName:cmenu.itemHoverClassName,
				icon:'',
				disabled:false,
				title:'',
				hoverItem:cmenu.hoverItem,
				hoverItemOut:cmenu.hoverItemOut
			},obj);
			// If an icon is specified, hard-code the background-image style. Themes that don't show images should take this into account in their CSS
			var iconStyle = (o.icon)?'background-image:url('+o.icon+');':'';
			var $div = $('<div class="'+cmenu.itemClassName+' '+o.className+((o.disabled)?' '+cmenu.disabledItemClassName:'')+'" title="'+o.title+'"></div>')
				// If the item is disabled, don't do anything when it is clicked
				.click(function(e){if(cmenu.isItemDisabled(this)){return false;}else{return o.onclick.call(cmenu.target,this,cmenu,e)}})
				// Change the class of the item when hovered over
				.hover( function(){ o.hoverItem.call(this,(cmenu.isItemDisabled(this))?cmenu.disabledItemHoverClassName:o.hoverClassName);},
						function(){ o.hoverItemOut.call(this,(cmenu.isItemDisabled(this))?cmenu.disabledItemHoverClassName:o.hoverClassName); }
				);
			var $idiv = $('<div class="'+cmenu.innerDivClassName+'" style="'+iconStyle+'">'+label+'</div>');
			$div.append($idiv);
			return $div;
		},
		
		// Create a separator row
		createSeparator: function() {
			return $('<div class="'+this.separatorClassName+'"></div>');
		},
		
		// Determine if an individual item is currently disabled. This is called each time the item is hovered or clicked because the disabled status may change at any time
		isItemDisabled: function(item) { return $(item).is('.'+this.disabledItemClassName); },
		
		// Functions to fire on hover. Extracted to methods for extensibility
		hoverItem: function(c) { $(this).addClass(c); },
		hoverItemOut: function(c) { $(this).removeClass(c); },
		
		// Create the shadow object
		createShadow: function(cmenu) {
			cmenu.shadowObj = $('<div class="'+cmenu.shadowClass+'"></div>')
			.css( {
				display:'none',
				position:"absolute", 
				zIndex:(cmenu.zindex-1), 
				opacity:cmenu.shadowOpacity, 
				backgroundColor:cmenu.shadowColor 
			} );
			$(cmenu.appendTo).append(cmenu.shadowObj);
		},
		
		// Display the shadow object, given the position of the menu itself
		showShadow: function(x,y,e) {
			var cmenu = this;
			if (cmenu.shadow) {
				cmenu.shadowObj.css( {
					width:(cmenu.menu.width()+cmenu.shadowWidthAdjust)+"px", 
					height:(cmenu.menu.height()+cmenu.shadowHeightAdjust)+"px", 
					top:(y+cmenu.shadowOffsetY)+"px", 
					left:(x+cmenu.shadowOffsetX)+"px"
				}).addClass(cmenu.shadowClass)[cmenu.showTransition](cmenu.showSpeed);
			}
		},
		
		// A hook to call before the menu is shown, in case special processing needs to be done.
		// Return false to cancel the default show operation
		beforeShow: function() { return true; },
		
		// Show the context menu
		show: function(t,e) {
			var cmenu=this, x=e.pageX, y=e.pageY;
			cmenu.target = t; // Preserve the object that triggered this context menu so menu item click methods can see it
			if (cmenu.beforeShow()!==false) {
				// If the menu content is a function, call it to populate the menu each time it is displayed
				if (cmenu.menuFunction) {
					if (cmenu.menu) { $(cmenu.menu).remove(); }
					cmenu.menu = cmenu.createMenu(cmenu.menuFunction(cmenu,t),cmenu);
					cmenu.menu.css({display:'none'});
					$(cmenu.appendTo).append(cmenu.menu);
				}
				var $c = cmenu.menu;
				x+=cmenu.offsetX; y+=cmenu.offsetY;
				var pos = cmenu.getPosition(x,y,cmenu,e); // Extracted to method for extensibility
				cmenu.showShadow(pos.x,pos.y,e);
				// Resize the iframe if needed
				(cmenu.useIframe) && $c.find('iframe').css({
					width:$c.width()+cmenu.shadowOffsetX+cmenu.shadowWidthAdjust,
					height:$c.height()+cmenu.shadowOffsetY+cmenu.shadowHeightAdjust
				});
				$c.css( {top:pos.y+"px", left:pos.x+"px", position:"absolute",zIndex:cmenu.zindex} )[cmenu.showTransition](cmenu.showSpeed,((cmenu.showCallback)?function(){cmenu.showCallback.call(cmenu);}:null));
				
				cmenu.shown=true;
				
				// Handle a single click to the document to hide the menu
				$('body').one('click',function(e){cmenu.hide();}); 
			}
		},
		
		// Find the position where the menu should appear, given an x,y of the click event
		getPosition: function(clickX,clickY,cmenu,e) {
			if(cmenu.oParentMenu){
				var $postable = cmenu.oParentMenu.menu.position();
				var $posparentelem = cmenu.oParentElem.position();
				clickX = $postable.left+$posparentelem.left+cmenu.oParentMenu.menu.width();
				clickY = $postable.top+$posparentelem.top-5;
			}
			var x = clickX+cmenu.offsetX;
			var y = clickY+cmenu.offsetY
			var h = $(cmenu.menu).height()+cmenu.shadowHeightAdjust+cmenu.shadowOffsetY;
			var w = $(cmenu.menu).width();
			var dir = cmenu.direction;
			if (cmenu.constrainToScreen) {
				var $w = $(window);
				var wh = $w.height();
				var ww = $w.width();
				if (dir=="down" && (y+h-$w.scrollTop() > wh)) { dir = "up"; }
					
				var maxRight = ww+$w.scrollLeft()-(w+cmenu.shadowWidthAdjust+cmenu.shadowOffsetX);
				if (x > maxRight) { 
					x =(!cmenu.oParentMenu)?maxRight:-cmenu.offsetX+$postable.left-$(cmenu.menu).width()+$w.scrollLeft();
				}
				x = (x<$w.scrollLeft())?$w.scrollLeft():x;
			}
			if (dir=="up") { y -= h; }
			return {'x':x,'y':(y<0)?0:y};
		},
		
		// Hide the menu, of course
		hide: function() {
			var cmenu=this;
			if (cmenu.shown) {
				cmenu.unselectElem();
				(cmenu.iframe) && $(cmenu.iframe).hide();
				(cmenu.menu) && cmenu.menu[cmenu.hideTransition](cmenu.hideSpeed,((cmenu.hideCallback)?function(){cmenu.hideCallback.call(cmenu);}:null));
				(cmenu.shadow) && cmenu.shadowObj[cmenu.hideTransition](cmenu.hideSpeed);
			}
		}
	};
	
	// This actually adds the .contextMenu() function to the jQuery namespace
	$.fn.contextMenu = function(menu,options) {
		if( (typeof menu=="string") && (menu=="hide") ){		
			return this.each(function(){
				if(!this.cmenu) return;
				this.cmenu.hide();
			});
		}
		(typeof menu=="string") && $(menu).css('display','none');		
		return this.each(function(){
			if(options.oParentMenu){
				menu.css('display','none');
				if(!this.cmenu){ this.cmenu=$.contextMenu.create($(menu),options);}
				$(this).hover(function(e){
					if(!this.cmenu){ this.cmenu=$.contextMenu.create($(menu),options);}
					!this.cmenu.isItemDisabled(this) && this.cmenu.show(this,e);
					return true;//stop propagation
				},function(){/*this.cmenu.hide()*/});
				return;
			}		
			$(this).bind('contextmenu',function(e){
				//close all other contextmenu
				$(document).click();
							
				if(!this.cmenu){ this.cmenu=$.contextMenu.create(menu,options);}
				this.cmenu.show(this,e);
				return false;//stop propagation
			});
		});
	};
})(jQuery);
