<?php
// (c) Copyright 2002-2011 by authors of the Tiki Wiki CMS Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: feature.php 39263 2011-12-22 17:55:32Z sylvieg $

function prefs_feature_list($partial = false) {

	global $prefs;
	
	$catree = array('-1' => tra('None'));

	if (! $partial && $prefs['feature_categories'] == 'y') {
		global $categlib;

		include_once ('lib/categories/categlib.php');
		$all_categs = $categlib->getCategories(NULL, true, false);

		$catree['0'] = tra('All');

		foreach ($all_categs as $categ) {
			$catree[$categ['categId']] = $categ['categpath'];
		}
	}

	return array(
		'feature_blog_mandatory_category' => array(
			'name' =>  tra('Blog:').' '.tra('Force and limit categorization to within subtree of'),
			'description' => tra('If you get an error message indicating a mandatory category is required when editing a blog post, this is the option to blame. Set it to None.'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_blogs',
			),
			'default' => '-1',
		),
		'feature_areas' => array(
			'name' => tra('Areas'),
			'description' => tra('Binding categories and perspectives to each other'),
			'type' => 'flag',
			'help' => 'Areas',
			'default' => 'n',
			'admin' => 'areas',
			'tags' => array('experimental'),
			'dependencies' => array(
				'feature_categories',
				'feature_perspective',
				'categories_used_in_tpl',
			),
		),
		'feature_wiki' => array(
			'name' => tra('Wiki'),
			'description' => tra('Collaboratively authored documents with history of changes.'),
			'type' => 'flag',
			'help' => 'Wiki',
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'wiki',
			'view' => 'tiki-listpages.php',
			'module' => 'wiki',
			'permission' => array(
				'permType' => 'wiki',
			),
		),
		'feature_blogs' => array(
			'name' => tra('Blog'),
			'description' => tra('Online diaries or journals.'),
			'type' => 'flag',
			'help' => 'Blogs',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'blogs',
			'view' => 'tiki-list_blogs.php',
			'module' => 'blog',
			'permission' => array(
				'permType' => 'blog',
			),
		),
		'feature_galleries' => array(
			'name' => tra('Image Gallery'),
			'description' => tra('Collections of graphic images for viewing or downloading (photo album)'),
			'warning' => tra('You can use file galleries instead.'),
			'type' => 'flag',
			'help' => 'Image+Gallery',
			'default' => 'n',
			'admin' => 'gal',
			'view' => 'tiki-galleries.php',
			'tags' => array('experimental'),
		),
		'feature_machine_translation' => array(
			'name' => tra('Machine Translation (by Google Translate)'),
			'description' => tra('Uses Google Translate to translate the content of wiki pages to other languages.'),
			'help' => 'Machine+Translation',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
			'type' => 'flag',
			'default' => 'n',
		),	
		'feature_trackers' => array(
			'name' => tra('Trackers'),
			'description' => tra('Database & form generator'),
			'help' => 'Trackers',
			'type' => 'flag',
			'keywords' => 'CRUD',
			'default' => 'n',
			'admin' => 'trackers',
			'view' => 'tiki-list_trackers.php',
			'module' => 'tracker',
			'permission' => array(
				'permType' => 'trackers',
			),
		),
		'feature_tracker_reports' => array(
			'name' => tra('Tracker Reports'),
			'description' => tra('Tracker Reports Generator'),
			'help' => 'Trackers',
			'type' => 'flag',
			'keywords' => 'CRUD',
			'default' => 'n',
			'dependencies' => array('feature_trackers'),
			'permission' => array(
				'permType' => 'trackers',
			),
		),
		'feature_forums' => array(
			'name' => tra('Forums'),
			'description' => tra('Online discussions on a variety of topics. Threaded or flat.'),
			'help' => 'Forums',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'forums',
			'view' => 'tiki-forums.php',
			'module' => 'forum',
			'permission' => array(
				'permType' => 'forums',
			),
		),
		'feature_file_galleries' => array(
			'name' => tra('File Gallery'),
			'description' => tra('Computer files, videos or software for downloading. With check-in & check-out (lock)'),
			'help' => 'File+Gallery',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'fgal',
			'module' => 'file',			
			'view' => 'tiki-list_file_gallery.php',
			'permission' => array(
				'permType' => 'file galleries',
			),
		),
		'feature_file_galleries_save_draft' => array(
			'name' => tra('Save files as drafts'),
			'dependencies' => array(
				'feature_file_galleries',
			),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_file_galleries_templates' => array(
			'name' => tra('File Galleries configuration templates'),
			'type' => 'flag',
			'keywords' => tra('template'),
			'dependencies' => array(
				'feature_file_galleries',
			),
			'default' => 'n',
		),
		'feature_articles' => array(
			'name' => tra('Articles'),
			'description' => tra('Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming "live."'),
			'help' => 'Articles',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'articles',
			'module' => 'article',			
			'view' => 'tiki-list_articles.php',
			'permission' => array(
				'textFilter' => 'article',
			),
		),
		'feature_polls' => array(
			'name' => tra('Polls'),
			'description' => tra('Brief list of votable options; appears in module (left or right column)'),
			'help' => 'Poll',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'polls',
			'module' => 'poll',
			'view' => 'tiki-admin_polls',
			'permission' => array(
				'textFilter' => 'poll',
			),
		),
		'feature_newsletters' => array(
			'name' => tra('Newsletters'),
			'description' => tra('Content mailed to registered users.'),
			'help' => 'Newsletters',
			'type' => 'flag',
			'default' => 'n',
			'module' => 'newsletter',			
			'tags' => array('basic'),
			'view' => 'tiki-newsletters.php',
			'permission' => array(
				'textFilter' => 'newsletter',
			),
		),
		'feature_calendar' => array(
			'name' => tra('Calendar'),
			'description' => tra('Events calendar with public, private and group channels.'),
			'help' => 'Calendar',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'calendar',
			'module' => 'calendar',			
			'view' => 'tiki-calendar.php?viewlist=list',
			'permission' => array(
				'textFilter' => 'calendar',
			),
		),
		'feature_banners' => array(
			'name' => tra('Banners'),
			'description' => tra('Insert, track, and manage advertising banners.'),
			'help' => 'Banners',
			'keywords' => 'banner publicity',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_banners.php',
			'admin' => 'ads',
			'module' => 'banner',			
			'permission' => array(
				'textFilter' => 'banner',
			),
		),
		'feature_categories' => array(
			'name' => tra('Category'),
			'description' => tra('Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions.'),
			'help' => 'Category',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'category',
			'module' => 'categ', // intentional use of categ so it catches category and categories
			'view' => 'tiki-browse_categories.php',
			'permission' => array(
				'textFilter' => 'categ', // intentional use of categ so it catches category and categories
			),
		),
		'feature_score' => array(
			'name' => tra('Score'),
			'description' => tra('Score is a game to motivate participants to increase their contribution by comparing to other users.'),
			'help' => 'Score',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'score',
			'module' => 'score',				
		),
		'feature_search' => array(
			'name' => tra('Search'),
			'description' => tra('Enables searching for content on the website, using Tiki-managed index.'),
			'help' => 'Search',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'search',
			'module' => 'search',			
			'permission' => array(
				'textFilter' => 'search',
			),
		),
		'feature_freetags' => array(
			'name' => tra('Freetags'),
			'description' => tra('Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns.'),
			'help' => 'Tags',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'freetags',
			'module' => 'tag',			
			'view' => 'tiki-browse_freetags.php',
			'permission' => array(
				'permType' => 'freetags',
			),
		),
		'feature_actionlog' => array(
			'name' => tra('Action Log'),
			'description' => tra('Allows to keep track of what users are doing and produce reports on a per-user or per-category basis.'),
			'help' => 'Action+Log',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_contribution' => array(
			'name' => tra('Contribution'),
			'description' => tra('Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports.'),
			'help' => 'Contribution',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_multilingual' => array(
			'name' => tra('Multilingual'),
			'description' => tra('Enables internationalization features and multilingual support for then entire site.'),
			'help' => 'Internationalization',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_faqs' => array(
			'name' => tra('FAQ'),
			'description' => tra('Frequently asked questions and answers'),
			'warning' => tra('You can use wiki pages instead.'),
			'help' => 'FAQ',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'admin' => 'faqs',
			'view' => 'tiki-list_faqs.php',
			'module' => 'faq',
			'permission' => array(
				'textFilter' => 'faq',
			),			
		),
		'feature_surveys' => array(
			'name' => tra('Surveys'),
			'description' => tra('Questionnaire with multiple choice or open ended question'),
			'help' => 'Surveys',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-list_surveys.php',
		),
		'feature_directory' => array(
			'name' => tra('Directory'),
			'description' => tra('User-submitted Web links'),
			'help' => 'Directory',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-directory_browse.php',
		),
		'feature_quizzes' => array(
			'name' => tra('Quizzes'),
			'description' => tra('Timed questionnaire with recorded scores.'),
			'help' => 'Quizzes',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-list_quizzes.php',
		),
		'feature_featuredLinks' => array(
			'name' => tra('Featured Links'),
			'description' => tra('Simple menu system which can optionally add an external web page in an iframe'),
			'help' => 'Featured+links',
			'view' => 'tiki-admin_links.php',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_copyright' => array(
			'name' => tra('Copyright'),
			'description' => tra('The Copyright Management System (or ©MS) is a way of licensing your content'),
			'help' => 'Copyright',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_shoutbox' => array(
			'name' => tra('Shoutbox'),
			'description' => tra('Quick comment (graffiti) box. Like a group chat, but not in real time.'),
			'help' => 'Shoutbox',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-shoutbox.php',
			'module' => 'shoutbox',
		),
		'feature_maps' => array(
			'name' => tra('MapServer'),
			'description' => tra('Navigable, interactive maps with user-selectable layers'),
			'help' => 'MapServer',
			'warning' => tra('Requires MapServer'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_gmap' => array(
			'name' => tra('Google Maps'),
			'description' => tra('Interactive use of Google Maps'),
			'help' => 'GMap',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'gmap',
		),
		'feature_live_support' => array(
			'name' => tra('Live support system'),
			'description' => tra('One-on-one chatting with customer'),
			'help' => 'Live+Support',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-live_support_admin.php',
		),
		'feature_tell_a_friend' => array(
			'name' => tra('Tell a Friend'),
			'description' => tra('Add a link "Email this page" in all the pages'),
			'help' => 'Tell+a+Friend',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_share' => array(
			'name' => tra('Share'),
			'description' => tra('Add a "Share" link in all pages to send it via e-mail, Twitter, Facebook, message or forums'),
			'warning' => tra('be careful when allowing to anonymous to activate the antibot feature.'),
			'help' => 'Share',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'share',
		),
		'feature_html_pages' => array(
			'name' => tra('HTML pages'),
			'description' => tra('Static and dynamic HTML content'),
			'help' => 'HTML+Pages',
			'warning' => tra('HTML can be used in wiki pages. This is a separate feature.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-admin_html_pages.php',
		),
		'feature_contact' => array(
			'name' => tra('Contact Us'),
			'description' => tra('Basic form from visitor to admin'),
			'help' => 'Contact+us',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_messages',
				'sender_email',
			),
			'tags' => array('basic'),
			'admin' => 'general',
			'view' => 'tiki-contact.php',
		),
		'feature_minichat' => array(
			'name' => tra('Minichat'),
			'description' => tra('Real-time group text chatting'),
			'help' => 'Minichat',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'module' => 'chat',
		),
		'feature_comments_moderation' => array(
			'name' => tra('Comments Moderation'),
			'description' => tra('An admin must validate a comment before it is visible'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comments_locking' => array(
			'name' => tra('Comments Locking'),
			'description' => tra('Comments can be closed (no new comments)'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comments_post_as_anonymous' => array(
			'name' => tra('Allow posting of comments as Anonymous'),
			'description' => tra('Permit anonymous visitors to add a comment without needing to create an account'),
			'help' => 'Comments',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_description' => array(
			'name' => tra('Display page description'),
			'description' => tra('Display the page description below the heading when viewing the page.'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_page_title' => array(
			'name' => tra('Display page name as page title'),
			'description' => tra('Display the page name at the top of each page as page title. If not enabled, the page content should be structured to contain a header.'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wiki_pageid' => array(
			'name' => tra('Display page ID'),
			'description' => tra('Display the internal page ID when viewing the page.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_icache' => array(
			'name' => tra('Individual wiki cache'),
			'description' => tra('Allow users to change the duration of the cache on a per-page basis.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_jscalendar' => array(
			'name' => tra('JS Calendar'),
			'description' => tra('JavaScript popup date selector. Will use jQuery UI DatePicker if enabled.'),
			'help' => 'JS+Calendar',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_htmlpurifier_output' => array(
			'name' => tra('Output should be HTML Purified'),
			'description' => tra('This enables HTML Purifier on outputs to filter potential remaining security problems like XSS.'),
			'help' => 'Purifier',
			'warning' => tra('Experimental.'),
			'tags' => array('experimental'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_fullscreen' => array(
			'name' => tra('Full Screen'),
			'description' => tra('Allow users to activate fullscreen mode.'),
			'help' => 'Fullscreen',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_cssmenus' => array(
			'name' => tra('CSS Menus'),
			'description' => tra('CSS Menus (suckerfish).'),
			'help' => 'Menus',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_shadowbox' => array(
			'name' => tra('Shadowbox / ColorBox'),
			'description' => tra('"Displaying content with Eye Candy". <br />Uses jQuery plugin "ColorBox". e.g. <code>{img fileId="42" thumb="y" alt="" rel="box[g]"}</code>'),
			'help' => 'Shadowbox',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_quick_object_perms' => array(
			'name' => tra('Quick Permission Assignment'),
			'description' => tra('Quickperms allow to define classes of privileges and grant them to roles on objects.'),
			'help' => 'Quickperms',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('experimental'),
		),
		'feature_purifier' => array(
			'name' => tra('HTML Purifier'),
			'description' => tra("HTML Purifier is a standards-compliant HTML filter library written in PHP and integrated in Tiki. HTML Purifier will not only remove all malicious code (better known as XSS) with a thoroughly audited, secure yet permissive whitelist, it will also make sure your documents are standards compliant, something only achievable with a comprehensive knowledge of W3C's specifications."),
			'hint' => tra('If you are trying to use HTML in your pages and it gets stripped out, you should make sure your HTML is valid or de-activate this feature.'),
			'help' => 'Purifier',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
		),
		'feature_ajax' => array(
			'name' => tra('Ajax'),
			'description' => tra('Ajax'),
			'help' => 'Ajax',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_morcego' => array(
			'name' => tra('Morcego 3D browser'),
			'description' => tra('Visualize relationships between wiki pages, in a 3D applet'),
			'help' => 'Wiki+3D',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_webmail' => array(
			'name' => tra('Webmail'),
			'description' => tra('Webmail'),
			'help' => 'Webmail',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'admin' => 'webmail',
			'view' => 'tiki-webmail.php',
		),
		'feature_intertiki' => array(
			'name' => tra('Intertiki'),
			'description' => tra('Allows several Tiki sites (slaves) to get authentication from a master Tiki site'),
			'help' => 'Intertiki',
			'perspective' => false,
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'intertiki',
		),
		'feature_mailin' => array(
			'name' => tra('Mail-in'),
			'description' => tra('Populate wiki pages and articles by email'),
			'help' => 'Mail-in',
			'keywords' => 'inbound email',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-admin_mailin.php',
		),
		'feature_wiki_mindmap' => array(
			'name' => tra('Mindmap'),
			'description' => tra('Mindmap'),
			'help' => 'MindMap',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_print_indexed' => array(
			'name' => tra('Print Indexed'),
			'description' => tra('Print Indexed'),
			'help' => 'Print+Indexed',
			'type' => 'flag',
			'default' => 'n', 
		),
		'feature_sheet' => array(
			'name' => tra('Spreadsheet'),
			'description' => tra('Datasheets with calculations and charts'),
			'help' => 'Spreadsheet',
			'type' => 'flag',
			'keywords' => 'sheet calculation calculations stats stat graph graphs',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-sheets.php',
			'permission' => array(
				'textFilter' => 'sheet',
			),
		),
		'feature_slideshow' => array(
			'name' => tra('Slideshow (jQuery.s5)'),
			'description' => tra('Web based slideshow'),
			'help' => 'Slideshow',
			'type' => 'flag',
			'keywords' => 'slide slides presentation',
			'default' => 'n',
			'tags' => array('basic'),			
		),
		'feature_invoice' => array(
			'name' => tra('Invoice'),
			'description' => tra('Invoice system'),
			'help' => 'Invoice',
			'type' => 'flag',
			'keywords' => 'invoice contractor invoicing',
			'default' => 'n',
			'view' => 'tiki-list_invoices.php',
			'tags' => array('experimental'),			
		),
		'feature_wysiwyg' => array(
			'name' => tra('Wysiwyg editor'),
			'description' => tra('WYSIWYG is an acronym for What You See Is What You Get. Uses CKEditor.'),
			'help' => 'Wysiwyg',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_kaltura' => array(
			'name' => tra('Kaltura Video Management'),
			'description' => tra('Integration to the Kaltura video management platform'),
			'help' => 'Kaltura',
			'type' => 'flag',
			'default' => 'n',
			'admin' => 'video',
			'view' => 'tiki-list_kaltura_entries.php?list=media',
		),
		'feature_friends' => array(
			'name' => tra('Friendship Network'),
			'description' => tra('Users can identify other users as their friends'),
			'warning' => tra('Neglected feature'),
			'help' => 'Friendship+Network',
			'type' => 'flag',
			'default' => 'n',
		),	
		'feature_banning' => array(
			'name' => tra('Banning system'),
			'description' => tra('Banning system'),
			'help' => 'Banning',
			'type' => 'flag',
			'keywords' => 'ban kick exclude deny',			
			'description' => tra('Deny access to specific users based on username, IP, and date/time range.'),
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-admin_banning.php',
		),
		'feature_stats' => array(
			'name' => tra('Stats'),
			'description' => tra('Record basic statistics about major Tiki features (number of wiki pages, size of file galleries, etc.)'),
			'help' => 'Stats',
			'keywords' => 'stat analytics',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-stats.php',
		),
		'feature_action_calendar' => array(
			'name' => tra('Action Calendar'),
			'description' => tra('Action Calendar'),
			'help' => 'Action+Calendar',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_referer_stats' => array(
			'name' => tra('Referer Stats'),
			'description' => tra('Record domain name of sites that send visitors to this Tiki.'),
			'help' => 'Stats',
			'keywords' => 'stat analytics referrer refferer refferrer',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-referer_stats.php',
		),
		'feature_redirect_on_error' => array(
			'name' => tra('Redirect On Error'),
			'description' => tra('On error, goto the HomePage as configured in Admin->General.'),
			'help' => 'Redirect+On+Error',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_comm' => array(
			'name' => tra('Communications (send/receive objects)'),
			'description' => tra('Send/receive wiki pages and articles between Tiki-powered sites'),
			'help' => 'Communication+Center',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_custom_home' => array(
			'name' => tra('Custom Home'),
			'description' => tra('Custom Home'),
			'help' => 'Custom+Home',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-custom_home.php',
			'tags' => array('advanced'),			
		),
		'feature_mytiki' => array(
			'name' => tra("Display 'MyTiki' in the application menu"),
			'description' => tra("Display 'MyTiki' in the application menu"),
			'help' => 'MyTiki',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_minical' => array(
			'name' => tra('Mini Calendar'),
			'description' => tra('Mini Calendar'),
			'help' => 'Calendar',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_userPreferences' => array(
			'name' => tra('User Preferences Screen'),
			'description' => tra('User Preferences Screen'),
			'help' => 'User+Preferences',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_notepad' => array(
			'name' => tra('User Notepad'),
			'description' => tra('User Notepad'),
			'help' => 'Notepad',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_bookmarks' => array(
			'name' => tra('My Bookmarks'),
			'description' => tra('My Bookmarks'),
			'help' => 'Bookmarks',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_contacts' => array(
			'name' => tra('User Contacts'),
			'description' => tra('User Contacts'),
			'help' => 'Contacts',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches' => array(
			'name' => tra('User Watches'),
			'description' => tra('Receive email notification of changes'),
			'help' => 'User+Watches',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'view' => 'tiki-admin_notifications.php',			
		),
		'feature_group_watches' => array(
			'name' => tra('Group Watches'),
			'description' => tra('Group Watches'),
			'help' => 'Group+Watches',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_daily_report_watches' => array(
			'name' => tra('Daily Reports for User Watches'),
			'description' => tra('Daily Reports for User Watches'),
			'help' => 'Daily+Reports',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches_translations' => array(
			'name' => tra('User Watches Translations'),
			'description' => tra('User Watches Translations'),
			'help' => 'User+Watches',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_user_watches_languages' => array(
			'name' => tra('User Watches Languages'),
			'description' => tra('Watch language-specific changes within a category.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_usermenu' => array(
			'name' => tra('User Menu'),
			'description' => tra('User Menu'),
			'help' => 'User+Menu',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_tasks' => array(
			'name' => tra('User Tasks'),
			'description' => tra('User Tasks'),
			'help' => 'Task',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_messages' => array(
			'name' => tra('User Messages'),
			'description' => tra('User Messages'),
			'help' => 'Inter-user+Messages',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'messages',
			'module' => 'message',
			'view' => 'messu-mailbox.php',
			'permission' => array(
				'textFilter' => 'message',
			),			
		),
		'feature_userfiles' => array(
			'name' => tra('User Files'),
			'description' => tra('User Files'),
			'help' => 'User+Files',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_userlevels' => array(
			'name' => tra('Menu User Levels'),
			'description' => tra('Allows to control the menu options that can be seen by a user'),
			'help' => 'User+Levels',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_groupalert' => array(
			'name' => tra('Group Alert'),
			'description' => tra('Group Alert'),
			'help' => 'Group+Alert',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_integrator' => array(
			'name' => tra('Integrator'),
			'description' => tra('Integrator'),
			'help' => 'Integrator',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-list_integrator_repositories.php',
		),
		'feature_xmlrpc' => array(
			'name' => tra('XMLRPC API'),
			'description' => tra('XMLRPC API'),
			'help' => 'Xmlrpc',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_debug_console' => array(
			'name' => tra('Debugger Console'),
			'description' => tra('Debugger Console'),
			'help' => 'Debugger+Console',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_tikitests' => array(
			'name' => tra('TikiTests'),
			'description' => tra('Permits recording and playback of functional tests'),
			'help' => 'TikiTests',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_version_checks' => array(
			'name' => tra('Check for updates automatically'),
			'description' => tra('Tiki will check for updates when you access the main Administration page'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_ticketlib' => array(
			'name' => tra('Require confirmation if possible CSRF detected'),
			'description' => tra('Require confirmation if possible CSRF detected'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_ticketlib2' => array(
			'name' => tra('Protect against CSRF with a ticket'),
			'description' => tra('Protect against CSRF with a ticket'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'y',
		),
		'feature_detect_language' => array(
			'name' => tra('Detect browser language'),
			'description' => tra('Lookup the user\'s preferred language through browser preferences.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_best_language' => array(
			'name' => tra('Show pages in user\'s preferred language'),
			'description' => tra('When accessing a page which has an equivalent in the user\'s preferred language, favor the translated page.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_userPreferences',
			),
			'default' => 'n',
		),
		'feature_sync_language' => array(
			'name' => tra('Changing the page language also changes the site language'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_translation' => array(
			'name' => tra('Translation assistant'),
			'description' => tra('Track translation operations between pages.'),
			'help' => 'Translating+Tiki+content',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_urgent_translation' => array(
			'name' => tra('Urgent translation notifications'),
			'description' => tra('Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_translation_incomplete_notice' => array(
			'name' => tra('Incomplete translation notice'),
			'description' => tra('When a page is translated to a new language, a notice will be automatically inserted into the page to indicate that the translation is not yet complete.'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_multilingual_structures' => array(
			'name' => tra('Multilingual structures'),
			'description' => tra('Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_wiki_structure',
				'feature_multilingual',
			),
			'default' => 'n',
		),
		'feature_multilingual_one_page' => array(
			'name' => tra('Display all languages in a single page'),
			'description' => tra('List all languages as a language option in the page language drop list to see all languages at once.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_obzip' => array(
			'name' => tra('GZip output'),
			'description' => tra('Compress your pages on-the-fly, if the requesting browser supports this'),
			'help' => 'Compression',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),
		'feature_help' => array(
			'name' => tra('Help System'),
			'description' => tra('Help System'),
			'help' => 'Documentation',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_display_my_to_others' => array(
			'name' => tra("Show user's contribution on the user information page"),
			'description' => tra("Show user's contribution on the user information page"),
			'help' => 'User+Preferences',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),			
		),
		'feature_babelfish' => array(
			'name' => tra('Yahoo! Babel Fish Translation URLs'),
			'description' => tra('Show clickable URLs to translate the page to another language using Babel Fish website.'),
			'type' => 'flag',
			'hint' => tra('You need to assign somewhere on the page via a module'),
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_babelfish_logo' => array(
			'name' => tra('Yahoo! Babel Fish Translation icons'),
			'description' => tra('Show clickable icons to translate the page to another language using Babel Fish website.'),
			'hint' => tra('You need to assign somewhere on the page via a module'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_smileys' => array(
			'name' => tra('Smileys'),
			'description' => tra('Also known as emoticons'),
			'help' => 'Smileys',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_draw' => array(
			'name' => tra('Draw (SVG-edit)'),
			'description' => tra('Draw gives you the ability to edit SVG images all around Tiki'),
			'help' => 'Draw',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_file_galleries',				
			),
			'tags' => array('experimental'),			
		),
		'feature_docs' => array(
			'name' => tra('Docs (WebODF)'),
			'description' => tra('Docs gives you the ability to view/edit Open Document Format'),
			'help' => 'Docs',
			'type' => 'flag',
			'default' => 'n',
			'dependencies' => array(
				'feature_file_galleries',				
			),
			'tags' => array('experimental'),			
		),
		'feature_dynamic_content' => array(
			'name' => tra('Dynamic Content System'),
			'description' => tra('Bloc of content which can be reused and programmed (timed)'),
			'help' => 'Dynamic+Content',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_contents.php',
		),
		'feature_filegals_manager' => array(
			'name' => tra('Use File Galleries to store pictures'),
			'type' => 'flag',
			'description' => tra('If disabled, pictures will be stored in ../img/wiki_up/.. instead.'),
			'default' => 'y',
		),
		'feature_wiki_ext_icon' => array(
			'name' => tra('External link icon'),
			'type' => 'flag',
			'description' => tra('External links will be identifed with an icon. Use the ../img/icons/external_link.gif image to customize the icon.'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_ext_rel_nofollow' => array(
			'name' => tra('Add "rel=nofollow" on external links'),
			'description' => tra("nofollow is used to instruct some search engines that links should not influence search engines. It can reduce search engine spam and prevent 'spamdexing'"),
			'type' => 'flag',
			'keywords' => 'no follow spam',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_semantic' => array(
			'name' => tra('Semantic links'),
			'description' => tra('Going beyond Backlinks, allows to define some semantic relationships between wiki pages'),
			'help' => 'Semantic',
			'type' => 'flag',
			'dependencies' => array(
				'feature_backlinks',
			),
			'default' => 'n',
		),
		'feature_webservices' => array(
			'name' => tra('Web Services'),
			'description' => tra('Can consume webservices in JSON or YAML'),
			'help' => 'WebServices',
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_menusfolderstyle' => array(
			'name' => tra('Display menus as folders'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_breadcrumbs' => array(
			'name' => tra('Breadcrumbs'),
			'description' => tra('Attempts to show you where you are'),
			'help' => 'Breadcrumbs',
			'warning' => tra('Neglected feature'),
			'type' => 'flag',
			'default' => 'n',
		),	
		'feature_antibot' => array(
			'name' => tra('Anonymous editors must enter anti-bot code (CAPTCHA)'),
			'help' => 'Spam+protection',
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),			
		),	
		'feature_wiki_protect_email' => array(
			'name' => tra('Protect email against spam'),
			'help' => 'Spam+protection',
			'warning' => ! $partial && $prefs['feature_wysiwyg'] === 'y' ? tra('Protect email against spam currently does not operate in pages edited in WYSIWYG mode (Tiki 6.1)') : '',
			'type' => 'flag',
			'default' => 'y',
		),	
		'feature_sitead' => array(
			'name' => tra('Activate'),
			'type' => 'flag',
			'default' => 'y',
		),	
		'feature_poll_anonymous' => array(
			'name' => tra('Anonymous voting'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),	
		'feature_poll_revote' => array(
			'name' => tra('Allow re-voting'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),	
		'feature_poll_comments' => array(
			'name' => tra('Comments for polls'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_polls',
			),
			'default' => 'n',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',
		),	
		'feature_faq_comments' => array(
			'name' => tra('Comments for FAQs'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_faqs',
			),
			'default' => 'y',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',			
		),	
		'feature_sefurl' => array(
			'name' => tra('Search engine friendly URL'),
			'description' => tra('If you are using Apache, you can copy _htaccess to .htaccess to get Short URLs. On IIS, copy web_config to web.config'),
			'help' => 'Clean+URLs',
			'perspective' => false,
			'type' => 'flag',
			'keywords' => 'sefurl sefurls seo rewrite rules short urls',
			'dependencies' => array(
				'wiki_badchar_prevent',
			),
			'default' => 'n',
			'admin' => 'sefurl',
		),
		'feature_sefurl_filter' => array(
			'name' => tra('Search engine friendly url Postfilter'),
			'help' => 'Rewrite+Rules',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),	
		'feature_sefurl_title_article' => array(
			'name' => tra('Display article title in the sefurl'),
			'type' => 'flag',
			'perspective' => false,
			'default' =>'n',
		),	
		'feature_sefurl_title_blog' => array(
			'name' => tra('Display blog title in the sefurl'),
			'type' => 'flag',
			'perspective' => false,
			'default' =>'n',
		),
		'feature_sefurl_tracker_prefixalias' => array(
			'name' => tra('Rewrite tiki-view_tracker.php?itemId=yyy to Prefixyyy page'),
			'description' => tra('This redirection uses the wiki prefix alias feature'),
			'help' => 'Page+Alias',
			'perspective' => false,
			'type' => 'flag',
			'dependencies' => array('feature_sefurl', 'wiki_prefixalias_tokens'),
			'default' =>'n',
		),	
		'feature_canonical_url' => array(
			'name' => tra('Canonical URL tag'),
			'description' => tra('Indicates to search engines which URL to use which prevents duplicate listings'),
			'type' => 'flag',
			'perspective' => false,
			'default' =>'y',
		),
		'feature_modulecontrols' => array(
			'name' => tra('Show module controls'),
			'help' => 'Module',
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),	
		'feature_perspective' => array(
			'name' => tra('Perspectives'),
			'description' => tra('Permits to override preferences.'),
			'help' => 'Perspectives',
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n', // If enabling by default, lib/setup/prefs.php needs updating
			'view' => 'tiki-edit_perspective.php',
		),
		'feature_wiki_replace' => array(
			'name' => tra('Search and replace'),
			'description' => tra('Permits find and replace of content in the edit box'),
			'help' => 'Regex+search+and+replace',
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_submissions' => array(
			'name' => tra('Submissions'),
			'description' => tra('Submissions are sent in but need to be approved before they go live'),
			'help' => 'Articles',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-list_submissions.php',
			'module' => 'submission',
			'permission' => array(
				'textFilter' => 'submission',
			),
		),
		'feature_cms_rankings' => array(
			'name' => tra('Rankings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_article_comments' => array(
			'name' => tra('Comments for articles'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_articles',
			),
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',			
		),
		'feature_cms_templates' => array(
			'name' => tra('Article content templates'),
			'type' => 'flag',
			'help' => 'Content+Template',
			'keywords' => tra('template article news'),			
			'description' => tra('Predefined content for a news article'),
			'view' => 'tiki-admin_content_templates.php',
			'default' => 'n',
		),
		'feature_cms_print' => array(
			'name' => tra('Print'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_cms_emails' => array(
			'name' => tra('Specify notification emails when creating articles'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_cms_sharethis' => array(
			'name' => tra('ShareThis buttons'),
			'type' => 'flag',
			'hint' => tra('Insert a ShareThis button from www.sharethis.com.'),
			'default' => 'n',
		),
		'feature_categorypath' => array(
			'name' => tra('Category Path'),
			'description' => tra('Show category tree, above wiki pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_categoryobjects' => array(
			'name' => tra('Show category objects'),
			'description' => tra('Show objects sharing the same category, below wiki pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_search_show_forbidden_cat' => array(
			'name' => tra('Ignore category viewing restrictions'),
			'hint' => tra('Will improve performance, but may show forbidden results'),
			'type' => 'flag',
			'help' => 'Search',
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_listPages' => array(
			'name' => tra('List pages'),
			'type' => 'flag',
			'view' => 'tiki-listpages.php',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_lastChanges' => array(
			'name' => tra('Latest Changes'),
			'type' => 'flag',
			'view' => 'tiki-lastchanges.php',
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_listorphanPages' => array(
			'name' => tra('Orphan pages'),
			'type' => 'flag',
			'view' => 'tiki-orphan_pages.php',
			'default' => 'n',
		),
		'feature_search_fulltext' => array(
			'name' => tra('MySQL Full-Text Search'),
			'description' => tra('This search uses the MySQL Full-Text Search feature. The indexation is continuously updated.'),
			'type' => 'flag',
			'help' => 'Search',
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_referer_highlight' => array(
			'name' => tra('Referer Search Highlighting'),
			'type' => 'flag',
			'help' => 'Referer+Search+Highlighting',
			'default' => 'y',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_stats' => array(
			'name' => tra('Search stats'),
			'type' => 'flag',
			'help' => 'Search+Stats',
			'default' => 'n',
			'keywords' => 'stat analytics',
			'tags' => array('basic'),
			'view' => 'tiki-search_stats.php',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_show_forbidden_obj' => array(
			'name' => tra('Ignore individual object permissions'),
			'hint' => tra('Will improve performance, but may show forbidden results'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_show_object_filter' => array(
			'name' => tra('Object filter'),
			'type' => 'flag',
			'default' => 'n',
			'dbfeatures' => array('mysql_fulltext'),
		),
		'feature_search_show_search_box' => array(
			'name' => tra('Search box'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_search_show_visit_count' => array(
			'name' => tra('Visits'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_search_show_pertinence' => array(
			'name' => tra('Pertinence'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_search_show_object_type' => array(
			'name' => tra('Object type'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_search_show_last_modification' => array(
			'name' => tra('Last modified date'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_blog_rankings' => array(
			'name' => tra('Rankings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_blog_heading' => array(
			'name' => tra('Custom blog headings'),
			'type' => 'flag',
			'default' => 'n',
			'warning' => tr('Using custom blog headings will use significantly more server resources. Unless you need per-blog templates, you should use a customize the template file.'),
		),
		'feature_blog_edit_publish_date' => array(
			'name' => tra('Publish dates can be modified'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_blogposts_comments' => array(
			'name' => tra('Comments on blog posts'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_blogs',
			),
			'default' => 'y',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',			
		),
		'feature_blog_sharethis' => array(
			'name' => tra('ShareThis buttons'),
			'type' => 'flag',
			'hint' => tra('Insert a ShareThis button from [http://www.sharethis.com].'),
			'default' => 'n',
		),
		'feature_file_galleries_rankings' =>array(
			'name' => tra('Rankings'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'feature_file_galleries_comments' =>array(
			'name' => tra('File Gallery Comments'),
			'type' => 'flag',
			'help' => 'Comments',
			'default' => 'n',
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',			
		),
		'feature_use_fgal_for_user_files' =>array(
			'name' => tra('Use file galleries for user files'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'dependencies' => array(
				'feature_file_galleries','feature_userfiles'
			),
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_use_fgal_for_wiki_attachments' =>array(
			'name' => tra('Use file galleries for wiki attachments'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'dependencies' => array(
				'feature_file_galleries','feature_wiki_attachments'
			),
			'default' => 'n',
			'tags' => array('experimental'),
		),
		'feature_file_galleries_author' => array(
			'name' => tra("Require file author's name for anonymous uploads"),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'feature_file_galleries_batch' => array(
			'name' => tra('Batch uploading'),
			'type' => 'flag',
			'help' => 'File+Gallery+Config',
			'default' => 'n',
		),
		'feature_forum_rankings' => array(
			'name' => tra('Rankings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_parse' => array(
			'name' => tra('Accept wiki syntax'),
			'type' => 'flag',
			'help' => 'Wiki+Syntax',
			'default' => 'n',
		),
		'feature_forum_topics_archiving' => array(
			'name' => tra('Topic archiving'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_quickjump' => array(
			'name' => tra('Quick jumps'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_replyempty' => array(
			'name' => tra('Replies are empty'),
			'type' => 'flag',
			'hint' => tra('If disabled, replies will quote the original post'),
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_forums_allow_thread_titles' => array(
			'name' => tra('First post of a thread can have an empty body'),
			'type' => 'flag',
			'hint' => tra('Will be a thread title'),
			'default' => 'n',
		),
		'feature_forums_name_search' => array(
			'name' => tra('Forum name search'),
			'type' => 'flag',
			'hint' => tra('When listing forums'),
			'default' => 'y',
		),
		'feature_forums_search' => array(
			'name' => tra('Forum content search'),
			'type' => 'flag',
			'hint' => tra('When listing forums'),
			'default' => 'n',
		),
		'feature_forum_content_search' => array(
			'name' => tra('Topic content search'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_search',
			),
			'default' => 'y',
		),
		'feature_forum_local_tiki_search' => array(
			'name' => tra('Tiki-indexed search.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_forum_local_search' => array(
			'name' => tra('Use database (full-text) search.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_clear_passwords' => array(
			'name' => tra('Store password as plain text'),
			'type' => 'flag',
			'perspective' => false,
			'default' => 'n',
		),

		'feature_crypt_passwords' => array(
			'name' => tra('Encryption method'),
			'type' => 'list',
			'options' => array(
				'crypt-md5' => 'crypt-md5',
				'crypt-des' => 'crypt-des',
				'tikihash' => tra('tikihash (old)'),
			),
			'perspective' => false,
			'default' => (CRYPT_MD5 == 1)? 'crypt-md5': 'tikihash',
		),
		'feature_editcss' => array(
			'name' => tra('Edit CSS'),
			'type' => 'flag',
			'help' => 'Edit+CSS',
			'perspective' => false,
			'default' => 'n',
			'view' => 'tiki-edit_css.php',
		),
		'feature_theme_control' => array(
			'name' => tra('Theme Control'),
			'description' => tra('Assign different themes to different sections, categories, and objects'),
			'keywords' => tra('design themes'),
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-theme_control.php',
		),
		'feature_view_tpl' => array(
			'name' => tra('Tiki Template Viewing'),
			'type' => 'flag',
			'help' => 'View+Templates',
			'keywords' => tra('template'),			
			'perspective' => false,
			'default' => 'n',
		),
		'feature_edit_templates' => array(
			'name' => tra('Edit Templates'),
			'type' => 'flag',
			'help' => 'Edit+Templates',
			'keywords' => tra('template'),			
			'perspective' => false,
			'dependencies' => array(
				'feature_view_tpl',
			),
			'default' => 'n',
			'view' => 'tiki-edit_templates.php',
			'tags' => array('experimental'),
		),
		'feature_custom_html_head_content' => array(
			'name' => tra('Custom HTML <head> Content'),
			'hint' => tra('Example:') . " {if \$page eq 'Slideshow'}{literal}<style type=\"text/css\">.slideshow { height: 232px; width: 232px; }</style>{/literal}{/if}",
			'description' => tra('Use to include custom &lt;meta&gt; or &lt;link&gt; tags.'),
			'type' => 'textarea',
			'size' => '6',
			'filter' => 'rawhtml_unsafe',
			'default' => '',
		),
		'feature_html_head_base_tag' => array(
			'name' => tra('Add BASE tag in the page HEAD'),
			'type' => 'flag',
			'description' => tra('The &lt;base&gt; tag specifies a default address for all links on a page.'),
			'default' => 'n',
		),
		'feature_sitelogo' => array(
			'name' => tra('Site Logo and Title'),
			'type' => 'flag',
			'warning' => tra('Will be obsolete in Tiki 8 and migrated to modules entirely.'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_left_column' => array(
			'name' => tra('Left column'),
			'type' => 'list',
			'help' => 'Users+Flip+Columns',
			'hint' => tra('Controls visibility of the left column of modules'),
			'keywords' => tra('side bar'),
			'options' => array(
				'y' => tra('Only if module'),
				'fixed' => tra('Always'),
				'user' => tra('User Decides'),
				'n' => tra('Never'),
			),
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_right_column' => array(
			'name' => tra('Right Column'),
			'type' => 'list',
			'help' => 'Users+Flip+Columns',
			'hint' => tra('Controls visibility of the right column of modules'),
			'keywords' => tra('side bar'),
			'options' => array(
				'y' => tra('Only if module'),
				'fixed' => tra('Always'),
				'user' => tra('User Decides'),
				'n' => tra('Never'),
			),
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_siteloclabel' => array(
			'name' => tra('Prefix breadcrumbs with "Location : "'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_siteloc' => array(
			'name' => tra('Site location bar'),
			'type' => 'list',
			'options' => array(
				'y' => tra('Top of page'),
				'page' => tra('Top of center column'),
				'n' => tra('None'),
			),
			'default' => 'y',
		),
		'feature_sitetitle' => array(
			'name' => tra('Larger font for'),
			'type' => 'list',
			'options' => array(
				'y' => tra('Entire location'),
				'title' => tra('Page name'),
				'n' => tra('None'),
			),
			'default' => 'y',
		),
		'feature_sitedesc' => array(
			'name' => tra('Use page description'),
			'type' => 'list',
			'options' => array(
				'y' => tra('Top of page'),
				'page' => tra('Top of center column'),
				'n' => tra('None'),
			),
			'dependencies' => array(
				'feature_wiki_description',
			),
			'default' => 'n',
		),
		'feature_endbody_code' => array(
			'name' => tra('Custom End of <body> Code'),
			'hint' => tra('Example:') . ' ' . "{wiki}{literal}{GOOGLEANALYTICS(account=xxxx) /}{/literal}{/wiki}",
			'type' => 'textarea',
			'size' => '6',
			'filter' => 'rawhtml_unsafe',
			'default' => '',
		),
		'feature_site_report' => array(
			'name' => tra('Webmaster Report'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_site_report_email' => array(
			'name' => tra('Webmaster Email'),
			'hint' => tra('Leave blank to use the default sender email'),
			'type' => 'text',
			'size' => '20',
			'dependencies' => array(
				'sender_email',
			),
			'default' => '',
		),
		'feature_site_send_link' => array(
			'name' => tra('Email this page'),
			'description' => tra('Add a link at the bottom if set, otherwise add a link at the top'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_tell_a_friend',
			),
			'default' => 'n',
		),
		'feature_layoutshadows' => array(
			'name' => tra('Shadow layer'),
			'hint' => tra('Additional layers for shadows, rounded corners or other decorative styling'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_jquery_tooltips' => array(
			'name' => tra('Tooltips'),
			'type' => 'flag',
			'description' => tra('Make tooltips such as this appear in a custom style. Use CSS to change their appearance.'),
			'help' => 'JQuery#Tooltips',
			'default' => 'y',		// use JQuery tooltips and override Overlib
		),
		'feature_jquery_autocomplete' => array(
			'name' => tra('Autocomplete'),
			'type' => 'flag',
			'description' => tra('Provides various drop-down menus on many text input boxes for page names, user names, groups, tags etc.'),
			'help' => 'JQuery#Autocomplete',
			'dependencies' => array(
				'feature_jquery_ui',
			),
			'default' => 'y',	// autocomplete on pages in QuickEdit (more coming soon)
		),
		'feature_jquery_superfish' => array(
			'name' => tra('Superfish'),
			'type' => 'flag',
			'description' => tra('Adds animation effects to CSS "Suckerfish" menus.'),
			'help' => 'JQuery#Superfish',
			'default' => 'y',		// Effects on CSS (Suckerfish) menus
		),
		'feature_jquery_reflection' => array(
			'name' => tra('Reflection'),
			'type' => 'flag',
			'description' => tra('Allows images to have a reflection effect below them. See the admin icons above for an example.'),
			'help' => 'JQuery#Reflection',
			'default' => 'n',		// reflection effects on images
		),
		'feature_jquery_ui' => array(
			'name' => tra('JQuery UI'),
			'type' => 'flag',
			'description' => tra('Include jQuery UI library. Enables many user interface features.'),
			'help' => 'JQuery#UI',
			'default' => 'y',				// include UI lib for more effects
		),
		'feature_jquery_ui_theme' => array(
			'name' => tra('jQuery UI Theme'),
			'help' => 'JQuery#UI',
			'type' => 'list',
			'description' => tra('jQuery UI Theme. Used in spreadsheet, for example.'),
			'options' => array(
				'black-tie' => 'black-tie',
				'blitzer' => 'blitzer',
				'cupertino' => 'cupertino',
				'dark-hive' => 'dark-hive',
				'dot-luv' => 'dot-luv',
				'eggplant' => 'eggplant',
				'excite-bike' => 'excite-bike',
				'flick' => 'flick',
				'hot-sneaks' => 'hot-sneaks',
				'humanity' => 'humanity',
				'le-frog' => 'le-frog',
				'mint-choc' => 'mint-choc',
				'overcast' => 'overcast',
				'pepper-grinder' => 'pepper-grinder',
				'redmond' => 'redmond',
				'smoothness' => 'smoothness',
				'south-street' => 'south-street',
				'start' => 'start',
				'sunny' => 'sunny',
				'swanky-purse' => 'swanky-purse',
				'trontastic' => 'trontastic',
				'ui-darkness' => 'ui-darkness',
				'ui-lightness' => 'ui-lightness',
				'vader' => 'vader',
			), 
			'default' => 'flick',	// theme for UI lib (see http://jqueryui.com/themeroller/ for list & demos - previously ui-darkness)
		),
		'feature_jquery_validation' => array(
			'name' => tra('Validation'),
			'type' => 'flag',
			'description' => tra('Provides various validation possibilities like in Trackers.'),
			'help' => 'JQuery#Validation',
			'default' => 'y',		// validation on Trackers etc
		),
		'feature_jquery_carousel' => array(
			'name' => tra('jQuery Infinite Carousel'),
			'type' => 'flag',
			'help' => 'JQuery#Carousel',
			'description' => tra('Image "carousel" plugin (coming soon)'),
			'default' => 'n',		// slideshow/carousel for file gals etc
		),
		'feature_jquery_tablesorter' => array(
			'name' => tra('jQuery Sortable Tables'),
			'type' => 'flag',
			'help' => 'JQuery#TableSorter',
			'description' => tra('Sort in fancytable plugin'),
			'default' => 'n',	// sortable tables ([will] override existing)
		),
		'feature_jquery_media' => array(
			'name' => tra('jQuery Media'),
			'type' => 'flag',
			'help' => 'JQuery#Media',
			'description' => tra('Media player'),
			'default' => 'n',	
		),
		'feature_tabs' => array(
			'name' => tra('Use Tabs'),
			'description' => tra('Makes pages shorter by splitting the content in different tabs'),			
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_iepngfix' => array(
			'name' => tra('Correct PNG images alpha transparency in IE6 (experimental)'),
			'tags' => array('experimental'),			
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_1like_redirection' => array(
			'name' => tra("Redirect to similar wiki page"),
			'type' => 'flag',
			'description' => tra("If a requested page doesn't exist, redirect to a similarly named page"),
			'help' => 'Redirect+to+similar+wiki+page',
			'default' => 'n',
		),
		'feature_wiki_pagealias' => array(
			'name' => tra("Redirect to page alias, if any"),
			'type' => 'flag',
			'description' => tra("If a requested page doesn't exist, redirect to an alias page, if specified using an alias semantic link"),
			'help' => 'Page+Alias',
			'dependencies' => array(
				'feature_wiki_1like_redirection',
				'feature_semantic', // this is needed at point of creation of semantic link otherwise link will not register
			),
			'default' => 'y',
		),
		'feature_wiki_templates' => array(
			'name' => tra('Wiki content templates'),
			'type' => 'flag',
			'keywords' => tra('template'),			
			'help' => 'Content+Template',
			'default' => 'n',
			'description' => tra('Predefined content for a wiki page'),
			'view' => 'tiki-admin_content_templates.php',
		),
		'feature_warn_on_edit' => array(
			'name' => tra('Warn on edit conflict'),
			'type' => 'flag',
			'description' => tra('Tiki will warn users who attempt to edit a page that another user is currenly editing.'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_undo' => array(
			'name' => tra('Undo'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_footnotes' => array(
			'name' => tra('Footnotes'),
			'type' => 'flag',
			'description' => tra('Create private notes for a page that are visible only by the author.'),
			'default' => 'n',
		),
		'feature_wiki_allowhtml' => array(
			'name' => tra('Allow HTML'),
			'type' => 'flag',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_actionlog_bytes' => array(
			'name' => tra('Log bytes changes (+/-) in action logs'),
			'type' => 'flag',
			'hint' => tra('May impact performance'),
			'default' => 'n',
		),
		'feature_sandbox' => array(
			'name' => tra('Sandbox'),
			'type' => 'flag',
			'description' => tra('A special wiki page for testing. Users can edit, but not save the Sandbox.'),
			'default' => 'n',
		),
		'feature_wiki_comments' => array(
			'name' => tra('Comments below wiki pages'),
			'type' => 'flag',
			'help' => 'Comments',
			'description' => tra('Allow users (with permission) to post threaded comments to a page.'),
			'dependencies' => array(
				'feature_wiki',
			),
			'default' => 'n',
			'tags' => array('basic'),
			'admin' => 'comments',
			'view' => 'tiki-list_comments.php',			
		),
		'feature_wiki_pictures' => array(
			'name' => tra('Pictures'),
			'type' => 'flag',
			'help' => 'Wiki-Syntax+Images',
			'description' => tra('Allow users to upload images (pictures) to a page.'),
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_export' => array(
			'name' => tra('Export'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wikiwords' => array(
			'name' => tra('WikiWords'),
			'type' => 'flag',
			'description' => tra('Automatically convert words with UpPeR and LoWeR-case letters into wiki links.'),
			'default' => 'n',
		),
		'feature_wiki_plurals' => array(
			'name' => tra('Link plural WikiWords to their singular forms'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wikiwords_usedash' => array(
			'name' => tra('Accept dashes and underscores in WikiWords'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_history' => array(
			'name' => tra('History'),
			'type' => 'flag',
			'help' => 'History',
			'default' => 'y',
			'tags' => array('basic'),
		),
		'feature_wiki_history_ip' => array(
			'name' => tra('Display IP address'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_history_full' => array(
			'name' => tra('Record all versions, rather than only when page content or description changes or when an edit comment is given'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_page_contribution' => array(
			'name' => tra('View page contributions by author'),
			'type' => 'flag',
			'dependencies' => array (
				'feature_history'
			),
			'description' => tra('Visualize the contributions of different authors made to a wiki page'),
			'default' => 'n',
		),
		'feature_wiki_discuss' => array(
			'name' => tra('Discuss pages on forums'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_forums'
			),
			'description' => tra('Include a link on each page to a forum topic.'),
			'default' => 'n',
		),
		'feature_source' => array(
			'name' => tra('View source'),
			'type' => 'flag',
			'default' => 'y',
			'tags' => array('basic'),			
		),
		'feature_wiki_ratings' => array(
			'name' => tra('Rating'),
			'type' => 'flag',
			'help' => 'Rating',
			'dependencies' => array(
				'feature_polls'
			),
			'default' => 'n',
		),
		'feature_backlinks' => array(
			'name' => tra('Backlinks'),
			'type' => 'flag',
			'help' => 'Backlinks',
			'default' => 'n',
			'tags' => array('basic'),
		),
		'feature_likePages' => array(
			'name' => tra('Similar (like pages)'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_rankings' => array(
			'name' => tra('Rankings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_structure' => array(
			'name' => tra('Structures'),
			'type' => 'flag',
			'help' => 'Structure',
			'default' => 'n',
		),
		'feature_wiki_open_as_structure' => array(
			'name' => tra('Open page as structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_make_structure' => array(
			'name' => tra('Make structure from page'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_categorize_structure' => array(
			'name' => tra('Categorize structure pages together'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_create_webhelp' => array(
			'name' => tra('Create webhelp from structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_import_html' => array(
			'name' => tra('Import HTML'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_use_date' => array(
			'name' => tra('Use date parameter'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_use_date_links' => array(
			'name' => tra('Report it in wiki links'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_import_page' => array(
			'name' => tra('Import pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_userpage' => array(
			'name' => tra("User's page"),
			'description' => tra('A personal page for the user to manage.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_userpage_prefix' => array(
			'name' => tra('UserPage prefix'),
			'description' => tra('All user pages share a common prefix. The concatenation of the prefix and the username will generate the page name. The prefix cannot be empty.'),
			'type' => 'text',
			'size' => '40',
			'default' => 'User:',
		),
		'feature_wiki_usrlock' => array(
			'name' => tra('Users can lock pages'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_multiprint' => array(
			'name' => tra('MultiPrint'),
			'type' => 'flag',
			'default' => 'n',
		),
	
		'feature_wiki_print' => array(
			'name' => tra('Print'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_listorphanStructure' => array(
			'name' => tra('Pages not in structure'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_attachments' => array(
			'name' => tra('Attachments'),
			'type' => 'flag',
			'help' => 'Attachments',
			'description' => tra('Allow users to upload (attach) files to a page.'),
			'default' => 'n',
		),
		'feature_dump' => array(
			'name' => tra('Dumps'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_mandatory_category' => array(
			'name' =>  tra('Wiki:').' '.tra('Force and limit categorization to within subtree of'),
			'description' => tra('If you get an error message indicating a mandatory category is required when editing a wiki page, this is the option to blame. Set it to None.'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_wiki',
			),
			'default' => -1,
		),
		'feature_image_gallery_mandatory_category' => array(
			'name' =>  tra('Image Gallery:').' '.tra('Force and limit categorization to within subtree of'),
			'description' => tra('If you get an error message indicating a mandatory category is required when editing an image (in an image gallery), this is the option to blame. Set it to None.'),
			'type' => 'list',
			'options' => $catree,
			'dependencies' => array(
				'feature_categories',
				'feature_galleries',
			),
			'default' => -1,
		),
		'feature_wiki_show_hide_before' => array(
			'name' => tra('Display show/hide icon displayed before headings'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_metrics_dashboard' => array(
			'name' => tra('Metrics Dashboard'),
			'description' => tra('Generate automated statistics from configured database queries.'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_jquery_ui',
			),
			'default' => 'n',
			'tags' => array('experimental'),
			'view' => 'tiki-admin_metrics.php',
			'admin' => 'metrics',
		),
		'feature_wiki_argvariable' => array(
			'name' => tra('Wiki argument variables'),
			'description' => tra('Allow to write request variables inside wiki content using {{paramname}} or {{paramname|default}} - special case {{page}} {{user}}'),
			'type' => 'flag',
			'help' => 'Advanced+Wiki+Syntax+usage+examples',
			'default' => 'n',
		),
		'feature_challenge' => array(
			'name' => tra('Use challenge/response authentication'),
			'type' => 'flag',
			'hint' => tra('Confirm that the Admin account has a valid email address or you will not be permitted to login'),
			'default' => 'n',
		),
		'feature_show_stay_in_ssl_mode' => array(
			'name' => tra('Users can choose to stay in SSL mode after an HTTPS login'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_switch_ssl_mode' => array(
			'name' => tra('Users can switch between secured or standard mode at login'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_paragraph_formatting' => array(
			'name' => tra('Wiki paragraph formatting'),
			'description' => tra('Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines.').' '.tra('Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_paragraph_formatting_add_br' => array(
			'name' => tra('...but still create line breaks within paragraphs'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_wiki_monosp' => array(
			'name' => tra('Automonospaced text'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_wiki_tables' => array(
			'name' => tra('Tables syntax'),
			'type' => 'list',
			'options' => array(
				'old' => tra('|| for rows'),
				'new' => tra('<return> for rows'),
			),
			'default' => 'new',
		),
		'feature_autolinks' => array(
			'name' => tra('AutoLinks'),
			'type' => 'flag',
			'help' => 'AutoLinks',
			'description' => tra('Tiki will automatically convert http:// and email addresses into links.'),
			'default' => 'y',
		),
		'feature_hotwords' => array(
			'name' => tra('Hotwords'),
			'type' => 'flag',
			'help' => 'Hotwords',
			'default' => 'n',
			'view' => 'tiki-admin_hotwords.php',
		),
		'feature_hotwords_nw' => array(
			'name' => tra('Open Hotwords in new window'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_use_quoteplugin' => array(
			'name' => tra('Use Quote plugin rather than ">" for quoting'),
			'type' => 'flag',
			'help' => 'PluginQuote',
			'dependencies' => array(
				'wikiplugin_quote',
			),
			'default' => 'n',
		),
		'feature_use_three_colon_centertag' => array(
			'name' => tra('Use three colons instead of two to center text. Avoids conflict with C++ resolution scope operator.'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_simplebox_delim' => array(
			'name' => tra('String to use to delimit simplebox'),
			'type' => 'text',
			'default' => '^',
		),
		'feature_community_gender' => array(
			'name' => tra('Users can choose to show their gender'),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'dependencies' => array(
				'feature_userPreferences',
			),
			'default' => 'n',
		),
		'feature_community_mouseover' => array(
			'name' => tra("Show user's information on mouseover"),
			'type' => 'flag',
			'help' => 'User+Preferences',
			'hint' => tra("Requires user's information to be public"),
			'default' => 'n',
		),
		'feature_community_mouseover_name' => array(
			'name' => tra('Real name'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_gender' => array(
			'name' => tra('Gender'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_picture' => array(
			'name' => tra('Picture (avatar)'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_friends' => array(
			'name' => tra('Number of friends'),
			'type' => 'flag',
			'help' => 'Friendship+Network',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_mouseover_score' => array(
			'name' => tra('Score'),
			'type' => 'flag',
			'help' => 'Score',
			'default' => 'y',
		),
		'feature_community_mouseover_country' => array(
			'name' => tra('Country'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_email' => array(
			'name' => tra('E-mail'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_lastlogin' => array(
			'name' => tra('Last login'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_mouseover_distance' => array(
			'name' => tra('Distance'),
			'type' => 'flag',
			'default' => 'y',
		),
		'feature_community_list_name' => array(
			'name' => tra('Name'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_score' => array(
			'name' => tra('Score'),
			'type' => 'flag',
			'help' => 'Score',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_country' => array(
			'name' => tra('Country'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_community_list_distance' => array(
			'name' => tra('Distance'),
			'type' => 'flag',
			'dependencies' => array(
				'feature_friends',
			),
			'default' => 'y',
		),
		'feature_cal_manual_time' => array(
			'name' => tra('Manual selection of time/date'),
			'type' => 'flag',
			'default' => 'n',
		),
		'feature_webdav' => array(
			'name' => tra('WebDAV access to Tiki'),
			'description' => tra('Allow to access File Galleries with WebDAV'),
			'hint' => tra('use tiki-webdav.php as the URI of the WebDAV repository'),
			'help' => 'WebDAV',
			'type' => 'flag',
			'tags' => array('experimental'),
			'dependencies' => array(
				'feature_file_galleries',
				'php_libxml',
				'php_datetime',
			),
			'default' => 'n',
		),
		'feature_fixed_width' => array(
			'name' => tra('Fixed width'),
			'type' => 'flag',
			'description' => tra('Constrains the width of the site.'),
			'default' => 'y',
		),
		'feature_socialnetworks' => array(
			'name' => tra('Social networks'),
			'description' => tra('Integration with different social networks like Twitter or Facebook'),
			'help' => 'Social+Networks',
			'type' => 'flag',
			'keywords' => 'social networks',
			'default' => 'n',
		),
		'feature_group_transition' => array(
			'name' => tra('Group Transition'),
			'description' => tra('Enables transitions for users between different groups. Transitions will create a user approval workflow.'),
			'type' => 'flag',
			'help' => 'Group+Transitions',
			'default' => 'n',
			'view' => 'tiki-admin_transitions.php',
			'permission' => array(
				'permType' => 'transition',
			),
		),
		'feature_category_transition' => array(
			'name' => tra('Category Transition'),
			'description' => tra('Enables transitions on objects between different categories. Transitions will create a document workflow.'),
			'type' => 'flag',
			'help' => 'Category+Transitions',
			'default' => 'n',
			'view' => 'tiki-admin_transitions.php',
			'permission' => array(
				'permType' => 'transition',
			),			
		),
		'feature_watershed' => array(
			'name' => tra('Ustream Watershed live video streaming'),
			'description' => tra('Integration to Ustream Watershed live video streaming.'),
			'type' => 'flag',
			'help' => 'Ustream+Watershed',
			'default' => 'n',
		),
		'feature_credits' => array(
			'name' => tra('Tiki User Credits'),
			'description' => tra('Tiki User Credits'),
			'type' => 'flag',
			'help' => 'Tiki+User+Credits',
			'default' => 'n',
			'view' => 'tiki-admin_credits.php',
		),
		'feature_invite' => array(
			'name' => tra('Invite users'),
			'description' => tra('Allow users to invite new users by mail to register on this tiki'),
			'type' => 'flag',
			'default' => 'n',
		),
        'feature_loadbalancer' => array(
            'name' => tra('Load Balancer'),
            'description' => tra('Enable this only if the server is behind a load balancer (or reverse proxy), this allow tiki to log the IP of the user, instead of the IP of the proxy server'),
            'type' => 'flag',
			'default' => 'n',
			'tags' => array('experimental'),			
        ),
        'feature_accounting' => array(
			'name' => tra('Accounting'),
			'description' => tra('Double-entry accounting system'),
			'help' => 'Accounting',
			'type' => 'flag',
			'default' => 'n',
			'view' => 'tiki-accounting_books.php',
			'tags' => array('experimental'),
		),
		'feature_syntax_highlighter' => array(
			'name' => tra('Syntax Highlighter (CodeMirror)'),
			'type' => 'flag',
			'help' => 'CodeMirror',
			'keywords' => 'Code Mirror',
			'description' => tra('Enables syntax highlighting with the use of CodeMirror'),
			'default' => 'n',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),		
		),
		'feature_jison_wiki_parser' => array(
			'name' => tra('Jison Wiki Parser'),
			'type' => 'flag',
			'help' => 'Jison+Wiki+Parser',
			'keywords' => 'parser',
			'description' => tra('Is a new strategy for parsing wiki pages more like a programming language'),
			'default' => 'n',
			'warning' => tra('Experimental'),
			'tags' => array('experimental'),
		),
		'feature_dummy' => array(
			'name' => tra('Dummy preference'),
			'type' => 'text',
			'size' => '15',			
			'help' => 'Preferences',
			'helpurl' => 'PreferencesURLtest', // 2011-08-28 ML: what does this do?
			'keywords' => 'test bogus bogusorama',
			'description' => tra('This is useful for developers to learn how to create a new preference.'),
			'default' => 'This is the default value of this preference.',
			'detail' => tra('This is the detail.'),
			'warning' => tra('This is the warning.'),
			'hint' => tra('This is the hint.'),
			'shorthint' => tra('This is the shorthint.'),
			'tags' => array(
				'experimental',
				),
			'view' => 'tiki-listpages.php',
			'plugin' => 'blog',
			'dependencies' => array(
				'feature_wiki',
			),
			'extensions' => array(
				'zlib',
			),
			'module' => 'blog',
			'permission' => array(
				'permType' => 'blog',
			),
			'admin' => 'blogs',
			'perspective' => false,			
		),
	);
}
