<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  admin_import.php                                         ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/


	@set_time_limit(600);
	@ini_set("auto_detect_line_endings", 1);
	@ini_set("max_input_vars", 10000);
	include_once("./admin_config.php");
	include_once($root_folder_path . "includes/common.php");
	include_once($root_folder_path . "includes/record.php");
	include_once($root_folder_path . "includes/import_functions.php");
	include_once($root_folder_path . "includes/friendly_functions.php");
	include_once($root_folder_path . "messages/" . $language_code . "/cart_messages.php");
	include_once($root_folder_path . "messages/" . $language_code . "/download_messages.php");
	include_once("./admin_common.php");

	check_admin_security("import_export");

	define("COMMA_DECIMAL", false);
	if (COMMA_DECIMAL) {
		$prices = array('price', 'buying_price', 'trade_price', 'properties_price', 'trade_properties_price',
			'sales_price', 'trade_sales');
	}

	$errors = "";
	$max_columns = 9;
	$rnd = get_param("rnd");
	$table = get_param("table");
	$file_type = get_param("file_type");
	$xml_product_root = get_param("xml_product_root");
	$csv_delimiter = get_param("csv_delimiter");
	$csv_file_path = get_param("csv_file_path");
	$operation = get_param("operation");
	$category_id = get_param("category_id");
	$newsletter_id = get_param("newsletter_id");
	$session_rnd = get_session("session_rnd");
	$delimiter_char = ($csv_delimiter === "tab") ? "\t" : substr($csv_delimiter, 0, 1);
	$tmp_dir = get_setting_value($settings, "tmp_dir", "");
	$features_groups = array();
	// show DB errors
	$db->DebugError = true;


	$eol = get_eol();
	$import_related_table   = get_param("import_related_table");
	$csv_related_delimiter  = get_param("csv_related_delimiter", "comma");
	$delimiters_symbols     = array("comma" => ",", "tab" => "\t", "semicolon" => ";", "vertical_bar" => "|", "row" => "row", "space" => " ", "newline" => $eol);
	if ($csv_related_delimiter) {
		$related_delimiter_char = $delimiters_symbols[$csv_related_delimiter];
	}

	$t = new VA_Template($settings["admin_templates_dir"]);
	$t->set_file("main", "admin_import.html");
	$t->set_var("rnd", $rnd);

	include_once("./admin_header.php");
	include_once("./admin_footer.php");

	$t->set_var("admin_select_href", "admin_select.php");
	$t->set_var("admin_import_href", "admin_import.php");
	$t->set_var("admin_items_list_href", "admin_items_list.php");
	$t->set_var("admin_users_list_href", "admin_newsletter_users.php");
	$t->set_var("header_data", "''"); // empty data if json object wasn't initiliazied
	$t->set_var("keys_chain", "''"); // empty data if json object wasn't initiliazied
	// set some messages
	$upload_select_msg = str_replace("{button_name}", UPLOAD_BUTTON, UPLOAD_SELECT_MSG);
	$t->set_var("UPLOAD_SELECT_MSG", $upload_select_msg); // empty data if json object wasn't initiliazied

	// url object to generate related links
	$admin_import_url = new VA_URL("admin_import.php", false);
	$admin_import_url->add_parameter("category_id", REQUEST, "category_id");
	$admin_import_url->add_parameter("id", REQUEST, "id");
	$admin_import_url->add_parameter("ids", REQUEST, "ids");
	$admin_import_url->add_parameter("s", REQUEST, "s");
	$admin_import_url->add_parameter("sl", REQUEST, "sl");
	$admin_import_url->add_parameter("ss", REQUEST, "ss");
	$admin_import_url->add_parameter("ap", REQUEST, "ap");

	if ($table == "items") {
		check_admin_security("products_import");
		include_once("./admin_table_items.php");		
		// check addition options for table
		$match_item_code = get_setting_value($settings, "match_item_code", 0);
		if ($match_item_code) {
			$db_columns["item_code"]["field_type"] = WHERE_DB_FIELD;
		}
		$match_manufacturer_code = get_setting_value($settings, "match_manufacturer_code", 0);
		if ($match_manufacturer_code) {
			$db_columns["manufacturer_code"]["field_type"] = WHERE_DB_FIELD;
		}

		// parse links for related import
		$admin_import_url->add_parameter("table", CONSTANT, "items_files");
		$t->set_var("admin_items_files_import_url", $admin_import_url->get_url());

		$admin_import_url->add_parameter("table", CONSTANT, "items_prices");
		$t->set_var("admin_items_prices_import_url", $admin_import_url->get_url());

		$admin_import_url->add_parameter("table", CONSTANT, "items_serials");
		$t->set_var("admin_items_serials_export_url", $admin_import_url->get_url());

		$t->parse("products_other_links", false);

	} elseif ($table == "items_files") {
		check_admin_security("products_import");
		include_once("./admin_table_items_files.php");		
	} elseif ($table == "items_prices") {
		check_admin_security("products_import");
		include_once("./admin_table_items_prices.php");		
	} elseif ($table == "categories") {
		check_admin_security("categories_import");
		include_once("./admin_table_categories.php");
	} elseif ($table == "users") {
		check_admin_security("import_users");
		include_once("./admin_table_users.php");
	} elseif ($table == "newsletters_emails") {
		check_admin_security("newsletter");
		include_once("../includes/newsletter_functions.php");
		include_once("./admin_table_newsletters_emails.php");
	} elseif ($table == "newsletters_users") {
		check_admin_security("import_users");
		include_once("./admin_table_emails.php");
	} elseif ($table == "orders") {
		check_admin_security("orders_import");
		include_once("./admin_table_orders.php");
	} else if ($table == "tax_rates") {
		check_admin_security("tax_rates");
		include_once("./admin_table_tax_rates.php");
	} else if ($table == "items_serials" || $table == "serials") {
		check_admin_security("products_import");
		include_once("./admin_table_serials.php");
	} else {
		$table_name = "";
		$table_title = "";
		$errors = CANT_FIND_TABLE_IMPORT_MSG;
	}

	if(!$errors){
		if ($table == "orders") {
			$sql  = " SELECT property_id, property_name FROM " . $table_prefix . "order_custom_properties ";
			$sql .= " WHERE payment_id=0 ";
			$sql .= " GROUP BY property_name, property_id ";
			$db->query($sql);
			while ($db->next_record()) {
				$property_id = $db->f("property_id");
				$property_name = $db->f("property_name");
				$db_columns["order_property_" . $property_id] = array(get_translation($property_name), TEXT, 5, false, $table_prefix . "order_properties");
			}

			$related_columns["tax_percent"] = array(PRODUCT_TAX_MSG, NUMBER, 2, false);

			$sql = " SELECT property_name FROM " . $table_prefix . "items_properties GROUP BY property_name";
			$db->query($sql);
			while ($db->next_record()) {
				$property_name = $db->f("property_name");
				$related_columns["order_item_property_" . $property_name] = array(PRODUCT_OPTION_MSG ." (" . get_translation($property_name) . ")", TEXT, 5, false, $table_prefix . "order_items_properties");
			}
			$sql = " SELECT property_name FROM " . $table_prefix . "orders_items_properties GROUP BY property_name ";
			$db->query($sql);
			while ($db->next_record()) {
				$property_name = $db->f("property_name");
				$related_columns["order_item_property_" . $property_name] = array(PRODUCT_OPTION_MSG . " (" . get_translation($property_name) . ")", TEXT, 5, false, $table_prefix . "order_items_properties");
			}
		} else if ($table == "users") {
			// update custom properties field type
			foreach ($db_columns as $column_name => $column_info) {
				if (preg_match("/^user_property_/", $column_name)) {
					if (isset($column_info["title"])) { // new format
						$db_columns[$column_name]["field_type"] = 5;
					} else { // old format
						$db_columns[$column_name][2] = 5;
					}
				}
			}
		}


		// check if we need to populate values list
		foreach ($db_columns as $column_name => $column_info) {
			if (isset($column_info["values_sql"]) && $column_info["values_sql"]) {
				$control_type = $column_info["control"];
				$values = array();
				if ($control_type == LISTBOX) {
					// added first empty value
					$values[] = array("", "");
				}
				$sql = $column_info["values_sql"];
				$db->query($sql);
				while ($db->next_record()) {
					$value_id = $db->f(0);
					$value_title = $db->f(1);
					$values[] = array($value_id, $value_title);
				}
				$db_columns[$column_name]["values"] = $values;
			}
		}
	}

/*
//	TODO: not sure if we need this block anymore
//	============================================
	$db_columns_options = array();
	$db_columns_options[] = array("", "");
	$db_columns_options[] = array("-1", "<-- " . IGNORE_COLUMN_MSG);
	if (!$errors) {
		foreach ($db_columns as $column_name => $column_info) {
			if ($column_info[2] != HIDE_DB_FIELD) {
				$db_columns_options[] = array($column_name, $column_info[0]);
			}
		}
		foreach ($db_columns as $column_name => $column_info) {
			$column_title = strtolower($column_info[0]);
			$db_aliases[$column_title] = $column_name;
		}
			// WORK WITH RELATED TABLE
				if ($import_related_table) {
					$db_columns_options[] = array("", "--".RELATED_MSG."--");
					foreach ($related_columns as $column_name => $column_info) {
						if ($column_info[2] != HIDE_DB_FIELD) {
							$db_columns_options[] = array($column_name, $column_info[0]);
						}
					}
					foreach ($related_columns as $column_name => $column_info) {
						$column_title = strtolower($column_info[0]);
						$db_aliases[$column_title] = $column_name;
					}
				}
	}
//*/

	$t->set_var("table", $table);
	$t->set_var("table_title", $table_title);
	$t->set_var("table_title", $table_title);
	if (isset($db_columns)) {
		$t->set_var("db_columns", json_encode($db_columns));
	}

	if ($operation == "upload") {

		if (strlen($csv_file_path)) {
			if (file_exists($csv_file_path)) {
				$fp = fopen($csv_file_path, "r");
				if (!$fp) {
					$errors = CANT_OPEN_IMPORTED_MSG;
				}
			} else {
				$errors = FILE_DOESNT_EXIST_MSG . "<b>$csv_file_path</b>";
			}
		} else {
			if (isset($_FILES)) {
				$tmp_name = $_FILES["csv_file"]["tmp_name"];
				$filename = $_FILES["csv_file"]["name"];
				$filesize = $_FILES["csv_file"]["size"];
				$upload_error = isset($_FILES["csv_file"]["error"]) ? $_FILES["csv_file"]["error"] : "";
			} else {
				$tmp_name = $HTTP_POST_FILES["csv_file"]["tmp_name"];
				$filename = $HTTP_POST_FILES["csv_file"]["name"];
				$filesize = $HTTP_POST_FILES["csv_file"]["size"];
				$upload_error = isset($HTTP_POST_FILES["csv_file"]["error"]) ? $HTTP_POST_FILES["csv_file"]["error"] : "";
			}

			if ($upload_error == 1) {
				$errors = FILESIZE_DIRECTIVE_ERROR_MSG;
			} elseif ($upload_error == 2) {
				$errors = FILESIZE_PARAMETER_ERROR_MSG;
			} elseif ($upload_error == 3) {
				$errors = PARTIAL_UPLOAD_ERROR_MSG;
			} elseif ($upload_error == 4) {
				$errors = NO_FILE_UPLOADED_MSG;
			} elseif ($upload_error == 6) {
				$errors = TEMPORARY_FOLDER_ERROR_MSG;
			} elseif ($upload_error == 7) {
				$errors = FILE_WRITE_ERROR_MSG;
			} elseif ($tmp_name == "none" || !strlen($tmp_name)) {
				$errors = NO_FILE_UPLOADED_MSG;
			}

			if (!strlen($errors)) {
				if ($tmp_dir) {
					$tmp_filename = "tmp_" . md5(uniqid(rand(), true)) . ".csv";
					if (@move_uploaded_file($tmp_name, $tmp_dir. $tmp_filename)) {
						$csv_file_path = $tmp_dir . $tmp_filename;
					}
				} else {
					$errors = SPECIFY_TEMP_FOLDER_MSG;
				}

				if (strlen($csv_file_path)) {
					$fp = fopen($csv_file_path, "r");
				}

				if (!$errors && !$fp) {
					$errors = CANT_OPEN_IMPORTED_MSG;
				}
			}
		}

		// TODO: add here check for uploaded file type - CSV / XML
		if (!strlen($errors)) {
			//$csv_data = fgetcsv($fp, 4096, $delimiter_char);
			$data_file = FilesImportStrategy::getParser($file_type, $csv_file_path, $fp, $delimiter_char);

			//$header_data = get_header_data($csv_data);
			$header_data = $data_file->getFieldsHeaders();
			$xml_fields = $data_file->getHeaders();
			//var_dump($header_data);exit;
		}

		if (!strlen($errors)) {

			$operation = "import";
			$column_number = 0;

			// transform column name to lowercase for comparison and prepare js array
			$header_json = array();
			foreach ($header_data as $key => $column_info) {
				$header_json[] = array(
					"value" => convert_to_utf8($key),
					"title" => convert_to_utf8($column_info["title"]),
				);
			}

			$t->set_var("header_data", json_encode($header_json));

			$column_number = 0;
			foreach ($db_columns as $column_name => $column_info) {
				$column_number++;
				if (isset($column_info["title"])) {
					// new format
					$column_title = $column_info["title"];
					$data_type = $column_info["data_type"];
					$field_type = $column_info["field_type"];
					$field_required = $column_info["required"];
					$default_value = isset($column_info["default"]) ? $column_info["default"] : "";
				} else {
					// old format
					$column_title = $column_info[0];
					$data_type = $column_info[1];
					$field_type = $column_info[2];
					$field_required = $column_info[3];
					$default_value = isset($column_info[4]) ? $column_info[4] : "";
				}
					/*
						1 - WHERE_DB_FIELD
						2 - USUAL_DB_FIELD   
						3 - FOREIGN_DB_FIELD
						4 - HIDE_DB_FIELD
						5 - RELATED_DB_FIELD
						6 - CUSTOM_FIELD   
					//*/


				$t->set_var("column_number", htmlspecialchars($column_number));
				$t->set_var("column_name", htmlspecialchars($column_name));
				$t->set_var("column_title", htmlspecialchars($column_title));
				// check if we can find some data source
				$source_type = ""; $source_key = ""; 
				$type_desc = ""; $key_desc = "";
				$check_name = trim(strtolower($column_name));
				$check_title = trim(strtolower($column_title));
				if (isset($header_data[$check_name])) {
					$row_class = "source";
					$source_type = strtolower($file_type);
					$type_desc = strtoupper($file_type);
					$source_key = $check_name;
					$key_desc = $header_data[$source_key]["title"];
				} else if (isset($header_data[$check_title])) {
					$row_class = "source";
					$source_type = strtolower($file_type);
					$type_desc = strtoupper($file_type);
					$source_key = $check_title;
					$key_desc = $header_data[$source_key]["title"];
				} else {
					$row_class = "unselected";
					$source_key = "Please Select"; 

					$type_desc = "&ndash;";
					$source_type = "ignore";
					$row_class = "ignore";
					$source_key = "Ignore"; 
					$key_desc = $source_key;
				}

				$t->set_var("source_type", htmlspecialchars($source_type));
				$t->set_var("type_desc", $type_desc);
				$t->set_var("source_key", htmlspecialchars($source_key));
				$t->set_var("key_desc", htmlspecialchars($key_desc));
				$t->set_var("row_class", htmlspecialchars($row_class));

				$t->parse("columns", true);
			}

			$t->set_var("total_columns", sizeof($db_columns));
			fclose($fp);
		}
	} elseif ($operation == "import") {

		// import data
		$operation = "insert";
		$total_columns = get_param("total_columns");
		$total_errors = 0;
		$is_where = false;

		$r = new VA_Record($table_name);
		/* RELATED
		if ($import_related_table) {
			$sub_r = new VA_Record($related_table_name);
			if ($related_table == "orders_items") {
				$sub_r->add_textbox("item_id", INTEGER);
				$sub_r->change_property("item_id", USE_SQL_NULL, false);
			}
		}//*/
		$r_no = array();

		// initialize all fields available for selected table
		$related_fields = array();
		foreach ($db_columns as $column_name => $column_info) {
			if (isset($column_info["title"])) {
				// new format
				$column_title = $column_info["title"];
				$data_type = $column_info["data_type"];
				$field_type = $column_info["field_type"];
				$field_required = $column_info["required"];
				$is_default_value = isset($column_info["default"]);
				$default_value = $is_default_value ? $column_info["default"] : "";
			} else {
				// old format
				$column_title = $column_info[0];
				$data_type = $column_info[1];
				$field_type = $column_info[2];
				$field_required = $column_info[3];
				$is_default_value = isset($column_info[4]);
				$default_value =  $is_default_value ? $column_info[4] : "";
			}
			// 1 - WHERE_DB_FIELD 2 - USUAL_DB_FIELD 3 - FOREIGN_DB_FIELD 4 - HIDE_DB_FIELD 5 - RELATED_DB_FIELD 6 - CUSTOM_FIELD   

			// todo todo todo
			$source_type = get_param("source_type_".$column_name);
			$source_key = get_param("source_key_".$column_name);
			if ($field_type == WHERE_DB_FIELD) {
				$r->add_where($column_name, $data_type, $column_title);
				$r->change_property($column_name, USE_IN_INSERT, true);
				if (strlen($source_type) && $source_type != "ignore") {
					$is_where = true;
				}
			} elseif ($field_type > 1 && $field_required == true) {
				$r->add_textbox($column_name, $data_type, $column_title);
				$r->change_property($column_name, REQUIRED, true);
				$r->change_property($column_name, USE_IN_UPDATE, false); 
				if (is_array($default_value) || strlen($default_value)) {
					$r->set_value($column_name, $default_value);
				}
			} elseif ($field_type == USUAL_DB_FIELD && $field_required == false) {
				$r->add_textbox($column_name, $data_type, $column_title);
				$r->change_property($column_name, USE_IN_UPDATE, false); 
				if ($is_default_value) {
					if (strlen($default_value)) {
						$r->set_value($column_name, $default_value);
					} else {
						// don't put null values if there empty value
						$r->change_property($column_name, USE_SQL_NULL, false);
					}
				}
			} else if ($field_type == RELATED_DB_FIELD) {
				if (strlen($source_type) && $source_type != "ignore") {
					$related_fields[] = $column_name;
				}
			}


			// if it not where and relate field and source available we re-initiliaze field
			if ($field_type != WHERE_DB_FIELD && $field_type != RELATED_DB_FIELD && strlen($source_type) && $source_type != "ignore") {
				$r->add_textbox($column_name, $data_type, $column_title);
				if ($data_type == DATE) {
					$r->change_property($column_name, VALUE_MASK, $date_edit_format);
				} elseif ($data_type == DATETIME) {
					$r->change_property($column_name, VALUE_MASK, $datetime_edit_format);
/*
echo "<br/>name:".$column_name;
echo "<br/>value:".$r->get_value($column_name);
echo "<br/>mask:";
print_r($datetime_edit_format);
echo "<br/>Check:";
	print_r($r->get_property_value($column_name, VALUE_MASK));
*/
				}
				$r->change_property($column_name, USE_IN_UPDATE, true);
				if ($column_name == "login") {
					// login field should be unique always
					$r->change_property($column_name, UNIQUE, true); 
					$r->change_property($column_name, MIN_LENGTH, 3); 
				}
				if ($column_name == "serial_number") {
					// serial number field should be unique 
					$r->change_property($column_name, UNIQUE, true); 
				}
				// added additional checks for friendly url field
				if ($column_name == "friendly_url") {
					$r->change_property("friendly_url", REGEXP_MASK, FRIENDLY_URL_REGEXP);
					$r->change_property("friendly_url", REGEXP_ERROR, ALPHANUMERIC_ALLOWED_ERROR);
				}
			}

		}

		// add some additional fields
		add_imported_fields();

		/* RELATED FIELDS
		if ($import_related_table) {
			foreach ($related_columns as $column_name => $column_info) {
				if ($field_type == 1) {
					$related_where_column = $column_name;
					$sub_r->add_where($column_name, $data_type, $column_title);
					$sub_r->change_property($related_where_column, USE_IN_INSERT, true);
				} elseif ($field_type > 1 && $field_required == true) {
					$sub_r->add_textbox($column_name, $data_type, $column_title);
					$sub_r->change_property($column_name, REQUIRED, true);
					$sub_r->change_property($column_name, USE_IN_UPDATE, false);
					if (isset($column_info[4]) && (is_array($column_info[4]) || strlen($column_info[4]))) {
						$sub_r->set_value($column_name, $column_info[4]);
					}
				} elseif ($field_type == HIDE_DB_FIELD || ($field_type == USUAL_DB_FIELD && $field_required == false && isset($column_info[4]))) {
					$sub_r->add_textbox($column_name, $data_type, $column_title);
					$sub_r->change_property($column_name, USE_IN_UPDATE, false);
					if (isset($column_info[4]) && strlen($column_info[4])) {
						$sub_r->set_value($column_name, $column_info[4]);
					} else {
						$sub_r->change_property($column_name, USE_SQL_NULL, false);
					}
				}
			}
		}//*/


		$column_number = 0; $sub_related_fields = array();
			/* RELATED COLUMNS
			$column_number++;
			if ($import_related_table && isset($related_columns[$column_name])) {
				if ($related_columns[$column_name][2] == RELATED_DB_FIELD) {
					$sub_related_fields[] = $col;
				} else {
					$sub_r->add_textbox($column_name, $related_columns[$column_name][1], $related_columns[$column_name][0]);
					if ($related_columns[$column_name][1] == DATE) {
						$sub_r->change_property($column_name, VALUE_MASK, $date_edit_format);
					} elseif ($related_columns[$column_name][1] == DATETIME) {
						$sub_r->change_property($column_name, VALUE_MASK, $datetime_edit_format);
					}
					$sub_r->change_property($column_name, USE_IN_UPDATE, true);
					if ($related_columns[$column_name][2] == USUAL_DB_FIELD && $related_columns[$column_name][3] == false &&
					isset($related_columns[$column_name][4])) {
						if (!strlen($related_columns[$column_name][4])) {
							$sub_r->change_property($column_name, USE_SQL_NULL, false);
						}
					}
				}
			}//*/
			// update fields properties which are available for uploaded CSV file

		$t->set_var("total_columns", $total_columns);

		if ($rnd == $session_rnd) {
			$records_error = get_session("session_records_error");
			$records_added = get_session("session_records_added");
			$records_updated = get_session("session_records_updated");
			$records_ignored = get_session("session_records_ignored");

			$operation = "result";
		} else {
			$records_error = 0; $records_added = 0; $records_updated = 0; $records_ignored = 0;

			// get max property_id
			$sql  = " SELECT MAX(property_id) FROM " . $table_prefix . "items_properties ";
			$max_property_id = get_db_value($sql);

			// start processing rows
			$is_next_row = false;

			$fp = fopen($csv_file_path, "r");
			if ($fp) {

				$data_file = FilesImportStrategy::getParser($file_type, $csv_file_path, $fp, $delimiter_char);

				// get header data
				$header_data = $data_file->getFieldsHeaders();
				//$csv_data = fgetcsv($fp, 4096, $delimiter_char);
				//$header_data = get_header_data($csv_data);

				// check first row for data
				$data = $data_file->getFieldsData();
				//$data = fgetcsv($fp, 65536, $delimiter_char);
				//$is_next_row = is_array($data);
			}
			$prev_item_id = 0;
//var_dump($data);
			//while ($is_next_row) {
			foreach($data as $k => $data_assoc){
				$t->set_var("cols", "");
				$column_number = 0;

				// clear state and country data
				if ($table == "users" || $table == "orders") {
					$r->set_value("country_id", "");
					$r->set_value("state_id", "");
					$r->set_value("delivery_country_id", "");
					$r->set_value("delivery_state_id", "");
				}

				$r->set_value($table_pk, ""); // always clearing the PK field as it could absent in parameters list but still could be set in different way 
				// set values
				foreach ($db_columns as $column_name => $column_info) {
					if (isset($column_info["title"])) {
						// new format
						$column_title = $column_info["title"];
						$data_type = $column_info["data_type"];
						$field_type = $column_info["field_type"];
						$field_required = $column_info["required"];
						$is_default_value = isset($column_info["default"]);
						$default_value = $is_default_value ? $column_info["default"] : "";
					} else {
						// old format
						$column_title = $column_info[0];
						$data_type = $column_info[1];
						$field_type = $column_info[2];
						$field_required = $column_info[3];
						$is_default_value = isset($column_info[4]);
						$default_value =  $is_default_value ? $column_info[4] : "";
					}
					$source_type = get_param("source_type_".$column_name);
					$source_key = get_param("source_key_".$column_name);


					if ($field_type > 1 && $field_required == true) {
						if ($is_default_value && (is_array($default_value) || strlen($default_value))) {
							$r->set_value($column_name, $default_value);
						}
					}


					// set data from the source
					if (strlen($source_type) && $source_type != "ignore" && $field_type != RELATED_DB_FIELD) {
						if ($source_type == "default") {
							$field_value = $source_key;
						} else if ($source_type == "csv") {
							//$csv_column = $header_data[$source_key]["id"];
							//$field_value = isset($data[$csv_column]) ? $data[$csv_column] : "";
							$csv_column = $header_data[$source_key]["title"];
							$csv_column = str_replace(" ", "_", strtolower($csv_column));
							$field_value = get_value_by_key($data_assoc, $csv_column);
						} else if ($source_type == "xml") {
							$xml_column = $header_data[$source_key]["title"];
							$xml_column = str_replace(" ", "_", strtolower($xml_column));
							$field_value = get_value_by_key($data_assoc, $xml_column);
						}
						/* allow to replace wrong digit separator
						if ($db_columns[$column_name][1] == FLOAT || $db_columns[$column_name][1] == NUMBER) {
						$field_value = str_replace(",", ".", $field_value);
						$field_value = str_replace(";", ".", $field_value);
						}//*/
						if (COMMA_DECIMAL && in_array($column_name, $prices)) {
							$field_value = str_replace(',', '.', $field_value);
						}
						$r->set_value($column_name, $field_value);
						$r->change_property($column_name, IS_VALID, true);
						$r->change_property($column_name, ERROR_DESC, "");
					} //*/

				}
			  // check if some primary field can be ignored
				if ($table == "items") {
					if (!$r->is_empty("item_id")) {
						$r->change_property("item_id", USE_IN_WHERE, true);
						$r->change_property("item_code", USE_IN_WHERE, false);
						$r->change_property("manufacturer_code", USE_IN_WHERE, false);
					} else if ($match_item_code || $match_manufacturer_code) {
						$r->change_property("item_id", USE_IN_WHERE, false);
						if ($match_item_code) {
							$r->change_property("item_code", USE_IN_WHERE, true);
						}
						if ($match_manufacturer_code) {
							$r->change_property("manufacturer_code", USE_IN_WHERE, true);
						}
					}
				}

				/*
				if ($import_related_table) {
					foreach ($related_columns as $column_name => $column_info) {
						if ($field_type > 1 && $field_required == true) {
							if ($is_default_value && (is_array($default_value) || strlen($default_value))) {
								$sub_r->set_value($column_name, $default_value);
							}
						}
					}
				}//*/
				$sub_r_fields     = array();
				$sub_r_fields_max = 0;


						/* OLD CSV STRUCTURE
						$field_value = isset($data[$col - 1]) ? $data[$col - 1] : "";
						$column_name = get_param("db_column_" . $col);

						if ($import_related_table && isset($related_columns[$column_name])) {
							$new_field_value = trim(implode(',', array_unique( explode($related_delimiter_char, $field_value) ) ) );
							if (!strlen($new_field_value)) $new_field_value = NULL;
							if ($related_columns[$column_name][2] != RELATED_DB_FIELD) {
								$sub_r->set_value($column_name, $new_field_value);
								if ($related_delimiter_char != "row") {
									$field_value_exploded = explode($related_delimiter_char, $field_value);
									if ($sub_r_fields_max < count($field_value_exploded)) {
										$sub_r_fields_max = count($field_value_exploded);
									}
									$sub_r_fields[] = array ("name" => $column_name, "values" => $field_value_exploded);
								}
							}
							if (isset($db_columns[$column_name]) && ($db_columns[$column_name][2] != RELATED_DB_FIELD)) {
								if (!$r->get_value($column_name)) {
									$r->set_value($column_name, $new_field_value);
								}
							}
						} //*/


				$r->errors = "";
				if ($table == "orders") {
					before_orders_save();
				}
				if ($table == "users" || $table == "orders") {
					check_country_state();
				}
				// before validate record we need to check if it exists or not
				$pk_id = ""; 
				$is_exists = false;
				$is_where_set = ($is_where && $r->check_where());
				if ($is_where_set) {
					$r->where_set = true; // this parameter required for unique validation 
					$sql  = " SELECT " . $table_pk . " FROM " . $table_name . "";
					$sql .= $r->get_where();
					$db->query($sql);
					if ($db->next_record()) {
						$pk_id = $db->f($table_pk);
						$r->set_value($table_pk, $pk_id);
						$is_exists = true;
					}
				}
				// set show status to false for all fields which we don't need to update 
				if ($is_exists) {
					foreach ($r->parameters as $key => $value) {				
						if ($r->get_property_value($key, USE_IN_UPDATE) === false) {
							$r->change_property($key, SHOW, false);
						}
					}
				}
				$r->validate();
				// back status show to true for next insert record
				if ($is_exists) {
					foreach ($r->parameters as $key => $value) {				
						if ($r->get_property_value($key, USE_IN_UPDATE) === false) {
							$r->change_property($key, SHOW, true);
						}
					}
				}

				// start insert / update records	
				if ($r->errors) {
					//echo $r->errors; TODO: show errors
					$records_ignored++;
					$pk_id = $r->get_value($table_pk); 
					$t->set_var("pk_id", htmlspecialchars($pk_id));
					$t->set_var("error_desc", $r->errors);
					$t->parse("records_errors", true);
				} else {
					$new_item_id = $r->get_value($table_pk);

					if ($import_related_table && $new_item_id>0 && ($new_item_id == $prev_item_id)) {
						// do nothing
					} elseif ($is_exists) {
						import_friendly_url(); // function to check duplicated friendly urls
						if ($r->update_record()) {
							$records_updated++;
						} else {
							$records_error++;

							$pk_id = $r->get_value($table_pk); 
							$t->set_var("pk_id", htmlspecialchars($pk_id));
							$t->set_var("error_desc", $db->Error);
							$t->parse("records_errors", true);
						}
					} else {
						if ($r->is_empty($table_pk)) {
							$sql = "SELECT MAX(" . $table_pk . ") FROM " . $table_name . "";
							$db->query($sql);
							$db->next_record();
							$max_id = $db->f(0);
							$r->set_value($table_pk, ($max_id + 1));
						}
						import_friendly_url(); // function to check duplicated friendly urls
						if ($r->insert_record()) {
							$records_added++;
							$pk_id = $r->get_value($table_pk);
						} else {
							$records_error++;
						}
					}

					if (strlen($pk_id)) {							
						if ($table == "orders") {
							after_orders_save($pk_id);
						}
					}

					$new_item_id = $r->get_value($table_pk);

					// save order products
					/*
					if ($import_related_table) {
						if (isset($related_columns_from_main)) {
							foreach ($related_columns_from_main AS $related_column_name) {
								if (!$r->is_empty($related_column_name)) {
									$sub_r->add_textbox($related_column_name, $db_columns[$related_column_name][1]);
									$sub_r->set_value($related_column_name, $r->get_value($related_column_name));
								}
							}
						}
						$sub_r->add_textbox($table_pk, INTEGER);
						$sub_r->set_value($table_pk, $new_item_id);
						if ($new_item_id != $prev_item_id) {
							$sql = " DELETE FROM " . $related_table_name . " WHERE " . $table_pk . "=" . $db->tosql($new_item_id, INTEGER);
							$db->query($sql);
							if ($table == "orders") {
								$sql = " DELETE FROM " . $table_prefix . "orders_items_properties WHERE order_id=" . $db->tosql($new_item_id, INTEGER);
								$db->query($sql);
							}
						}
						$sql = "SELECT MAX(" . $related_aliases["id"] . ") FROM " . $related_table_name;
						$max_sub_id = get_db_value($sql);
						if ($related_delimiter_char == "row" || !(isset($sub_r_fields)) || !($sub_r_fields_max>1)) {
							$max_sub_id++;
							$sub_r->set_value($related_aliases["id"], $max_sub_id);		
							if ($related_table == "orders_items") {
								before_orders_items_save();
							}					
							$sub_r->insert_record();
							if ($related_table == "orders_items") {
								after_orders_items_save();
							}													
							for ($ri = 0; $ri < sizeof($sub_related_fields); $ri++) {
								$related_col   = $sub_related_fields[$ri];
								$column_name   = get_param("db_column_" . $related_col);
								$column_value  = get_param("db_value_" . $related_col);

								$related_prop_table = $related_columns[$column_name][4];
								$related_value = isset($data[$related_col - 1]) ? $data[$related_col - 1] : "";
								if ($related_prop_table == $table_prefix . "order_items_properties") {
									update_orders_items_properties($sub_r->get_value($related_aliases["id"]), $new_item_id, $related_value);
								}
							}
						} else {
							// products in one line separated by \t \s etc
							$sub_r_inserted_ids=array();
							for ($sb=0; $sb < $sub_r_fields_max; $sb++) {
								for ($sf=0; $sf < count($sub_r_fields); $sf++) {
									$column_name = $sub_r_fields[$sf]["name"];
									if (isset($sub_r_fields[$sf]["values"][$sb])) {
										$field_value = $sub_r_fields[$sf]["values"][$sb];
									} elseif (isset($sub_r_fields[$sf]["values"][0])) {
										$field_value = $sub_r_fields[$sf]["values"][0];
									} elseif (isset($related_columns[$column_name][4])) {
										$field_value = $related_columns[$column_name][4];
									} else {
										$field_value = NULL;
									}
									if ($related_columns[$column_name][2] != RELATED_DB_FIELD) {
										$sub_r->set_value($column_name, $field_value);
									}
								}
								$max_sub_id++;
								$sub_r->set_value($related_aliases["id"], $max_sub_id);								
								if ($related_table == "orders_items") {
									before_orders_items_save();
								}							
								$sub_r->insert_record();												
								$sub_r_inserted_ids[] = $sub_r->get_value($related_aliases["id"]);
								if ($related_table == "orders_items") {
									after_orders_items_save();
								}		
							}

							for ($ri = 0; $ri < sizeof($sub_related_fields); $ri++) {
								$related_col   = $sub_related_fields[$ri];
								$column_name   = get_param("db_column_" . $related_col);
								$column_value  = get_param("db_value_" . $related_col);
								$related_prop_table = $related_columns[$column_name][4];
								$col_n = str_replace(" ", "_", strtolower($column_name));
								//$related_value = isset($data[$related_col - 1]) ? $data[$related_col - 1] : "";
								$related_value = get_value_by_key($data_assoc, $col_n);
								if ($related_prop_table == $table_prefix . "order_items_properties") {									
									$field_value_exploded = explode($related_delimiter_char, $related_value);								
									for ($sb=0; $sb<$sub_r_fields_max; $sb++){
										if (isset($field_value_exploded[$sb]) && $field_value_exploded[$sb]) {
											update_orders_items_properties($sub_r_inserted_ids[$sb], $new_item_id, $field_value_exploded[$sb]);
										}
									}
								}
							}
						}
					}//*/

					$prev_item_id = $r->get_value($table_pk);
					// end save order products

					// added data to related tables

					if (strlen($pk_id))
					{
						$property_order = 0; $category_column = false;
						for ($ri = 0; $ri < sizeof($related_fields); $ri++) {
							$column_name = $related_fields[$ri];
							$source_type = get_param("source_type_".$column_name);
							$source_key = get_param("source_key_".$column_name);
							
							if (isset($db_columns[$column_name]["title"])) { // new format
								$related_prop_table = get_setting_value($db_columns[$column_name], "related_table", "");
							} else { // old format
								$related_prop_table = get_setting_value($db_columns[$column_name], "4", ""); 
							}

							//$related_value = isset($data[$related_col - 1]) ? $data[$related_col - 1] : "";
							$col_n = str_replace(" ", "_", ($source_key));
							$related_value = get_value_by_key($data_assoc, $col_n);

							if ($related_prop_table == $table_prefix . "order_properties") {
								update_orders_properties($pk_id, $related_value);
							} elseif ($related_prop_table == $table_prefix . "users_properties") {
								update_user_properties($pk_id, $related_value);
							} elseif ($related_prop_table == $table_prefix . "items_properties") {
								update_items_properties($pk_id, $related_value);
							} elseif ($related_prop_table == $table_prefix . "categories") {
								$category_column = true;
								update_items_categories($pk_id, $related_value);
							} elseif ($related_prop_table == $table_prefix . "manufacturers") {
								update_manufacturer($pk_id, $related_value);
							} elseif ($related_prop_table == $table_prefix . "features") {
								update_items_features($pk_id, $related_value);
							}
						}

						// added link to category
						if ($table_name == $table_prefix . "items" && !$category_column && !$is_exists) {
							$sql  = " INSERT INTO " . $table_prefix . "items_categories (item_id, category_id) ";
							$sql .= " VALUES (" . $db->tosql($pk_id, INTEGER) . ", " . $db->tosql($category_id, INTEGER) . ") ";
							$db->query($sql);
						}
						if ($table_name == $table_prefix . "newsletters_emails") {
							count_newsletter_emails();
						}
					}

				} // end of importing data

				// check if there are more rows to process
				//$data = fgetcsv($fp, 65536, $delimiter_char);
				//$is_next_row = is_array($data);
			}
			// end processing rows
			fclose($fp);


			if ($table_name == $table_prefix . "categories") {
				prepare_categories_list();
				update_categories_tree(0, "");
			}

			set_session("session_records_error", $records_error);
			set_session("session_records_added", $records_added);
			set_session("session_records_updated", $records_updated);
			set_session("session_records_ignored", $records_ignored);

			$operation = "result";

			// it's temporary file which can be deleted
			if (preg_match("/tmp_[0-9a-f]{32}\.csv/", $csv_file_path)) {
				@unlink($csv_file_path);
			}
		}

	} 

	if (strlen($errors))
	{
		//$t->set_var("after_upload", "");
		$t->set_var("errors_list", $errors);
		$t->parse("errors", false);
	}
	else
	{
		$t->set_var("errors", "");
	}

	$t->set_var("operation", $operation);
	$t->set_var("category_id", htmlspecialchars($category_id));
	$t->set_var("newsletter_id", htmlspecialchars($newsletter_id));
	$t->set_var("csv_file_path", htmlspecialchars($csv_file_path));
	$t->set_var("csv_delimiter", htmlspecialchars($csv_delimiter));
	$t->set_var("file_type", $file_type);
	$t->set_var("rnd", va_timestamp());

	$t->set_var("csv_related_delimiter", htmlspecialchars($csv_related_delimiter));
	$t->set_var("import_related_table", $import_related_table);

	$t->set_var("import_block", "");
	$t->set_var("upload_block", "");
	$t->set_var("result_block", "");
	if ($operation == "import") {
		if($file_type === "xml"){
			$xml_elems = array(array("-1", ""));
			$xml_fields = $data_file->getHeaderVisual();

			if(count($xml_fields) == 1){
				$t->set_var("root_elem", $xml_fields[0][0]);
				$t->parse("xml_root_single", false);
			}
			else{
				foreach($xml_fields as $v){
					$xml_elems[] = $v;
				}
				set_options($xml_elems, "-1", "xml_root");
				$t->parse("xml_root_select", false);
			}
			$encoded_fields = $data_file->getHeadersEncoded();
			$t->set_var("keys_chain", $encoded_fields);
		}
		$t->parse("import_block", false);
	} elseif ($operation == "result") {
		$records_error = get_session("session_records_error");
		$records_added = get_session("session_records_added");
		$records_updated = get_session("session_records_updated");
		$records_ignored = get_session("session_records_ignored");

		if ($records_error > 0) {
			$t->set_var("records_error", $records_error);
			$t->parse("db_errors", false);
		}
		$t->set_var("records_added", $records_added);
		$t->set_var("records_updated", $records_updated);
		$t->set_var("records_ignored", $records_ignored);

		if ($records_error || $records_ignored) {
			$t->parse("import_errors", false);
		}

		$t->parse("result_block", false);
	} else {
		$operation = "upload";
		$file_types = array(array("csv", "CSV"), array("xml", "XML"));
		set_options($file_types, $file_type, "file_type");
		$delimiters = array(array(",", COMMA_MSG), array("tab", TAB_MSG), array(";", SEMICOLON_MSG), array("|", VERTICAL_BAR_MSG));
		$related_delimiters = array(array("row", ROWS_MSG), array("comma", COMMA_MSG), array("tab", TAB_MSG), array("space", SPACE_MSG), array("semicolon", SEMICOLON_MSG), array("vertical_bar", VERTICAL_BAR_MSG), array("newline", NEWLINE_MSG));
		set_options($delimiters, $csv_delimiter, "delimiter");
		if (isset($related_table)) {
			set_options($related_delimiters, $csv_related_delimiter, "related_delimiter");
			$t->parse("related_delimiter_block", false);
		}
		$t->parse("upload_block", false);
	}
/*	
	if ($table_name == ($table_prefix . "items") || $table_name == ($table_prefix . "categories")) {
		$t->parse("products_path", false);
	} else {
		$t->set_var("products_path", "");
	}

	if ($table_name == ($table_prefix . "newsletters_users")) {
		$t->parse("newsletters_path", false);
	}
*/	
	$t->pparse("main");

	function before_orders_search() {
		global $r;
		if ($r->parameter_exists("parent_order_id") && $r->is_empty("parent_order_id")) {
			$r->set_value("parent_order_id", 0);
		}
	}

	function before_orders_save()
	{
		global $r, $sub_r, $related_delimiter_char;
		global $r_no, $db, $table_prefix;

		if ($r->parameter_exists("parent_order_id") && $r->is_empty("parent_order_id")) {
			$r->set_value("parent_order_id", 0);
		}

		if (!$r->is_empty("order_id")) {
			$order_id = $r->get_value("order_id");
			if (!is_integer($order_id)) {			
				$order_id = substr(str_replace(array("-", " "), "", $order_id), 0, 6);
				$r->set_value("order_id", $order_id);				
			}
		}

		if ($r->is_empty("order_status") || isset($r_no["order_status"])) {
			$r->add_textbox("order_status", INTEGER);
			$r->set_value("order_status", 4);
			$r_no["order_status"] = 1;
		}
		if (isset($sub_r)) {
			if ($r->is_empty("total_quantity") || isset($r_no["total_quantity"])) {
				$r->add_textbox("total_quantity", INTEGER);
				$r->change_property("total_quantity", USE_SQL_NULL, false);
				$quantity = $sub_r->get_value("quantity");
				$quantity_exploded = explode($related_delimiter_char, $quantity);
				$r->set_value("total_quantity", array_sum($quantity_exploded));
				$r_no["total_quantity"] = 1;
			}
			if ($r->is_empty("goods_total") || isset($r_no["goods_total"])) {
				$r->add_textbox("goods_total", INTEGER);
				$r->change_property("goods_total", USE_SQL_NULL, false);
				$price = $sub_r->get_value("price");
				$price_exploded = explode($related_delimiter_char, $price);
				$quantity = $sub_r->get_value("quantity");
				$quantity_exploded = explode($related_delimiter_char, $quantity);
				$goods_total = 0;
				for ($i=0, $m=min(count($price_exploded),count($quantity_exploded)); $i<$m; $i++) {
					$goods_total = $price_exploded[$i]*$quantity_exploded[$i];
				}
				$r->set_value("goods_total", $goods_total);
				$r_no["goods_total"] = 1;
			}
			if ($r->is_empty("total_buying") || isset($r_no["total_buying"])) {
				$r->add_textbox("total_buying", INTEGER);
				$r->change_property("total_buying", USE_SQL_NULL, false);
				$quantity = $sub_r->get_value("quantity");
				$quantity_exploded = explode($related_delimiter_char, $quantity);
				$r->set_value("total_buying", array_sum($quantity_exploded));
				$r_no["total_buying"] = 1;
			}
		}
		if ((!$r->parameter_exists("order_total")) || $r->is_empty("order_total") || isset($r_no["order_total"])) {
			$r->add_textbox("order_total", NUMBER);
			$r->change_property("order_total", USE_SQL_NULL, false);			
			if ($r->parameter_exists("goods_total")) {
				$goods_total  = $r->get_value("goods_total");
			} else {
				$goods_total = 0;
			}
			if ($r->parameter_exists("shipping_cost")) {
				$shipping_cost = $r->get_value("shipping_cost");
			} else {
				$shipping_cost = 0;
			}
			$r->set_value("order_total", ($goods_total + $shipping_cost));
			$r_no["order_total"] = 1;
		}

		// parse dates, modified in excel
		if (!$r->is_empty("order_placed_date")) {
			$order_placed_date = $r->get_value("order_placed_date");
			$order_placed_date = before_orders_save_check_date($order_placed_date);
			$r->set_value("order_placed_date", $order_placed_date);
		} else {
			$r->set_value("order_placed_date", va_time());
		}

		if (!$r->is_empty("modified_date")) {
			$modified_date = $r->get_value("modified_date");
			$modified_date = before_orders_save_check_date($modified_date);
			$r->set_value("modified_date", $modified_date);
		} else {
			$r->set_value("modified_date", va_time());
		}

		if (!$r->is_empty("shipping_expecting_date")) {
			$shipping_expecting_date = $r->get_value("shipping_expecting_date");
			$shipping_expecting_date = before_orders_save_check_date($shipping_expecting_date);
			$r->set_value("shipping_expecting_date", $shipping_expecting_date);
		}
	}

	function check_country_state()
	{
		global $r;
		if ($r->parameter_exists("country_id") && $r->parameter_exists("country_code")) {
			if (!$r->is_empty("country_id") || !$r->is_empty("country_code")) {
				$country_id   = $r->get_value("country_id");
				$country_code = $r->get_value("country_code");
				before_orders_save_check_country($country_id, $country_code);
				$r->set_value("country_id", $country_id);
				$r->set_value("country_code", $country_code);			
			}		
		}

		if ($r->parameter_exists("state_id") && $r->parameter_exists("state_code")) {
			if (!$r->is_empty("state_id") || !$r->is_empty("state_code")) {
				$state_id = $r->get_value("state_id");
				$state_code = $r->get_value("state_code");
				$country_id = $r->parameter_exists("country_id") ? $r->get_value("country_id") : "";
				before_orders_save_check_state($state_id, $state_code, $country_id);
				$r->set_value("state_id", $state_id);
				$r->set_value("state_code", $state_code);
				$r->set_value("country_id", $country_id);
			}
		}

		if ($r->parameter_exists("delivery_country_id") && $r->parameter_exists("delivery_country_code")) {
			if (!$r->is_empty("delivery_country_id") || !$r->is_empty("delivery_country_code")) {
				$delivery_country_id = $r->get_value("delivery_country_id");
				$delivery_country_code = $r->get_value("delivery_country_code");
				before_orders_save_check_country($delivery_country_id, $delivery_country_code);
				$r->set_value("delivery_country_id", $delivery_country_id);
				$r->set_value("delivery_country_code", $delivery_country_code);
			}
		}

		if ($r->parameter_exists("delivery_state_id") && $r->parameter_exists("delivery_state_code")) {
			if (!$r->is_empty("delivery_state_id") || !$r->is_empty("delivery_state_code")) {
				$delivery_state_id = $r->get_value("delivery_state_id");
				$delivery_state_code = $r->get_value("delivery_state_code");
				$delivery_country_id = $r->parameter_exists("delivery_country_id") ? $r->get_value("delivery_country_id") : "";
				before_orders_save_check_state($delivery_state_id, $delivery_state_code, $delivery_country_id);
				$r->set_value("delivery_state_id", $delivery_state_id);
				$r->set_value("delivery_state_code", $delivery_state_code);
				$r->set_value("delivery_country_id", $delivery_country_id);
			}
		}
	}

	function before_orders_save_check_date($date) {
		if (is_string($date)) {
			$timestamp = strtotime($date);
			if ($timestamp) {
				return date("Y-m-d H:i:s", $timestamp);
			} else {
				return $date;
			}
		} else {
			return $date;
		}
	}

	function before_orders_save_check_country(&$country_id, &$country_code) {
		global $table_prefix, $db;
		$country_id = rtrim(trim($country_id));
		$country_code = rtrim(trim($country_code));
		if ($country_id) {
			if (intval($country_id) > 0) {
				$sql  = " SELECT country_id, country_code FROM " .  $table_prefix . "countries ";
				$sql .= " WHERE country_id=" . $db->tosql($country_id, INTEGER, true, false);
				$db->query($sql);
				if ($db->next_record()) {
					$country_code = $db->f("country_code");
				} else {
					$country_code = $country_id;
				}				
			} else {
				$old_id = strtolower($country_id);
				$sql  = " SELECT country_id, country_code FROM " .  $table_prefix . "countries ";
				$sql .= " WHERE LOWER(country_name)=" . $db->tosql($old_id, TEXT);
				$sql .= " OR LOWER(country_code)=" . $db->tosql($old_id, TEXT);
				$db->query($sql);
				if ($db->next_record()) {
					$country_id   = $db->f("country_id");
					$country_code = $db->f("country_code");
				} else {
					$country_code = $country_id;
				}
			}
		} elseif ($country_code) {			
			$old_code = strtolower($country_code);
			$sql  = " SELECT country_id, country_code FROM " .  $table_prefix . "countries ";
			$sql .= " WHERE LOWER(country_name)=" . $db->tosql($old_code, TEXT);
			$sql .= " OR LOWER(country_code)=" . $db->tosql($old_code, TEXT);
			$db->query($sql);
			if ($db->next_record()) {
				$country_id   = $db->f("country_id");
				$country_code = $db->f("country_code");
			} else {
				$country_code = $country_id;
			}
		}
	}

	function before_orders_save_check_state(&$state_id, &$state_code, $country_id) {
		global $table_prefix, $db;
		$state_id = rtrim(trim($state_id));
		$state_code = rtrim(trim($state_code));
		if (intval($state_id) > 0) {
			$sql  = " SELECT state_id, state_code, country_id FROM " . $table_prefix . "states ";
			$sql .= " WHERE state_id=" . $db->tosql($state_id, INTEGER);
			if ($country_id) {
				$sql .= " AND country_id=" .  $db->tosql($country_id, INTEGER);
			}
			$db->query($sql);
			if ($db->next_record()) {
				$state_id   = $db->f("state_id");
				$state_code = $db->f("state_code");
				$country_id = $db->f("country_id");
			} else {
				$state_id = get_db_value("SELECT MAX(state_id) FROM " .$table_prefix . "states") + 1;
				$sql  = " INSERT INTO " . $table_prefix . "states ";
				$sql .= " (state_id, country_id, state_code, state_name)";
				$sql .= " VALUES (";
				$sql .= $db->tosql($state_id, INTEGER) . ",";
				if ($country_id) {
					$sql .= $db->tosql($country_id, INTEGER) . ",";
				} else {
					$sql .= "0,";
				}
				if (strlen($state_code)) {
					$sql .= $db->tosql($state_code, TEXT). ",";
					$sql .= $db->tosql($state_code, TEXT). ")";
				} else {
					$state_code = substr($state_id, 0, 2);
					$sql .= $db->tosql($state_code, TEXT). ",";
					$sql .= $db->tosql($state_id, TEXT). ")";
				}
				$db->query($sql);
			}		
		} elseif ($country_id) {
			$old_id = strtolower($state_id);
			$old_code = strtolower($state_code);			
			$sql  = " SELECT state_id, state_code FROM " . $table_prefix . "states ";
			$sql .= " WHERE ( LOWER(state_name)=" . $db->tosql($old_id, TEXT);
			if ($state_code) {
				$sql .= " OR LOWER(state_code)=" .  $db->tosql($old_code, TEXT);			
				$sql .= " OR LOWER(state_code)=" .  $db->tosql($old_code, TEXT);
			}
			$sql .= " OR LOWER(state_code)=" .  $db->tosql($old_id, TEXT) . ") ";
			if ($country_id) {
				$sql .= " AND country_id=" .  $db->tosql($country_id, INTEGER);
			}
			$db->query($sql);
			if ($db->next_record()) {
				$state_id   = $db->f("state_id");
				$state_code = $db->f("state_code");
			} else {				
				$state_id = get_db_value("SELECT MAX(state_id) FROM " .$table_prefix . "states") + 1;				
				$sql  = " INSERT INTO " . $table_prefix . "states ";
				$sql .= " (state_id, country_id, state_code, state_name)";
				$sql .= " VALUES(";
				$sql .= $db->tosql($state_id, INTEGER) . ",";
				if ($country_id) {
					$sql .= $db->tosql($country_id, INTEGER) . ",";
				} else {
					$sql .= "0,";
				}
				if (strlen($state_code)) {
					$sql .= $db->tosql($state_code, TEXT). ",";
					$sql .= $db->tosql($state_code, TEXT). ")";
				} else {
					$state_code = substr($state_id, 0, 2);
					$sql .= $db->tosql($state_code, TEXT). ",";
					$sql .= $db->tosql("UNDEFINED", TEXT). ")";
				}
				$db->query($sql);				
			}
		}
	}

	function before_orders_items_save()
	{
		global $sub_r, $db, $table_prefix;
		$item_id = $sub_r->get_value("item_id");
		$quantity = $sub_r->get_value("quantity");

		if (!$item_id) {
			if (!$sub_r->is_empty("item_code")) {
				$item_code = $sub_r->get_value("item_code");
				$sql  = " SELECT item_id FROM " . $table_prefix . "items ";
				$sql .= " WHERE item_code=" . $db->tosql($item_code, TEXT, true, false);
				$item_id = get_db_value($sql);
			}
			if (!$item_id && !$sub_r->is_empty("manufacturer_code")) {
				$manufacturer_code = $sub_r->get_value("manufacturer_code");
				$sql  = " SELECT item_id FROM " . $table_prefix . "items ";
				$sql .= " WHERE manufacturer_code=" . $db->tosql($manufacturer_code, TEXT, true, false);
				$item_id = get_db_value($sql);
			}
			$sub_r->set_value("item_id", $item_id);
		}
	}

	function after_orders_items_save()
	{
		global $sub_r, $db, $table_prefix;
		$item_id = $sub_r->get_value("item_id");
		$quantity = $sub_r->get_value("quantity");

		if ($quantity && $item_id) {
			$sql  = " SELECT stock_level FROM " . $table_prefix . "items ";
			$sql .= " WHERE item_id=" . $db->tosql($item_id, INTEGER, true, false);
			$old_stock = get_db_value($sql);

			$sql  = " UPDATE " . $table_prefix . "items SET stock_level=" . $db->tosql($old_stock - $quantity, INTEGER, true, false);
			$sql .= " WHERE item_id=" . $db->tosql($item_id, INTEGER, true, false);
			$db->query($sql);
		}

		$sub_r->set_value("item_id", 0);
	}

	function update_orders_items_properties($order_item_id, $order_id, $related_value) 
	{
		global $db, $table_prefix, $column_name, $column_value;
		if (!$related_value) return false;
		$property_name   = substr($column_name, 20);	
		$property_id         = 0;
		$property_values_ids = array();	
		$additional_price    = 0;
		$additional_weight   = 0;

		$sql  = " SELECT property_id, additional_price FROM " . $table_prefix . "items_properties WHERE property_name=" . $db->tosql($property_name, TEXT);
		$db->query($sql);
		if ($db->next_record()) {
			$property_id      = $db->f('property_id');
			$additional_price = $db->f('additional_price');
			$tmp = explode (",", $related_value);
			foreach ($tmp AS $property_value) {
				$property_value = trim($property_value);
				$sql  = " SELECT item_property_id, additional_price, additional_weight FROM " . $table_prefix . "items_properties_values ";
				$sql .= " WHERE property_id=" . $db->tosql($property_id, INTEGER, true, false). " AND property_value=" . $db->tosql($property_value, TEXT);
				$db->query($sql);
				if ($db->next_record()) {
					$property_values_ids[] = $db->f('item_property_id');
					$additional_price  += $db->f('additional_price');
					$additional_weight += $db->f('additional_weight');				
				}
			}
		}	

		$sql  = " INSERT INTO " . $table_prefix . "orders_items_properties ";
		$sql .= " (order_id, order_item_id, property_id, property_values_ids, property_name, property_value, additional_price, additional_weight) ";
		$sql .= " VALUES (" . $db->tosql($order_id, INTEGER) . ", " ;
		$sql .= $db->tosql($order_item_id, INTEGER) . ", " ;
		$sql .= $db->tosql($property_id, INTEGER, true, false) . ", " ;
		$sql .= $db->tosql(implode(',', $property_values_ids), TEXT, true, false) . ", " ;
		$sql .= $db->tosql($property_name, TEXT) . ", " ;
		$sql .= $db->tosql($related_value, TEXT) . ", ";
		$sql .= $db->tosql($additional_price,  FLOAT, true, false) . ", ";
		$sql .= $db->tosql($additional_weight, FLOAT, true, false) . ") ";
		$db->query($sql);
	}

	function after_orders_save($order_id) {
		global $db, $table_prefix;
		$sql  = " DELETE FROM " . $table_prefix . "orders_properties WHERE order_id=" . $db->tosql($order_id, INTEGER);
		$db->query($sql);		
	}

	function update_orders_properties($item_id, $related_value) 
	{
		global $db, $table_prefix, $column_name, $column_value;
		$property_id = substr($column_name, 15);

		$property_order  = 0;
		$property_type   = 1;
		$property_name   = $column_value;
		$property_price  = 0;
		$property_weight = 0;
		$property_tax_free = 0;
		$property_value_id = 0;
		$tmp = explode (";", $related_value);
		foreach ($tmp AS $property_value) {
			$property_value = trim($property_value);
			$sql  = " SELECT p.property_order,p.property_type,p.property_name,p.tax_free, ";
			$sql .= " pv.property_price, pv.property_weight, pv.property_value_id ";
			$sql .= " FROM ( " . $table_prefix . "order_custom_properties p ";
			$sql .= " LEFT JOIN " . $table_prefix . "order_custom_values pv ON pv.property_id=p.property_id) ";
			$sql .= " WHERE p.property_id=" . $db->tosql($property_id, INTEGER);
			$sql .= " AND ( pv.property_value=" . $db->tosql($property_value , TEXT);
			$sql .= " OR  pv.property_value_id=" . $db->tosql($property_value , TEXT) . ")";
			$db->query($sql);
			if ($db->next_record()) {
				$property_order    = $db->f('property_order');
				$property_type     = $db->f('property_type');
				$property_name     = $db->f('property_name');
				$property_price    += $db->f('property_price');
				$property_weight   += $db->f('property_weight');
				$property_tax_free = $db->f('tax_free');
				$property_value_id = $db->f('property_value_id');
			}
		}
		if ($property_value_id) {
			$related_value = $property_value_id;
		}
		$sql  = " INSERT INTO " . $table_prefix . "orders_properties ";
		$sql .= " (order_id, property_id, property_order, property_type, property_name, property_value,property_price,property_weight,tax_free) ";
		$sql .= " VALUES (" . $db->tosql($item_id, INTEGER) . ", " ;
		$sql .= $db->tosql($property_id, INTEGER) . ", " ;
		$sql .= $db->tosql($property_order, INTEGER, true, false) . ", " ;
		$sql .= $db->tosql($property_type, INTEGER, true, false) . ", " ;
		$sql .= $db->tosql($property_name, TEXT) . ", " ;
		$sql .= $db->tosql($related_value, TEXT) . ", ";
		$sql .= $db->tosql($property_price,  FLOAT, true, false) . ", ";
		$sql .= $db->tosql($property_weight, FLOAT, true, false) . ", " ;
		$sql .= $db->tosql($property_tax_free , INTEGER, true, false) . ") ";
		$db->query($sql);
	}


	function update_user_properties($user_id, $related_value) 
	{
		global $db, $table_prefix, $column_name, $column_value;
		
		if (preg_match("/^user_property_(\d+)$/", $column_name, $matches)) {
			$property_id = $matches[1];
		} else {
			return;
		}

		// check control type first
		$control_type = "";
		$sql  = " SELECT control_type FROM " . $table_prefix . "user_profile_properties ";
		$sql .= " WHERE property_id=" . $db->tosql($property_id, INTEGER);
		$db->query($sql);
		if ($db->next_record()) {
			$control_type = $db->f("control_type");
		}

		// get property values
		$property_values = array();
		if($control_type == "CHECKBOXLIST" ||  $control_type == "RADIOBUTTON" || $control_type == "LISTBOX") {
			$check_values = explode (";", $related_value);
			foreach ($check_values as $key => $property_value) {
				$property_value = trim($property_value);
				$sql  = " SELECT property_value_id FROM " . $table_prefix . "user_profile_values ";
				$sql .= " WHERE property_id=" . $db->tosql($property_id, INTEGER);
				$sql .= " AND property_value=" . $db->tosql($property_value, TEXT);
				$db->query($sql);
				if ($db->next_record()) {
					$property_values[] = $db->f("property_value_id");
				}
			}
		} else if (strlen($related_value)) {
			$property_values[] = $related_value;
		}

		// clear old values 
		$sql  = " DELETE FROM " . $table_prefix . "users_properties ";
		$sql .= " WHERE user_id=" . $db->tosql($user_id, INTEGER);
		$sql .= " AND property_id=" . $db->tosql($property_id, INTEGER);
		$db->query($sql);

		// add new values
		foreach ($property_values as $property_value) {
			$sql  = " INSERT INTO " . $table_prefix . "users_properties ";
			$sql .= " (user_id, property_id, property_value) ";
			$sql .= " VALUES (" . $db->tosql($user_id, INTEGER) . ", " ;
			$sql .= $db->tosql($property_id, INTEGER) . ", " ;
			$sql .= $db->tosql($property_value, TEXT) . ") " ;
			$db->query($sql);
		}
	}


	function update_items_categories($item_id, $categories_info)
	{
		global $db, $table_prefix;

		$categories_info = trim($categories_info);
		$sql = " DELETE FROM " . $table_prefix . "items_categories WHERE item_id=" . $db->tosql($item_id, INTEGER);
		$db->query($sql);

		$categories_list = explode(";", $categories_info);
		for ($i = 0; $i < sizeof($categories_list); $i++) {
			$category_info = $categories_list[$i];
			$categories_names = explode(">", $category_info);

			$last_category_id = 0; $category_path = "";
			for ($ci = 0; $ci < sizeof($categories_names); $ci++) {
				$category_name = trim($categories_names[$ci]);
				if (strval($category_name) == "0") {
					$category_path = "0,";
				} elseif (strlen($category_name)) {
					$category_path .= $last_category_id . ",";
					$sql  = " SELECT category_id FROM " . $table_prefix . "categories ";
					$sql .= " WHERE parent_category_id=" . $db->tosql($last_category_id, INTEGER);
					$sql .= " AND category_name=" . $db->tosql($category_name, TEXT);
					$db->query($sql);
					if ($db->next_record()) {
						$last_category_id = $db->f("category_id");
					} else {
						$parent_category_id = $last_category_id;
						$sql  = " SELECT MAX(category_id) FROM " . $table_prefix . "categories ";
						$last_category_id = get_db_value($sql) + 1;

						$sql  = " SELECT MAX(category_order) FROM " . $table_prefix . "categories ";
						$sql .= " WHERE parent_category_id=" . $db->tosql($parent_category_id, INTEGER);
						$category_order = get_db_value($sql) + 1;

						$sql  = " INSERT INTO " . $table_prefix . "categories ";
						$sql .= " (category_id, parent_category_id, category_path, category_name, category_order, is_showing) VALUES (";
						$sql .= $db->tosql($last_category_id, INTEGER) . ", ";
						$sql .= $db->tosql($parent_category_id, INTEGER) . ", ";
						$sql .= $db->tosql($category_path, TEXT) . ", ";
						$sql .= $db->tosql($category_name, TEXT) . ", ";
						$sql .= $db->tosql($category_order, INTEGER) . ", 1) ";
						$db->query($sql);
					}
				}
			}

			if (strlen($category_path)) {
				$sql  = " INSERT INTO " . $table_prefix . "items_categories (item_id, category_id) ";
				$sql .= " VALUES (" . $db->tosql($item_id, INTEGER) . ", " . $db->tosql($last_category_id, INTEGER) . ") ";
				$db->query($sql);
			}
		}
	}

	function update_items_properties($item_id, $properties_info)
	{
		global $db, $table_prefix, $column_value, $property_order, $max_property_id;

		$properties_info = trim($properties_info);

		$property_id = "";
		$sql  = " SELECT property_id FROM " . $table_prefix . "items_properties ";
		$sql .= " WHERE item_id=" . $db->tosql($item_id, INTEGER);
		$sql .= " AND property_name=" . $db->tosql($column_value, TEXT);
		$db->query($sql);
		if ($db->next_record()) {
			$property_id = $db->f("property_id");
			$sql = " DELETE FROM " . $table_prefix . "items_properties_values WHERE property_id=" . $db->tosql($property_id, INTEGER);
			$db->query($sql);
		}

		if (strlen($properties_info)) {
			if (strpos($properties_info, ";") === false) {
				$control_type = "LABEL";
				$property_description = $properties_info;
			} else {
				$control_type = "LISTBOX";
				$property_description = "";
			}
			if (strlen($property_id)) {
				$sql  = " UPDATE " . $table_prefix . "items_properties SET ";
				$sql .= " property_description=" . $db->tosql($property_description, TEXT) . ", ";
				$sql .= " control_type=" . $db->tosql($control_type, TEXT);
				$sql .= " WHERE property_id=" . $db->tosql($property_id, INTEGER);
				$db->query($sql);
			} else {
				$property_order++;
				$max_property_id++;
				$property_id = $max_property_id;
				$item_type_id = 0;

				$sql  = " INSERT INTO " . $table_prefix . "items_properties ";
				$sql .= " (property_id, item_id, item_type_id, property_order, property_name, property_description, control_type, required, use_on_list, use_on_details, use_on_checkout) VALUES (";
				$sql .= $db->tosql($property_id, INTEGER) . ", ";
				$sql .= $db->tosql($item_id, INTEGER) . ", ";
				$sql .= $db->tosql($item_type_id, INTEGER) . ", ";
				$sql .= $db->tosql($property_order, INTEGER) . ", ";
				$sql .= $db->tosql($column_value, TEXT) . ", ";
				$sql .= $db->tosql($property_description, TEXT) . ", ";
				$sql .= $db->tosql($control_type, TEXT) . ", ";
				$sql .= "0, 1, 1, 0) ";
				$db->query($sql);
			}

			if ($control_type == "LISTBOX") {
				$property_values = explode(";", $properties_info);
				for ($pv = 0; $pv < sizeof($property_values); $pv++) {
					$property_value = trim($property_values[$pv]);
					$additional_price = "";
					if (preg_match("/^(.+)=\s*([\-\+]?[\d]*\.?[\d]*)$/", $property_value, $matches)) {
						$property_value = $matches[1];
						$additional_price = $matches[2];
					}
					if (strlen($property_value)) {
						$sql  = " INSERT INTO " . $table_prefix . "items_properties_values ";
						$sql .= " (property_id, property_value, additional_price, hide_out_of_stock, hide_value) VALUES (";
						$sql .= $db->tosql($property_id, INTEGER) . ", ";
						$sql .= $db->tosql($property_value, TEXT) . ", ";
						$sql .= $db->tosql($additional_price, NUMBER) . ", ";
						$sql .= "0, 0) ";
						$db->query($sql);
					}
				}
			}
		} else {
			$sql = " DELETE FROM " . $table_prefix . "items_properties WHERE property_id=" . $db->tosql($property_id, INTEGER);
			$db->query($sql);
		}
	}

	function update_items_features($item_id, $feature_value)
	{
		global $db, $db_type, $features_groups, $table_prefix, $column_value;

		$feature_value = trim($feature_value);
		if (preg_match("/^(.+)>(.+)$/isU", $column_value, $matches)) {
			$group_name = trim($matches[1]);
			$feature_name = trim($matches[2]);
			if (isset($features_groups[$group_name])) {
				$group_id = $features_groups[$group_name];
			} else {
				$sql  = " SELECT group_id FROM " . $table_prefix . "features_groups ";
				$sql .= " WHERE group_name=" . $db->tosql($group_name, TEXT);
				$db->query($sql);
				if ($db->next_record()) {
					$group_id = $db->f("group_id");
				} else {
					// feature group doesn't exists - add new
					$sql = " SELECT MAX(group_order) FROM " . $table_prefix . "features_groups ";
					$group_order = get_db_value($sql);
					$group_order++;

					if ($db_type == "postgre") {
						$group_id = get_db_value(" SELECT NEXTVAL('seq_" . $table_prefix . "features_groups') ");
					}

					$sql  = " INSERT INTO " . $table_prefix . "features_groups (";
					if ($db_type == "postgre") { $sql .= " group_id, "; }
					$sql .= " group_order, group_name) VALUES (";
					if ($db_type == "postgre") { $sql .= $db->tosql($group_id, INTEGER) . ", "; }
					$sql .= $db->tosql($group_order, INTEGER) . ", ";
					$sql .= $db->tosql($group_name, TEXT) . ") ";
					$db->query($sql);

					if ($db_type == "mysql") {
						$group_id = get_db_value(" SELECT LAST_INSERT_ID() ");
					} elseif ($db_type == "access") {
						$group_id = get_db_value(" SELECT @@IDENTITY ");
					} elseif ($db_type == "db2") {
						$group_id = get_db_value(" SELECT PREVVAL FOR seq_" . $table_prefix . "features_groups FROM " . $table_prefix . "features_groups");
					}
				}
				$features_groups[$group_name] = $group_id;
			}

			$feature_id = "";
			$sql  = " SELECT feature_id FROM " . $table_prefix . "features ";
			$sql .= " WHERE item_id=" . $db->tosql($item_id, INTEGER);
			$sql .= " AND group_id=" . $db->tosql($group_id, INTEGER);
			$sql .= " AND feature_name=" . $db->tosql($feature_name, TEXT);
			$db->query($sql);
			if ($db->next_record()) {
				$feature_id = $db->f("feature_id");
			}
			if (strlen($feature_value)) {
				if (strlen($feature_id)) {
					$sql  = " UPDATE " . $table_prefix . "features SET ";
					$sql .= " feature_value=" . $db->tosql($feature_value, TEXT);
					$sql .= " WHERE feature_id=" . $db->tosql($feature_id, INTEGER);
					$db->query($sql);
				} else {
					$sql  = " INSERT INTO " . $table_prefix . "features ";
					$sql .= " (item_id, group_id, feature_name, feature_value) VALUES (";
					$sql .= $db->tosql($item_id, INTEGER) . ", ";
					$sql .= $db->tosql($group_id, INTEGER) . ", ";
					$sql .= $db->tosql($feature_name, TEXT) . ", ";
					$sql .= $db->tosql($feature_value, TEXT) . ") ";
					$db->query($sql);
				}
			} else {
				$sql = " DELETE FROM " . $table_prefix . "features WHERE feature_id=" . $db->tosql($feature_id, INTEGER);
				$db->query($sql);
			}
		}
	}

	function update_manufacturer($item_id, $manufacturer_name)
	{
		global $db, $table_prefix;

		$manufacturer_id = "";
		if (strlen($manufacturer_name)) {
			$sql  = " SELECT manufacturer_id FROM " . $table_prefix . "manufacturers ";
			$sql .= " WHERE manufacturer_name=" . $db->tosql($manufacturer_name, TEXT);
			$db->query($sql);
			if ($db->next_record()) {
				$manufacturer_id = $db->f("manufacturer_id");
			} else {
				$sql  = " SELECT MAX(manufacturer_id) FROM " . $table_prefix . "manufacturers ";
				$manufacturer_id = get_db_value($sql) + 1;

				$sql  = " INSERT INTO " . $table_prefix . "manufacturers ";
				$sql .= " (manufacturer_id, manufacturer_name) VALUES (";
				$sql .= $db->tosql($manufacturer_id, INTEGER) . ", ";
				$sql .= $db->tosql($manufacturer_name, TEXT) . ") ";
				$db->query($sql);
			}
		}

		$sql  = " UPDATE " . $table_prefix . "items SET manufacturer_id=" . $db->tosql($manufacturer_id, INTEGER);
		$sql .= " WHERE item_id=" . $db->tosql($item_id, INTEGER);
		$db->query($sql);
	}

	function prepare_categories_list()
	{
		global $db, $table_prefix, $categories;

		//-- parent items
		$sql  = " SELECT category_id, parent_category_id FROM " . $table_prefix . "categories ";
		$db->query($sql);
		while ($db->next_record()) {
			$list_id = $db->f("category_id");
			$list_parent_id = $db->f("parent_category_id");
			$categories[$list_parent_id]["subs"][] = $list_id;
		}
	}

	function update_categories_tree($parent_category_id, $category_path)
	{
		global $db, $table_prefix, $categories;

		if (isset($categories[$parent_category_id]["subs"])) {
			$category_path .= $parent_category_id . ",";

			$subs = $categories[$parent_category_id]["subs"];
			for ($s = 0; $s < sizeof($subs); $s++) {
				$sub_id = $subs[$s];

				$sql  = " UPDATE " . $table_prefix . "categories SET ";
				$sql .= " category_path=" . $db->tosql($category_path, TEXT);
				$sql .= " WHERE category_id=" . $db->tosql($sub_id, INTEGER);
				$db->query($sql);

				if (isset($categories[$sub_id]["subs"])) {
					update_categories_tree($sub_id, $category_path);
				}
			}
		}	
	}

	function import_friendly_url()
	{
		global $r;
		if ($r->parameter_exists("friendly_url")) {
			$friendly_url = trim($r->get_value("friendly_url")); // trim friendly url value
			$r->set_value("friendly_url", $friendly_url); // set trimed value
			if (strlen($friendly_url)) {
				$is_unique = validate_friendly_url("", false); // check if existed value is unique
				if (!$is_unique) {
					$r->set_value("friendly_url", ""); // clear duplicated friendly value
				}
			}
			set_friendly_url(); // generate new friendly value from title
		}
	}

	function add_imported_fields()
	{
		global $r, $table, $datetime_edit_format;

		if ($table == "items") {
			// administrative information
			$r->add_textbox("is_keywords", INTEGER);
			$r->add_textbox("admin_id_added_by", INTEGER);
			$r->change_property("admin_id_added_by", USE_IN_UPDATE, false);
			$r->add_textbox("admin_id_modified_by", INTEGER);
			$r->add_textbox("date_added", DATETIME);
			$r->change_property("date_added", USE_IN_UPDATE, false);
			$r->change_property("date_added", VALUE_MASK, $datetime_edit_format);
			$r->add_textbox("date_modified", DATETIME);
			$r->change_property("date_modified", VALUE_MASK, $datetime_edit_format);
			// set values
			$r->set_value("is_keywords", 0);
			$r->set_value("admin_id_added_by", get_session("session_admin_id"));
			$r->set_value("admin_id_modified_by", get_session("session_admin_id"));
			$r->set_value("date_added", va_time());
			$r->set_value("date_modified", va_time());
		} elseif ($table == "orders") {
			$r->add_textbox("order_placed_date", DATETIME);
			$r->change_property("order_placed_date", USE_SQL_NULL, false);
			$r->change_property("order_placed_date", VALUE_MASK, $datetime_edit_format);
			$r->set_value("order_placed_date", va_time());
			$r->add_textbox("modified_date", DATETIME);
			$r->change_property("modified_date", USE_SQL_NULL, false);
			$r->change_property("modified_date", VALUE_MASK, $datetime_edit_format);
			$r->set_value("modified_date", va_time());
			$r->add_textbox("affiliate_code", TEXT);
			$r->change_property("affiliate_code", USE_SQL_NULL, false);
			$r->add_textbox("first_name", TEXT);
			$r->change_property("first_name", USE_SQL_NULL, false);
			$r->add_textbox("last_name", TEXT);
			$r->change_property("last_name", USE_SQL_NULL, false);
			$r->add_textbox("email", TEXT);
			$r->change_property("email", USE_SQL_NULL, false);
		}

		if ($table == "orders" || $table == "users") {
			$r->add_textbox("state_id", INTEGER);
			$r->change_property("state_id", USE_SQL_NULL, false);
			$r->add_textbox("country_id", INTEGER);
			$r->change_property("country_id", USE_SQL_NULL, false);
			$r->add_textbox("delivery_state_id", INTEGER);
			$r->change_property("delivery_state_id", USE_SQL_NULL, false);
			$r->add_textbox("delivery_country_id", INTEGER);
			$r->change_property("delivery_country_id", USE_SQL_NULL, false);	
		}
	}


function get_header_data($csv_data)
{
	$header_data = array();
	foreach ($csv_data as $id => $column_name) {
		$lowercase_column = trim(strtolower($column_name));
		$header_data[$lowercase_column] = array("id" => $id, "title" => $column_name);
	}
	return $header_data;
}

/*used in case xml feed returns multidimensional array*/
/**
 * @param $array xml data array
 * @param $key needle
 * @return searched value
 */
function get_value_by_key($array, $key)
{
	foreach($array as $k => $val){
		if($k == $key){
			return $val;
		}

		if(is_array($val)){
			if($needle = get_value_by_key($val, $key)){
				return $needle;
			}
		}

	}

	return "";

}



?>