<?php                           

	$default_title = SAVE_CART_TITLE;

	$html_template = get_setting_value($block, "html_template", "block_cart_save.html"); 
  $t->set_file("block_body", $html_template);

	$current_page = "cart_save.php";

	$shopping_cart = get_session("shopping_cart");
	$total_items = 0;
	if(is_array($shopping_cart)) {
		// check for active products in the cart
		foreach($shopping_cart as $cart_id => $item) {
			$item_id = $item["ITEM_ID"];
			$total_items++;
		}
	}
	if (!$total_items) {
		$rp = get_param("rp");
		$basket_page = strlen($rp) ? get_custom_friendly_url("basket.php") . "?rp=" . urlencode($rp) : get_custom_friendly_url("basket.php");
		header("Location: " . $basket_page);
		exit;
	}

	// get contact us settings
	$saved_cart_settings = get_settings("saved_cart");
	$user_id = get_session("session_user_id");
	$user_info = get_session("session_user_info");
	$user_email = get_setting_value($user_info, "email", "");
	$user_notify = get_setting_value($saved_cart_settings, "user_notify", 0);

	$t->set_var("basket_href",   get_custom_friendly_url("basket.php"));
	$t->set_var("current_href",  get_custom_friendly_url("basket.php"));
	$t->set_var("checkout_href", get_custom_friendly_url("checkout.php"));
	$t->set_var("products_href", get_custom_friendly_url("products_list.php"));
	$t->set_var("cart_save_href",get_custom_friendly_url("cart_save.php"));

	srand ((double) microtime() * 1000000);
	$new_random_value = rand();

	$discount_type = get_session("session_discount_type");
	$discount_amount = get_session("session_discount_amount");

	// set up return page
	$rp = get_param("rp");
	if(!$rp) { $rp = get_custom_friendly_url("products_list.php"); }
	$t->set_var("rp", htmlspecialchars($rp));

	$operation = get_param("operation");
	$rnd = get_param("rnd");
	$session_rnd = get_session("session_rnd");

	$r = new VA_Record($table_prefix . "saved_carts");
	$r->add_where("cart_id", INTEGER);
	$r->add_textbox("site_id", INTEGER);
	$r->add_textbox("user_id", INTEGER);
	$r->add_textbox("cart_name", TEXT, CART_NAME_FIELD);
	$r->change_property("cart_name", REQUIRED, true);
	$r->add_textbox("user_email", TEXT, EMAIL_FIELD);
	$r->change_property("user_email", USE_IN_INSERT, false);
	$r->change_property("user_email", REGEXP_MASK, EMAIL_REGEXP);
	if ($user_notify) {
		$t->parse("user_email_note", false);
	} else {
		$r->change_property("user_email", SHOW, false);
	}
	$r->add_textbox("cart_total", NUMBER);
	$r->add_textbox("cart_added", DATETIME);

	$si = new VA_Record($table_prefix . "saved_items");
	$si->add_where("cart_item_id", INTEGER);
	$si->add_textbox("site_id", INTEGER);
	$si->add_textbox("item_id", INTEGER);
	$si->add_textbox("cart_id", INTEGER);
	$si->add_textbox("user_id", INTEGER);
	$si->add_textbox("item_name", TEXT);
	$si->add_textbox("quantity", INTEGER);
	$si->add_textbox("price", NUMBER);
	$si->add_textbox("date_added", DATETIME);

	$sip = new VA_Record($table_prefix . "saved_items_properties");
	$sip->add_where("item_property_id", INTEGER);
	$sip->add_textbox("cart_item_id", INTEGER);
	$sip->add_textbox("cart_id", INTEGER);
	$sip->add_textbox("property_id", INTEGER);
	$sip->add_textbox("property_value", TEXT);
	$sip->add_textbox("property_values_ids", TEXT);

	$rnd = get_param("rnd");
	$session_rnd = get_session("session_rnd");
	$session_cart_id = get_session("session_cart_id");
	$success_message = "";
	$cart_id = "";
	if(strlen($operation) && $rnd != $session_rnd) 
	{
		if ($operation == "cancel") {
			header("Location: " . get_custom_friendly_url("basket.php") . "?rp=" . urlencode($rp));
			exit;
		} 
		$r->get_form_values();

		$is_valid = $r->validate();

		if ($is_valid) {
			set_session("session_rnd", $rnd);
			// prepare total products quantities
			if (!isset($site_id) || !$site_id) {
				$site_id = 1;
			}
			$cart_items = array(); $cart_total = 0;
			if(is_array($shopping_cart))
			{
				foreach ($shopping_cart as $cart_id => $item) {

					$item_id = $item["ITEM_ID"];
					if (!$item_id) { continue; }
			  
					$item_type_id = $item["ITEM_TYPE_ID"];
					$item_name = $item["ITEM_NAME"];
					$properties = $item["PROPERTIES"];
					$quantity = $item["QUANTITY"];
					$tax_free = isset($item["TAX_FREE"]) ? $item["TAX_FREE"] : 0;
					$discount_applicable = isset($item["DISCOUNT"]) ? $item["DISCOUNT"] : 0;
					$buying_price = isset($item["BUYING_PRICE"]) ? $item["BUYING_PRICE"] : 0;
					$price = $item["PRICE"];
					$is_price_edit = isset($item["PRICE_EDIT"]) ? $item["PRICE_EDIT"] : 0;
					$properties_price = $item["PROPERTIES_PRICE"];
					$properties_percentage = $item["PROPERTIES_PERCENTAGE"];
					$properties_buying = $item["PROPERTIES_BUYING"];
					$properties_discount = $item["PROPERTIES_DISCOUNT"];
					$components = $item["COMPONENTS"];
					if ($discount_applicable) {
						if (!$is_price_edit) {
							if ($discount_type == 1) {
								$price -= round(($price * $discount_amount) / 100, 2);
							} else if ($discount_type == 2) {
								$price -= round($discount_amount, 2);
							} else if ($discount_type == 3) {
								$price -= round(($price * $discount_amount) / 100, 2);
							} else if ($discount_type == 4) {
								$price -= round((($price - $buying_price) * $discount_amount) / 100, 2);
							}
						}
					} 
					if ($properties_percentage && $price) {
						$properties_price += round(($price * $properties_percentage) / 100, 2);
					}
					if ($properties_discount > 0) {
						$properties_price -= round(($properties_price * $properties_discount) / 100, 2);
					}
					if ($discount_applicable) {
						if ($discount_type == 1) {
							$properties_price -= round((($properties_price) * $discount_amount) / 100, 2);
						} else if ($discount_type == 4) {
							$properties_price -= round((($properties_price - $properties_buying) * $discount_amount) / 100, 2);
						}
					}
		    
					$price += $properties_price;
			  
					// add components prices
					if (is_array($components) && sizeof($components) > 0) {
						foreach ($components as $property_id => $component_values) {
							foreach ($component_values as $property_item_id => $component) {
								$component_price = $component["price"];
								$sub_item_id = $component["sub_item_id"];
								$sub_type_id = $component["item_type_id"];
								if (!strlen($component_price)) {
									$sub_price = $component["base_price"];
									$sub_buying = $component["buying"];
									$sub_user_price = $component["user_price"];
									$sub_user_action = $component["user_price_action"];
									$sub_prices = get_product_price($sub_item_id, $sub_price, $sub_buying, 0, 0, $sub_user_price, $sub_user_action, $discount_type, $discount_amount);
									$component_price = $sub_prices["base"];
								}
		    
								$price += $component_price;
							}
						}
					}
					$cart_total += ($price * $quantity);

					$cart_items[] = array($item_id, $item_name, $quantity, $price, $properties);
				}
			}

			if ($db_type == "postgre") {
				$cart_id = get_db_value(" SELECT NEXTVAL('seq_" . $table_prefix . "saved_carts') ");
				$r->change_property("cart_id", USE_IN_INSERT, true);
				$r->set_value("cart_id", $cart_id);
			}
			$r->set_value("site_id", $site_id);
			$r->set_value("user_id", intval(get_session("session_user_id")));
			$r->set_value("cart_added", va_time());
			$r->set_value("cart_total", $cart_total);
			if ($r->insert_record()) {
				if ($db_type == "mysql") {
					$cart_id = get_db_value(" SELECT LAST_INSERT_ID() ");
				} else if ($db_type == "access") {
					$cart_id = get_db_value(" SELECT @@IDENTITY ");
				} else if ($db_type == "db2") {
					$cart_id = get_db_value(" SELECT PREVVAL FOR seq_" . $table_prefix . "saved_carts FROM " . $table_prefix . "saved_carts");
				}
				$r->set_value("cart_id", $cart_id);

				set_session("session_cart_id", $cart_id);

				// save cart items
				$si->set_value("site_id", $site_id);
				$si->set_value("cart_id", $cart_id);
				$si->set_value("cart_id", $cart_id);
				$si->set_value("date_added", va_time());
				$si->set_value("user_id", intval(get_session("session_user_id")));

				for ($ci = 0; $ci < sizeof($cart_items); $ci++) {
					list ($item_id, $item_name, $quantity, $price, $properties) = $cart_items[$ci];
					if ($db_type == "postgre") {
						$cart_item_id = get_db_value(" SELECT NEXTVAL('seq_" . $table_prefix . "saved_items') ");
						$si->change_property("cart_item_id", USE_IN_INSERT, true);
						$si->set_value("cart_item_id", $cart_item_id);
					}
					$si->set_value("item_id", $item_id);
					$si->set_value("item_name", $item_name);
					$si->set_value("quantity", $quantity);
					$si->set_value("price", $price);
					if ($si->insert_record()) {
						// save properties
						if ($db_type == "mysql") {
							$cart_item_id = get_db_value(" SELECT LAST_INSERT_ID() ");
						} else if ($db_type == "access") {
							$cart_item_id = get_db_value(" SELECT @@IDENTITY ");
						} else if ($db_type == "db2") {
							$cart_item_id = get_db_value(" SELECT PREVVAL FOR seq_" . $table_prefix . "saved_items FROM " . $table_prefix . "saved_items");
						}

						if (is_array($properties)) {
							$sip->set_value("cart_item_id", $cart_item_id);
							$sip->set_value("cart_id", $cart_id);
							foreach($properties as $property_id => $property_values) {
								$sip->set_value("property_id", $property_id);
								$sql  = " SELECT control_type ";
								$sql .= " FROM " . $table_prefix . "items_properties ";
								$sql .= " WHERE property_id=" . $db->tosql($property_id, INTEGER);
								$db->query($sql);
								if ($db->next_record()) {
									$control_type = $db->f("control_type");
									if (strtoupper($control_type) == "RADIOBUTTON" 
										|| strtoupper($control_type) == "CHECKBOXLIST" 
										|| strtoupper($control_type) == "LISTBOX") {
										$sip->set_value("property_value", "");
										$sip->set_value("property_values_ids", implode(",", $property_values));
									} else {
										$sip->set_value("property_value", $property_values[0]);
										$sip->set_value("property_values_ids", "");
									}
									$sip->insert_record();

								}
							}
						}
						// end save properties
					}
				}
				// end save cart items

				// send notfication 
				$ip = get_ip();
				$eol = get_eol();
				$user_info = get_session("session_user_info");
				$admin_notify = get_setting_value($saved_cart_settings, "admin_notify", 0);
				$user_email = $r->get_value("user_email");
				$user_notify = get_setting_value($saved_cart_settings, "user_notify", 0);
				if ($admin_notify || ($user_notify && $user_email)) {
					// set variables for email notifications
					$t->set_vars($user_info);
      
					$date_added_formatted = va_date($datetime_show_format, va_time());
					$t->set_var("date_added", $date_added_formatted);
      
					$t->set_var("ip", $ip);
					$t->set_var("remote_address", $ip);
					$t->set_var("cart_id", $r->get_value("cart_id"));
					$t->set_var("cart_name", $r->get_value("cart_name"));
					$t->set_var("user_email", $r->get_value("user_email"));
					$t->set_var("email", $r->get_value("user_email"));

				}
      
				// send email notification to admin
				if ($admin_notify)
				{
					$t->set_block("admin_subject", $saved_cart_settings["admin_subject"]);
					$t->set_block("admin_message", $saved_cart_settings["admin_message"]);
      
					$mail_to = get_setting_value($saved_cart_settings, "admin_email", $settings["admin_email"]);
					$mail_to = str_replace(";", ",", $mail_to);
					$mail_from = get_setting_value($saved_cart_settings, "admin_mail_from", $settings["admin_email"]);
					$email_headers = array();
					$email_headers["from"] = parse_value($mail_from);
					$email_headers["cc"] = get_setting_value($saved_cart_settings, "admin_mail_cc");
					$email_headers["bcc"] = get_setting_value($saved_cart_settings, "admin_mail_bcc");
					$email_headers["reply_to"] = get_setting_value($saved_cart_settings, "admin_mail_reply_to");
					$email_headers["return_path"] = get_setting_value($saved_cart_settings, "admin_mail_return_path");
					$email_headers["mail_type"] = get_setting_value($saved_cart_settings, "admin_message_type");
      
					$t->parse("admin_subject", false);
					$t->parse("admin_message", false);
					$admin_message = preg_replace("/\r\n|\r|\n/", $eol, $t->get_var("admin_message"));
					va_mail($mail_to, $t->get_var("admin_subject"), $admin_message, $email_headers);
				}
      
				// send email notification to user
				if ($user_notify && $user_email)
				{
					$t->set_block("user_subject", $saved_cart_settings["user_subject"]);
					$t->set_block("user_message", $saved_cart_settings["user_message"]);
      
					$mail_from = get_setting_value($saved_cart_settings, "user_mail_from", $settings["admin_email"]); 
					$email_headers = array();
					$email_headers["from"] = parse_value($mail_from);
					$email_headers["cc"] = get_setting_value($saved_cart_settings, "user_mail_cc");
					$email_headers["bcc"] = get_setting_value($saved_cart_settings, "user_mail_bcc");
					$email_headers["reply_to"] = get_setting_value($saved_cart_settings, "user_mail_reply_to");
					$email_headers["return_path"] = get_setting_value($saved_cart_settings, "user_mail_return_path");
					$email_headers["mail_type"] = get_setting_value($saved_cart_settings, "user_message_type");
      
					$t->parse("user_subject", false);
					$t->parse("user_message", false);
      
					$user_message = preg_replace("/\r\n|\r|\n/", $eol, $t->get_var("user_message"));
					va_mail($user_email, $t->get_var("user_subject"), $user_message, $email_headers);
				}


			}
		}
	} else if ($session_cart_id) {
		$cart_id = $session_cart_id;
	} else {
		$r->set_value("user_email", $user_email);
	}

	$r->set_parameters();

	if ($cart_id) {
		$success_message = str_replace("{cart_id}", $cart_id, CART_SAVED_MSG);
		$r->set_value("cart_name", "");
		$t->set_var("success_message", $success_message);
		$t->parse("success_block", false);
	}

	$t->set_var("rp", htmlspecialchars($rp));
	$t->set_var("random_value", htmlspecialchars($new_random_value));

	$block_parsed = true;

?>