<?php

	$friendly_urls = get_setting_value($settings, "friendly_urls", 0);
	$friendly_extension = get_setting_value($settings, "friendly_extension", "");

	if (isset($sub_block) && $sub_block) {
		$t->set_file($sub_block, "block_site_navigation.html");
	} else {
		$t->set_file("block_body", "block_site_navigation.html");
	}
	$t->set_var("menu", "");
	$t->set_var("menu_block", "");

	set_script_tag("js/init.js");

	$menu_blocks = array();
	if (compare_versions(va_version(), "4.4.2") >= 0) {
		$sql  = " SELECT m.menu_id, m.block_class, m.menu_class FROM (" . $table_prefix . "menus m";
		$sql .= " LEFT JOIN " . $table_prefix . "menus_sites ms ON m.menu_id=ms.menu_id) ";
		$sql .= " WHERE m.menu_type=2 "; // get only header menu
		$sql .= " AND (m.sites_all=1 OR ms.site_id=" . $db->tosql($site_id, INTEGER) . ")";
		$db->query($sql);
		while ($db->next_record()) {
			$menu_id = $db->f("menu_id");
			$block_class = $db->f("block_class");
			if (!$block_class) { $block_class = "menu"; }
			$menu_class = $db->f("menu_class");
			$menu_blocks[$menu_id] = array(
				"block_class" => $block_class,
				"menu_class" => $menu_class,
			);
		}
	}

	$menu_index = 0;
	foreach ($menu_blocks as $menu_id => $menu_data) {
		$menu_index++;
		$menu_class = $menu_data["menu_class"];
		$block_class = $menu_data["block_class"];

		// init menus array
		$menus = array(); 
		$top_menu_type = get_setting_value($settings, "top_menu_type", 1);
		$sql  = " SELECT * FROM " . $table_prefix . "menus_items ";
		$sql .= " WHERE menu_id=" . $db->tosql($menu_id, INTEGER);
		if (get_session("session_user_id")) {
			$sql .= " AND user_access=1 ";
		} else {
			$sql .= " AND guest_access=1 ";
		}
		if (get_session("session_admin_id")) {
			$sql .= " AND admin_access IS NOT NULL ";
		}
		$sql .= " ORDER BY menu_order ";
		$db->query($sql);
		while ($db->next_record())
		{
			$menu_id = $db->f("menu_item_id");
			$parent_menu_id = $db->f("parent_menu_item_id");
			$menu_order = $db->f("menu_order");
			$menu_url = $db->f("menu_url");
			$menu_class = $db->f("menu_class");
			$menu_page = $db->f("menu_page");
			$menu_title = get_translation($db->f("menu_title"));
			$menu_image = $db->f("menu_image");
			$menu_image_active = $db->f("menu_image_active");
			$match_type = 2; 
  
			if ($menu_id == $parent_menu_id) {
				$parent_menu_id = 0;
			}
 
			if (strlen($menu_title) || $menu_image || $menu_image_active) {
				$menus[$menu_id]["parent"] = $parent_menu_id;
				$menus[$menu_id]["menu_url"] = $menu_url;
				$menus[$menu_id]["menu_title"] = $menu_title;
				$menus[$menu_id]["menu_target"] = $db->f("menu_target");
				$menus[$menu_id]["menu_image"] = $menu_image;
				$menus[$menu_id]["menu_image_active"] = $menu_image_active;
				$menus[$menu_id]["menu_class"] = $menu_class;
				$menus[$menu_id]["match_type"] = 2;
				$menus[$parent_menu_id]["subs"][$menu_id] = $menu_order;
			}
		}
  
		// check categories menu only for first menu
		if ($menu_index == 1) {
			$sql  = " SELECT * FROM " . $table_prefix . "categories ";
			$sql .= " WHERE header_menu_show=1 ";
			$db->query($sql);
			while ($db->next_record()) {
				$category_id = $db->f("category_id");
				$menu_id = "c".$category_id;
				$parent_category_id = $db->f("parent_category_id");
				$parent_menu_id = ($parent_category_id) ? "c".$parent_category_id : 0; 
				$menu_order = $db->f("header_menu_order");
				if (!$menu_order) {
					$menu_order = $db->f("category_order");
				}
				$friendly_url = $db->f("friendly_url");
				if ($friendly_urls && $friendly_url) {
					$menu_url = $friendly_url.$friendly_extension;
				} else {
					$menu_url = "products_list.php?category_id=".urlencode($category_id);
				}
				$menu_class = $db->f("header_menu_class");
				$category_name = get_translation($db->f("category_name"));
				$menu_title = $category_name;
				$image_small = $db->f("image");
				$image_large = $db->f("image_large");
				$menu_image = "";
				$menu_image_active = "";
				$match_type = 2;
    
				if ($menu_id == $parent_menu_id) {
					$parent_menu_id = 0;
				}
    
				if (strlen($menu_title) || $menu_image || $menu_image_active) {
					$menus[$menu_id]["parent"] = $parent_menu_id;
					$menus[$menu_id]["menu_url"] = $menu_url;
					$menus[$menu_id]["menu_title"] = $menu_title;
					$menus[$menu_id]["menu_target"] = $db->f("menu_target");
					$menus[$menu_id]["menu_image"] = $menu_image;
					$menus[$menu_id]["menu_image_active"] = $menu_image_active;
					$menus[$menu_id]["menu_class"] = $menu_class;
					$menus[$menu_id]["match_type"] = 2;
					$menus[$parent_menu_id]["subs"][$menu_id] = $menu_order;
				}
			}
		}
  
		set_menus($menus, 0, 0);

		$menu_class = $menu_data["menu_class"];
		$block_class = $menu_data["block_class"];
		$t->set_var("block_menu_class", htmlspecialchars($block_class));
		$t->set_var("top_menu_class", htmlspecialchars($menu_class));
		$t->parse("menu_block");
	}


	$t->set_var("index_href", get_custom_friendly_url("index.php"));
	$t->set_var("products_href", get_custom_friendly_url("products_list.php"));
	$t->set_var("basket_href", get_custom_friendly_url("basket.php"));
	$t->set_var("user_profile_href", get_custom_friendly_url("user_profile.php"));
	$t->set_var("admin_href", "admin.php");
	$t->set_var("help_href", get_custom_friendly_url("page.php") . "?page=help");
	$t->set_var("about_href", get_custom_friendly_url("page.php") . "?page=about");

	$block_parsed = true;

?>