
DROP TABLE IF EXISTS va_admin_privileges;
CREATE TABLE va_admin_privileges (
  `privilege_id` INT(11) NOT NULL AUTO_INCREMENT,
  `is_hidden` TINYINT default '0',
  `support_privilege` TINYINT default '0',
  `privilege_name` VARCHAR(64) NOT NULL,
  `user_types_all` TINYINT default '1',
  `non_logged_users` TINYINT default '1',
  `user_types_ids` TEXT
  ,PRIMARY KEY (privilege_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_admin_privileges_settings;
CREATE TABLE va_admin_privileges_settings (
  `privilege_id` INT(11) NOT NULL default '0',
  `block_name` VARCHAR(64) NOT NULL,
  `permission` TINYINT
  ,PRIMARY KEY (privilege_id,block_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_admins;
CREATE TABLE va_admins (
  `admin_id` INT(11) NOT NULL AUTO_INCREMENT,
  `admin_name` VARCHAR(255) NOT NULL,
  `nickname` VARCHAR(32),
  `admin_alias` VARCHAR(16),
  `privilege_id` INT(11) NOT NULL default '0',
  `is_hidden` TINYINT default '0',
  `email` VARCHAR(255) NOT NULL,
  `cell_phone` VARCHAR(32),
  `login` VARCHAR(64) NOT NULL,
  `password` VARCHAR(32) NOT NULL,
  `personal_image` VARCHAR(255),
  `signature` TEXT,
  `last_order_id` INT(11) default '0',
  `exported_order_id` INT(11) default '0',
  `exported_order_fields` TEXT,
  `last_user_id` INT(11) default '0',
  `exported_email_id` VARCHAR(50),
  `exported_user_id` INT(11) default '0',
  `exported_email_fields` VARCHAR(50),
  `exported_user_fields` TEXT,
  `imported_email_fields` VARCHAR(50),
  `imported_user_fields` TEXT,
  `exported_item_fields` TEXT,
  `imported_item_fields` TEXT,
  `edited_item_fields` TEXT,
  `last_visit_date` DATETIME,
  `support_online_date` DATETIME,
  `is_generate_big_image` TINYINT default '0',
  `is_generate_small_image` TINYINT default '0',
  `login_attempts` INT(11) default '0',
  `login_failed` DATETIME,
  `access_code` VARCHAR(16),
  `access_added` DATETIME,
  `access_attempts` INT(11) default '0',
  `access_failed` DATETIME
  ,KEY login (login)
  ,KEY password (password)
  ,PRIMARY KEY (admin_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_admins_login_stats;
CREATE TABLE va_admins_login_stats (
  `stat_id` INT(11) NOT NULL AUTO_INCREMENT,
  `admin_id` INT(11) default '0',
  `login_status` TINYINT default '0',
  `ip_address` VARCHAR(32),
  `forwarded_ips` VARCHAR(255),
  `date_added` DATETIME
  ,KEY admin_id (admin_id)
  ,PRIMARY KEY (stat_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_admins_settings;
CREATE TABLE va_admins_settings (
  `admin_id` INT(11) NOT NULL default '0',
  `setting_name` VARCHAR(64) NOT NULL,
  `setting_value` TEXT
  ,PRIMARY KEY (admin_id,setting_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_assigned;
CREATE TABLE va_ads_assigned (
  `item_id` INT(11) NOT NULL default '0',
  `category_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (item_id,category_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_categories;
CREATE TABLE va_ads_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `language_code` VARCHAR(2),
  `parent_category_id` INT(11) default '0',
  `alias_category_id` INT(11) default '0',
  `category_path` VARCHAR(255) NOT NULL,
  `category_name` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `sites_all` TINYINT default '1',
  `publish_price` DOUBLE(16,2) default '0',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7',
  `category_order` INT(11) default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `image_small` VARCHAR(255),
  `image_large` VARCHAR(255),
  `total_views` INT(11) default '0',
  `total_ads` INT(11) default '0',
  `total_subcategories` INT(11) default '0'
  ,KEY admin_access_level (admin_access_level)
  ,KEY category_path (category_path)
  ,KEY friendly_url (friendly_url)
  ,KEY guest_access_level (guest_access_level)
  ,KEY parent_category_id (parent_category_id)
  ,PRIMARY KEY (category_id)
  ,KEY sites_all (sites_all)
  ,KEY subscription_access_level (access_level)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_categories_sites;
CREATE TABLE va_ads_categories_sites (
  `category_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (category_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_categories_subscriptions;
CREATE TABLE va_ads_categories_subscriptions (
  `category_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_categories_types;
CREATE TABLE va_ads_categories_types (
  `category_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_days;
CREATE TABLE va_ads_days (
  `days_id` INT(11) NOT NULL AUTO_INCREMENT,
  `days_number` INT(11),
  `days_title` VARCHAR(64),
  `publish_price` DOUBLE(16,2)
  ,PRIMARY KEY (days_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_features;
CREATE TABLE va_ads_features (
  `feature_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) default '0',
  `group_id` INT(11) default '0',
  `feature_name` VARCHAR(255),
  `feature_value` VARCHAR(255)
  ,KEY group_id (group_id)
  ,KEY item_id (item_id)
  ,PRIMARY KEY (feature_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_features_default;
CREATE TABLE va_ads_features_default (
  `feature_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_id` INT(11) default '0',
  `group_id` INT(11) default '0',
  `feature_name` VARCHAR(50),
  `feature_value` TEXT
  ,KEY group_id (group_id)
  ,KEY item_type_id (type_id)
  ,PRIMARY KEY (feature_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_features_groups;
CREATE TABLE va_ads_features_groups (
  `group_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_order` INT(11) NOT NULL default '1',
  `group_name` VARCHAR(255)
  ,PRIMARY KEY (group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_hot_days;
CREATE TABLE va_ads_hot_days (
  `days_id` INT(11) NOT NULL AUTO_INCREMENT,
  `days_number` INT(11),
  `days_title` VARCHAR(64),
  `publish_price` DOUBLE(16,2)
  ,PRIMARY KEY (days_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_images;
CREATE TABLE va_ads_images (
  `image_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) NOT NULL default '0',
  `image_small` VARCHAR(255),
  `small_width` INT(11),
  `small_height` INT(11),
  `image_large` VARCHAR(255),
  `image_title` VARCHAR(255),
  `image_description` TEXT
  ,KEY item_id (item_id)
  ,PRIMARY KEY (image_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_items;
CREATE TABLE va_ads_items (
  `item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_id` INT(11) NOT NULL default '0',
  `is_shown` TINYINT default '1',
  `is_shown_internal` TINYINT default '1',
  `is_paid` TINYINT default '0',
  `publish_price` DOUBLE(16,2) default '0',
  `language_code` VARCHAR(2),
  `item_title` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `item_order` INT(11) default '0',
  `user_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `days_run` INT(11),
  `date_start` DATETIME,
  `date_end` DATETIME,
  `date_added` DATETIME,
  `date_updated` DATETIME,
  `image_small` VARCHAR(255),
  `image_large` VARCHAR(255),
  `is_special` TINYINT default '0',
  `special_description` TEXT,
  `special_days_run` INT(11),
  `special_date_start` DATETIME,
  `special_date_end` DATETIME,
  `is_hot` TINYINT default '0',
  `hot_description` TEXT,
  `hot_days_run` INT(11),
  `hot_date_start` DATETIME,
  `hot_date_end` DATETIME,
  `short_description` TEXT,
  `full_description` TEXT,
  `price` DOUBLE(16,2) default '0',
  `currency_code` VARCHAR(4),
  `quantity` INT(11) default '0',
  `availability` VARCHAR(255),
  `location_info` TEXT,
  `location_city` VARCHAR(128),
  `location_postcode` VARCHAR(16),
  `location_state_id` INT(11) default '0',
  `location_state` VARCHAR(8),
  `location_country_id` INT(11) default '0',
  `location_country` VARCHAR(4),
  `is_approved` TINYINT default '0',
  `is_compared` TINYINT default '0',
  `total_views` INT(11) default '0'
  ,KEY currency_id (currency_code)
  ,KEY friendly_url (friendly_url)
  ,KEY hot_date_end (hot_date_end)
  ,KEY hot_date_start (hot_date_start)
  ,KEY is_hot (is_hot)
  ,KEY is_paid (is_paid)
  ,KEY is_shown (is_shown)
  ,KEY item_title (item_title)
  ,KEY location_country_id (location_country_id)
  ,KEY location_postcode (location_postcode)
  ,KEY location_state_id (location_state_id)
  ,PRIMARY KEY (item_id)
  ,KEY special_date_end (special_date_end)
  ,KEY special_date_start (special_date_start)
  ,KEY type_id (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_properties;
CREATE TABLE va_ads_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) NOT NULL default '0',
  `property_name` VARCHAR(255) NOT NULL,
  `property_value` TEXT
  ,KEY item_id (item_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_properties_default;
CREATE TABLE va_ads_properties_default (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_id` INT(11) NOT NULL default '0',
  `property_name` VARCHAR(255) NOT NULL,
  `property_value` TEXT
  ,KEY item_id (type_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_special_days;
CREATE TABLE va_ads_special_days (
  `days_id` INT(11) NOT NULL AUTO_INCREMENT,
  `days_number` INT(11),
  `days_title` VARCHAR(64),
  `publish_price` DOUBLE(16,2)
  ,PRIMARY KEY (days_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ads_types;
CREATE TABLE va_ads_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(50)
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_albums;
CREATE TABLE va_albums (
  `album_id` INT(11) NOT NULL AUTO_INCREMENT,
  `album_name` VARCHAR(255),
  `name_first` VARCHAR(2),
  `album_type` VARCHAR(32),
  `album_date` DATETIME,
  `friendly_url` VARCHAR(255),
  `image_tiny` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_super` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT
  ,KEY name_first (name_first)
  ,PRIMARY KEY (album_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_albums_authors;
CREATE TABLE va_albums_authors (
  `album_id` INT(11) NOT NULL default '0',
  `author_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (album_id,author_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_allowed_cell_phones;
CREATE TABLE va_allowed_cell_phones (
  `cell_phone_id` INT(11) NOT NULL AUTO_INCREMENT,
  `cell_phone_number` VARCHAR(32)
  ,KEY cell_phone_number (cell_phone_number)
  ,PRIMARY KEY (cell_phone_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles;
CREATE TABLE va_articles (
  `article_id` INT(11) NOT NULL AUTO_INCREMENT,
  `language_code` VARCHAR(2),
  `article_date` DATETIME,
  `date_end` DATETIME,
  `article_title` VARCHAR(255),
  `title_first` VARCHAR(2),
  `article_comment` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `article_template` VARCHAR(255),
  `article_order` INT(11) default '0',
  `author_name` VARCHAR(255),
  `author_email` VARCHAR(255),
  `author_url` VARCHAR(255),
  `author_remote_address` VARCHAR(255),
  `created_user_id` INT(11) default '0',
  `created_admin_id` INT(11) default '0',
  `updated_user_id` INT(11) default '0',
  `updated_admin_id` INT(11) default '0',
  `status_id` INT(11) NOT NULL default '0',
  `is_html` TINYINT default '0',
  `allowed_rate` TINYINT default '0',
  `is_hot` TINYINT default '0',
  `hot_order` INT(11) default '1',
  `hot_description` TEXT,
  `link_title` VARCHAR(255),
  `link_url` VARCHAR(255),
  `download_url` VARCHAR(255),
  `is_link_direct` VARCHAR(255),
  `is_remote_rss` TINYINT default '0',
  `details_remote_url` VARCHAR(255),
  `date_added` VARCHAR(255),
  `date_updated` VARCHAR(255),
  `keywords` TEXT,
  `highlights` TEXT,
  `short_description` TEXT,
  `full_description` TEXT,
  `notes` TEXT,
  `total_views` INT(11) default '0',
  `total_votes` INT(11) default '0',
  `total_points` INT(11) default '0',
  `rating` DOUBLE(16,2) default '0',
  `total_clicks` INT(11) default '0',
  `image_tiny` VARCHAR(255),
  `image_tiny_alt` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `image_super` VARCHAR(255),
  `image_super_alt` VARCHAR(255),
  `stream_video` VARCHAR(255),
  `stream_video_width` INT(11),
  `stream_video_height` INT(11),
  `stream_video_preview` VARCHAR(255),
  `youtube_video` VARCHAR(255),
  `youtube_video_width` INT(11),
  `youtube_video_height` INT(11),
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `is_draft` TINYINT default '0',
  `draft_parent_id` INT(11) default '0'
  ,KEY draft_parent_id (draft_parent_id)
  ,KEY friendly_url (friendly_url)
  ,KEY is_draft (is_draft)
  ,PRIMARY KEY (article_id)
  ,KEY status_id (status_id)
  ,KEY title_first (title_first)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_albums;
CREATE TABLE va_articles_albums (
  `article_id` INT(11) NOT NULL default '0',
  `album_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (article_id,album_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_assigned;
CREATE TABLE va_articles_assigned (
  `article_id` INT(11) NOT NULL default '0',
  `category_id` INT(11) NOT NULL default '0',
  `article_order` INT(11) default '0'
  ,PRIMARY KEY (article_id,category_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_authors;
CREATE TABLE va_articles_authors (
  `article_id` INT(11) NOT NULL default '0',
  `author_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (article_id,author_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_categories;
CREATE TABLE va_articles_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `language_code` VARCHAR(2),
  `parent_category_id` INT(11) default '0',
  `alias_category_id` INT(11) default '0',
  `category_path` VARCHAR(255) NOT NULL,
  `category_name` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `category_order` INT(11) default '0',
  `articles_list_template` VARCHAR(255),
  `articles_details_template` VARCHAR(255),
  `articles_order_column` VARCHAR(50),
  `articles_order_direction` VARCHAR(50),
  `article_edit_fields` TEXT,
  `article_list_fields` TEXT,
  `article_details_fields` TEXT,
  `article_required_fields` TEXT,
  `article_settings` TEXT,
  `moderators_ids` VARCHAR(255),
  `is_hot` TINYINT default '0',
  `sites_all` TINYINT default '1',
  `user_types_all` TINYINT default '1',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7',
  `allowed_rate` TINYINT default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `is_rss` TINYINT default '0',
  `rss_limit` INT(11),
  `rss_on_breadcrumb` INT(11) default '0',
  `rss_on_list` INT(11) default '0',
  `is_remote_rss` TINYINT default '0',
  `remote_rss_url` VARCHAR(255),
  `remote_rss_date_updated` DATETIME,
  `remote_rss_ttl` INT(11),
  `remote_rss_refresh_rate` INT(11),
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `total_views` INT(11) default '0',
  `total_articles` INT(11) default '0',
  `total_subcategories` INT(11) default '0'
  ,KEY admin_access_level (admin_access_level)
  ,KEY category_path (category_path)
  ,KEY friendly_url (friendly_url)
  ,KEY guest_access_level (guest_access_level)
  ,KEY parent_category_id (parent_category_id)
  ,PRIMARY KEY (category_id)
  ,KEY sites_all (sites_all)
  ,KEY subscription_access_level (access_level)
  ,KEY user_types_all (user_types_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_categories_items;
CREATE TABLE va_articles_categories_items (
  `category_id` INT(11) default '0',
  `item_id` INT(11) default '0',
  `related_order` INT(11) NOT NULL default '1'
  ,KEY category_id (category_id)
  ,KEY item_id (item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_categories_sites;
CREATE TABLE va_articles_categories_sites (
  `category_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (category_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_categories_subscriptions;
CREATE TABLE va_articles_categories_subscriptions (
  `category_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_categories_types;
CREATE TABLE va_articles_categories_types (
  `category_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_forum_topics;
CREATE TABLE va_articles_forum_topics (
  `article_id` INT(11) NOT NULL default '0',
  `thread_id` INT(11) NOT NULL default '0',
  `article_order` INT(11) default '1',
  `thread_order` INT(11) default '1'
  ,PRIMARY KEY (article_id,thread_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_images;
CREATE TABLE va_articles_images (
  `image_id` INT(11) NOT NULL AUTO_INCREMENT,
  `article_id` INT(11) default '0',
  `category_id` INT(11) default '0',
  `is_default` TINYINT default '0',
  `image_order` INT(11) default '0',
  `image_position` TINYINT default '1',
  `image_title` VARCHAR(255),
  `image_tiny` VARCHAR(255),
  `image_tiny_alt` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `image_super` VARCHAR(255),
  `image_super_alt` VARCHAR(255),
  `image_description` TEXT,
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY article_id (article_id)
  ,KEY category_id (category_id)
  ,PRIMARY KEY (image_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_items_related;
CREATE TABLE va_articles_items_related (
  `article_id` INT(11) default '0',
  `item_id` INT(11) default '0',
  `item_order` INT(11) NOT NULL default '1',
  `article_order` INT(11) default '1'
  ,KEY artilcle_id (article_id)
  ,KEY item_id (item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_links;
CREATE TABLE va_articles_links (
  `link_id` INT(11) NOT NULL AUTO_INCREMENT,
  `article_id` INT(11) default '0',
  `category_id` INT(11) default '0',
  `link_title` VARCHAR(255),
  `link_url` VARCHAR(255),
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY article_id (article_id)
  ,KEY category_id (category_id)
  ,PRIMARY KEY (link_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_related;
CREATE TABLE va_articles_related (
  `article_id` INT(11) NOT NULL default '0',
  `related_id` INT(11) NOT NULL default '0',
  `related_order` INT(11) NOT NULL default '1'
  ,PRIMARY KEY (article_id,related_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_reviews;
CREATE TABLE va_articles_reviews (
  `review_id` INT(11) NOT NULL AUTO_INCREMENT,
  `article_id` INT(11) NOT NULL default '0',
  `user_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `recommended` TINYINT default '0',
  `approved` TINYINT default '0',
  `rating` INT(11) default '0',
  `summary` TEXT,
  `user_name` VARCHAR(64),
  `user_email` VARCHAR(128),
  `remote_address` VARCHAR(255),
  `comments` TEXT,
  `admin_id_approved_by` INT(11),
  `admin_id_modified_by` INT(11),
  `date_added` DATETIME NOT NULL,
  `date_modified` DATETIME,
  `date_approved` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY article_id (article_id)
  ,PRIMARY KEY (review_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_statuses;
CREATE TABLE va_articles_statuses (
  `status_id` INT(11) NOT NULL AUTO_INCREMENT,
  `status_name` VARCHAR(255),
  `status_description` VARCHAR(255),
  `is_shown` TINYINT default '0',
  `status_icon` VARCHAR(255),
  `status_style` VARCHAR(255),
  `allowed_view` TINYINT NOT NULL default '0'
  ,PRIMARY KEY (status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_articles_tags;
CREATE TABLE va_articles_tags (
  `article_id` INT(11) NOT NULL default '0',
  `tag_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (article_id,tag_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_authors;
CREATE TABLE va_authors (
  `author_id` INT(11) NOT NULL AUTO_INCREMENT,
  `author_name` VARCHAR(255),
  `other_name` VARCHAR(255),
  `name_first` VARCHAR(2),
  `middle_first` VARCHAR(2),
  `last_first` VARCHAR(2),
  `other_first` VARCHAR(2),
  `friendly_url` VARCHAR(255),
  `image_tiny` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_super` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT,
  `sites_all` TINYINT default '1',
  `date_added` DATETIME,
  `date_updated` DATETIME
  ,KEY friendly_url (friendly_url)
  ,KEY last_first (last_first)
  ,KEY middle_first (middle_first)
  ,KEY name_first (name_first)
  ,KEY other_first (other_first)
  ,PRIMARY KEY (author_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_authors_sites;
CREATE TABLE va_authors_sites (
  `author_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (author_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banned_contents;
CREATE TABLE va_banned_contents (
  `content_id` INT(11) NOT NULL AUTO_INCREMENT,
  `content_text` VARCHAR(255) NOT NULL
  ,PRIMARY KEY (content_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banners;
CREATE TABLE va_banners (
  `banner_id` INT(11) NOT NULL AUTO_INCREMENT,
  `banner_rank` INT(11) NOT NULL default '1',
  `banner_title` VARCHAR(255) NOT NULL,
  `show_title` INT(11) default '0',
  `image_src` VARCHAR(255),
  `image_alt` VARCHAR(255),
  `html_text` TEXT,
  `target_url` VARCHAR(255),
  `is_new_window` TINYINT default '0',
  `is_active` TINYINT default '0',
  `sites_all` TINYINT default '1',
  `show_on_ssl` TINYINT default '0',
  `max_impressions` INT(11) default '0',
  `max_clicks` INT(11) default '0',
  `expiry_date` DATETIME,
  `total_impressions` INT(11) default '0',
  `total_clicks` INT(11) default '0'
  ,KEY is_active (is_active)
  ,KEY max_clicks (max_clicks)
  ,KEY max_impressions (max_impressions)
  ,PRIMARY KEY (banner_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banners_assigned;
CREATE TABLE va_banners_assigned (
  `banner_id` INT(11) NOT NULL default '0',
  `group_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (banner_id,group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banners_clicks;
CREATE TABLE va_banners_clicks (
  `click_id` INT(11) NOT NULL AUTO_INCREMENT,
  `banner_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `remote_address` VARCHAR(50),
  `click_date` DATETIME NOT NULL
  ,KEY banner_id (banner_id)
  ,KEY click_date (click_date)
  ,PRIMARY KEY (click_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banners_groups;
CREATE TABLE va_banners_groups (
  `group_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_name` VARCHAR(128),
  `group_desc` TEXT,
  `is_active` TINYINT default '0'
  ,KEY is_active (is_active)
  ,PRIMARY KEY (group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_banners_sites;
CREATE TABLE va_banners_sites (
  `banner_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (banner_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_black_ips;
CREATE TABLE va_black_ips (
  `ip_address` VARCHAR(32) NOT NULL,
  `address_action` INT(11) default '0',
  `address_notes` VARCHAR(255)
  ,PRIMARY KEY (ip_address)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_bookmarks;
CREATE TABLE va_bookmarks (
  `bookmark_id` INT(11) NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(50) NOT NULL,
  `url` VARCHAR(255) NOT NULL,
  `admin_id` INT(11) NOT NULL default '0',
  `image_path` VARCHAR(255),
  `is_start_page` TINYINT default '0',
  `is_popup` TINYINT default '0',
  `notes` VARCHAR(255)
  ,KEY admin_id (admin_id)
  ,PRIMARY KEY (bookmark_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_caches;
CREATE TABLE va_caches (
  `cache_id` INT(11) NOT NULL AUTO_INCREMENT,
  `cache_type` VARCHAR(32),
  `cache_name` VARCHAR(32),
  `cache_parameter` VARCHAR(32),
  `cache_date` DATETIME NOT NULL,
  `cache_data` TEXT NOT NULL
  ,KEY cache_name (cache_name)
  ,KEY cache_parameter (cache_parameter)
  ,KEY cache_type (cache_type)
  ,PRIMARY KEY (cache_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_categories;
CREATE TABLE va_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_category_id` INT(11) NOT NULL default '0',
  `alias_category_id` INT(11) default '0',
  `redirect_category_id` INT(11) default '0',
  `google_base_type_id` INT(11) default '0',
  `category_path` VARCHAR(255) NOT NULL,
  `category_name` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `category_order` INT(11) NOT NULL default '1',
  `sites_all` TINYINT default '1',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7',
  `is_showing` TINYINT NOT NULL default '0',
  `allowed_post_subcategories` TINYINT default '0',
  `show_sub_products` TINYINT default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `image` VARCHAR(255),
  `image_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `list_class` VARCHAR(64),
  `list_template` VARCHAR(128),
  `details_template` VARCHAR(128),
  `table_view` TINYINT default '0',
  `a_title` VARCHAR(255),
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `total_views` INT(11) default '0',
  `header_menu_show` TINYINT default '0',
  `header_menu_order` INT(11),
  `header_menu_class` VARCHAR(64),
  `nav_bar_show` TINYINT default '0',
  `nav_bar_order` INT(11),
  `nav_bar_class` VARCHAR(64),
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY access_level (guest_access_level)
  ,KEY admin_access_level (admin_access_level)
  ,KEY category_path (category_path)
  ,KEY friendly_url (friendly_url)
  ,KEY google_base_type_id (google_base_type_id)
  ,KEY is_showing (is_showing)
  ,KEY parent_category_id (parent_category_id)
  ,PRIMARY KEY (category_id)
  ,KEY sites_all (sites_all)
  ,KEY subscription_access_level (access_level)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_categories_columns;
CREATE TABLE va_categories_columns (
  `column_id` INT(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) NOT NULL default '0',
  `column_order` TINYINT default '0',
  `column_code` VARCHAR(64),
  `column_title` VARCHAR(255),
  `column_html` TEXT
  ,KEY category_id (category_id)
  ,PRIMARY KEY (column_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_categories_sites;
CREATE TABLE va_categories_sites (
  `category_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (category_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_categories_subscriptions;
CREATE TABLE va_categories_subscriptions (
  `category_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_categories_user_types;
CREATE TABLE va_categories_user_types (
  `category_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cc_expiry_years;
CREATE TABLE va_cc_expiry_years (
  `expiry_year` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (expiry_year)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cc_start_years;
CREATE TABLE va_cc_start_years (
  `start_year` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (start_year)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_change_types;
CREATE TABLE va_change_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(255) NOT NULL
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_chats;
CREATE TABLE va_chats (
  `chat_id` INT(11) NOT NULL AUTO_INCREMENT,
  `chat_status` TINYINT default '1',
  `user_id` INT(11) default '0',
  `user_name` VARCHAR(128),
  `user_email` VARCHAR(128),
  `user_message` TEXT,
  `admin_id` INT(11) default '0',
  `chat_added` DATETIME,
  `chat_started` DATETIME,
  `chat_closed` DATETIME,
  `user_online` DATETIME,
  `user_last_added` DATETIME,
  `admin_online` DATETIME,
  `admin_last_added` DATETIME
  ,PRIMARY KEY (chat_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_chats_messages;
CREATE TABLE va_chats_messages (
  `message_id` INT(11) NOT NULL AUTO_INCREMENT,
  `chat_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `is_user_message` TINYINT default '0',
  `message_type` TINYINT default '1',
  `message_text` TEXT,
  `message_added` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY chat_id (chat_id)
  ,KEY message_type (message_type)
  ,PRIMARY KEY (message_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks;
CREATE TABLE va_cms_blocks (
  `block_id` INT(11) NOT NULL AUTO_INCREMENT,
  `module_id` INT(11) default '0',
  `block_order` INT(11) default '1',
  `block_code` VARCHAR(64),
  `block_name` VARCHAR(128),
  `php_script` VARCHAR(128),
  `layout_type` VARCHAR(32),
  `layout_template` VARCHAR(64),
  `html_template` VARCHAR(64),
  `css_class` VARCHAR(128),
  `block_title` TEXT,
  `pages_all` TINYINT default '0'
  ,PRIMARY KEY (block_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks_pages;
CREATE TABLE va_cms_blocks_pages (
  `block_id` INT(11) NOT NULL default '0',
  `page_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (block_id,page_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks_periods;
CREATE TABLE va_cms_blocks_periods (
  `period_id` INT(11) NOT NULL AUTO_INCREMENT,
  `ps_id` INT(11) default '0',
  `pb_id` INT(11) default '0',
  `start_date` DATETIME,
  `end_date` DATETIME,
  `start_time` INT(11) default '0',
  `end_time` INT(11) default '0',
  `week_days` INT(11) default '0'
  ,PRIMARY KEY (period_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks_properties;
CREATE TABLE va_cms_blocks_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `block_id` INT(11) default '0',
  `property_order` INT(11) default '1',
  `property_name` VARCHAR(255),
  `control_type` VARCHAR(16),
  `parent_property_id` INT(11),
  `parent_value_id` INT(11),
  `variable_name` VARCHAR(64),
  `default_value` VARCHAR(255),
  `required` TINYINT default '0',
  `property_class` VARCHAR(128),
  `property_style` TEXT,
  `control_style` TEXT,
  `start_html` TEXT,
  `middle_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `end_html` TEXT,
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks_settings;
CREATE TABLE va_cms_blocks_settings (
  `bs_id` INT(11) NOT NULL AUTO_INCREMENT,
  `ps_id` INT(11) default '0',
  `pb_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `value_id` INT(11) default '0',
  `variable_name` VARCHAR(64),
  `variable_value` VARCHAR(255)
  ,PRIMARY KEY (bs_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_blocks_values;
CREATE TABLE va_cms_blocks_values (
  `value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `value_order` INT(11) default '1',
  `value_name` VARCHAR(255),
  `variable_name` VARCHAR(64),
  `variable_value` VARCHAR(255),
  `hide_value` TINYINT default '0',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (value_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_frames;
CREATE TABLE va_cms_frames (
  `frame_id` INT(11) NOT NULL AUTO_INCREMENT,
  `layout_id` INT(11) default '0',
  `frame_name` VARCHAR(128),
  `tag_name` VARCHAR(128)
  ,PRIMARY KEY (frame_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_frames_settings;
CREATE TABLE va_cms_frames_settings (
  `fs_id` INT(11) NOT NULL AUTO_INCREMENT,
  `ps_id` INT(11) default '0',
  `frame_id` INT(11) default '0',
  `frame_style` TEXT,
  `frame_class` VARCHAR(64),
  `frame_code` TEXT,
  `html_frame_start` TEXT,
  `html_before_block` TEXT,
  `html_after_block` TEXT,
  `html_frame_end` TEXT,
  `html_between_blocks` TEXT
  ,KEY frame_id (frame_id)
  ,PRIMARY KEY (fs_id)
  ,KEY ps_id (ps_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_layouts;
CREATE TABLE va_cms_layouts (
  `layout_id` INT(11) NOT NULL AUTO_INCREMENT,
  `layout_name` VARCHAR(255),
  `layout_order` INT(11) default '0',
  `layout_template` VARCHAR(255),
  `admin_template` VARCHAR(255)
  ,PRIMARY KEY (layout_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_modules;
CREATE TABLE va_cms_modules (
  `module_id` INT(11) NOT NULL AUTO_INCREMENT,
  `module_order` INT(11) default '0',
  `module_code` VARCHAR(32),
  `module_name` VARCHAR(255)
  ,PRIMARY KEY (module_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_pages;
CREATE TABLE va_cms_pages (
  `page_id` INT(11) NOT NULL AUTO_INCREMENT,
  `module_id` INT(11) default '0',
  `page_order` INT(11) default '0',
  `page_code` VARCHAR(32),
  `page_name` VARCHAR(128)
  ,KEY page_code (page_code)
  ,PRIMARY KEY (page_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_pages_blocks;
CREATE TABLE va_cms_pages_blocks (
  `pb_id` INT(11) NOT NULL AUTO_INCREMENT,
  `ps_id` INT(11) default '0',
  `block_id` INT(11) default '0',
  `block_key` VARCHAR(32),
  `frame_id` INT(11) default '0',
  `block_order` INT(11) default '0',
  `tag_name` VARCHAR(128),
  `layout_type` VARCHAR(32),
  `layout_template` VARCHAR(64),
  `html_template` VARCHAR(128),
  `css_class` VARCHAR(128),
  `block_style` TEXT,
  `block_title` TEXT
  ,PRIMARY KEY (pb_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_cms_pages_settings;
CREATE TABLE va_cms_pages_settings (
  `ps_id` INT(11) NOT NULL AUTO_INCREMENT,
  `page_id` INT(11) default '0',
  `key_code` VARCHAR(32),
  `key_type` VARCHAR(16),
  `key_rule` VARCHAR(16),
  `layout_id` INT(11) default '0',
  `site_id` INT(11) default '0',
  `page_class` VARCHAR(64),
  `meta_title` TEXT,
  `meta_keywords` TEXT,
  `meta_description` TEXT
  ,KEY key_code (key_code)
  ,KEY page_id (page_id)
  ,PRIMARY KEY (ps_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_companies;
CREATE TABLE va_companies (
  `company_id` INT(11) NOT NULL AUTO_INCREMENT,
  `company_name` VARCHAR(255) NOT NULL,
  `image_small` VARCHAR(50),
  `image_large` VARCHAR(50),
  `address_info` TEXT,
  `phone_number` VARCHAR(32),
  `fax_number` VARCHAR(32),
  `site_url` VARCHAR(128),
  `contact_email` VARCHAR(128),
  `short_description` TEXT,
  `full_description` TEXT
  ,PRIMARY KEY (company_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_countries;
CREATE TABLE va_countries (
  `country_id` INT(11) NOT NULL AUTO_INCREMENT,
  `country_code` VARCHAR(4) NOT NULL,
  `country_iso_number` VARCHAR(4),
  `country_code_alpha3` VARCHAR(4),
  `country_order` INT(11) default '1',
  `country_name` VARCHAR(64) NOT NULL,
  `full_name` VARCHAR(64),
  `state_field_name` VARCHAR(64),
  `phone_code` VARCHAR(32),
  `currency_code` VARCHAR(4),
  `show_for_user` TINYINT default '1',
  `sites_all` TINYINT default '1'
  ,PRIMARY KEY (country_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_countries_sites;
CREATE TABLE va_countries_sites (
  `country_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (country_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_coupons;
CREATE TABLE va_coupons (
  `coupon_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `coupon_code` VARCHAR(64),
  `use_friends_code` TINYINT default '0',
  `coupon_title` VARCHAR(255),
  `is_active` TINYINT default '1',
  `is_auto_apply` TINYINT NOT NULL default '0',
  `apply_order` INT(11) default '1',
  `discount_type` TINYINT default '0',
  `discount_amount` DOUBLE(16,2) default '0',
  `discount_quantity` INT(11),
  `discount_tax_free` INT(11) default '0',
  `free_postage` TINYINT default '0',
  `free_postage_all` TINYINT default '1',
  `free_postage_ids` TEXT,
  `coupon_tax_free` TINYINT default '0',
  `order_tax_free` TINYINT default '0',
  `order_min_goods_cost` DOUBLE(16,2) default '0',
  `order_max_goods_cost` DOUBLE(16,2) default '0',
  `order_min_weight` DOUBLE(16,4) default '0',
  `order_max_weight` DOUBLE(16,4) default '0',
  `items_all` TINYINT default '1',
  `items_rule` TINYINT default '1',
  `items_ids` TEXT,
  `items_types_ids` TEXT,
  `items_categories_ids` TEXT,
  `cart_items_all` TINYINT default '1',
  `cart_items_ids` TEXT,
  `cart_items_types_ids` TEXT,
  `sites_all` TINYINT default '1',
  `users_all` TINYINT default '1',
  `users_ids` TEXT,
  `users_types_ids` TEXT,
  `users_use_limit` INT(11),
  `min_quantity` INT(11),
  `max_quantity` INT(11),
  `minimum_amount` DOUBLE(16,2) default '0',
  `maximum_amount` DOUBLE(16,2),
  `min_cart_quantity` INT(11),
  `max_cart_quantity` INT(11),
  `min_cart_cost` DOUBLE(16,2),
  `max_cart_cost` DOUBLE(16,2),
  `orders_period` TINYINT,
  `orders_interval` INT(11),
  `orders_min_goods` DOUBLE(16,2),
  `orders_max_goods` DOUBLE(16,2),
  `orders_min_quantity` INT(11),
  `orders_max_quantity` INT(11),
  `orders_items_type` TINYINT default '1',
  `orders_items_ids` TEXT,
  `orders_types_ids` TEXT,
  `friends_discount_type` TINYINT default '0',
  `friends_all` TINYINT default '1',
  `friends_ids` TEXT,
  `friends_types_ids` TEXT,
  `friends_period` TINYINT,
  `friends_interval` INT(11),
  `friends_min_goods` DOUBLE(16,2),
  `friends_max_goods` DOUBLE(16,2),
  `start_date` DATETIME,
  `expiry_date` DATETIME,
  `is_exclusive` TINYINT default '0',
  `quantity_limit` INT(11) default '1',
  `coupon_uses` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY coupon_code (coupon_code)
  ,KEY is_auto_apply (is_auto_apply)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (coupon_id)
  ,KEY sites_all (sites_all)
  ,KEY use_friends_code (use_friends_code)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_coupons_sites;
CREATE TABLE va_coupons_sites (
  `coupon_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (coupon_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_credit_cards;
CREATE TABLE va_credit_cards (
  `credit_card_id` INT(11) NOT NULL AUTO_INCREMENT,
  `credit_card_code` VARCHAR(32) NOT NULL,
  `credit_card_name` VARCHAR(64) NOT NULL
  ,PRIMARY KEY (credit_card_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_currencies;
CREATE TABLE va_currencies (
  `currency_id` INT(11) NOT NULL AUTO_INCREMENT,
  `is_default` TINYINT default '0',
  `is_default_show` TINYINT default '0',
  `show_for_user` TINYINT default '1',
  `currency_code` VARCHAR(4),
  `currency_value` VARCHAR(16),
  `currency_title` VARCHAR(64),
  `currency_image` VARCHAR(255),
  `currency_image_active` VARCHAR(255),
  `exchange_rate` DOUBLE(16,8) NOT NULL default '1',
  `symbol_left` VARCHAR(32),
  `symbol_right` VARCHAR(32),
  `decimals_number` TINYINT default '2',
  `decimal_point` VARCHAR(16),
  `thousands_separator` VARCHAR(16),
  `sites_all` TINYINT default '1'
  ,KEY currency_code (currency_code)
  ,PRIMARY KEY (currency_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_currencies_sites;
CREATE TABLE va_currencies_sites (
  `currency_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (currency_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_custom_blocks;
CREATE TABLE va_custom_blocks (
  `block_id` INT(11) NOT NULL AUTO_INCREMENT,
  `block_name` VARCHAR(128),
  `block_notes` TEXT,
  `block_class` VARCHAR(128),
  `block_title` VARCHAR(255),
  `block_path` VARCHAR(255),
  `block_desc` TEXT
  ,PRIMARY KEY (block_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ethnicities;
CREATE TABLE va_ethnicities (
  `ethnicity_id` INT(11) NOT NULL AUTO_INCREMENT,
  `ethnicity_name` VARCHAR(255),
  `sort_order` INT(11) default '1',
  `show_for_user` TINYINT default '1'
  ,PRIMARY KEY (ethnicity_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_export_fields;
CREATE TABLE va_export_fields (
  `field_id` INT(11) NOT NULL AUTO_INCREMENT,
  `template_id` INT(11) default '0',
  `field_order` INT(11) default '0',
  `field_title` VARCHAR(128),
  `field_source` TEXT
  ,PRIMARY KEY (field_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_export_filters;
CREATE TABLE va_export_filters (
  `filter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `template_id` INT(11) default '0',
  `filter_parameter` VARCHAR(64),
  `filter_value` VARCHAR(255)
  ,PRIMARY KEY (filter_id)
  ,KEY template_id (template_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_export_templates;
CREATE TABLE va_export_templates (
  `template_id` INT(11) NOT NULL AUTO_INCREMENT,
  `template_name` VARCHAR(255),
  `table_name` VARCHAR(64),
  `save_file` TINYINT default '0',
  `file_path_mask` VARCHAR(255),
  `file_path_mask_copy` VARCHAR(255),
  `ftp_upload` TINYINT default '0',
  `ftp_host` VARCHAR(255),
  `ftp_port` VARCHAR(16),
  `ftp_login` VARCHAR(128),
  `ftp_password` VARCHAR(255),
  `ftp_passive_mode` TINYINT default '0',
  `ftp_transfer_mode` VARCHAR(16),
  `ftp_path` VARCHAR(255),
  `use_filter` TINYINT default '0',
  `is_cronjob` TINYINT default '0',
  `order_status_update` INT(11),
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,PRIMARY KEY (template_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_features;
CREATE TABLE va_features (
  `feature_id` INT(11) NOT NULL AUTO_INCREMENT,
  `default_feature_id` INT(11) default '0',
  `item_id` INT(11) default '0',
  `group_id` INT(11) default '0',
  `google_base_attribute_id` INT(11) default '0',
  `feature_order` INT(11) default '1',
  `feature_code` VARCHAR(32),
  `feature_name` VARCHAR(255),
  `value_id` INT(11) default '0',
  `value_code` VARCHAR(32),
  `feature_value` VARCHAR(255),
  `show_as_group` TINYINT default '1',
  `show_on_table` TINYINT default '0',
  `show_on_details` TINYINT default '0',
  `show_on_basket` TINYINT default '0',
  `show_on_checkout` TINYINT default '0',
  `show_on_invoice` TINYINT default '0'
  ,KEY default_feature_id (default_feature_id)
  ,KEY feature_code (feature_code)
  ,KEY google_base_attribute_id (google_base_attribute_id)
  ,KEY group_id (group_id)
  ,KEY item_id (item_id)
  ,PRIMARY KEY (feature_id)
  ,KEY value_code (value_code)
  ,KEY value_id (value_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_features_default;
CREATE TABLE va_features_default (
  `feature_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_type_id` INT(11) default '0',
  `google_base_attribute_id` INT(11) default '0',
  `group_id` INT(11) default '0',
  `feature_order` INT(11) default '1',
  `feature_code` VARCHAR(32),
  `feature_name` VARCHAR(50),
  `feature_value` TEXT,
  `control_type` VARCHAR(16),
  `required` TINYINT default '0',
  `show_as_group` TINYINT default '1',
  `show_on_table` TINYINT default '0',
  `show_on_details` TINYINT default '0',
  `show_on_basket` TINYINT default '0',
  `show_on_checkout` TINYINT default '0',
  `show_on_invoice` TINYINT default '0'
  ,KEY google_base_attribute_id (google_base_attribute_id)
  ,KEY group_id (group_id)
  ,KEY item_type_id (item_type_id)
  ,PRIMARY KEY (feature_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_features_groups;
CREATE TABLE va_features_groups (
  `group_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_order` INT(11) NOT NULL default '1',
  `group_name` VARCHAR(255),
  `show_on_table` TINYINT default '0',
  `show_on_details` TINYINT default '1',
  `show_on_basket` TINYINT default '0',
  `show_on_checkout` TINYINT default '0',
  `show_on_invoice` TINYINT default '0',
  `item_types_all` TINYINT default '1'
  ,PRIMARY KEY (group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_features_item_types;
CREATE TABLE va_features_item_types (
  `group_id` INT(11) NOT NULL default '0',
  `item_type_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (group_id,item_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_features_values;
CREATE TABLE va_features_values (
  `value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `feature_id` INT(11) default '0',
  `value_order` INT(11) default '1',
  `value_code` VARCHAR(32),
  `value_desc` TEXT,
  `hide_value` TINYINT default '1',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (value_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_file_transfers;
CREATE TABLE va_file_transfers (
  `transfer_id` INT(11) NOT NULL AUTO_INCREMENT,
  `transfer_type` TINYINT default '0',
  `transfer_status` VARCHAR(16),
  `transfer_date` DATETIME,
  `ftp_host` VARCHAR(255),
  `ftp_port` VARCHAR(16),
  `ftp_login` VARCHAR(128),
  `ftp_password` VARCHAR(255),
  `ftp_passive_mode` TINYINT default '0',
  `ftp_transfer_mode` VARCHAR(16),
  `ftp_path` VARCHAR(255),
  `file_path` VARCHAR(255),
  `date_added` DATETIME,
  `date_transferred` DATETIME,
  `date_failed` DATETIME,
  `failed_attempts` INT(11) default '0',
  `failed_errors` TEXT
  ,PRIMARY KEY (transfer_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_file_types;
CREATE TABLE va_file_types (
  `file_type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_order` INT(11) default '0',
  `type_name` VARCHAR(255),
  `extension_mask` TEXT
  ,PRIMARY KEY (file_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_filters;
CREATE TABLE va_filters (
  `filter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `filter_type` VARCHAR(32),
  `filter_name` VARCHAR(255),
  `filter_desc` TEXT
  ,PRIMARY KEY (filter_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_filters_properties;
CREATE TABLE va_filters_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `filter_id` INT(11) NOT NULL default '0',
  `property_order` INT(11) NOT NULL default '1',
  `property_name` VARCHAR(255),
  `property_type` VARCHAR(64),
  `property_value` VARCHAR(255),
  `filter_from_sql` TEXT,
  `filter_join_sql` TEXT,
  `filter_where_sql` TEXT,
  `list_group_fields` TEXT,
  `list_group_where` TEXT,
  `list_table` VARCHAR(64),
  `list_field_id` VARCHAR(64),
  `list_field_title` VARCHAR(64),
  `list_field_total` VARCHAR(64),
  `list_sql` TEXT
  ,KEY filter_id (filter_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_filters_properties_values;
CREATE TABLE va_filters_properties_values (
  `value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `value_order` INT(11),
  `list_value_id` VARCHAR(128),
  `list_value_title` VARCHAR(255),
  `filter_where_sql` TEXT
  ,KEY filter_property_id (property_id)
  ,PRIMARY KEY (value_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum;
CREATE TABLE va_forum (
  `thread_id` INT(11) NOT NULL AUTO_INCREMENT,
  `forum_id` INT(11) NOT NULL default '0',
  `priority_id` INT(11) default '0',
  `user_id` INT(11) NOT NULL default '0',
  `user_name` VARCHAR(64) NOT NULL,
  `user_email` VARCHAR(128) NOT NULL,
  `remote_address` VARCHAR(32),
  `topic` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `description` TEXT NOT NULL,
  `email_notification` INT(11),
  `views` INT(11),
  `replies` INT(11),
  `date_added` DATETIME NOT NULL,
  `date_modified` DATETIME,
  `thread_updated` DATETIME NOT NULL,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `last_post_added` DATETIME,
  `last_post_user_id` INT(11) default '0',
  `last_post_admin_id` INT(11) default '0',
  `last_post_message_id` INT(11) default '0'
  ,KEY forum_id (forum_id)
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (thread_id)
  ,KEY priority_id (priority_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_attachments;
CREATE TABLE va_forum_attachments (
  `attachment_id` INT(11) NOT NULL AUTO_INCREMENT,
  `forum_id` INT(11) NOT NULL default '0',
  `thread_id` INT(11) default '0',
  `message_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `session_id` VARCHAR(32),
  `attachment_status` INT(11) default '0',
  `file_name` VARCHAR(255),
  `file_path` VARCHAR(255),
  `date_added` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY message_id (message_id)
  ,PRIMARY KEY (attachment_id)
  ,KEY session_id (session_id)
  ,KEY support_id (forum_id)
  ,KEY thread_id (thread_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_categories;
CREATE TABLE va_forum_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `category_name` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `category_order` INT(11) default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `allowed_view` TINYINT NOT NULL default '0',
  `sites_all` TINYINT default '1'
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (category_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_categories_sites;
CREATE TABLE va_forum_categories_sites (
  `category_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (category_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_list;
CREATE TABLE va_forum_list (
  `forum_id` INT(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) NOT NULL default '0',
  `forum_name` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `forum_order` INT(11) NOT NULL default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `small_image` VARCHAR(255),
  `large_image` VARCHAR(255),
  `date_added` DATETIME NOT NULL,
  `threads_number` INT(11) NOT NULL default '0',
  `messages_number` INT(11) NOT NULL default '0',
  `last_post_added` DATETIME,
  `last_post_user_id` INT(11) default '0',
  `last_post_admin_id` INT(11) default '0',
  `last_post_thread_id` INT(11) default '0',
  `last_post_message_id` INT(11) default '0',
  `is_rss` TINYINT default '0',
  `rss_limit` INT(11),
  `rss_on_breadcrumb` TINYINT default '0',
  `rss_on_list` TINYINT default '0',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7'
  ,KEY access_level (guest_access_level)
  ,KEY admin_access_level (admin_access_level)
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (forum_id)
  ,KEY subscription_access_level (access_level)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_messages;
CREATE TABLE va_forum_messages (
  `message_id` INT(11) NOT NULL AUTO_INCREMENT,
  `thread_id` INT(11) NOT NULL default '0',
  `admin_id` INT(11),
  `user_name` VARCHAR(64) NOT NULL,
  `user_email` VARCHAR(128) NOT NULL,
  `remote_address` VARCHAR(32),
  `message_text` TEXT NOT NULL,
  `date_added` DATETIME NOT NULL,
  `date_modified` DATETIME,
  `user_id` INT(11) NOT NULL default '0',
  `admin_id_modified_by` INT(11) default '0'
  ,PRIMARY KEY (message_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_moderators;
CREATE TABLE va_forum_moderators (
  `admin_id` INT(11) NOT NULL default '0',
  `forum_id` INT(11) NOT NULL default '0',
  `is_default_forum` TINYINT default '0'
  ,PRIMARY KEY (admin_id,forum_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_priorities;
CREATE TABLE va_forum_priorities (
  `priority_id` INT(11) NOT NULL AUTO_INCREMENT,
  `priority_name` VARCHAR(255),
  `priority_rank` INT(11) default '0',
  `html_before_title` TEXT,
  `html_after_title` TEXT,
  `is_default` TINYINT default '0'
  ,PRIMARY KEY (priority_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_subscriptions;
CREATE TABLE va_forum_subscriptions (
  `forum_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (forum_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_forum_user_types;
CREATE TABLE va_forum_user_types (
  `forum_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (forum_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_friendly_urls;
CREATE TABLE va_friendly_urls (
  `friendly_id` INT(11) NOT NULL AUTO_INCREMENT,
  `script_name` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `sites_all` TINYINT default '1'
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (friendly_id)
  ,KEY script_name (script_name)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_friendly_urls_sites;
CREATE TABLE va_friendly_urls_sites (
  `friendly_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (friendly_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_global_settings;
CREATE TABLE va_global_settings (
  `site_id` INT(11) NOT NULL default '1',
  `setting_type` VARCHAR(32) NOT NULL,
  `setting_name` VARCHAR(64) NOT NULL,
  `setting_value` TEXT
  ,PRIMARY KEY (site_id,setting_type,setting_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_google_base_attributes;
CREATE TABLE va_google_base_attributes (
  `attribute_id` INT(11) NOT NULL AUTO_INCREMENT,
  `attribute_name` VARCHAR(255),
  `attribute_type` VARCHAR(16),
  `value_type` VARCHAR(32)
  ,PRIMARY KEY (attribute_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_google_base_types;
CREATE TABLE va_google_base_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(255)
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_google_base_types_attributes;
CREATE TABLE va_google_base_types_attributes (
  `type_id` INT(11) NOT NULL default '0',
  `attribute_id` INT(11) NOT NULL default '0',
  `required` TINYINT default '0'
  ,PRIMARY KEY (type_id,attribute_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_icons;
CREATE TABLE va_icons (
  `icon_id` INT(11) NOT NULL AUTO_INCREMENT,
  `is_active` TINYINT default '1',
  `show_for_user` TINYINT default '1',
  `icon_order` INT(11) default '1',
  `icon_code` VARCHAR(32),
  `icon_image` VARCHAR(255),
  `icon_width` INT(11),
  `icon_height` INT(11),
  `icon_name` VARCHAR(255)
  ,PRIMARY KEY (icon_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_ips_countries;
CREATE TABLE va_ips_countries (
  `ip_start` INT(11) NOT NULL default '0',
  `ip_end` INT(11) NOT NULL default '0',
  `country_code` VARCHAR(4)
  ,PRIMARY KEY (ip_start,ip_end)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_issue_numbers;
CREATE TABLE va_issue_numbers (
  `issue_number` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (issue_number)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_item_types;
CREATE TABLE va_item_types (
  `item_type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `google_base_type_id` INT(11) default '0',
  `item_type_name` VARCHAR(50),
  `is_gift_voucher` TINYINT default '0',
  `is_bundle` TINYINT default '0',
  `is_user` TINYINT default '0',
  `reward_type` INT(11),
  `reward_amount` DOUBLE(16,4),
  `credit_reward_type` TINYINT,
  `credit_reward_amount` DOUBLE(16,2),
  `affiliate_commission_type` INT(11),
  `affiliate_commission_amount` DOUBLE(16,2),
  `merchant_fee_type` INT(11),
  `merchant_fee_amount` DOUBLE(16,2)
  ,KEY google_base_type_id (google_base_type_id)
  ,PRIMARY KEY (item_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items;
CREATE TABLE va_items (
  `item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_code` VARCHAR(64),
  `item_name` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `item_order` INT(11) NOT NULL default '1',
  `item_type_id` INT(11) NOT NULL default '0',
  `google_base_type_id` INT(11) default '0',
  `issue_date` DATETIME,
  `language_code` VARCHAR(4),
  `manufacturer_id` INT(11) default '0',
  `manufacturer_code` VARCHAR(255),
  `supplier_id` INT(11) default '0',
  `author_id` INT(11),
  `template_name` VARCHAR(255),
  `hide_add_list` TINYINT default '0',
  `hide_add_table` TINYINT default '0',
  `hide_add_grid` TINYINT default '0',
  `hide_add_details` TINYINT default '0',
  `hide_view_list` TINYINT default '0',
  `hide_view_details` TINYINT default '0',
  `hide_view_table` TINYINT default '0',
  `hide_view_grid` TINYINT default '0',
  `hide_checkout_list` TINYINT default '0',
  `hide_checkout_details` TINYINT default '0',
  `hide_checkout_table` TINYINT default '0',
  `hide_checkout_grid` TINYINT default '0',
  `hide_wishlist_list` TINYINT default '0',
  `hide_wishlist_details` TINYINT default '0',
  `hide_wishlist_table` TINYINT default '0',
  `hide_wishlist_grid` TINYINT default '0',
  `hide_shipping_details` TINYINT default '0',
  `features` TEXT,
  `highlights` TEXT,
  `short_description` TEXT,
  `full_desc_type` TINYINT,
  `full_description` TEXT,
  `is_special_offer` TINYINT NOT NULL default '0',
  `special_order` INT(11) default '1',
  `special_offer` TEXT,
  `notes` TEXT,
  `tiny_image` VARCHAR(255),
  `tiny_image_alt` VARCHAR(255),
  `small_image` VARCHAR(255),
  `small_image_alt` VARCHAR(255),
  `big_image` VARCHAR(255),
  `big_image_alt` VARCHAR(255),
  `super_image` VARCHAR(255),
  `super_image_alt` VARCHAR(255),
  `preview_url` VARCHAR(255),
  `preview_width` INT(11),
  `preview_height` INT(11),
  `specification` VARCHAR(255),
  `buying_price` DOUBLE(16,2) default '0',
  `buying_price_id` INT(11) default '0',
  `price` DOUBLE(16,2) NOT NULL default '0',
  `price_id` INT(11) default '0',
  `trade_price` DOUBLE(16,2) NOT NULL default '0',
  `trade_price_id` INT(11) default '0',
  `is_price_edit` TINYINT default '0',
  `properties_price` DOUBLE(16,2) default '0',
  `properties_price_id` INT(11) default '0',
  `trade_properties_price` DOUBLE(16,2) default '0',
  `trade_properties_price_id` INT(11) default '0',
  `tax_id` INT(11) default '0',
  `tax_free` TINYINT default '0',
  `width` DOUBLE(16,4) default '0',
  `height` DOUBLE(16,4) default '0',
  `length` DOUBLE(16,4) default '0',
  `weight` DOUBLE(16,4),
  `packages_number` DOUBLE(16,4),
  `min_quantity` INT(11),
  `max_quantity` INT(11),
  `quantity_increment` INT(11),
  `stock_level` INT(11),
  `use_stock_level` INT(11) NOT NULL default '0',
  `hide_out_of_stock` TINYINT NOT NULL default '0',
  `disable_out_of_stock` TINYINT default '0',
  `is_shipping_free` TINYINT default '0',
  `is_separate_shipping` TINYINT default '0',
  `is_shipping_required` TINYINT default '0',
  `shipping_in_stock` INT(11),
  `shipping_out_stock` INT(11) default '0',
  `shipping_rule_id` INT(11),
  `shipping_cost` DOUBLE(16,2),
  `shipping_trade_cost` DOUBLE(16,2),
  `shipping_modules_default` TINYINT default '1',
  `shipping_modules_ids` TEXT,
  `is_sales` TINYINT,
  `sales_price` DOUBLE(16,2) NOT NULL default '0',
  `sales_price_id` INT(11) default '0',
  `trade_sales` DOUBLE(16,2) NOT NULL default '0',
  `trade_sales_id` INT(11) default '0',
  `discount_percent` DOUBLE(16,2),
  `is_points_price` TINYINT default '0',
  `points_price` DOUBLE(16,4),
  `reward_type` INT(11),
  `reward_amount` DOUBLE(16,4),
  `credit_reward_type` TINYINT,
  `credit_reward_amount` DOUBLE(16,2),
  `is_recurring` TINYINT default '0',
  `recurring_price` DOUBLE(16,2),
  `recurring_period` INT(11),
  `recurring_interval` INT(11),
  `recurring_payments_total` INT(11),
  `recurring_start_date` DATETIME,
  `recurring_end_date` DATETIME,
  `affiliate_commission_type` INT(11),
  `affiliate_commission_amount` DOUBLE(16,2),
  `merchant_fee_type` INT(11),
  `merchant_fee_amount` DOUBLE(16,2),
  `downloadable` TINYINT,
  `download_period` INT(11),
  `download_path` TEXT,
  `download_show_terms` INT(11) default '0',
  `download_terms_text` TEXT,
  `generate_serial` INT(11) default '0',
  `serial_period` INT(11),
  `activations_number` INT(11) default '0',
  `is_showing` TINYINT NOT NULL default '1',
  `is_approved` TINYINT NOT NULL default '1',
  `is_new` TINYINT default '0',
  `is_keywords` TINYINT default '0',
  `sites_all` TINYINT default '1',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7',
  `is_compared` TINYINT default '0',
  `buy_link` VARCHAR(255),
  `total_views` INT(11) default '0',
  `votes` INT(11),
  `points` INT(11),
  `rating` DOUBLE(16,4),
  `a_title` VARCHAR(255),
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `mail_notify` INT(11) default '0',
  `mail_to` VARCHAR(255),
  `mail_from` VARCHAR(64),
  `mail_cc` VARCHAR(255),
  `mail_bcc` VARCHAR(255),
  `mail_reply_to` VARCHAR(64),
  `mail_return_path` VARCHAR(64),
  `mail_type` INT(11) default '0',
  `mail_subject` VARCHAR(255),
  `mail_body` TEXT,
  `sms_notify` INT(11) default '0',
  `sms_recipient` VARCHAR(255),
  `sms_originator` VARCHAR(64),
  `sms_message` TEXT,
  `user_id` INT(11) default '0',
  `is_draft` TINYINT default '0',
  `draft_parent_id` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY access_level (access_level)
  ,KEY admin_access_level (admin_access_level)
  ,KEY buying_price_id (buying_price_id)
  ,KEY draft_parent_id (draft_parent_id)
  ,KEY friendly_url (friendly_url)
  ,KEY google_base_type_id (google_base_type_id)
  ,KEY guest_access_level (guest_access_level)
  ,KEY hide_out_of_stock (hide_out_of_stock)
  ,KEY is_approved (is_approved)
  ,KEY is_draft (is_draft)
  ,KEY is_showing (is_showing)
  ,KEY is_special_offer (is_special_offer)
  ,KEY item_code (item_code)
  ,KEY item_name (item_name)
  ,KEY language_code (language_code)
  ,KEY manufacturer_id (manufacturer_id)
  ,KEY price (price)
  ,KEY price_id (price_id)
  ,PRIMARY KEY (item_id)
  ,KEY properties_price_id (properties_price_id)
  ,KEY sales_price (sales_price)
  ,KEY sales_price_id (sales_price_id)
  ,KEY sites_all (sites_all)
  ,KEY special_order (special_order)
  ,KEY supplier_id (supplier_id)
  ,KEY trade_price (trade_price)
  ,KEY trade_price_id (trade_price_id)
  ,KEY trade_properties_price_id (trade_properties_price_id)
  ,KEY trade_sales (trade_sales)
  ,KEY trade_sales_id (trade_sales_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_accessories;
CREATE TABLE va_items_accessories (
  `item_id` INT(11) NOT NULL default '0',
  `accessory_id` INT(11) NOT NULL default '0',
  `accessory_order` INT(11) NOT NULL default '1'
  ,PRIMARY KEY (item_id,accessory_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_categories;
CREATE TABLE va_items_categories (
  `item_id` INT(11) NOT NULL default '0',
  `category_id` INT(11) NOT NULL default '0',
  `item_order` INT(11) default '1'
  ,PRIMARY KEY (item_id,category_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_downloads;
CREATE TABLE va_items_downloads (
  `download_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) NOT NULL default '0',
  `user_id` INT(11) NOT NULL default '0',
  `order_item_id` INT(11) NOT NULL default '0',
  `item_id` INT(11) NOT NULL default '0',
  `download_notes` VARCHAR(255),
  `download_path` VARCHAR(255),
  `activated` TINYINT,
  `max_downloads` INT(11),
  `download_added` DATETIME NOT NULL,
  `download_expiry` DATETIME,
  `download_limit` INT(11)
  ,KEY item_id (item_id)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (download_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_downloads_statistic;
CREATE TABLE va_items_downloads_statistic (
  `download_id` INT(11) NOT NULL default '0',
  `order_item_id` INT(11) NOT NULL default '0',
  `remote_address` VARCHAR(32) NOT NULL,
  `downloaded_date` DATETIME NOT NULL
  ,KEY download_id (download_id)
  ,KEY downloaded_date (downloaded_date)
  ,KEY order_item_id (order_item_id)
  ,KEY remote_address (remote_address)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_files;
CREATE TABLE va_items_files (
  `file_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) default '0',
  `item_type_id` INT(11) default '0',
  `download_type` TINYINT default '1',
  `download_title` VARCHAR(255),
  `download_path` VARCHAR(255),
  `download_period` TINYINT,
  `download_interval` INT(11),
  `download_limit` INT(11),
  `preview_type` TINYINT default '0',
  `preview_title` VARCHAR(255),
  `preview_path` VARCHAR(255),
  `preview_image` VARCHAR(255),
  `preview_position` TINYINT default '0'
  ,KEY item_id (item_id)
  ,KEY item_type_id (item_type_id)
  ,PRIMARY KEY (file_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_forum_topics;
CREATE TABLE va_items_forum_topics (
  `item_id` INT(11) NOT NULL default '0',
  `thread_id` INT(11) NOT NULL default '0',
  `item_order` INT(11) default '1',
  `thread_order` INT(11) default '1'
  ,PRIMARY KEY (item_id,thread_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_images;
CREATE TABLE va_items_images (
  `image_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) NOT NULL default '0',
  `is_default` TINYINT default '0',
  `image_order` INT(11) default '0',
  `image_position` TINYINT default '1',
  `image_title` VARCHAR(255),
  `image_tiny` VARCHAR(255),
  `image_tiny_alt` VARCHAR(255),
  `image_small` VARCHAR(255) NOT NULL,
  `image_small_alt` VARCHAR(255),
  `small_width` INT(11),
  `small_height` INT(11),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `image_super` VARCHAR(255),
  `image_super_alt` VARCHAR(255),
  `image_description` TEXT
  ,KEY item_id (item_id)
  ,PRIMARY KEY (image_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_prices;
CREATE TABLE va_items_prices (
  `price_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) default '0',
  `is_active` INT(11) default '0',
  `min_quantity` INT(11) default '1',
  `max_quantity` INT(11) default '1',
  `price` DOUBLE(16,2) default '0',
  `user_type_id` INT(11) default '0',
  `site_id` INT(11) default '0',
  `discount_action` INT(11) default '0',
  `properties_discount` DOUBLE(16,2) default '0'
  ,KEY item_id (item_id)
  ,PRIMARY KEY (price_id)
  ,KEY site_id (site_id)
  ,KEY user_type_id (user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_properties;
CREATE TABLE va_items_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_type_id` INT(11) default '1',
  `parent_property_id` INT(11),
  `parent_value_id` INT(11),
  `show_for_user` TINYINT default '1',
  `usage_type` TINYINT default '1',
  `item_type_id` INT(11) default '0',
  `item_id` INT(11) NOT NULL default '0',
  `sub_item_id` INT(11) default '0',
  `additional_price` DOUBLE(16,2),
  `trade_additional_price` DOUBLE(16,2),
  `percentage_price_type` TINYINT default '1',
  `percentage_property_id` INT(11),
  `quantity` INT(11),
  `quantity_action` TINYINT default '1',
  `property_order` INT(11) NOT NULL default '1',
  `property_step` INT(11) default '1',
  `property_name` VARCHAR(255) NOT NULL,
  `property_hint` VARCHAR(255),
  `hide_name` TINYINT default '0',
  `property_code` VARCHAR(32),
  `property_description` TEXT,
  `property_class` VARCHAR(64),
  `property_style` TEXT,
  `property_price_type` TINYINT,
  `free_price_type` TINYINT,
  `free_price_amount` DOUBLE(16,2),
  `max_limit_type` TINYINT,
  `max_limit_length` INT(11),
  `length_units` VARCHAR(8),
  `use_on_list` TINYINT default '1',
  `use_on_table` TINYINT default '1',
  `use_on_grid` TINYINT default '0',
  `use_on_details` TINYINT default '1',
  `use_on_checkout` TINYINT default '0',
  `use_on_second` TINYINT default '0',
  `control_type` VARCHAR(16) NOT NULL,
  `control_style` VARCHAR(255),
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT,
  `required` TINYINT default '0',
  `start_html` TEXT,
  `middle_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `end_html` TEXT,
  `sites_all` TINYINT default '1'
  ,KEY item_id (item_id)
  ,KEY item_type_id (item_type_id)
  ,PRIMARY KEY (property_id)
  ,KEY property_code (property_code)
  ,KEY property_type_id (property_type_id)
  ,KEY sites_all (sites_all)
  ,KEY sub_item_id (sub_item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_properties_assigned;
CREATE TABLE va_items_properties_assigned (
  `item_id` INT(11) NOT NULL default '0',
  `property_id` INT(11) NOT NULL default '0',
  `property_description` TEXT
  ,PRIMARY KEY (item_id,property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_properties_sites;
CREATE TABLE va_items_properties_sites (
  `property_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (property_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_properties_sizes;
CREATE TABLE va_items_properties_sizes (
  `size_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `width` DOUBLE(16,4) default '0',
  `height` DOUBLE(16,4) default '0',
  `price` DOUBLE(16,2) default '0'
  ,PRIMARY KEY (size_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_properties_values;
CREATE TABLE va_items_properties_values (
  `item_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) NOT NULL default '0',
  `sub_item_id` INT(11) default '0',
  `property_value` VARCHAR(255) NOT NULL,
  `value_order` INT(11) default '1',
  `item_code` VARCHAR(64),
  `manufacturer_code` VARCHAR(64),
  `download_period` INT(11),
  `download_path` VARCHAR(255),
  `download_files_ids` TEXT,
  `buying_price` DOUBLE(16,2),
  `additional_price` DOUBLE(16,2),
  `trade_additional_price` DOUBLE(16,2),
  `quantity` INT(11),
  `percentage_price` DOUBLE(16,2),
  `additional_weight` DOUBLE(16,4),
  `use_stock_level` TINYINT default '0',
  `stock_level` INT(11),
  `hide_out_of_stock` TINYINT default '0',
  `hide_value` TINYINT NOT NULL default '0',
  `is_default_value` TINYINT default '0',
  `image_tiny` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_super` VARCHAR(255)
  ,KEY hide_value (hide_value)
  ,PRIMARY KEY (item_property_id)
  ,KEY property_id (property_id)
  ,KEY sub_item_id (sub_item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_related;
CREATE TABLE va_items_related (
  `item_id` INT(11) NOT NULL default '0',
  `related_id` INT(11) NOT NULL default '0',
  `related_order` INT(11) NOT NULL default '1'
  ,KEY item_id (item_id)
  ,KEY related_id (related_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_serials;
CREATE TABLE va_items_serials (
  `serial_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) default '0',
  `serial_number` VARCHAR(128),
  `used` TINYINT default '0'
  ,KEY item_id (item_id)
  ,PRIMARY KEY (serial_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_sites;
CREATE TABLE va_items_sites (
  `item_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (item_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_subscriptions;
CREATE TABLE va_items_subscriptions (
  `item_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (item_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_tabs;
CREATE TABLE va_items_tabs (
  `tab_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) default '0',
  `tab_order` INT(11) default '1',
  `tab_title` VARCHAR(50),
  `tab_desc` TEXT,
  `hide_tab` TINYINT default '0'
  ,KEY item_id (item_id)
  ,PRIMARY KEY (tab_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_user_types;
CREATE TABLE va_items_user_types (
  `item_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (item_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_items_values_assigned;
CREATE TABLE va_items_values_assigned (
  `item_id` INT(11) NOT NULL default '0',
  `property_value_id` INT(11) NOT NULL default '0',
  `is_default_value` TINYINT
  ,PRIMARY KEY (item_id,property_value_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_keywords;
CREATE TABLE va_keywords (
  `keyword_id` INT(11) NOT NULL AUTO_INCREMENT,
  `keyword_name` VARCHAR(255)
  ,PRIMARY KEY (keyword_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_keywords_items;
CREATE TABLE va_keywords_items (
  `item_id` INT(11) default '0',
  `keyword_id` INT(11) default '0',
  `field_id` TINYINT default '0',
  `keyword_position` SMALLINT default '0',
  `keyword_rank` SMALLINT default '0'
  ,KEY field_id (field_id)
  ,KEY item_id (item_id)
  ,KEY keyword_id (keyword_id)
  ,KEY keyword_position (keyword_position)
  ,KEY keyword_rank (keyword_rank)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_languages;
CREATE TABLE va_languages (
  `language_code` VARCHAR(2) NOT NULL,
  `language_order` INT(11) default '1',
  `language_name` VARCHAR(255) NOT NULL,
  `show_for_user` TINYINT default '0',
  `language_image` VARCHAR(255),
  `language_image_active` VARCHAR(255),
  `currency_code` VARCHAR(4)
  ,PRIMARY KEY (language_code)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_layouts;
CREATE TABLE va_layouts (
  `layout_id` INT(11) NOT NULL AUTO_INCREMENT,
  `sites_all` TINYINT default '1',
  `show_for_user` TINYINT default '0',
  `layout_name` VARCHAR(64) NOT NULL,
  `user_layout_name` VARCHAR(255),
  `top_menu_type` INT(11) default '1',
  `style_name` VARCHAR(64),
  `scheme_name` VARCHAR(64),
  `templates_dir` VARCHAR(255) NOT NULL,
  `admin_templates_dir` VARCHAR(255) NOT NULL,
  `block_default_template` VARCHAR(64),
  `block_area_template` VARCHAR(64),
  `block_breadcrumb_template` VARCHAR(64)
  ,PRIMARY KEY (layout_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_layouts_sites;
CREATE TABLE va_layouts_sites (
  `layout_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (layout_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_articles;
CREATE TABLE va_manuals_articles (
  `article_id` INT(11) NOT NULL AUTO_INCREMENT,
  `manual_id` INT(11) default '0',
  `parent_article_id` INT(11) default '0',
  `alias_article_id` INT(11) default '0',
  `article_path` VARCHAR(255) NOT NULL,
  `article_title` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `article_order` INT(11) default '0',
  `section_number` VARCHAR(255),
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT,
  `allowed_view` TINYINT NOT NULL default '0',
  `shown_in_contents` TINYINT NOT NULL default '0',
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0'
  ,KEY alias_article_id (alias_article_id)
  ,KEY article_path (article_path)
  ,KEY friendly_url (friendly_url)
  ,KEY manual_id (manual_id)
  ,KEY parent_article_id (parent_article_id)
  ,PRIMARY KEY (article_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_categories;
CREATE TABLE va_manuals_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `category_name` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `category_order` INT(11) default '0',
  `short_description` TEXT,
  `full_description` TEXT,
  `sites_all` TINYINT default '1',
  `access_level` TINYINT default '7',
  `guest_access_level` TINYINT default '7',
  `admin_access_level` TINYINT default '7',
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0'
  ,KEY admin_access_level (admin_access_level)
  ,KEY friendly_url (friendly_url)
  ,KEY guest_access_level (guest_access_level)
  ,PRIMARY KEY (category_id)
  ,KEY sites_all (sites_all)
  ,KEY subscription_access_level (access_level)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_categories_sites;
CREATE TABLE va_manuals_categories_sites (
  `category_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (category_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_categories_subscriptions;
CREATE TABLE va_manuals_categories_subscriptions (
  `category_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_categories_types;
CREATE TABLE va_manuals_categories_types (
  `category_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0',
  `access_level` TINYINT default '0'
  ,PRIMARY KEY (category_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manuals_list;
CREATE TABLE va_manuals_list (
  `manual_id` INT(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) default '0',
  `alias_manual_id` INT(11) default '0',
  `manual_order` INT(11) default '0',
  `manual_title` VARCHAR(255),
  `friendly_url` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT,
  `allowed_view` TINYINT default '0',
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255),
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0'
  ,KEY alias_manual_id (alias_manual_id)
  ,KEY category_id (category_id)
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (manual_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_manufacturers;
CREATE TABLE va_manufacturers (
  `manufacturer_id` INT(11) NOT NULL AUTO_INCREMENT,
  `manufacturer_name` VARCHAR(255) NOT NULL,
  `manufacturer_order` INT(11) NOT NULL default '1',
  `friendly_url` VARCHAR(255),
  `affiliate_code` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT,
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255)
  ,KEY friendly_url (friendly_url)
  ,PRIMARY KEY (manufacturer_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_menus;
CREATE TABLE va_menus (
  `menu_id` INT(11) NOT NULL AUTO_INCREMENT,
  `menu_type` TINYINT default '0',
  `menu_title` VARCHAR(255),
  `menu_name` VARCHAR(128),
  `block_class` VARCHAR(128),
  `menu_class` VARCHAR(128),
  `menu_notes` TEXT,
  `show_title` INT(11) default '0',
  `sites_all` TINYINT default '1'
  ,PRIMARY KEY (menu_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_menus_items;
CREATE TABLE va_menus_items (
  `menu_item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `menu_id` INT(11) default '0',
  `parent_menu_item_id` INT(11) default '0',
  `menu_code` VARCHAR(64),
  `menu_title` VARCHAR(255),
  `menu_url` VARCHAR(255),
  `menu_target` VARCHAR(32),
  `menu_image` VARCHAR(255),
  `menu_image_active` VARCHAR(255),
  `menu_order` INT(11) default '0',
  `menu_class` VARCHAR(64),
  `head_content` TEXT,
  `foot_content` TEXT,
  `guest_access` TINYINT default '1',
  `user_access` VARCHAR(255),
  `admin_access` VARCHAR(255)
  ,KEY menu_id (menu_id)
  ,KEY parent_menu_item_id (parent_menu_item_id)
  ,PRIMARY KEY (menu_item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_menus_sites;
CREATE TABLE va_menus_sites (
  `menu_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (menu_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_messages;
CREATE TABLE va_messages (
  `message_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_message_id` INT(11) default '0',
  `reply_message_id` INT(11) default '0',
  `forward_message_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `system_folder_id` TINYINT default '1',
  `user_folder_id` INT(11) default '0',
  `message_from` VARCHAR(64),
  `from_admin_id` INT(11) default '0',
  `from_user_id` INT(11) default '0',
  `to_admin_id` INT(11) default '0',
  `to_user_id` INT(11) default '0',
  `message_type` TINYINT default '0',
  `message_key_id` INT(11) default '0',
  `message_to` VARCHAR(255),
  `message_cc` VARCHAR(255),
  `message_bcc` VARCHAR(255),
  `message_subject` VARCHAR(255),
  `message_text` TEXT,
  `date_added` DATETIME,
  `date_read` DATETIME,
  `date_replied` DATETIME,
  `date_forwarded` DATETIME,
  `date_sent` DATETIME,
  `date_modified` DATETIME,
  `date_trashed` DATETIME,
  `date_deleted` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY date_added (date_added)
  ,KEY date_deleted (date_deleted)
  ,KEY date_trashed (date_trashed)
  ,KEY from_admin_id (from_admin_id)
  ,KEY from_user_id (from_user_id)
  ,KEY message_key_id (message_key_id)
  ,KEY message_type (message_type)
  ,KEY parent_message_id (parent_message_id)
  ,PRIMARY KEY (message_id)
  ,KEY system_folder_id (system_folder_id)
  ,KEY user_folder_id (user_folder_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletter_filters;
CREATE TABLE va_newsletter_filters (
  `filter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `newsletter_id` INT(11) default '0',
  `filter_parameter` VARCHAR(64),
  `filter_value` VARCHAR(255)
  ,KEY newsletter_id (newsletter_id)
  ,PRIMARY KEY (filter_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters;
CREATE TABLE va_newsletters (
  `newsletter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `campaign_id` INT(11) default '0',
  `template_newsletter_id` INT(11),
  `newsletter_type` TINYINT default '1',
  `newsletter_date` DATETIME NOT NULL,
  `newsletter_subject` VARCHAR(255) NOT NULL,
  `newsletter_body` TEXT,
  `mail_type` TINYINT default '0',
  `mail_from` VARCHAR(128),
  `mail_cc` VARCHAR(255),
  `mail_bcc` VARCHAR(50),
  `mail_reply_to` VARCHAR(128),
  `mail_return_path` VARCHAR(128),
  `mailing_start` DATETIME,
  `mailing_end` DATETIME,
  `emails_total` INT(11) default '0',
  `emails_left` INT(11) default '0',
  `emails_sent` INT(11) default '0',
  `emails_opened` INT(11) default '0',
  `emails_clicked` INT(11) default '0',
  `emails_bounced` INT(11) default '0',
  `emails_unsubscribed` INT(11) default '0',
  `is_active` TINYINT default '0',
  `is_sent` TINYINT default '0',
  `is_prepared` TINYINT default '0',
  `users_recipients` TEXT,
  `admins_recipients` TEXT,
  `subscribed_recipients` TEXT,
  `orders_recipients` TEXT,
  `custom_recipients` TEXT,
  `added_by` INT(11) default '0',
  `added_date` DATETIME,
  `edited_by` INT(11) default '0',
  `edited_date` DATETIME,
  `template_active` TINYINT,
  `template_period` TINYINT,
  `template_interval` INT(11),
  `template_newsletters_limit` INT(11),
  `template_newsletters_added` VARCHAR(50),
  `template_start_date` DATETIME,
  `template_end_date` DATETIME,
  `template_next_date` DATETIME,
  `template_last_date` DATETIME,
  `template_filter_period` INT(11),
  `template_filter_interval` INT(11)
  ,KEY campaign_id (campaign_id)
  ,KEY newsletter_type (newsletter_type)
  ,PRIMARY KEY (newsletter_id)
  ,KEY template_active (template_active)
  ,KEY template_newsletter_id (template_newsletter_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_campaigns;
CREATE TABLE va_newsletters_campaigns (
  `campaign_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '0',
  `is_active` TINYINT default '1',
  `campaign_name` VARCHAR(255),
  `campaign_date_start` DATETIME,
  `campaign_date_end` DATETIME,
  `emails_sent` INT(11) default '0',
  `emails_opened` INT(11) default '0',
  `emails_clicked` INT(11) default '0',
  `emails_bounced` INT(11) default '0',
  `emails_unsubscribed` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,PRIMARY KEY (campaign_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_emails;
CREATE TABLE va_newsletters_emails (
  `email_id` INT(11) NOT NULL AUTO_INCREMENT,
  `newsletter_id` INT(11) default '0',
  `email_type` TINYINT default '0',
  `user_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `user_email` VARCHAR(128) NOT NULL,
  `user_name` VARCHAR(128),
  `is_custom` TINYINT default '0',
  `is_sent` TINYINT default '0',
  `is_opened` TINYINT default '0',
  `is_clicked` TINYINT default '0',
  `is_bounced` TINYINT default '0',
  `is_unsubscribed` TINYINT default '0',
  `is_ordered` TINYINT default '0'
  ,KEY admin_id (admin_id)
  ,KEY email_type (email_type)
  ,KEY newsletter_id (newsletter_id)
  ,KEY order_id (order_id)
  ,PRIMARY KEY (email_id)
  ,KEY user_email (user_email)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_groups;
CREATE TABLE va_newsletters_groups (
  `group_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_name` VARCHAR(255),
  `group_desc` TEXT,
  `show_for_user` TINYINT default '1',
  `is_default` TINYINT default '1',
  `is_hidden` TINYINT default '0',
  `sites_all` TINYINT default '1'
  ,PRIMARY KEY (group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_groups_sites;
CREATE TABLE va_newsletters_groups_sites (
  `group_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (group_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_users;
CREATE TABLE va_newsletters_users (
  `email_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `user_name` VARCHAR(128),
  `email` VARCHAR(128),
  `date_added` DATETIME,
  `date_updated` DATETIME
  ,KEY email (email)
  ,PRIMARY KEY (email_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_newsletters_users_groups;
CREATE TABLE va_newsletters_users_groups (
  `email_id` INT(11) NOT NULL default '0',
  `group_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (email_id,group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_order_custom_properties;
CREATE TABLE va_order_custom_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '1',
  `sites_all` TINYINT default '1',
  `payment_id` INT(11) default '0',
  `shipping_module_id` INT(11) default '0',
  `shipping_type_id` INT(11) default '0',
  `property_order` INT(11) default '0',
  `property_code` VARCHAR(64),
  `property_name` VARCHAR(255),
  `property_description` TEXT,
  `default_value` TEXT,
  `property_class` VARCHAR(64),
  `property_style` VARCHAR(255),
  `property_type` INT(11) default '0',
  `property_show` INT(11) default '0',
  `tax_free` TINYINT default '0',
  `control_type` VARCHAR(16),
  `control_style` VARCHAR(255),
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT,
  `required` TINYINT default '0',
  `before_name_html` TEXT,
  `after_name_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `validation_regexp` TEXT,
  `regexp_error` TEXT,
  `options_values_sql` TEXT
  ,KEY payment_id (payment_id)
  ,PRIMARY KEY (property_id)
  ,KEY shipping_module_id (shipping_module_id)
  ,KEY shipping_type_id (shipping_type_id)
  ,KEY site_id (site_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_order_custom_sites;
CREATE TABLE va_order_custom_sites (
  `property_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (property_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_order_custom_values;
CREATE TABLE va_order_custom_values (
  `property_value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `property_value` VARCHAR(255),
  `property_price` DOUBLE(16,2) default '0',
  `property_weight` DOUBLE(16,4) default '0',
  `hide_value` TINYINT default '0',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (property_value_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_order_statuses;
CREATE TABLE va_order_statuses (
  `status_id` INT(11) NOT NULL AUTO_INCREMENT,
  `status_order` INT(11) default '1',
  `status_name` VARCHAR(64) NOT NULL,
  `status_type` VARCHAR(16),
  `status_php_lib` VARCHAR(255),
  `admin_order_class` VARCHAR(64),
  `user_order_class` VARCHAR(64),
  `is_user_cancel` TINYINT default '0',
  `allow_user_cancel` TINYINT default '0',
  `generate_invoice` TINYINT default '0',
  `user_invoice_activation` TINYINT default '0',
  `is_dispatch` TINYINT default '0',
  `is_list` TINYINT default '1',
  `show_for_user` TINYINT default '0',
  `paid_status` TINYINT default '0',
  `credit_note_action` TINYINT default '1',
  `stock_level_action` INT(11) default '0',
  `points_action` INT(11) default '0',
  `credit_action` INT(11) default '0',
  `commission_action` INT(11) default '0',
  `download_activation` TINYINT default '0',
  `download_notify` TINYINT default '0',
  `item_notify` TINYINT default '0',
  `mail_notify` TINYINT default '0',
  `mail_to` VARCHAR(255),
  `mail_from` VARCHAR(64),
  `mail_cc` VARCHAR(255),
  `mail_bcc` VARCHAR(255),
  `mail_reply_to` VARCHAR(64),
  `mail_return_path` VARCHAR(64),
  `mail_type` INT(11) default '0',
  `mail_pdf_invoice` TINYINT default '0',
  `mail_subject` VARCHAR(255),
  `mail_body` TEXT,
  `sms_notify` TINYINT default '0',
  `sms_recipient` VARCHAR(255),
  `sms_originator` VARCHAR(64),
  `sms_message` TEXT,
  `merchant_notify` TINYINT default '0',
  `merchant_to` VARCHAR(255),
  `merchant_from` VARCHAR(64),
  `merchant_cc` VARCHAR(255),
  `merchant_bcc` VARCHAR(255),
  `merchant_reply_to` VARCHAR(64),
  `merchant_return_path` VARCHAR(64),
  `merchant_mail_type` TINYINT default '0',
  `merchant_subject` VARCHAR(255),
  `merchant_body` TEXT,
  `merchant_sms_notify` TINYINT default '0',
  `merchant_sms_recipient` VARCHAR(255),
  `merchant_sms_originator` VARCHAR(64),
  `merchant_sms_message` TEXT,
  `supplier_notify` TINYINT default '0',
  `supplier_to` VARCHAR(255),
  `supplier_from` VARCHAR(64),
  `supplier_cc` VARCHAR(255),
  `supplier_bcc` VARCHAR(255),
  `supplier_reply_to` VARCHAR(64),
  `supplier_return_path` VARCHAR(64),
  `supplier_mail_type` TINYINT default '0',
  `supplier_subject` VARCHAR(255),
  `supplier_body` TEXT,
  `supplier_sms_notify` TINYINT default '0',
  `supplier_sms_recipient` VARCHAR(255),
  `supplier_sms_originator` VARCHAR(64),
  `supplier_sms_message` TEXT,
  `affiliate_notify` TINYINT default '0',
  `affiliate_to` VARCHAR(255),
  `affiliate_from` VARCHAR(64),
  `affiliate_cc` VARCHAR(255),
  `affiliate_bcc` VARCHAR(255),
  `affiliate_reply_to` VARCHAR(64),
  `affiliate_return_path` VARCHAR(64),
  `affiliate_mail_type` TINYINT default '0',
  `affiliate_subject` VARCHAR(255),
  `affiliate_body` TEXT,
  `affiliate_sms_notify` TINYINT default '0',
  `affiliate_sms_recipient` VARCHAR(255),
  `affiliate_sms_originator` VARCHAR(64),
  `affiliate_sms_message` TEXT,
  `admin_notify` TINYINT default '0',
  `admin_to` VARCHAR(255),
  `admin_to_groups_ids` TEXT,
  `admin_from` VARCHAR(64),
  `admin_cc` VARCHAR(255),
  `admin_bcc` VARCHAR(255),
  `admin_reply_to` VARCHAR(64),
  `admin_return_path` VARCHAR(64),
  `admin_mail_type` TINYINT default '0',
  `admin_pdf_invoice` TINYINT default '0',
  `admin_subject` VARCHAR(255),
  `admin_body` TEXT,
  `admin_sms_notify` TINYINT default '0',
  `admin_sms_recipient` VARCHAR(255),
  `admin_sms_originator` VARCHAR(64),
  `admin_sms_message` TEXT,
  `final_title` VARCHAR(255),
  `final_message` TEXT,
  `is_active` TINYINT default '1',
  `view_order_groups_all` TINYINT default '1',
  `view_order_groups_ids` TEXT,
  `set_status_groups_all` TINYINT default '1',
  `set_status_groups_ids` TEXT,
  `update_order_groups_all` TINYINT default '1',
  `update_order_groups_ids` TEXT
  ,PRIMARY KEY (status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders;
CREATE TABLE va_orders (
  `order_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_order_id` INT(11) default '0',
  `invoice_number` VARCHAR(128),
  `invoice_copy_number` INT(11) default '0',
  `site_id` INT(11) default '1',
  `session_id` VARCHAR(32),
  `transaction_id` VARCHAR(128),
  `authorization_code` VARCHAR(128),
  `user_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) default '0',
  `newsletter_id` INT(11) default '0',
  `newsletter_email_id` INT(11) default '0',
  `payment_id` INT(11) default '0',
  `order_payment_id` INT(11) default '0',
  `payment_amount` DOUBLE(16,2),
  `success_message` VARCHAR(255),
  `pending_message` VARCHAR(50),
  `error_message` VARCHAR(255),
  `visit_id` INT(11) default '0',
  `remote_address` VARCHAR(32),
  `initial_ip` VARCHAR(32),
  `cookie_ip` VARCHAR(32),
  `affiliate_code` VARCHAR(64) NOT NULL,
  `affiliate_user_id` INT(11) default '0',
  `friend_code` VARCHAR(64),
  `friend_user_id` INT(11) default '0',
  `keywords` VARCHAR(255),
  `coupons_ids` TEXT,
  `vouchers_ids` TEXT,
  `default_currency_code` VARCHAR(4),
  `currency_code` VARCHAR(4),
  `currency_rate` DOUBLE(16,8) default '1',
  `payment_currency_code` VARCHAR(4),
  `payment_currency_rate` DOUBLE(16,8) default '1',
  `avs_response_code` VARCHAR(64),
  `avs_message` VARCHAR(255),
  `avs_address_match` VARCHAR(16),
  `avs_zip_match` VARCHAR(16),
  `cvv2_match` VARCHAR(16),
  `secure_3d_check` VARCHAR(16),
  `secure_3d_status` VARCHAR(128),
  `secure_3d_md` VARCHAR(255),
  `secure_3d_eci` VARCHAR(16),
  `secure_3d_cavv` VARCHAR(128),
  `secure_3d_xid` VARCHAR(128),
  `order_status` INT(11) NOT NULL default '1',
  `total_buying` DOUBLE(16,2) NOT NULL default '0',
  `total_buying_tax` DOUBLE(16,2) default '0',
  `total_points_amount` DOUBLE(16,4) default '0',
  `total_reward_points` DOUBLE(16,4) default '0',
  `total_reward_credits` DOUBLE(16,2) default '0',
  `total_merchants_commission` DOUBLE(16,2) default '0',
  `total_affiliate_commission` DOUBLE(16,2) default '0',
  `goods_total` DOUBLE(16,2) NOT NULL default '0',
  `goods_tax` DOUBLE(16,2) default '0',
  `goods_incl_tax` DOUBLE(16,2) NOT NULL default '0',
  `goods_points_amount` DOUBLE(16,4) default '0',
  `shipping_excl_tax` DOUBLE(16,2) default '0',
  `shipping_tax` DOUBLE(16,2) default '0',
  `shipping_incl_tax` DOUBLE(16,2) default '0',
  `shipping_points_cost` DOUBLE(16,4) default '0',
  `total_quantity` INT(11) NOT NULL default '0',
  `weight_total` DOUBLE(16,4) default '0',
  `total_discount` DOUBLE(16,2) default '0',
  `total_discount_tax` DOUBLE(16,2) default '0',
  `shipping_type_id` INT(11) default '0',
  `shipping_type_code` VARCHAR(64),
  `shipping_type_desc` VARCHAR(255),
  `shipping_cost` DOUBLE(16,2),
  `shipping_points_amount` DOUBLE(16,4) default '0',
  `shipping_taxable` INT(11) default '0',
  `shipping_tracking_id` VARCHAR(64),
  `shipping_expecting_date` DATETIME,
  `properties_total` DOUBLE(16,2) default '0',
  `properties_points_amount` DOUBLE(16,4) default '0',
  `properties_taxable` DOUBLE(16,2) default '0',
  `processing_fee` DOUBLE(16,2) default '0',
  `processing_tax_free` TINYINT default '0',
  `processing_excl_tax` DOUBLE(16,2) default '0',
  `processing_tax` DOUBLE(16,2) default '0',
  `processing_incl_tax` DOUBLE(16,2) default '0',
  `tax_name` VARCHAR(255),
  `tax_percent` DOUBLE(16,3),
  `tax_total` DOUBLE(16,2) default '0',
  `tax_prices_type` TINYINT default '0',
  `tax_round_type` TINYINT default '1',
  `vouchers_amount` DOUBLE(16,2) default '0',
  `credit_amount` DOUBLE(16,2) default '0',
  `order_total` DOUBLE(16,2) NOT NULL default '0',
  `paid_total` DOUBLE(16,2) default '0',
  `name` VARCHAR(128) NOT NULL,
  `first_name` VARCHAR(64) NOT NULL,
  `last_name` VARCHAR(64) NOT NULL,
  `company_id` INT(11) default '0',
  `company_name` VARCHAR(128),
  `email` VARCHAR(128) NOT NULL,
  `address1` VARCHAR(255),
  `address2` VARCHAR(255),
  `city` VARCHAR(128),
  `province` VARCHAR(128),
  `state_id` INT(11) default '0',
  `state_code` VARCHAR(8),
  `zip` VARCHAR(16),
  `country_id` INT(11) default '0',
  `country_code` VARCHAR(8),
  `phone` VARCHAR(32),
  `daytime_phone` VARCHAR(32),
  `evening_phone` VARCHAR(32),
  `cell_phone` VARCHAR(32),
  `fax` VARCHAR(32),
  `delivery_name` VARCHAR(128),
  `delivery_first_name` VARCHAR(64),
  `delivery_last_name` VARCHAR(64),
  `delivery_company_id` INT(11) default '0',
  `delivery_company_name` VARCHAR(128),
  `delivery_email` VARCHAR(128),
  `delivery_address1` VARCHAR(255),
  `delivery_address2` VARCHAR(255),
  `delivery_city` VARCHAR(128),
  `delivery_province` VARCHAR(128),
  `delivery_state_id` INT(11) default '0',
  `delivery_state_code` VARCHAR(8),
  `delivery_zip` VARCHAR(16),
  `delivery_country_id` INT(11) default '0',
  `delivery_country_code` VARCHAR(8),
  `delivery_phone` VARCHAR(32),
  `delivery_daytime_phone` VARCHAR(32),
  `delivery_evening_phone` VARCHAR(32),
  `delivery_cell_phone` VARCHAR(32),
  `delivery_fax` VARCHAR(32),
  `bill_encrypt_type` TINYINT default '1',
  `bill_name` VARCHAR(128),
  `bill_first_name` VARCHAR(64),
  `bill_last_name` VARCHAR(64),
  `bill_company_id` VARCHAR(32),
  `bill_company_name` VARCHAR(128),
  `bill_email` VARCHAR(128),
  `bill_address1` VARCHAR(255),
  `bill_address2` VARCHAR(255),
  `bill_city` VARCHAR(128),
  `bill_province` VARCHAR(128),
  `bill_state_id` VARCHAR(32),
  `bill_zip` VARCHAR(16),
  `bill_country_id` VARCHAR(32),
  `bill_phone` VARCHAR(32),
  `bill_daytime_phone` VARCHAR(32),
  `bill_evening_phone` VARCHAR(32),
  `bill_cell_phone` VARCHAR(32),
  `bill_fax` VARCHAR(32),
  `bill_cc_number` VARCHAR(64),
  `bill_cc_start_date` VARCHAR(32),
  `bill_cc_expiry_date` VARCHAR(32),
  `bill_cc_type` VARCHAR(32),
  `bill_cc_issue_number` VARCHAR(16),
  `bill_cc_cvv2` VARCHAR(16),
  `cc_encrypt_type` TINYINT default '1',
  `cc_name` VARCHAR(90),
  `cc_first_name` VARCHAR(64),
  `cc_last_name` VARCHAR(64),
  `cc_number` VARCHAR(32),
  `cc_start_date` DATETIME,
  `cc_expiry_date` DATETIME,
  `cc_type` INT(11),
  `cc_issue_number` INT(11),
  `cc_security_code` VARCHAR(32),
  `pay_without_cc` TEXT,
  `order_placed_date` DATETIME NOT NULL,
  `order_paid_date` DATETIME,
  `modified_date` DATETIME,
  `is_fast_checkout` TINYINT default '0',
  `is_confirmed` TINYINT default '0',
  `is_placed` TINYINT default '0',
  `is_paid` TINYINT default '0',
  `is_exported` TINYINT default '0',
  `is_call_center` TINYINT default '0',
  `is_recurring` TINYINT default '0',
  `is_unsubscribed` TINYINT default '0',
  `is_reminder_send` TINYINT default '0',
  `reminder_send_date` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_modified` DATETIME
  ,KEY affiliate_code (affiliate_code)
  ,KEY affiliate_user_id (affiliate_user_id)
  ,KEY country_id (country_id)
  ,KEY currency_code (currency_code)
  ,KEY delivery_country_id (delivery_country_id)
  ,KEY delivery_state_id (delivery_state_id)
  ,KEY email (email)
  ,KEY first_name (first_name)
  ,KEY friend_id (friend_code)
  ,KEY friend_user_id (friend_user_id)
  ,KEY goods_total (goods_total)
  ,KEY invoice_number (invoice_number)
  ,KEY is_paid (is_paid)
  ,KEY keywords (keywords)
  ,KEY last_name (last_name)
  ,KEY name (name)
  ,KEY newsletter_id (newsletter_id)
  ,KEY order_paid_date (order_paid_date)
  ,KEY order_placed_date (order_placed_date)
  ,KEY order_status (order_status)
  ,KEY parent_order_id (parent_order_id)
  ,KEY payment_id (payment_id)
  ,PRIMARY KEY (order_id)
  ,KEY session_id (session_id)
  ,KEY shipping_tracking_id (shipping_tracking_id)
  ,KEY shipping_type_id (shipping_type_id)
  ,KEY site_id (site_id)
  ,KEY state_id (state_id)
  ,KEY total_buying (total_buying)
  ,KEY user_id (user_id)
  ,KEY user_type_id (user_type_id)
  ,KEY visit_id (visit_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_coupons;
CREATE TABLE va_orders_coupons (
  `order_coupon_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `coupon_id` INT(11) default '0',
  `coupon_code` VARCHAR(64),
  `coupon_title` VARCHAR(255),
  `discount_type` TINYINT default '0',
  `discount_amount` DOUBLE(16,2) default '0',
  `discount_tax_amount` DOUBLE(16,2) default '0'
  ,KEY coupon_id (coupon_id)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (order_coupon_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_events;
CREATE TABLE va_orders_events (
  `event_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `status_id` INT(11) default '0',
  `order_items` TEXT,
  `event_date` DATETIME,
  `event_type` VARCHAR(32),
  `event_name` VARCHAR(255),
  `event_description` TEXT
  ,KEY admin_id (admin_id)
  ,KEY order_id (order_id)
  ,PRIMARY KEY (event_id)
  ,KEY status_id (status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_items;
CREATE TABLE va_orders_items (
  `order_item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_order_item_id` INT(11) default '0',
  `top_order_item_id` INT(11) default '0',
  `order_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) default '1',
  `user_id` INT(11) default '0',
  `user_type_id` INT(11) default '0',
  `item_id` INT(11) NOT NULL default '0',
  `subscription_id` INT(11) default '0',
  `cart_item_id` INT(11) default '0',
  `item_user_id` INT(11) default '0',
  `affiliate_user_id` INT(11) default '0',
  `friend_user_id` INT(11) default '0',
  `parent_item_id` INT(11) default '0',
  `item_type_id` INT(11) NOT NULL default '0',
  `item_code` VARCHAR(64),
  `manufacturer_code` VARCHAR(255),
  `supplier_id` INT(11) default '0',
  `coupons_ids` TEXT,
  `item_status` INT(11) NOT NULL default '1',
  `component_order` INT(11) default '1',
  `component_name` VARCHAR(255),
  `item_name` VARCHAR(255) NOT NULL,
  `item_properties` TEXT,
  `buying_price` DOUBLE(16,2) default '0',
  `real_price` DOUBLE(16,2) default '0',
  `discount_amount` DOUBLE(16,2) default '0',
  `points_price` DOUBLE(16,4) default '0',
  `reward_points` DOUBLE(16,4) default '0',
  `reward_credits` DOUBLE(16,4) default '0',
  `affiliate_commission` DOUBLE(16,4) default '0',
  `merchant_commission` DOUBLE(16,4) default '0',
  `price` DOUBLE(16,2) NOT NULL default '0',
  `tax_id` INT(11) default '0',
  `tax_free` INT(11) default '0',
  `tax_percent` DOUBLE(16,3),
  `width` DOUBLE(16,4) default '0',
  `height` DOUBLE(16,4) default '0',
  `length` DOUBLE(16,4) default '0',
  `weight` DOUBLE(16,4) default '0',
  `packages_number` DOUBLE(16,4),
  `quantity` INT(11),
  `downloadable` INT(11) default '0',
  `is_shipping_free` TINYINT default '0',
  `shipping_cost` DOUBLE(16,2) default '0',
  `order_shipping_id` INT(11) default '0',
  `is_recurring` TINYINT default '0',
  `recurring_price` DOUBLE(16,2),
  `recurring_period` INT(11),
  `recurring_interval` INT(11),
  `recurring_payments_total` INT(11),
  `recurring_payments_made` INT(11),
  `recurring_payments_failed` INT(11),
  `recurring_end_date` DATETIME,
  `recurring_last_payment` DATETIME,
  `recurring_next_payment` DATETIME,
  `recurring_plan_payment` DATETIME,
  `is_subscription` TINYINT default '0',
  `is_account_subscription` TINYINT default '0',
  `subscription_period` INT(11),
  `subscription_interval` INT(11),
  `subscription_suspend` INT(11),
  `subscription_start_date` DATETIME,
  `subscription_expiry_date` DATETIME
  ,KEY affiliate_user_id (affiliate_user_id)
  ,KEY friend_user_id (friend_user_id)
  ,KEY is_subscription (is_subscription)
  ,KEY item_code (item_code)
  ,KEY item_id (item_id)
  ,KEY item_status (item_status)
  ,KEY item_type (item_type_id)
  ,KEY item_user_id (item_user_id)
  ,KEY order_id (order_id)
  ,KEY order_shipping_id (order_shipping_id)
  ,KEY parent_item_id (parent_item_id)
  ,KEY parent_order_item_id (parent_order_item_id)
  ,KEY price (price)
  ,PRIMARY KEY (order_item_id)
  ,KEY site_id (site_id)
  ,KEY subscription_expiry_date (subscription_expiry_date)
  ,KEY subscription_id (user_type_id)
  ,KEY subscription_id1 (subscription_id)
  ,KEY supplier_id (supplier_id)
  ,KEY top_order_item_id (top_order_item_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_items_properties;
CREATE TABLE va_orders_items_properties (
  `item_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) NOT NULL default '0',
  `order_item_id` INT(11) NOT NULL default '0',
  `property_id` INT(11) NOT NULL default '0',
  `property_values_ids` TEXT,
  `property_order` INT(11) default '1',
  `property_name` VARCHAR(255) NOT NULL,
  `hide_name` TINYINT default '0',
  `length_units` VARCHAR(8),
  `property_value` TEXT,
  `additional_price` DOUBLE(16,2) default '0',
  `additional_weight` DOUBLE(16,4) default '0'
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (item_property_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_items_serials;
CREATE TABLE va_orders_items_serials (
  `serial_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `item_id` INT(11) default '0',
  `serial_number` VARCHAR(128),
  `activated` TINYINT default '0',
  `activations_number` INT(11) default '0',
  `serial_added` DATETIME,
  `serial_expiry` DATETIME
  ,KEY item_id (item_id)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (serial_id)
  ,KEY serial_number (serial_number)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_items_taxes;
CREATE TABLE va_orders_items_taxes (
  `tax_item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_tax_id` INT(11) default '0',
  `item_type_id` INT(11) default '0',
  `tax_percent` DOUBLE(16,3),
  `fixed_amount` DOUBLE(16,2)
  ,KEY item_type_id (item_type_id)
  ,KEY order_tax_id (order_tax_id)
  ,PRIMARY KEY (tax_item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_notes;
CREATE TABLE va_orders_notes (
  `note_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `note_title` VARCHAR(255),
  `note_details` TEXT,
  `show_for_user` TINYINT default '0',
  `date_added` DATETIME,
  `date_updated` DATETIME
  ,KEY order_id (order_id)
  ,PRIMARY KEY (note_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_payments;
CREATE TABLE va_orders_payments (
  `order_payment_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `payment_id` INT(11) default '0',
  `payment_index` INT(11) default '1',
  `payment_amount` DOUBLE(16,2) default '0',
  `transaction_id` VARCHAR(128),
  `success_message` VARCHAR(255),
  `pending_message` VARCHAR(255),
  `error_message` VARCHAR(255),
  `remote_ip` VARCHAR(32),
  `payment_currency_code` VARCHAR(4),
  `payment_currency_rate` DOUBLE(16,8) default '1',
  `payment_status` INT(11) default '0',
  `payment_paid` TINYINT default '0'
  ,KEY order_id (order_id)
  ,KEY payment_id (payment_id)
  ,PRIMARY KEY (order_payment_id)
  ,KEY transaction_id (transaction_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_properties;
CREATE TABLE va_orders_properties (
  `order_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_order` INT(11) default '1',
  `property_type` INT(11) default '0',
  `property_name` VARCHAR(255) NOT NULL,
  `property_value_id` INT(11),
  `property_value` TEXT,
  `property_price` DOUBLE(16,2) default '0',
  `property_points_amount` DOUBLE(16,4) default '0',
  `property_weight` DOUBLE(16,4) default '0',
  `tax_free` TINYINT default '0'
  ,KEY order_id (order_id)
  ,PRIMARY KEY (order_property_id)
  ,KEY property_id (property_id)
  ,KEY property_name (property_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_serials_activations;
CREATE TABLE va_orders_serials_activations (
  `activation_id` INT(11) NOT NULL AUTO_INCREMENT,
  `serial_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `remote_address` VARCHAR(32),
  `generation_key` VARCHAR(255),
  `activation_key` TEXT,
  `date_added` DATETIME
  ,KEY order_id (order_id)
  ,PRIMARY KEY (activation_id)
  ,KEY serial_id (serial_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_shipments;
CREATE TABLE va_orders_shipments (
  `order_shipping_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) NOT NULL default '0',
  `shipping_id` INT(11) NOT NULL default '0',
  `shipping_code` VARCHAR(64),
  `shipping_desc` VARCHAR(255),
  `shipping_cost` DOUBLE(16,2) default '0',
  `points_cost` DOUBLE(16,4) default '0',
  `tax_free` TINYINT default '0',
  `tracking_id` VARCHAR(64),
  `expecting_date` DATETIME,
  `goods_weight` DOUBLE(16,4) default '0',
  `tare_weight` DOUBLE(16,4) default '0',
  `order_items_ids` TEXT
  ,KEY order_id (order_id)
  ,PRIMARY KEY (order_shipping_id)
  ,KEY shipping_type_id (shipping_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_orders_taxes;
CREATE TABLE va_orders_taxes (
  `order_tax_id` INT(11) NOT NULL AUTO_INCREMENT,
  `order_id` INT(11) default '0',
  `tax_id` INT(11) default '0',
  `tax_type` TINYINT default '1',
  `show_type` TINYINT default '0',
  `tax_name` VARCHAR(50),
  `tax_percent` DOUBLE(16,3) default '0',
  `fixed_amount` DOUBLE(16,2),
  `shipping_tax_percent` DOUBLE(16,3),
  `shipping_fixed_amount` DOUBLE(16,2)
  ,KEY order_id (order_id)
  ,PRIMARY KEY (order_tax_id)
  ,KEY tax_id (tax_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_pages;
CREATE TABLE va_pages (
  `page_id` INT(11) NOT NULL AUTO_INCREMENT,
  `page_code` VARCHAR(16) NOT NULL,
  `page_title` VARCHAR(255) NOT NULL,
  `friendly_url` VARCHAR(255),
  `page_url` VARCHAR(255),
  `page_order` INT(11) NOT NULL default '1',
  `is_site_map` TINYINT default '1',
  `sites_all` TINYINT default '1',
  `user_types_all` TINYINT default '1',
  `is_showing` TINYINT NOT NULL default '1',
  `link_in_footer` TINYINT NOT NULL default '0',
  `is_html` TINYINT,
  `page_type` INT(11),
  `page_path` VARCHAR(255),
  `page_body` TEXT,
  `meta_title` VARCHAR(255),
  `meta_keywords` VARCHAR(255),
  `meta_description` VARCHAR(255)
  ,KEY friendly_url (friendly_url)
  ,KEY is_showing (is_showing)
  ,KEY is_site_map (is_site_map)
  ,KEY link_in_footer (link_in_footer)
  ,KEY page_code (page_code)
  ,PRIMARY KEY (page_id)
  ,KEY sites_all (sites_all)
  ,KEY user_types_all (user_types_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_pages_sites;
CREATE TABLE va_pages_sites (
  `page_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (page_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_pages_user_types;
CREATE TABLE va_pages_user_types (
  `page_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (page_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_countries;
CREATE TABLE va_payment_countries (
  `payment_id` INT(11),
  `country_id` INT(11)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_currencies;
CREATE TABLE va_payment_currencies (
  `payment_id` INT(11) NOT NULL default '0',
  `currency_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (payment_id,currency_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_item_types;
CREATE TABLE va_payment_item_types (
  `payment_id` INT(11) NOT NULL default '0',
  `item_type_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (payment_id,item_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_parameters;
CREATE TABLE va_payment_parameters (
  `parameter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `payment_id` INT(11) NOT NULL default '0',
  `parameter_name` VARCHAR(255) NOT NULL,
  `parameter_type` VARCHAR(16) NOT NULL,
  `parameter_source` TEXT,
  `not_passed` TINYINT default '0'
  ,PRIMARY KEY (parameter_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_systems;
CREATE TABLE va_payment_systems (
  `payment_id` INT(11) NOT NULL AUTO_INCREMENT,
  `payment_order` INT(11) default '1',
  `payment_name` VARCHAR(255) NOT NULL,
  `user_payment_name` VARCHAR(255),
  `payment_info` TEXT,
  `payment_notes` TEXT,
  `payment_type` VARCHAR(32),
  `payment_code` VARCHAR(64),
  `payment_php_lib` VARCHAR(255),
  `validation_php_lib` VARCHAR(255),
  `payment_url` VARCHAR(255) NOT NULL,
  `processing_time` INT(11) default '0',
  `processing_fee` DOUBLE(16,2),
  `processing_tax_free` TINYINT default '0',
  `fee_type` INT(11) default '0',
  `fee_min_goods` DOUBLE(16,2),
  `fee_max_goods` DOUBLE(16,2),
  `submit_method` VARCHAR(4),
  `recurring_method` INT(11) default '0',
  `is_advanced` TINYINT default '0',
  `advanced_url` VARCHAR(255),
  `advanced_php_lib` VARCHAR(255),
  `capture_php_lib` VARCHAR(255),
  `refund_php_lib` VARCHAR(255),
  `void_php_lib` VARCHAR(255),
  `success_status_id` INT(11),
  `pending_status_id` INT(11),
  `failure_status_id` INT(11),
  `failure_action` INT(11) default '0',
  `is_active` TINYINT default '0',
  `is_default` TINYINT default '0',
  `is_call_center` TINYINT default '0',
  `allowed_user_edit` TINYINT default '0',
  `sites_all` TINYINT default '1',
  `non_logged_users` TINYINT default '1',
  `user_types_all` TINYINT default '1',
  `item_types_all` TINYINT default '1',
  `currencies_all` TINYINT default '1',
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255),
  `fast_checkout_active` TINYINT default '0',
  `fast_checkout_image` VARCHAR(255),
  `fast_checkout_width` INT(11),
  `fast_checkout_height` INT(11),
  `fast_checkout_alt` VARCHAR(255),
  `order_total_min` DOUBLE(16,2) default '0',
  `order_total_max` DOUBLE(16,2) default '0',
  `countries_all` INT(11) default '1'
  ,PRIMARY KEY (payment_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_systems_sites;
CREATE TABLE va_payment_systems_sites (
  `payment_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (payment_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_payment_user_types;
CREATE TABLE va_payment_user_types (
  `payment_id` INT(11) default '0',
  `user_type_id` INT(11) default '0'
  ,KEY payment_id (payment_id)
  ,KEY user_type_id (user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_polls;
CREATE TABLE va_polls (
  `poll_id` INT(11) NOT NULL AUTO_INCREMENT,
  `poll_type` INT(11) NOT NULL default '1',
  `question` TEXT NOT NULL,
  `is_active` TINYINT NOT NULL default '0',
  `date_added` DATETIME NOT NULL,
  `total_votes` INT(11) default '0'
  ,PRIMARY KEY (poll_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_polls_options;
CREATE TABLE va_polls_options (
  `poll_option_id` INT(11) NOT NULL AUTO_INCREMENT,
  `poll_id` INT(11) NOT NULL default '0',
  `option_description` TEXT NOT NULL,
  `is_default_value` TINYINT default '0'
  ,KEY poll_id (poll_id)
  ,PRIMARY KEY (poll_option_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_polls_votes;
CREATE TABLE va_polls_votes (
  `poll_id` INT(11) NOT NULL default '0',
  `poll_option_id` INT(11) NOT NULL default '0',
  `remote_address` VARCHAR(32) NOT NULL,
  `date_added` DATETIME NOT NULL
  ,KEY poll_id (poll_id)
  ,KEY poll_option_id (poll_option_id)
  ,KEY remote_address (remote_address)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_prices;
CREATE TABLE va_prices (
  `price_id` INT(11) NOT NULL AUTO_INCREMENT,
  `price_title` VARCHAR(64),
  `price_amount` DOUBLE(16,2) default '0',
  `price_description` TEXT
  ,PRIMARY KEY (price_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_profiles;
CREATE TABLE va_profiles (
  `profile_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `is_shown` TINYINT default '1',
  `is_approved` TINYINT default '1',
  `profile_type_id` INT(11) default '0',
  `looking_type_id` INT(11) default '0',
  `profile_name` VARCHAR(128),
  `birth_year` SMALLINT default '0',
  `birth_month` TINYINT,
  `birth_day` TINYINT,
  `birth_date` DATETIME,
  `country_id` INT(11) default '0',
  `state_id` INT(11) default '0',
  `postal_code` VARCHAR(16),
  `city` VARCHAR(128),
  `photo_id` INT(11) default '0',
  `ethnicity_id` INT(11) default '0',
  `height` SMALLINT default '0',
  `weight` INT(11) default '0',
  `profile_info` TEXT,
  `looking_info` TEXT,
  `date_added` DATETIME,
  `date_updated` DATETIME,
  `date_last_visit` DATETIME
  ,KEY is_approved (is_approved)
  ,KEY is_shown (is_shown)
  ,KEY looking_type_id (looking_type_id)
  ,KEY photo_id (photo_id)
  ,PRIMARY KEY (profile_id)
  ,KEY profile_type_id (profile_type_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_profiles_types;
CREATE TABLE va_profiles_types (
  `profile_type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `profile_type_name` VARCHAR(255),
  `show_for_user` TINYINT default '1',
  `is_profile_default` TINYINT default '0',
  `is_looking_default` TINYINT default '0'
  ,PRIMARY KEY (profile_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_quotes;
CREATE TABLE va_quotes (
  `quote_id` INT(11) NOT NULL AUTO_INCREMENT,
  `support_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `user_name` VARCHAR(255),
  `user_email` VARCHAR(255),
  `quote_price` DOUBLE(16,2) default '0',
  `quote_status_id` INT(11) default '0',
  `is_paid` TINYINT default '0',
  `minutes_spent` INT(11) default '0',
  `date_due` DATETIME,
  `summary` VARCHAR(255),
  `description` TEXT,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY is_paid (is_paid)
  ,PRIMARY KEY (quote_id)
  ,KEY quote_status_id (quote_status_id)
  ,KEY support_id (support_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_quotes_events;
CREATE TABLE va_quotes_events (
  `event_id` INT(11) NOT NULL AUTO_INCREMENT,
  `quote_id` INT(11) default '0',
  `feature_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `status_id_old` INT(11) default '0',
  `status_id_new` INT(11) default '0',
  `event_date` DATETIME,
  `event_name` VARCHAR(255),
  `event_description` TEXT
  ,KEY admin_id (admin_id)
  ,KEY feature_id (feature_id)
  ,PRIMARY KEY (event_id)
  ,KEY quote_id (quote_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_quotes_features;
CREATE TABLE va_quotes_features (
  `feature_id` INT(11) NOT NULL AUTO_INCREMENT,
  `quote_id` INT(11) default '0',
  `feature_description` TEXT,
  `feature_price` DOUBLE(16,2) default '0',
  `feature_status_id` INT(11) default '0',
  `feature_paid` INT(11) default '0',
  `minutes_spent` INT(11) default '0',
  `date_due` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY feature_paid (feature_paid)
  ,KEY feature_status_id (feature_status_id)
  ,PRIMARY KEY (feature_id)
  ,KEY quote_id (quote_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_quotes_orders;
CREATE TABLE va_quotes_orders (
  `quote_order_id` INT(11) NOT NULL AUTO_INCREMENT,
  `quote_id` INT(11) default '0',
  `feature_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0'
  ,KEY feature_id (feature_id)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (quote_order_id)
  ,KEY quote_id (quote_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_quotes_statuses;
CREATE TABLE va_quotes_statuses (
  `status_id` INT(11) NOT NULL AUTO_INCREMENT,
  `status_name` VARCHAR(255),
  `status_icon` VARCHAR(255),
  `html_start` VARCHAR(255),
  `html_end` VARCHAR(255),
  `notes` TEXT
  ,PRIMARY KEY (status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_categories;
CREATE TABLE va_registration_categories (
  `category_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_category_id` INT(11) default '0',
  `category_order` INT(11) default '1',
  `category_path` VARCHAR(255),
  `category_name` VARCHAR(255),
  `show_for_user` TINYINT NOT NULL default '1',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY category_order (category_order)
  ,KEY category_path (category_path)
  ,KEY parent_category_id (parent_category_id)
  ,PRIMARY KEY (category_id)
  ,KEY show_for_user (show_for_user)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_custom_properties;
CREATE TABLE va_registration_custom_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '1',
  `property_order` INT(11) default '0',
  `property_name` VARCHAR(255),
  `property_description` TEXT,
  `default_value` TEXT,
  `property_class` VARCHAR(64),
  `property_style` VARCHAR(255),
  `section_id` INT(11) default '0',
  `property_show` TINYINT default '0',
  `control_type` VARCHAR(16),
  `control_style` VARCHAR(255),
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT,
  `required` TINYINT default '0',
  `before_name_html` TEXT,
  `after_name_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `validation_regexp` TEXT,
  `regexp_error` TEXT,
  `options_values_sql` TEXT
  ,KEY payment_id (site_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_custom_values;
CREATE TABLE va_registration_custom_values (
  `property_value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `property_value` VARCHAR(255),
  `hide_value` TINYINT default '0',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (property_value_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_items;
CREATE TABLE va_registration_items (
  `item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_code` VARCHAR(64),
  `item_name` VARCHAR(255),
  `item_order` INT(11) default '1',
  `show_for_user` TINYINT default '1',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY item_code (item_code)
  ,KEY item_order (item_order)
  ,PRIMARY KEY (item_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_items_assigned;
CREATE TABLE va_registration_items_assigned (
  `item_id` INT(11) NOT NULL default '0',
  `category_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (item_id,category_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_list;
CREATE TABLE va_registration_list (
  `registration_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `is_approved` TINYINT default '0',
  `category_id` INT(11) default '0',
  `item_id` INT(11) default '0',
  `item_code` VARCHAR(64),
  `item_name` VARCHAR(255),
  `serial_number` VARCHAR(128),
  `invoice_number` VARCHAR(128),
  `store_name` VARCHAR(128),
  `purchased_day` TINYINT default '0',
  `purchased_month` TINYINT default '0',
  `purchased_year` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY category_id (category_id)
  ,KEY invoice_number (invoice_number)
  ,KEY item_code (item_code)
  ,KEY item_id (item_id)
  ,PRIMARY KEY (registration_id)
  ,KEY purchased_day (purchased_day)
  ,KEY purchased_month (purchased_month)
  ,KEY purchased_year (purchased_year)
  ,KEY serial_number (serial_number)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_registration_properties;
CREATE TABLE va_registration_properties (
  `registration_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `registration_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_value` TEXT
  ,PRIMARY KEY (registration_property_id)
  ,KEY property_id (property_id)
  ,KEY support_id (registration_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_release_changes;
CREATE TABLE va_release_changes (
  `change_id` INT(11) NOT NULL AUTO_INCREMENT,
  `release_id` INT(11) NOT NULL default '0',
  `change_type_id` INT(11) NOT NULL default '0',
  `change_date` DATETIME NOT NULL,
  `change_desc` TEXT,
  `is_showing` TINYINT NOT NULL default '1'
  ,PRIMARY KEY (change_id)
  ,KEY release_id (release_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_release_types;
CREATE TABLE va_release_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(255) NOT NULL
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_releases;
CREATE TABLE va_releases (
  `release_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) NOT NULL default '0',
  `release_type_id` INT(11) NOT NULL default '0',
  `release_date` DATETIME NOT NULL,
  `release_title` VARCHAR(255) NOT NULL,
  `version` VARCHAR(32),
  `release_desc` TEXT,
  `download_type` INT(11) NOT NULL default '0',
  `path_to_file` VARCHAR(255),
  `is_showing` TINYINT NOT NULL default '1',
  `show_on_index` TINYINT NOT NULL default '0'
  ,KEY item_id (item_id)
  ,PRIMARY KEY (release_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_reminders;
CREATE TABLE va_reminders (
  `reminder_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `start_date` DATETIME,
  `end_date` DATETIME,
  `reminder_year` INT(11) default '0',
  `reminder_month` TINYINT default '0',
  `reminder_day` TINYINT default '0',
  `reminder_weekdays` TINYINT default '0',
  `reminder_title` VARCHAR(255),
  `reminder_notes` TEXT,
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `date_sent` DATETIME
  ,KEY end_date (end_date)
  ,PRIMARY KEY (reminder_id)
  ,KEY reminder_day (reminder_day)
  ,KEY reminder_month (reminder_month)
  ,KEY reminder_weekdays (reminder_weekdays)
  ,KEY reminder_year (reminder_year)
  ,KEY start_date (start_date)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_reviews;
CREATE TABLE va_reviews (
  `review_id` INT(11) NOT NULL AUTO_INCREMENT,
  `item_id` INT(11) NOT NULL default '0',
  `user_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `recommended` TINYINT NOT NULL default '0',
  `approved` TINYINT NOT NULL default '0',
  `rating` INT(11) default '0',
  `summary` VARCHAR(255),
  `user_name` VARCHAR(64),
  `user_email` VARCHAR(128),
  `remote_address` VARCHAR(32) NOT NULL,
  `comments` TEXT,
  `admin_id_approved_by` INT(11),
  `admin_id_modified_by` INT(11),
  `date_added` DATETIME NOT NULL,
  `date_modified` DATETIME,
  `date_approved` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY approved (approved)
  ,KEY item_id (item_id)
  ,PRIMARY KEY (review_id)
  ,KEY recommended (recommended)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_saved_carts;
CREATE TABLE va_saved_carts (
  `cart_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '1',
  `user_id` INT(11) default '0',
  `cart_name` VARCHAR(255),
  `cart_total` DOUBLE(16,2) default '0',
  `cart_added` DATETIME
  ,PRIMARY KEY (cart_id)
  ,KEY site_id (site_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_saved_items;
CREATE TABLE va_saved_items (
  `cart_item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '1',
  `item_id` INT(11) NOT NULL default '0',
  `cart_id` INT(11) NOT NULL default '0',
  `user_id` INT(11) NOT NULL default '0',
  `type_id` INT(11) NOT NULL default '0',
  `item_name` VARCHAR(255),
  `quantity` INT(11) default '0',
  `quantity_bought` INT(11) default '0',
  `price` DOUBLE(16,2) default '0',
  `date_added` DATETIME
  ,KEY cart_id (cart_id)
  ,KEY item_id (item_id)
  ,PRIMARY KEY (cart_item_id)
  ,KEY site_id (site_id)
  ,KEY type_id (type_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_saved_items_properties;
CREATE TABLE va_saved_items_properties (
  `item_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `cart_item_id` INT(11) default '0',
  `cart_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_value` TEXT,
  `property_values_ids` TEXT
  ,KEY bakset_id (cart_item_id)
  ,KEY bakset_id1 (cart_id)
  ,PRIMARY KEY (item_property_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_saved_types;
CREATE TABLE va_saved_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(64),
  `type_desc` TEXT,
  `is_active` TINYINT default '1',
  `allowed_search` TINYINT default '0'
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_search_engines;
CREATE TABLE va_search_engines (
  `engine_id` INT(11) NOT NULL AUTO_INCREMENT,
  `engine_name` VARCHAR(64),
  `keywords_parameter` VARCHAR(32),
  `referer_regexp` TEXT,
  `user_agent_regexp` TEXT,
  `ip_regexp` TEXT
  ,PRIMARY KEY (engine_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_modules;
CREATE TABLE va_shipping_modules (
  `shipping_module_id` INT(11) NOT NULL AUTO_INCREMENT,
  `shipping_module_name` VARCHAR(255),
  `user_module_name` VARCHAR(255),
  `module_notes` TEXT,
  `admin_order_class` VARCHAR(64),
  `user_order_class` VARCHAR(64),
  `is_external` TINYINT default '1',
  `php_external_lib` VARCHAR(255),
  `external_url` VARCHAR(255),
  `tracking_url` VARCHAR(255),
  `is_active` TINYINT default '1',
  `is_default` TINYINT default '1',
  `is_call_center` TINYINT default '1',
  `cost_add_percent` DOUBLE(16,2) default '0'
  ,PRIMARY KEY (shipping_module_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_modules_parameters;
CREATE TABLE va_shipping_modules_parameters (
  `parameter_id` INT(11) NOT NULL AUTO_INCREMENT,
  `shipping_module_id` INT(11) default '0',
  `parameter_name` VARCHAR(255),
  `parameter_source` TEXT,
  `not_passed` TINYINT default '0'
  ,PRIMARY KEY (parameter_id)
  ,KEY shipping_module_id (shipping_module_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_rules;
CREATE TABLE va_shipping_rules (
  `shipping_rule_id` INT(11) NOT NULL AUTO_INCREMENT,
  `shipping_rule_desc` VARCHAR(255) NOT NULL,
  `is_country_restriction` TINYINT default '0'
  ,PRIMARY KEY (shipping_rule_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_rules_countries;
CREATE TABLE va_shipping_rules_countries (
  `shipping_rule_id` INT(11) NOT NULL default '0',
  `country_id` INT(11) NOT NULL default '0'
  ,KEY country_id (country_id)
  ,KEY shipping_rule_id (shipping_rule_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_times;
CREATE TABLE va_shipping_times (
  `shipping_time_id` INT(11) NOT NULL AUTO_INCREMENT,
  `shipping_time_desc` VARCHAR(255) NOT NULL,
  `availability_time` INT(11) default '0'
  ,PRIMARY KEY (shipping_time_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_types;
CREATE TABLE va_shipping_types (
  `shipping_type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `shipping_module_id` INT(11) default '0',
  `shipping_order` INT(11) default '1',
  `shipping_type_code` VARCHAR(128),
  `shipping_type_desc` VARCHAR(255) NOT NULL,
  `shipping_parameters` TEXT,
  `shipping_time` INT(11) default '0',
  `admin_order_class` VARCHAR(64),
  `user_order_class` VARCHAR(64),
  `tare_weight` DOUBLE(16,4) default '0',
  `min_goods_cost` DOUBLE(16,2) default '0',
  `max_goods_cost` DOUBLE(16,2) default '0',
  `min_weight` DOUBLE(16,4) default '0',
  `max_weight` DOUBLE(16,4) default '0',
  `min_quantity` INT(11),
  `max_quantity` INT(11),
  `cost_per_order` DOUBLE(16,2) default '0',
  `cost_per_product` DOUBLE(16,2) default '0',
  `cost_per_weight` DOUBLE(16,2) default '0',
  `zero_cost_rule` TINYINT default '0',
  `zero_cost_desc` VARCHAR(255),
  `zero_cost_text` VARCHAR(255),
  `is_taxable` TINYINT default '1',
  `is_active` TINYINT default '1',
  `is_call_center` TINYINT default '1',
  `sites_all` TINYINT default '1',
  `guest_access` TINYINT default '1',
  `user_types_all` TINYINT default '1',
  `countries_all` TINYINT default '1',
  `states_all` TINYINT default '1',
  `postal_match_type` TINYINT default '1',
  `postal_codes` TEXT
  ,PRIMARY KEY (shipping_type_id)
  ,KEY shipping_module_id (shipping_module_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_types_countries;
CREATE TABLE va_shipping_types_countries (
  `shipping_type_id` INT(11) NOT NULL default '0',
  `country_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (shipping_type_id,country_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_types_sites;
CREATE TABLE va_shipping_types_sites (
  `shipping_type_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (shipping_type_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_types_states;
CREATE TABLE va_shipping_types_states (
  `shipping_type_id` INT(11) NOT NULL default '0',
  `state_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (shipping_type_id,state_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_shipping_types_users;
CREATE TABLE va_shipping_types_users (
  `shipping_type_id` INT(11) default '0',
  `user_type_id` INT(11) default '0'
  ,KEY shipping_type_id (shipping_type_id)
  ,KEY user_type_id (user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_sites;
CREATE TABLE va_sites (
  `site_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_site_id` INT(11),
  `is_mobile` TINYINT default '0',
  `is_mobile_redirect` TINYINT default '0',
  `short_name` VARCHAR(16),
  `site_name` VARCHAR(255),
  `site_description` TEXT
  ,PRIMARY KEY (site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_sliders;
CREATE TABLE va_sliders (
  `slider_id` INT(11) NOT NULL AUTO_INCREMENT,
  `slider_name` VARCHAR(64),
  `slider_title` VARCHAR(255),
  `slider_height` VARCHAR(16),
  `slider_width` VARCHAR(16)
  ,PRIMARY KEY (slider_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_sliders_items;
CREATE TABLE va_sliders_items (
  `item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `slider_id` INT(11) NOT NULL default '0',
  `show_for_user` TINYINT default '1',
  `item_order` INT(11) default '0',
  `item_name` VARCHAR(255),
  `slider_image` VARCHAR(255),
  `slider_link` VARCHAR(255),
  `slider_html` TEXT
  ,PRIMARY KEY (item_id)
  ,KEY slider_id (slider_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_states;
CREATE TABLE va_states (
  `state_id` INT(11) NOT NULL AUTO_INCREMENT,
  `state_code` VARCHAR(8),
  `country_id` INT(11) default '0',
  `state_name` VARCHAR(64) NOT NULL,
  `show_for_user` TINYINT default '1'
  ,KEY country_code (country_id)
  ,PRIMARY KEY (state_id)
  ,KEY state_code (state_code)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_subscriptions;
CREATE TABLE va_subscriptions (
  `subscription_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_id` INT(11) default '0',
  `user_type_id` INT(11) default '0',
  `subscription_name` VARCHAR(255),
  `is_active` TINYINT default '1',
  `is_default` TINYINT default '0',
  `is_subscription_recurring` TINYINT default '1',
  `subscription_fee` DOUBLE(16,2) default '0',
  `subscription_period` INT(11),
  `subscription_interval` INT(11),
  `subscription_suspend` INT(11) default '0',
  `subscription_points_type` TINYINT,
  `subscription_points_amount` DOUBLE(16,4),
  `subscription_credits_type` TINYINT,
  `subscription_credits_amount` DOUBLE(16,2),
  `subscription_affiliate_type` TINYINT,
  `subscription_affiliate_amount` INT(11)
  ,KEY group_id (group_id)
  ,PRIMARY KEY (subscription_id)
  ,KEY user_type_id (user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_subscriptions_groups;
CREATE TABLE va_subscriptions_groups (
  `group_id` INT(11) NOT NULL AUTO_INCREMENT,
  `group_name` VARCHAR(255),
  `is_active` TINYINT default '1'
  ,PRIMARY KEY (group_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_suppliers;
CREATE TABLE va_suppliers (
  `supplier_id` INT(11) NOT NULL AUTO_INCREMENT,
  `supplier_order` INT(11) default '1',
  `supplier_name` VARCHAR(255),
  `supplier_email` VARCHAR(255),
  `short_description` TEXT,
  `full_description` TEXT,
  `image_small` VARCHAR(255),
  `image_small_alt` VARCHAR(255),
  `image_large` VARCHAR(255),
  `image_large_alt` VARCHAR(255)
  ,PRIMARY KEY (supplier_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support;
CREATE TABLE va_support (
  `support_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) NOT NULL default '1',
  `user_id` INT(11) NOT NULL default '0',
  `user_name` VARCHAR(64) NOT NULL,
  `user_email` VARCHAR(128) NOT NULL,
  `affiliate_code` VARCHAR(64),
  `mail_cc` VARCHAR(255),
  `mail_bcc` VARCHAR(255),
  `mail_headers` TEXT,
  `remote_address` VARCHAR(32),
  `identifier` VARCHAR(128),
  `environment` VARCHAR(255),
  `support_product_id` INT(11) NOT NULL default '0',
  `support_type_id` INT(11) NOT NULL default '0',
  `dep_id` INT(11) NOT NULL default '0',
  `summary` VARCHAR(255) NOT NULL,
  `description` TEXT,
  `mail_body_text` TEXT,
  `mail_body_html` TEXT,
  `support_status_id` INT(11) default '0',
  `support_priority_id` INT(11) default '0',
  `admin_id_assign_to` INT(11) NOT NULL default '0',
  `admin_id_assign_by` INT(11) NOT NULL default '0',
  `admin_id_added_by` INT(11) NOT NULL default '0',
  `admin_id_modified_by` INT(11) NOT NULL default '0',
  `date_added` DATETIME NOT NULL,
  `date_modified` DATETIME NOT NULL,
  `date_viewed` DATETIME
  ,KEY admin_id_added_by (admin_id_added_by)
  ,KEY admin_id_assign_by (admin_id_assign_by)
  ,KEY admin_id_assign_to (admin_id_assign_to)
  ,KEY admin_id_modified_by (admin_id_modified_by)
  ,KEY date_added (date_added)
  ,KEY dep_id (dep_id)
  ,PRIMARY KEY (support_id)
  ,KEY site_id (site_id)
  ,KEY summary (summary)
  ,KEY support_product_id (support_product_id)
  ,KEY support_type_id (support_type_id)
  ,KEY user_email (user_email)
  ,KEY user_id (user_id)
  ,KEY user_name (user_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_attachments;
CREATE TABLE va_support_attachments (
  `attachment_id` INT(11) NOT NULL AUTO_INCREMENT,
  `support_id` INT(11) NOT NULL default '0',
  `message_id` INT(11) default '0',
  `admin_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `session_id` VARCHAR(32),
  `attachment_status` INT(11) default '0',
  `file_name` VARCHAR(255),
  `file_path` VARCHAR(255),
  `date_added` DATETIME
  ,KEY admin_id (admin_id)
  ,KEY message_id (message_id)
  ,PRIMARY KEY (attachment_id)
  ,KEY session_id (session_id)
  ,KEY support_id (support_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_custom_properties;
CREATE TABLE va_support_custom_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `site_id` INT(11) default '1',
  `property_order` INT(11) default '0',
  `property_name` VARCHAR(255),
  `property_description` TEXT,
  `default_value` TEXT,
  `property_class` VARCHAR(64),
  `property_style` VARCHAR(255),
  `section_id` INT(11) default '0',
  `property_show` TINYINT default '0',
  `control_type` VARCHAR(16),
  `control_style` VARCHAR(255),
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT,
  `required` TINYINT default '0',
  `before_name_html` TEXT,
  `after_name_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `validation_regexp` TEXT,
  `regexp_error` TEXT,
  `options_values_sql` TEXT
  ,KEY payment_id (site_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_custom_values;
CREATE TABLE va_support_custom_values (
  `property_value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `property_value` VARCHAR(255),
  `hide_value` TINYINT default '0',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (property_value_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_departments;
CREATE TABLE va_support_departments (
  `dep_id` INT(11) NOT NULL AUTO_INCREMENT,
  `short_title` VARCHAR(255),
  `full_title` VARCHAR(255),
  `signature` TEXT,
  `attachments_dir` VARCHAR(255),
  `attachments_mask` TEXT,
  `incoming_account` TEXT,
  `incoming_type_id` INT(11) default '0',
  `incoming_product_id` INT(11) default '0',
  `outgoing_account` VARCHAR(50),
  `show_for_user` TINYINT default '1',
  `sites_all` TINYINT default '1'
  ,KEY incoming_product_id (incoming_product_id)
  ,KEY incoming_type_id (incoming_type_id)
  ,PRIMARY KEY (dep_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_departments_sites;
CREATE TABLE va_support_departments_sites (
  `dep_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (dep_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_messages;
CREATE TABLE va_support_messages (
  `message_id` INT(11) NOT NULL AUTO_INCREMENT,
  `support_id` INT(11) NOT NULL default '0',
  `internal` TINYINT NOT NULL default '0',
  `dep_id` INT(11) NOT NULL default '0',
  `support_status_id` INT(11) NOT NULL default '0',
  `admin_id_assign_by` INT(11) NOT NULL default '0',
  `admin_id_assign_to` INT(11) NOT NULL default '0',
  `admin_id_modified_by` INT(11) NOT NULL default '0',
  `user_rating` TINYINT,
  `user_rating_comments` VARCHAR(128),
  `user_rating_id` INT(11),
  `user_rating_ip` VARCHAR(32),
  `admin_rating` TINYINT,
  `admin_rating_comments` VARCHAR(255),
  `admin_rating_id` INT(11),
  `admin_rating_ip` VARCHAR(32),
  `subject` VARCHAR(255),
  `message_text` TEXT,
  `mail_body_text` TEXT,
  `mail_body_html` TEXT,
  `reply_to` VARCHAR(255),
  `reply_from` VARCHAR(255),
  `mail_cc` VARCHAR(255),
  `mail_headers` TEXT,
  `date_added` DATETIME NOT NULL,
  `date_viewed` DATETIME,
  `date_modified` DATETIME,
  `is_user_reply` TINYINT default '0',
  `is_html` TINYINT default '0'
  ,KEY admin_id_assign_by (admin_id_assign_by)
  ,KEY admin_id_assign_to (admin_id_assign_to)
  ,KEY admin_id_modified_by (admin_id_modified_by)
  ,KEY date_added (date_added)
  ,KEY dep_id (dep_id)
  ,PRIMARY KEY (message_id)
  ,KEY support_id (support_id)
  ,KEY support_status_id (support_status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_predefined;
CREATE TABLE va_support_predefined (
  `reply_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_id` INT(11) default '0',
  `subject` VARCHAR(255),
  `body` TEXT,
  `total_uses` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `last_updated` DATETIME
  ,PRIMARY KEY (reply_id)
  ,KEY type_id (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_predefined_types;
CREATE TABLE va_support_predefined_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(64)
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_priorities;
CREATE TABLE va_support_priorities (
  `priority_id` INT(11) NOT NULL AUTO_INCREMENT,
  `priority_name` VARCHAR(255) NOT NULL,
  `priority_rank` INT(11) default '0',
  `admin_html` TEXT,
  `is_default` TINYINT default '0'
  ,PRIMARY KEY (priority_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_products;
CREATE TABLE va_support_products (
  `product_id` INT(11) NOT NULL AUTO_INCREMENT,
  `product_name` VARCHAR(255) NOT NULL,
  `show_for_user` TINYINT default '1',
  `sites_all` INT(11) default '1'
  ,PRIMARY KEY (product_id)
  ,KEY sites_all (sites_all)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_products_sites;
CREATE TABLE va_support_products_sites (
  `product_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (product_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_properties;
CREATE TABLE va_support_properties (
  `support_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `support_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_value` TEXT
  ,PRIMARY KEY (support_property_id)
  ,KEY property_id (property_id)
  ,KEY support_id (support_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_statuses;
CREATE TABLE va_support_statuses (
  `status_id` INT(11) NOT NULL AUTO_INCREMENT,
  `status_name` VARCHAR(255) NOT NULL,
  `show_for_user` TINYINT default '1',
  `status_caption` VARCHAR(255),
  `status_icon` VARCHAR(128),
  `admin_ticket_class` VARCHAR(64),
  `user_ticket_class` VARCHAR(64),
  `html_start` VARCHAR(255),
  `html_end` VARCHAR(255),
  `is_user_new` TINYINT default '0',
  `is_user_reply` TINYINT default '0',
  `is_admin_reply` TINYINT default '0',
  `is_operation` TINYINT default '0',
  `is_reassign` TINYINT default '0',
  `is_internal` TINYINT default '0',
  `is_list` TINYINT default '0',
  `is_closed` TINYINT default '0',
  `is_add_knowledge` TINYINT default '0',
  `admin_notify` TINYINT default '0',
  `admin_to` VARCHAR(255),
  `admin_from` VARCHAR(64),
  `admin_cc` VARCHAR(255),
  `admin_bcc` VARCHAR(255),
  `admin_reply_to` VARCHAR(64),
  `admin_return_path` VARCHAR(64),
  `admin_mail_type` TINYINT default '0',
  `admin_subject` VARCHAR(255),
  `admin_body` TEXT,
  `manager_by_notify` TINYINT default '0',
  `manager_by_to` VARCHAR(255),
  `manager_by_from` VARCHAR(64),
  `manager_by_cc` VARCHAR(255),
  `manager_by_bcc` VARCHAR(255),
  `manager_by_reply_to` VARCHAR(64),
  `manager_by_return_path` VARCHAR(64),
  `manager_by_mail_type` TINYINT default '0',
  `manager_by_subject` VARCHAR(255),
  `manager_by_body` TEXT,
  `manager_to_notify` TINYINT default '0',
  `manager_to_to` VARCHAR(255),
  `manager_to_from` VARCHAR(64),
  `manager_to_cc` VARCHAR(255),
  `manager_to_bcc` VARCHAR(255),
  `manager_to_reply_to` VARCHAR(64),
  `manager_to_return_path` VARCHAR(64),
  `manager_to_mail_type` TINYINT default '0',
  `manager_to_subject` VARCHAR(255),
  `manager_to_body` TEXT,
  `user_notify` TINYINT default '0',
  `user_to` VARCHAR(255),
  `user_from` VARCHAR(64),
  `user_cc` VARCHAR(255),
  `user_bcc` VARCHAR(255),
  `user_reply_to` VARCHAR(64),
  `user_return_path` VARCHAR(64),
  `user_mail_type` TINYINT default '0',
  `user_subject` VARCHAR(255),
  `user_body` TEXT
  ,PRIMARY KEY (status_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_time_report;
CREATE TABLE va_support_time_report (
  `report_id` INT(11) NOT NULL AUTO_INCREMENT,
  `admin_id` INT(11) NOT NULL default '0',
  `support_id` INT(11) NOT NULL default '0',
  `started_date` DATETIME,
  `report_date` DATETIME,
  `spent_hours` INT(11) default '0'
  ,KEY admin_id (admin_id)
  ,PRIMARY KEY (report_id)
  ,KEY support_id (support_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_types;
CREATE TABLE va_support_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(255) NOT NULL,
  `show_for_user` TINYINT default '1'
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_users_departments;
CREATE TABLE va_support_users_departments (
  `admin_id` INT(11) NOT NULL default '0',
  `dep_id` INT(11) NOT NULL default '0',
  `is_default_dep` TINYINT default '0'
  ,PRIMARY KEY (admin_id,dep_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_support_users_priorities;
CREATE TABLE va_support_users_priorities (
  `user_priority_id` INT(11) NOT NULL AUTO_INCREMENT,
  `priority_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `user_email` VARCHAR(255),
  `priority_expiry` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,PRIMARY KEY (user_priority_id)
  ,KEY priority_id (priority_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_tags;
CREATE TABLE va_tags (
  `tag_id` INT(11) NOT NULL AUTO_INCREMENT,
  `tag_name` VARCHAR(128),
  `name_first` VARCHAR(2),
  `friendly_url` VARCHAR(255)
  ,KEY friendly_url (friendly_url)
  ,KEY name_first (name_first)
  ,PRIMARY KEY (tag_id)
  ,KEY tag_name (tag_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_tax_rates;
CREATE TABLE va_tax_rates (
  `tax_id` INT(11) NOT NULL AUTO_INCREMENT,
  `is_default` TINYINT default '0',
  `tax_name` VARCHAR(255) NOT NULL,
  `tax_type` TINYINT default '1',
  `show_type` TINYINT default '0',
  `postal_code` TEXT,
  `state_id` INT(11) default '0',
  `country_id` INT(11) default '0',
  `tax_percent` DOUBLE(16,3) NOT NULL default '0',
  `fixed_amount` DOUBLE(16,2),
  `shipping_tax_percent` DOUBLE(16,3),
  `shipping_fixed_amount` DOUBLE(16,2)
  ,KEY country_id (country_id)
  ,PRIMARY KEY (tax_id)
  ,KEY state_id (state_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_tax_rates_items;
CREATE TABLE va_tax_rates_items (
  `tax_item_id` INT(11) NOT NULL AUTO_INCREMENT,
  `tax_id` INT(11) default '0',
  `item_type_id` INT(11) default '0',
  `tax_percent` DOUBLE(16,3),
  `fixed_amount` DOUBLE(16,2)
  ,KEY item_type_id (item_type_id)
  ,PRIMARY KEY (tax_item_id)
  ,KEY tax_id (tax_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_tracking_pages;
CREATE TABLE va_tracking_pages (
  `page_id` INT(11) NOT NULL AUTO_INCREMENT,
  `visit_id` INT(11) NOT NULL default '0',
  `ip_long` INT(11) NOT NULL default '0',
  `ip_text` VARCHAR(32),
  `forwarded_ips` VARCHAR(255),
  `request_uri` VARCHAR(255),
  `request_page` VARCHAR(255),
  `date_added` DATETIME NOT NULL,
  `year_added` SMALLINT NOT NULL default '0',
  `month_added` TINYINT NOT NULL default '0',
  `day_added` TINYINT NOT NULL default '0',
  `hour_added` TINYINT NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,KEY date_added (date_added)
  ,KEY day_added (day_added)
  ,KEY hour_added (hour_added)
  ,KEY ip_long (ip_long)
  ,KEY month_added (month_added)
  ,PRIMARY KEY (page_id)
  ,KEY site_id (site_id)
  ,KEY visit_id (visit_id)
  ,KEY year_added (year_added)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_tracking_visits;
CREATE TABLE va_tracking_visits (
  `visit_id` INT(11) NOT NULL AUTO_INCREMENT,
  `parent_visit_id` INT(11) default '0',
  `visit_number` INT(11) default '1',
  `ip_long` INT(11) NOT NULL default '0',
  `ip_text` VARCHAR(32) NOT NULL,
  `forwarded_ips` VARCHAR(50),
  `affiliate_code` VARCHAR(64),
  `keywords` VARCHAR(255),
  `user_agent` VARCHAR(255),
  `request_uri` VARCHAR(255),
  `request_page` VARCHAR(255),
  `referer` VARCHAR(255),
  `referer_host` VARCHAR(255),
  `referer_engine_id` INT(11) NOT NULL default '0',
  `robot_engine_id` INT(11) NOT NULL default '0',
  `date_added` DATETIME NOT NULL,
  `year_added` SMALLINT NOT NULL default '0',
  `month_added` TINYINT NOT NULL default '0',
  `week_added` INT(11) NOT NULL default '0',
  `day_added` TINYINT NOT NULL default '0',
  `hour_added` TINYINT NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,KEY affiliate_code (affiliate_code)
  ,KEY date_added (date_added)
  ,KEY day_added (day_added)
  ,KEY hour_added (hour_added)
  ,KEY keyword_phrase (keywords)
  ,KEY month_added (month_added)
  ,KEY parent_visit_id (parent_visit_id)
  ,PRIMARY KEY (visit_id)
  ,KEY referer_engine_id (referer_engine_id)
  ,KEY referer_host (referer_host)
  ,KEY remote_ip_long (ip_long)
  ,KEY robot_engine_id (robot_engine_id)
  ,KEY site_id (site_id)
  ,KEY week_added (week_added)
  ,KEY year_added (year_added)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_profile_properties;
CREATE TABLE va_user_profile_properties (
  `property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_type_id` INT(11) default '0',
  `property_order` INT(11) default '0',
  `property_code` VARCHAR(64),
  `property_name` VARCHAR(255),
  `property_description` TEXT,
  `default_value` TEXT,
  `property_class` VARCHAR(64),
  `property_style` VARCHAR(255),
  `section_id` INT(11) default '0',
  `property_show` TINYINT default '0',
  `control_type` VARCHAR(16),
  `control_style` VARCHAR(255),
  `control_code` TEXT,
  `onchange_code` TEXT,
  `onclick_code` TEXT,
  `required` TINYINT default '0',
  `before_name_html` TEXT,
  `after_name_html` TEXT,
  `before_control_html` TEXT,
  `after_control_html` TEXT,
  `validation_regexp` TEXT,
  `regexp_error` TEXT,
  `options_values_sql` TEXT
  ,KEY payment_id (user_type_id)
  ,PRIMARY KEY (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_profile_sections;
CREATE TABLE va_user_profile_sections (
  `section_id` INT(11) NOT NULL AUTO_INCREMENT,
  `is_active` TINYINT default '1',
  `step_number` INT(11) default '1',
  `section_order` INT(11) default '0',
  `section_code` VARCHAR(16),
  `section_name` VARCHAR(64),
  `user_types_all` TINYINT default '1'
  ,PRIMARY KEY (section_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_profile_sections_types;
CREATE TABLE va_user_profile_sections_types (
  `section_id` INT(11) NOT NULL default '0',
  `user_type_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (section_id,user_type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_profile_values;
CREATE TABLE va_user_profile_values (
  `property_value_id` INT(11) NOT NULL AUTO_INCREMENT,
  `property_id` INT(11) default '0',
  `property_value` VARCHAR(255),
  `hide_value` TINYINT default '0',
  `is_default_value` TINYINT default '0'
  ,PRIMARY KEY (property_value_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_types;
CREATE TABLE va_user_types (
  `type_id` INT(11) NOT NULL AUTO_INCREMENT,
  `type_name` VARCHAR(128),
  `is_default` TINYINT default '0',
  `is_active` TINYINT default '1',
  `is_sms_allowed` TINYINT default '0',
  `sites_all` TINYINT default '1',
  `countries_all` TINYINT default '1',
  `show_for_user` TINYINT default '1',
  `price_type` TINYINT default '0',
  `discount_type` TINYINT,
  `discount_amount` DOUBLE(16,2) default '0',
  `reward_type` TINYINT,
  `reward_amount` DOUBLE(16,4),
  `credit_reward_type` TINYINT,
  `credit_reward_amount` DOUBLE(16,2),
  `affiliate_commission_type` TINYINT,
  `affiliate_commission_amount` DOUBLE(16,2),
  `merchant_fee_type` TINYINT,
  `merchant_fee_amount` DOUBLE(16,2),
  `order_min_goods_cost` DOUBLE(16,2),
  `order_max_goods_cost` DOUBLE(16,2),
  `tax_free` TINYINT default '0',
  `coupons_ids` TEXT,
  `is_subscription` TINYINT default '0',
  `is_subscription_recurring` INT(11),
  `subscription_name` VARCHAR(255),
  `subscription_fee` DOUBLE(16,2),
  `subscription_period` INT(11),
  `subscription_interval` INT(11),
  `subscription_suspend` INT(11) default '0',
  `subscription_points_type` TINYINT,
  `subscription_points_amount` DOUBLE(16,4),
  `subscription_credits_type` TINYINT,
  `subscription_credits_amount` DOUBLE(16,2),
  `subscription_affiliate_type` TINYINT,
  `subscription_affiliate_amount` DOUBLE(16,2)
  ,PRIMARY KEY (type_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_types_countries;
CREATE TABLE va_user_types_countries (
  `type_id` INT(11) NOT NULL default '0',
  `country_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (type_id,country_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_types_settings;
CREATE TABLE va_user_types_settings (
  `type_id` INT(11) NOT NULL default '0',
  `setting_name` VARCHAR(64) NOT NULL,
  `setting_value` VARCHAR(50)
  ,PRIMARY KEY (type_id,setting_name)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_user_types_sites;
CREATE TABLE va_user_types_sites (
  `type_id` INT(11) NOT NULL default '0',
  `site_id` INT(11) NOT NULL default '0'
  ,PRIMARY KEY (type_id,site_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users;
CREATE TABLE va_users (
  `user_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_type_id` INT(11) default '0',
  `subscription_id` INT(11) default '0',
  `layout_id` INT(11),
  `is_approved` TINYINT default '0',
  `is_hidden` TINYINT default '0',
  `is_unsubscribed` TINYINT default '0',
  `expiry_date` DATETIME,
  `suspend_date` DATETIME,
  `registration_last_step` INT(11) default '1',
  `registration_total_steps` INT(11) default '1',
  `is_sms_allowed` TINYINT default '0',
  `credit_balance` DOUBLE(16,2) default '0',
  `total_points` DOUBLE(16,4) default '0',
  `discount_type` TINYINT,
  `discount_amount` DOUBLE(16,2) default '0',
  `reward_type` TINYINT,
  `reward_amount` DOUBLE(16,4),
  `credit_reward_type` TINYINT,
  `credit_reward_amount` DOUBLE(16,2),
  `affiliate_commission_type` TINYINT,
  `affiliate_commission_amount` DOUBLE(16,2),
  `merchant_fee_type` TINYINT,
  `merchant_fee_amount` DOUBLE(16,2),
  `tax_free` TINYINT default '0',
  `order_min_goods_cost` DOUBLE(16,2),
  `order_max_goods_cost` DOUBLE(16,2),
  `coupons_ids` TEXT,
  `login` VARCHAR(64) NOT NULL,
  `password` VARCHAR(32) NOT NULL,
  `nickname` VARCHAR(32),
  `affiliate_code` VARCHAR(64),
  `security_question` VARCHAR(255),
  `security_answer` VARCHAR(255),
  `personal_image` VARCHAR(255),
  `short_description` VARCHAR(255),
  `full_description` TEXT,
  `friendly_url` VARCHAR(255),
  `name` VARCHAR(128) NOT NULL,
  `first_name` VARCHAR(64) NOT NULL,
  `last_name` VARCHAR(64) NOT NULL,
  `company_id` INT(11) default '0',
  `company_name` VARCHAR(128),
  `email` VARCHAR(128) NOT NULL,
  `address1` VARCHAR(255),
  `address2` VARCHAR(255),
  `city` VARCHAR(128),
  `province` VARCHAR(128),
  `state_id` INT(11) default '0',
  `state_code` VARCHAR(8),
  `zip` VARCHAR(16),
  `country_id` INT(11) default '0',
  `country_code` VARCHAR(8),
  `phone` VARCHAR(32),
  `daytime_phone` VARCHAR(32),
  `evening_phone` VARCHAR(32),
  `cell_phone` VARCHAR(32),
  `fax` VARCHAR(32),
  `delivery_name` VARCHAR(128),
  `delivery_first_name` VARCHAR(64),
  `delivery_last_name` VARCHAR(64),
  `delivery_company_id` INT(11) default '0',
  `delivery_company_name` VARCHAR(128),
  `delivery_email` VARCHAR(128),
  `delivery_address1` VARCHAR(255),
  `delivery_address2` VARCHAR(255),
  `delivery_city` VARCHAR(128),
  `delivery_province` VARCHAR(128),
  `delivery_state_id` INT(11) default '0',
  `delivery_state_code` VARCHAR(8),
  `delivery_zip` VARCHAR(16),
  `delivery_country_id` INT(11) default '0',
  `delivery_country_code` VARCHAR(8),
  `delivery_phone` VARCHAR(32),
  `delivery_daytime_phone` VARCHAR(32),
  `delivery_evening_phone` VARCHAR(32),
  `delivery_cell_phone` VARCHAR(32),
  `delivery_fax` VARCHAR(32),
  `bill_encrypt_type` TINYINT default '1',
  `bill_name` VARCHAR(128),
  `bill_first_name` VARCHAR(64),
  `bill_last_name` VARCHAR(64),
  `bill_company_id` VARCHAR(32),
  `bill_company_name` VARCHAR(128),
  `bill_email` VARCHAR(128),
  `bill_address1` VARCHAR(255),
  `bill_address2` VARCHAR(255),
  `bill_city` VARCHAR(128),
  `bill_province` VARCHAR(128),
  `bill_state_id` VARCHAR(32),
  `bill_zip` VARCHAR(32),
  `bill_country_id` VARCHAR(32),
  `bill_phone` VARCHAR(32),
  `bill_daytime_phone` VARCHAR(32),
  `bill_evening_phone` VARCHAR(32),
  `bill_cell_phone` VARCHAR(32),
  `bill_fax` VARCHAR(32),
  `bill_cc_number` VARCHAR(64),
  `bill_cc_start_date` VARCHAR(32),
  `bill_cc_expiry_date` VARCHAR(32),
  `bill_cc_type` VARCHAR(32),
  `bill_cc_issue_number` VARCHAR(16),
  `bill_cc_cvv2` VARCHAR(16),
  `paypal_account` VARCHAR(128),
  `msn_account` VARCHAR(128),
  `icq_number` VARCHAR(32),
  `user_site_url` VARCHAR(255),
  `tax_id` VARCHAR(128),
  `birth_year` SMALLINT,
  `birth_month` TINYINT,
  `birth_day` TINYINT,
  `user_notes` TEXT,
  `admin_notes` TEXT,
  `registration_ip` VARCHAR(32),
  `registration_date` DATETIME,
  `modified_ip` VARCHAR(32),
  `modified_date` DATETIME,
  `admin_modified_ip` VARCHAR(32),
  `admin_modified_date` DATETIME,
  `last_logged_ip` VARCHAR(32),
  `last_logged_date` DATETIME,
  `last_visit_ip` VARCHAR(32),
  `last_visit_page` VARCHAR(255),
  `last_visit_date` DATETIME,
  `reset_password_code` VARCHAR(64),
  `reset_password_date` DATETIME
  ,KEY affiliate_code (affiliate_code)
  ,KEY company_id (company_id)
  ,KEY country_id (country_id)
  ,KEY delivery_company_id (delivery_company_id)
  ,KEY delivery_country_id (delivery_country_id)
  ,KEY delivery_state_id (delivery_state_id)
  ,KEY email (email)
  ,KEY first_name (first_name)
  ,KEY last_name (last_name)
  ,KEY last_visit_date (last_visit_date)
  ,KEY login (login)
  ,KEY name (name)
  ,KEY nickname (nickname)
  ,KEY password (password)
  ,PRIMARY KEY (user_id)
  ,KEY reset_password_code (reset_password_code)
  ,KEY state_id (state_id)
  ,KEY subscription_id (subscription_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_addresses;
CREATE TABLE va_users_addresses (
  `address_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `address_type` TINYINT default '0',
  `name` VARCHAR(128),
  `first_name` VARCHAR(64),
  `last_name` VARCHAR(64),
  `company_id` INT(11) default '0',
  `company_name` VARCHAR(128),
  `email` VARCHAR(128),
  `address1` VARCHAR(255),
  `address2` VARCHAR(255),
  `city` VARCHAR(128),
  `province` VARCHAR(128),
  `state_id` INT(11) default '0',
  `state_code` VARCHAR(8),
  `postal_code` VARCHAR(16),
  `country_id` INT(11) default '0',
  `country_code` VARCHAR(8),
  `phone` VARCHAR(32),
  `daytime_phone` VARCHAR(32),
  `evening_phone` VARCHAR(32),
  `cell_phone` VARCHAR(32),
  `fax` VARCHAR(32)
  ,PRIMARY KEY (address_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_commissions;
CREATE TABLE va_users_commissions (
  `commission_id` INT(11) NOT NULL AUTO_INCREMENT,
  `payment_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `commission_amount` DOUBLE(16,2) default '0',
  `commission_action` INT(11) default '0',
  `commission_type` INT(11) default '0',
  `date_added` DATETIME NOT NULL
  ,KEY date_added (date_added)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,KEY payment_id (payment_id)
  ,PRIMARY KEY (commission_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_credits;
CREATE TABLE va_users_credits (
  `credit_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `credit_amount` DOUBLE(16,2) default '0',
  `credit_action` INT(11) default '0',
  `credit_type` TINYINT default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY date_added (date_added)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (credit_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_files;
CREATE TABLE va_users_files (
  `file_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL default '0',
  `file_type` VARCHAR(32),
  `file_name` VARCHAR(255),
  `file_path` VARCHAR(255)
  ,PRIMARY KEY (file_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_payments;
CREATE TABLE va_users_payments (
  `payment_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `is_paid` TINYINT default '0',
  `transaction_id` VARCHAR(128),
  `payment_total` DOUBLE(16,2) default '0',
  `payment_name` VARCHAR(255),
  `payment_notes` TEXT,
  `date_added` DATETIME,
  `date_modified` DATETIME,
  `date_paid` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0'
  ,KEY date_paid (date_paid)
  ,KEY is_paid (is_paid)
  ,PRIMARY KEY (payment_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_photos;
CREATE TABLE va_users_photos (
  `photo_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `key_id` INT(11) default '0',
  `photo_type` TINYINT default '1',
  `is_shown` TINYINT default '1',
  `is_approved` TINYINT default '1',
  `photo_name` VARCHAR(255),
  `photo_desc` TEXT,
  `tiny_photo` VARCHAR(255),
  `small_photo` VARCHAR(255),
  `large_photo` VARCHAR(255),
  `super_photo` VARCHAR(255),
  `date_added` DATETIME,
  `date_updated` DATETIME
  ,KEY key_id (key_id)
  ,KEY photo_type (photo_type)
  ,PRIMARY KEY (photo_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_points;
CREATE TABLE va_users_points (
  `points_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `order_id` INT(11) default '0',
  `order_item_id` INT(11) default '0',
  `points_amount` DOUBLE(16,4) default '0',
  `points_action` INT(11) default '0',
  `points_type` INT(11) default '0',
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY date_added (date_added)
  ,KEY order_id (order_id)
  ,KEY order_item_id (order_item_id)
  ,PRIMARY KEY (points_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_properties;
CREATE TABLE va_users_properties (
  `user_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_value` TEXT
  ,KEY order_id (user_id)
  ,PRIMARY KEY (user_property_id)
  ,KEY property_id (property_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_ps_details;
CREATE TABLE va_users_ps_details (
  `psd_id` INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) default '0',
  `payment_id` INT(11) default '0',
  `is_default` TINYINT default '0',
  `is_active` INT(11) default '0',
  `cc_encrypt_type` TINYINT default '1',
  `cc_name` VARCHAR(128),
  `cc_first_name` VARCHAR(64),
  `cc_last_name` VARCHAR(64),
  `cc_number` VARCHAR(64),
  `cc_start_date` DATETIME,
  `cc_expiry_date` DATETIME,
  `cc_type` INT(11),
  `cc_issue_number` INT(11),
  `cc_security_code` VARCHAR(32),
  `success_payments` INT(11) default '0',
  `failed_payments` INT(11) default '0',
  `last_payment_date` DATETIME,
  `admin_id_added_by` INT(11) default '0',
  `admin_id_modified_by` INT(11) default '0',
  `date_added` DATETIME,
  `date_modified` DATETIME
  ,KEY payment_id (payment_id)
  ,PRIMARY KEY (psd_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


DROP TABLE IF EXISTS va_users_ps_properties;
CREATE TABLE va_users_ps_properties (
  `user_property_id` INT(11) NOT NULL AUTO_INCREMENT,
  `psd_id` INT(11) default '0',
  `user_id` INT(11) default '0',
  `property_id` INT(11) default '0',
  `property_order` INT(11) default '1',
  `property_type` INT(11) default '0',
  `property_name` VARCHAR(255) NOT NULL,
  `property_value_id` INT(11),
  `property_value` TEXT
  ,PRIMARY KEY (user_property_id)
  ,KEY property_id (property_id)
  ,KEY property_name (property_name)
  ,KEY psd_id (psd_id)
  ,KEY user_id (user_id)
) DEFAULT CHARACTER SET=utf8 ;


INSERT INTO va_admin_privileges (`privilege_id`,`is_hidden`,`support_privilege`,`privilege_name`,`user_types_all`,`non_logged_users`,`user_types_ids`) VALUES (1 , 0 , 0 , 'Administrator' , 1 , 1 , NULL ) ;
INSERT INTO va_admin_privileges (`privilege_id`,`is_hidden`,`support_privilege`,`privilege_name`,`user_types_all`,`non_logged_users`,`user_types_ids`) VALUES (2 , 0 , 1 , 'HelpDesk Manager' , 1 , 1 , NULL ) ;


INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_admins' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_duplicate_coupons' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_payments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_sites' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'add_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admin_registration' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admin_sites' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admin_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admins_groups' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admins_hidden' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'admins_login' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'ads' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'advanced_search' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'approve_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'articles' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'articles_lost' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'articles_reviews' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'articles_reviews_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'articles_statuses' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'banned_contents' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'banners' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'black_ips' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'categories_export' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'categories_import' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'categories_order' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'cms_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'coupons' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'create_orders' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'custom_blocks' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'custom_friendly_urls' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'db_management' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'downloadable_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'duplicate_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'edit_reg_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'edit_reg_list' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'edit_reg_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'export_payments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'export_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'features_groups' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'filemanager' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'filters' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'footer_links' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'forum' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'get_orders_ids' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'get_orders_statuses' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'import_export' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'import_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'layouts' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'manual' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'manufacturers' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'newsletter' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_confirmation' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_links' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_notes' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_payment' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_profile' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_serials' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_statuses' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'order_vouchers' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'orders_import' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'orders_recover' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'orders_stats' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'payment_systems' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'polls' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_accessories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_features' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_images' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_prices' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_properties' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_related' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_releases' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'product_types' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_export' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_export_google_base' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_import' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_order' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_report' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_reviews' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_reviews_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'products_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_admins' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_orders' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_payments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_sites' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'remove_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'sales_orders' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'saved_types' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'shipping_methods' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'shipping_rules' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'shipping_times' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'site_navigation' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'site_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'site_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'sliders' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'static_google_base_attributes' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'static_google_base_types' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'static_messages' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'static_prices' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'static_tables' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'subscriptions' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'subscriptions_groups' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'suppliers' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_departments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_predefined_reply' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_static_data' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_ticket_close' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_ticket_edit' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_ticket_new' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_ticket_reply' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_users_priorities' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'support_users_stats' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'system_upgrade' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'tax_rates' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'tell_friend' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_admins' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_order_status' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_orders' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_payments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_sites' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'update_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'users_forgot' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'users_groups' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'users_login' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'users_payments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'view_categories' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'view_products' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'visits_report' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (1 , 'web_pages' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_admins' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_duplicate_coupons' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_payments' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_sites' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'add_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admin_registration' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admin_sites' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admin_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admins_groups' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admins_hidden' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'admins_login' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'ads' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'advanced_search' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'approve_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'articles' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'articles_lost' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'articles_reviews' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'articles_reviews_settings' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'articles_statuses' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'banned_contents' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'banners' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'black_ips' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'categories_export' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'categories_import' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'categories_order' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'cms_settings' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'coupons' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'create_orders' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'custom_blocks' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'custom_friendly_urls' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'db_management' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'downloadable_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'duplicate_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'edit_reg_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'edit_reg_list' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'edit_reg_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'export_payments' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'export_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'features_groups' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'filemanager' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'filters' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'footer_links' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'forum' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'get_orders_ids' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'get_orders_statuses' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'import_export' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'import_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'layouts' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'manual' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'manufacturers' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'newsletter' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_confirmation' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_links' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_notes' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_payment' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_profile' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_serials' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_statuses' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'order_vouchers' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'orders_import' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'orders_recover' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'orders_stats' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'payment_systems' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'polls' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_accessories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_features' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_images' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_prices' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_properties' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_related' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_releases' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'product_types' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_export' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_export_google_base' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_import' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_order' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_report' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_reviews' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_reviews_settings' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'products_settings' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_admins' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_orders' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_payments' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_sites' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'remove_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'sales_orders' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'saved_types' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'shipping_methods' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'shipping_rules' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'shipping_times' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'site_navigation' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'site_settings' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'site_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'sliders' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'static_google_base_attributes' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'static_google_base_types' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'static_messages' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'static_prices' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'static_tables' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'subscriptions' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'subscriptions_groups' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'suppliers' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_departments' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_predefined_reply' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_settings' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_static_data' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_ticket_close' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_ticket_edit' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_ticket_new' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_ticket_reply' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_users' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_users_priorities' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'support_users_stats' , 1 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'system_upgrade' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'tax_rates' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'tell_friend' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_admins' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_order_status' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_orders' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_payments' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_sites' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'update_users' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'users_forgot' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'users_groups' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'users_login' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'users_payments' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'view_categories' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'view_products' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'visits_report' , 0 ) ;
INSERT INTO va_admin_privileges_settings (`privilege_id`,`block_name`,`permission`) VALUES (2 , 'web_pages' , 0 ) ;


INSERT INTO va_admins (`admin_id`,`admin_name`,`nickname`,`admin_alias`,`privilege_id`,`is_hidden`,`email`,`cell_phone`,`login`,`password`,`personal_image`,`signature`,`last_order_id`,`exported_order_id`,`exported_order_fields`,`last_user_id`,`exported_email_id`,`exported_user_id`,`exported_email_fields`,`exported_user_fields`,`imported_email_fields`,`imported_user_fields`,`exported_item_fields`,`imported_item_fields`,`edited_item_fields`,`last_visit_date`,`support_online_date`,`is_generate_big_image`,`is_generate_small_image`,`login_attempts`,`login_failed`,`access_code`,`access_added`,`access_attempts`,`access_failed`) VALUES (1 , 'Site Administrator' , 'admin' , 'SA' , 1 , 0 , 'admin@yoursite.com' , NULL , 'admin' , 'admin' , NULL , NULL , NULL , NULL , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , 'i.item_id,i.item_name,i.item_order,i.buying_price,i.features,csv_delimiter,csv_delimiter,related_delimiterrelated_delimiter' , NULL , NULL , NULL , NULL , NULL , NULL , 0 , NULL , NULL , NULL , 0 , NULL ) ;


INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (1 , 1 , 1 , '127.0.0.1' , NULL , '2014-03-26 21:06:23' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (2 , 1 , 1 , '127.0.0.1' , NULL , '2015-01-27 15:56:40' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (3 , 1 , 1 , '127.0.0.1' , NULL , '2015-02-04 14:55:57' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (4 , 1 , 1 , '127.0.0.1' , NULL , '2015-02-04 14:55:57' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (5 , 1 , 1 , '127.0.0.1' , NULL , '2015-03-11 23:27:28' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (6 , 1 , 1 , '127.0.0.1' , NULL , '2015-03-11 23:27:28' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (7 , 1 , 1 , '127.0.0.1' , NULL , '2015-03-23 23:09:46' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (8 , 1 , 1 , '127.0.0.1' , NULL , '2015-03-23 23:09:46' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (9 , 1 , 1 , '127.0.0.1' , NULL , '2015-04-20 09:09:29' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (10 , 1 , 1 , '127.0.0.1' , NULL , '2015-04-20 09:09:29' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (11 , 1 , 1 , '127.0.0.1' , NULL , '2015-04-21 18:26:52' ) ;
INSERT INTO va_admins_login_stats (`stat_id`,`admin_id`,`login_status`,`ip_address`,`forwarded_ips`,`date_added`) VALUES (12 , 1 , 1 , '127.0.0.1' , NULL , '2015-04-21 18:26:52' ) ;


INSERT INTO va_admins_settings (`admin_id`,`setting_name`,`setting_value`) VALUES (1 , 'recent_queries' , '["update categories set header_menu_show=1,nav_bar_show=1"]' ) ;




INSERT INTO va_ads_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`sites_all`,`publish_price`,`access_level`,`guest_access_level`,`admin_access_level`,`category_order`,`short_description`,`full_description`,`image_small`,`image_large`,`total_views`,`total_ads`,`total_subcategories`) VALUES (1 , NULL , 0 , 0 , '0,' , 'Books' , NULL , 1 , NULL , 7 , 7 , 7 , 1 , NULL , NULL , 'images/categories/books.gif' , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_ads_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`sites_all`,`publish_price`,`access_level`,`guest_access_level`,`admin_access_level`,`category_order`,`short_description`,`full_description`,`image_small`,`image_large`,`total_views`,`total_ads`,`total_subcategories`) VALUES (2 , NULL , 0 , 0 , '0,' , 'Electronics ' , NULL , 1 , NULL , 7 , 7 , 7 , 2 , NULL , NULL , 'images/categories/electronics.gif' , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_ads_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`sites_all`,`publish_price`,`access_level`,`guest_access_level`,`admin_access_level`,`category_order`,`short_description`,`full_description`,`image_small`,`image_large`,`total_views`,`total_ads`,`total_subcategories`) VALUES (3 , NULL , 0 , 0 , '0,' , 'Computers' , NULL , 1 , NULL , 7 , 7 , 7 , 3 , NULL , NULL , 'images/categories/computers.gif' , NULL , NULL , 0 , 0 ) ;








INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (1 , 1 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (2 , 3 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (3 , 7 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (4 , 14 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (5 , 30 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (6 , 60 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (7 , 90 , NULL , NULL ) ;
INSERT INTO va_ads_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (8 , 180 , NULL , NULL ) ;






INSERT INTO va_ads_features_groups (`group_id`,`group_order`,`group_name`) VALUES (1 , 1 , 'General' ) ;
INSERT INTO va_ads_features_groups (`group_id`,`group_order`,`group_name`) VALUES (2 , 2 , 'Sizes' ) ;
INSERT INTO va_ads_features_groups (`group_id`,`group_order`,`group_name`) VALUES (3 , 3 , 'Accessories' ) ;


INSERT INTO va_ads_hot_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (1 , 1 , NULL , NULL ) ;
INSERT INTO va_ads_hot_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (2 , 3 , NULL , NULL ) ;
INSERT INTO va_ads_hot_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (3 , 7 , NULL , NULL ) ;
INSERT INTO va_ads_hot_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (4 , 14 , NULL , NULL ) ;
INSERT INTO va_ads_hot_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (5 , 30 , NULL , NULL ) ;










INSERT INTO va_ads_special_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (1 , 1 , NULL , NULL ) ;
INSERT INTO va_ads_special_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (2 , 3 , NULL , NULL ) ;
INSERT INTO va_ads_special_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (3 , 7 , NULL , NULL ) ;
INSERT INTO va_ads_special_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (4 , 14 , NULL , NULL ) ;
INSERT INTO va_ads_special_days (`days_id`,`days_number`,`days_title`,`publish_price`) VALUES (5 , 30 , NULL , NULL ) ;


INSERT INTO va_ads_types (`type_id`,`type_name`) VALUES (1 , 'AD_PRODUCT_TYPE_MSG' ) ;
INSERT INTO va_ads_types (`type_id`,`type_name`) VALUES (2 , 'AD_ACCESSORY_TYPE_MSG' ) ;








INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (1 , NULL , '2008-09-11 15:06:00' , NULL , '\'Mythical\' animal finally poses for camera' , NULL , NULL , NULL , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 1 , 1 , 'Rare images of an African animal so elusive that it was once believed to be mythical have been released.' , NULL , NULL , NULL , NULL , 0 , NULL , NULL , '2008-09-12 14:29:25' , NULL , NULL , 'Rare images of an African animal so elusive that it was once believed to be mythical have been released.\r\n<br><br>\r\nThe okapi is a shy animal related to the giraffe, with zebra-like stripes on its rear. It is native to the tropical rainforests of Africa but is now known to live only in the Democratic Republic of the Congo.' , 'Rare images of an African animal so elusive that it was once believed to be mythical have been released.\r\n\r\nThe okapi is a shy animal related to the giraffe, with zebra-like stripes on its rear. It is native to the tropical rainforests of Africa but is now known to live only in the Democratic Republic of the Congo.\r\n\r\nOkapis were last seen in the DRC 50 years ago, and the images are the first to capture the animal in the wild.\r\n\r\n"To have captured the first-ever photographs of such a charismatic creature is amazing," said Noelle Kumpel, manager of the Bushmeat and Forests Conservation Program at the Zoological Society of London, which took the pictures. \r\n\r\n"Okapi are very shy and rare animals, which is why conventional surveys only tend to record droppings and other signs of their presence."\r\n\r\nThe okapi\'s face and long legs resemble those of the giraffe, their closest-living relative, but they look more like horses with long necks. The average height of their shoulders is 1.6 meters (5 feet, 3 inches), the ZSL says.\r\n\r\nThey have a short, dense, velvety coat and dark prehensile tongue long enough to clean their own eyelids and ears.\r\n\r\nThe new pictures show the okapi in the foliage of the DRC\'s Virunga National Park, where decades of economic collapse and armed conflict have threatened the diverse wildlife.\r\n\r\nIn one image, an okapi looks curiously toward the camera amid the green trees and groundcover. Its large ears, dark nose, and zebra stripes are clearly visible.\r\n\r\nThe next shot shows the okapi walking away from the camera, giving a clear view of its striking black-and-white stripes on its rear legs.\r\n\r\nA third image released by ZSL was taken at night and gives a vivid side view of the animal.\r\n\r\n"The photographs clearly show the stripes on their rear, which act like unique fingerprints," said Theirry Lusenge, a key member of ZSL\'s survey team in the DRC. "We have already identified three individuals, and further survey work will enable us to estimate population numbers and distribution in and around the park, which is a critical first step in targeting conservation efforts."\r\n\r\nZSL said the images prove the okapi still thrives in the park despite threats to its survival, which include poaching, deforestation, military camps inside the park, and the influx of refugees at the park\'s borders.\r\n\r\nThe animal\'s exact status is still a mystery, however, and it remains under threat, the ZSL said. Okapi meat reportedly poached from the park is now regularly on sale at the nearby town of Beni -- and if hunting continues at the same rate, okapi could become extinct within the park within a few years, the ZSL said.\r\n\r\nThe Virunga National Park is one of only three protected areas the okapi are known to inhabit, the ZSL said.\r\n\r\nThe ZSL\'s study of the okapi is part of a larger EU-funded conservation project in the park. Though focused on okapi, the study has also managed to find other species including shrews and duikers, a kind of antelope, a ZSL spokeswoman said.\r\n\r\nThe study involved 18 cameras set up around the park by the ZSL and the Congolese Institute for Nature Conservation, the spokeswoman said.\r\n\r\nThe announcement comes a month after another group of researchers reported finding thousands of previously-unknown gorillas in the neighboring Republic of Congo.\r\n\r\nThe U.S.-based Wildlife Conservation Society said in August they had found 125,000 Western lowland gorillas living in a swamp in northern Congo, adding significantly to the existing worldwide population of the threatened species.\r\n\r\nOkapi were well known by Africans for centuries but the animal remained elusive, thanks to its acute hearing and effective camouflage, according to The National Zoological Gardens of South Africa.\r\n\r\nNineteenth-century explorers sometimes caught a fleeting glimpse of the okapi\'s striped backside as it ran through the forest, leading to speculation that it was a kind of zebra, the National Zoological Gardens says. It was known to the pygmy as a sacred animal.\r\n\r\nStill, the okapi remained unknown to the Western world until the early 20th century, when British explorer Harry Johnston went to Congo and sent a complete skin and skull back to Britain, the ZSL said' , NULL , 1 , 1 , 4 , 4 , 0 , NULL , NULL , 'images/articles/small/news4.jpg' , NULL , 'images/articles/large/news4.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (2 , NULL , '2008-09-11 15:10:00' , NULL , 'Thousands stranded by Channel Tunnel fire' , NULL , NULL , NULL , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , 'Authorities on Thursday halted all traffic running through the 50-kilometer (30-mile) Chunnel after a fire broke out inside the tunnel, which runs between Britain and France underneath the English Channel, Eurotunnel and fire officials said.\r\n' , NULL , NULL , NULL , NULL , 0 , NULL , NULL , '2008-09-12 14:26:54' , NULL , NULL , 'Authorities on Thursday halted all traffic running through the 50-kilometer (30-mile) Chunnel after a fire broke out inside the tunnel, which runs between Britain and France underneath the English Channel, Eurotunnel and fire officials said.\r\n<br><br>\r\nThe fire started on a shuttle train carrying freight as it approached France, Eurotunnel said. No passenger trains were going through the tunnel at the time of the fire.' , 'Authorities on Thursday halted all traffic running through the 50-kilometer (30-mile) Chunnel after a fire broke out inside the tunnel, which runs between Britain and France underneath the English Channel, Eurotunnel and fire officials said.\r\n\r\nThe fire started on a shuttle train carrying freight as it approached France, Eurotunnel said. No passenger trains were going through the tunnel at the time of the fire.\r\n\r\nThe fire continued to burn nearly four hours later, according to Georges Bos, the prefecture of France\'s Pas de Calais region.\r\n\r\nFrench rail authorities said the tunnel will be closed at least until Friday morning.\r\n\r\nThe French Interior Ministry said some people were injured in the incident, but did not specify how many or the nature of their injuries. Bos told BFM-TV that six people suffered from smoke inhalation.\r\n\r\nThe fire broke out around 2:55 p.m. (9:55 a.m. ET) -- reportedly on one of the trucks being shuttled by the train -- about 11 kilometers (7 miles) from France, officials said. \r\n\r\nThirty-two people were evacuated through a central service tunnel that runs between the east and west tubes, Kent fire officials said. \r\n\r\nEurotunnel authorities suspended services in both directions to allow emergency vehicles to get to the fire. The tunnel closure will affect thousands of travelers, according to Simon Montague, a spokesman for the Eurostar train system. \r\n\r\n"Probably at the order of 2,000 who were actually in transit, and several more thousands who would\'ve been hoping to travel with us tonight," he said. "Obviously our highest priority tonight is to help those travelers who have not been able to complete their journeys."\r\n\r\nThe tunnel runs through England\'s Kent County and police there may have to implement "Operation Stack" -- in which trucks that are waiting to be shuttled through the tunnel would be lined up on the M20 highway. People who were planning on driving along that route are being asked to "delay or vary" their travel, according to the Kent police Web site.\r\n\r\nEurostar issued a statement Thursday night saying that service will be suspended Friday, and passengers holding tickets for Friday "are advised not to travel." Passengers can exchange their tickets for travel on a later date or get a refund. \r\n\r\nThose holding tickets for Saturday or Sunday travel should check Eurostar\'s Web site for updates, the company said.\r\n\r\nThe $15 billion undersea tunnel opened in 1994 and has drastically reduced land/sea travel time between Great Britain and mainland Europe.\r\n\r\nA massive fire broke out inside the tunnel in November 1996, causing structural damage but no serious injuries. A truck on a Eurotunnel lorry shuttle caught fire before the train entered the tunnel, and the fire spread to nearby cars.\r\n\r\nThat fire was caused by the vehicle\'s traction system and had "nothing to do with the cargo or the people," according to Colin Brown, director of engineering at the Institute of Mechanical Engineers.\r\n\r\n"It will be very interesting if we have the same issue, I doubt that we will," Brown told CNN. "My expectation is this will be a different issue."' , NULL , 2 , 1 , 5 , 5 , 0 , NULL , NULL , 'images/articles/small/news3.jpg' , NULL , 'images/articles/large/news3.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (3 , NULL , '2008-09-12 15:12:00' , NULL , 'Zimbabwe leaders said to agree to power-sharing deal' , NULL , NULL , NULL , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , 'A power-sharing deal has been reached between Zimbabwean President Robert Mugabe and the opposition Movement for Democratic Change, South African President Thabo Mbeki said.\r\n' , NULL , NULL , NULL , NULL , 0 , NULL , NULL , '2008-09-12 14:23:11' , NULL , NULL , 'A power-sharing deal has been reached between Zimbabwean President Robert Mugabe and the opposition Movement for Democratic Change, South African President Thabo Mbeki said.\r\n<br><br>\r\nMbeki, who mediated the talks in Harare for the Southern African Development Community, said the deal would be signed Monday but did not give details of the agreement.' , 'A power-sharing deal has been reached between Zimbabwean President Robert Mugabe and the opposition Movement for Democratic Change, South African President Thabo Mbeki said.\r\n\r\nMbeki, who mediated the talks in Harare for the Southern African Development Community, said the deal would be signed Monday but did not give details of the agreement.\r\n\r\nZimbabwe has had no Cabinet since the March presidential election that started the impasse.\r\n\r\nOpposition lawmakers booed and heckled Mugabe when he spoke at the opening of the country\'s parliament August 26.\r\n\r\nMDC leader Morgan Tsvangirai won the most votes in that election, but not enough to avoid a runoff, according to the government\'s official count.\r\n\r\nHe withdrew from the June 27 runoff days before the vote, saying Mugabe\'s supporters had waged a campaign of violence and intimidation against opposition supporters.\r\n\r\nThe main sticking point in the talks had been how much power Mugabe would retain.\r\n\r\nTsvangirai had said he would sign a deal only if Mugabe gave up some power and his presidency became a ceremonial position.\r\n\r\nUnited Nations Secretary-General Ban Ki-moon welcomed the agreement, according to a statement released by his spokesperson, and "hopes that this agreement will pave the way for a durable peace and recovery in the country and contribute to rapid improvement in the welfare and human rights of the people of Zimbabwe." \r\n\r\nThe country is also reeling from hyper-inflation. In August, the country\'s Central Statistical Office said inflation was at 11.2 million percent, the highest in the world.\r\n\r\nAnalysts have said the Zimbabwean government\'s official inflation rate figures are conservative.\r\n\r\nOne of Zimbabwe\'s leading banks, Kingdom Bank, said the country\'s inflation rate was more than 20 million percent.\r\n\r\nThe economic crisis has destroyed Zimbabwe\'s currency and made it difficult for Zimbabweans to buy basic commodities, electricity, fuel and medicines.' , NULL , 2 , 0 , 0 , 0 , 0 , NULL , NULL , 'images/articles/small/news2.jpg' , NULL , 'images/articles/large/news2.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (4 , NULL , '2008-09-12 15:20:00' , NULL , 'Russian bombers in Venezuela amid tension with U.S.' , NULL , NULL , NULL , NULL , 4 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , 'Two Russian bombers have landed at a Venezuelan airfield where they will carry out training flights for several days, the Russian defense ministry said Wednesday.' , NULL , NULL , NULL , NULL , 0 , NULL , NULL , '2008-09-12 14:14:39' , NULL , NULL , 'Two Russian bombers have landed at a Venezuelan airfield where they will carry out training flights for several days, the Russian defense ministry said Wednesday.\r\n<br><br>\r\nThe Tupolev Tu-160 strategic bombers landed at Venezuela\'s Libertador military airfield and "will spend several days carrying out training flights over neutral waters, after which they will return to the base," the ministry added.\r\n\r\n' , 'Two Russian bombers have landed at a Venezuelan airfield where they will carry out training flights for several days, the Russian defense ministry said Wednesday.\r\n\r\nThe Tupolev Tu-160 strategic bombers landed at Venezuela\'s Libertador military airfield and "will spend several days carrying out training flights over neutral waters, after which they will return to the base," the ministry added.\r\n\r\nNATO fighters followed the bombers on their 13-hour flight over the Arctic Ocean and the Atlantic, the defense ministry said.\r\n\r\nIt said the Russian flights were carried out in strict accordance with international rules governing airspace above neutral waters, and that the aircraft did not violate the borders of other states.\r\n\r\nPentagon spokesman Bryan Whitman said such joint exercises between nations are not unusual. "We exercise all around the globe and have joint exercises with countries all over the world. So do many other nations."\r\n\r\nThe U.S. will monitor the Russian-Venezuelan training, said Pentagon officials who asked not to be identified as they are not authorized to speak on the information.\r\n\r\nOn Monday, Russia announced it might hold joint naval maneuvers with Venezuela in the Caribbean.\r\n\r\nThe declaration came amid increased tension between Russia and the United States over Russia\'s invasion last month of the former Soviet republic of Georgia, a U.S. ally that aspires to join NATO. \r\n\r\nOn Monday Russia denied any link between that announcement and the conflict in Georgia, although Russia has criticized U.S. support for Georgia.\r\n\r\nRussia has also objected to the missile defense system agreement, signed between the United States and Poland and the Czech Republic in August, that places a ground-based ballistic defense facility in the two eastern European nations.\r\n\r\nRussia has said the deal threatens its security, while the United States has said that the system is to guard against rogue states such as Iran.\r\n\r\nEarlier this month, Venezuelan President Hugo Chavez, whose comments have frequently antagonized Washington, said it would welcome the Russian air force, according to Russian news agency Novosti.\r\n\r\n"If Russian long-range bombers should need to land in Venezuela, we would not object to that either. We will also welcome them," Chavez said on September 1, according to Novosti. \r\n' , NULL , 1 , 1 , 5 , 5 , 0 , NULL , NULL , 'images/articles/small/news1.jpg' , NULL , 'images/articles/large/news1.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (5 , NULL , '2005-06-10 15:25:00' , NULL , 'Image 1' , NULL , NULL , NULL , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '07.09.2005 11:46:56' , NULL , NULL , NULL , NULL , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , 'images/big/story1.jpg' , NULL , 'images/big/story1.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (6 , NULL , '2005-06-10 15:26:00' , NULL , 'Image 2' , NULL , NULL , NULL , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '07.09.2005 11:47:13' , NULL , NULL , NULL , NULL , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , 'images/big/story2.jpg' , NULL , 'images/big/story2.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (7 , NULL , '2005-06-10 15:27:00' , NULL , 'Image 3' , NULL , NULL , NULL , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 15:27:42' , '10.06.2005 15:27:42' , NULL , NULL , NULL , NULL , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , 'images/big/story3.jpg' , NULL , 'images/big/story3.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (8 , NULL , '2005-06-10 15:27:00' , NULL , 'Image 4' , NULL , NULL , NULL , NULL , 4 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 15:28:04' , '10.06.2005 15:28:04' , NULL , NULL , NULL , NULL , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , 'images/big/story4.jpg' , NULL , 'images/big/story4.jpg' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (9 , '' , NULL , NULL , 'Adele - Hello' , 'A' , NULL , '' , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Lyrics Online' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 1:54:43' , NULL , NULL , NULL , '<p>\r\n\r\n<span data-start="80" data-stop="85">\r\nHello, it\'s me<br>\r\n</span>\r\n<span data-start="86">\r\nI was wondering if after all these years<br>\r\nYou\'d like to meet, to go over everything<br>\r\n</span>\r\n<span data-start="97">\r\nThey say that time\'s supposed to heal ya<br>\r\nBut I ain\'t done much healing<br>\r\n</span>\r\n<span data-start="105" data-stop="110">\r\nHello, can you hear me?<br>\r\n</span>\r\n<span data-start="110" data-stop="122">\r\nI\'m in California dreaming about who we used to be<br>\r\nWhen we were younger and free<br>\r\n</span>\r\n<span data-start="122">\r\nI\'ve forgotten how it felt before the world fell at our feet<br>\r\nThere\'s such a difference between us<br>\r\n</span>\r\n<span data-start="134" data-stop="139">\r\nAnd a million miles<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="141">\r\nHello from the other side<br>\r\nI must\'ve called a thousand times<br>\r\n</span>\r\n<span data-start="152">\r\nTo tell you I\'m sorry, for everything that I\'ve done<br>\r\nBut when I call you never seem to be home<br>\r\n</span>\r\n<span data-start="165">\r\nHello from the outside<br>\r\nAt least I can say that I\'ve tried<br>\r\n</span>\r\n<span data-start="177" data-stop="191">\r\nTo tell you I\'m sorry, for breaking your heart<br>\r\nBut it don\'t matter, it clearly doesn\'t tear you apart anymore<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="195" data-stop="210">\r\nHello, how are you?<br>\r\n</span>\r\n<span data-start="201" data-stop="212">\r\nIt\'s so typical of me to talk about myself, I\'m sorry<br>\r\nI hope that you\'re well<br>\r\n</span>\r\n<span data-start="214">\r\nDid you ever make it out of that town<br>\r\nWhere nothing ever happened?<br>\r\n</span>\r\n<span data-start="220" data-stop="231">\r\nIt\'s no secret<br>\r\nThat the both of us are running out of time<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="232">\r\nSo hello from the other side<br>\r\nI must\'ve called a thousand times<br>\r\n</span>\r\n<span data-start="243">\r\nTo tell you I\'m sorry, for everything that I\'ve done<br>\r\nBut when I call you never seem to be home<br>\r\n</span>\r\n<span data-start="257">\r\nHello from the outside<br>\r\nAt least I can say that I\'ve tried<br>\r\n</span>\r\n<span data-start="268" data-stop="282">\r\nTo tell you I\'m sorry, for breaking your heart<br>\r\nBut it don\'t matter, it clearly doesn\'t tear you apart anymore<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="284" data-stop="294">\r\nOoooohh, anymore<br>\r\nOoooohh, anymore<br>\r\n</span>\r\n<span data-start="296" data-stop="304">\r\nOoooohh, anymore, anymore<br>\r\n</span>\r\n</p>\r\n\r\n\r\n<span data-start="305">\r\nHello from the other side<br>\r\nI must\'ve called a thousand times<br>\r\n</span>\r\n<span data-start="316">\r\nTo tell you I\'m sorry, for everything that I\'ve done<br>\r\nBut when I call you never seem to be home<br>\r\n</span>\r\n<span data-start="330">\r\nHello from the outside<br>\r\nAt least I can say that I\'ve tried<br>\r\n</span>\r\n<span data-start="341" data-stop="355">\r\nTo tell you I\'m sorry, for breaking your heart<br>\r\nBut it don\'t matter, it clearly doesn\'t tear you apart anymore<br><br><span><a href="http://www.minelyrics.com/adele-hello.html">Adele - Hello Lyrics</a></span><br></span>' , NULL , 1 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'YQHsXMglC9A' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (10 , '' , NULL , NULL , 'Avicii - For A Better Day' , 'A' , NULL , '' , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Song Texts' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 15:56:05' , '24.11.2015 1:58:07' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="Xq-knHXSKYY">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p><span data-start="9">\r\nPale on a caution wind<br>\r\nMeet the bleeding sky<br>\r\n</span>\r\n<span data-start="19">\r\nI called your name<br>\r\nThere was no one there<br>\r\n</span>\r\n<span data-start="26">\r\nAnd in cold and snow<br>\r\nI saw your face\r\n</span>\r\n</p>\r\n\r\n\r\n<p>\r\n<span data-start="33">\r\nAnd we sang the song for the little things<br>\r\nMagic call, but the joy you bring<br>\r\n</span>\r\n<span data-start="41">\r\nRunning it down the line<br>\r\nWish you could find that love is a fragile thing<br>\r\n</span>\r\n<span data-start="49">\r\nMagic call from a pretty thing<br>\r\nMaybe it might be time<br>\r\n</span>\r\n<span data-start="58" data-stop="76">\r\nFor a better day, for a better day<br>\r\nFor a better day\r\n</span>\r\n</p>\r\n\r\n\r\n<p>\r\n<span data-start="88">\r\nStraight, from the path of love<br>\r\nIn the road of life<br>\r\n</span>\r\n<span data-start="97">\r\nI tumble forward<br>\r\nBut going on, I\'mma keep it strong<br>\r\n</span>\r\n<span data-start="108">\r\nI saw your face\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="111">\r\nAnd we sang the song for the little thing<br>\r\nMagic call, but the joy you bring<br>\r\n</span>\r\n<span data-start="120">\r\nRunning it down the line<br>\r\nWish you could find that love is a fragile thing<br>\r\n</span>\r\n<span data-start="127">\r\nMagic call from a pretty thing<br>\r\nMaybe it might be time<br>\r\n</span>\r\n<span data-start="133" data-stop="164">\r\nFor a better day, for a better day, for a better day<br>\r\nFor a better day, for a better day, for a better day\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="166">\r\nAnd we sang the song for the little thing<br>\r\nMagic call, but the joy you bring<br>\r\n</span>\r\n<span data-start="173">\r\nRunning it down the line<br>\r\nWish you could find that love is a fragile thing<br>\r\n</span>\r\n<span data-start="180">\r\nMagic come from a pretty thing<br>\r\nMaybe it might be time<br>\r\n</span>\r\n<span data-start="187" data-stop="196">\r\nFor a better day... <br></span></p><p><br><span><a href="http://www.minelyrics.com/avicii-for-a-better-day.html">Avicii - For A Better Day Lyrics</a></span><span data-start="187" data-stop="196"></span></p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Xq-knHXSKYY' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (11 , '' , NULL , NULL , 'Beyonce - Halo' , 'B' , NULL , '' , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 1 , NULL , NULL , 'English Lyrics ' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:01:54' , NULL , NULL , NULL , '<p>\r\n<span data-start="24">\r\nRemember those walls I built?<br>\r\nOh, baby they\'re tumbling down<br>\r\n</span>\r\n<span data-start="30">\r\nAnd they didn\'t even put up a fight<br>\r\nThey didn\'t even make a sound<br>\r\n</span>\r\n<span data-start="36">\r\nI found a way to let you in<br>\r\nBut, I never really had a doubt<br>\r\n</span>\r\n<span data-start="42">\r\nStanding in the light of your halo<br>\r\nI got my angel now\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="49">\r\nIt\'s like I\'ve been awakened<br>\r\nEvery rule I had you breaking<br>\r\n</span>\r\n<span data-start="54">\r\nIt\'s the risk that I\'m taking<br>\r\nI ain\'t never gonna shut you out!\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="61">\r\nEverywhere I\'m looking now<br>\r\nI\'m surrounded by your embrace<br>\r\n</span>\r\n<span data-start="66">\r\nBaby, I can see your halo<br>\r\nYou know you\'re my saving grace<br>\r\n</span>\r\n<span data-start="72">\r\nYou\'re everything I need and more<br>\r\nIt\'s written all over your face<br>\r\n</span>\r\n<span data-start="79">\r\nBaby, I can feel your halo<br>\r\nPray it won\'t fade away\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="83">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo<br>\r\n</span>\r\n<span data-start="88">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo, ooh ooh...<br>\r\n</span>\r\n\r\n</p>\r\n\r\n<p>\r\n<span data-start="96">\r\nHit me like a ray of sun<br>\r\nBurning through my darkest night<br>\r\n</span>\r\n<span data-start="102">\r\nYou\'re the only one that I want<br>\r\nThink I\'m addicted to your light<br>\r\n</span>\r\n<span data-start="108">\r\nI swore I\'d never fall again<br>\r\nBut this don\'t even feel like falling<br>\r\n</span>\r\n<span data-start="115">\r\nGravity can\'t forget to pull me back to the ground again\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="120">\r\nAnd it\'s like I\'ve been awakened<br>\r\nEvery rule I had you breaking<br>\r\n</span>\r\n<span data-start="126">\r\nIt\'s the risk that I\'m taking<br>\r\nI\'m never gonna shut you out!\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="133">\r\nEverywhere I\'m looking now<br>\r\nI\'m surrounded by your embrace<br>\r\n</span>\r\n<span data-start="138">\r\nBaby, I can feel your halo<br>\r\nPray it won\'t fade away\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="144">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo<br>\r\n</span>\r\n<span data-start="149" data-stop="157">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo, ooh ooh...<br>\r\n</span>\r\n\r\n<span data-start="160" data-stop="180">\r\nHalo, ooh ooh...<br>\r\nHalo, ooh ooh, ooh, ooh, ooh, oh...\r\n</span></p>\r\n\r\n<p>\r\n<span data-start="183">\r\nEverywhere I\'m looking now<br>\r\nI\'m surrounded by your embrace<br>\r\n</span>\r\n<span data-start="189">\r\nBaby, I can see your halo<br>\r\nYou know you\'re my saving grace<br>\r\n</span>\r\n<span data-start="195">\r\nYou\'re everything I need and more<br>\r\nIt\'s written all over your face<br>\r\n</span>\r\n<span data-start="201">\r\nBaby, I can feel your halo<br>\r\nPray it won\'t fade away\r\n</span>\r\n</p>\r\n\r\n\r\n<span data-start="206">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo<br>\r\n</span>\r\n<span data-start="213">\r\nI can feel your halo, halo, halo<br>\r\nI can see your halo, halo, halo, ooh oh...<br><br><span><a href="http://www.minelyrics.com/beyonce-halo.html">Beyonce - Halo Lyrics</a></span><br></span>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'bnVUHWCynig' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (12 , '' , NULL , NULL , 'Coolio - Gangsta\'s Paradise' , 'C' , NULL , '' , NULL , 4 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Rap Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 15:56:48' , '24.11.2015 2:04:20' , NULL , NULL , NULL , '<p>\r\n<span data-start="11">\r\nAs I walk through the valley of the shadow of death<br>\r\nI take a look at my life and realize there\'s nothing left<br>\r\n</span>\r\n<span data-start="17.5">\r\n\'Cause I\'ve been blasting and laughing so long,<br>\r\nThat even my mama thinks that my mind is gone<br>\r\n</span>\r\n<span data-start="23">\r\nBut I ain\'t never crossed a man that didn\'t deserve it<br>\r\nMe be treated like a punk you know that\'s unheard of<br>\r\n</span>\r\n<span data-start="29">\r\nYou better watch how you\'re talking and where you\'re walking<br>\r\nOr you and your homies might be lined in chalk<br>\r\n</span>\r\n<span data-start="35">\r\nI really hate to trip but I gotta loc<br>\r\nAs they croak, I see myself in the pistol smoke, fool<br>\r\n</span>\r\n<span data-start="42">\r\nI\'m the kinda G the little homies wanna be like<br>\r\nOn my knees in the night saying prayers in the streetlight\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="48">\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\n</span>\r\n<span data-start="59">\r\nKeep spending most our lives, living in the gangsta\'s paradise<br>\r\nKeep spending most our lives, living in the gangsta\'s paradise\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="71">\r\nLook at the situation they got me facing<br>\r\nI can\'t live a normal life, I was raised by the streets<br>\r\n</span>\r\n<span data-start="77.5">\r\nSo I gotta be down with the hood team<br>\r\nToo much television watching got me chasing dreams<br>\r\n</span>\r\n<span data-start="83">\r\nI\'m an educated fool with money on my mind<br>\r\nGot my ten in my hand and a gleam in my eye<br>\r\n</span>\r\n<span data-start="89">\r\nI\'m a loc\'d out gangsta set tripping banger<br>\r\nAnd my homies is down so don\'t arouse my anger, fool<br>\r\n</span>\r\n<span data-start="95.5">\r\nDeath ain\'t nothing but a heartbeat away,<br>\r\nI\'m living life, do or die, what can I say<br>\r\n</span>\r\n<span data-start="101">\r\nI\'m twenty three now, but will I live to see twenty four<br>\r\nThe way things are going I don\'t know\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="107">\r\nTell me why are we so blind to see<br>\r\nThat the ones we hurt are you and me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="119">\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\n</span>\r\n<span data-start="131">\r\nKeep spending most our lives, living in the gangsta\'s paradise<br>\r\nKeep spending most our lives, living in the gangsta\'s paradise\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="143">\r\nPower and the money, money and the power<br>\r\nMinute after minute, hour after hour<br>\r\n</span>\r\n<span data-start="149">\r\nEverybody\'s running, but half of them ain\'t looking<br>\r\nWhat\'s going on in the kitchen, but I don\'t know what\'s cooking<br>\r\n</span>\r\n<span data-start="155.5">\r\nThey say I gotta learn, but nobody\'s here to teach me<br>\r\nIf they can\'t understand it, how can they reach me<br>\r\n</span>\r\n<span data-start="162">\r\nI guess they can\'t, I guess they won\'t<br>\r\nI guess they front, that\'s why I know my life is out of luck, fool\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="168">\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\nBeen spending most their lives, living in the gangsta\'s paradise<br>\r\n</span>\r\n<span data-start="179">\r\nKeep spending most our lives, living in the gangsta\'s paradise<br>\r\nKeep spending most our lives, living in the gangsta\'s paradise\r\n</span>\r\n</p>\r\n\r\n\r\n<span data-start="190">\r\nTell me why are we so blind to see<br>\r\nThat the ones we hurt are you and me<br>\r\n</span>\r\n<span data-start="202" data-stop="215">\r\nTell me why are we so blind to see<br>\r\nThat the ones we hurt are you and me<br><br><span><a href="http://www.minelyrics.com/coolio-gangstas-paradise.html">Coolio - Gangsta\'s Paradise Lyrics</a></span><br></span>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'n24EGOE4Ikw' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (13 , '' , NULL , NULL , 'Eagles - Hotel California' , 'E' , NULL , '' , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , '<br>' , 'Online Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 15:57:49' , '24.11.2015 1:49:52' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="lrfhf1Gv4Tw">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="90">\r\nOn a dark desert highway, cool wind in my hair<br>\r\nWarm smell of colitas, rising up through the air<br>\r\n</span>\r\n<span data-start="103">\r\nUp ahead in the distance, I saw a shimmering light<br>\r\nMy head grew heavy and my sight grew dim<br>\r\n</span>\r\n<span data-start="113">\r\nI had to stop for the night<br>\r\nThere she stood in the doorway;<br>\r\n</span>\r\n<span data-start="119">\r\nI heard the mission bell<br>\r\nAnd I was thinking to myself,<br>\r\n</span>\r\n<span data-start="124">\r\n"This could be Heaven or this could be Hell"<br>\r\nThen she lit up a candle and she showed me the way<br>\r\n</span>\r\n<span data-start="135">\r\nThere were voices down the corridor,<br>\r\nI thought I heard them say...\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="142">\r\nWelcome to the Hotel California<br>\r\nSuch a lovely place (Such a lovely place)<br>\r\nSuch a lovely face<br>\r\n</span>\r\n<span data-start="154">\r\nPlenty of room at the Hotel California<br>\r\nAny time of year (Any time of year)<br>\r\nYou can find it here\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="167">\r\nHer mind is Tiffany-twisted, she got the Mercedes bends<br>\r\nShe got a lot of pretty, pretty boys she calls friends<br>\r\n</span>\r\n<span data-start="180">\r\nHow they dance in the courtyard, sweet summer sweat.<br>\r\nSome dance to remember, some dance to forget\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="193">\r\nSo I called up the Captain,<br>\r\n"Please bring me my wine"<br>\r\n</span>\r\n<span data-start="199">\r\nHe said, "We haven\'t had that spirit here since nineteen sixty nine"<br>\r\n</span>\r\n<span data-start="206">\r\nAnd still those voices are calling from far away,<br>\r\nWake you up in the middle of the night<br>\r\nJust to hear them say...\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="219">\r\nWelcome to the Hotel California<br>\r\nSuch a lovely place (Such a lovely place)<br>\r\nSuch a lovely face<br>\r\n</span>\r\n<span data-start="231">\r\nThey livin\' it up at the Hotel California<br>\r\nWhat a nice surprise (what a nice surprise)<br>\r\nBring your alibis\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="244">\r\nMirrors on the ceiling,<br>\r\nThe pink champagne on ice<br>\r\n</span>\r\n<span data-start="250">\r\nAnd she said "We are all just prisoners here, of our own device"<br>\r\n</span>\r\n<span data-start="258">\r\nAnd in the master\'s chambers,<br>\r\nThey gathered for the feast<br>\r\n</span>\r\n<span data-start="263">\r\nThey stab it with their steely knives,<br>\r\nBut they just can\'t kill the beast\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="270">\r\nLast thing I remember, I was<br>\r\nRunning for the door<br>\r\n</span>\r\n<span data-start="276">\r\nI had to find the passage back<br>\r\nTo the place I was before<br>\r\n</span>\r\n<span data-start="283">\r\n"Relax, " said the night man,<br>\r\n"We are programmed to receive.<br>\r\n</span>\r\n<span data-start="289" data-stop="297">\r\nYou can check-out any time you like,<br>\r\nBut you can never leave! " <br></span></p><p><span><a href="http://www.minelyrics.com/eagles-hotel-california.html">Eagles - Hotel California Lyrics</a></span><br><span><a href="http://www.minelyrics.com/eagles-hotel-california.html" alt="Eagles - Hotel California Lyrics"></a></span><span data-start="289" data-stop="297"></span></p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'lrfhf1Gv4Tw' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (14 , '' , NULL , NULL , 'Enrique Iglesias - Hero' , 'E' , NULL , '' , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 1 , NULL , NULL , 'Song Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 1:51:58' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="koJlIGDImiU">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\nLet me be your hero\r\n</p>\r\n\r\n<p>\r\nWould you dance if I asked you to dance?<br>\r\nWould you run and never look back?<br>\r\nWould you cry if you saw me crying?<br>\r\nWould you save my soul tonight?\r\n</p>\r\n\r\n<p>\r\nWould you tremble if I touched your lips?<br>\r\nWould you laugh? Oh, please tell me this.<br>\r\nNow would you die for the one you love?<br>\r\nHold me in your arms, tonight.\r\n</p>\r\n\r\n<p>\r\nI can be your hero, baby.<br>\r\nI can kiss away the pain.<br>\r\nI will stand by you forever.<br>\r\nYou can take my breath away.\r\n</p>\r\n\r\n<p>\r\nWould you swear that you\'ll always be mine?<br>\r\nWould you lie? Would you run and hide?<br>\r\nAm I in too deep? Have I lost my mind?<br>\r\nI don\'t care. You\'re here tonight.\r\n</p>\r\n\r\n<p>\r\nI can be your hero, baby.<br>\r\nI can kiss away the pain.<br>\r\nI will stand by you forever.<br>\r\nYou can take my breath away.\r\n</p>\r\n\r\n<p>\r\nOh, I just want to hold you.<br>\r\nI just want to hold you, oh, yeah.\r\n</p>\r\n\r\n<p>\r\nAm I in too deep? Have I lost my mind?<br>\r\nWell, I don\'t care. You\'re here tonight.\r\n</p>\r\n\r\n<p>\r\nI can be your hero, baby.<br>\r\nI can kiss away the pain, oh, yeah.<br>\r\nI will stand by you forever.<br>\r\nYou can take my breath away.\r\n</p>\r\n\r\n<p>\r\n(I can be your hero, baby)<br>\r\nI can be your hero.<br>\r\nI can kiss away the pain.<br>\r\nAnd I will stand by you forever.<br>\r\nYou can take my breath away.<br>\r\nYou can take my breath away.\r\n</p>\r\n\r\n<p>\r\nI can be your hero. <br></p><p><br><span><a href="http://www.minelyrics.com/enrique-iglesias-hero.html">Enrique Iglesias - Hero Lyrics</a></span></p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'koJlIGDImiU' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (15 , '' , NULL , NULL , 'Hozier - Take Me To Church' , 'H' , NULL , '' , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Online Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 15:58:40' , '24.11.2015 1:53:10' , NULL , NULL , NULL , '<span data-start="0">My lover\'s got humour<br>\r\nShe\'s the giggle at a funeral<br>\r\n</span>\r\n<span data-start="5">\r\nKnows everybody\'s disapproval<br>\r\nI should\'ve worshipped her sooner<br>\r\n</span>\r\n<br>\r\n<span data-start="11">\r\nIf the heavens ever did speak<br>\r\nShe\'s the last true mouthpiece<br>\r\n</span>\r\n<span data-start="17">\r\nEvery Sunday\'s getting more bleak<br>\r\nA fresh poison each week<br>\r\n</span>\r\n<br>\r\n<span data-start="23">\r\n"We were born sick," you heard them say it<br>\r\nMy church offers no absolutes<br>\r\n</span>\r\n<span data-start="29">\r\nShe tells me, "Worship in the bedroom."<br>\r\nThe only heaven I\'ll be sent to<br>\r\n</span>\r\n<span data-start="35">\r\nIs when I\'m alone with you<br>\r\nI was born sick<br>\r\n</span>\r\n<span data-start="40">\r\nBut I love it<br>\r\nCommand me to be well<br>\r\n</span>\r\n<span data-start="44" data-stop="55">\r\nAaay. Amen. Amen. Amen.<br>\r\n</span>\r\n\r\n<p>\r\n<span data-start="56">\r\nTake me to church<br></span>\r\n<span data-start="58">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins and you can sharpen your knife<br></span>\r\n<span data-start="65" data-stop="69.5">\r\nOffer me that deathless death<br>\r\nGood God, let me give you my life<br></span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="70">\r\nTake me to church<br></span>\r\n<span data-start="72">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins and you can sharpen your knife<br></span>\r\n<span data-start="80" data-stop="85.5">\r\nOffer me that deathless death<br>\r\nGood God, let me give you my life<br></span>\r\n</p>\r\n\r\n<br>\r\n<span data-start="87">\r\nIf I\'m a pagan of the good times<br>\r\nMy lover\'s the sunlight<br>\r\n</span>\r\n<span data-start="92">\r\nTo keep the Goddess on my side<br>\r\nShe demands a sacrifice<br>\r\n</span>\r\n<br>\r\n<span data-start="98">\r\nDrain the whole sea<br>\r\nGet something shiny<br>\r\n</span>\r\n<span data-start="102">\r\nSomething meaty for the main course<br>\r\nThat\'s a fine-looking high horse<br>\r\n</span>\r\n<span data-start="107">\r\nWhat you got in the stable?<br>\r\nWe\'ve a lot of starving faithful<br>\r\n</span>\r\n\r\n<p>\r\n<span data-start="113">\r\nThat looks tasty<br>\r\nThat looks plenty<br>\r\nThis is hungry work<br>\r\n</span>\r\n</p>\r\n\r\n\r\n<p>\r\n<span data-start="119">\r\nTake me to church<br>\r\n</span>\r\n<span data-start="121">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins so you can sharpen your knife<br>\r\n</span>\r\n<span data-start="128" data-stop="133.8">\r\nOffer me my deathless death<br>\r\nGood God, let me give you my life<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="134">\r\nTake me to church<br>\r\n</span>\r\n<span data-start="136">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins so you can sharpen your knife<br>\r\n</span>\r\n<span data-start="143" data-stop="149">\r\nOffer me my deathless death<br>\r\nGood God, let me give you my life<br>\r\n</span>\r\n</p>\r\n\r\n<br>\r\n<span data-start="150">\r\nNo Masters or Kings<br>\r\nWhen the Ritual begins<br>\r\n</span>\r\n<span data-start="157">\r\nThere is no sweeter innocence than our gentle sin<br>\r\nIn the madness and soil of that sad earthly scene<br>\r\n</span>\r\n<span data-start="172">\r\nOnly then I am human<br>\r\nOnly then I am clean<br>\r\n</span>\r\n<span data-start="180">\r\nOoh oh. Amen. Amen. Amen.<br>\r\n</span>\r\n\r\n<p>\r\n<span data-start="196">\r\nTake me to church<br>\r\n</span>\r\n<span data-start="198">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins and you can sharpen your knife<br>\r\n</span>\r\n<span data-start="206" data-stop="210.9">\r\nOffer me that deathless death<br>\r\nGood God, let me give you my life\r\n</span>\r\n</p>\r\n\r\n\r\n\r\n<p>\r\n<span data-start="211">\r\nTake me to church<br>\r\n</span>\r\n<span data-start="213">\r\nI\'ll worship like a dog at the shrine of your lies<br>\r\nI\'ll tell you my sins and you can sharpen your knife<br>\r\n</span>\r\n<span data-start="220" data-stop="227">\r\nOffer me that deathless death<br>\r\nGood God, let me give you my life <br></span></p><p><span data-start="220" data-stop="227"><span><a href="http://www.minelyrics.com/hozier-take-me-to-church.html">Hozier - Take Me To Church Lyrics</a></span><br></span>\r\n</p>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'MYSVMgRr6pw' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (16 , '' , NULL , NULL , 'Justin Timberlake - Mirrors' , 'J' , NULL , '' , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Pop Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 15:59:41' , '24.11.2015 2:11:53' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="uuZE_IRwLNI">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="29">\r\nAren\'t you something to admire?<br>\r\nCause your shine is something like a mirror<br>\r\n</span>\r\n<span data-start="35">\r\nAnd I can\'t help but notice<br>\r\nYou reflect in this heart of mine<br>\r\n</span>\r\n<span data-start="39">\r\nIf you ever feel alone and<br>\r\nThe glare makes me hard to find<br>\r\n</span>\r\n<span data-start="47">\r\nJust know that I\'m always parallel on the other side\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="53">\r\nCause with your hand in my hand and a pocket full of soul<br>\r\nI can tell you there\'s no place we couldn\'t go<br>\r\n</span>\r\n<span data-start="59">\r\nJust put your hand on the glass<br>\r\nI\'ll be trying to pull you through you just gotta be strong<br>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="65">\r\nCause I don\'t wanna lose you now<br>\r\nI\'m looking right at the other half of me<br>\r\n</span>\r\n<span data-start="71">\r\nThe vacancy that sat in my heart<br>\r\nIs a space that now you hold<br>\r\n</span>\r\n<span data-start="77">\r\nShow me how to fight for now<br>\r\nAnd I\'ll tell you, baby, it was easy<br>\r\n</span>\r\n<span data-start="83">\r\nComing back here to you once I figured it out<br>\r\nYou were right here all along\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="90">\r\nIt\'s like you\'re my mirror<br>\r\nMy mirror staring back at me<br>\r\n</span>\r\n<span data-start="96">\r\nI couldn\'t get any bigger<br>\r\nWith anyone else beside of me<br>\r\n</span>\r\n<span data-start="102">\r\nAnd now it\'s clear as this promise<br>\r\nThat we\'re making two reflections into one<br>\r\n</span>\r\n<span data-start="110">\r\nCause it\'s like you\'re my mirror<br>\r\nMy mirror staring back at me, staring back at me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="116">\r\nAren\'t you something, an original<br>\r\nCause it doesn\'t seem merely assembled<br>\r\n</span>\r\n<span data-start="122">\r\nAnd I can\'t help but stare, cause<br>\r\nI see truth somewhere in your eyes<br>\r\n</span>\r\n<span data-start="127">\r\nI can\'t ever change without you<br>\r\nYou reflect me, I love that about you<br>\r\n</span>\r\n<span data-start="135">\r\nAnd if I could, I would look at us all the time\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="140">\r\nCause with your hand in my hand and a pocket full of soul<br>\r\nI can tell you there\'s no place we couldn\'t go<br>\r\n</span>\r\n<span data-start="147">\r\nJust put your hand on the glass<br>\r\nI\'ll be trying to pull you through<br>\r\nYou just gotta be strong\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="153">\r\nCause I don\'t wanna lose you now<br>\r\nI\'m looking right at the other half of me<br>\r\n</span>\r\n<span data-start="159">\r\nThe vacancy that sat in my heart<br>\r\nIs a space that now you hold<br>\r\n</span>\r\n<span data-start="165">\r\nShow me how to fight for now<br>\r\nAnd I\'ll tell you, baby, it was easy<br>\r\n</span>\r\n<span data-start="171">\r\nComing back into you once I figured it out<br>\r\nYou were right here all along\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="178">\r\nIt\'s like you\'re my mirror<br>\r\nMy mirror staring back at me<br>\r\n</span>\r\n<span data-start="184">\r\nI couldn\'t get any bigger<br>\r\nWith anyone else beside of me<br>\r\n</span>\r\n<span data-start="190">\r\nAnd now it\'s clear as this promise<br>\r\nThat we\'re making two reflections into one<br>\r\n</span>\r\n<span data-start="196">\r\nCause it\'s like you\'re my mirror<br>\r\nMy mirror staring back at me, staring back at me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="204">\r\nYesterday is history<br>\r\nTomorrow\'s a mystery<br>\r\n</span>\r\n<span data-start="217">\r\nI can see you looking back at me<br>\r\nKeep your eyes on me<br>\r\nBaby, keep your eyes on me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="228">\r\nCause I don\'t wanna lose you now<br>\r\nI\'m looking right at the other half of me<br>\r\n</span>\r\n<span data-start="234">\r\nThe vacancy that sat in my heart<br>\r\nIs a space that now you hold<br>\r\n</span>\r\n<span data-start="240">\r\nShow me how to fight for now (please show me, baby)<br>\r\nI\'ll tell you, baby, it was easy<br>\r\n</span>\r\n<span data-start="245">\r\nComing back into you once I figured it out<br>\r\nYou were right here all along\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="253">\r\nIt\'s like you\'re my mirror<br>\r\nMy mirror staring back at me<br>\r\n</span>\r\n<span data-start="259">\r\nI couldn\'t get any bigger<br>\r\nWith anyone else beside of me<br>\r\n</span>\r\n<span data-start="265">\r\nAnd now it\'s clear as this promise<br>\r\nThat we\'re making two reflections into one<br>\r\n</span>\r\n<span data-start="271" data-stop="280">\r\nCause it\'s like you\'re my mirror<br>\r\nMy mirror staring back at me, staring back at me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="325">\r\nYou are, you are the love of my life <i>[x10]</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="359">\r\nNow you\'re the inspiration of this precious song<br>\r\nAnd I just wanna see your face light up since you put me on<br>\r\n</span>\r\n<span data-start="371">\r\nSo now I say goodbye to the old me, it\'s already gone<br>\r\nAnd I can\'t wait wait wait wait wait to get you home<br>\r\n</span>\r\n<span data-start="382">\r\nJust to let you know, you are\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="387">\r\nYou are, you are the love of my life <i>[x8]</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="409">\r\nGirl you\'re my reflection, all I see is you<br>\r\nMy reflection, in everything I do<br>\r\n</span>\r\n<span data-start="421">\r\nYou\'re my reflection and all I see is you<br>\r\nMy reflection, in everything I do\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="435" data-stop="489">\r\nYou are, you are the love of my life <i>[x16]</i></span></p><p><span data-start="435" data-stop="489"><i><span><a href="http://www.minelyrics.com/justin-timberlake-mirrors.html">Justin Timberlake - Mirrors Lyrics</a></span><br></i>\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'uuZE_IRwLNI' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (17 , '' , NULL , NULL , 'Katy Perry - Dark Horse' , 'K' , NULL , '' , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 1 , NULL , NULL , 'Lyrics English' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:16:29' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="0KSOMA3QBU0">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="4" data-stop="7">\r\nOh, no.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Juicy J]</i><br>\r\n<span data-start="9">\r\nYeah<br>\r\nYa\'ll know what it is<br>\r\n</span>\r\n<span data-start="12">\r\nKaty Perry<br>\r\nJuicy J, aha.<br>\r\nLet\'s rage\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Katy Perry]</i><br>\r\n<span data-start="19">\r\nI knew you were<br>\r\nYou were gonna come to me<br>\r\n</span>\r\n<span data-start="22">\r\nAnd here you are<br>\r\nBut you better choose carefully<br>\r\n</span>\r\n<span data-start="26">\r\nCause I, Im capable of anything<br>\r\nOf anything and everything\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="33">\r\nMake me your Aphrodite<br>\r\nMake me your one and only<br>\r\n</span>\r\n<span data-start="40">\r\nBut dont make me your enemy, your enemy, your enemy\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="49">\r\nSo you wanna play with magic<br>\r\nBoy, you should know what you\'re falling for<br>\r\n</span>\r\n<span data-start="56">\r\nBaby do you dare to do this?<br>\r\nCause Im coming at you like a dark horse<br>\r\n</span>\r\n<span data-start="64">\r\nAre you ready for, ready for<br>\r\nA perfect storm, perfect storm<br>\r\n</span>\r\n<span data-start="71" data-stop="77">\r\nCause once youre mine, once youre mine<br>\r\nTheres no going back\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="84">\r\nMark my words<br>\r\nThis love will make you levitate<br>\r\n</span>\r\n<span data-start="88">\r\nLike a bird<br>\r\nLike a bird without a cage<br>\r\n</span>\r\n<span data-start="91">\r\nBut down to earth<br>\r\nIf you choose to walk away, dont walk away\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="98">\r\nIts in the palm of your hand now baby<br>\r\nIts a yes or no, no maybe<br>\r\n</span>\r\n<span data-start="106">\r\nSo just be sure before you give it all to me<br>\r\nAll to me, give it all to me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="114">\r\nSo you wanna play with magic<br>\r\nBoy, you should know what you\'re falling for<br>\r\n</span>\r\n<span data-start="121">\r\nBaby do you dare to do this?<br>\r\nCause Im coming at you like a dark horse<br>\r\n</span>\r\n<span data-start="130">\r\nAre you ready for, ready for<br>\r\nA perfect storm, perfect storm<br>\r\n</span>\r\n<span data-start="136">\r\nCause once youre mine, once youre mine (love trippin\')<br>\r\nTheres no going back\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Juicy J]</i><br>\r\n<span data-start="143">\r\nUh<br>\r\nShes a beast<br>\r\nI call her Karma (come back)<br>\r\n</span>\r\n<span data-start="147">\r\nShe eats your heart out<br>\r\nLike Jeffrey Dahmer (woo)<br>\r\nBe careful<br>\r\n</span>\r\n<span data-start="151">\r\nTry not to lead her on<br>\r\nShortys heart is on steroids<br>\r\nCause her love is so strong<br>\r\n</span>\r\n<span data-start="157">\r\nYou may fall in love<br>\r\nWhen you meet her<br>\r\n</span>\r\n<span data-start="158">\r\nIf you get the chance you better keep her<br>\r\nShe\'s sweet as pie but if you break her heart<br>\r\n</span>\r\n<span data-start="162">\r\nShe\'ll turn cold as a freezer<br>\r\nThat fairy tale ending with a knight in shining armor<br>\r\n</span>\r\n<span data-start="167">\r\nShe can be my Sleeping Beauty<br>\r\nIm gon put her in a coma<br>\r\nWoo!<br>\r\n</span>\r\n<span data-start="171">\r\nDamn I think I love her<br>\r\nShorty so bad, Im sprung and I dont care<br>\r\n</span>\r\n<span data-start="174">\r\nShe ride me like a roller coaster<br>\r\nTurned the bedroom into a fair (a fair!)<br>\r\n</span>\r\n<span data-start="178">\r\nHer love is like a drug<br>\r\nI was tryna hit it and quit it<br>\r\n</span>\r\n<span data-start="182">\r\nBut lil\' mama so dope<br>\r\nI messed around and got addicted\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Katy Perry]</i><br>\r\n<span data-start="187">\r\nSo you wanna play with magic<br>\r\nBoy, you should know what you\'re falling for (you should know)<br>\r\n</span>\r\n<span data-start="194">\r\nBaby do you dare to do this?<br>\r\nCause Im coming at you like a dark horse (like a dark horse)<br>\r\n</span>\r\n<span data-start="202">\r\nAre you ready for, ready for (ready for)<br>\r\nA perfect storm, perfect storm (a perfect storm)<br>\r\n</span>\r\n<span data-start="209" data-stop="216">\r\nCause once youre mine, once youre mine (mine)<br>\r\nTheres no going back <br></span></p><p><br><span><a href="http://www.minelyrics.com/katy-perry-dark-horse.html">Katy Perry - Dark Horse Lyrics</a></span><span data-start="209" data-stop="216"></span></p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '0KSOMA3QBU0' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (18 , '' , NULL , NULL , 'Lana Del Rey - High By The Beach' , 'L' , NULL , '' , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , '10.06.2005 16:00:27' , '24.11.2015 2:17:48' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="QnxpHIl5Ynw">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="40">\r\nBoy, look at you, looking at me<br>\r\nI know you know how I feel<br>\r\n</span>\r\n<span data-start="49">\r\nLoving you is hard, being here is harder<br>\r\nYou take the wheel<br>\r\n</span>\r\n<span data-start="56">\r\nI don\'t wanna do this anymore<br>\r\nIt\'s so surreal, I can\'t survive<br>\r\n</span>\r\n<span data-start="67">\r\nIf this is all that\'s real\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="70">\r\nAll I wanna do is get high by the beach<br>\r\nGet high by the beach, get high<br>\r\n</span>\r\n<span data-start="76">\r\nAll I wanna do is get by by the beach<br>\r\nGet by baby, baby, bye, bye<br>\r\n</span>\r\n<span data-start="84">\r\nThe truth is I never<br>\r\nBought into your bullshit<br>\r\n</span>\r\n<span data-start="88">\r\nWhen you would pay tribute to me<br>\r\nCause I know that<br>\r\n</span>\r\n<span data-start="92">\r\nAll I wanted to do is get high by the beach<br>\r\nGet high baby, baby, bye, bye\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="98">\r\nBoy look at you, looking at me<br>\r\nI know you don\'t understand<br>\r\n</span>\r\n<span data-start="106">\r\nYou could be a bad motherfucker<br>\r\nBut that don\'t make you a man<br>\r\n</span>\r\n<span data-start="114">\r\nNow you\'re just another one of my problems<br>\r\nBecause you got out of hand<br>\r\n</span>\r\n<span data-start="122">\r\nWe won\'t survive<br>\r\nWe\'re sinking into the sand\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="128">\r\nAll I wanna do is get high by the beach<br>\r\nGet high by the beach, get high<br>\r\n</span>\r\n<span data-start="134">\r\nAll I wanna do is get by by the beach<br>\r\nGet by baby, baby, bye, bye<br>\r\n</span>\r\n<span data-start="142">\r\nThe truth is I never<br>\r\nBought into your bullshit<br>\r\n</span>\r\n<span data-start="146">\r\nWhen you would pay tribute to me<br>\r\nCause I know that<br>\r\n</span>\r\n<span data-start="150">\r\nAll I wanted to do is get high by the beach<br>\r\nGet high baby, baby, bye, bye\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="156">\r\nLights, camera, accin<br>\r\nI\'ll do it on my own<br>\r\n</span>\r\n<span data-start="165">\r\nDon\'t need your money, money<br>\r\nTo get me what I want<br>\r\n</span>\r\n<span data-start="171">\r\nLights camera accin<br>\r\nI\'ll do it on my own<br>\r\n</span>\r\n<span data-start="180" data-stop="185">\r\nDon\'t need your money, money<br>\r\nTo get me what I want\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="206">\r\nAll I wanna do is get high by the beach<br>\r\nGet high by the beach, get high<br>\r\n</span>\r\n<span data-start="212">\r\nAll I wanna do is get by by the beach<br>\r\nGet by baby, baby, bye, bye<br>\r\n</span>\r\n<span data-start="219">\r\nThe truth is I never<br>\r\nBought into your bullshit<br>\r\n</span>\r\n<span data-start="224">\r\nWhen you would pay tribute to me<br>\r\nCause I know that<br>\r\n</span>\r\n<span data-start="228" data-stop="235">\r\nAll I wanted to do is get high by the beach<br>\r\nGet high baby, baby, bye, bye\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="235" data-stop="262">\r\nHigh-igh-igh-igh, high-igh-igh-igh<br>\r\nHigh-igh-igh-igh, high-igh-igh-igh\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="264">\r\nEveryone can start again<br>\r\nNot through love but through revenge<br>\r\n</span>\r\n<span data-start="271" data-stop="279">\r\nThrough the fire, we\'re born again<br>\r\nPeace by vengeance brings the end <br></span></p><p><span data-start="271" data-stop="279"><span><a href="http://www.minelyrics.com/lana-del-rey-high-by-the-beach.html">Lana Del Rey - High By The Beach Lyrics</a></span><br></span>\r\n\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'QnxpHIl5Ynw' , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (19 , NULL , '2005-06-10 17:18:00' , NULL , 'PHP Applications gathering ' , NULL , NULL , NULL , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:18:26' , '10.06.2005 17:18:26' , NULL , NULL , 'The PHP Quebec Conference team is looking for the best software developed with PHP, MySQL and Apache. Each proposal received by April 29th 29 will be will be reviewed by an experts and members of the PHP Quebec community. ' , 'The PHP Quebec Conference team is looking for the best software developed with PHP, MySQL and Apache. Each proposal received by April 29th 29 will be will be reviewed by an experts and members of the PHP Quebec community. \r\n\r\nThe most useful software will be included on the 2005 PHP Quebec Conference CDROM along with over 25 hours of conference which where given by the leaders behind PHP, MySQL and Apache, as well as regional and international experts at the 2005 PHP Quebec conference. ' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (20 , NULL , '2005-06-10 17:18:00' , NULL , 'MySQL, RedHat and other partners started a new campaign against software patents' , NULL , NULL , NULL , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:19:00' , '10.06.2005 17:19:00' , NULL , NULL , 'In order to boost more awareness of the pending software patent issues in the European UnionMySQL, ISP 1&1, RedHat and other partners started a new portal "http://nosoftwarepatents.com". The site is available in 10 different european languages and explains why software patents are bad, and how they might affect you. ' , 'Under the influence of the patent system and big industry lobbyists, the European Union is on the verge of making a huge mistake: to pass a law that would legalize software patents. \r\n\r\nIf that happens, you will pay dearly. Europe\'s software industry will fall victim to unscrupulous extortioners. A cartel of large corporations will crush smaller competitors. Consequently, we will all pay more money for less good and less secure software. You personally, your household, your company, your government, all of us. \r\n\r\nYou\'ll know when you get the bill. When someone breaks into your computer, reads your E-mails, and steals the password of your bank account. When your computer crashes every day. When spam doesn\'t stop. When prices go up and companies shut down. When people lose their jobs. \r\n\r\n"Chances are that patents on software, common practice in the US and on the brink of being legalised in Europe, in fact stifle innovation. Europe could still alter course." \r\nDeutsche Bank Research \r\n\r\nWithout software patents, Europe could save costs, foster innovation, enhance security, and create jobs. Thanks to Linux and other open-source software, Europe has the chance to gain independence from Microsoft and other large American companies. However, if the EU allows software patents, then that\'s the beginning of the end for Linux. Not only for Linux. It\'s just a prominent example' , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (21 , NULL , '2005-06-10 17:19:00' , NULL , 'PHP Quebec 2005: PHP - MySQL - Apache ' , NULL , NULL , NULL , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:19:19' , '10.06.2005 17:19:19' , NULL , NULL , 'PHP Quebec is proud to present an extended conference in Montreal, Quebec, covering the latest innovations in PHP, MySQL and Apache.' , 'PHP Quebec is proud to present an extended conference in Montreal, Quebec, covering the latest innovations in PHP, MySQL and Apache. From March 30th until April 1st, major AMP contributors will talk about Security, Web Services, PHP 5 and great achievements with PHP in North America. The 4 tracks are available at the PHP Quebec site. \r\n\r\nPHP Certification exams by Zend are included with every admission ticket to the conference. The certification center will also provide MySQL and Linux certification from MySQL AB, LPI and Savoir Faire Linux. The examination center is open to everyone. ' , NULL , 1 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (22 , NULL , '2005-06-10 17:27:28' , NULL , 'What is eShopping? ' , NULL , NULL , NULL , NULL , 1 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:27:28' , '10.06.2005 17:27:28' , NULL , NULL , NULL , 'eShopping contains sites of which the primary focus is to allow the consumer to select and obtain goods and services over the Web. Common examples include: \r\nIntegrated online shopping-cart systems that allow the user to order directly over the Web \r\nOnline shopping-cart systems that allow the user to generate an order form to be sent to the merchant via fax or snail-mail \r\nSimple directories of products and prices that the user can order via mail or phone. \r\nThe key is that the site contains three elements: lists of products for sale, prices, and information on how the consumer can obtain the product from their own h\r\n' , NULL , 4 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (23 , NULL , '2005-06-10 17:28:21' , NULL , 'How to Shop at Our Online Store?' , NULL , NULL , NULL , NULL , 2 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:28:21' , '10.06.2005 17:28:21' , NULL , NULL , NULL , 'Read online help please. See Help Section' , NULL , 3 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (24 , NULL , '2005-06-10 17:29:09' , NULL , 'I\'ve received an error message stating that my credit card is invalid. What should I do?' , NULL , NULL , NULL , NULL , 3 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:29:09' , '10.06.2005 17:29:09' , NULL , NULL , NULL , 'If you see an error message stating that your credit card is invalid, this has most likely happened for one of the following reasons: \r\n1. You have incorrectly entered your credit card number. \r\n2. You have incorrectly entered your CVV code. \r\n3. You have incorrectly entered your expiration date. \r\n4. You have used a cancelled credit card to place your order. \r\n5. Your card is restricted to point-of-sale transactions only (sales where your card is physically scanned). \r\n\r\nPlease double-check your credit card and/or with your bank to ensure that none of these problems have occurred. If you realize that you\'ve made a mistake, simply return to the payment option page and enter in the correct information. Continue checking out as normal. \r\n\r\nIf you\'re still encountering problems, please contact us. However, at NO point should you ever e-mail us your full credit card number. Your e-mail does not have the same security features in place as the website. If you wish to reference a specific credit card that you already have on file with us, please reference by the order number.\r\n\r\nIf you believe that you have provided us with an incorrect CVV code or expiration date you may send us that corrected information via e-mail referencing by the order number.\r\n\r\nIf you believe that your card was declined due to insufficient funds, but now have those funds available, you may ask that we attempt to charge your credit card again.\r\n\r\nIf you believe that your card is restricted to point-of-sale transactions, you must either contact your bank about removing such restrictions, provide us with a different credit card, or choose a new payment method.\r\n' , NULL , 2 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (25 , NULL , '2005-06-10 17:29:38' , NULL , 'Why is my online confirmation number different from my order number?' , NULL , NULL , NULL , NULL , 4 , NULL , NULL , NULL , '10.1.1.6' , NULL , 1 , NULL , 1 , 1 , 0 , 1 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '10.06.2005 17:29:38' , '10.06.2005 17:29:38' , NULL , NULL , NULL , 'This is due to the internal process we must maintain to properly track your order through the system. Once an order number is assigned you may use it for all future references to that purchase.' , NULL , 1 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (26 , '' , NULL , NULL , 'Maroon 5 - One More Night' , 'M' , NULL , '' , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Online Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:21:39' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="fwK7ggA3-bU">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="8">\r\nYou and I go hard at each other like we\'re going to war.<br>\r\nYou and I go rough, we keep throwing things and slamming the door.<br>\r\n</span>\r\n<span data-start="18">\r\nYou and I get so damn dysfunctional, we stopped keeping score.<br>\r\nYou and I get sick, yeah, I know that we can\'t do this no more.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="29">\r\nYeah, but baby there you go again, there you go again, making me love you.<br>\r\nYeah, I stopped using my head, using my head, let it all go.\r\n</span><br>\r\n<span data-start="40">\r\nGot you stuck on my body, on my body, like a tattoo.<br>\r\nAnd now I\'m feeling stupid, feeling stupid, crawling back to you.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="50">\r\nSo I cross my heart and I hope to die<br>\r\nThat I\'ll only stay with you one more night<br>\r\n</span>\r\n<span data-start="60">\r\nAnd I know I said it a million times<br>\r\nBut I\'ll only stay with you one more night\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="70">\r\nTry to tell you "no" but my body keeps on telling you "yes".<br>\r\nTry to tell you "stop", but your lipstick got me so out of breath.<br>\r\n</span>\r\n<span data-start="80">\r\nI\'ll be waking up in the morning, probably hating myself.<br>\r\nAnd I\'ll be waking up, feeling satisfied but guilty as hell.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="91">\r\nYeah, but baby there you go again, there you go again, making me love you.<br>\r\n(Making me love you)<br>\r\n</span>\r\n<span data-start="97">\r\nYeah, I stopped using my head, using my head, let it all go.<br>\r\n(I let it all go)<br>\r\n</span>\r\n<span data-start="102">\r\nGot you stuck on my body, on my body, like a tattoo.<br>\r\n(Like a tattoo, yeah)<br>\r\n</span>\r\n<span data-start="107">\r\nAnd now I\'m feeling stupid, feeling stupid, crawling back to you.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="112">\r\nSo I cross my heart and I hope to die<br>\r\n(Yeah)<br>\r\n</span>\r\n<span data-start="118">\r\nThat I\'ll only stay with you one more night<br>\r\n(Oh)<br>\r\n</span>\r\n<span data-start="122">\r\nAnd I know I said it a million times<br>\r\n(Yeah)<br>\r\n</span>\r\n<span data-start="128">\r\nBut I\'ll only stay with you one more night<br>\r\n(Yeah)\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="136">\r\nYeah, baby, give me one more night<br>\r\n</span>\r\n<span data-start="141">\r\nYeah, baby, give me one more night (whoa, yeah)<br>\r\nYeah, baby, give me one more night (oh, yeah, yeah)\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="154">\r\nYeah, but baby there you go again, there you go again making me love you.<br>\r\nYeah, I stopped using my head, using my head, let it all go.\r\n</span>\r\n<br>\r\n<span data-start="164">\r\nGot you stuck on my body, on my body like a tattoo.<br>\r\nYeah, yeah, yeah, yeah\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="174">\r\nSo I cross my heart and I hope to die<br>\r\n(Oh oh oh oh, oh oh oh oh)<br>\r\n</span>\r\n<span data-start="180">\r\nThat I\'ll only stay with you one more night<br>\r\n(Oh oh oh oh oh oh)<br>\r\n</span>\r\n<span data-start="184">\r\nAnd I know I said it a million times<br>\r\n(Oh, I said it a million times)<br>\r\n</span>\r\n<span data-start="190">\r\nBut I\'ll only stay with you one more night<br>\r\n(Yeah, baby give me one more night)\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="195">\r\nSo I cross my heart and I hope to die (yeah, yeah)<br>\r\nThat I\'ll only stay with you one more night (yeah, yeah)<br>\r\n</span>\r\n<span data-start="206">\r\nAnd I know I said it a million times (yeah, yeah)<br>\r\nBut I\'ll only stay with you one more night (yeah, yeah)\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="217">\r\nI don\'t know, whatever.\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/maroon-5-one-more-night.html">Maroon 5 - One More Night Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'fwK7ggA3-bU' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (27 , '' , NULL , NULL , 'Michael Jackson - They Don\'t Care About Us' , 'M' , NULL , '' , NULL , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Mine Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:25:00' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="t1pqi8vjTLY">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="17">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="23" data-stop="30">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="54">\r\nSkin head, dead head<br>\r\nEverybody gone bad<br>\r\n</span>\r\n<span data-start="58">\r\nSituation, aggravation<br>\r\nEverybody allegation<br>\r\n</span>\r\n<span data-start="60">\r\nIn the suite, on the news<br>\r\nEverybody dog food<br>\r\n</span>\r\n<span data-start="63">\r\nBang bang, shot dead<br>\r\nEverybody\'s gone mad\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="66">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="71">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="76">\r\nBeat me, hate me<br>\r\nYou can never break me<br>\r\n</span>\r\n<span data-start="78">\r\nWill me, thrill me<br>\r\nYou can never kill me<br>\r\n</span>\r\n<span data-start="82">\r\nJew me, sue me<br>\r\nEverybody do me<br>\r\n</span>\r\n<span data-start="84">\r\nKick me, kike me<br>\r\nDon\'t you black or white me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="87">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="92">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="98">\r\nTell me what has become of my life<br>\r\nI have a wife and two children who love me<br>\r\n</span>\r\n<span data-start="103">\r\nI am the victim of police brutality, now<br>\r\nI\'m tired of bein\' the victim of hate<br>\r\n</span>\r\n<span data-start="111">\r\nYou\'re rapin\' me off my pride<br>\r\nOh, for God\'s sake<br>\r\n</span>\r\n<span data-start="114">\r\nI look to heaven to fulfill its prophecy...<br>\r\nSet me free\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="119">\r\nSkin head, dead head<br>\r\nEverybody gone bad<br>\r\n</span>\r\n<span data-start="122">\r\nTrepidation, speculation<br>\r\nEverybody allegation<br>\r\n</span>\r\n<span data-start="124">\r\nIn the suite, on the news<br>\r\nEverybody dog food<br>\r\n</span>\r\n<span data-start="127">\r\nBlack male, black mail<br>\r\nThrow your brother in jail\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="130">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="134">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="141">\r\nTell me what has become of my rights<br>\r\nAm I invisible because you ignore me?<br>\r\n</span>\r\n<span data-start="146">\r\nYour proclamation promised me free liberty, now<br>\r\nI\'m tired of bein\' the victim of shame<br>\r\n</span>\r\n<span data-start="154">\r\nThey\'re throwing me in a class with a bad name<br>\r\nI can\'t believe this is the land from which I came<br>\r\n</span>\r\n<span data-start="160">\r\nYou know I really do hate to say it<br>\r\nThe government don\'t wanna see<br>\r\n</span>\r\n<span data-start="166">\r\nBut if Roosevelt was livin\'<br>\r\nHe wouldn\'t let this be, no, no\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="172">\r\nSkin head, dead head<br>\r\nEverybody gone bad<br>\r\n</span>\r\n<span data-start="175">\r\nSituation, speculation<br>\r\nEverybody litigation<br>\r\n</span>\r\n<span data-start="178">\r\nBeat me, bash me<br>\r\nYou can never trash me<br>\r\n</span>\r\n<span data-start="181">\r\nHit me, kick me<br>\r\nYou can never get me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="183">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="188" data-stop="192">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="215">\r\nSome things in life they just don\'t wanna see<br>\r\nBut if Martin Luther was livin\'<br>\r\n</span>\r\n<span data-start="223">\r\nHe wouldn\'t let this be, no, no\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="226">\r\nSkin head, dead head<br>\r\nEverybody gone bad<br>\r\n</span>\r\n<span data-start="229">\r\nSituation, segregation<br>\r\nEverybody allegation<br>\r\n</span>\r\n<span data-start="231">\r\nIn the suite, on the news<br>\r\nEverybody dog food<br>\r\n</span>\r\n<span data-start="234">\r\nKick me, kike me<br>\r\nDon\'t you wrong or right me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="236">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="241">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="246">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us<br>\r\n</span>\r\n<span data-start="252">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about<br>\r\n</span>\r\n<span data-start="256">\r\nAll I wanna say is that<br>\r\nthey don\'t really care about<br>\r\n</span>\r\n<span data-start="258" data-stop="265">\r\nAll I wanna say is that<br>\r\nThey don\'t really care about us\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/michael-jackson-they-dont-care-about-us.html">Michael Jackson - They Don\'t Care About Us Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'QNJL6nfu__Q' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (28 , '' , NULL , NULL , 'Pink - Try' , 'P' , NULL , '' , NULL , 3 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Online Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:27:04' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="yTCDVfMz15M">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="14">\r\nOh, oh, oh, ohhhh\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="22">\r\nEver wonder about what he\'s doing?<br>\r\nHow it all turned to lies?<br>\r\n</span>\r\n<span data-start="30" data-stop="40">\r\nSometimes I think that it\'s better to never ask why\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="49">\r\nWhere there is desire<br>\r\nThere is gonna be a flame<br>\r\n</span>\r\n<span data-start="54">\r\nWhere there is a flame<br>\r\nSomeone\'s bound to get burned<br>\r\n</span>\r\n<span data-start="59">\r\nBut just because it burns<br>\r\nDoesn\'t mean you\'re gonna die<br>\r\n</span>\r\n<span data-start="63">\r\nYou\'ve gotta get up and try, try, try<br>\r\nGotta get up and try, try, try<br>\r\n</span>\r\n<span data-start="73" data-stop="77">\r\nGotta get up and try, try, try\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="82">\r\nEh, eh, eh\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="85">\r\nFunny how the heart can be deceiving<br>\r\nMore than just a couple times<br>\r\n</span>\r\n<span data-start="93" data-stop="102">\r\nWhy do we fall in love so easy?<br>\r\nEven when it\'s not right\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="108">\r\nEh, eh, eh, eh, ohhh\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="112">\r\nWhere there is desire<br>\r\nThere is gonna be a flame<br>\r\n</span>\r\n<span data-start="116">\r\nWhere there is a flame<br>\r\nSomeone\'s bound to get burned<br>\r\n</span>\r\n<span data-start="121">\r\nBut just because it burns<br>\r\nDoesn\'t mean you\'re gonna die<br>\r\n</span>\r\n<span data-start="125">\r\nYou\'ve gotta get up and try, try, try<br>\r\nGotta get up and try, try, try<br>\r\n</span>\r\n<span data-start="135" data-stop="140">\r\nYou gotta get up and try, try, try\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="147">\r\nEver worry that it might be ruined<br>\r\nAnd does it make you wanna cry?<br>\r\n</span>\r\n<span data-start="156">\r\nWhen you\'re out there doing what you\'re doing<br>\r\nAre you just getting by?<br>\r\n</span>\r\n<span data-start="164">\r\nTell me are you just getting by, by, by?\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="170">\r\nWhere there is desire<br>\r\nThere is gonna be a flame<br>\r\n</span>\r\n<span data-start="174">\r\nWhere there is a flame<br>\r\nSomeone\'s bound to get burned<br>\r\n</span>\r\n<span data-start="179">\r\nBut just because it burns<br>\r\nDoesn\'t mean you\'re gonna die<br>\r\n</span>\r\n<span data-start="183">\r\nYou\'ve gotta get up and try, try, try<br>\r\nGotta get up and try, try, try<br>\r\n</span>\r\n<span data-start="192">\r\nYou gotta get up and try, try, try<br>\r\nGotta get up and try, try, try<br>\r\n</span>\r\n<span data-start="201">\r\nGotta get up and try, try, try<br>\r\nYou gotta get up and try, try, try<br>\r\n</span>\r\n<span data-start="211" data-stop="216">\r\nGotta get up and try, try, try\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="222" data-stop="233">\r\nYou gotta get up and try, try, try<br>\r\nGotta get up and try, try, try\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/pink-try.html">Pink - Try Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'yTCDVfMz15M' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (29 , '' , NULL , NULL , 'Queen - We Are The Champions' , 'Q' , NULL , '' , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Rock Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:29:18' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="04854XqcfCY">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="4">\r\nI\'ve paid my dues<br>\r\nTime after time.<br>\r\n</span>\r\n<span data-start="11">\r\nI\'ve done my sentence<br>\r\nBut committed no crime.<br>\r\n</span>\r\n<span data-start="19">\r\nAnd bad mistakes <br>\r\nI\'ve made a few.<br>\r\n</span>\r\n<span data-start="26">\r\nI\'ve had my share of sand kicked in my face<br>\r\nBut I\'ve come through.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="34">\r\n<i>(And I need just go on and on, and on, and on)</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="38">\r\nWe are the champions, my friends,<br>\r\nAnd we\'ll keep on fighting \'til the end.<br>\r\n</span>\r\n<span data-start="52">\r\nWe are the champions.<br>\r\nWe are the champions.<br>\r\n</span>\r\n<span data-start="60" data-stop="75">\r\nNo time for losers<br>\r\nCause we are the champions of the world.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n\r\n<span data-start="80">\r\nI\'ve taken my bows<br>\r\nAnd my curtain calls<br>\r\n</span>\r\n<span data-start="87">\r\nYou brought me fame and fortune and everything that goes with it<br>\r\nI thank you all\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="95">\r\nBut it\'s been no bed of roses,<br>\r\nNo pleasure cruise.<br>\r\n</span>\r\n<span data-start="103">\r\nI consider it a challenge before the whole human race<br>\r\nAnd I ain\'t gonna lose.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="109">\r\n<i>(And I need just go on and on, and on, and on)</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="113">\r\nWe are the champions, my friends,<br>\r\nAnd we\'ll keep on fighting \'til the end.<br>\r\n</span>\r\n<span data-start="128">\r\nWe are the champions.<br>\r\nWe are the champions.<br>\r\n</span>\r\n<span data-start="136">\r\nNo time for losers<br>\r\nCause we are the champions of the world.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="147">\r\nWe are the champions, my friends,<br>\r\nAnd we\'ll keep on fighting \'til the end.<br>\r\n</span>\r\n<span data-start="159">\r\nWe are the champions.<br>\r\nWe are the champions.<br>\r\n</span>\r\n<span data-start="168" data-stop="182">\r\nNo time for losers<br>\r\nCause we are the champions. <br></span></p><p><span data-start="168" data-stop="182"><span><a href="http://www.minelyrics.com/queen-we-are-the-champions.html">Queen - We Are The Champions Lyrics</a></span><br></span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '04854XqcfCY' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (30 , '' , NULL , NULL , 'Rihanna - Stay' , 'R' , NULL , '' , NULL , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Online Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:33:43' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="JF8BRvqGCNs">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<i>[Rihanna]</i><br>\r\n<span data-start="17" data-stop="21">\r\nAll along it was a fever<br>\r\n</span>\r\n<span data-start="24" data-stop="29">\r\nA cold sweat hot-headed believer<br>\r\n</span>\r\n<span data-start="32" data-stop="38">\r\nI threw my hands in the air, said, "Show me something"<br>\r\n</span>\r\n<span data-start="41" data-stop="47">\r\nHe said, "If you dare, come a little closer"\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="50" data-stop="56">\r\nRound and around and around and around we go<br>\r\n</span>\r\n<span data-start="58" data-stop="65">\r\nOh now, tell me now, tell me now, tell me now you know.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="68">\r\nNot really sure how to feel about it.<br>\r\nSomething in the way you move<br>\r\n</span>\r\n<span data-start="76">\r\nMakes me feel like I can\'t live without you.<br>\r\nIt takes me all the way.<br>\r\n</span>\r\n<span data-start="84" data-stop="90">\r\nI want you to stay\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Mikky]</i><br>\r\n<span data-start="94" data-stop="98">\r\nIt\'s not much of a life you\'re living<br>\r\n</span>\r\n<span data-start="101" data-stop="107">\r\nIt\'s not just something you take, it\'s given\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="110" data-stop="116">\r\nRound and around and around and around we go<br>\r\n</span>\r\n<span data-start="118" data-stop="125">\r\nOh now, tell me now, tell me now, tell me now you know.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="128">\r\nNot really sure how to feel about it.<br>\r\nSomething in the way you move<br>\r\n</span>\r\n<span data-start="136">\r\nMakes me feel like I can\'t live without you.<br>\r\nYeah, it takes me all the way.<br>\r\n</span>\r\n<span data-start="144" data-stop="150">\r\nI want you to stay.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[RIhanna &amp; Mikky]</i><br>\r\n<span data-start="153" data-stop="160">\r\nOoh, ooh, ooh, the reason I hold on<br>\r\n</span>\r\n<span data-start="162" data-stop="169">\r\nOoh, ooh, ooh, \'cause I need this hole gone<br>\r\n</span>\r\n<span data-start="170" data-stop="178">\r\nFunny you\'re the broken one but I\'m the only one who needed saving<br>\r\n</span>\r\n<span data-start="179" data-stop="186">\r\n\'Cause when you never see the light it\'s hard to know which one of us is caving.\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<i>[Rihanna]</i><br>\r\n<span data-start="188">\r\nNot really sure how to feel about it.<br>\r\nSomething in the way you move<br>\r\n</span>\r\n<span data-start="196">\r\nMakes me feel like I can\'t live without you.<br>\r\nYeah, it takes me all the way.<br>\r\n</span>\r\n<span data-start="204" data-stop="233">\r\nI want you to sta-a-ay, sta-a-ay.<br>\r\nI want you to stay, oooh. <br></span></p><p><span data-start="204" data-stop="233"><span><a href="http://www.minelyrics.com/rihanna-stay.html">Rihanna - Stay Lyrics</a></span><br></span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'JF8BRvqGCNs' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (31 , '' , NULL , NULL , 'Stevie Wonder - I Just Called to Say I Love You' , 'S' , NULL , '' , NULL , 3 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Retro Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:37:18' , NULL , NULL , NULL , '<p>\r\n<span data-start="7" data-stop="23">\r\nNo New Year\'s Day to celebrate<br>\r\nNo chocolate covered candy hearts to give away<br>\r\n</span>\r\n<span data-start="24" data-stop="31.5">\r\nNo first of spring<br>\r\nNo song to sing<br>\r\n</span>\r\n<span data-start="32" data-stop="40">\r\nIn fact here\'s just another ordinary day\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="41" data-stop="48">\r\nNo April rain<br>\r\nNo flowers bloom<br>\r\n</span>\r\n<span data-start="49" data-stop="65">\r\nNo wedding Saturday within the month of June<br>\r\nBut what it is, is something true<br>\r\n</span>\r\n<span data-start="66" data-stop="74">\r\nMade up of these three words that I must say to you\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="75" data-stop="90">\r\nI just called to say - I love you<br>\r\nI just called to say how much I care<br>\r\n</span>\r\n<span data-start="92" data-stop="107">\r\nI just called to say - I love you<br>\r\nAnd I mean it from the bottom of my heart\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="108" data-stop="116">\r\nNo summer\'s high<br>\r\nNo warm July<br>\r\n</span>\r\n<span data-start="116">\r\nNo harvest moon to light one tender August night<br>\r\nNo autumn breeze<br>\r\n</span>\r\n<span data-start="130" data-stop="141">\r\nNo falling leaves<br>\r\nNot even time for birds to fly to southern skies\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="142">\r\nNo Libra sun<br>\r\nNo Halloween<br>\r\n</span>\r\n<span data-start="150" data-stop="166">\r\nNo giving thanks to all the Christmas joy you bring<br>\r\nBut what it is, though old so new<br>\r\n</span>\r\n<span data-start="167" data-stop="175">\r\nTo fill your heart like no three words could ever do\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="176">\r\nI just called to say - I love you<br>\r\nI just called to say how much I care, I do<br>\r\n</span>\r\n<span data-start="193" data-stop="209">\r\nI just called to say - I love you<br>\r\nAnd I mean it from the bottom of my heart\r\n</span>\r\n</p>\r\n\r\n\r\n<span data-start="210">\r\nI just called to say - I love you<br>\r\nI just called to say how much I care, I do<br>\r\n</span>\r\n<span data-start="227" data-stop="255">\r\nI just called to say - I love you<br>\r\nAnd I mean it from the bottom of my heart, of my heart, of my heart<br><br><span><a href="http://www.minelyrics.com/stevie-wonder-i-just-called-to-say-i-love-you.html">Stevie Wonder - I Just Called to Say I Love You Lyrics</a></span><br></span>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'QwOU3bnuU0k' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (32 , '' , NULL , NULL , 'The Beatles - Let It Be' , 'T' , NULL , '' , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'All Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:39:37' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="ajCYQL8ouqw">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="12">\r\nWhen I find myself in times of trouble<br>\r\nMother Mary comes to me<br>\r\n</span>\r\n<span data-start="19">\r\nSpeaking words of wisdom, let it be<br>\r\nAnd in my hour of darkness<br>\r\n</span>\r\n<span data-start="29">\r\nShe is standing right in front of me<br>\r\nSpeaking words of wisdom, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="38">\r\nLet it be, let it be<br>\r\nLet it be, let it be<br>\r\n</span>\r\n<span data-start="45">\r\nWhisper words of wisdom, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="52">\r\nAnd when the broken-hearted people<br>\r\nLiving in the world agree<br>\r\n</span>\r\n<span data-start="58">\r\nThere will be an answer, let it be<br>\r\nFor though they may be parted<br>\r\n</span>\r\n<span data-start="67">\r\nThere is still a chance that they will see<br>\r\nThere will be an answer, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="77">\r\nLet it be, let it be<br>\r\nLet it be, let it be<br>\r\n</span>\r\n<span data-start="85">\r\nYeah, there will be an answer, let it be<br>\r\nLet it be, let it be<br>\r\n</span>\r\n<span data-start="94" data-stop="104">\r\nLet it be, let it be<br>\r\nWhisper words of wisdom, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="145">\r\nLet it be, let it be<br>\r\nAh, let it be, yeah, let it be<br>\r\n</span>\r\n<span data-start="153">\r\nWhisper words of wisdom, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="160">\r\nAnd when the night is cloudy<br>\r\nThere is still a light that shines on me<br>\r\n</span>\r\n<span data-start="168">\r\nShine on until tomorrow, let it be<br>\r\nI wake up to the sound of music,<br>\r\n</span>\r\n<span data-start="178">\r\nMother Mary comes to me<br>\r\nSpeaking words of wisdom, let it be\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="188">\r\nLet it be, let it be<br>\r\nLet it be, yeah, let it be<br>\r\n</span>\r\n<span data-start="195">\r\nOh, there will be an answer, let it be<br>\r\nLet it be, let it be<br>\r\n</span>\r\n<span data-start="205" data-stop="217">\r\nLet it be, yeah, let it be<br>\r\nWhisper words of wisdom, let it be <br></span></p><p><span data-start="205" data-stop="217"><span><a href="http://www.minelyrics.com/the-beatles-let-it-be.html">The Beatles - Let It Be Lyrics</a></span><br></span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'ajCYQL8ouqw' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (33 , '' , NULL , NULL , 'Toni Braxton - Un-Break My Heart' , 'T' , NULL , '' , NULL , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Youtube Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:46:04' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="p2Rch6WvPJE">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="20">\r\nDon\'t leave me in all this pain<br>\r\nDon\'t leave me out in the rain<br>\r\n</span>\r\n<span data-start="29">\r\nCome back and bring back my smile<br>\r\nCome and take these tears away<br>\r\n</span>\r\n<span data-start="36">\r\nI need your arms to hold me now<br>\r\nThe nights are so unkind<br>\r\n</span>\r\n<span data-start="45">\r\nBring back those nights when I held you beside me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="52">\r\nUn-break my heart<br>\r\nSay you\'ll love me again<br>\r\n</span>\r\n<span data-start="60">\r\nUndo this hurt you caused<br>\r\nWhen you walked out the door<br>\r\n</span>\r\n<span data-start="66">\r\nAnd walked out of my life<br>\r\nUn-cry these tears<br>\r\n</span>\r\n<span data-start="73">\r\nI cried so many nights<br>\r\nUn-break my heart<br>\r\nMy heart\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="90">\r\nTake back that sad word good-bye<br>\r\nBring back the joy to my life<br>\r\n</span>\r\n<span data-start="99">\r\nDon\'t leave me here with these tears<br>\r\nCome and kiss this pain away<br>\r\n</span>\r\n<span data-start="106">\r\nI can\'t forget the day you left<br>\r\nTime is so unkind<br>\r\n</span>\r\n<span data-start="115">\r\nAnd life is so cruel without you here beside me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="122">\r\nUn-break my heart<br>\r\nSay you\'ll love me again<br>\r\n</span>\r\n<span data-start="130">\r\nUndo this hurt you caused<br>\r\nWhen you walked out the door<br>\r\n</span>\r\n<span data-start="136">\r\nAnd walked out of my life<br>\r\nUn-cry these tears<br>\r\n</span>\r\n<span data-start="143" data-stop="161">\r\nI cried so many nights<br>\r\nUn-break my heart<br>\r\nMy heart\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="175">\r\nDon\'t leave me in all this pain<br>\r\nDon\'t leave me out in the rain<br>\r\n</span>\r\n<span data-start="183">\r\nBring back the nights when I held you beside me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="189">\r\nUn-break my heart<br>\r\nSay you\'ll love me again<br>\r\n</span>\r\n<span data-start="198">\r\nUndo this hurt you caused<br>\r\nWhen you walked out the door<br>\r\n</span>\r\n<span data-start="204">\r\nAnd walked out of my life<br>\r\nUn-cry this tears<br>\r\n</span>\r\n<span data-start="210">\r\nI cried so many, many nights<br>\r\nUn-break my\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="218">\r\nUn-break my heart oh baby<br>\r\nCome back and say you love me<br>\r\n</span>\r\n<span data-start="227">\r\nUn-break my heart<br>\r\nSweet darlin\'<br>\r\n</span>\r\n<span data-start="231">\r\nWithout you I just can\'t go on<br>\r\nCan\'t go on.... <br></span></p><p><span data-start="231"><span><a href="http://www.minelyrics.com/toni-braxton-un-break-my-heart.html">Toni Braxton - Un-Break My Heart Lyrics</a></span><br></span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t</div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'p2Rch6WvPJE' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (34 , '' , NULL , NULL , 'Whitney Houston - I Will Always Love You' , 'W' , NULL , '' , NULL , 3 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Karaoke Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:48:53' , NULL , NULL , NULL , '<span data-start="0">If I should stay<br>\r\nI would only be in your way<br>\r\n</span>\r\n<span data-start="20">\r\nSo I\'ll go but I know<br>\r\nI\'ll think of you every step of the way<br>\r\n</span>\r\n<br>\r\n<span data-start="43">\r\nAnd I... will always love you, ooh<br>\r\nWill always love you<br>\r\nYou<br>\r\n</span>\r\n<span data-start="70">\r\nMy darling, you...<br>\r\nMmm-mm<br>\r\n</span>\r\n<br>\r\n<span data-start="78">\r\nBittersweet memories<br>\r\nThat is all I\'m taking with me.<br>\r\n</span>\r\n<span data-start="92">\r\nSo good-bye.<br>\r\nPlease don\'t cry:<br>\r\nWe both know I\'m not what you, you need<br>\r\n</span>\r\n<br>\r\n<span data-start="106" data-stop="130">\r\nAnd I... will always love you<br>\r\nI... will always love you<br>\r\nYou, ooh<br>\r\n</span>\r\n<br>\r\n<span data-start="156">\r\nI hope life treats you kind<br>\r\nAnd I hope you have all you\'ve dreamed of<br>\r\n</span>\r\n<span data-start="171">\r\nAnd I wish you joy and happiness<br>\r\nBut above all this I wish you love<br>\r\n</span>\r\n<br>\r\n<span data-start="189">\r\nAnd I... will always love you<br>\r\nI will always love you<br>\r\n</span>\r\n<span data-start="207" data-stop="221">\r\nI will always love you<br>\r\nI will always love you<br>\r\n</span>\r\n<br>\r\n<span data-start="223" data-stop="244">\r\nI will always love you<br>\r\nI, I will always love you.<br>\r\n</span>\r\n<br>\r\n<span data-start="245">\r\nYou.<br>\r\nDarling, I love you.<br>\r\nI\'ll always...<br>\r\n</span>\r\n<span data-start="253">\r\nI\'ll always love you.<br>\r\nOoh<br>\r\nOoh<br><br><span><a href="http://www.minelyrics.com/whitney-houston-i-will-always-love-you.html">Whitney Houston - I Will Always Love You Lyrics</a></span><br></span>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , '3JWTaaS7LdU' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (35 , '' , NULL , NULL , 'Zedd - Clarity' , 'Z' , NULL , '' , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Best Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:52:43' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="IxxstCcJlsc">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\nHigh dive into frozen waves where the past comes back to life<br>\r\nFight fear for the selfish pain, it was worth it every time<br>\r\nHold still right before we crash \'cause we both know how this ends<br>\r\nA clock ticks \'til it breaks your glass and I drown in you again\r\n</p>\r\n\r\n<p>\r\n\'Cause you are the piece of me I wish I didn\'t need<br>\r\nChasing relentlessly, still fight and I don\'t know why\r\n</p>\r\n\r\n<p>\r\nIf our love is tragedy, why are you my remedy?<br>\r\nIf our love\'s insanity, why are you my clarity?\r\n</p>\r\n\r\n<p>\r\n(Hey-ay, hey-ay-ay. Hey-ay, hey-ay-ay. Hey-ay, hey-ay-ay. Hey-ay, hey)\r\n</p>\r\n\r\n<p>\r\nIf our love is tragedy, why are you my remedy?<br>\r\nIf our love\'s insanity, why are you my clarity?\r\n</p>\r\n\r\n<p>\r\nWalk on through a red parade and refuse to make amends<br>\r\nIt cuts deep through our ground and makes us forget all common sense<br>\r\nDon\'t speak as I try to leave \'cause we both know what we\'ll choose<br>\r\nIf you pull then I\'ll push too deep and I\'ll fall right back to you\r\n</p>\r\n\r\n<p>\r\n\'Cause you are the piece of me I wish I didn\'t need<br>\r\nChasing relentlessly, still fight and I don\'t know why\r\n</p>\r\n\r\n<p>\r\nIf our love is tragedy, why are you my remedy?<br>\r\nIf our love\'s insanity, why are you my clarity?\r\n</p>\r\n\r\n<p>\r\n(Hey-ay, hey-ay-ay. Hey-ay, hey-ay-ay. Hey-ay, hey-ay-ay. Hey-ay, hey)\r\n</p>\r\n\r\n<p>\r\nWhy are you my clarity?<br>\r\nWhy are you my remedy?<br>\r\nWhy are you my clarity?<br>\r\nWhy are you my remedy?\r\n</p>\r\n\r\n<p>\r\nIf our love is tragedy, why are you my remedy?<br>\r\nIf our love\'s insanity, why are you my clarity?\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/zedd-clarity.html">Zedd - Clarity Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'IxxstCcJlsc' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (36 , '' , NULL , NULL , '2Pac - Dear Mama' , '2' , NULL , '' , NULL , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Lyrics Hits' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:55:36' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="Mb1ZvUDvLDY">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="5" data-stop="7">\r\n<i>You are appreciated</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="11">\r\nWhen I was young me and my mama had beef<br>\r\nSeventeen years old kicked out on the streets<br>\r\n</span>\r\n<span data-start="16">\r\nThough back at the time, I never thought I\'d see her face<br>\r\nAin\'t a woman alive that could take my mama\'s place<br>\r\n</span>\r\n<span data-start="22">\r\nSuspended from school and scared to go home, I was a fool<br>\r\nwith the big boys, breaking all the rules<br>\r\n</span>\r\n<span data-start="27">\r\nI shed tears with my baby sister<br>\r\nOver the years we was poorer than the other little kids<br>\r\n</span>\r\n<span data-start="33">\r\nAnd even though we had different daddy\'s, the same drama<br>\r\nWhen things went wrong we\'d blame mama<br>\r\n</span>\r\n<span data-start="39">\r\nI reminisce on the stress I caused, it was hell<br>\r\nHuggin on my mama from a jail cell<br>\r\n</span>\r\n<span data-start="45">\r\nAnd who\'d think in elementary?<br>\r\nHeeey! I see the penitentiary, one day<br>\r\n</span>\r\n<span data-start="51">\r\nAnd running from the police, that\'s right<br>\r\nMama catch me, put a whoopin to my backside<br>\r\n</span>\r\n<span data-start="57">\r\nAnd even as a crack fiend, mama<br>\r\nYou always was a black queen, mama<br>\r\n</span>\r\n<span data-start="63">\r\nI finally understand<br>\r\nfor a woman it ain\'t easy tryin to raise a man<br>\r\n</span>\r\n<span data-start="68">\r\nYou always was committed<br>\r\nA poor single mother on welfare, tell me how ya did it<br>\r\n</span>\r\n<span data-start="73">\r\nThere\'s no way I can pay you back<br>\r\nBut the plan is to show you that I understand<br>\r\n</span>\r\n<span data-start="78">\r\nYou are appreciated\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="80">\r\n<i>Lady, don\'t cha know we love ya? </i><br>\r\n</span>\r\n<span data-start="85">\r\nDear mama<br>\r\n<i>Sweet lady, place no one above ya</i><br>\r\n</span>\r\n<span data-start="90">\r\nYou are appreciated<br>\r\n<i>Sweet lady, don\'t cha know we love ya?</i>\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="97">\r\nNow ain\'t nobody tell us it was fair<br>\r\nNo love from my daddy cause the coward wasn\'t there<br>\r\n</span>\r\n<span data-start="102">\r\nHe passed away and I didn\'t cry, cause my anger<br>\r\nwouldn\'t let me feel for a stranger<br>\r\n</span>\r\n<span data-start="107">\r\nThey say I\'m wrong and I\'m heartless, but all along<br>\r\nI was lookin for a father he was gone<br>\r\n</span>\r\n<span data-start="113">\r\nI hung around with the Thugs, and even though they sold drugs<br>\r\nThey showed a young brother love<br>\r\n</span>\r\n<span data-start="119">\r\nI moved out and started really hangin<br>\r\nI needed money of my own so I started slangin<br>\r\n</span>\r\n<span data-start="124">\r\nI ain\'t guilty cause, even though I sell rocks<br>\r\nIt feels good puttin money in your mailbox<br>\r\n</span>\r\n<span data-start="129">\r\nI love payin rent when the rent\'s due<br>\r\nI hope ya got the diamond necklace that I sent to you<br>\r\n</span>\r\n<span data-start="136">\r\nCause when I was low you was there for me<br>\r\nAnd never left me alone because you cared for me<br>\r\n</span>\r\n<span data-start="141">\r\nAnd I could see you comin home after work late<br>\r\nYou\'re in the kitchen tryin to fix us a hot plate<br>\r\n</span>\r\n<span data-start="147">\r\nYa just workin with the scraps you was given<br>\r\nAnd mama made miracles every Thanksgivin<br>\r\n</span>\r\n<span data-start="153">\r\nBut now the road got rough, you\'re alone<br>\r\nYou\'re tryin to raise two bad kids on your own<br>\r\n</span>\r\n<span data-start="159">\r\nAnd there\'s no way I can pay you back<br>\r\nBut my plan is to show you that I understand<br>\r\n</span>\r\n<span data-start="164">\r\nYou are appreciated\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="166">\r\n<i>Lady, don\'t cha know we love ya? </i><br>\r\n</span>\r\n<span data-start="170">\r\nDear mama<br>\r\n<i>Sweet lady, place no one above ya</i><br>\r\n</span>\r\n<span data-start="175">\r\n<i>You are appreciated</i><br>\r\nSweet lady, don\'t cha know we love ya?\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="182">\r\nPour out some liquor and I reminisce, cause through the drama<br>\r\nI can always depend on my mama<br>\r\n</span>\r\n<span data-start="187">\r\nAnd when it seems that I\'m hopeless<br>\r\nYou say the words that can get me back in focus<br>\r\n</span>\r\n<span data-start="192">\r\nWhen I was sick as a little kid<br>\r\nTo keep me happy there\'s no limit to the things you did<br>\r\n</span>\r\n<span data-start="198">\r\nAnd all my childhood memories<br>\r\nAre full of all the sweet things you did for me<br>\r\n</span>\r\n<span data-start="204">\r\nAnd even though I act craaazy<br>\r\nI gotta thank the Lord that you made me<br>\r\n</span>\r\n<span data-start="210">\r\nThere are no words that can express how I feel<br>\r\nYou never kept a secret, always stayed real<br>\r\n</span>\r\n<span data-start="216">\r\nAnd I appreciate, how you raised me<br>\r\nAnd all the extra love that you gave me<br>\r\n</span>\r\n<span data-start="221">\r\nI wish I could take the pain away<br>\r\nIf you can make it through the night there\'s a brighter day<br>\r\n</span>\r\n<span data-start="227">\r\nEverything will be alright if ya hold on<br>\r\nIt\'s a struggle everyday, gotta roll on<br>\r\n</span>\r\n<span data-start="233">\r\nAnd there\'s no way I can pay you back<br>\r\nBut my plan is to show you that I understand<br>\r\n</span>\r\n<span data-start="238">\r\nYou are appreciated\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="240">\r\n<i>Lady, don\'t cha know we love ya? </i><br>\r\n</span>\r\n<span data-start="244">\r\nDear mama<br>\r\n<i>Sweet lady, place no one above ya</i><br>\r\n</span>\r\n<span data-start="249">\r\nYou are appreciated<br>\r\n<i>Sweet lady, don\'t cha know we love ya?</i>\r\n</span>\r\n</p>\r\n\r\n\r\n<p>\r\n<span data-start="255">\r\n<i>Sweet lady</i><br>\r\nAnd dear mama<br>\r\n</span>\r\n<span data-start="261" data-stop="275">\r\nDear mama<br>\r\n<i>Lady, Lady, Lady.</i>\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/2pac-dear-mama.html">2Pac - Dear Mama Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Mb1ZvUDvLDY' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;
INSERT INTO va_articles (`article_id`,`language_code`,`article_date`,`date_end`,`article_title`,`title_first`,`article_comment`,`friendly_url`,`article_template`,`article_order`,`author_name`,`author_email`,`author_url`,`author_remote_address`,`created_user_id`,`created_admin_id`,`updated_user_id`,`updated_admin_id`,`status_id`,`is_html`,`allowed_rate`,`is_hot`,`hot_order`,`hot_description`,`link_title`,`link_url`,`download_url`,`is_link_direct`,`is_remote_rss`,`details_remote_url`,`date_added`,`date_updated`,`keywords`,`highlights`,`short_description`,`full_description`,`notes`,`total_views`,`total_votes`,`total_points`,`rating`,`total_clicks`,`image_tiny`,`image_tiny_alt`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`image_super`,`image_super_alt`,`stream_video`,`stream_video_width`,`stream_video_height`,`stream_video_preview`,`youtube_video`,`youtube_video_width`,`youtube_video_height`,`meta_title`,`meta_keywords`,`meta_description`,`is_draft`,`draft_parent_id`) VALUES (37 , '' , NULL , NULL , '3 Doors Down - Here Without You' , '3' , NULL , '' , NULL , 3 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 1 , 1 , 1 , 0 , NULL , NULL , 'Sing Lyrics' , 'http://www.minelyrics.com/' , NULL , NULL , 0 , NULL , NULL , '24.11.2015 2:57:41' , NULL , NULL , NULL , '<div class="article-desc">\r\n\t\t\t\t\t\t<div id="youtube-lyrics" data-video-id="kPBzTxZQG5Q">\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t<div class="desc desc-full"><p>\r\n<span data-start="5" data-stop="14">\r\nA hundred days have made me older<br>\r\nSince the last time that I saw your pretty face<br>\r\n</span>\r\n<span data-start="18.5" data-stop="28">\r\nA thousand lies have made me colder<br>\r\nAnd I don\'t think I can look at this the same\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="33.5" data-stop="46.5">\r\nBut all the miles that separate<br>\r\nDisappear now when I\'m dreaming of your face\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="47">\r\nI\'m here without you, baby<br>\r\nBut you\'re still on my lonely mind<br>\r\n</span>\r\n<span data-start="54">\r\nI think about you, baby<br>\r\nAnd I dream about you all the time<br>\r\n</span>\r\n<span data-start="61" data-stop="67.5">\r\nI\'m here without you, baby<br>\r\nBut you\'re still with me in my dreams<br>\r\n</span>\r\n<span data-start="69" data-stop="79">\r\nAnd tonight it\'s only you and me, yeah.\r\n</span>\r\n</p>\r\n\r\n\r\n<p>\r\n<span data-start="86" data-stop="94">\r\nThe miles just keep rolling<br>\r\nAs the people leave their way to say hello<br>\r\n</span>\r\n<span data-start="98" data-stop="113">\r\nI\'ve heard this life is overrated<br>\r\nBut I hope that it gets better as we go, oh, yeah, yeah\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="114">\r\nI\'m here without you, baby<br>\r\nBut you\'re still on my lonely mind<br>\r\n</span>\r\n<span data-start="120">\r\nI think about you, baby<br>\r\nAnd I dream about you all the time<br>\r\n</span>\r\n<span data-start="127" data-stop="134">\r\nI\'m here without you, baby<br>\r\nBut you\'re still with me in my dreams<br>\r\n</span>\r\n<span data-start="136">\r\nAnd tonight, girl, its only you and me\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="141">\r\nEverything I know, and anywhere I go (<i>oh whoa</i>)<br>\r\nIt gets hard but it won\'t take away my love (<i>oh whoa</i>)<br>\r\n</span>\r\n<span data-start="154">\r\nAnd when the last one falls<br>\r\nWhen it\'s all said and done<br>\r\n</span>\r\n<span data-start="161" data-stop="178">\r\nIt gets hard but it wont take away my love, whoa, oh, oh\r\n</span>\r\n</p>\r\n\r\n<p>\r\n<span data-start="183">\r\nI\'m here without you, baby<br>\r\nBut you\'re still on my lonely mind<br>\r\n</span>\r\n<span data-start="190">\r\nI think about you, baby<br>\r\nAnd I dream about you all the time<br>\r\n</span>\r\n<span data-start="197" data-stop="204">\r\nI\'m here without you, baby<br>\r\nBut you\'re still with me in my dreams<br>\r\n</span>\r\n<span data-start="206" data-stop="228">\r\nAnd tonight, girl, it\'s only you and me<br>\r\nYeah, oh yeah, oh, oh, oh, oh, oh...\r\n</span>\r\n</p></div>\r\n\t\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\r\n\r\n\r\n\r\n\t\t\t\t\t<span><a href="http://www.minelyrics.com/3-doors-down-here-without-you.html">3 Doors Down - Here Without You Lyrics</a></span><br></div>' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'kPBzTxZQG5Q' , NULL , NULL , NULL , NULL , NULL , NULL , 0 ) ;




INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 1 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 15 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 16 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 17 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 18 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 19 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 20 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 21 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 22 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 23 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 24 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 25 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 26 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 27 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 28 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (1 , 29 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 1 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 18 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 19 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 21 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 23 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (2 , 29 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (3 , 1 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (3 , 20 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (3 , 28 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (4 , 1 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (4 , 16 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (4 , 23 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (5 , 5 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (6 , 5 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (7 , 5 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (8 , 5 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (9 , 7 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (10 , 7 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (11 , 7 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (12 , 7 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (13 , 8 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (14 , 8 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (15 , 8 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (16 , 10 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (17 , 10 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (18 , 10 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (19 , 6 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (20 , 6 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (21 , 6 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (22 , 4 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (23 , 4 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (24 , 4 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (25 , 4 , 0 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (26 , 11 , 1 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (27 , 11 , 2 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (28 , 11 , 3 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (29 , 12 , 1 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (30 , 12 , 2 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (31 , 12 , 3 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (32 , 13 , 1 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (33 , 13 , 2 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (34 , 13 , 3 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (35 , 14 , 1 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (36 , 14 , 2 ) ;
INSERT INTO va_articles_assigned (`article_id`,`category_id`,`article_order`) VALUES (37 , 14 , 3 ) ;




INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (1 , '' , 0 , 0 , '0,' , 'News' , '' , 10 , NULL , NULL , 'article_date' , 'DESC' , NULL , 'article_date,article_title,short_description,image_small' , 'article_date,article_title,full_description,image_large' , 'article_date,article_title' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 4 , 4 , 15 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (3 , '' , 0 , NULL , '0,' , 'Lyrics' , '' , 7 , NULL , NULL , NULL , NULL , '{"article_title":1,"link_url":1,"full_description":1,"youtube_video":1,"article_date_format":"datetime","date_end_format":"datetime"}' , 'article_title,short_description' , 'article_title,link_url,full_description,youtube_video' , 'article_title,full_description' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 2 , 0 , 7 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (4 , '' , 0 , 0 , '0,' , 'FAQ' , '' , 9 , NULL , NULL , NULL , NULL , NULL , 'article_title,full_description,image_small' , 'article_title,full_description,image_large' , 'article_title' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 4 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (5 , '' , 0 , 0 , '0,' , 'Image Gallery' , '' , 5 , NULL , NULL , NULL , NULL , NULL , 'article_date,article_title,short_description,image_small' , 'article_date,article_title,full_description,image_large' , 'article_date,article_title' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 4 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (6 , '' , 0 , 0 , '0,' , 'Events' , '' , 6 , NULL , NULL , NULL , NULL , NULL , 'article_date,article_title,short_description,image_small' , 'article_date,article_title,full_description,image_large' , 'article_date,article_title' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (7 , '' , 3 , 0 , '0,3,' , 'A, B, C, D' , '' , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 4 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (8 , '' , 3 , 0 , '0,3,' , 'E, F, G, H' , '' , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (10 , '' , 3 , 0 , '0,3,' , 'I, J, K, L' , '' , 4 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (11 , '' , 3 , 0 , '0,3,' , 'M, N, O, P' , '' , 5 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (12 , '' , 3 , 0 , '0,3,' , 'Q, R, S' , '' , 6 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (13 , '' , 3 , 0 , '0,3,' , 'T, U, V, W' , '' , 7 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (14 , '' , 3 , 0 , '0,3,' , 'X, Y, Z, 0-9' , '' , 8 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , NULL , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 3 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (15 , NULL , 1 , 0 , '0,1,' , 'Asia' , NULL , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 1 , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (16 , NULL , 1 , 0 , '0,1,' , 'Europe' , NULL , 2 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (17 , NULL , 1 , 0 , '0,1,' , 'U.S.' , NULL , 3 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (18 , NULL , 1 , 0 , '0,1,' , 'WorldWorld' , NULL , 4 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (19 , NULL , 1 , 0 , '0,1,' , 'Business' , NULL , 5 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (20 , NULL , 1 , 0 , '0,1,' , 'Technology' , NULL , 6 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (21 , NULL , 1 , 0 , '0,1,' , 'Science & Space' , NULL , 7 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (22 , NULL , 1 , 0 , '0,1,' , 'Entertainment' , NULL , 8 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (23 , NULL , 1 , 0 , '0,1,' , 'World Sport' , NULL , 9 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (24 , NULL , 1 , 0 , '0,1,' , 'Travel' , NULL , 10 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (25 , NULL , 1 , 0 , '0,1,' , 'Executive' , NULL , 11 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (26 , NULL , 1 , 0 , '0,1,' , 'Education' , NULL , 12 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (27 , NULL , 1 , 0 , '0,1,' , 'Weather' , NULL , 13 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (28 , NULL , 1 , 0 , '0,1,' , 'Special Reports' , NULL , 14 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (29 , NULL , 1 , 0 , '0,1,' , 'Video' , NULL , 15 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;
INSERT INTO va_articles_categories (`category_id`,`language_code`,`parent_category_id`,`alias_category_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`articles_list_template`,`articles_details_template`,`articles_order_column`,`articles_order_direction`,`article_edit_fields`,`article_list_fields`,`article_details_fields`,`article_required_fields`,`article_settings`,`moderators_ids`,`is_hot`,`sites_all`,`user_types_all`,`access_level`,`guest_access_level`,`admin_access_level`,`allowed_rate`,`short_description`,`full_description`,`image_small`,`image_small_alt`,`image_large`,`image_large_alt`,`is_rss`,`rss_limit`,`rss_on_breadcrumb`,`rss_on_list`,`is_remote_rss`,`remote_rss_url`,`remote_rss_date_updated`,`remote_rss_ttl`,`remote_rss_refresh_rate`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`total_articles`,`total_subcategories`) VALUES (30 , '' , 0 , 0 , '0,' , 'Knowledge Base' , '' , 11 , NULL , NULL , 'article_order' , 'ASC' , NULL , 'article_date,article_title,short_description' , 'article_date,article_title,full_description' , 'article_date,article_title,full_description' , NULL , NULL , 0 , 1 , 1 , 7 , 7 , 7 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , 0 , 0 , 0 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 0 , 0 ) ;


















INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (1 , 2 , 1 ) ;
INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (1 , 3 , 2 ) ;
INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (2 , 1 , 2 ) ;
INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (2 , 3 , 1 ) ;
INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (3 , 1 , 2 ) ;
INSERT INTO va_articles_related (`article_id`,`related_id`,`related_order`) VALUES (3 , 2 , 1 ) ;


INSERT INTO va_articles_reviews (`review_id`,`article_id`,`user_id`,`admin_id`,`recommended`,`approved`,`rating`,`summary`,`user_name`,`user_email`,`remote_address`,`comments`,`admin_id_approved_by`,`admin_id_modified_by`,`date_added`,`date_modified`,`date_approved`) VALUES (1 , 1 , NULL , NULL , 1 , 1 , 4 , NULL , 'Author' , NULL , '10.1.1.6' , NULL , NULL , NULL , '2008-09-08 15:53:50' , NULL , NULL ) ;
INSERT INTO va_articles_reviews (`review_id`,`article_id`,`user_id`,`admin_id`,`recommended`,`approved`,`rating`,`summary`,`user_name`,`user_email`,`remote_address`,`comments`,`admin_id_approved_by`,`admin_id_modified_by`,`date_added`,`date_modified`,`date_approved`) VALUES (2 , 4 , NULL , NULL , 1 , 1 , 5 , NULL , 'test' , NULL , '127.0.0.1' , NULL , NULL , NULL , '2008-09-12 08:44:13' , NULL , NULL ) ;
INSERT INTO va_articles_reviews (`review_id`,`article_id`,`user_id`,`admin_id`,`recommended`,`approved`,`rating`,`summary`,`user_name`,`user_email`,`remote_address`,`comments`,`admin_id_approved_by`,`admin_id_modified_by`,`date_added`,`date_modified`,`date_approved`) VALUES (3 , 2 , NULL , NULL , 1 , 1 , 5 , NULL , 'test3' , NULL , '127.0.0.1' , NULL , NULL , NULL , '2008-09-09 13:11:48' , NULL , NULL ) ;
INSERT INTO va_articles_reviews (`review_id`,`article_id`,`user_id`,`admin_id`,`recommended`,`approved`,`rating`,`summary`,`user_name`,`user_email`,`remote_address`,`comments`,`admin_id_approved_by`,`admin_id_modified_by`,`date_added`,`date_modified`,`date_approved`) VALUES (4 , 3 , NULL , NULL , 1 , 1 , 0 , NULL , 'test2' , NULL , '127.0.0.1' , NULL , NULL , NULL , '2008-09-09 18:05:32' , NULL , NULL ) ;


INSERT INTO va_articles_statuses (`status_id`,`status_name`,`status_description`,`is_shown`,`status_icon`,`status_style`,`allowed_view`) VALUES (1 , 'ARTICLE_NEW_MSG' , NULL , 1 , NULL , NULL , 1 ) ;
INSERT INTO va_articles_statuses (`status_id`,`status_name`,`status_description`,`is_shown`,`status_icon`,`status_style`,`allowed_view`) VALUES (2 , 'ARTICLE_PUBLISHED_MSG' , NULL , 1 , NULL , NULL , 1 ) ;
INSERT INTO va_articles_statuses (`status_id`,`status_name`,`status_description`,`is_shown`,`status_icon`,`status_style`,`allowed_view`) VALUES (3 , 'ARTICLE_PENDING_MSG' , NULL , 1 , NULL , NULL , 0 ) ;
INSERT INTO va_articles_statuses (`status_id`,`status_name`,`status_description`,`is_shown`,`status_icon`,`status_style`,`allowed_view`) VALUES (4 , 'ARTICLE_HIDDEN_MSG' , NULL , 1 , NULL , NULL , 0 ) ;
























INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (16 , 'admin.php' , 'visits' , 'yesterday' , '2012-12-06 14:55:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (17 , 'admin.php' , 'visits' , 'this_week' , '2012-12-06 14:55:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (18 , 'admin.php' , 'visits' , 'this_month' , '2012-12-06 14:55:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (19 , 'admin.php' , 'visits' , 'last_month' , '2012-12-06 14:55:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (20 , 'admin.php' , 'visits' , 'total_year' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (26 , 'counts_users' , 'date' , '2010-06-01' , '2010-07-01 17:08:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (27 , 'counts_users' , 'date' , '2010-06-02' , '2010-07-01 17:08:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (28 , 'counts_users' , 'date' , '2010-06-03' , '2010-07-01 17:08:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (29 , 'counts_users' , 'date' , '2010-06-04' , '2010-07-01 17:08:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (30 , 'counts_users' , 'date' , '2010-06-05' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (31 , 'counts_users' , 'date' , '2010-06-06' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (32 , 'counts_users' , 'date' , '2010-06-07' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (33 , 'counts_users' , 'date' , '2010-06-08' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (34 , 'counts_users' , 'date' , '2010-06-09' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (35 , 'counts_users' , 'date' , '2010-06-10' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (36 , 'counts_users' , 'date' , '2010-06-11' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (37 , 'counts_users' , 'date' , '2010-06-12' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (38 , 'counts_users' , 'date' , '2010-06-13' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (39 , 'counts_users' , 'date' , '2010-06-14' , '2010-07-06 03:20:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (40 , 'counts_users' , 'date' , '2010-06-15' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (41 , 'counts_users' , 'date' , '2010-06-16' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (42 , 'counts_users' , 'date' , '2010-06-17' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (43 , 'counts_users' , 'date' , '2010-06-18' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (44 , 'counts_users' , 'date' , '2010-06-19' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (45 , 'counts_users' , 'date' , '2010-06-20' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (46 , 'counts_users' , 'date' , '2010-06-21' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (47 , 'counts_users' , 'date' , '2010-06-22' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (48 , 'counts_users' , 'date' , '2010-06-23' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (49 , 'counts_users' , 'date' , '2010-06-24' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (50 , 'counts_users' , 'date' , '2010-06-25' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (51 , 'counts_users' , 'date' , '2010-06-26' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (52 , 'counts_users' , 'date' , '2010-06-27' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (53 , 'counts_users' , 'date' , '2010-06-28' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (54 , 'counts_users' , 'date' , '2010-06-29' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (55 , 'counts_users' , 'date' , '2010-06-30' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (56 , 'counts_orders' , 'date' , '2010-06-01' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (57 , 'counts_orders' , 'date' , '2010-06-02' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (58 , 'counts_orders' , 'date' , '2010-06-03' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (59 , 'counts_orders' , 'date' , '2010-06-04' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (60 , 'counts_orders' , 'date' , '2010-06-05' , '2010-07-01 17:08:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (61 , 'counts_orders' , 'date' , '2010-06-06' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (62 , 'counts_orders' , 'date' , '2010-06-07' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (63 , 'counts_orders' , 'date' , '2010-06-08' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (64 , 'counts_orders' , 'date' , '2010-06-09' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (65 , 'counts_orders' , 'date' , '2010-06-10' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (66 , 'counts_orders' , 'date' , '2010-06-11' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (67 , 'counts_orders' , 'date' , '2010-06-12' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (68 , 'counts_orders' , 'date' , '2010-06-13' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (69 , 'counts_orders' , 'date' , '2010-06-14' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (70 , 'counts_orders' , 'date' , '2010-06-15' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (71 , 'counts_orders' , 'date' , '2010-06-16' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (72 , 'counts_orders' , 'date' , '2010-06-17' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (73 , 'counts_orders' , 'date' , '2010-06-18' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (74 , 'counts_orders' , 'date' , '2010-06-19' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (75 , 'counts_orders' , 'date' , '2010-06-20' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (76 , 'counts_orders' , 'date' , '2010-06-21' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (77 , 'counts_orders' , 'date' , '2010-06-22' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (78 , 'counts_orders' , 'date' , '2010-06-23' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (79 , 'counts_orders' , 'date' , '2010-06-24' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (80 , 'counts_orders' , 'date' , '2010-06-25' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (81 , 'counts_orders' , 'date' , '2010-06-26' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (82 , 'counts_orders' , 'date' , '2010-06-27' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (83 , 'counts_orders' , 'date' , '2010-06-28' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (84 , 'counts_orders' , 'date' , '2010-06-29' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (85 , 'counts_orders' , 'date' , '2010-06-30' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (86 , 'counts_sales' , 'date' , '2010-06-01' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (87 , 'counts_sales' , 'date' , '2010-06-02' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (88 , 'counts_sales' , 'date' , '2010-06-03' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (89 , 'counts_sales' , 'date' , '2010-06-04' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (90 , 'counts_sales' , 'date' , '2010-06-05' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (91 , 'counts_sales' , 'date' , '2010-06-06' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (92 , 'counts_sales' , 'date' , '2010-06-07' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (93 , 'counts_sales' , 'date' , '2010-06-08' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (94 , 'counts_sales' , 'date' , '2010-06-09' , '2010-07-06 03:20:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (95 , 'counts_sales' , 'date' , '2010-06-10' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (96 , 'counts_sales' , 'date' , '2010-06-11' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (97 , 'counts_sales' , 'date' , '2010-06-12' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (98 , 'counts_sales' , 'date' , '2010-06-13' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (99 , 'counts_sales' , 'date' , '2010-06-14' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (100 , 'counts_sales' , 'date' , '2010-06-15' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (101 , 'counts_sales' , 'date' , '2010-06-16' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (102 , 'counts_sales' , 'date' , '2010-06-17' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (103 , 'counts_sales' , 'date' , '2010-06-18' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (104 , 'counts_sales' , 'date' , '2010-06-19' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (105 , 'counts_sales' , 'date' , '2010-06-20' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (106 , 'counts_sales' , 'date' , '2010-06-21' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (107 , 'counts_sales' , 'date' , '2010-06-22' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (108 , 'counts_sales' , 'date' , '2010-06-23' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (109 , 'counts_sales' , 'date' , '2010-06-24' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (110 , 'counts_sales' , 'date' , '2010-06-25' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (111 , 'counts_sales' , 'date' , '2010-06-26' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (112 , 'counts_sales' , 'date' , '2010-06-27' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (113 , 'counts_sales' , 'date' , '2010-06-28' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (114 , 'counts_sales' , 'date' , '2010-06-29' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (115 , 'counts_sales' , 'date' , '2010-06-30' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (116 , 'counts_visits' , 'date' , '2010-06-01' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (117 , 'counts_visits' , 'date' , '2010-06-02' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (118 , 'counts_visits' , 'date' , '2010-06-03' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (119 , 'counts_visits' , 'date' , '2010-06-04' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (120 , 'counts_visits' , 'date' , '2010-06-05' , '2010-07-01 17:08:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (121 , 'counts_visits' , 'date' , '2010-06-06' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (122 , 'counts_visits' , 'date' , '2010-06-07' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (123 , 'counts_visits' , 'date' , '2010-06-08' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (124 , 'counts_visits' , 'date' , '2010-06-09' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (125 , 'counts_visits' , 'date' , '2010-06-10' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (126 , 'counts_visits' , 'date' , '2010-06-11' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (127 , 'counts_visits' , 'date' , '2010-06-12' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (128 , 'counts_visits' , 'date' , '2010-06-13' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (129 , 'counts_visits' , 'date' , '2010-06-14' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (130 , 'counts_visits' , 'date' , '2010-06-15' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (131 , 'counts_visits' , 'date' , '2010-06-16' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (132 , 'counts_visits' , 'date' , '2010-06-17' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (133 , 'counts_visits' , 'date' , '2010-06-18' , '2010-07-06 03:21:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (134 , 'counts_visits' , 'date' , '2010-06-19' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (135 , 'counts_visits' , 'date' , '2010-06-20' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (136 , 'counts_visits' , 'date' , '2010-06-21' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (137 , 'counts_visits' , 'date' , '2010-06-22' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (138 , 'counts_visits' , 'date' , '2010-06-23' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (139 , 'counts_visits' , 'date' , '2010-06-24' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (140 , 'counts_visits' , 'date' , '2010-06-25' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (141 , 'counts_visits' , 'date' , '2010-06-26' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (142 , 'counts_visits' , 'date' , '2010-06-27' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (143 , 'counts_visits' , 'date' , '2010-06-28' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (144 , 'counts_visits' , 'date' , '2010-06-29' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (145 , 'counts_visits' , 'date' , '2010-06-30' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (146 , 'counts_users' , 'date' , '2010-07-01' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (147 , 'counts_users' , 'date' , '2010-07-02' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (148 , 'counts_users' , 'date' , '2010-07-03' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (149 , 'counts_users' , 'date' , '2010-07-04' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (150 , 'counts_users' , 'date' , '2010-07-05' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (151 , 'counts_orders' , 'date' , '2010-07-01' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (152 , 'counts_orders' , 'date' , '2010-07-02' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (153 , 'counts_orders' , 'date' , '2010-07-03' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (154 , 'counts_orders' , 'date' , '2010-07-04' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (155 , 'counts_orders' , 'date' , '2010-07-05' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (156 , 'counts_sales' , 'date' , '2010-07-01' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (157 , 'counts_sales' , 'date' , '2010-07-02' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (158 , 'counts_sales' , 'date' , '2010-07-03' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (159 , 'counts_sales' , 'date' , '2010-07-04' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (160 , 'counts_sales' , 'date' , '2010-07-05' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (161 , 'counts_visits' , 'date' , '2010-07-01' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (162 , 'counts_visits' , 'date' , '2010-07-02' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (163 , 'counts_visits' , 'date' , '2010-07-03' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (164 , 'counts_visits' , 'date' , '2010-07-04' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (165 , 'counts_visits' , 'date' , '2010-07-05' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (166 , 'counts_users' , 'date' , '2010-07-06' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (167 , 'counts_users' , 'date' , '2010-07-07' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (168 , 'counts_users' , 'date' , '2010-07-08' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (169 , 'counts_users' , 'date' , '2010-07-09' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (170 , 'counts_users' , 'date' , '2010-07-10' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (171 , 'counts_users' , 'date' , '2010-07-11' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (172 , 'counts_users' , 'date' , '2010-07-12' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (173 , 'counts_users' , 'date' , '2010-07-13' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (174 , 'counts_users' , 'date' , '2010-07-14' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (175 , 'counts_users' , 'date' , '2010-07-15' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (176 , 'counts_users' , 'date' , '2010-07-16' , '2010-07-19 15:58:52' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (177 , 'counts_users' , 'date' , '2010-07-17' , '2010-08-16 20:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (178 , 'counts_users' , 'date' , '2010-07-18' , '2010-08-16 20:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (179 , 'counts_orders' , 'date' , '2010-07-06' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (180 , 'counts_orders' , 'date' , '2010-07-07' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (181 , 'counts_orders' , 'date' , '2010-07-08' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (182 , 'counts_orders' , 'date' , '2010-07-09' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (183 , 'counts_orders' , 'date' , '2010-07-10' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (184 , 'counts_orders' , 'date' , '2010-07-11' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (185 , 'counts_orders' , 'date' , '2010-07-12' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (186 , 'counts_orders' , 'date' , '2010-07-13' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (187 , 'counts_orders' , 'date' , '2010-07-14' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (188 , 'counts_orders' , 'date' , '2010-07-15' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (189 , 'counts_orders' , 'date' , '2010-07-16' , '2010-07-19 15:58:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (190 , 'counts_orders' , 'date' , '2010-07-17' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (191 , 'counts_orders' , 'date' , '2010-07-18' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (192 , 'counts_sales' , 'date' , '2010-07-06' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (193 , 'counts_sales' , 'date' , '2010-07-07' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (194 , 'counts_sales' , 'date' , '2010-07-08' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (195 , 'counts_sales' , 'date' , '2010-07-09' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (196 , 'counts_sales' , 'date' , '2010-07-10' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (197 , 'counts_sales' , 'date' , '2010-07-11' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (198 , 'counts_sales' , 'date' , '2010-07-12' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (199 , 'counts_sales' , 'date' , '2010-07-13' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (200 , 'counts_sales' , 'date' , '2010-07-14' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (201 , 'counts_sales' , 'date' , '2010-07-15' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (202 , 'counts_sales' , 'date' , '2010-07-16' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (203 , 'counts_sales' , 'date' , '2010-07-17' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (204 , 'counts_sales' , 'date' , '2010-07-18' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (205 , 'counts_visits' , 'date' , '2010-07-06' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (206 , 'counts_visits' , 'date' , '2010-07-07' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (207 , 'counts_visits' , 'date' , '2010-07-08' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (208 , 'counts_visits' , 'date' , '2010-07-09' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (209 , 'counts_visits' , 'date' , '2010-07-10' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (210 , 'counts_visits' , 'date' , '2010-07-11' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (211 , 'counts_visits' , 'date' , '2010-07-12' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (212 , 'counts_visits' , 'date' , '2010-07-13' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (213 , 'counts_visits' , 'date' , '2010-07-14' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (214 , 'counts_visits' , 'date' , '2010-07-15' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (215 , 'counts_visits' , 'date' , '2010-07-16' , '2010-07-19 15:58:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (216 , 'counts_visits' , 'date' , '2010-07-17' , '2010-08-16 20:47:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (217 , 'counts_visits' , 'date' , '2010-07-18' , '2010-08-16 20:47:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (218 , 'counts_users' , 'date' , '2010-07-19' , '2010-08-16 20:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (219 , 'counts_users' , 'date' , '2010-07-20' , '2010-08-16 20:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (220 , 'counts_users' , 'date' , '2010-07-21' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (221 , 'counts_users' , 'date' , '2010-07-22' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (222 , 'counts_users' , 'date' , '2010-07-23' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (223 , 'counts_users' , 'date' , '2010-07-24' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (224 , 'counts_users' , 'date' , '2010-07-25' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (225 , 'counts_users' , 'date' , '2010-07-26' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (226 , 'counts_users' , 'date' , '2010-07-27' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (227 , 'counts_users' , 'date' , '2010-07-28' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (228 , 'counts_users' , 'date' , '2010-07-29' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (229 , 'counts_users' , 'date' , '2010-07-30' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (230 , 'counts_users' , 'date' , '2010-07-31' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (231 , 'counts_users' , 'date' , '2010-08-01' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (232 , 'counts_users' , 'date' , '2010-08-02' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (233 , 'counts_users' , 'date' , '2010-08-03' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (234 , 'counts_users' , 'date' , '2010-08-04' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (235 , 'counts_users' , 'date' , '2010-08-05' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (236 , 'counts_users' , 'date' , '2010-08-06' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (237 , 'counts_users' , 'date' , '2010-08-07' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (238 , 'counts_users' , 'date' , '2010-08-08' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (239 , 'counts_users' , 'date' , '2010-08-09' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (240 , 'counts_users' , 'date' , '2010-08-10' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (241 , 'counts_users' , 'date' , '2010-08-11' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (242 , 'counts_users' , 'date' , '2010-08-12' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (243 , 'counts_users' , 'date' , '2010-08-13' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (244 , 'counts_users' , 'date' , '2010-08-14' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (245 , 'counts_users' , 'date' , '2010-08-15' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (246 , 'counts_orders' , 'date' , '2010-07-19' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (247 , 'counts_orders' , 'date' , '2010-07-20' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (248 , 'counts_orders' , 'date' , '2010-07-21' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (249 , 'counts_orders' , 'date' , '2010-07-22' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (250 , 'counts_orders' , 'date' , '2010-07-23' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (251 , 'counts_orders' , 'date' , '2010-07-24' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (252 , 'counts_orders' , 'date' , '2010-07-25' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (253 , 'counts_orders' , 'date' , '2010-07-26' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (254 , 'counts_orders' , 'date' , '2010-07-27' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (255 , 'counts_orders' , 'date' , '2010-07-28' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (256 , 'counts_orders' , 'date' , '2010-07-29' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (257 , 'counts_orders' , 'date' , '2010-07-30' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (258 , 'counts_orders' , 'date' , '2010-07-31' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (259 , 'counts_orders' , 'date' , '2010-08-01' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (260 , 'counts_orders' , 'date' , '2010-08-02' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (261 , 'counts_orders' , 'date' , '2010-08-03' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (262 , 'counts_orders' , 'date' , '2010-08-04' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (263 , 'counts_orders' , 'date' , '2010-08-05' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (264 , 'counts_orders' , 'date' , '2010-08-06' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (265 , 'counts_orders' , 'date' , '2010-08-07' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (266 , 'counts_orders' , 'date' , '2010-08-08' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (267 , 'counts_orders' , 'date' , '2010-08-09' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (268 , 'counts_orders' , 'date' , '2010-08-10' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (269 , 'counts_orders' , 'date' , '2010-08-11' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (270 , 'counts_orders' , 'date' , '2010-08-12' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (271 , 'counts_orders' , 'date' , '2010-08-13' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (272 , 'counts_orders' , 'date' , '2010-08-14' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (273 , 'counts_orders' , 'date' , '2010-08-15' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (274 , 'counts_sales' , 'date' , '2010-07-19' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (275 , 'counts_sales' , 'date' , '2010-07-20' , '2010-08-16 20:47:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (276 , 'counts_sales' , 'date' , '2010-07-21' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (277 , 'counts_sales' , 'date' , '2010-07-22' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (278 , 'counts_sales' , 'date' , '2010-07-23' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (279 , 'counts_sales' , 'date' , '2010-07-24' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (280 , 'counts_sales' , 'date' , '2010-07-25' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (281 , 'counts_sales' , 'date' , '2010-07-26' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (282 , 'counts_sales' , 'date' , '2010-07-27' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (283 , 'counts_sales' , 'date' , '2010-07-28' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (284 , 'counts_sales' , 'date' , '2010-07-29' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (285 , 'counts_sales' , 'date' , '2010-07-30' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (286 , 'counts_sales' , 'date' , '2010-07-31' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (287 , 'counts_sales' , 'date' , '2010-08-01' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (288 , 'counts_sales' , 'date' , '2010-08-02' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (289 , 'counts_sales' , 'date' , '2010-08-03' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (290 , 'counts_sales' , 'date' , '2010-08-04' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (291 , 'counts_sales' , 'date' , '2010-08-05' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (292 , 'counts_sales' , 'date' , '2010-08-06' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (293 , 'counts_sales' , 'date' , '2010-08-07' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (294 , 'counts_sales' , 'date' , '2010-08-08' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (295 , 'counts_sales' , 'date' , '2010-08-09' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (296 , 'counts_sales' , 'date' , '2010-08-10' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (297 , 'counts_sales' , 'date' , '2010-08-11' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (298 , 'counts_sales' , 'date' , '2010-08-12' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (299 , 'counts_sales' , 'date' , '2010-08-13' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (300 , 'counts_sales' , 'date' , '2010-08-14' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (301 , 'counts_sales' , 'date' , '2010-08-15' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (302 , 'counts_visits' , 'date' , '2010-07-19' , '2010-08-16 20:47:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (303 , 'counts_visits' , 'date' , '2010-07-20' , '2010-08-16 20:47:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (304 , 'counts_visits' , 'date' , '2010-07-21' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (305 , 'counts_visits' , 'date' , '2010-07-22' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (306 , 'counts_visits' , 'date' , '2010-07-23' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (307 , 'counts_visits' , 'date' , '2010-07-24' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (308 , 'counts_visits' , 'date' , '2010-07-25' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (309 , 'counts_visits' , 'date' , '2010-07-26' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (310 , 'counts_visits' , 'date' , '2010-07-27' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (311 , 'counts_visits' , 'date' , '2010-07-28' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (312 , 'counts_visits' , 'date' , '2010-07-29' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (313 , 'counts_visits' , 'date' , '2010-07-30' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (314 , 'counts_visits' , 'date' , '2010-07-31' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (315 , 'counts_visits' , 'date' , '2010-08-01' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (316 , 'counts_visits' , 'date' , '2010-08-02' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (317 , 'counts_visits' , 'date' , '2010-08-03' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (318 , 'counts_visits' , 'date' , '2010-08-04' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (319 , 'counts_visits' , 'date' , '2010-08-05' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (320 , 'counts_visits' , 'date' , '2010-08-06' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (321 , 'counts_visits' , 'date' , '2010-08-07' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (322 , 'counts_visits' , 'date' , '2010-08-08' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (323 , 'counts_visits' , 'date' , '2010-08-09' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (324 , 'counts_visits' , 'date' , '2010-08-10' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (325 , 'counts_visits' , 'date' , '2010-08-11' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (326 , 'counts_visits' , 'date' , '2010-08-12' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (327 , 'counts_visits' , 'date' , '2010-08-13' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (328 , 'counts_visits' , 'date' , '2010-08-14' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (329 , 'counts_visits' , 'date' , '2010-08-15' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (330 , 'counts_users' , 'date' , '2010-08-16' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (331 , 'counts_users' , 'date' , '2010-08-17' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (332 , 'counts_users' , 'date' , '2010-08-18' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (333 , 'counts_users' , 'date' , '2010-08-19' , '2010-08-20 20:50:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (334 , 'counts_sales' , 'date' , '2010-08-16' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (335 , 'counts_sales' , 'date' , '2010-08-17' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (336 , 'counts_sales' , 'date' , '2010-08-18' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (337 , 'counts_sales' , 'date' , '2010-08-19' , '2010-08-20 20:50:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (338 , 'counts_visits' , 'date' , '2010-08-16' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (339 , 'counts_visits' , 'date' , '2010-08-17' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (340 , 'counts_visits' , 'date' , '2010-08-18' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (341 , 'counts_visits' , 'date' , '2010-08-19' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (342 , 'counts_orders' , 'date' , '2010-08-16' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (343 , 'counts_orders' , 'date' , '2010-08-17' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (344 , 'counts_orders' , 'date' , '2010-08-18' , '2010-08-20 20:50:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (345 , 'counts_orders' , 'date' , '2010-08-19' , '2010-08-20 20:50:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (346 , 'counts_users' , 'date' , '2010-08-20' , '2010-09-19 03:29:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (347 , 'counts_users' , 'date' , '2010-08-21' , '2010-09-19 03:29:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (348 , 'counts_users' , 'date' , '2010-08-22' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (349 , 'counts_users' , 'date' , '2010-08-23' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (350 , 'counts_users' , 'date' , '2010-08-24' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (351 , 'counts_users' , 'date' , '2010-08-25' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (352 , 'counts_users' , 'date' , '2010-08-26' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (353 , 'counts_users' , 'date' , '2010-08-27' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (354 , 'counts_users' , 'date' , '2010-08-28' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (355 , 'counts_users' , 'date' , '2010-08-29' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (356 , 'counts_users' , 'date' , '2010-08-30' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (357 , 'counts_users' , 'date' , '2010-08-31' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (358 , 'counts_users' , 'date' , '2010-09-01' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (359 , 'counts_users' , 'date' , '2010-09-02' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (360 , 'counts_users' , 'date' , '2010-09-03' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (361 , 'counts_users' , 'date' , '2010-09-04' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (362 , 'counts_users' , 'date' , '2010-09-05' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (363 , 'counts_users' , 'date' , '2010-09-06' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (364 , 'counts_users' , 'date' , '2010-09-07' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (365 , 'counts_users' , 'date' , '2010-09-08' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (366 , 'counts_users' , 'date' , '2010-09-09' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (367 , 'counts_users' , 'date' , '2010-09-10' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (368 , 'counts_users' , 'date' , '2010-09-11' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (369 , 'counts_users' , 'date' , '2010-09-12' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (370 , 'counts_users' , 'date' , '2010-09-13' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (371 , 'counts_users' , 'date' , '2010-09-14' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (372 , 'counts_users' , 'date' , '2010-09-15' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (373 , 'counts_users' , 'date' , '2010-09-16' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (374 , 'counts_users' , 'date' , '2010-09-17' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (375 , 'counts_users' , 'date' , '2010-09-18' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (376 , 'counts_sales' , 'date' , '2010-08-20' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (377 , 'counts_sales' , 'date' , '2010-08-21' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (378 , 'counts_sales' , 'date' , '2010-08-22' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (379 , 'counts_sales' , 'date' , '2010-08-23' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (380 , 'counts_sales' , 'date' , '2010-08-24' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (381 , 'counts_sales' , 'date' , '2010-08-25' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (382 , 'counts_sales' , 'date' , '2010-08-26' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (383 , 'counts_sales' , 'date' , '2010-08-27' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (384 , 'counts_sales' , 'date' , '2010-08-28' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (385 , 'counts_sales' , 'date' , '2010-08-29' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (386 , 'counts_sales' , 'date' , '2010-08-30' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (387 , 'counts_sales' , 'date' , '2010-08-31' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (388 , 'counts_sales' , 'date' , '2010-09-01' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (389 , 'counts_sales' , 'date' , '2010-09-02' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (390 , 'counts_sales' , 'date' , '2010-09-03' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (391 , 'counts_sales' , 'date' , '2010-09-04' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (392 , 'counts_sales' , 'date' , '2010-09-05' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (393 , 'counts_sales' , 'date' , '2010-09-06' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (394 , 'counts_sales' , 'date' , '2010-09-07' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (395 , 'counts_sales' , 'date' , '2010-09-08' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (396 , 'counts_sales' , 'date' , '2010-09-09' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (397 , 'counts_sales' , 'date' , '2010-09-10' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (398 , 'counts_sales' , 'date' , '2010-09-11' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (399 , 'counts_sales' , 'date' , '2010-09-12' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (400 , 'counts_sales' , 'date' , '2010-09-13' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (401 , 'counts_sales' , 'date' , '2010-09-14' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (402 , 'counts_sales' , 'date' , '2010-09-15' , '2010-09-19 03:29:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (403 , 'counts_sales' , 'date' , '2010-09-16' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (404 , 'counts_sales' , 'date' , '2010-09-17' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (405 , 'counts_sales' , 'date' , '2010-09-18' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (406 , 'counts_visits' , 'date' , '2010-08-20' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (407 , 'counts_visits' , 'date' , '2010-08-21' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (408 , 'counts_visits' , 'date' , '2010-08-22' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (409 , 'counts_visits' , 'date' , '2010-08-23' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (410 , 'counts_visits' , 'date' , '2010-08-24' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (411 , 'counts_visits' , 'date' , '2010-08-25' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (412 , 'counts_visits' , 'date' , '2010-08-26' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (413 , 'counts_visits' , 'date' , '2010-08-27' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (414 , 'counts_visits' , 'date' , '2010-08-28' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (415 , 'counts_visits' , 'date' , '2010-08-29' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (416 , 'counts_visits' , 'date' , '2010-08-30' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (417 , 'counts_visits' , 'date' , '2010-08-31' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (418 , 'counts_visits' , 'date' , '2010-09-01' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (419 , 'counts_visits' , 'date' , '2010-09-02' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (420 , 'counts_visits' , 'date' , '2010-09-03' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (421 , 'counts_visits' , 'date' , '2010-09-04' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (422 , 'counts_visits' , 'date' , '2010-09-05' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (423 , 'counts_visits' , 'date' , '2010-09-06' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (424 , 'counts_visits' , 'date' , '2010-09-07' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (425 , 'counts_visits' , 'date' , '2010-09-08' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (426 , 'counts_visits' , 'date' , '2010-09-09' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (427 , 'counts_visits' , 'date' , '2010-09-10' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (428 , 'counts_visits' , 'date' , '2010-09-11' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (429 , 'counts_visits' , 'date' , '2010-09-12' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (430 , 'counts_visits' , 'date' , '2010-09-13' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (431 , 'counts_visits' , 'date' , '2010-09-14' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (432 , 'counts_visits' , 'date' , '2010-09-15' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (433 , 'counts_visits' , 'date' , '2010-09-16' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (434 , 'counts_visits' , 'date' , '2010-09-17' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (435 , 'counts_visits' , 'date' , '2010-09-18' , '2010-09-19 03:29:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (436 , 'counts_visits' , 'date' , '2010-09-27' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (437 , 'counts_visits' , 'date' , '2010-09-28' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (438 , 'counts_visits' , 'date' , '2010-09-29' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (439 , 'counts_visits' , 'date' , '2010-09-30' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (440 , 'counts_visits' , 'date' , '2010-10-01' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (441 , 'counts_visits' , 'date' , '2010-10-02' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (442 , 'counts_visits' , 'date' , '2010-10-03' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (443 , 'counts_visits' , 'date' , '2010-10-04' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (444 , 'counts_visits' , 'date' , '2010-10-05' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (445 , 'counts_visits' , 'date' , '2010-10-06' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (446 , 'counts_visits' , 'date' , '2010-10-07' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (447 , 'counts_visits' , 'date' , '2010-10-08' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (448 , 'counts_visits' , 'date' , '2010-10-09' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (449 , 'counts_visits' , 'date' , '2010-10-10' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (450 , 'counts_visits' , 'date' , '2010-10-11' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (451 , 'counts_visits' , 'date' , '2010-10-12' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (452 , 'counts_visits' , 'date' , '2010-10-13' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (453 , 'counts_visits' , 'date' , '2010-10-14' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (454 , 'counts_visits' , 'date' , '2010-10-15' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (455 , 'counts_visits' , 'date' , '2010-10-16' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (456 , 'counts_visits' , 'date' , '2010-10-17' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (457 , 'counts_visits' , 'date' , '2010-10-18' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (458 , 'counts_visits' , 'date' , '2010-10-19' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (459 , 'counts_visits' , 'date' , '2010-10-20' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (460 , 'counts_visits' , 'date' , '2010-10-21' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (461 , 'counts_visits' , 'date' , '2010-10-22' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (462 , 'counts_visits' , 'date' , '2010-10-23' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (463 , 'counts_visits' , 'date' , '2010-10-24' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (464 , 'counts_visits' , 'date' , '2010-10-25' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (465 , 'counts_visits' , 'date' , '2010-10-26' , '2010-10-27 20:42:07' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (466 , 'counts_users' , 'date' , '2010-09-27' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (467 , 'counts_users' , 'date' , '2010-09-28' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (468 , 'counts_users' , 'date' , '2010-09-29' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (469 , 'counts_users' , 'date' , '2010-09-30' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (470 , 'counts_users' , 'date' , '2010-10-01' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (471 , 'counts_users' , 'date' , '2010-10-02' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (472 , 'counts_users' , 'date' , '2010-10-03' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (473 , 'counts_users' , 'date' , '2010-10-04' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (474 , 'counts_users' , 'date' , '2010-10-05' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (475 , 'counts_users' , 'date' , '2010-10-06' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (476 , 'counts_users' , 'date' , '2010-10-07' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (477 , 'counts_users' , 'date' , '2010-10-08' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (478 , 'counts_users' , 'date' , '2010-10-09' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (479 , 'counts_users' , 'date' , '2010-10-10' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (480 , 'counts_users' , 'date' , '2010-10-11' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (481 , 'counts_users' , 'date' , '2010-10-12' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (482 , 'counts_users' , 'date' , '2010-10-13' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (483 , 'counts_users' , 'date' , '2010-10-14' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (484 , 'counts_users' , 'date' , '2010-10-15' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (485 , 'counts_users' , 'date' , '2010-10-16' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (486 , 'counts_users' , 'date' , '2010-10-17' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (487 , 'counts_users' , 'date' , '2010-10-18' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (488 , 'counts_users' , 'date' , '2010-10-19' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (489 , 'counts_users' , 'date' , '2010-10-20' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (490 , 'counts_users' , 'date' , '2010-10-21' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (491 , 'counts_users' , 'date' , '2010-10-22' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (492 , 'counts_users' , 'date' , '2010-10-23' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (493 , 'counts_users' , 'date' , '2010-10-24' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (494 , 'counts_users' , 'date' , '2010-10-25' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (495 , 'counts_users' , 'date' , '2010-10-26' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (496 , 'counts_sales' , 'date' , '2010-09-27' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (497 , 'counts_sales' , 'date' , '2010-09-28' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (498 , 'counts_sales' , 'date' , '2010-09-29' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (499 , 'counts_sales' , 'date' , '2010-09-30' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (500 , 'counts_sales' , 'date' , '2010-10-01' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (501 , 'counts_sales' , 'date' , '2010-10-02' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (502 , 'counts_sales' , 'date' , '2010-10-03' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (503 , 'counts_sales' , 'date' , '2010-10-04' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (504 , 'counts_sales' , 'date' , '2010-10-05' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (505 , 'counts_sales' , 'date' , '2010-10-06' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (506 , 'counts_sales' , 'date' , '2010-10-07' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (507 , 'counts_sales' , 'date' , '2010-10-08' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (508 , 'counts_sales' , 'date' , '2010-10-09' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (509 , 'counts_sales' , 'date' , '2010-10-10' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (510 , 'counts_sales' , 'date' , '2010-10-11' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (511 , 'counts_sales' , 'date' , '2010-10-12' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (512 , 'counts_sales' , 'date' , '2010-10-13' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (513 , 'counts_sales' , 'date' , '2010-10-14' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (514 , 'counts_sales' , 'date' , '2010-10-15' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (515 , 'counts_sales' , 'date' , '2010-10-16' , '2010-10-27 20:42:08' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (516 , 'counts_sales' , 'date' , '2010-10-17' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (517 , 'counts_sales' , 'date' , '2010-10-18' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (518 , 'counts_sales' , 'date' , '2010-10-19' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (519 , 'counts_sales' , 'date' , '2010-10-20' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (520 , 'counts_sales' , 'date' , '2010-10-21' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (521 , 'counts_sales' , 'date' , '2010-10-22' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (522 , 'counts_sales' , 'date' , '2010-10-23' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (523 , 'counts_sales' , 'date' , '2010-10-24' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (524 , 'counts_sales' , 'date' , '2010-10-25' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (525 , 'counts_sales' , 'date' , '2010-10-26' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (526 , 'counts_orders' , 'date' , '2010-09-27' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (527 , 'counts_orders' , 'date' , '2010-09-28' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (528 , 'counts_orders' , 'date' , '2010-09-29' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (529 , 'counts_orders' , 'date' , '2010-09-30' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (530 , 'counts_orders' , 'date' , '2010-10-01' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (531 , 'counts_orders' , 'date' , '2010-10-02' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (532 , 'counts_orders' , 'date' , '2010-10-03' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (533 , 'counts_orders' , 'date' , '2010-10-04' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (534 , 'counts_orders' , 'date' , '2010-10-05' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (535 , 'counts_orders' , 'date' , '2010-10-06' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (536 , 'counts_orders' , 'date' , '2010-10-07' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (537 , 'counts_orders' , 'date' , '2010-10-08' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (538 , 'counts_orders' , 'date' , '2010-10-09' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (539 , 'counts_orders' , 'date' , '2010-10-10' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (540 , 'counts_orders' , 'date' , '2010-10-11' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (541 , 'counts_orders' , 'date' , '2010-10-12' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (542 , 'counts_orders' , 'date' , '2010-10-13' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (543 , 'counts_orders' , 'date' , '2010-10-14' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (544 , 'counts_orders' , 'date' , '2010-10-15' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (545 , 'counts_orders' , 'date' , '2010-10-16' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (546 , 'counts_orders' , 'date' , '2010-10-17' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (547 , 'counts_orders' , 'date' , '2010-10-18' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (548 , 'counts_orders' , 'date' , '2010-10-19' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (549 , 'counts_orders' , 'date' , '2010-10-20' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (550 , 'counts_orders' , 'date' , '2010-10-21' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (551 , 'counts_orders' , 'date' , '2010-10-22' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (552 , 'counts_orders' , 'date' , '2010-10-23' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (553 , 'counts_orders' , 'date' , '2010-10-24' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (554 , 'counts_orders' , 'date' , '2010-10-25' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (555 , 'counts_orders' , 'date' , '2010-10-26' , '2010-10-27 20:42:09' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (556 , 'counts_users' , 'date' , '2010-10-27' , '2010-10-28 04:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (557 , 'counts_orders' , 'date' , '2010-10-27' , '2010-10-28 04:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (558 , 'counts_sales' , 'date' , '2010-10-27' , '2010-10-28 04:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (559 , 'counts_visits' , 'date' , '2010-10-27' , '2010-10-28 04:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (560 , 'counts_orders' , 'date' , '2010-11-01' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (561 , 'counts_orders' , 'date' , '2010-11-02' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (562 , 'counts_orders' , 'date' , '2010-11-03' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (563 , 'counts_orders' , 'date' , '2010-11-04' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (564 , 'counts_orders' , 'date' , '2010-11-05' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (565 , 'counts_orders' , 'date' , '2010-11-06' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (566 , 'counts_orders' , 'date' , '2010-11-07' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (567 , 'counts_orders' , 'date' , '2010-11-08' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (568 , 'counts_orders' , 'date' , '2010-11-09' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (569 , 'counts_orders' , 'date' , '2010-11-10' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (570 , 'counts_orders' , 'date' , '2010-11-11' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (571 , 'counts_orders' , 'date' , '2010-11-12' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (572 , 'counts_orders' , 'date' , '2010-11-13' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (573 , 'counts_orders' , 'date' , '2010-11-14' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (574 , 'counts_orders' , 'date' , '2010-11-15' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (575 , 'counts_orders' , 'date' , '2010-11-16' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (576 , 'counts_orders' , 'date' , '2010-11-17' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (577 , 'counts_orders' , 'date' , '2010-11-18' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (578 , 'counts_orders' , 'date' , '2010-11-19' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (579 , 'counts_orders' , 'date' , '2010-11-20' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (580 , 'counts_orders' , 'date' , '2010-11-21' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (581 , 'counts_orders' , 'date' , '2010-11-22' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (582 , 'counts_orders' , 'date' , '2010-11-23' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (583 , 'counts_orders' , 'date' , '2010-11-24' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (584 , 'counts_orders' , 'date' , '2010-11-25' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (585 , 'counts_orders' , 'date' , '2010-11-26' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (586 , 'counts_orders' , 'date' , '2010-11-27' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (587 , 'counts_orders' , 'date' , '2010-11-28' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (588 , 'counts_orders' , 'date' , '2010-11-29' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (589 , 'counts_orders' , 'date' , '2010-11-30' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (590 , 'counts_visits' , 'date' , '2010-11-01' , '2010-12-01 17:47:27' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (591 , 'counts_visits' , 'date' , '2010-11-02' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (592 , 'counts_visits' , 'date' , '2010-11-03' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (593 , 'counts_visits' , 'date' , '2010-11-04' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (594 , 'counts_visits' , 'date' , '2010-11-05' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (595 , 'counts_visits' , 'date' , '2010-11-06' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (596 , 'counts_visits' , 'date' , '2010-11-07' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (597 , 'counts_visits' , 'date' , '2010-11-08' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (598 , 'counts_visits' , 'date' , '2010-11-09' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (599 , 'counts_visits' , 'date' , '2010-11-10' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (600 , 'counts_visits' , 'date' , '2010-11-11' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (601 , 'counts_visits' , 'date' , '2010-11-12' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (602 , 'counts_visits' , 'date' , '2010-11-13' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (603 , 'counts_visits' , 'date' , '2010-11-14' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (604 , 'counts_visits' , 'date' , '2010-11-15' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (605 , 'counts_visits' , 'date' , '2010-11-16' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (606 , 'counts_visits' , 'date' , '2010-11-17' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (607 , 'counts_visits' , 'date' , '2010-11-18' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (608 , 'counts_visits' , 'date' , '2010-11-19' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (609 , 'counts_visits' , 'date' , '2010-11-20' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (610 , 'counts_visits' , 'date' , '2010-11-21' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (611 , 'counts_visits' , 'date' , '2010-11-22' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (612 , 'counts_visits' , 'date' , '2010-11-23' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (613 , 'counts_visits' , 'date' , '2010-11-24' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (614 , 'counts_visits' , 'date' , '2010-11-25' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (615 , 'counts_visits' , 'date' , '2010-11-26' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (616 , 'counts_visits' , 'date' , '2010-11-27' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (617 , 'counts_visits' , 'date' , '2010-11-28' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (618 , 'counts_visits' , 'date' , '2010-11-29' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (619 , 'counts_visits' , 'date' , '2010-11-30' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (620 , 'counts_sales' , 'date' , '2010-11-01' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (621 , 'counts_sales' , 'date' , '2010-11-02' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (622 , 'counts_sales' , 'date' , '2010-11-03' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (623 , 'counts_sales' , 'date' , '2010-11-04' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (624 , 'counts_sales' , 'date' , '2010-11-05' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (625 , 'counts_sales' , 'date' , '2010-11-06' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (626 , 'counts_sales' , 'date' , '2010-11-07' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (627 , 'counts_sales' , 'date' , '2010-11-08' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (628 , 'counts_sales' , 'date' , '2010-11-09' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (629 , 'counts_sales' , 'date' , '2010-11-10' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (630 , 'counts_sales' , 'date' , '2010-11-11' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (631 , 'counts_sales' , 'date' , '2010-11-12' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (632 , 'counts_sales' , 'date' , '2010-11-13' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (633 , 'counts_sales' , 'date' , '2010-11-14' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (634 , 'counts_sales' , 'date' , '2010-11-15' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (635 , 'counts_sales' , 'date' , '2010-11-16' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (636 , 'counts_sales' , 'date' , '2010-11-17' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (637 , 'counts_sales' , 'date' , '2010-11-18' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (638 , 'counts_sales' , 'date' , '2010-11-19' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (639 , 'counts_sales' , 'date' , '2010-11-20' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (640 , 'counts_sales' , 'date' , '2010-11-21' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (641 , 'counts_sales' , 'date' , '2010-11-22' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (642 , 'counts_sales' , 'date' , '2010-11-23' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (643 , 'counts_sales' , 'date' , '2010-11-24' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (644 , 'counts_sales' , 'date' , '2010-11-25' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (645 , 'counts_sales' , 'date' , '2010-11-26' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (646 , 'counts_sales' , 'date' , '2010-11-27' , '2010-12-01 17:47:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (647 , 'counts_sales' , 'date' , '2010-11-28' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (648 , 'counts_sales' , 'date' , '2010-11-29' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (649 , 'counts_sales' , 'date' , '2010-11-30' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (650 , 'counts_users' , 'date' , '2010-11-01' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (651 , 'counts_users' , 'date' , '2010-11-02' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (652 , 'counts_users' , 'date' , '2010-11-03' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (653 , 'counts_users' , 'date' , '2010-11-04' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (654 , 'counts_users' , 'date' , '2010-11-05' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (655 , 'counts_users' , 'date' , '2010-11-06' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (656 , 'counts_users' , 'date' , '2010-11-07' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (657 , 'counts_users' , 'date' , '2010-11-08' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (658 , 'counts_users' , 'date' , '2010-11-09' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (659 , 'counts_users' , 'date' , '2010-11-10' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (660 , 'counts_users' , 'date' , '2010-11-11' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (661 , 'counts_users' , 'date' , '2010-11-12' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (662 , 'counts_users' , 'date' , '2010-11-13' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (663 , 'counts_users' , 'date' , '2010-11-14' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (664 , 'counts_users' , 'date' , '2010-11-15' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (665 , 'counts_users' , 'date' , '2010-11-16' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (666 , 'counts_users' , 'date' , '2010-11-17' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (667 , 'counts_users' , 'date' , '2010-11-18' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (668 , 'counts_users' , 'date' , '2010-11-19' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (669 , 'counts_users' , 'date' , '2010-11-20' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (670 , 'counts_users' , 'date' , '2010-11-21' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (671 , 'counts_users' , 'date' , '2010-11-22' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (672 , 'counts_users' , 'date' , '2010-11-23' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (673 , 'counts_users' , 'date' , '2010-11-24' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (674 , 'counts_users' , 'date' , '2010-11-25' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (675 , 'counts_users' , 'date' , '2010-11-26' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (676 , 'counts_users' , 'date' , '2010-11-27' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (677 , 'counts_users' , 'date' , '2010-11-28' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (678 , 'counts_users' , 'date' , '2010-11-29' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (679 , 'counts_users' , 'date' , '2010-11-30' , '2010-12-01 17:47:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (680 , 'counts_visits' , 'date' , '2011-03-23' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (681 , 'counts_visits' , 'date' , '2011-03-24' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (682 , 'counts_visits' , 'date' , '2011-03-25' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (683 , 'counts_visits' , 'date' , '2011-03-26' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (684 , 'counts_visits' , 'date' , '2011-03-27' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (685 , 'counts_visits' , 'date' , '2011-03-28' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (686 , 'counts_visits' , 'date' , '2011-03-29' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (687 , 'counts_visits' , 'date' , '2011-03-30' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (688 , 'counts_visits' , 'date' , '2011-03-31' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (689 , 'counts_visits' , 'date' , '2011-04-01' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (690 , 'counts_visits' , 'date' , '2011-04-02' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (691 , 'counts_visits' , 'date' , '2011-04-03' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (692 , 'counts_visits' , 'date' , '2011-04-04' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (693 , 'counts_visits' , 'date' , '2011-04-05' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (694 , 'counts_visits' , 'date' , '2011-04-06' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (695 , 'counts_visits' , 'date' , '2011-04-07' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (696 , 'counts_visits' , 'date' , '2011-04-08' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (697 , 'counts_visits' , 'date' , '2011-04-09' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (698 , 'counts_visits' , 'date' , '2011-04-10' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (699 , 'counts_visits' , 'date' , '2011-04-11' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (700 , 'counts_visits' , 'date' , '2011-04-12' , '2011-04-22 20:03:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (701 , 'counts_visits' , 'date' , '2011-04-13' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (702 , 'counts_visits' , 'date' , '2011-04-14' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (703 , 'counts_visits' , 'date' , '2011-04-15' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (704 , 'counts_visits' , 'date' , '2011-04-16' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (705 , 'counts_visits' , 'date' , '2011-04-17' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (706 , 'counts_visits' , 'date' , '2011-04-18' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (707 , 'counts_visits' , 'date' , '2011-04-19' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (708 , 'counts_visits' , 'date' , '2011-04-20' , '2011-05-20 12:36:02' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (709 , 'counts_visits' , 'date' , '2011-04-21' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (710 , 'counts_users' , 'date' , '2011-03-23' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (711 , 'counts_users' , 'date' , '2011-03-24' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (712 , 'counts_users' , 'date' , '2011-03-25' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (713 , 'counts_users' , 'date' , '2011-03-26' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (714 , 'counts_users' , 'date' , '2011-03-27' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (715 , 'counts_users' , 'date' , '2011-03-28' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (716 , 'counts_users' , 'date' , '2011-03-29' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (717 , 'counts_users' , 'date' , '2011-03-30' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (718 , 'counts_users' , 'date' , '2011-03-31' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (719 , 'counts_users' , 'date' , '2011-04-01' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (720 , 'counts_users' , 'date' , '2011-04-02' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (721 , 'counts_users' , 'date' , '2011-04-03' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (722 , 'counts_users' , 'date' , '2011-04-04' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (723 , 'counts_users' , 'date' , '2011-04-05' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (724 , 'counts_users' , 'date' , '2011-04-06' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (725 , 'counts_users' , 'date' , '2011-04-07' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (726 , 'counts_users' , 'date' , '2011-04-08' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (727 , 'counts_users' , 'date' , '2011-04-09' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (728 , 'counts_users' , 'date' , '2011-04-10' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (729 , 'counts_users' , 'date' , '2011-04-11' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (730 , 'counts_users' , 'date' , '2011-04-12' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (731 , 'counts_users' , 'date' , '2011-04-13' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (732 , 'counts_users' , 'date' , '2011-04-14' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (733 , 'counts_users' , 'date' , '2011-04-15' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (734 , 'counts_users' , 'date' , '2011-04-16' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (735 , 'counts_users' , 'date' , '2011-04-17' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (736 , 'counts_users' , 'date' , '2011-04-18' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (737 , 'counts_users' , 'date' , '2011-04-19' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (738 , 'counts_users' , 'date' , '2011-04-20' , '2011-05-20 12:36:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (739 , 'counts_users' , 'date' , '2011-04-21' , '2011-05-20 12:36:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (740 , 'counts_orders' , 'date' , '2011-03-23' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (741 , 'counts_orders' , 'date' , '2011-03-24' , '2011-04-22 20:03:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (742 , 'counts_orders' , 'date' , '2011-03-25' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (743 , 'counts_orders' , 'date' , '2011-03-26' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (744 , 'counts_orders' , 'date' , '2011-03-27' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (745 , 'counts_orders' , 'date' , '2011-03-28' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (746 , 'counts_orders' , 'date' , '2011-03-29' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (747 , 'counts_orders' , 'date' , '2011-03-30' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (748 , 'counts_orders' , 'date' , '2011-03-31' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (749 , 'counts_orders' , 'date' , '2011-04-01' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (750 , 'counts_orders' , 'date' , '2011-04-02' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (751 , 'counts_orders' , 'date' , '2011-04-03' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (752 , 'counts_orders' , 'date' , '2011-04-04' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (753 , 'counts_orders' , 'date' , '2011-04-05' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (754 , 'counts_orders' , 'date' , '2011-04-06' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (755 , 'counts_orders' , 'date' , '2011-04-07' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (756 , 'counts_orders' , 'date' , '2011-04-08' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (757 , 'counts_orders' , 'date' , '2011-04-09' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (758 , 'counts_orders' , 'date' , '2011-04-10' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (759 , 'counts_orders' , 'date' , '2011-04-11' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (760 , 'counts_orders' , 'date' , '2011-04-12' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (761 , 'counts_orders' , 'date' , '2011-04-13' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (762 , 'counts_orders' , 'date' , '2011-04-14' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (763 , 'counts_orders' , 'date' , '2011-04-15' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (764 , 'counts_orders' , 'date' , '2011-04-16' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (765 , 'counts_orders' , 'date' , '2011-04-17' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (766 , 'counts_orders' , 'date' , '2011-04-18' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (767 , 'counts_orders' , 'date' , '2011-04-19' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (768 , 'counts_orders' , 'date' , '2011-04-20' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (769 , 'counts_orders' , 'date' , '2011-04-21' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (770 , 'counts_sales' , 'date' , '2011-03-23' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (771 , 'counts_sales' , 'date' , '2011-03-24' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (772 , 'counts_sales' , 'date' , '2011-03-25' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (773 , 'counts_sales' , 'date' , '2011-03-26' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (774 , 'counts_sales' , 'date' , '2011-03-27' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (775 , 'counts_sales' , 'date' , '2011-03-28' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (776 , 'counts_sales' , 'date' , '2011-03-29' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (777 , 'counts_sales' , 'date' , '2011-03-30' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (778 , 'counts_sales' , 'date' , '2011-03-31' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (779 , 'counts_sales' , 'date' , '2011-04-01' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (780 , 'counts_sales' , 'date' , '2011-04-02' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (781 , 'counts_sales' , 'date' , '2011-04-03' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (782 , 'counts_sales' , 'date' , '2011-04-04' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (783 , 'counts_sales' , 'date' , '2011-04-05' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (784 , 'counts_sales' , 'date' , '2011-04-06' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (785 , 'counts_sales' , 'date' , '2011-04-07' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (786 , 'counts_sales' , 'date' , '2011-04-08' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (787 , 'counts_sales' , 'date' , '2011-04-09' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (788 , 'counts_sales' , 'date' , '2011-04-10' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (789 , 'counts_sales' , 'date' , '2011-04-11' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (790 , 'counts_sales' , 'date' , '2011-04-12' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (791 , 'counts_sales' , 'date' , '2011-04-13' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (792 , 'counts_sales' , 'date' , '2011-04-14' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (793 , 'counts_sales' , 'date' , '2011-04-15' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (794 , 'counts_sales' , 'date' , '2011-04-16' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (795 , 'counts_sales' , 'date' , '2011-04-17' , '2011-04-22 20:03:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (796 , 'counts_sales' , 'date' , '2011-04-18' , '2011-04-22 20:03:56' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (797 , 'counts_sales' , 'date' , '2011-04-19' , '2011-04-22 20:03:56' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (798 , 'counts_sales' , 'date' , '2011-04-20' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (799 , 'counts_sales' , 'date' , '2011-04-21' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (800 , 'counts_orders' , 'date' , '2011-04-22' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (801 , 'counts_orders' , 'date' , '2011-04-23' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (802 , 'counts_orders' , 'date' , '2011-04-24' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (803 , 'counts_orders' , 'date' , '2011-04-25' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (804 , 'counts_orders' , 'date' , '2011-04-26' , '2011-05-20 12:35:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (805 , 'counts_orders' , 'date' , '2011-04-27' , '2011-05-27 14:52:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (806 , 'counts_orders' , 'date' , '2011-04-28' , '2011-05-27 14:52:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (807 , 'counts_orders' , 'date' , '2011-04-29' , '2011-05-27 14:52:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (808 , 'counts_orders' , 'date' , '2011-04-30' , '2011-05-27 14:52:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (809 , 'counts_orders' , 'date' , '2011-05-01' , '2011-05-27 14:52:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (810 , 'counts_orders' , 'date' , '2011-05-02' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (811 , 'counts_orders' , 'date' , '2011-05-03' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (812 , 'counts_orders' , 'date' , '2011-05-04' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (813 , 'counts_orders' , 'date' , '2011-05-05' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (814 , 'counts_orders' , 'date' , '2011-05-06' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (815 , 'counts_orders' , 'date' , '2011-05-07' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (816 , 'counts_orders' , 'date' , '2011-05-08' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (817 , 'counts_orders' , 'date' , '2011-05-09' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (818 , 'counts_orders' , 'date' , '2011-05-10' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (819 , 'counts_orders' , 'date' , '2011-05-11' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (820 , 'counts_orders' , 'date' , '2011-05-12' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (821 , 'counts_orders' , 'date' , '2011-05-13' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (822 , 'counts_orders' , 'date' , '2011-05-14' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (823 , 'counts_orders' , 'date' , '2011-05-15' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (824 , 'counts_orders' , 'date' , '2011-05-16' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (825 , 'counts_orders' , 'date' , '2011-05-17' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (826 , 'counts_orders' , 'date' , '2011-05-18' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (827 , 'counts_orders' , 'date' , '2011-05-19' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (828 , 'counts_sales' , 'date' , '2011-04-22' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (829 , 'counts_sales' , 'date' , '2011-04-23' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (830 , 'counts_sales' , 'date' , '2011-04-24' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (831 , 'counts_sales' , 'date' , '2011-04-25' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (832 , 'counts_sales' , 'date' , '2011-04-26' , '2011-05-20 12:36:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (833 , 'counts_sales' , 'date' , '2011-04-27' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (834 , 'counts_sales' , 'date' , '2011-04-28' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (835 , 'counts_sales' , 'date' , '2011-04-29' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (836 , 'counts_sales' , 'date' , '2011-04-30' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (837 , 'counts_sales' , 'date' , '2011-05-01' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (838 , 'counts_sales' , 'date' , '2011-05-02' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (839 , 'counts_sales' , 'date' , '2011-05-03' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (840 , 'counts_sales' , 'date' , '2011-05-04' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (841 , 'counts_sales' , 'date' , '2011-05-05' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (842 , 'counts_sales' , 'date' , '2011-05-06' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (843 , 'counts_sales' , 'date' , '2011-05-07' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (844 , 'counts_sales' , 'date' , '2011-05-08' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (845 , 'counts_sales' , 'date' , '2011-05-09' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (846 , 'counts_sales' , 'date' , '2011-05-10' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (847 , 'counts_sales' , 'date' , '2011-05-11' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (848 , 'counts_sales' , 'date' , '2011-05-12' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (849 , 'counts_sales' , 'date' , '2011-05-13' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (850 , 'counts_sales' , 'date' , '2011-05-14' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (851 , 'counts_sales' , 'date' , '2011-05-15' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (852 , 'counts_sales' , 'date' , '2011-05-16' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (853 , 'counts_sales' , 'date' , '2011-05-17' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (854 , 'counts_sales' , 'date' , '2011-05-18' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (855 , 'counts_sales' , 'date' , '2011-05-19' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (856 , 'counts_users' , 'date' , '2011-04-22' , '2011-05-20 12:36:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (857 , 'counts_users' , 'date' , '2011-04-23' , '2011-05-20 12:36:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (858 , 'counts_users' , 'date' , '2011-04-24' , '2011-05-20 12:36:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (859 , 'counts_users' , 'date' , '2011-04-25' , '2011-05-20 12:36:02' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (860 , 'counts_users' , 'date' , '2011-04-26' , '2011-05-20 12:36:02' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (861 , 'counts_users' , 'date' , '2011-04-27' , '2011-05-27 14:52:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (862 , 'counts_users' , 'date' , '2011-04-28' , '2011-05-27 14:52:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (863 , 'counts_users' , 'date' , '2011-04-29' , '2011-05-27 14:52:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (864 , 'counts_users' , 'date' , '2011-04-30' , '2011-05-27 14:52:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (865 , 'counts_users' , 'date' , '2011-05-01' , '2011-05-27 14:52:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (866 , 'counts_users' , 'date' , '2011-05-02' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (867 , 'counts_users' , 'date' , '2011-05-03' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (868 , 'counts_users' , 'date' , '2011-05-04' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (869 , 'counts_users' , 'date' , '2011-05-05' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (870 , 'counts_users' , 'date' , '2011-05-06' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (871 , 'counts_users' , 'date' , '2011-05-07' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (872 , 'counts_users' , 'date' , '2011-05-08' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (873 , 'counts_users' , 'date' , '2011-05-09' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (874 , 'counts_users' , 'date' , '2011-05-10' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (875 , 'counts_users' , 'date' , '2011-05-11' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (876 , 'counts_users' , 'date' , '2011-05-12' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (877 , 'counts_users' , 'date' , '2011-05-13' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (878 , 'counts_users' , 'date' , '2011-05-14' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (879 , 'counts_users' , 'date' , '2011-05-15' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (880 , 'counts_users' , 'date' , '2011-05-16' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (881 , 'counts_users' , 'date' , '2011-05-17' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (882 , 'counts_users' , 'date' , '2011-05-18' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (883 , 'counts_users' , 'date' , '2011-05-19' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (884 , 'counts_visits' , 'date' , '2011-04-22' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (885 , 'counts_visits' , 'date' , '2011-04-23' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (886 , 'counts_visits' , 'date' , '2011-04-24' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (887 , 'counts_visits' , 'date' , '2011-04-25' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (888 , 'counts_visits' , 'date' , '2011-04-26' , '2011-05-20 12:36:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (889 , 'counts_visits' , 'date' , '2011-04-27' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (890 , 'counts_visits' , 'date' , '2011-04-28' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (891 , 'counts_visits' , 'date' , '2011-04-29' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (892 , 'counts_visits' , 'date' , '2011-04-30' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (893 , 'counts_visits' , 'date' , '2011-05-01' , '2011-05-27 14:52:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (894 , 'counts_visits' , 'date' , '2011-05-02' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (895 , 'counts_visits' , 'date' , '2011-05-03' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (896 , 'counts_visits' , 'date' , '2011-05-04' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (897 , 'counts_visits' , 'date' , '2011-05-05' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (898 , 'counts_visits' , 'date' , '2011-05-06' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (899 , 'counts_visits' , 'date' , '2011-05-07' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (900 , 'counts_visits' , 'date' , '2011-05-08' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (901 , 'counts_visits' , 'date' , '2011-05-09' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (902 , 'counts_visits' , 'date' , '2011-05-10' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (903 , 'counts_visits' , 'date' , '2011-05-11' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (904 , 'counts_visits' , 'date' , '2011-05-12' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (905 , 'counts_visits' , 'date' , '2011-05-13' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (906 , 'counts_visits' , 'date' , '2011-05-14' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (907 , 'counts_visits' , 'date' , '2011-05-15' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (908 , 'counts_visits' , 'date' , '2011-05-16' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (909 , 'counts_visits' , 'date' , '2011-05-17' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (910 , 'counts_visits' , 'date' , '2011-05-18' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (911 , 'counts_visits' , 'date' , '2011-05-19' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (912 , 'counts_users' , 'date' , '2011-05-20' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (913 , 'counts_users' , 'date' , '2011-05-21' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (914 , 'counts_users' , 'date' , '2011-05-22' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (915 , 'counts_users' , 'date' , '2011-05-23' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (916 , 'counts_users' , 'date' , '2011-05-24' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (917 , 'counts_users' , 'date' , '2011-05-25' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (918 , 'counts_users' , 'date' , '2011-05-26' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (919 , 'counts_orders' , 'date' , '2011-05-20' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (920 , 'counts_orders' , 'date' , '2011-05-21' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (921 , 'counts_orders' , 'date' , '2011-05-22' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (922 , 'counts_orders' , 'date' , '2011-05-23' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (923 , 'counts_orders' , 'date' , '2011-05-24' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (924 , 'counts_orders' , 'date' , '2011-05-25' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (925 , 'counts_orders' , 'date' , '2011-05-26' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (926 , 'counts_sales' , 'date' , '2011-05-20' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (927 , 'counts_sales' , 'date' , '2011-05-21' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (928 , 'counts_sales' , 'date' , '2011-05-22' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (929 , 'counts_sales' , 'date' , '2011-05-23' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (930 , 'counts_sales' , 'date' , '2011-05-24' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (931 , 'counts_sales' , 'date' , '2011-05-25' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (932 , 'counts_sales' , 'date' , '2011-05-26' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (933 , 'counts_visits' , 'date' , '2011-05-20' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (934 , 'counts_visits' , 'date' , '2011-05-21' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (935 , 'counts_visits' , 'date' , '2011-05-22' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (936 , 'counts_visits' , 'date' , '2011-05-23' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (937 , 'counts_visits' , 'date' , '2011-05-24' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (938 , 'counts_visits' , 'date' , '2011-05-25' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (939 , 'counts_visits' , 'date' , '2011-05-26' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (940 , 'counts_visits' , 'date' , '2011-05-27' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (941 , 'counts_visits' , 'date' , '2011-05-28' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (942 , 'counts_visits' , 'date' , '2011-05-29' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (943 , 'counts_visits' , 'date' , '2011-05-30' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (944 , 'counts_visits' , 'date' , '2011-05-31' , '2011-06-01 17:54:28' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (945 , 'counts_sales' , 'date' , '2011-05-27' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (946 , 'counts_sales' , 'date' , '2011-05-28' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (947 , 'counts_sales' , 'date' , '2011-05-29' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (948 , 'counts_sales' , 'date' , '2011-05-30' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (949 , 'counts_sales' , 'date' , '2011-05-31' , '2011-06-01 17:54:29' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (950 , 'counts_users' , 'date' , '2011-05-27' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (951 , 'counts_users' , 'date' , '2011-05-28' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (952 , 'counts_users' , 'date' , '2011-05-29' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (953 , 'counts_users' , 'date' , '2011-05-30' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (954 , 'counts_users' , 'date' , '2011-05-31' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (955 , 'counts_orders' , 'date' , '2011-05-27' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (956 , 'counts_orders' , 'date' , '2011-05-28' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (957 , 'counts_orders' , 'date' , '2011-05-29' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (958 , 'counts_orders' , 'date' , '2011-05-30' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (959 , 'counts_orders' , 'date' , '2011-05-31' , '2011-06-01 17:54:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (960 , 'counts_users' , 'date' , '2011-06-01' , '2011-06-02 00:14:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (961 , 'counts_visits' , 'date' , '2011-06-01' , '2011-06-02 00:14:58' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (962 , 'counts_orders' , 'date' , '2011-06-01' , '2011-06-02 00:14:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (963 , 'counts_sales' , 'date' , '2011-06-01' , '2011-06-02 00:14:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (964 , 'counts_sales' , 'date' , '2011-07-20' , '2011-08-19 00:28:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (965 , 'counts_sales' , 'date' , '2011-07-21' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (966 , 'counts_sales' , 'date' , '2011-07-22' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (967 , 'counts_sales' , 'date' , '2011-07-23' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (968 , 'counts_sales' , 'date' , '2011-07-24' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (969 , 'counts_sales' , 'date' , '2011-07-25' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (970 , 'counts_sales' , 'date' , '2011-07-26' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (971 , 'counts_sales' , 'date' , '2011-07-27' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (972 , 'counts_sales' , 'date' , '2011-07-28' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (973 , 'counts_sales' , 'date' , '2011-07-29' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (974 , 'counts_sales' , 'date' , '2011-07-30' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (975 , 'counts_sales' , 'date' , '2011-07-31' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (976 , 'counts_sales' , 'date' , '2011-08-01' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (977 , 'counts_sales' , 'date' , '2011-08-02' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (978 , 'counts_sales' , 'date' , '2011-08-03' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (979 , 'counts_sales' , 'date' , '2011-08-04' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (980 , 'counts_sales' , 'date' , '2011-08-05' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (981 , 'counts_sales' , 'date' , '2011-08-06' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (982 , 'counts_sales' , 'date' , '2011-08-07' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (983 , 'counts_sales' , 'date' , '2011-08-08' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (984 , 'counts_sales' , 'date' , '2011-08-09' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (985 , 'counts_sales' , 'date' , '2011-08-10' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (986 , 'counts_sales' , 'date' , '2011-08-11' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (987 , 'counts_sales' , 'date' , '2011-08-12' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (988 , 'counts_sales' , 'date' , '2011-08-13' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (989 , 'counts_sales' , 'date' , '2011-08-14' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (990 , 'counts_sales' , 'date' , '2011-08-15' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (991 , 'counts_sales' , 'date' , '2011-08-16' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (992 , 'counts_sales' , 'date' , '2011-08-17' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (993 , 'counts_sales' , 'date' , '2011-08-18' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (994 , 'counts_users' , 'date' , '2011-07-20' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (995 , 'counts_users' , 'date' , '2011-07-21' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (996 , 'counts_users' , 'date' , '2011-07-22' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (997 , 'counts_users' , 'date' , '2011-07-23' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (998 , 'counts_users' , 'date' , '2011-07-24' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (999 , 'counts_users' , 'date' , '2011-07-25' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1000 , 'counts_users' , 'date' , '2011-07-26' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1001 , 'counts_users' , 'date' , '2011-07-27' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1002 , 'counts_users' , 'date' , '2011-07-28' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1003 , 'counts_users' , 'date' , '2011-07-29' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1004 , 'counts_users' , 'date' , '2011-07-30' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1005 , 'counts_users' , 'date' , '2011-07-31' , '2011-08-19 00:28:34' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1006 , 'counts_users' , 'date' , '2011-08-01' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1007 , 'counts_users' , 'date' , '2011-08-02' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1008 , 'counts_users' , 'date' , '2011-08-03' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1009 , 'counts_users' , 'date' , '2011-08-04' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1010 , 'counts_users' , 'date' , '2011-08-05' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1011 , 'counts_users' , 'date' , '2011-08-06' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1012 , 'counts_users' , 'date' , '2011-08-07' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1013 , 'counts_users' , 'date' , '2011-08-08' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1014 , 'counts_users' , 'date' , '2011-08-09' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1015 , 'counts_users' , 'date' , '2011-08-10' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1016 , 'counts_users' , 'date' , '2011-08-11' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1017 , 'counts_users' , 'date' , '2011-08-12' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1018 , 'counts_users' , 'date' , '2011-08-13' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1019 , 'counts_users' , 'date' , '2011-08-14' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1020 , 'counts_users' , 'date' , '2011-08-15' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1021 , 'counts_users' , 'date' , '2011-08-16' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1022 , 'counts_users' , 'date' , '2011-08-17' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1023 , 'counts_users' , 'date' , '2011-08-18' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1024 , 'counts_visits' , 'date' , '2011-07-20' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1025 , 'counts_visits' , 'date' , '2011-07-21' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1026 , 'counts_visits' , 'date' , '2011-07-22' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1027 , 'counts_visits' , 'date' , '2011-07-23' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1028 , 'counts_visits' , 'date' , '2011-07-24' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1029 , 'counts_visits' , 'date' , '2011-07-25' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1030 , 'counts_visits' , 'date' , '2011-07-26' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1031 , 'counts_visits' , 'date' , '2011-07-27' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1032 , 'counts_visits' , 'date' , '2011-07-28' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1033 , 'counts_visits' , 'date' , '2011-07-29' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1034 , 'counts_visits' , 'date' , '2011-07-30' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1035 , 'counts_visits' , 'date' , '2011-07-31' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1036 , 'counts_visits' , 'date' , '2011-08-01' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1037 , 'counts_visits' , 'date' , '2011-08-02' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1038 , 'counts_visits' , 'date' , '2011-08-03' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1039 , 'counts_visits' , 'date' , '2011-08-04' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1040 , 'counts_visits' , 'date' , '2011-08-05' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1041 , 'counts_visits' , 'date' , '2011-08-06' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1042 , 'counts_visits' , 'date' , '2011-08-07' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1043 , 'counts_visits' , 'date' , '2011-08-08' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1044 , 'counts_visits' , 'date' , '2011-08-09' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1045 , 'counts_visits' , 'date' , '2011-08-10' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1046 , 'counts_visits' , 'date' , '2011-08-11' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1047 , 'counts_visits' , 'date' , '2011-08-12' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1048 , 'counts_visits' , 'date' , '2011-08-13' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1049 , 'counts_visits' , 'date' , '2011-08-14' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1050 , 'counts_visits' , 'date' , '2011-08-15' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1051 , 'counts_visits' , 'date' , '2011-08-16' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1052 , 'counts_visits' , 'date' , '2011-08-17' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1053 , 'counts_visits' , 'date' , '2011-08-18' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1054 , 'counts_orders' , 'date' , '2011-07-20' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1055 , 'counts_orders' , 'date' , '2011-07-21' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1056 , 'counts_orders' , 'date' , '2011-07-22' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1057 , 'counts_orders' , 'date' , '2011-07-23' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1058 , 'counts_orders' , 'date' , '2011-07-24' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1059 , 'counts_orders' , 'date' , '2011-07-25' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1060 , 'counts_orders' , 'date' , '2011-07-26' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1061 , 'counts_orders' , 'date' , '2011-07-27' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1062 , 'counts_orders' , 'date' , '2011-07-28' , '2011-08-19 00:28:35' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1063 , 'counts_orders' , 'date' , '2011-07-29' , '2011-08-19 00:28:36' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1064 , 'counts_orders' , 'date' , '2011-07-30' , '2011-08-19 00:28:36' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1065 , 'counts_orders' , 'date' , '2011-07-31' , '2011-08-19 00:28:36' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1066 , 'counts_orders' , 'date' , '2011-08-01' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1067 , 'counts_orders' , 'date' , '2011-08-02' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1068 , 'counts_orders' , 'date' , '2011-08-03' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1069 , 'counts_orders' , 'date' , '2011-08-04' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1070 , 'counts_orders' , 'date' , '2011-08-05' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1071 , 'counts_orders' , 'date' , '2011-08-06' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1072 , 'counts_orders' , 'date' , '2011-08-07' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1073 , 'counts_orders' , 'date' , '2011-08-08' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1074 , 'counts_orders' , 'date' , '2011-08-09' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1075 , 'counts_orders' , 'date' , '2011-08-10' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1076 , 'counts_orders' , 'date' , '2011-08-11' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1077 , 'counts_orders' , 'date' , '2011-08-12' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1078 , 'counts_orders' , 'date' , '2011-08-13' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1079 , 'counts_orders' , 'date' , '2011-08-14' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1080 , 'counts_orders' , 'date' , '2011-08-15' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1081 , 'counts_orders' , 'date' , '2011-08-16' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1082 , 'counts_orders' , 'date' , '2011-08-17' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1083 , 'counts_orders' , 'date' , '2011-08-18' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1084 , 'counts_users' , 'date' , '2011-08-19' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1085 , 'counts_users' , 'date' , '2011-08-20' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1086 , 'counts_users' , 'date' , '2011-08-21' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1087 , 'counts_users' , 'date' , '2011-08-22' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1088 , 'counts_users' , 'date' , '2011-08-23' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1089 , 'counts_users' , 'date' , '2011-08-24' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1090 , 'counts_users' , 'date' , '2011-08-25' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1091 , 'counts_users' , 'date' , '2011-08-26' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1092 , 'counts_users' , 'date' , '2011-08-27' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1093 , 'counts_users' , 'date' , '2011-08-28' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1094 , 'counts_users' , 'date' , '2011-08-29' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1095 , 'counts_users' , 'date' , '2011-08-30' , '2011-08-31 13:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1096 , 'counts_orders' , 'date' , '2011-08-19' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1097 , 'counts_orders' , 'date' , '2011-08-20' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1098 , 'counts_orders' , 'date' , '2011-08-21' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1099 , 'counts_orders' , 'date' , '2011-08-22' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1100 , 'counts_orders' , 'date' , '2011-08-23' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1101 , 'counts_orders' , 'date' , '2011-08-24' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1102 , 'counts_orders' , 'date' , '2011-08-25' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1103 , 'counts_orders' , 'date' , '2011-08-26' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1104 , 'counts_orders' , 'date' , '2011-08-27' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1105 , 'counts_orders' , 'date' , '2011-08-28' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1106 , 'counts_orders' , 'date' , '2011-08-29' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1107 , 'counts_orders' , 'date' , '2011-08-30' , '2011-08-31 13:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1108 , 'counts_visits' , 'date' , '2011-08-19' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1109 , 'counts_visits' , 'date' , '2011-08-20' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1110 , 'counts_visits' , 'date' , '2011-08-21' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1111 , 'counts_visits' , 'date' , '2011-08-22' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1112 , 'counts_visits' , 'date' , '2011-08-23' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1113 , 'counts_visits' , 'date' , '2011-08-24' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1114 , 'counts_visits' , 'date' , '2011-08-25' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1115 , 'counts_visits' , 'date' , '2011-08-26' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1116 , 'counts_visits' , 'date' , '2011-08-27' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1117 , 'counts_visits' , 'date' , '2011-08-28' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1118 , 'counts_visits' , 'date' , '2011-08-29' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1119 , 'counts_visits' , 'date' , '2011-08-30' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1120 , 'counts_sales' , 'date' , '2011-08-19' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1121 , 'counts_sales' , 'date' , '2011-08-20' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1122 , 'counts_sales' , 'date' , '2011-08-21' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1123 , 'counts_sales' , 'date' , '2011-08-22' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1124 , 'counts_sales' , 'date' , '2011-08-23' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1125 , 'counts_sales' , 'date' , '2011-08-24' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1126 , 'counts_sales' , 'date' , '2011-08-25' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1127 , 'counts_sales' , 'date' , '2011-08-26' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1128 , 'counts_sales' , 'date' , '2011-08-27' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1129 , 'counts_sales' , 'date' , '2011-08-28' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1130 , 'counts_sales' , 'date' , '2011-08-29' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1131 , 'counts_sales' , 'date' , '2011-08-30' , '2011-08-31 13:26:55' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1132 , 'counts_users' , 'date' , '2012-04-15' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1133 , 'counts_users' , 'date' , '2012-04-16' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1134 , 'counts_users' , 'date' , '2012-04-17' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1135 , 'counts_users' , 'date' , '2012-04-18' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1136 , 'counts_users' , 'date' , '2012-04-19' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1137 , 'counts_users' , 'date' , '2012-04-20' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1138 , 'counts_users' , 'date' , '2012-04-21' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1139 , 'counts_users' , 'date' , '2012-04-22' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1140 , 'counts_users' , 'date' , '2012-04-23' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1141 , 'counts_users' , 'date' , '2012-04-24' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1142 , 'counts_users' , 'date' , '2012-04-25' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1143 , 'counts_users' , 'date' , '2012-04-26' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1144 , 'counts_users' , 'date' , '2012-04-27' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1145 , 'counts_users' , 'date' , '2012-04-28' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1146 , 'counts_users' , 'date' , '2012-04-29' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1147 , 'counts_users' , 'date' , '2012-04-30' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1148 , 'counts_users' , 'date' , '2012-05-01' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1149 , 'counts_users' , 'date' , '2012-05-02' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1150 , 'counts_users' , 'date' , '2012-05-03' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1151 , 'counts_users' , 'date' , '2012-05-04' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1152 , 'counts_users' , 'date' , '2012-05-05' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1153 , 'counts_users' , 'date' , '2012-05-06' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1154 , 'counts_users' , 'date' , '2012-05-07' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1155 , 'counts_users' , 'date' , '2012-05-08' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1156 , 'counts_users' , 'date' , '2012-05-09' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1157 , 'counts_users' , 'date' , '2012-05-10' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1158 , 'counts_users' , 'date' , '2012-05-11' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1159 , 'counts_users' , 'date' , '2012-05-12' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1160 , 'counts_users' , 'date' , '2012-05-13' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1161 , 'counts_users' , 'date' , '2012-05-14' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1162 , 'counts_orders' , 'date' , '2012-04-15' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1163 , 'counts_orders' , 'date' , '2012-04-16' , '2012-05-15 16:00:37' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1164 , 'counts_orders' , 'date' , '2012-04-17' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1165 , 'counts_orders' , 'date' , '2012-04-18' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1166 , 'counts_orders' , 'date' , '2012-04-19' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1167 , 'counts_orders' , 'date' , '2012-04-20' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1168 , 'counts_orders' , 'date' , '2012-04-21' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1169 , 'counts_orders' , 'date' , '2012-04-22' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1170 , 'counts_orders' , 'date' , '2012-04-23' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1171 , 'counts_orders' , 'date' , '2012-04-24' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1172 , 'counts_orders' , 'date' , '2012-04-25' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1173 , 'counts_orders' , 'date' , '2012-04-26' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1174 , 'counts_orders' , 'date' , '2012-04-27' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1175 , 'counts_orders' , 'date' , '2012-04-28' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1176 , 'counts_orders' , 'date' , '2012-04-29' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1177 , 'counts_orders' , 'date' , '2012-04-30' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1178 , 'counts_orders' , 'date' , '2012-05-01' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1179 , 'counts_orders' , 'date' , '2012-05-02' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1180 , 'counts_orders' , 'date' , '2012-05-03' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1181 , 'counts_orders' , 'date' , '2012-05-04' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1182 , 'counts_orders' , 'date' , '2012-05-05' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1183 , 'counts_orders' , 'date' , '2012-05-06' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1184 , 'counts_orders' , 'date' , '2012-05-07' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1185 , 'counts_orders' , 'date' , '2012-05-08' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1186 , 'counts_orders' , 'date' , '2012-05-09' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1187 , 'counts_orders' , 'date' , '2012-05-10' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1188 , 'counts_orders' , 'date' , '2012-05-11' , '2012-06-10 22:57:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1189 , 'counts_orders' , 'date' , '2012-05-12' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1190 , 'counts_orders' , 'date' , '2012-05-13' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1191 , 'counts_orders' , 'date' , '2012-05-14' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1192 , 'counts_sales' , 'date' , '2012-04-15' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1193 , 'counts_sales' , 'date' , '2012-04-16' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1194 , 'counts_sales' , 'date' , '2012-04-17' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1195 , 'counts_sales' , 'date' , '2012-04-18' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1196 , 'counts_sales' , 'date' , '2012-04-19' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1197 , 'counts_sales' , 'date' , '2012-04-20' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1198 , 'counts_sales' , 'date' , '2012-04-21' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1199 , 'counts_sales' , 'date' , '2012-04-22' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1200 , 'counts_sales' , 'date' , '2012-04-23' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1201 , 'counts_sales' , 'date' , '2012-04-24' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1202 , 'counts_sales' , 'date' , '2012-04-25' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1203 , 'counts_sales' , 'date' , '2012-04-26' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1204 , 'counts_sales' , 'date' , '2012-04-27' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1205 , 'counts_sales' , 'date' , '2012-04-28' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1206 , 'counts_sales' , 'date' , '2012-04-29' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1207 , 'counts_sales' , 'date' , '2012-04-30' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1208 , 'counts_sales' , 'date' , '2012-05-01' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1209 , 'counts_sales' , 'date' , '2012-05-02' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1210 , 'counts_sales' , 'date' , '2012-05-03' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1211 , 'counts_sales' , 'date' , '2012-05-04' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1212 , 'counts_sales' , 'date' , '2012-05-05' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1213 , 'counts_sales' , 'date' , '2012-05-06' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1214 , 'counts_sales' , 'date' , '2012-05-07' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1215 , 'counts_sales' , 'date' , '2012-05-08' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1216 , 'counts_sales' , 'date' , '2012-05-09' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1217 , 'counts_sales' , 'date' , '2012-05-10' , '2012-05-15 16:00:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1218 , 'counts_sales' , 'date' , '2012-05-11' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1219 , 'counts_sales' , 'date' , '2012-05-12' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1220 , 'counts_sales' , 'date' , '2012-05-13' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1221 , 'counts_sales' , 'date' , '2012-05-14' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1222 , 'counts_visits' , 'date' , '2012-04-15' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1223 , 'counts_visits' , 'date' , '2012-04-16' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1224 , 'counts_visits' , 'date' , '2012-04-17' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1225 , 'counts_visits' , 'date' , '2012-04-18' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1226 , 'counts_visits' , 'date' , '2012-04-19' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1227 , 'counts_visits' , 'date' , '2012-04-20' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1228 , 'counts_visits' , 'date' , '2012-04-21' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1229 , 'counts_visits' , 'date' , '2012-04-22' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1230 , 'counts_visits' , 'date' , '2012-04-23' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1231 , 'counts_visits' , 'date' , '2012-04-24' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1232 , 'counts_visits' , 'date' , '2012-04-25' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1233 , 'counts_visits' , 'date' , '2012-04-26' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1234 , 'counts_visits' , 'date' , '2012-04-27' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1235 , 'counts_visits' , 'date' , '2012-04-28' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1236 , 'counts_visits' , 'date' , '2012-04-29' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1237 , 'counts_visits' , 'date' , '2012-04-30' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1238 , 'counts_visits' , 'date' , '2012-05-01' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1239 , 'counts_visits' , 'date' , '2012-05-02' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1240 , 'counts_visits' , 'date' , '2012-05-03' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1241 , 'counts_visits' , 'date' , '2012-05-04' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1242 , 'counts_visits' , 'date' , '2012-05-05' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1243 , 'counts_visits' , 'date' , '2012-05-06' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1244 , 'counts_visits' , 'date' , '2012-05-07' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1245 , 'counts_visits' , 'date' , '2012-05-08' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1246 , 'counts_visits' , 'date' , '2012-05-09' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1247 , 'counts_visits' , 'date' , '2012-05-10' , '2012-05-15 16:00:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1248 , 'counts_visits' , 'date' , '2012-05-11' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1249 , 'counts_visits' , 'date' , '2012-05-12' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1250 , 'counts_visits' , 'date' , '2012-05-13' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1251 , 'counts_visits' , 'date' , '2012-05-14' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1252 , 'counts_orders' , 'date' , '2012-05-15' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1253 , 'counts_orders' , 'date' , '2012-05-16' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1254 , 'counts_orders' , 'date' , '2012-05-17' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1255 , 'counts_orders' , 'date' , '2012-05-18' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1256 , 'counts_orders' , 'date' , '2012-05-19' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1257 , 'counts_orders' , 'date' , '2012-05-20' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1258 , 'counts_orders' , 'date' , '2012-05-21' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1259 , 'counts_orders' , 'date' , '2012-05-22' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1260 , 'counts_orders' , 'date' , '2012-05-23' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1261 , 'counts_orders' , 'date' , '2012-05-24' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1262 , 'counts_orders' , 'date' , '2012-05-25' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1263 , 'counts_orders' , 'date' , '2012-05-26' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1264 , 'counts_orders' , 'date' , '2012-05-27' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1265 , 'counts_orders' , 'date' , '2012-05-28' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1266 , 'counts_orders' , 'date' , '2012-05-29' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1267 , 'counts_orders' , 'date' , '2012-05-30' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1268 , 'counts_orders' , 'date' , '2012-05-31' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1269 , 'counts_orders' , 'date' , '2012-06-01' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1270 , 'counts_orders' , 'date' , '2012-06-02' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1271 , 'counts_orders' , 'date' , '2012-06-03' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1272 , 'counts_orders' , 'date' , '2012-06-04' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1273 , 'counts_orders' , 'date' , '2012-06-05' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1274 , 'counts_orders' , 'date' , '2012-06-06' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1275 , 'counts_orders' , 'date' , '2012-06-07' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1276 , 'counts_orders' , 'date' , '2012-06-08' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1277 , 'counts_orders' , 'date' , '2012-06-09' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1278 , 'counts_users' , 'date' , '2012-05-15' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1279 , 'counts_users' , 'date' , '2012-05-16' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1280 , 'counts_users' , 'date' , '2012-05-17' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1281 , 'counts_users' , 'date' , '2012-05-18' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1282 , 'counts_users' , 'date' , '2012-05-19' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1283 , 'counts_users' , 'date' , '2012-05-20' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1284 , 'counts_users' , 'date' , '2012-05-21' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1285 , 'counts_users' , 'date' , '2012-05-22' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1286 , 'counts_users' , 'date' , '2012-05-23' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1287 , 'counts_users' , 'date' , '2012-05-24' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1288 , 'counts_users' , 'date' , '2012-05-25' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1289 , 'counts_users' , 'date' , '2012-05-26' , '2012-06-10 22:57:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1290 , 'counts_users' , 'date' , '2012-05-27' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1291 , 'counts_users' , 'date' , '2012-05-28' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1292 , 'counts_users' , 'date' , '2012-05-29' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1293 , 'counts_users' , 'date' , '2012-05-30' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1294 , 'counts_users' , 'date' , '2012-05-31' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1295 , 'counts_users' , 'date' , '2012-06-01' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1296 , 'counts_users' , 'date' , '2012-06-02' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1297 , 'counts_users' , 'date' , '2012-06-03' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1298 , 'counts_users' , 'date' , '2012-06-04' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1299 , 'counts_users' , 'date' , '2012-06-05' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1300 , 'counts_users' , 'date' , '2012-06-06' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1301 , 'counts_users' , 'date' , '2012-06-07' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1302 , 'counts_users' , 'date' , '2012-06-08' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1303 , 'counts_users' , 'date' , '2012-06-09' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1304 , 'counts_visits' , 'date' , '2012-05-15' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1305 , 'counts_visits' , 'date' , '2012-05-16' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1306 , 'counts_visits' , 'date' , '2012-05-17' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1307 , 'counts_visits' , 'date' , '2012-05-18' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1308 , 'counts_visits' , 'date' , '2012-05-19' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1309 , 'counts_visits' , 'date' , '2012-05-20' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1310 , 'counts_visits' , 'date' , '2012-05-21' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1311 , 'counts_visits' , 'date' , '2012-05-22' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1312 , 'counts_visits' , 'date' , '2012-05-23' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1313 , 'counts_visits' , 'date' , '2012-05-24' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1314 , 'counts_visits' , 'date' , '2012-05-25' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1315 , 'counts_visits' , 'date' , '2012-05-26' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1316 , 'counts_visits' , 'date' , '2012-05-27' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1317 , 'counts_visits' , 'date' , '2012-05-28' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1318 , 'counts_visits' , 'date' , '2012-05-29' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1319 , 'counts_visits' , 'date' , '2012-05-30' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1320 , 'counts_visits' , 'date' , '2012-05-31' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1321 , 'counts_visits' , 'date' , '2012-06-01' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1322 , 'counts_visits' , 'date' , '2012-06-02' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1323 , 'counts_visits' , 'date' , '2012-06-03' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1324 , 'counts_visits' , 'date' , '2012-06-04' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1325 , 'counts_visits' , 'date' , '2012-06-05' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1326 , 'counts_visits' , 'date' , '2012-06-06' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1327 , 'counts_visits' , 'date' , '2012-06-07' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1328 , 'counts_visits' , 'date' , '2012-06-08' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1329 , 'counts_visits' , 'date' , '2012-06-09' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1330 , 'counts_sales' , 'date' , '2012-05-15' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1331 , 'counts_sales' , 'date' , '2012-05-16' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1332 , 'counts_sales' , 'date' , '2012-05-17' , '2012-06-10 22:57:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1333 , 'counts_sales' , 'date' , '2012-05-18' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1334 , 'counts_sales' , 'date' , '2012-05-19' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1335 , 'counts_sales' , 'date' , '2012-05-20' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1336 , 'counts_sales' , 'date' , '2012-05-21' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1337 , 'counts_sales' , 'date' , '2012-05-22' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1338 , 'counts_sales' , 'date' , '2012-05-23' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1339 , 'counts_sales' , 'date' , '2012-05-24' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1340 , 'counts_sales' , 'date' , '2012-05-25' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1341 , 'counts_sales' , 'date' , '2012-05-26' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1342 , 'counts_sales' , 'date' , '2012-05-27' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1343 , 'counts_sales' , 'date' , '2012-05-28' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1344 , 'counts_sales' , 'date' , '2012-05-29' , '2012-06-10 22:57:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1345 , 'counts_sales' , 'date' , '2012-05-30' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1346 , 'counts_sales' , 'date' , '2012-05-31' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1347 , 'counts_sales' , 'date' , '2012-06-01' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1348 , 'counts_sales' , 'date' , '2012-06-02' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1349 , 'counts_sales' , 'date' , '2012-06-03' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1350 , 'counts_sales' , 'date' , '2012-06-04' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1351 , 'counts_sales' , 'date' , '2012-06-05' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1352 , 'counts_sales' , 'date' , '2012-06-06' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1353 , 'counts_sales' , 'date' , '2012-06-07' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1354 , 'counts_sales' , 'date' , '2012-06-08' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1355 , 'counts_sales' , 'date' , '2012-06-09' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1356 , 'counts_visits' , 'date' , '2012-06-10' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1357 , 'counts_visits' , 'date' , '2012-06-11' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1358 , 'counts_visits' , 'date' , '2012-06-12' , '2012-06-29 14:11:18' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1359 , 'counts_visits' , 'date' , '2012-06-13' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1360 , 'counts_visits' , 'date' , '2012-06-14' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1361 , 'counts_visits' , 'date' , '2012-06-15' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1362 , 'counts_visits' , 'date' , '2012-06-16' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1363 , 'counts_visits' , 'date' , '2012-06-17' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1364 , 'counts_visits' , 'date' , '2012-06-18' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1365 , 'counts_visits' , 'date' , '2012-06-19' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1366 , 'counts_visits' , 'date' , '2012-06-20' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1367 , 'counts_visits' , 'date' , '2012-06-21' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1368 , 'counts_visits' , 'date' , '2012-06-22' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1369 , 'counts_visits' , 'date' , '2012-06-23' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1370 , 'counts_visits' , 'date' , '2012-06-24' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1371 , 'counts_visits' , 'date' , '2012-06-25' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1372 , 'counts_visits' , 'date' , '2012-06-26' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1373 , 'counts_visits' , 'date' , '2012-06-27' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1374 , 'counts_visits' , 'date' , '2012-06-28' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1375 , 'counts_orders' , 'date' , '2012-06-10' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1376 , 'counts_orders' , 'date' , '2012-06-11' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1377 , 'counts_orders' , 'date' , '2012-06-12' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1378 , 'counts_orders' , 'date' , '2012-06-13' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1379 , 'counts_orders' , 'date' , '2012-06-14' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1380 , 'counts_orders' , 'date' , '2012-06-15' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1381 , 'counts_orders' , 'date' , '2012-06-16' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1382 , 'counts_orders' , 'date' , '2012-06-17' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1383 , 'counts_orders' , 'date' , '2012-06-18' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1384 , 'counts_orders' , 'date' , '2012-06-19' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1385 , 'counts_orders' , 'date' , '2012-06-20' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1386 , 'counts_orders' , 'date' , '2012-06-21' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1387 , 'counts_orders' , 'date' , '2012-06-22' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1388 , 'counts_orders' , 'date' , '2012-06-23' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1389 , 'counts_orders' , 'date' , '2012-06-24' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1390 , 'counts_orders' , 'date' , '2012-06-25' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1391 , 'counts_orders' , 'date' , '2012-06-26' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1392 , 'counts_orders' , 'date' , '2012-06-27' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1393 , 'counts_orders' , 'date' , '2012-06-28' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1394 , 'counts_users' , 'date' , '2012-06-10' , '2012-06-29 14:11:19' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1395 , 'counts_users' , 'date' , '2012-06-11' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1396 , 'counts_users' , 'date' , '2012-06-12' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1397 , 'counts_users' , 'date' , '2012-06-13' , '2012-07-13 16:44:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1398 , 'counts_users' , 'date' , '2012-06-14' , '2012-07-13 16:44:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1399 , 'counts_users' , 'date' , '2012-06-15' , '2012-07-13 16:44:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1400 , 'counts_users' , 'date' , '2012-06-16' , '2012-07-13 16:44:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1401 , 'counts_users' , 'date' , '2012-06-17' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1402 , 'counts_users' , 'date' , '2012-06-18' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1403 , 'counts_users' , 'date' , '2012-06-19' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1404 , 'counts_users' , 'date' , '2012-06-20' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1405 , 'counts_users' , 'date' , '2012-06-21' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1406 , 'counts_users' , 'date' , '2012-06-22' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1407 , 'counts_users' , 'date' , '2012-06-23' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1408 , 'counts_users' , 'date' , '2012-06-24' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1409 , 'counts_users' , 'date' , '2012-06-25' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1410 , 'counts_users' , 'date' , '2012-06-26' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1411 , 'counts_users' , 'date' , '2012-06-27' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1412 , 'counts_users' , 'date' , '2012-06-28' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1413 , 'counts_sales' , 'date' , '2012-06-10' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1414 , 'counts_sales' , 'date' , '2012-06-11' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1415 , 'counts_sales' , 'date' , '2012-06-12' , '2012-06-29 14:11:20' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1416 , 'counts_sales' , 'date' , '2012-06-13' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1417 , 'counts_sales' , 'date' , '2012-06-14' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1418 , 'counts_sales' , 'date' , '2012-06-15' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1419 , 'counts_sales' , 'date' , '2012-06-16' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1420 , 'counts_sales' , 'date' , '2012-06-17' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1421 , 'counts_sales' , 'date' , '2012-06-18' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1422 , 'counts_sales' , 'date' , '2012-06-19' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1423 , 'counts_sales' , 'date' , '2012-06-20' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1424 , 'counts_sales' , 'date' , '2012-06-21' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1425 , 'counts_sales' , 'date' , '2012-06-22' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1426 , 'counts_sales' , 'date' , '2012-06-23' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1427 , 'counts_sales' , 'date' , '2012-06-24' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1428 , 'counts_sales' , 'date' , '2012-06-25' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1429 , 'counts_sales' , 'date' , '2012-06-26' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1430 , 'counts_sales' , 'date' , '2012-06-27' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1431 , 'counts_sales' , 'date' , '2012-06-28' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1432 , 'counts_users' , 'date' , '2012-06-29' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1433 , 'counts_users' , 'date' , '2012-06-30' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1434 , 'counts_users' , 'date' , '2012-07-01' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1435 , 'counts_users' , 'date' , '2012-07-02' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1436 , 'counts_users' , 'date' , '2012-07-03' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1437 , 'counts_users' , 'date' , '2012-07-04' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1438 , 'counts_users' , 'date' , '2012-07-05' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1439 , 'counts_users' , 'date' , '2012-07-06' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1440 , 'counts_users' , 'date' , '2012-07-07' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1441 , 'counts_users' , 'date' , '2012-07-08' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1442 , 'counts_users' , 'date' , '2012-07-09' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1443 , 'counts_users' , 'date' , '2012-07-10' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1444 , 'counts_users' , 'date' , '2012-07-11' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1445 , 'counts_users' , 'date' , '2012-07-12' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1446 , 'counts_visits' , 'date' , '2012-06-29' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1447 , 'counts_visits' , 'date' , '2012-06-30' , '2012-07-13 16:44:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1448 , 'counts_visits' , 'date' , '2012-07-01' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1449 , 'counts_visits' , 'date' , '2012-07-02' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1450 , 'counts_visits' , 'date' , '2012-07-03' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1451 , 'counts_visits' , 'date' , '2012-07-04' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1452 , 'counts_visits' , 'date' , '2012-07-05' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1453 , 'counts_visits' , 'date' , '2012-07-06' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1454 , 'counts_visits' , 'date' , '2012-07-07' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1455 , 'counts_visits' , 'date' , '2012-07-08' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1456 , 'counts_visits' , 'date' , '2012-07-09' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1457 , 'counts_visits' , 'date' , '2012-07-10' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1458 , 'counts_visits' , 'date' , '2012-07-11' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1459 , 'counts_visits' , 'date' , '2012-07-12' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1460 , 'counts_sales' , 'date' , '2012-06-29' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1461 , 'counts_sales' , 'date' , '2012-06-30' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1462 , 'counts_sales' , 'date' , '2012-07-01' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1463 , 'counts_sales' , 'date' , '2012-07-02' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1464 , 'counts_sales' , 'date' , '2012-07-03' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1465 , 'counts_sales' , 'date' , '2012-07-04' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1466 , 'counts_sales' , 'date' , '2012-07-05' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1467 , 'counts_sales' , 'date' , '2012-07-06' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1468 , 'counts_sales' , 'date' , '2012-07-07' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1469 , 'counts_sales' , 'date' , '2012-07-08' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1470 , 'counts_sales' , 'date' , '2012-07-09' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1471 , 'counts_sales' , 'date' , '2012-07-10' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1472 , 'counts_sales' , 'date' , '2012-07-11' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1473 , 'counts_sales' , 'date' , '2012-07-12' , '2012-07-13 16:44:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1474 , 'counts_orders' , 'date' , '2012-06-29' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1475 , 'counts_orders' , 'date' , '2012-06-30' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1476 , 'counts_orders' , 'date' , '2012-07-01' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1477 , 'counts_orders' , 'date' , '2012-07-02' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1478 , 'counts_orders' , 'date' , '2012-07-03' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1479 , 'counts_orders' , 'date' , '2012-07-04' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1480 , 'counts_orders' , 'date' , '2012-07-05' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1481 , 'counts_orders' , 'date' , '2012-07-06' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1482 , 'counts_orders' , 'date' , '2012-07-07' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1483 , 'counts_orders' , 'date' , '2012-07-08' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1484 , 'counts_orders' , 'date' , '2012-07-09' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1485 , 'counts_orders' , 'date' , '2012-07-10' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1486 , 'counts_orders' , 'date' , '2012-07-11' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1487 , 'counts_orders' , 'date' , '2012-07-12' , '2012-07-13 16:44:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1488 , 'counts_users' , 'date' , '2012-08-02' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1489 , 'counts_users' , 'date' , '2012-08-03' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1490 , 'counts_users' , 'date' , '2012-08-04' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1491 , 'counts_users' , 'date' , '2012-08-05' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1492 , 'counts_users' , 'date' , '2012-08-06' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1493 , 'counts_users' , 'date' , '2012-08-07' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1494 , 'counts_users' , 'date' , '2012-08-08' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1495 , 'counts_users' , 'date' , '2012-08-09' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1496 , 'counts_users' , 'date' , '2012-08-10' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1497 , 'counts_users' , 'date' , '2012-08-11' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1498 , 'counts_users' , 'date' , '2012-08-12' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1499 , 'counts_users' , 'date' , '2012-08-13' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1500 , 'counts_users' , 'date' , '2012-08-14' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1501 , 'counts_users' , 'date' , '2012-08-15' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1502 , 'counts_users' , 'date' , '2012-08-16' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1503 , 'counts_users' , 'date' , '2012-08-17' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1504 , 'counts_users' , 'date' , '2012-08-18' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1505 , 'counts_users' , 'date' , '2012-08-19' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1506 , 'counts_users' , 'date' , '2012-08-20' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1507 , 'counts_users' , 'date' , '2012-08-21' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1508 , 'counts_users' , 'date' , '2012-08-22' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1509 , 'counts_users' , 'date' , '2012-08-23' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1510 , 'counts_users' , 'date' , '2012-08-24' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1511 , 'counts_users' , 'date' , '2012-08-25' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1512 , 'counts_users' , 'date' , '2012-08-26' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1513 , 'counts_users' , 'date' , '2012-08-27' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1514 , 'counts_users' , 'date' , '2012-08-28' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1515 , 'counts_users' , 'date' , '2012-08-29' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1516 , 'counts_users' , 'date' , '2012-08-30' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1517 , 'counts_users' , 'date' , '2012-08-31' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1518 , 'counts_orders' , 'date' , '2012-08-02' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1519 , 'counts_orders' , 'date' , '2012-08-03' , '2012-09-01 02:17:12' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1520 , 'counts_orders' , 'date' , '2012-08-04' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1521 , 'counts_orders' , 'date' , '2012-08-05' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1522 , 'counts_orders' , 'date' , '2012-08-06' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1523 , 'counts_orders' , 'date' , '2012-08-07' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1524 , 'counts_orders' , 'date' , '2012-08-08' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1525 , 'counts_orders' , 'date' , '2012-08-09' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1526 , 'counts_orders' , 'date' , '2012-08-10' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1527 , 'counts_orders' , 'date' , '2012-08-11' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1528 , 'counts_orders' , 'date' , '2012-08-12' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1529 , 'counts_orders' , 'date' , '2012-08-13' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1530 , 'counts_orders' , 'date' , '2012-08-14' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1531 , 'counts_orders' , 'date' , '2012-08-15' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1532 , 'counts_orders' , 'date' , '2012-08-16' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1533 , 'counts_orders' , 'date' , '2012-08-17' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1534 , 'counts_orders' , 'date' , '2012-08-18' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1535 , 'counts_orders' , 'date' , '2012-08-19' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1536 , 'counts_orders' , 'date' , '2012-08-20' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1537 , 'counts_orders' , 'date' , '2012-08-21' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1538 , 'counts_orders' , 'date' , '2012-08-22' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1539 , 'counts_orders' , 'date' , '2012-08-23' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1540 , 'counts_orders' , 'date' , '2012-08-24' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1541 , 'counts_orders' , 'date' , '2012-08-25' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1542 , 'counts_orders' , 'date' , '2012-08-26' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1543 , 'counts_orders' , 'date' , '2012-08-27' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1544 , 'counts_orders' , 'date' , '2012-08-28' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1545 , 'counts_orders' , 'date' , '2012-08-29' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1546 , 'counts_orders' , 'date' , '2012-08-30' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1547 , 'counts_orders' , 'date' , '2012-08-31' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1548 , 'counts_sales' , 'date' , '2012-08-02' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1549 , 'counts_sales' , 'date' , '2012-08-03' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1550 , 'counts_sales' , 'date' , '2012-08-04' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1551 , 'counts_sales' , 'date' , '2012-08-05' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1552 , 'counts_sales' , 'date' , '2012-08-06' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1553 , 'counts_sales' , 'date' , '2012-08-07' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1554 , 'counts_sales' , 'date' , '2012-08-08' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1555 , 'counts_sales' , 'date' , '2012-08-09' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1556 , 'counts_sales' , 'date' , '2012-08-10' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1557 , 'counts_sales' , 'date' , '2012-08-11' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1558 , 'counts_sales' , 'date' , '2012-08-12' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1559 , 'counts_sales' , 'date' , '2012-08-13' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1560 , 'counts_sales' , 'date' , '2012-08-14' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1561 , 'counts_sales' , 'date' , '2012-08-15' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1562 , 'counts_sales' , 'date' , '2012-08-16' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1563 , 'counts_sales' , 'date' , '2012-08-17' , '2012-09-01 02:17:13' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1564 , 'counts_sales' , 'date' , '2012-08-18' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1565 , 'counts_sales' , 'date' , '2012-08-19' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1566 , 'counts_sales' , 'date' , '2012-08-20' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1567 , 'counts_sales' , 'date' , '2012-08-21' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1568 , 'counts_sales' , 'date' , '2012-08-22' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1569 , 'counts_sales' , 'date' , '2012-08-23' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1570 , 'counts_sales' , 'date' , '2012-08-24' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1571 , 'counts_sales' , 'date' , '2012-08-25' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1572 , 'counts_sales' , 'date' , '2012-08-26' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1573 , 'counts_sales' , 'date' , '2012-08-27' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1574 , 'counts_sales' , 'date' , '2012-08-28' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1575 , 'counts_sales' , 'date' , '2012-08-29' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1576 , 'counts_sales' , 'date' , '2012-08-30' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1577 , 'counts_sales' , 'date' , '2012-08-31' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1578 , 'counts_visits' , 'date' , '2012-08-02' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1579 , 'counts_visits' , 'date' , '2012-08-03' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1580 , 'counts_visits' , 'date' , '2012-08-04' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1581 , 'counts_visits' , 'date' , '2012-08-05' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1582 , 'counts_visits' , 'date' , '2012-08-06' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1583 , 'counts_visits' , 'date' , '2012-08-07' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1584 , 'counts_visits' , 'date' , '2012-08-08' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1585 , 'counts_visits' , 'date' , '2012-08-09' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1586 , 'counts_visits' , 'date' , '2012-08-10' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1587 , 'counts_visits' , 'date' , '2012-08-11' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1588 , 'counts_visits' , 'date' , '2012-08-12' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1589 , 'counts_visits' , 'date' , '2012-08-13' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1590 , 'counts_visits' , 'date' , '2012-08-14' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1591 , 'counts_visits' , 'date' , '2012-08-15' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1592 , 'counts_visits' , 'date' , '2012-08-16' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1593 , 'counts_visits' , 'date' , '2012-08-17' , '2012-09-01 02:17:14' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1594 , 'counts_visits' , 'date' , '2012-08-18' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1595 , 'counts_visits' , 'date' , '2012-08-19' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1596 , 'counts_visits' , 'date' , '2012-08-20' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1597 , 'counts_visits' , 'date' , '2012-08-21' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1598 , 'counts_visits' , 'date' , '2012-08-22' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1599 , 'counts_visits' , 'date' , '2012-08-23' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1600 , 'counts_visits' , 'date' , '2012-08-24' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1601 , 'counts_visits' , 'date' , '2012-08-25' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1602 , 'counts_visits' , 'date' , '2012-08-26' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1603 , 'counts_visits' , 'date' , '2012-08-27' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1604 , 'counts_visits' , 'date' , '2012-08-28' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1605 , 'counts_visits' , 'date' , '2012-08-29' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1606 , 'counts_visits' , 'date' , '2012-08-30' , '2012-09-17 04:28:03' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1607 , 'counts_visits' , 'date' , '2012-08-31' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1608 , 'counts_visits' , 'date' , '2012-09-01' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1609 , 'counts_visits' , 'date' , '2012-09-02' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1610 , 'counts_visits' , 'date' , '2012-09-03' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1611 , 'counts_visits' , 'date' , '2012-09-04' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1612 , 'counts_visits' , 'date' , '2012-09-05' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1613 , 'counts_visits' , 'date' , '2012-09-06' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1614 , 'counts_visits' , 'date' , '2012-09-07' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1615 , 'counts_visits' , 'date' , '2012-09-08' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1616 , 'counts_visits' , 'date' , '2012-09-09' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1617 , 'counts_visits' , 'date' , '2012-09-10' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1618 , 'counts_visits' , 'date' , '2012-09-11' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1619 , 'counts_visits' , 'date' , '2012-09-12' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1620 , 'counts_visits' , 'date' , '2012-09-13' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1621 , 'counts_visits' , 'date' , '2012-09-14' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1622 , 'counts_visits' , 'date' , '2012-09-15' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1623 , 'counts_visits' , 'date' , '2012-09-16' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1624 , 'counts_users' , 'date' , '2012-09-01' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1625 , 'counts_users' , 'date' , '2012-09-02' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1626 , 'counts_users' , 'date' , '2012-09-03' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1627 , 'counts_users' , 'date' , '2012-09-04' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1628 , 'counts_users' , 'date' , '2012-09-05' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1629 , 'counts_users' , 'date' , '2012-09-06' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1630 , 'counts_users' , 'date' , '2012-09-07' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1631 , 'counts_users' , 'date' , '2012-09-08' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1632 , 'counts_users' , 'date' , '2012-09-09' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1633 , 'counts_users' , 'date' , '2012-09-10' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1634 , 'counts_users' , 'date' , '2012-09-11' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1635 , 'counts_users' , 'date' , '2012-09-12' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1636 , 'counts_users' , 'date' , '2012-09-13' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1637 , 'counts_users' , 'date' , '2012-09-14' , '2012-09-17 04:28:04' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1638 , 'counts_users' , 'date' , '2012-09-15' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1639 , 'counts_users' , 'date' , '2012-09-16' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1640 , 'counts_sales' , 'date' , '2012-09-01' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1641 , 'counts_sales' , 'date' , '2012-09-02' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1642 , 'counts_sales' , 'date' , '2012-09-03' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1643 , 'counts_sales' , 'date' , '2012-09-04' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1644 , 'counts_sales' , 'date' , '2012-09-05' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1645 , 'counts_sales' , 'date' , '2012-09-06' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1646 , 'counts_sales' , 'date' , '2012-09-07' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1647 , 'counts_sales' , 'date' , '2012-09-08' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1648 , 'counts_sales' , 'date' , '2012-09-09' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1649 , 'counts_sales' , 'date' , '2012-09-10' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1650 , 'counts_sales' , 'date' , '2012-09-11' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1651 , 'counts_sales' , 'date' , '2012-09-12' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1652 , 'counts_sales' , 'date' , '2012-09-13' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1653 , 'counts_sales' , 'date' , '2012-09-14' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1654 , 'counts_sales' , 'date' , '2012-09-15' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1655 , 'counts_sales' , 'date' , '2012-09-16' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1656 , 'counts_orders' , 'date' , '2012-09-01' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1657 , 'counts_orders' , 'date' , '2012-09-02' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1658 , 'counts_orders' , 'date' , '2012-09-03' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1659 , 'counts_orders' , 'date' , '2012-09-04' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1660 , 'counts_orders' , 'date' , '2012-09-05' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1661 , 'counts_orders' , 'date' , '2012-09-06' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1662 , 'counts_orders' , 'date' , '2012-09-07' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1663 , 'counts_orders' , 'date' , '2012-09-08' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1664 , 'counts_orders' , 'date' , '2012-09-09' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1665 , 'counts_orders' , 'date' , '2012-09-10' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1666 , 'counts_orders' , 'date' , '2012-09-11' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1667 , 'counts_orders' , 'date' , '2012-09-12' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1668 , 'counts_orders' , 'date' , '2012-09-13' , '2012-09-17 04:28:05' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1669 , 'counts_orders' , 'date' , '2012-09-14' , '2012-09-17 04:28:06' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1670 , 'counts_orders' , 'date' , '2012-09-15' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1671 , 'counts_orders' , 'date' , '2012-09-16' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1672 , 'counts_users' , 'date' , '2012-09-17' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1673 , 'counts_visits' , 'date' , '2012-09-17' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1674 , 'counts_sales' , 'date' , '2012-09-17' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1675 , 'counts_orders' , 'date' , '2012-09-17' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1676 , 'counts_sales' , 'date' , '2012-09-18' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1677 , 'counts_sales' , 'date' , '2012-09-19' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1678 , 'counts_sales' , 'date' , '2012-09-20' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1679 , 'counts_sales' , 'date' , '2012-09-21' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1680 , 'counts_sales' , 'date' , '2012-09-22' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1681 , 'counts_sales' , 'date' , '2012-09-23' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1682 , 'counts_sales' , 'date' , '2012-09-24' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1683 , 'counts_sales' , 'date' , '2012-09-25' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1684 , 'counts_sales' , 'date' , '2012-09-26' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1685 , 'counts_sales' , 'date' , '2012-09-27' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1686 , 'counts_sales' , 'date' , '2012-09-28' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1687 , 'counts_sales' , 'date' , '2012-09-29' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1688 , 'counts_sales' , 'date' , '2012-09-30' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1689 , 'counts_sales' , 'date' , '2012-10-01' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1690 , 'counts_sales' , 'date' , '2012-10-02' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1691 , 'counts_sales' , 'date' , '2012-10-03' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1692 , 'counts_sales' , 'date' , '2012-10-04' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1693 , 'counts_sales' , 'date' , '2012-10-05' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1694 , 'counts_sales' , 'date' , '2012-10-06' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1695 , 'counts_sales' , 'date' , '2012-10-07' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1696 , 'counts_sales' , 'date' , '2012-10-08' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1697 , 'counts_sales' , 'date' , '2012-10-09' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1698 , 'counts_sales' , 'date' , '2012-10-10' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1699 , 'counts_sales' , 'date' , '2012-10-11' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1700 , 'counts_sales' , 'date' , '2012-10-12' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1701 , 'counts_sales' , 'date' , '2012-10-13' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1702 , 'counts_sales' , 'date' , '2012-10-14' , '2012-10-15 18:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1703 , 'counts_visits' , 'date' , '2012-09-18' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1704 , 'counts_visits' , 'date' , '2012-09-19' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1705 , 'counts_visits' , 'date' , '2012-09-20' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1706 , 'counts_visits' , 'date' , '2012-09-21' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1707 , 'counts_visits' , 'date' , '2012-09-22' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1708 , 'counts_visits' , 'date' , '2012-09-23' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1709 , 'counts_visits' , 'date' , '2012-09-24' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1710 , 'counts_visits' , 'date' , '2012-09-25' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1711 , 'counts_visits' , 'date' , '2012-09-26' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1712 , 'counts_visits' , 'date' , '2012-09-27' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1713 , 'counts_visits' , 'date' , '2012-09-28' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1714 , 'counts_visits' , 'date' , '2012-09-29' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1715 , 'counts_visits' , 'date' , '2012-09-30' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1716 , 'counts_visits' , 'date' , '2012-10-01' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1717 , 'counts_visits' , 'date' , '2012-10-02' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1718 , 'counts_visits' , 'date' , '2012-10-03' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1719 , 'counts_visits' , 'date' , '2012-10-04' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1720 , 'counts_visits' , 'date' , '2012-10-05' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1721 , 'counts_visits' , 'date' , '2012-10-06' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1722 , 'counts_visits' , 'date' , '2012-10-07' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1723 , 'counts_visits' , 'date' , '2012-10-08' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1724 , 'counts_visits' , 'date' , '2012-10-09' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1725 , 'counts_visits' , 'date' , '2012-10-10' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1726 , 'counts_visits' , 'date' , '2012-10-11' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1727 , 'counts_visits' , 'date' , '2012-10-12' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1728 , 'counts_visits' , 'date' , '2012-10-13' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1729 , 'counts_visits' , 'date' , '2012-10-14' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1730 , 'counts_users' , 'date' , '2012-09-18' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1731 , 'counts_users' , 'date' , '2012-09-19' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1732 , 'counts_users' , 'date' , '2012-09-20' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1733 , 'counts_users' , 'date' , '2012-09-21' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1734 , 'counts_users' , 'date' , '2012-09-22' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1735 , 'counts_users' , 'date' , '2012-09-23' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1736 , 'counts_users' , 'date' , '2012-09-24' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1737 , 'counts_users' , 'date' , '2012-09-25' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1738 , 'counts_users' , 'date' , '2012-09-26' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1739 , 'counts_users' , 'date' , '2012-09-27' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1740 , 'counts_users' , 'date' , '2012-09-28' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1741 , 'counts_users' , 'date' , '2012-09-29' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1742 , 'counts_users' , 'date' , '2012-09-30' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1743 , 'counts_users' , 'date' , '2012-10-01' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1744 , 'counts_users' , 'date' , '2012-10-02' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1745 , 'counts_users' , 'date' , '2012-10-03' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1746 , 'counts_users' , 'date' , '2012-10-04' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1747 , 'counts_users' , 'date' , '2012-10-05' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1748 , 'counts_users' , 'date' , '2012-10-06' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1749 , 'counts_users' , 'date' , '2012-10-07' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1750 , 'counts_users' , 'date' , '2012-10-08' , '2012-10-15 18:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1751 , 'counts_users' , 'date' , '2012-10-09' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1752 , 'counts_users' , 'date' , '2012-10-10' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1753 , 'counts_users' , 'date' , '2012-10-11' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1754 , 'counts_users' , 'date' , '2012-10-12' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1755 , 'counts_users' , 'date' , '2012-10-13' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1756 , 'counts_users' , 'date' , '2012-10-14' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1757 , 'counts_orders' , 'date' , '2012-09-18' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1758 , 'counts_orders' , 'date' , '2012-09-19' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1759 , 'counts_orders' , 'date' , '2012-09-20' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1760 , 'counts_orders' , 'date' , '2012-09-21' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1761 , 'counts_orders' , 'date' , '2012-09-22' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1762 , 'counts_orders' , 'date' , '2012-09-23' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1763 , 'counts_orders' , 'date' , '2012-09-24' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1764 , 'counts_orders' , 'date' , '2012-09-25' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1765 , 'counts_orders' , 'date' , '2012-09-26' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1766 , 'counts_orders' , 'date' , '2012-09-27' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1767 , 'counts_orders' , 'date' , '2012-09-28' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1768 , 'counts_orders' , 'date' , '2012-09-29' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1769 , 'counts_orders' , 'date' , '2012-09-30' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1770 , 'counts_orders' , 'date' , '2012-10-01' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1771 , 'counts_orders' , 'date' , '2012-10-02' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1772 , 'counts_orders' , 'date' , '2012-10-03' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1773 , 'counts_orders' , 'date' , '2012-10-04' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1774 , 'counts_orders' , 'date' , '2012-10-05' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1775 , 'counts_orders' , 'date' , '2012-10-06' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1776 , 'counts_orders' , 'date' , '2012-10-07' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1777 , 'counts_orders' , 'date' , '2012-10-08' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1778 , 'counts_orders' , 'date' , '2012-10-09' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1779 , 'counts_orders' , 'date' , '2012-10-10' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1780 , 'counts_orders' , 'date' , '2012-10-11' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1781 , 'counts_orders' , 'date' , '2012-10-12' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1782 , 'counts_orders' , 'date' , '2012-10-13' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1783 , 'counts_orders' , 'date' , '2012-10-14' , '2012-10-15 18:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1784 , 'counts_users' , 'date' , '2012-11-06' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1785 , 'counts_users' , 'date' , '2012-11-07' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1786 , 'counts_users' , 'date' , '2012-11-08' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1787 , 'counts_users' , 'date' , '2012-11-09' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1788 , 'counts_users' , 'date' , '2012-11-10' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1789 , 'counts_users' , 'date' , '2012-11-11' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1790 , 'counts_users' , 'date' , '2012-11-12' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1791 , 'counts_users' , 'date' , '2012-11-13' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1792 , 'counts_users' , 'date' , '2012-11-14' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1793 , 'counts_users' , 'date' , '2012-11-15' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1794 , 'counts_users' , 'date' , '2012-11-16' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1795 , 'counts_users' , 'date' , '2012-11-17' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1796 , 'counts_users' , 'date' , '2012-11-18' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1797 , 'counts_users' , 'date' , '2012-11-19' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1798 , 'counts_users' , 'date' , '2012-11-20' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1799 , 'counts_users' , 'date' , '2012-11-21' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1800 , 'counts_users' , 'date' , '2012-11-22' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1801 , 'counts_users' , 'date' , '2012-11-23' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1802 , 'counts_users' , 'date' , '2012-11-24' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1803 , 'counts_users' , 'date' , '2012-11-25' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1804 , 'counts_users' , 'date' , '2012-11-26' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1805 , 'counts_users' , 'date' , '2012-11-27' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1806 , 'counts_users' , 'date' , '2012-11-28' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1807 , 'counts_users' , 'date' , '2012-11-29' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1808 , 'counts_users' , 'date' , '2012-11-30' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1809 , 'counts_users' , 'date' , '2012-12-01' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1810 , 'counts_users' , 'date' , '2012-12-02' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1811 , 'counts_users' , 'date' , '2012-12-03' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1812 , 'counts_users' , 'date' , '2012-12-04' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1813 , 'counts_users' , 'date' , '2012-12-05' , '2012-12-06 14:55:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1814 , 'counts_orders' , 'date' , '2012-11-06' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1815 , 'counts_orders' , 'date' , '2012-11-07' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1816 , 'counts_orders' , 'date' , '2012-11-08' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1817 , 'counts_orders' , 'date' , '2012-11-09' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1818 , 'counts_orders' , 'date' , '2012-11-10' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1819 , 'counts_orders' , 'date' , '2012-11-11' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1820 , 'counts_orders' , 'date' , '2012-11-12' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1821 , 'counts_orders' , 'date' , '2012-11-13' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1822 , 'counts_orders' , 'date' , '2012-11-14' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1823 , 'counts_orders' , 'date' , '2012-11-15' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1824 , 'counts_orders' , 'date' , '2012-11-16' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1825 , 'counts_orders' , 'date' , '2012-11-17' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1826 , 'counts_orders' , 'date' , '2012-11-18' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1827 , 'counts_orders' , 'date' , '2012-11-19' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1828 , 'counts_orders' , 'date' , '2012-11-20' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1829 , 'counts_orders' , 'date' , '2012-11-21' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1830 , 'counts_orders' , 'date' , '2012-11-22' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1831 , 'counts_orders' , 'date' , '2012-11-23' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1832 , 'counts_orders' , 'date' , '2012-11-24' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1833 , 'counts_orders' , 'date' , '2012-11-25' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1834 , 'counts_orders' , 'date' , '2012-11-26' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1835 , 'counts_orders' , 'date' , '2012-11-27' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1836 , 'counts_orders' , 'date' , '2012-11-28' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1837 , 'counts_orders' , 'date' , '2012-11-29' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1838 , 'counts_orders' , 'date' , '2012-11-30' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1839 , 'counts_orders' , 'date' , '2012-12-01' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1840 , 'counts_orders' , 'date' , '2012-12-02' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1841 , 'counts_orders' , 'date' , '2012-12-03' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1842 , 'counts_orders' , 'date' , '2012-12-04' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1843 , 'counts_orders' , 'date' , '2012-12-05' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1844 , 'counts_sales' , 'date' , '2012-11-06' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1845 , 'counts_sales' , 'date' , '2012-11-07' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1846 , 'counts_sales' , 'date' , '2012-11-08' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1847 , 'counts_sales' , 'date' , '2012-11-09' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1848 , 'counts_sales' , 'date' , '2012-11-10' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1849 , 'counts_sales' , 'date' , '2012-11-11' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1850 , 'counts_sales' , 'date' , '2012-11-12' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1851 , 'counts_sales' , 'date' , '2012-11-13' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1852 , 'counts_sales' , 'date' , '2012-11-14' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1853 , 'counts_sales' , 'date' , '2012-11-15' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1854 , 'counts_sales' , 'date' , '2012-11-16' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1855 , 'counts_sales' , 'date' , '2012-11-17' , '2012-12-06 14:55:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1856 , 'counts_sales' , 'date' , '2012-11-18' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1857 , 'counts_sales' , 'date' , '2012-11-19' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1858 , 'counts_sales' , 'date' , '2012-11-20' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1859 , 'counts_sales' , 'date' , '2012-11-21' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1860 , 'counts_sales' , 'date' , '2012-11-22' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1861 , 'counts_sales' , 'date' , '2012-11-23' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1862 , 'counts_sales' , 'date' , '2012-11-24' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1863 , 'counts_sales' , 'date' , '2012-11-25' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1864 , 'counts_sales' , 'date' , '2012-11-26' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1865 , 'counts_sales' , 'date' , '2012-11-27' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1866 , 'counts_sales' , 'date' , '2012-11-28' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1867 , 'counts_sales' , 'date' , '2012-11-29' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1868 , 'counts_sales' , 'date' , '2012-11-30' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1869 , 'counts_sales' , 'date' , '2012-12-01' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1870 , 'counts_sales' , 'date' , '2012-12-02' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1871 , 'counts_sales' , 'date' , '2012-12-03' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1872 , 'counts_sales' , 'date' , '2012-12-04' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1873 , 'counts_sales' , 'date' , '2012-12-05' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1874 , 'counts_visits' , 'date' , '2012-11-06' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1875 , 'counts_visits' , 'date' , '2012-11-07' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1876 , 'counts_visits' , 'date' , '2012-11-08' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1877 , 'counts_visits' , 'date' , '2012-11-09' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1878 , 'counts_visits' , 'date' , '2012-11-10' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1879 , 'counts_visits' , 'date' , '2012-11-11' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1880 , 'counts_visits' , 'date' , '2012-11-12' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1881 , 'counts_visits' , 'date' , '2012-11-13' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1882 , 'counts_visits' , 'date' , '2012-11-14' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1883 , 'counts_visits' , 'date' , '2012-11-15' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1884 , 'counts_visits' , 'date' , '2012-11-16' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1885 , 'counts_visits' , 'date' , '2012-11-17' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1886 , 'counts_visits' , 'date' , '2012-11-18' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1887 , 'counts_visits' , 'date' , '2012-11-19' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1888 , 'counts_visits' , 'date' , '2012-11-20' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1889 , 'counts_visits' , 'date' , '2012-11-21' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1890 , 'counts_visits' , 'date' , '2012-11-22' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1891 , 'counts_visits' , 'date' , '2012-11-23' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1892 , 'counts_visits' , 'date' , '2012-11-24' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1893 , 'counts_visits' , 'date' , '2012-11-25' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1894 , 'counts_visits' , 'date' , '2012-11-26' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1895 , 'counts_visits' , 'date' , '2012-11-27' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1896 , 'counts_visits' , 'date' , '2012-11-28' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1897 , 'counts_visits' , 'date' , '2012-11-29' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1898 , 'counts_visits' , 'date' , '2012-11-30' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1899 , 'counts_visits' , 'date' , '2012-12-01' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1900 , 'counts_visits' , 'date' , '2012-12-02' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1901 , 'counts_visits' , 'date' , '2012-12-03' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1902 , 'counts_visits' , 'date' , '2012-12-04' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1903 , 'counts_visits' , 'date' , '2012-12-05' , '2012-12-06 14:55:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1904 , 'counts_orders' , 'date' , '2013-12-28' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1905 , 'counts_orders' , 'date' , '2013-12-29' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1906 , 'counts_orders' , 'date' , '2013-12-30' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1907 , 'counts_orders' , 'date' , '2013-12-31' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1908 , 'counts_orders' , 'date' , '2014-01-01' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1909 , 'counts_orders' , 'date' , '2014-01-02' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1910 , 'counts_orders' , 'date' , '2014-01-03' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1911 , 'counts_orders' , 'date' , '2014-01-04' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1912 , 'counts_orders' , 'date' , '2014-01-05' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1913 , 'counts_orders' , 'date' , '2014-01-06' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1914 , 'counts_orders' , 'date' , '2014-01-07' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1915 , 'counts_orders' , 'date' , '2014-01-08' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1916 , 'counts_orders' , 'date' , '2014-01-09' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1917 , 'counts_orders' , 'date' , '2014-01-10' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1918 , 'counts_orders' , 'date' , '2014-01-11' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1919 , 'counts_orders' , 'date' , '2014-01-12' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1920 , 'counts_orders' , 'date' , '2014-01-13' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1921 , 'counts_orders' , 'date' , '2014-01-14' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1922 , 'counts_orders' , 'date' , '2014-01-15' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1923 , 'counts_orders' , 'date' , '2014-01-16' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1924 , 'counts_orders' , 'date' , '2014-01-17' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1925 , 'counts_orders' , 'date' , '2014-01-18' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1926 , 'counts_orders' , 'date' , '2014-01-19' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1927 , 'counts_orders' , 'date' , '2014-01-20' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1928 , 'counts_orders' , 'date' , '2014-01-21' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1929 , 'counts_orders' , 'date' , '2014-01-22' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1930 , 'counts_orders' , 'date' , '2014-01-23' , '2014-01-27 23:36:45' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1931 , 'counts_orders' , 'date' , '2014-01-24' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1932 , 'counts_orders' , 'date' , '2014-01-25' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1933 , 'counts_orders' , 'date' , '2014-01-26' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1934 , 'counts_users' , 'date' , '2013-12-28' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1935 , 'counts_users' , 'date' , '2013-12-29' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1936 , 'counts_users' , 'date' , '2013-12-30' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1937 , 'counts_users' , 'date' , '2013-12-31' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1938 , 'counts_users' , 'date' , '2014-01-01' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1939 , 'counts_users' , 'date' , '2014-01-02' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1940 , 'counts_users' , 'date' , '2014-01-03' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1941 , 'counts_users' , 'date' , '2014-01-04' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1942 , 'counts_users' , 'date' , '2014-01-05' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1943 , 'counts_users' , 'date' , '2014-01-06' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1944 , 'counts_users' , 'date' , '2014-01-07' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1945 , 'counts_users' , 'date' , '2014-01-08' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1946 , 'counts_users' , 'date' , '2014-01-09' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1947 , 'counts_users' , 'date' , '2014-01-10' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1948 , 'counts_users' , 'date' , '2014-01-11' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1949 , 'counts_users' , 'date' , '2014-01-12' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1950 , 'counts_users' , 'date' , '2014-01-13' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1951 , 'counts_users' , 'date' , '2014-01-14' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1952 , 'counts_users' , 'date' , '2014-01-15' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1953 , 'counts_users' , 'date' , '2014-01-16' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1954 , 'counts_users' , 'date' , '2014-01-17' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1955 , 'counts_users' , 'date' , '2014-01-18' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1956 , 'counts_users' , 'date' , '2014-01-19' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1957 , 'counts_users' , 'date' , '2014-01-20' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1958 , 'counts_users' , 'date' , '2014-01-21' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1959 , 'counts_users' , 'date' , '2014-01-22' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1960 , 'counts_users' , 'date' , '2014-01-23' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1961 , 'counts_users' , 'date' , '2014-01-24' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1962 , 'counts_users' , 'date' , '2014-01-25' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1963 , 'counts_users' , 'date' , '2014-01-26' , '2014-01-27 23:36:46' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1964 , 'counts_sales' , 'date' , '2013-12-28' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1965 , 'counts_sales' , 'date' , '2013-12-29' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1966 , 'counts_sales' , 'date' , '2013-12-30' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1967 , 'counts_sales' , 'date' , '2013-12-31' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1968 , 'counts_sales' , 'date' , '2014-01-01' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1969 , 'counts_sales' , 'date' , '2014-01-02' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1970 , 'counts_sales' , 'date' , '2014-01-03' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1971 , 'counts_sales' , 'date' , '2014-01-04' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1972 , 'counts_sales' , 'date' , '2014-01-05' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1973 , 'counts_sales' , 'date' , '2014-01-06' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1974 , 'counts_sales' , 'date' , '2014-01-07' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1975 , 'counts_sales' , 'date' , '2014-01-08' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1976 , 'counts_sales' , 'date' , '2014-01-09' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1977 , 'counts_sales' , 'date' , '2014-01-10' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1978 , 'counts_sales' , 'date' , '2014-01-11' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1979 , 'counts_sales' , 'date' , '2014-01-12' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1980 , 'counts_sales' , 'date' , '2014-01-13' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1981 , 'counts_sales' , 'date' , '2014-01-14' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1982 , 'counts_sales' , 'date' , '2014-01-15' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1983 , 'counts_sales' , 'date' , '2014-01-16' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1984 , 'counts_sales' , 'date' , '2014-01-17' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1985 , 'counts_sales' , 'date' , '2014-01-18' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1986 , 'counts_sales' , 'date' , '2014-01-19' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1987 , 'counts_sales' , 'date' , '2014-01-20' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1988 , 'counts_sales' , 'date' , '2014-01-21' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1989 , 'counts_sales' , 'date' , '2014-01-22' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1990 , 'counts_sales' , 'date' , '2014-01-23' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1991 , 'counts_sales' , 'date' , '2014-01-24' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1992 , 'counts_sales' , 'date' , '2014-01-25' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1993 , 'counts_sales' , 'date' , '2014-01-26' , '2014-01-27 23:36:47' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1994 , 'counts_users' , 'date' , '2014-02-24' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1995 , 'counts_users' , 'date' , '2014-02-25' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1996 , 'counts_users' , 'date' , '2014-02-26' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1997 , 'counts_users' , 'date' , '2014-02-27' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1998 , 'counts_users' , 'date' , '2014-02-28' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (1999 , 'counts_users' , 'date' , '2014-03-01' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2000 , 'counts_users' , 'date' , '2014-03-02' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2001 , 'counts_users' , 'date' , '2014-03-03' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2002 , 'counts_users' , 'date' , '2014-03-04' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2003 , 'counts_users' , 'date' , '2014-03-05' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2004 , 'counts_users' , 'date' , '2014-03-06' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2005 , 'counts_users' , 'date' , '2014-03-07' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2006 , 'counts_users' , 'date' , '2014-03-08' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2007 , 'counts_users' , 'date' , '2014-03-09' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2008 , 'counts_users' , 'date' , '2014-03-10' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2009 , 'counts_users' , 'date' , '2014-03-11' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2010 , 'counts_users' , 'date' , '2014-03-12' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2011 , 'counts_users' , 'date' , '2014-03-13' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2012 , 'counts_users' , 'date' , '2014-03-14' , '2014-03-26 21:06:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2013 , 'counts_users' , 'date' , '2014-03-15' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2014 , 'counts_users' , 'date' , '2014-03-16' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2015 , 'counts_users' , 'date' , '2014-03-17' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2016 , 'counts_users' , 'date' , '2014-03-18' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2017 , 'counts_users' , 'date' , '2014-03-19' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2018 , 'counts_users' , 'date' , '2014-03-20' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2019 , 'counts_users' , 'date' , '2014-03-21' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2020 , 'counts_users' , 'date' , '2014-03-22' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2021 , 'counts_users' , 'date' , '2014-03-23' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2022 , 'counts_users' , 'date' , '2014-03-24' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2023 , 'counts_users' , 'date' , '2014-03-25' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2024 , 'counts_sales' , 'date' , '2014-02-24' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2025 , 'counts_sales' , 'date' , '2014-02-25' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2026 , 'counts_sales' , 'date' , '2014-02-26' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2027 , 'counts_sales' , 'date' , '2014-02-27' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2028 , 'counts_sales' , 'date' , '2014-02-28' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2029 , 'counts_sales' , 'date' , '2014-03-01' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2030 , 'counts_sales' , 'date' , '2014-03-02' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2031 , 'counts_sales' , 'date' , '2014-03-03' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2032 , 'counts_sales' , 'date' , '2014-03-04' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2033 , 'counts_sales' , 'date' , '2014-03-05' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2034 , 'counts_sales' , 'date' , '2014-03-06' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2035 , 'counts_sales' , 'date' , '2014-03-07' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2036 , 'counts_sales' , 'date' , '2014-03-08' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2037 , 'counts_sales' , 'date' , '2014-03-09' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2038 , 'counts_sales' , 'date' , '2014-03-10' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2039 , 'counts_sales' , 'date' , '2014-03-11' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2040 , 'counts_sales' , 'date' , '2014-03-12' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2041 , 'counts_sales' , 'date' , '2014-03-13' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2042 , 'counts_sales' , 'date' , '2014-03-14' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2043 , 'counts_sales' , 'date' , '2014-03-15' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2044 , 'counts_sales' , 'date' , '2014-03-16' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2045 , 'counts_sales' , 'date' , '2014-03-17' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2046 , 'counts_sales' , 'date' , '2014-03-18' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2047 , 'counts_sales' , 'date' , '2014-03-19' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2048 , 'counts_sales' , 'date' , '2014-03-20' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2049 , 'counts_sales' , 'date' , '2014-03-21' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2050 , 'counts_sales' , 'date' , '2014-03-22' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2051 , 'counts_sales' , 'date' , '2014-03-23' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2052 , 'counts_sales' , 'date' , '2014-03-24' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2053 , 'counts_sales' , 'date' , '2014-03-25' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2054 , 'counts_orders' , 'date' , '2014-02-24' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2055 , 'counts_orders' , 'date' , '2014-02-25' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2056 , 'counts_orders' , 'date' , '2014-02-26' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2057 , 'counts_orders' , 'date' , '2014-02-27' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2058 , 'counts_orders' , 'date' , '2014-02-28' , '2014-03-26 21:06:25' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2059 , 'counts_orders' , 'date' , '2014-03-01' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2060 , 'counts_orders' , 'date' , '2014-03-02' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2061 , 'counts_orders' , 'date' , '2014-03-03' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2062 , 'counts_orders' , 'date' , '2014-03-04' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2063 , 'counts_orders' , 'date' , '2014-03-05' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2064 , 'counts_orders' , 'date' , '2014-03-06' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2065 , 'counts_orders' , 'date' , '2014-03-07' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2066 , 'counts_orders' , 'date' , '2014-03-08' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2067 , 'counts_orders' , 'date' , '2014-03-09' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2068 , 'counts_orders' , 'date' , '2014-03-10' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2069 , 'counts_orders' , 'date' , '2014-03-11' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2070 , 'counts_orders' , 'date' , '2014-03-12' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2071 , 'counts_orders' , 'date' , '2014-03-13' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2072 , 'counts_orders' , 'date' , '2014-03-14' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2073 , 'counts_orders' , 'date' , '2014-03-15' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2074 , 'counts_orders' , 'date' , '2014-03-16' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2075 , 'counts_orders' , 'date' , '2014-03-17' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2076 , 'counts_orders' , 'date' , '2014-03-18' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2077 , 'counts_orders' , 'date' , '2014-03-19' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2078 , 'counts_orders' , 'date' , '2014-03-20' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2079 , 'counts_orders' , 'date' , '2014-03-21' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2080 , 'counts_orders' , 'date' , '2014-03-22' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2081 , 'counts_orders' , 'date' , '2014-03-23' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2082 , 'counts_orders' , 'date' , '2014-03-24' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2083 , 'counts_orders' , 'date' , '2014-03-25' , '2014-03-26 21:06:26' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2084 , 'counts_users' , 'date' , '2014-12-28' , '2015-01-27 15:56:41' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2085 , 'counts_users' , 'date' , '2014-12-29' , '2015-01-27 15:56:41' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2086 , 'counts_users' , 'date' , '2014-12-30' , '2015-01-27 15:56:41' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2087 , 'counts_users' , 'date' , '2014-12-31' , '2015-01-27 15:56:41' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2088 , 'counts_users' , 'date' , '2015-01-01' , '2015-01-27 15:56:41' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2089 , 'counts_users' , 'date' , '2015-01-02' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2090 , 'counts_users' , 'date' , '2015-01-03' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2091 , 'counts_users' , 'date' , '2015-01-04' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2092 , 'counts_users' , 'date' , '2015-01-05' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2093 , 'counts_users' , 'date' , '2015-01-06' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2094 , 'counts_users' , 'date' , '2015-01-07' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2095 , 'counts_users' , 'date' , '2015-01-08' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2096 , 'counts_users' , 'date' , '2015-01-09' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2097 , 'counts_users' , 'date' , '2015-01-10' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2098 , 'counts_users' , 'date' , '2015-01-11' , '2015-02-04 14:55:59' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2099 , 'counts_users' , 'date' , '2015-01-12' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2100 , 'counts_users' , 'date' , '2015-01-13' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2101 , 'counts_users' , 'date' , '2015-01-14' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2102 , 'counts_users' , 'date' , '2015-01-15' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2103 , 'counts_users' , 'date' , '2015-01-16' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2104 , 'counts_users' , 'date' , '2015-01-17' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2105 , 'counts_users' , 'date' , '2015-01-18' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2106 , 'counts_users' , 'date' , '2015-01-19' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2107 , 'counts_users' , 'date' , '2015-01-20' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2108 , 'counts_users' , 'date' , '2015-01-21' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2109 , 'counts_users' , 'date' , '2015-01-22' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2110 , 'counts_users' , 'date' , '2015-01-23' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2111 , 'counts_users' , 'date' , '2015-01-24' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2112 , 'counts_users' , 'date' , '2015-01-25' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2113 , 'counts_users' , 'date' , '2015-01-26' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2114 , 'counts_orders' , 'date' , '2014-12-28' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2115 , 'counts_orders' , 'date' , '2014-12-29' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2116 , 'counts_orders' , 'date' , '2014-12-30' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2117 , 'counts_orders' , 'date' , '2014-12-31' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2118 , 'counts_orders' , 'date' , '2015-01-01' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2119 , 'counts_orders' , 'date' , '2015-01-02' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2120 , 'counts_orders' , 'date' , '2015-01-03' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2121 , 'counts_orders' , 'date' , '2015-01-04' , '2015-01-27 15:56:42' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2122 , 'counts_orders' , 'date' , '2015-01-05' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2123 , 'counts_orders' , 'date' , '2015-01-06' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2124 , 'counts_orders' , 'date' , '2015-01-07' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2125 , 'counts_orders' , 'date' , '2015-01-08' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2126 , 'counts_orders' , 'date' , '2015-01-09' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2127 , 'counts_orders' , 'date' , '2015-01-10' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2128 , 'counts_orders' , 'date' , '2015-01-11' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2129 , 'counts_orders' , 'date' , '2015-01-12' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2130 , 'counts_orders' , 'date' , '2015-01-13' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2131 , 'counts_orders' , 'date' , '2015-01-14' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2132 , 'counts_orders' , 'date' , '2015-01-15' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2133 , 'counts_orders' , 'date' , '2015-01-16' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2134 , 'counts_orders' , 'date' , '2015-01-17' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2135 , 'counts_orders' , 'date' , '2015-01-18' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2136 , 'counts_orders' , 'date' , '2015-01-19' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2137 , 'counts_orders' , 'date' , '2015-01-20' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2138 , 'counts_orders' , 'date' , '2015-01-21' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2139 , 'counts_orders' , 'date' , '2015-01-22' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2140 , 'counts_orders' , 'date' , '2015-01-23' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2141 , 'counts_orders' , 'date' , '2015-01-24' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2142 , 'counts_orders' , 'date' , '2015-01-25' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2143 , 'counts_orders' , 'date' , '2015-01-26' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2144 , 'counts_sales' , 'date' , '2014-12-28' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2145 , 'counts_sales' , 'date' , '2014-12-29' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2146 , 'counts_sales' , 'date' , '2014-12-30' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2147 , 'counts_sales' , 'date' , '2014-12-31' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2148 , 'counts_sales' , 'date' , '2015-01-01' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2149 , 'counts_sales' , 'date' , '2015-01-02' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2150 , 'counts_sales' , 'date' , '2015-01-03' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2151 , 'counts_sales' , 'date' , '2015-01-04' , '2015-01-27 15:56:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2152 , 'counts_sales' , 'date' , '2015-01-05' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2153 , 'counts_sales' , 'date' , '2015-01-06' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2154 , 'counts_sales' , 'date' , '2015-01-07' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2155 , 'counts_sales' , 'date' , '2015-01-08' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2156 , 'counts_sales' , 'date' , '2015-01-09' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2157 , 'counts_sales' , 'date' , '2015-01-10' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2158 , 'counts_sales' , 'date' , '2015-01-11' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2159 , 'counts_sales' , 'date' , '2015-01-12' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2160 , 'counts_sales' , 'date' , '2015-01-13' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2161 , 'counts_sales' , 'date' , '2015-01-14' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2162 , 'counts_sales' , 'date' , '2015-01-15' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2163 , 'counts_sales' , 'date' , '2015-01-16' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2164 , 'counts_sales' , 'date' , '2015-01-17' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2165 , 'counts_sales' , 'date' , '2015-01-18' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2166 , 'counts_sales' , 'date' , '2015-01-19' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2167 , 'counts_sales' , 'date' , '2015-01-20' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2168 , 'counts_sales' , 'date' , '2015-01-21' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2169 , 'counts_sales' , 'date' , '2015-01-22' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2170 , 'counts_sales' , 'date' , '2015-01-23' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2171 , 'counts_sales' , 'date' , '2015-01-24' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2172 , 'counts_sales' , 'date' , '2015-01-25' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2173 , 'counts_sales' , 'date' , '2015-01-26' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2174 , 'counts_users' , 'date' , '2015-01-27' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2175 , 'counts_users' , 'date' , '2015-01-28' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2176 , 'counts_users' , 'date' , '2015-01-29' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2177 , 'counts_users' , 'date' , '2015-01-30' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2178 , 'counts_users' , 'date' , '2015-01-31' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2179 , 'counts_users' , 'date' , '2015-02-01' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2180 , 'counts_users' , 'date' , '2015-02-02' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2181 , 'counts_users' , 'date' , '2015-02-03' , '2015-02-04 14:56:00' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2182 , 'counts_orders' , 'date' , '2015-01-27' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2183 , 'counts_orders' , 'date' , '2015-01-28' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2184 , 'counts_orders' , 'date' , '2015-01-29' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2185 , 'counts_orders' , 'date' , '2015-01-30' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2186 , 'counts_orders' , 'date' , '2015-01-31' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2187 , 'counts_orders' , 'date' , '2015-02-01' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2188 , 'counts_orders' , 'date' , '2015-02-02' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2189 , 'counts_orders' , 'date' , '2015-02-03' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2190 , 'counts_sales' , 'date' , '2015-01-27' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2191 , 'counts_sales' , 'date' , '2015-01-28' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2192 , 'counts_sales' , 'date' , '2015-01-29' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2193 , 'counts_sales' , 'date' , '2015-01-30' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2194 , 'counts_sales' , 'date' , '2015-01-31' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2195 , 'counts_sales' , 'date' , '2015-02-01' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2196 , 'counts_sales' , 'date' , '2015-02-02' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2197 , 'counts_sales' , 'date' , '2015-02-03' , '2015-02-04 14:56:01' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2198 , 'counts_users' , 'date' , '2015-02-09' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2199 , 'counts_users' , 'date' , '2015-02-10' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2200 , 'counts_users' , 'date' , '2015-02-11' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2201 , 'counts_users' , 'date' , '2015-02-12' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2202 , 'counts_users' , 'date' , '2015-02-13' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2203 , 'counts_users' , 'date' , '2015-02-14' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2204 , 'counts_users' , 'date' , '2015-02-15' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2205 , 'counts_users' , 'date' , '2015-02-16' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2206 , 'counts_users' , 'date' , '2015-02-17' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2207 , 'counts_users' , 'date' , '2015-02-18' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2208 , 'counts_users' , 'date' , '2015-02-19' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2209 , 'counts_users' , 'date' , '2015-02-20' , '2015-03-11 23:27:30' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2210 , 'counts_users' , 'date' , '2015-02-21' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2211 , 'counts_users' , 'date' , '2015-02-22' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2212 , 'counts_users' , 'date' , '2015-02-23' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2213 , 'counts_users' , 'date' , '2015-02-24' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2214 , 'counts_users' , 'date' , '2015-02-25' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2215 , 'counts_users' , 'date' , '2015-02-26' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2216 , 'counts_users' , 'date' , '2015-02-27' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2217 , 'counts_users' , 'date' , '2015-02-28' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2218 , 'counts_users' , 'date' , '2015-03-01' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2219 , 'counts_users' , 'date' , '2015-03-02' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2220 , 'counts_users' , 'date' , '2015-03-03' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2221 , 'counts_users' , 'date' , '2015-03-04' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2222 , 'counts_users' , 'date' , '2015-03-05' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2223 , 'counts_users' , 'date' , '2015-03-06' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2224 , 'counts_users' , 'date' , '2015-03-07' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2225 , 'counts_users' , 'date' , '2015-03-08' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2226 , 'counts_users' , 'date' , '2015-03-09' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2227 , 'counts_users' , 'date' , '2015-03-10' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2228 , 'counts_sales' , 'date' , '2015-02-09' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2229 , 'counts_sales' , 'date' , '2015-02-10' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2230 , 'counts_sales' , 'date' , '2015-02-11' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2231 , 'counts_sales' , 'date' , '2015-02-12' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2232 , 'counts_sales' , 'date' , '2015-02-13' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2233 , 'counts_sales' , 'date' , '2015-02-14' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2234 , 'counts_sales' , 'date' , '2015-02-15' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2235 , 'counts_sales' , 'date' , '2015-02-16' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2236 , 'counts_sales' , 'date' , '2015-02-17' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2237 , 'counts_sales' , 'date' , '2015-02-18' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2238 , 'counts_sales' , 'date' , '2015-02-19' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2239 , 'counts_sales' , 'date' , '2015-02-20' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2240 , 'counts_sales' , 'date' , '2015-02-21' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2241 , 'counts_sales' , 'date' , '2015-02-22' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2242 , 'counts_sales' , 'date' , '2015-02-23' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2243 , 'counts_sales' , 'date' , '2015-02-24' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2244 , 'counts_sales' , 'date' , '2015-02-25' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2245 , 'counts_sales' , 'date' , '2015-02-26' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2246 , 'counts_sales' , 'date' , '2015-02-27' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2247 , 'counts_sales' , 'date' , '2015-02-28' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2248 , 'counts_sales' , 'date' , '2015-03-01' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2249 , 'counts_sales' , 'date' , '2015-03-02' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2250 , 'counts_sales' , 'date' , '2015-03-03' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2251 , 'counts_sales' , 'date' , '2015-03-04' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2252 , 'counts_sales' , 'date' , '2015-03-05' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2253 , 'counts_sales' , 'date' , '2015-03-06' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2254 , 'counts_sales' , 'date' , '2015-03-07' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2255 , 'counts_sales' , 'date' , '2015-03-08' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2256 , 'counts_sales' , 'date' , '2015-03-09' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2257 , 'counts_sales' , 'date' , '2015-03-10' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2258 , 'counts_orders' , 'date' , '2015-02-09' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2259 , 'counts_orders' , 'date' , '2015-02-10' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2260 , 'counts_orders' , 'date' , '2015-02-11' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2261 , 'counts_orders' , 'date' , '2015-02-12' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2262 , 'counts_orders' , 'date' , '2015-02-13' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2263 , 'counts_orders' , 'date' , '2015-02-14' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2264 , 'counts_orders' , 'date' , '2015-02-15' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2265 , 'counts_orders' , 'date' , '2015-02-16' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2266 , 'counts_orders' , 'date' , '2015-02-17' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2267 , 'counts_orders' , 'date' , '2015-02-18' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2268 , 'counts_orders' , 'date' , '2015-02-19' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2269 , 'counts_orders' , 'date' , '2015-02-20' , '2015-03-11 23:27:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2270 , 'counts_orders' , 'date' , '2015-02-21' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2271 , 'counts_orders' , 'date' , '2015-02-22' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2272 , 'counts_orders' , 'date' , '2015-02-23' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2273 , 'counts_orders' , 'date' , '2015-02-24' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2274 , 'counts_orders' , 'date' , '2015-02-25' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2275 , 'counts_orders' , 'date' , '2015-02-26' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2276 , 'counts_orders' , 'date' , '2015-02-27' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2277 , 'counts_orders' , 'date' , '2015-02-28' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2278 , 'counts_orders' , 'date' , '2015-03-01' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2279 , 'counts_orders' , 'date' , '2015-03-02' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2280 , 'counts_orders' , 'date' , '2015-03-03' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2281 , 'counts_orders' , 'date' , '2015-03-04' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2282 , 'counts_orders' , 'date' , '2015-03-05' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2283 , 'counts_orders' , 'date' , '2015-03-06' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2284 , 'counts_orders' , 'date' , '2015-03-07' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2285 , 'counts_orders' , 'date' , '2015-03-08' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2286 , 'counts_orders' , 'date' , '2015-03-09' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2287 , 'counts_orders' , 'date' , '2015-03-10' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2288 , 'counts_orders' , 'date' , '2015-03-11' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2289 , 'counts_orders' , 'date' , '2015-03-12' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2290 , 'counts_orders' , 'date' , '2015-03-13' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2291 , 'counts_orders' , 'date' , '2015-03-14' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2292 , 'counts_orders' , 'date' , '2015-03-15' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2293 , 'counts_orders' , 'date' , '2015-03-16' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2294 , 'counts_orders' , 'date' , '2015-03-17' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2295 , 'counts_orders' , 'date' , '2015-03-18' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2296 , 'counts_orders' , 'date' , '2015-03-19' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2297 , 'counts_orders' , 'date' , '2015-03-20' , '2015-03-23 23:09:48' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2298 , 'counts_orders' , 'date' , '2015-03-21' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2299 , 'counts_orders' , 'date' , '2015-03-22' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2300 , 'counts_sales' , 'date' , '2015-03-11' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2301 , 'counts_sales' , 'date' , '2015-03-12' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2302 , 'counts_sales' , 'date' , '2015-03-13' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2303 , 'counts_sales' , 'date' , '2015-03-14' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2304 , 'counts_sales' , 'date' , '2015-03-15' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2305 , 'counts_sales' , 'date' , '2015-03-16' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2306 , 'counts_sales' , 'date' , '2015-03-17' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2307 , 'counts_sales' , 'date' , '2015-03-18' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2308 , 'counts_sales' , 'date' , '2015-03-19' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2309 , 'counts_sales' , 'date' , '2015-03-20' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2310 , 'counts_sales' , 'date' , '2015-03-21' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2311 , 'counts_sales' , 'date' , '2015-03-22' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2312 , 'counts_users' , 'date' , '2015-03-11' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2313 , 'counts_users' , 'date' , '2015-03-12' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2314 , 'counts_users' , 'date' , '2015-03-13' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2315 , 'counts_users' , 'date' , '2015-03-14' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2316 , 'counts_users' , 'date' , '2015-03-15' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2317 , 'counts_users' , 'date' , '2015-03-16' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2318 , 'counts_users' , 'date' , '2015-03-17' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2319 , 'counts_users' , 'date' , '2015-03-18' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2320 , 'counts_users' , 'date' , '2015-03-19' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2321 , 'counts_users' , 'date' , '2015-03-20' , '2015-03-23 23:09:49' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2322 , 'counts_users' , 'date' , '2015-03-21' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2323 , 'counts_users' , 'date' , '2015-03-22' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2324 , 'counts_orders' , 'date' , '2015-03-23' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2325 , 'counts_orders' , 'date' , '2015-03-24' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2326 , 'counts_orders' , 'date' , '2015-03-25' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2327 , 'counts_orders' , 'date' , '2015-03-26' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2328 , 'counts_orders' , 'date' , '2015-03-27' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2329 , 'counts_orders' , 'date' , '2015-03-28' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2330 , 'counts_orders' , 'date' , '2015-03-29' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2331 , 'counts_orders' , 'date' , '2015-03-30' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2332 , 'counts_orders' , 'date' , '2015-03-31' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2333 , 'counts_orders' , 'date' , '2015-04-01' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2334 , 'counts_orders' , 'date' , '2015-04-02' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2335 , 'counts_orders' , 'date' , '2015-04-03' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2336 , 'counts_orders' , 'date' , '2015-04-04' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2337 , 'counts_orders' , 'date' , '2015-04-05' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2338 , 'counts_orders' , 'date' , '2015-04-06' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2339 , 'counts_orders' , 'date' , '2015-04-07' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2340 , 'counts_orders' , 'date' , '2015-04-08' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2341 , 'counts_orders' , 'date' , '2015-04-09' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2342 , 'counts_orders' , 'date' , '2015-04-10' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2343 , 'counts_orders' , 'date' , '2015-04-11' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2344 , 'counts_orders' , 'date' , '2015-04-12' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2345 , 'counts_orders' , 'date' , '2015-04-13' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2346 , 'counts_orders' , 'date' , '2015-04-14' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2347 , 'counts_orders' , 'date' , '2015-04-15' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2348 , 'counts_orders' , 'date' , '2015-04-16' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2349 , 'counts_orders' , 'date' , '2015-04-17' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2350 , 'counts_orders' , 'date' , '2015-04-18' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2351 , 'counts_orders' , 'date' , '2015-04-19' , '2015-04-20 09:09:31' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2352 , 'counts_users' , 'date' , '2015-03-23' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2353 , 'counts_users' , 'date' , '2015-03-24' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2354 , 'counts_users' , 'date' , '2015-03-25' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2355 , 'counts_users' , 'date' , '2015-03-26' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2356 , 'counts_users' , 'date' , '2015-03-27' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2357 , 'counts_users' , 'date' , '2015-03-28' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2358 , 'counts_users' , 'date' , '2015-03-29' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2359 , 'counts_users' , 'date' , '2015-03-30' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2360 , 'counts_users' , 'date' , '2015-03-31' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2361 , 'counts_users' , 'date' , '2015-04-01' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2362 , 'counts_users' , 'date' , '2015-04-02' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2363 , 'counts_users' , 'date' , '2015-04-03' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2364 , 'counts_users' , 'date' , '2015-04-04' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2365 , 'counts_users' , 'date' , '2015-04-05' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2366 , 'counts_users' , 'date' , '2015-04-06' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2367 , 'counts_users' , 'date' , '2015-04-07' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2368 , 'counts_users' , 'date' , '2015-04-08' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2369 , 'counts_users' , 'date' , '2015-04-09' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2370 , 'counts_users' , 'date' , '2015-04-10' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2371 , 'counts_users' , 'date' , '2015-04-11' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2372 , 'counts_users' , 'date' , '2015-04-12' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2373 , 'counts_users' , 'date' , '2015-04-13' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2374 , 'counts_users' , 'date' , '2015-04-14' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2375 , 'counts_users' , 'date' , '2015-04-15' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2376 , 'counts_users' , 'date' , '2015-04-16' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2377 , 'counts_users' , 'date' , '2015-04-17' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2378 , 'counts_users' , 'date' , '2015-04-18' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2379 , 'counts_users' , 'date' , '2015-04-19' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2380 , 'counts_sales' , 'date' , '2015-03-23' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2381 , 'counts_sales' , 'date' , '2015-03-24' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2382 , 'counts_sales' , 'date' , '2015-03-25' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2383 , 'counts_sales' , 'date' , '2015-03-26' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2384 , 'counts_sales' , 'date' , '2015-03-27' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2385 , 'counts_sales' , 'date' , '2015-03-28' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2386 , 'counts_sales' , 'date' , '2015-03-29' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2387 , 'counts_sales' , 'date' , '2015-03-30' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2388 , 'counts_sales' , 'date' , '2015-03-31' , '2015-04-20 09:09:32' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2389 , 'counts_sales' , 'date' , '2015-04-01' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2390 , 'counts_sales' , 'date' , '2015-04-02' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2391 , 'counts_sales' , 'date' , '2015-04-03' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2392 , 'counts_sales' , 'date' , '2015-04-04' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2393 , 'counts_sales' , 'date' , '2015-04-05' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2394 , 'counts_sales' , 'date' , '2015-04-06' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2395 , 'counts_sales' , 'date' , '2015-04-07' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2396 , 'counts_sales' , 'date' , '2015-04-08' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2397 , 'counts_sales' , 'date' , '2015-04-09' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2398 , 'counts_sales' , 'date' , '2015-04-10' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2399 , 'counts_sales' , 'date' , '2015-04-11' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2400 , 'counts_sales' , 'date' , '2015-04-12' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2401 , 'counts_sales' , 'date' , '2015-04-13' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2402 , 'counts_sales' , 'date' , '2015-04-14' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2403 , 'counts_sales' , 'date' , '2015-04-15' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2404 , 'counts_sales' , 'date' , '2015-04-16' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2405 , 'counts_sales' , 'date' , '2015-04-17' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2406 , 'counts_sales' , 'date' , '2015-04-18' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2407 , 'counts_sales' , 'date' , '2015-04-19' , '2015-04-20 09:09:33' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2408 , 'counts_orders' , 'date' , '2015-04-20' , '2015-04-21 18:26:53' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2409 , 'counts_users' , 'date' , '2015-04-20' , '2015-04-21 18:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2410 , 'counts_sales' , 'date' , '2015-04-20' , '2015-04-21 18:26:54' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2411 , 'counts_orders' , 'date' , '2015-07-07' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2412 , 'counts_orders' , 'date' , '2015-07-08' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2413 , 'counts_orders' , 'date' , '2015-07-09' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2414 , 'counts_orders' , 'date' , '2015-07-10' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2415 , 'counts_orders' , 'date' , '2015-07-11' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2416 , 'counts_orders' , 'date' , '2015-07-12' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2417 , 'counts_orders' , 'date' , '2015-07-13' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2418 , 'counts_orders' , 'date' , '2015-07-14' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2419 , 'counts_orders' , 'date' , '2015-07-15' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2420 , 'counts_orders' , 'date' , '2015-07-16' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2421 , 'counts_orders' , 'date' , '2015-07-17' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2422 , 'counts_orders' , 'date' , '2015-07-18' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2423 , 'counts_orders' , 'date' , '2015-07-19' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2424 , 'counts_orders' , 'date' , '2015-07-20' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2425 , 'counts_orders' , 'date' , '2015-07-21' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2426 , 'counts_orders' , 'date' , '2015-07-22' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2427 , 'counts_orders' , 'date' , '2015-07-23' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2428 , 'counts_orders' , 'date' , '2015-07-24' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2429 , 'counts_orders' , 'date' , '2015-07-25' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2430 , 'counts_orders' , 'date' , '2015-07-26' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2431 , 'counts_orders' , 'date' , '2015-07-27' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2432 , 'counts_orders' , 'date' , '2015-07-28' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2433 , 'counts_orders' , 'date' , '2015-07-29' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2434 , 'counts_orders' , 'date' , '2015-07-30' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2435 , 'counts_orders' , 'date' , '2015-07-31' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2436 , 'counts_orders' , 'date' , '2015-08-01' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2437 , 'counts_orders' , 'date' , '2015-08-02' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2438 , 'counts_orders' , 'date' , '2015-08-03' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2439 , 'counts_orders' , 'date' , '2015-08-04' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2440 , 'counts_orders' , 'date' , '2015-08-05' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2441 , 'counts_sales' , 'date' , '2015-07-07' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2442 , 'counts_sales' , 'date' , '2015-07-08' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2443 , 'counts_sales' , 'date' , '2015-07-09' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2444 , 'counts_sales' , 'date' , '2015-07-10' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2445 , 'counts_sales' , 'date' , '2015-07-11' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2446 , 'counts_sales' , 'date' , '2015-07-12' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2447 , 'counts_sales' , 'date' , '2015-07-13' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2448 , 'counts_sales' , 'date' , '2015-07-14' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2449 , 'counts_sales' , 'date' , '2015-07-15' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2450 , 'counts_sales' , 'date' , '2015-07-16' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2451 , 'counts_sales' , 'date' , '2015-07-17' , '2015-08-06 17:13:23' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2452 , 'counts_sales' , 'date' , '2015-07-18' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2453 , 'counts_sales' , 'date' , '2015-07-19' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2454 , 'counts_sales' , 'date' , '2015-07-20' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2455 , 'counts_sales' , 'date' , '2015-07-21' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2456 , 'counts_sales' , 'date' , '2015-07-22' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2457 , 'counts_sales' , 'date' , '2015-07-23' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2458 , 'counts_sales' , 'date' , '2015-07-24' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2459 , 'counts_sales' , 'date' , '2015-07-25' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2460 , 'counts_sales' , 'date' , '2015-07-26' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2461 , 'counts_sales' , 'date' , '2015-07-27' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2462 , 'counts_sales' , 'date' , '2015-07-28' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2463 , 'counts_sales' , 'date' , '2015-07-29' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2464 , 'counts_sales' , 'date' , '2015-07-30' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2465 , 'counts_sales' , 'date' , '2015-07-31' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2466 , 'counts_sales' , 'date' , '2015-08-01' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2467 , 'counts_sales' , 'date' , '2015-08-02' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2468 , 'counts_sales' , 'date' , '2015-08-03' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2469 , 'counts_sales' , 'date' , '2015-08-04' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2470 , 'counts_sales' , 'date' , '2015-08-05' , '2015-08-06 17:13:24' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2471 , 'counts_users' , 'date' , '2015-07-07' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2472 , 'counts_users' , 'date' , '2015-07-08' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2473 , 'counts_users' , 'date' , '2015-07-09' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2474 , 'counts_users' , 'date' , '2015-07-10' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2475 , 'counts_users' , 'date' , '2015-07-11' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2476 , 'counts_users' , 'date' , '2015-07-12' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2477 , 'counts_users' , 'date' , '2015-07-13' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2478 , 'counts_users' , 'date' , '2015-07-14' , '2015-08-06 20:09:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2479 , 'counts_users' , 'date' , '2015-07-15' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2480 , 'counts_users' , 'date' , '2015-07-16' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2481 , 'counts_users' , 'date' , '2015-07-17' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2482 , 'counts_users' , 'date' , '2015-07-18' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2483 , 'counts_users' , 'date' , '2015-07-19' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2484 , 'counts_users' , 'date' , '2015-07-20' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2485 , 'counts_users' , 'date' , '2015-07-21' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2486 , 'counts_users' , 'date' , '2015-07-22' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2487 , 'counts_users' , 'date' , '2015-07-23' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2488 , 'counts_users' , 'date' , '2015-07-24' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2489 , 'counts_users' , 'date' , '2015-07-25' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2490 , 'counts_users' , 'date' , '2015-07-26' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2491 , 'counts_users' , 'date' , '2015-07-27' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2492 , 'counts_users' , 'date' , '2015-07-28' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2493 , 'counts_users' , 'date' , '2015-07-29' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2494 , 'counts_users' , 'date' , '2015-07-30' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2495 , 'counts_users' , 'date' , '2015-07-31' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2496 , 'counts_users' , 'date' , '2015-08-01' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2497 , 'counts_users' , 'date' , '2015-08-02' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2498 , 'counts_users' , 'date' , '2015-08-03' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2499 , 'counts_users' , 'date' , '2015-08-04' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2500 , 'counts_users' , 'date' , '2015-08-05' , '2015-08-06 20:09:44' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2501 , 'counts_users' , 'date' , '2015-08-06' , '2015-08-07 00:08:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2502 , 'counts_sales' , 'date' , '2015-08-06' , '2015-08-07 00:08:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2503 , 'counts_orders' , 'date' , '2015-08-06' , '2015-08-07 00:08:43' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2608 , 'admin.php' , 'orders' , 'yesterday' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2609 , 'admin.php' , 'orders' , 'this_week' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2610 , 'admin.php' , 'orders' , 'this_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2611 , 'admin.php' , 'orders' , 'last_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2612 , 'admin.php' , 'orders' , 'total_year' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2613 , 'admin.php' , 'sales' , 'yesterday' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2614 , 'admin.php' , 'sales' , 'this_week' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2615 , 'admin.php' , 'sales' , 'this_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2616 , 'admin.php' , 'sales' , 'last_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2617 , 'admin.php' , 'sales' , 'total_year' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2618 , 'admin.php' , 'users' , 'yesterday' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2619 , 'admin.php' , 'users' , 'this_week' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2620 , 'admin.php' , 'users' , 'this_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2621 , 'admin.php' , 'users' , 'last_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2622 , 'admin.php' , 'users' , 'total_year' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2623 , 'admin.php' , 'tickets' , 'yesterday' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2624 , 'admin.php' , 'tickets' , 'this_week' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2625 , 'admin.php' , 'tickets' , 'this_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2626 , 'admin.php' , 'tickets' , 'last_month' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2627 , 'admin.php' , 'tickets' , 'total_year' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2628 , 'counts_users' , 'date' , '2015-10-27' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2629 , 'counts_users' , 'date' , '2015-10-28' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2630 , 'counts_users' , 'date' , '2015-10-29' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2631 , 'counts_users' , 'date' , '2015-10-30' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2632 , 'counts_users' , 'date' , '2015-10-31' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2633 , 'counts_users' , 'date' , '2015-11-01' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2634 , 'counts_users' , 'date' , '2015-11-02' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2635 , 'counts_users' , 'date' , '2015-11-03' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2636 , 'counts_users' , 'date' , '2015-11-04' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2637 , 'counts_users' , 'date' , '2015-11-05' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2638 , 'counts_users' , 'date' , '2015-11-06' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2639 , 'counts_users' , 'date' , '2015-11-07' , '2015-11-24 03:15:38' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2640 , 'counts_users' , 'date' , '2015-11-08' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2641 , 'counts_users' , 'date' , '2015-11-09' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2642 , 'counts_users' , 'date' , '2015-11-10' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2643 , 'counts_users' , 'date' , '2015-11-11' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2644 , 'counts_users' , 'date' , '2015-11-12' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2645 , 'counts_users' , 'date' , '2015-11-13' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2646 , 'counts_users' , 'date' , '2015-11-14' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2647 , 'counts_users' , 'date' , '2015-11-15' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2648 , 'counts_users' , 'date' , '2015-11-16' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2649 , 'counts_users' , 'date' , '2015-11-17' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2650 , 'counts_users' , 'date' , '2015-11-18' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2651 , 'counts_users' , 'date' , '2015-11-19' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2652 , 'counts_users' , 'date' , '2015-11-20' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2653 , 'counts_users' , 'date' , '2015-11-21' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2654 , 'counts_users' , 'date' , '2015-11-22' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2655 , 'counts_users' , 'date' , '2015-11-23' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2656 , 'counts_orders' , 'date' , '2015-10-27' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2657 , 'counts_orders' , 'date' , '2015-10-28' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2658 , 'counts_orders' , 'date' , '2015-10-29' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2659 , 'counts_orders' , 'date' , '2015-10-30' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2660 , 'counts_orders' , 'date' , '2015-10-31' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2661 , 'counts_orders' , 'date' , '2015-11-01' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2662 , 'counts_orders' , 'date' , '2015-11-02' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2663 , 'counts_orders' , 'date' , '2015-11-03' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2664 , 'counts_orders' , 'date' , '2015-11-04' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2665 , 'counts_orders' , 'date' , '2015-11-05' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2666 , 'counts_orders' , 'date' , '2015-11-06' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2667 , 'counts_orders' , 'date' , '2015-11-07' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2668 , 'counts_orders' , 'date' , '2015-11-08' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2669 , 'counts_orders' , 'date' , '2015-11-09' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2670 , 'counts_orders' , 'date' , '2015-11-10' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2671 , 'counts_orders' , 'date' , '2015-11-11' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2672 , 'counts_orders' , 'date' , '2015-11-12' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2673 , 'counts_orders' , 'date' , '2015-11-13' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2674 , 'counts_orders' , 'date' , '2015-11-14' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2675 , 'counts_orders' , 'date' , '2015-11-15' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2676 , 'counts_orders' , 'date' , '2015-11-16' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2677 , 'counts_orders' , 'date' , '2015-11-17' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2678 , 'counts_orders' , 'date' , '2015-11-18' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2679 , 'counts_orders' , 'date' , '2015-11-19' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2680 , 'counts_orders' , 'date' , '2015-11-20' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2681 , 'counts_orders' , 'date' , '2015-11-21' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2682 , 'counts_orders' , 'date' , '2015-11-22' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2683 , 'counts_orders' , 'date' , '2015-11-23' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2684 , 'counts_sales' , 'date' , '2015-10-27' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2685 , 'counts_sales' , 'date' , '2015-10-28' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2686 , 'counts_sales' , 'date' , '2015-10-29' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2687 , 'counts_sales' , 'date' , '2015-10-30' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2688 , 'counts_sales' , 'date' , '2015-10-31' , '2015-11-24 03:15:39' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2689 , 'counts_sales' , 'date' , '2015-11-01' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2690 , 'counts_sales' , 'date' , '2015-11-02' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2691 , 'counts_sales' , 'date' , '2015-11-03' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2692 , 'counts_sales' , 'date' , '2015-11-04' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2693 , 'counts_sales' , 'date' , '2015-11-05' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2694 , 'counts_sales' , 'date' , '2015-11-06' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2695 , 'counts_sales' , 'date' , '2015-11-07' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2696 , 'counts_sales' , 'date' , '2015-11-08' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2697 , 'counts_sales' , 'date' , '2015-11-09' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2698 , 'counts_sales' , 'date' , '2015-11-10' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2699 , 'counts_sales' , 'date' , '2015-11-11' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2700 , 'counts_sales' , 'date' , '2015-11-12' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2701 , 'counts_sales' , 'date' , '2015-11-13' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2702 , 'counts_sales' , 'date' , '2015-11-14' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2703 , 'counts_sales' , 'date' , '2015-11-15' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2704 , 'counts_sales' , 'date' , '2015-11-16' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2705 , 'counts_sales' , 'date' , '2015-11-17' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2706 , 'counts_sales' , 'date' , '2015-11-18' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2707 , 'counts_sales' , 'date' , '2015-11-19' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2708 , 'counts_sales' , 'date' , '2015-11-20' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2709 , 'counts_sales' , 'date' , '2015-11-21' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2710 , 'counts_sales' , 'date' , '2015-11-22' , '2015-11-24 03:15:40' , '0' ) ;
INSERT INTO va_caches (`cache_id`,`cache_type`,`cache_name`,`cache_parameter`,`cache_date`,`cache_data`) VALUES (2711 , 'counts_sales' , 'date' , '2015-11-23' , '2015-11-24 03:15:40' , '0' ) ;


INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (48 , 0 , NULL , NULL , -1 , '0,' , 'Computers' , '' , 1 , 1 , 7 , 7 , 7 , 1 , 0 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Computers' , 'Demo Site | Computers: Notebooks, Desctops, ...' , 'Demo Site | Computers: Notebooks, Desctops, ...' , 7 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-08-29 08:08:34' , '2008-12-05 17:01:21' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (49 , 0 , NULL , NULL , -1 , '0,' , 'Cameras' , '' , 2 , 1 , 7 , 7 , 7 , 1 , 0 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Cameras' , 'Demo Site | Cameras: Digital Camera, Camcorders, ...' , 'Demo Site | Cameras: Digital Camera, Camcorders, ...' , 2 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-08-29 11:25:21' , '2008-12-05 17:01:31' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (50 , 0 , NULL , NULL , -1 , '0,' , 'TV & Home' , '' , 3 , 1 , 7 , 7 , 7 , 1 , 0 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | TV & Home' , 'Demo Site | TV & Home: Televisions, Home Theater, ...' , 'Demo Site | TV & Home: Televisions, Home Theater, ...' , 1 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-08-29 11:28:23' , '2008-12-05 17:01:40' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (51 , 0 , NULL , NULL , -1 , '0,' , 'MP3' , '' , 4 , 1 , 7 , 7 , 7 , 1 , 0 , 1 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | MP3' , 'Demo Site | MP3: Players, Headphones, ...' , 'Demo Site | MP3: Players, Headphones, ...' , 1 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-08-29 11:29:33' , '2008-12-05 17:01:50' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (52 , 0 , NULL , NULL , -1 , '0,' , 'Accessories' , '' , 5 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , '<br>' , '<br>' , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Accessories' , 'Demo Site | Accessories: Computers, Notebooks, Desctops, Cameras, Digital Camera, Camcorders, TV & Home, Televisions, Home Theater, ...' , 'Demo Site | Accessories: Computers, Notebooks, Desctops, Cameras, Digital Camera, Camcorders, TV & Home, Televisions, Home Theater, ...' , 2 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-08-29 11:30:20' , '2008-12-05 17:02:01' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (53 , 48 , NULL , NULL , -1 , '0,48,' , 'Notebooks' , NULL , 1 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Computers | Notebooks' , 'Demo Site | Computers | Notebooks' , 'Demo Site | Computers | Notebooks' , 4 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-08 10:55:41' , '2008-09-08 10:55:41' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (54 , 48 , NULL , NULL , -1 , '0,48,' , 'Desktops' , NULL , 2 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Computers | Desctops' , 'Demo Site | Computers | Desctops' , 'Demo Site | Computers | Desctops' , 3 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-08 10:56:32' , '2008-09-22 17:11:43' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (55 , 49 , NULL , NULL , -1 , '0,49,' , 'Digital Camera' , NULL , 1 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Cameras | Digital Camera' , 'Demo Site | Cameras | Digital Camera' , 'Demo Site | Cameras | Digital Camera' , 2 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-09 11:32:55' , '2008-09-09 11:32:55' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (56 , 49 , NULL , NULL , -1 , '0,49,' , 'Camcorders' , NULL , 2 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | Cameras | Camcorders' , 'Demo Site | Cameras | Camcorders' , 'Demo Site | Cameras | Camcorders' , 2 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-09 11:33:28' , '2008-09-09 11:33:28' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (57 , 50 , NULL , NULL , -1 , '0,50,' , 'Televisions' , NULL , 1 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | TV & Home | Televisions' , 'Demo Site | TV & Home | Televisions' , 'Demo Site | TV & Home | Televisions' , 3 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-09 17:41:29' , '2008-09-09 17:41:29' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (58 , 50 , NULL , NULL , -1 , '0,50,' , 'Home Theater' , NULL , 2 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | TV & Home | Home Theater' , 'Demo Site | TV & Home | Home Theater' , 'Demo Site | TV & Home | Home Theater' , 2 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-09 17:41:39' , '2008-09-09 17:42:00' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (59 , 51 , NULL , NULL , -1 , '0,51,' , 'Players' , NULL , 1 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | MP3 | Players' , 'Demo Site | MP3 | Players' , 'Demo Site | MP3 | Players' , 1 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-11 12:44:30' , '2008-09-11 12:44:30' ) ;
INSERT INTO va_categories (`category_id`,`parent_category_id`,`alias_category_id`,`redirect_category_id`,`google_base_type_id`,`category_path`,`category_name`,`friendly_url`,`category_order`,`sites_all`,`access_level`,`guest_access_level`,`admin_access_level`,`is_showing`,`allowed_post_subcategories`,`show_sub_products`,`short_description`,`full_description`,`image`,`image_alt`,`image_large`,`image_large_alt`,`list_class`,`list_template`,`details_template`,`table_view`,`a_title`,`meta_title`,`meta_keywords`,`meta_description`,`total_views`,`header_menu_show`,`header_menu_order`,`header_menu_class`,`nav_bar_show`,`nav_bar_order`,`nav_bar_class`,`admin_id_added_by`,`admin_id_modified_by`,`date_added`,`date_modified`) VALUES (60 , 51 , NULL , NULL , -1 , '0,51,' , 'Headphones' , NULL , 2 , 1 , 7 , 7 , 7 , 1 , 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , 'Demo Site | MP3 | Headphones' , 'Demo Site | MP3 | Headphones' , 'Demo Site | MP3 | Headphones' , 1 , 1 , NULL , NULL , 1 , NULL , NULL , 1 , 1 , '2008-09-11 12:45:09' , '2008-09-11 12:45:09' ) ;


INSERT INTO va_categories_columns (`column_id`,`category_id`,`column_order`,`column_code`,`column_title`,`column_html`) VALUES (1 , 0 , 1 , 'image|compare' , 'IMAGE_MSG' , NULL ) ;
INSERT INTO va_categories_columns (`column_id`,`category_id`,`column_order`,`column_code`,`column_title`,`column_html`) VALUES (2 , 0 , 2 , 'item_name|found_in_category|description|options' , 'PROD_NAME_MSG' , NULL ) ;
INSERT INTO va_categories_columns (`column_id`,`category_id`,`column_order`,`column_code`,`column_title`,`column_html`) VALUES (4 , 0 , 3 , 'price|sales_price|save' , 'PRICE_MSG' , NULL ) ;
INSERT INTO va_categories_columns (`column_id`,`category_id`,`column_order`,`column_code`,`column_title`,`column_html`) VALUES (7 , 0 , 4 , 'quantity|add_button' , '&nbsp;' , NULL ) ;












INSERT INTO va_change_types (`type_id`,`type_name`) VALUES (1 , 'Bug' ) ;
INSERT INTO va_change_types (`type_id`,`type_name`) VALUES (2 , 'New Feature' ) ;






INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (1 , 1 , 1 , 'language' , 'LANGUAGE_TITLE' , 'block_language.php' , NULL , NULL , NULL , 'bk-language' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (2 , 1 , 1 , 'user_profile' , 'PROFILE_TITLE' , 'block_user_profile.php' , NULL , NULL , NULL , 'bk-user-profile' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (3 , 1 , 1 , 'subscribe' , 'NEWSLETTER_SUBSRIPTION_MSG' , 'block_subscribe.php' , NULL , NULL , NULL , 'bk-subscribe' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (4 , 1 , 1 , 'login' , 'LOGIN_TITLE' , 'block_login.php' , NULL , NULL , NULL , 'bk-login' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (5 , 1 , 1 , 'login_advanced' , '{LOGIN_TITLE}: {ADVANCED_MSG}' , 'block_login_advanced.php' , NULL , NULL , NULL , 'bk-login-advanced' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (6 , 1 , 1 , 'forgot_password' , 'FORGOTTEN_PASSWORD_SETTINGS_MSG' , 'block_password_forgot.php' , NULL , NULL , NULL , 'bk-forgot-password' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (7 , 1 , 1 , 'reset_password' , 'RESET_PASSWORD_INFO_MSG' , 'block_password_reset.php' , NULL , NULL , NULL , 'bk-reset-password' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (8 , 1 , 1 , 'custom_page_body' , 'CUSTOM_PAGE_BODY_MSG' , 'block_custom_page_body.php' , NULL , NULL , NULL , 'bk-custom-page-body' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (9 , 1 , 1 , 'designs' , 'DESIGNS_MSG' , 'block_designs.php' , NULL , NULL , NULL , 'bk-designs' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (10 , 1 , 1 , 'poll' , 'POLL_TITLE' , 'block_poll.php' , NULL , NULL , NULL , 'bk-poll' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (11 , 1 , 1 , 'polls_previous_list' , 'PREVIOUS_POLLS_MSG' , 'block_polls_previous_list.php' , NULL , NULL , NULL , 'bk-polls-previous-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (12 , 1 , 1 , 'site_map' , 'SITE_MAP_TITLE' , 'block_site_map.php' , NULL , NULL , NULL , 'bk-site-map' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (13 , 1 , 1 , 'sms_test' , 'SMS_TEST_TITLE' , 'block_sms_test.php' , NULL , NULL , NULL , 'bk-sms-test' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (14 , 12 , 1 , 'user_account_breadcrumb' , '{USER_ACCOUNT_MSG}: {BREADCRUMB_MSG}' , 'block_user_account_breadcrumb.php' , NULL , NULL , NULL , 'bk-user-account-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (15 , 12 , 1 , 'user_home' , '{USER_ACCOUNT_MSG}: {USER_HOME_TITLE}' , 'block_user_home.php' , NULL , NULL , NULL , 'bk-user-home' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (16 , 1 , 1 , 'site_search_form' , '{ADMIN_SITE_MSG}: {SEARCH_TITLE}' , 'block_site_search_form.php' , NULL , NULL , NULL , 'bk-site-search-form' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (17 , 1 , 1 , 'site_search_results' , '{ADMIN_SITE_MSG}: {SEARCH_RESULTS_MSG}' , 'block_site_search_results.php' , NULL , NULL , NULL , 'bk-site-search-results' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (18 , 2 , 1 , 'products_list' , 'PRODUCTS_LIST_MSG' , 'block_products_list.php' , NULL , NULL , NULL , 'bk-products-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (19 , 2 , 1 , 'product_details' , 'PRODUCT_DETAILS_MSG' , 'block_product_details.php' , NULL , NULL , NULL , 'bk-product-details' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (20 , 2 , 1 , 'categories_list' , 'CATEGORIES_LIST_MSG' , 'block_categories_list.php' , NULL , NULL , NULL , 'bk-categories-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (21 , 2 , 1 , 'category_description' , 'CATEGORY_INFO_MSG' , 'block_category_description.php' , NULL , NULL , NULL , 'bk-category-description' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (22 , 2 , 1 , 'shopping_cart' , 'CART_TITLE' , 'block_basket.php' , NULL , NULL , NULL , 'bk-shopping-cart' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (23 , 2 , 1 , 'cart_recommended_products' , '{CART_TITLE}: {PRODUCTS_RECOMMENDED_TITLE}' , 'block_basket_recommended.php' , NULL , NULL , NULL , 'bk-cart-recommended-products' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (24 , 2 , 1 , 'mini_cart' , 'SMALL_CART_MSG' , 'block_cart.php' , NULL , NULL , NULL , 'bk-mini-cart' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (25 , 2 , 1 , 'cart_retrieve' , 'RETRIEVE_CART_BUTTON' , 'block_cart_retrieve.php' , NULL , NULL , NULL , 'bk-cart-retrieve' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (26 , 2 , 1 , 'cart_save.php' , 'SAVE_CART_BUTTON' , 'block_cart_save.php' , NULL , NULL , NULL , 'bk-cart-save.php' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (27 , 2 , 1 , 'products_search' , '{PRODUCTS_TITLE} {SEARCH_FORM_MSG}' , 'block_search.php' , NULL , NULL , NULL , 'bk-products-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (28 , 2 , 1 , 'products_advanced_search' , 'PRODUCTS_SEARCH_ADVANCED_MSG' , 'block_products_search_advanced.php' , NULL , NULL , NULL , 'bk-products-advanced-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (29 , 2 , 1 , 'manufacturers_list' , 'MANUFACTURERS_TITLE' , 'block_manufacturers.php' , NULL , NULL , NULL , 'bk-manufacturers-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (30 , 2 , 1 , 'manufacturer_info' , 'MANUFACTURER_INFO_MSG' , 'block_manufacturer_info.php' , NULL , NULL , NULL , 'bk-manufacturer-info' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (31 , 2 , 1 , 'merchants_list' , 'MERCHANTS_TITLE' , 'block_merchants.php' , NULL , NULL , NULL , 'bk-merchants-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (32 , 2 , 1 , 'merchant_info' , 'MERCHANT_INFO_MSG' , 'block_merchant_info.php' , NULL , NULL , NULL , 'bk-merchant-info' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (33 , 2 , 1 , 'merchant_contact' , 'CONTACT_MERCHANT_TITLE' , 'block_merchant_contact.php' , NULL , NULL , NULL , 'bk-merchant-contact' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (34 , 2 , 1 , 'products_offers' , 'SPECIAL_OFFER_MSG' , 'block_offers.php' , NULL , NULL , NULL , 'bk-products-offers' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (35 , 2 , 1 , 'products_breadcrumb' , '{PRODUCTS_TITLE} {BREADCRUMB_MSG}' , 'block_products_breadcrumb.php' , NULL , NULL , NULL , 'bk-products-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (36 , 2 , 1 , 'products_changes_log' , 'CHANGES_LOG_TITLE' , 'block_products_changes_log.php' , NULL , NULL , NULL , 'bk-products-changes-log' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (37 , 2 , 1 , 'products_compare' , 'PRODUCTS_COMPARE_RESULTS_MSG' , 'block_products_compare.php' , NULL , NULL , NULL , 'bk-products-compare' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (38 , 2 , 1 , 'products_fast_add' , 'FAST_PRODUCT_ADDING_MSG' , 'block_products_fast_add.php' , NULL , NULL , NULL , 'bk-products-fast-add' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (39 , 2 , 1 , 'products_latest' , '{PRODUCTS_TITLE} {LATEST_TITLE}' , 'block_products_latest.php' , NULL , NULL , NULL , 'bk-products-latest' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (40 , 2 , 1 , 'products_options' , 'PRODUCT_OPTIONS_MSG' , 'block_product_options.php' , NULL , NULL , NULL , 'bk-products-options' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (41 , 2 , 1 , 'products_recently_viewed' , '{PRODUCTS_TITLE} {RECENTLY_VIEWED_MSG}' , 'block_products_recently.php' , NULL , NULL , NULL , 'bk-products-recently-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (42 , 2 , 1 , 'products_recommended' , '{REGISTERED_CUSTOMERS_MSG}: {PRODUCTS_RECOMMENDED_TITLE}' , 'block_products_recommended.php' , NULL , NULL , NULL , 'bk-products-recommended' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (43 , 2 , 1 , 'products_releases' , '{PRODUCTS_TITLE} {RELEASES_TITLE}' , 'block_products_releases.php' , NULL , NULL , NULL , 'bk-products-releases' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (44 , 2 , 1 , 'products_releases_hot' , '{PRODUCTS_TITLE} {HOT_RELEASES_MSG}' , 'block_products_releases_hot.php' , NULL , NULL , NULL , 'bk-products-releases-hot' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (45 , 2 , 1 , 'products_top_sellers' , 'TOP_SELLERS_TITLE' , 'block_products_top_sellers.php' , NULL , NULL , NULL , 'bk-products-top-sellers' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (46 , 2 , 1 , 'products_top_viewed' , 'TOP_VIEWED_TITLE' , 'block_products_top_viewed.php' , NULL , NULL , NULL , 'bk-products-top-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (47 , 2 , 1 , 'products_top_rated' , 'TOP_RATED_TITLE' , 'block_products_top_rated.php' , NULL , NULL , NULL , 'bk-products-top-rated' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (48 , 2 , 1 , 'products_related' , '{PRODUCTS_TITLE} {RELATED_MSG}' , 'block_products_related.php' , NULL , NULL , NULL , 'bk-products-related' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (49 , 2 , 1 , 'products_related_purchase' , 'WHO_BOUGHT_THIS_SHORT_MSG' , 'block_products_related_purchase.php' , NULL , NULL , NULL , 'bk-products-related-purchase' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (50 , 2 , 1 , 'checkout_breadcrumb' , '{ADMIN_CHECKOUT_MSG} {BREADCRUMB_MSG}' , 'block_checkout_breadcrumb.php' , NULL , NULL , NULL , 'bk-checkout-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (51 , 2 , 1 , 'checkout_final' , 'FINAL_CHECKOUT_MSG' , 'block_checkout_final.php' , NULL , NULL , NULL , 'bk-checkout-final' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (52 , 2 , 1 , 'checkout_login' , 'CHECKOUT_LOGIN_TITLE' , 'block_checkout_login.php' , NULL , NULL , NULL , 'bk-checkout-login' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (53 , 2 , 1 , 'order_cart' , 'ORDER_CART_MSG' , 'block_order_cart.php' , NULL , NULL , NULL , 'bk-order-cart' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (54 , 2 , 1 , 'order_form' , 'ORDER_FORM_MSG' , 'block_order_info.php' , NULL , NULL , NULL , 'bk-order-form' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (55 , 2 , 1 , 'order_preview' , 'ORDER_PREVIEW_MSG' , 'block_order_data_preview.php' , NULL , NULL , NULL , 'bk-order-preview' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (56 , 2 , 1 , 'order_payment_details' , 'PAYMENT_DETAILS_MSG' , 'block_order_payment_form.php' , NULL , NULL , NULL , 'bk-order-payment-details' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (57 , 2 , 1 , 'coupon_form' , 'COUPON_INFO_MSG' , 'block_coupon_form.php' , NULL , NULL , NULL , 'bk-coupon-form' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (58 , 2 , 1 , 'currencies_list' , 'CURRENCIES_MSG' , 'block_currency.php' , NULL , NULL , NULL , 'bk-currencies-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (59 , 2 , 1 , 'subscriptions' , 'SUBSCRIPTIONS_MSG' , 'block_subscriptions.php' , NULL , NULL , NULL , 'bk-subscriptions' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (60 , 2 , 1 , 'subscriptions_breadcrumb' , '{SUBSCRIPTIONS_MSG}: {BREADCRUMB_MSG}' , 'block_subscriptions_breadcrumb.php' , NULL , NULL , NULL , 'bk-subscriptions-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (61 , 2 , 1 , 'users_bought_item' , 'CUSTOMERS_LIST_BOUGHT_ITEM_TITLE' , 'block_products_users_bought.php' , NULL , NULL , NULL , 'bk-users-bought-item' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (62 , 2 , 1 , 'wishlist_items' , 'WISHLIST_ITEMS_SETTINGS_MSG' , 'block_wishlist_items.php' , NULL , NULL , NULL , 'bk-wishlist-items' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (63 , 2 , 1 , 'wishlist_search' , '{WISHLIST_MSG}: {SEARCH_TITLE}' , 'block_wishlist_search.php' , NULL , NULL , NULL , 'bk-wishlist-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (64 , 2 , 1 , 'product_related_articles' , 'RELATED_ARTICLES_MSG' , 'block_articles_related.php' , NULL , NULL , NULL , 'bk-product-related-articles' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (65 , 2 , 1 , 'product_related_forums' , 'RELATED_FORUMS_MSG' , 'block_forums_related.php' , NULL , NULL , NULL , 'bk-product-related-forums' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (66 , 3 , 1 , 'articles_breadcrumb' , 'BREADCRUMB_MSG' , 'block_articles_breadcrumb.php' , NULL , NULL , NULL , 'bk-articles-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (67 , 3 , 1 , 'articles_list' , 'ARTICLES_LIST_MSG' , 'block_articles_list.php' , NULL , NULL , NULL , 'bk-articles-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (68 , 3 , 1 , 'article_details' , 'ARTICLE_MSG' , 'block_articles_details.php' , NULL , NULL , NULL , 'bk-article-details' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (69 , 3 , 1 , 'articles_categories' , 'CATEGORIES_LIST_MSG' , 'block_articles_categories.php' , NULL , NULL , NULL , 'bk-articles-categories' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (70 , 3 , 1 , 'articles_category_description' , 'CATEGORY_INFO_MSG' , 'block_articles_category.php' , NULL , NULL , NULL , 'bk-articles-category-description' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (71 , 3 , 1 , 'articles_content' , 'CONTENT_TITLE' , 'block_articles_content.php' , NULL , NULL , NULL , 'bk-articles-content' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (72 , 3 , 1 , 'articles_hot' , 'HOT_TITLE' , 'block_articles_hot.php' , NULL , NULL , NULL , 'bk-articles-hot' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (73 , 3 , 1 , 'articles_related' , 'RELATED_ARTICLES_MSG' , 'block_articles_related.php' , NULL , NULL , NULL , 'bk-articles-related' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (74 , 3 , 1 , 'articles_related_forums' , 'RELATED_FORUMS_MSG' , 'block_forums_related.php' , NULL , NULL , NULL , 'bk-articles-related-forums' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (75 , 3 , 1 , 'articles_related_products' , 'ARTICLE_RELATED_PRODUCTS_TITLE' , 'block_products_related.php' , NULL , NULL , NULL , 'bk-articles-related-products' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (76 , 3 , 1 , 'articles_category_products_relat' , 'CATEGORY_RELATED_PRODUCTS_TITLE' , 'block_products_related.php' , NULL , NULL , NULL , 'bk-articles-category-products-relat' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (77 , 3 , 1 , 'articles_latest' , 'LATEST_TITLE' , 'block_articles_latest.php' , NULL , NULL , NULL , 'bk-articles-latest' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (78 , 3 , 1 , 'articles_search' , 'SEARCH_TITLE' , 'block_articles_search.php' , NULL , NULL , NULL , 'bk-articles-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (79 , 3 , 1 , 'articles_top_rated' , 'TOP_RATED_TITLE' , 'block_articles_top_rated.php' , NULL , NULL , NULL , 'bk-articles-top-rated' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (80 , 3 , 1 , 'articles_top_viewed' , 'TOP_VIEWED_TITLE' , 'block_articles_top_viewed.php' , NULL , NULL , NULL , 'bk-articles-top-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (81 , 4 , 1 , 'ticket_new' , 'SUBMIT_TICKET_MSG' , 'block_support.php' , NULL , NULL , NULL , 'bk-ticket-new' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (82 , 4 , 1 , 'ticket_reply' , 'REPLYING_TICKETS_MSG' , 'block_support_reply.php' , NULL , NULL , NULL , 'bk-ticket-reply' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (83 , 5 , 1 , 'forum_breadcrumb' , 'BREADCRUMB_MSG' , 'block_forum_breadcrumb.php' , NULL , NULL , NULL , 'bk-forum-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (84 , 5 , 1 , 'forum_list' , 'FORUMS_LIST_PAGE_MSG' , 'block_forum_list.php' , NULL , NULL , NULL , 'bk-forum-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (85 , 5 , 1 , 'forum_description' , 'DESCRIPTION_MSG' , 'block_forum_description.php' , NULL , NULL , NULL , 'bk-forum-description' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (86 , 5 , 1 , 'forum_topics' , 'TOPICS_LIST_MSG' , 'block_forum_topics.php' , NULL , NULL , NULL , 'bk-forum-topics' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (87 , 5 , 1 , 'forum_topic' , 'FORUM_TOPICS_THREAD_MSG' , 'block_forum_topic.php' , NULL , NULL , NULL , 'bk-forum-topic' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (88 , 5 , 1 , 'forum_top_viewed' , 'TOP_VIEWED_TITLE' , 'block_forum_top_viewed.php' , NULL , NULL , NULL , 'bk-forum-top-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (89 , 5 , 1 , 'forum_latest' , 'LATEST_TITLE' , 'block_forum_latest.php' , NULL , NULL , NULL , 'bk-forum-latest' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (90 , 5 , 1 , 'forum_related_articles' , 'RELATED_ARTICLES_MSG' , 'block_articles_related.php' , NULL , NULL , NULL , 'bk-forum-related-articles' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (91 , 5 , 1 , 'forum_related_products' , 'RELATED_PRODUCTS_TITLE' , 'block_products_related.php' , NULL , NULL , NULL , 'bk-forum-related-products' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (92 , 5 , 1 , 'forum_search' , 'SEARCH_TITLE' , 'block_forum_search.php' , NULL , NULL , NULL , 'bk-forum-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (93 , 6 , 1 , 'ads_breadcrumb' , 'BREADCRUMB_MSG' , 'block_ads_breadcrumb.php' , NULL , NULL , NULL , 'bk-ads-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (94 , 6 , 1 , 'ads_categories' , 'CATEGORIES_LIST_MSG' , 'block_ads_categories.php' , NULL , NULL , NULL , 'bk-ads-categories' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (95 , 6 , 1 , 'ads_category_info' , 'CATEGORY_INFO_MSG' , 'block_ads_category.php' , NULL , NULL , NULL , 'bk-ads-category-info' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (96 , 6 , 1 , 'ads_list' , 'ADS_LISTING_MSG' , 'block_ads_list.php' , NULL , NULL , NULL , 'bk-ads-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (97 , 6 , 1 , 'ads_details' , 'ADS_DETAILS_MSG' , 'block_ads_details.php' , NULL , NULL , NULL , 'bk-ads-details' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (98 , 6 , 1 , 'ads_compare' , 'PRODUCTS_COMPARE_RESULTS_MSG' , 'block_ads_compare.php' , NULL , NULL , NULL , 'bk-ads-compare' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (99 , 6 , 1 , 'ads_add' , 'NEW_AD_MSG' , 'block_ads_add.php' , NULL , NULL , NULL , 'bk-ads-add' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (100 , 6 , 1 , 'ads_hot' , 'HOT_OFFERS_MSG' , 'block_ads_hot.php' , NULL , NULL , NULL , 'bk-ads-hot' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (101 , 6 , 1 , 'ads_special' , 'SPECIAL_OFFER_MSG' , 'block_ads_special.php' , NULL , NULL , NULL , 'bk-ads-special' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (102 , 6 , 1 , 'ads_latest' , 'LATEST_TITLE' , 'block_ads_latest.php' , NULL , NULL , NULL , 'bk-ads-latest' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (103 , 6 , 1 , 'ads_top_viewed' , 'TOP_VIEWED_TITLE' , 'block_ads_top_viewed.php' , NULL , NULL , NULL , 'bk-ads-top-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (104 , 6 , 1 , 'ads_recently_viewed' , 'RECENTLY_VIEWED_MSG' , 'block_ads_recently.php' , NULL , NULL , NULL , 'bk-ads-recently-viewed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (105 , 6 , 1 , 'ads_sellers' , 'SELLERS_MSG' , 'block_ads_sellers.php' , NULL , NULL , NULL , 'bk-ads-sellers' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (106 , 6 , 1 , 'ads_search' , 'SEARCH_FORM_MSG' , 'block_ads_search.php' , NULL , NULL , NULL , 'bk-ads-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (107 , 6 , 1 , 'ads_search_advanced' , 'ADVANCED_SEARCH_TITLE' , 'block_ads_search_advanced.php' , NULL , NULL , NULL , 'bk-ads-search-advanced' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (108 , 7 , 1 , 'manuals_breadcrumb' , 'BREADCRUMB_MSG' , 'block_manuals_breadcrumb.php' , NULL , NULL , NULL , 'bk-manuals-breadcrumb' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (109 , 7 , 1 , 'manuals_list' , 'MANUAL_LIST_MSG' , 'block_manuals_list.php' , NULL , NULL , NULL , 'bk-manuals-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (110 , 7 , 1 , 'manuals_articles' , 'MANUAL_ARTICLES_MSG' , 'block_manuals_articles.php' , NULL , NULL , NULL , 'bk-manuals-articles' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (111 , 7 , 1 , 'manuals_article_details' , 'MANUAL_ARTICLE_DETAILS_MSG' , 'block_manuals_article_details.php' , NULL , NULL , NULL , 'bk-manuals-article-details' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (112 , 7 , 1 , 'manuals_search' , 'SEARCH_TITLE' , 'block_manuals_search.php' , NULL , NULL , NULL , 'bk-manuals-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (113 , 7 , 1 , 'manuals_search_results' , 'MANUAL_SEARCH_RESULTS_MSG' , 'block_manuals_search_results.php' , NULL , NULL , NULL , 'bk-manuals-search-results' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (114 , 8 , 1 , 'filter' , '{filter_name}' , 'block_filter.php' , NULL , NULL , NULL , 'bk-filter' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (115 , 9 , 1 , 'custom_block' , '{block_name}' , 'block_custom.php' , NULL , NULL , NULL , 'bk-custom-block' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (116 , 10 , 1 , 'navigation' , '{menu_title}' , 'block_navigation.php' , NULL , NULL , NULL , 'bk-navigation' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (117 , 11 , 1 , 'banners' , '{group_name}' , 'block_banners.php' , NULL , NULL , NULL , 'bk-banners' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (118 , 1 , 1 , 'header' , 'HEADER_MSG' , 'header.php' , NULL , NULL , NULL , 'bk-header' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (119 , 1 , 1 , 'footer' , 'FOOTER_MSG' , 'footer.php' , NULL , NULL , NULL , 'bk-footer' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (120 , 2 , 1 , 'product_reviews' , 'PRODUCTS_REVIEWS_MSG' , 'block_reviews.php' , NULL , NULL , NULL , 'bk-product-reviews' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (121 , 3 , 1 , 'article_reviews' , 'ARTICLES_REVIEWS_MSG' , 'block_articles_reviews.php' , NULL , NULL , NULL , 'bk-article-reviews' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (122 , 1 , 1 , 'download' , 'DOWNLOAD_TITLE' , 'block_download.php' , NULL , NULL , NULL , 'bk-download' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (123 , 5 , 1 , 'forum_topic_new' , 'NEW_TOPIC_MSG' , 'block_forum_topic_new.php' , NULL , NULL , NULL , 'bk-forum-topic-new' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (124 , 12 , 1 , 'user_account_profile' , 'PROFILE_TITLE' , 'block_user_profile.php' , NULL , NULL , NULL , 'bk-user-account-profile' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (125 , 12 , 1 , 'user_change_password' , 'CHANGE_PASSWORD_MSG' , 'block_user_change_password.php' , NULL , NULL , NULL , 'bk-user-change-password' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (126 , 12 , 1 , 'user_change_type' , 'UPGRADE_DOWNGRADE_MSG' , 'block_user_change_type.php' , NULL , NULL , NULL , 'bk-user-change-type' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (127 , 12 , 1 , 'user_carts' , 'MY_SAVED_CARTS_MSG' , 'block_user_carts.php' , NULL , NULL , NULL , 'bk-user-carts' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (128 , 12 , 1 , 'user_wishlist' , 'MY_WISHLIST_MSG' , 'block_user_wishlist.php' , NULL , NULL , NULL , 'bk-user-wishlist' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (129 , 12 , 1 , 'user_orders' , '{MY_ORDERS_MSG}: {LIST_MSG}' , 'block_user_orders.php' , NULL , NULL , NULL , 'bk-user-orders' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (130 , 12 , 1 , 'user_order' , '{MY_ORDERS_MSG}: {VIEW_DETAILS_MSG}' , 'block_user_order.php' , NULL , NULL , NULL , 'bk-user-order' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (131 , 12 , 1 , 'user_order_update' , '{MY_ORDERS_MSG}:  {EDIT_MSG}' , 'block_user_order_update.php' , NULL , NULL , NULL , 'bk-user-order-update' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (132 , 12 , 1 , 'user_support' , 'MY_SUPPORT_ISSUES_MSG' , 'block_user_support.php' , NULL , NULL , NULL , 'bk-user-support' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (133 , 12 , 1 , 'user_ads' , '{MY_ADS_MSG}: {LIST_MSG}' , 'block_user_ads.php' , NULL , NULL , NULL , 'bk-user-ads' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (134 , 12 , 1 , 'user_ad' , '{MY_ADS_MSG}: {EDIT_MSG}' , 'block_user_ad.php' , NULL , NULL , NULL , 'bk-user-ad' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (135 , 12 , 1 , 'user_affiliate_sales' , 'AFFILIATE_SALES_MSG' , 'block_user_affiliate_sales.php' , NULL , NULL , NULL , 'bk-user-affiliate-sales' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (136 , 12 , 1 , 'user_affiliate_items' , '{AFFILIATE_SALES_MSG}: {PRODUCTS_LIST_MSG}' , 'block_user_affiliate_items.php' , NULL , NULL , NULL , 'bk-user-affiliate-items' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (137 , 12 , 1 , 'user_products' , '{MY_PRODUCTS_MSG}: {LIST_MSG}' , 'block_user_products.php' , NULL , NULL , NULL , 'bk-user-products' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (138 , 12 , 1 , 'user_product' , '{MY_PRODUCTS_MSG}: {EDIT_MSG}' , 'block_user_product.php' , NULL , NULL , NULL , 'bk-user-product' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (139 , 12 , 1 , 'user_product_options' , '{OPTIONS_AND_COMPONENTS_MSG}: {LIST_MSG}' , 'block_user_product_options.php' , NULL , NULL , NULL , 'bk-user-product-options' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (140 , 12 , 1 , 'user_product_option' , '{OPTIONS_AND_COMPONENTS_MSG}: {EDIT_OPTION_MSG}' , 'block_user_product_option.php' , NULL , NULL , NULL , 'bk-user-product-option' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (141 , 12 , 1 , 'user_product_subcomponent' , '{OPTIONS_AND_COMPONENTS_MSG}: {EDIT_SUBCOMP_MSG}' , 'block_user_product_subcomponent.php' , NULL , NULL , NULL , 'bk-user-product-subcomponent' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (142 , 12 , 1 , 'user_product_subcomponents' , '{OPTIONS_AND_COMPONENTS_MSG}: {EDIT_SUBCOMP_SELECTION_MSG}' , 'block_user_product_subcomponents.php' , NULL , NULL , NULL , 'bk-user-product-subcomponents' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (143 , 12 , 1 , 'user_payments' , '{COMMISSION_PAYMENTS_MSG}: {LIST_MSG}' , 'block_user_payments.php' , NULL , NULL , NULL , 'bk-user-payments' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (144 , 12 , 1 , 'user_payment' , '{COMMISSION_PAYMENTS_MSG}: {VIEW_DETAILS_MSG}' , 'block_user_payment.php' , NULL , NULL , NULL , 'bk-user-payment' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (145 , 12 , 1 , 'user_merchant_orders' , '{MY_SALES_ORDERS_MSG}: {LIST_MSG}' , 'block_user_merchant_orders.php' , NULL , NULL , NULL , 'bk-user-merchant-orders' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (146 , 12 , 1 , 'user_merchant_order' , '{MY_SALES_ORDERS_MSG}: {VIEW_DETAILS_MSG}' , 'block_user_merchant_order.php' , NULL , NULL , NULL , 'bk-user-merchant-order' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (147 , 12 , 1 , 'user_merchant_sales' , 'MERCHANT_SALES_MSG' , 'block_user_merchant_sales.php' , NULL , NULL , NULL , 'bk-user-merchant-sales' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (148 , 12 , 1 , 'user_merchant_items' , '{MERCHANT_SALES_MSG}: {PRODUCTS_LIST_MSG}' , 'block_user_merchant_items.php' , NULL , NULL , NULL , 'bk-user-merchant-items' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (149 , 12 , 1 , 'user_reminders' , '{MY_REMINDERS_MSG}: {LIST_MSG}' , 'block_user_reminders.php' , NULL , NULL , NULL , 'bk-user-reminders' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (150 , 12 , 1 , 'user_reminder' , '{MY_REMINDERS_MSG}: {EDIT_MSG}' , 'block_user_reminder.php' , NULL , NULL , NULL , 'bk-user-reminder' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (151 , 12 , 1 , 'user_psd_list' , '{PAYMENT_DETAILS_MSG}: {LIST_MSG}' , 'block_user_psd_list.php' , NULL , NULL , NULL , 'bk-user-psd-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (152 , 12 , 1 , 'user_psd_update' , '{PAYMENT_DETAILS_MSG}: {EDIT_MSG}' , 'block_user_psd_update.php' , NULL , NULL , NULL , 'bk-user-psd-update' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (153 , 12 , 1 , 'user_product_registrations' , 'MY_PRODUCT_REGISTRATIONS_MSG' , 'block_user_product_registrations.php' , NULL , NULL , NULL , 'bk-user-product-registrations' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (154 , 12 , 1 , 'user_product_registration' , 'REGISTER_PRODUCT_MSG' , 'block_user_product_registration.php' , NULL , NULL , NULL , 'bk-user-product-registration' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (155 , 1 , 1 , 'contact_us' , 'CONTACT_US_TITLE' , 'block_contact_us.php' , NULL , NULL , NULL , 'bk-contact-us' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (156 , 13 , 1 , 'sliders' , '{slider_name}' , 'block_sliders.php' , NULL , NULL , NULL , 'bk-sliders' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (157 , 1 , 1 , 'unsubscribe' , 'UNSUBSCRIBE_TITLE' , 'block_unsubscribe.php' , NULL , NULL , NULL , 'bk-unsubscribe' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (158 , 14 , 1 , 'facebook_feed' , 'Facebook Feed' , 'block_facebook_feed.php' , NULL , NULL , NULL , 'bk-facebook-feed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (159 , 14 , 1 , 'twitter_feed' , 'Twitter Feed' , 'block_twitter_feed.php' , NULL , NULL , NULL , 'bk-twitter-feed' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (160 , 12 , 1 , 'user_addresses' , '{MY_ADDRESSES_MSG}: {LIST_MSG}' , 'block_user_addresses.php' , NULL , NULL , NULL , 'bk-user-addresses' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (161 , 12 , 1 , 'user_address' , '{MY_ADDRESSES_MSG}: {EDIT_MSG}' , 'block_user_address.php' , NULL , NULL , NULL , 'bk-user-address' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (162 , 1 , 1 , 'site_navigation' , 'SITE_NAVIGATION_MSG' , 'block_site_navigation.php' , NULL , NULL , NULL , 'bk-site-navigation' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (163 , 1 , 1 , 'cookies_control' , 'COOKIE_CONTROL_MSG' , 'block_cookies_control.php' , NULL , NULL , NULL , 'bk-cookies-control' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (164 , 2 , 1 , 'friend_form' , 'FRIEND_AFFILIATE_FORM_MSG' , 'block_friend_form.php' , NULL , NULL , NULL , 'bk-friend-form' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (165 , 4 , 1 , 'support_live' , 'SUPPORT_LIVE_MSG' , 'block_support_live.php' , NULL , NULL , NULL , 'bk-support-live' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (166 , 12 , 1 , 'user_messages' , 'MY_MESSAGES_MSG' , 'block_user_messages.php' , NULL , NULL , NULL , 'bk-user-messages' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (167 , 15 , 1 , 'profiles_search' , 'SEARCH_FORM_MSG' , 'block_profiles_search.php' , NULL , NULL , NULL , 'bk-profiles-search' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (168 , 15 , 2 , 'profiles_list' , '{PROFILES_TITLE}: {LIST_MSG}' , 'block_profiles_list.php' , NULL , NULL , NULL , 'bk-profiles-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (169 , 15 , 3 , 'profiles_view' , '{PROFILES_TITLE}: {VIEW_MSG}' , 'block_profiles_view.php' , NULL , NULL , NULL , 'bk-profiles-view' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (170 , 15 , 4 , 'profiles_user_list' , '{MY_PROFILES_MSG}: {LIST_MSG}' , 'block_profiles_user_list.php' , NULL , NULL , NULL , 'bk-profiles-user-list' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (171 , 15 , 5 , 'profiles_user_edit' , '{MY_PROFILES_MSG}: {EDIT_MSG}' , 'block_profiles_user_edit.php' , NULL , NULL , NULL , 'bk-profiles-user-edit' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (172 , 1 , 1 , 'navigation_bar' , 'NAVIGATION_BAR_MSG' , 'block_navigation_bar.php' , NULL , NULL , NULL , 'bk-navigation-bar' , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (173 , 3 , 1 , 'articles_random' , 'RANDOM_TITLE' , 'block_articles_random.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (174 , 16 , 1 , 'authors_list' , '{AUTHORS_MSG}: {LIST_MSG}' , 'block_authors_list.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (175 , 16 , 2 , 'author_details' , '{AUTHOR_MSG}: {DETAILED_DESCRIPTION_MSG}' , 'block_author_details.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (176 , 16 , 3 , 'author_articles' , '{AUTHOR_MSG}: {ARTICLES_TITLE}' , 'block_author_articles.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (177 , 16 , 1 , 'albums_list' , '{ALBUMS_MSG}: {LIST_MSG}' , 'block_albums_list.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (178 , 16 , 2 , 'album_details' , '{ALBUM_MSG}: {DETAILED_DESCRIPTION_MSG}' , 'block_album_details.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (179 , 16 , 3 , 'album_articles' , '{ALBUM_MSG}: {ARTICLES_TITLE}' , 'block_album_articles.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;
INSERT INTO va_cms_blocks (`block_id`,`module_id`,`block_order`,`block_code`,`block_name`,`php_script`,`layout_type`,`layout_template`,`html_template`,`css_class`,`block_title`,`pages_all`) VALUES (180 , 16 , 1 , 'author_breadcrumb' , '{AUTHOR_MSG}: {BREADCRUMB_MSG}' , 'block_author_breadcrumb.php' , NULL , NULL , NULL , NULL , NULL , 1 ) ;






INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (1 , 1 , 1 , 'SELECT_TYPE_MSG' , 'RADIOBUTTON' , NULL , NULL , 'language_selection' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , '<br>' , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (2 , 9 , 1 , 'SELECT_TYPE_MSG' , 'RADIOBUTTON' , NULL , NULL , 'design_selection' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , '<br>' , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (3 , 13 , 1 , 'ORIGINATOR_MSG' , 'TEXTBOX' , NULL , NULL , 'sms_originator' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (4 , 13 , 2 , 'SMS_TEST_MESSAGE_MSG' , 'TEXTAREA' , NULL , NULL , 'sms_test_message' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (5 , 18 , 1 , 'RECORDS_PER_PAGE_MSG' , 'TEXTBOX' , NULL , NULL , 'products_per_page' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (6 , 18 , 2 , 'NUMBER_OF_COLUMNS_MSG' , 'TEXTBOX' , NULL , NULL , 'products_columns' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (7 , 18 , 3 , 'NAVIGATOR_SORTING_SETTINGS_MSG' , 'LISTBOX' , NULL , NULL , 'products_nav_type' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (8 , 18 , 4 , 'NAVIGATOR_FIRST_LAST_PAGES_MSG' , 'CHECKBOX' , NULL , NULL , 'products_nav_first_last' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (9 , 18 , 5 , 'NAVIGATOR_PREV_NEXT_PAGES_MSG' , 'CHECKBOX' , NULL , NULL , 'products_nav_prev_next' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (10 , 18 , 6 , 'NUMBER_OF_PAGES_NAVIGATOR_MSG' , 'TEXTBOX' , NULL , NULL , 'products_nav_pages' , '5' , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (11 , 18 , 7 , 'SHOW_PRODUCTS_SORTING_MSG' , 'CHECKBOX' , NULL , NULL , 'products_sortings' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (12 , 18 , 8 , 'GROUP_PRODUCTS_BY_CATEGORIES_MSG' , 'CHECKBOX' , NULL , NULL , 'products_group_by_cats' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (13 , 18 , 9 , 'DEFAULT_VIEW_TYPE_MSG' , 'LISTBOX' , NULL , NULL , 'products_default_view' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (15 , 19 , 2 , 'SHOW_SUPER_IMAGE_MSG' , 'LISTBOX' , NULL , NULL , 'show_super_image' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (16 , 19 , 3 , 'MANUFACTURER_IMAGE_MSG' , 'LISTBOX' , NULL , NULL , 'show_manufacturer_image' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (17 , 20 , 1 , 'CATEGORIES_TYPE_VIEW_MSG' , 'LISTBOX' , NULL , NULL , 'categories_type' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (18 , 20 , 2 , 'NUMBER_OF_COLUMNS_MSG' , 'TEXTBOX' , NULL , NULL , 'categories_columns' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (19 , 20 , 3 , 'NUMBER_OF_SHOWN_SUBS_MSG' , 'TEXTBOX' , 17 , 20 , 'categories_subs' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (20 , 20 , 4 , 'IMAGE_TYPE_FOR_TOP_CAT_MSG' , 'LISTBOX' , NULL , NULL , 'categories_image' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (21 , 21 , 1 , 'IMAGE_MSG' , 'LISTBOX' , NULL , NULL , 'category_description_image' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (22 , 21 , 2 , 'DESCRIPTION_MSG' , 'LISTBOX' , NULL , NULL , 'category_description_type' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (23 , 22 , 1 , 'IMAGE_TYPE_MSG' , 'LISTBOX' , NULL , NULL , 'image_type' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (25 , 29 , 1 , 'SELECT_TYPE_MSG' , 'RADIOBUTTON' , NULL , NULL , 'manufacturers_selection' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (26 , 29 , 2 , 'IMAGE_TYPE_MSG' , 'LISTBOX' , NULL , NULL , 'manufacturers_image' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (27 , 29 , 3 , 'DESCRIPTION_MSG' , 'LISTBOX' , NULL , NULL , 'manufacturers_desc' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclick_code`) VALUES (28 , 29 , 4 , 'SORT_ORDER_MSG' , 'LISTBOX' , NULL , NULL , 'manufacturers_order' , NULL , 0 , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL , NULL ) ;
INSERT INTO va_cms_blocks_properties (`property_id`,`block_id`,`property_order`,`property_name`,`control_type`,`parent_property_id`,`parent_value_id`,`variable_name`,`default_value`,`required`,`property_class`,`property_style`,`control_style`,`start_html`,`middle_html`,`before_control_html`,`after_control_html`,`end_html`,`control_code`,`onchange_code`,`onclic