<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  db_query.php                                             ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/


class VA_Query
{  
	static function prepare_sql(&$sql_data) 
	{
		if (!is_array($sql_data) && $sql_data) {
			$sql_data = array("where" => $sql_data);
		}
		if (isset($sql_data["order"])) {
			$sql_order = $sql_data["order"];
			if (!is_array($sql_order)) {
				$sql_data["order"] = preg_replace("/\s*order\s+by\s*/i", "", $sql_order);
			}
		}
		// check parameters and convert to arrays
		$params = array ("select", "from", "where", "join", "group", "distinct", "order");
		foreach ($params as $param_name) {
			if (isset($sql_data[$param_name])) {
				$param_value = $sql_data[$param_name];
				if (!is_array($param_value)) { 
					$param_value = trim($param_value);
					$sql_data[$param_name] = strlen($param_value) ? array($param_value) : array(); 
				}
			} else {
				$sql_data[$param_name] = array();
			}
		}
	}

	static function build_sql($sql_data) 
	{
		$sql_select = " SELECT " . implode(", ", $sql_data["select"]);
		$sql_brackets = ""; $sql_join = "";
		foreach ($sql_data["join"] as $join_value) {
			$sql_brackets .= "(";
			$sql_join .= " ".$join_value ." )";
		}
		$sql_from = " FROM ".$sql_brackets.implode(",", $sql_data["from"]).$sql_join;
		$sql_where = count($sql_data["where"]) ? " WHERE " . implode(" AND ", $sql_data["where"]) : "";
		$sql_group = count($sql_data["group"]) ? " GROUP BY " . implode(", ", $sql_data["group"]) : "";
		$sql_order = count($sql_data["order"]) ? " ORDER BY " . implode(", ", $sql_data["order"]) : "";
		$sql = $sql_select . $sql_from . $sql_where . $sql_group . $sql_order;
		return $sql;
	}
}

?>