<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  file_functions.php                                       ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/


function unique_filename($file_path_original)
{
	$file_path = $file_path_original;
	$file_index = 0;
	while (file_exists($file_path)) {
		$file_index++;
		$delimiter_pos = strrpos($file_path_original, ".");
		// check slash position
		$slash_pos = strrpos($file_path_original, "/");
		$back_slash_pos = strrpos($file_path_original, "\\");
		if($delimiter_pos && $delimiter_pos > intval($slash_pos) && $delimiter_pos > intval($back_slash_pos)) {
			$file_path = substr($file_path_original, 0, $delimiter_pos) . "_" . $file_index . substr($file_path_original, $delimiter_pos);
		} else {
			$file_path = $index . "_" . $file_path_original;
		}
	}
	return $file_path;
}


function mkdir_recursively($file_path, &$errors)
{
	$errors = "";
	// check if we need create a new dirs recursively
	if (preg_match("/^(.+[\/\\\\])[^\/\\\\]*$/", $file_path, $matches)) {
		$dir_path = $matches[1];
		if (!file_exists($dir_path)) {
	    $dir_path = preg_replace("/(\/){2,}|(\\\){1,}/", "/", $dir_path); 
	    $dir_path = rtrim($dir_path, "/");
			$dir_parts = explode("/", $dir_path);
			$dir_path = ""; // clear var to create dir one by one
			foreach ($dir_parts as $dir_part) {
				$start_path = $dir_path;
				$dir_path .= $dir_part."/";
				if (!is_dir($dir_path)) {
					$dir_created = @mkdir($dir_path, 0777);
					if (!$dir_created) {
						if (!is_writable($start_path)) {
							$errors .= str_replace("{folder_name}", $start_path, FOLDER_PERMISSION_MESSAGE) . "<br>\n";
						}	else if (!file_exists($dir_path)) {
							$errors .= FOLDER_DOESNT_EXIST_MSG." ".$dir_path."\n";
						}
						break;
					}
				}
			}
		}
	}

}



?>