<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  profile_functions.php                                    ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/


function get_phone_codes()
{
	global $db, $table_prefix;
	$phone_codes = array(array("", ""));
	$sql  = " SELECT country_code, phone_code FROM " . $table_prefix . "countries ";
	$sql .= " WHERE show_for_user=1 AND phone_code IS NOT NULL AND phone_code <>'' ";
	$sql .= " ORDER BY country_order, country_name ";
	$db->query($sql);	
	while ($db->next_record()) {
		$country_code = $db->f("country_code");
		$phone_code = $db->f("phone_code");	
		$phone_codes[] = array($phone_code, $country_code.": (".$phone_code.") ");
	}
	return $phone_codes;
}

function phone_code_checks($phone_codes)
{
	global $settings, $r, $phone_parameters;
	$phone_code_select = get_setting_value($settings, "phone_code_select", 1);
	if ($phone_code_select) {
		foreach ($phone_parameters as $id => $field_name) {
			$show_option = $r->get_property_value($field_name, SHOW);
			if ($show_option) {
				$phone_number = $r->get_value($field_name);
				if (preg_match("/^\s*\(([^\)]+)\)\s*(.*)$/", $phone_number, $matches)) {
					$phone_code = $matches[1];
					$phone_number = $matches[2];
					$code_desc = get_array_value($phone_code, $phone_codes);
					if (strlen($code_desc)) {
						$r->set_value($field_name."_code", $phone_code);
						$r->set_value($field_name, $phone_number);
					}
				}
			}
		}
	}
}

function disable_phone_codes()
{
	global $phone_parameters, $r;
	foreach ($phone_parameters as $id => $field_name) {
		$code_field = $field_name."_code";
		if ($r->parameter_exists($code_field)) {
			$r->change_property($code_field, USE_IN_INSERT, false);
			$r->change_property($code_field, USE_IN_UPDATE, false);
			$r->change_property($code_field, USE_IN_SELECT, false);
		}
	}
}

function join_phone_fields()
{
	global $phone_parameters, $r;
	foreach ($phone_parameters as $id => $field_name) {
		$code_field = $field_name."_code";
		if ($r->parameter_exists($code_field) && !$r->is_empty($code_field)) {
			$phone_code = $r->get_value($code_field);
			$phone_number = $r->get_value($field_name);
			$r->set_value($field_name, "(".$phone_code.") ".$phone_number);
		}
	}
}

function prepare_states(&$r)
{
	global $t, $db, $table_prefix;

	$params = array(
		"personal" => array("prefix" => "", "states" => "", "country_id" => "", "province" => false),
		"del" => array("prefix" => "delivery_", "states" => "", "country_id" => "", "province" => false), 
		"bill" => array("prefix" => "bill_", "states" => "", "country_id" => "", "province" => false), 
		"fc" => array("prefix" => "fast_checkout_", "states" => "", "country_id" => "", "province" => false),
	);

	foreach ($params as $code => $param) {
		$prefix = $param["prefix"];
		// initialize states array
		$params[$code]["states"] = array(array("", SELECT_STATE_MSG));
		// get country data from record
		if ($r->parameter_exists($prefix."country_id")) {
			$params[$code]["country_id"] = $r->get_value($prefix."country_id");
		}
		$params[$code]["province"] = $r->get_property_value($prefix."province", SHOW);
	}
	// prepare state names 
	$state_names = array(); 
	$sql = "SELECT country_id, state_field_name FROM " . $table_prefix . "countries WHERE show_for_user=1 AND state_field_name IS NOT NULL AND state_field_name<>'' ";
	$db->query($sql);
	while ($db->next_record()) {
		$country_id = $db->f("country_id");
		$state_field_name = trim(get_translation($db->f("state_field_name")));
		if ($state_field_name && $state_field_name !== "") {
			$state_names[$country_id] = $state_field_name;
		}
	}
	$state_names_json = json_encode($state_names);
	$t->set_var("state_names_json", $state_names_json);
	$t->sparse("state_names_json_block", false);

	$states = array(); 
	$sql = "SELECT country_id, state_id, state_name FROM " . $table_prefix . "states WHERE show_for_user=1 ORDER BY state_name ";
	$db->query($sql);
	while ($db->next_record()) {
		$country_id = $db->f("country_id");
		$state_id = $db->f("state_id");
		$state_name = get_translation($db->f("state_name"));
		// populates states for controls
		foreach ($params as $code => $param) {
			$param_country_id = $param["country_id"];
			if ($param_country_id == $country_id) {
				$params[$code]["states"][] = array($state_id, $state_name);
			}
		}
		if (!isset($states[$country_id])) { $states[$country_id] = array(); }
		$states[$country_id][$state_id] = $state_name;
	}
	$states_json = json_encode($states);
	$t->set_var("states_json", $states_json);
	$t->sparse("states_json_block", false);

	// set states list for controls
	foreach ($params as $code => $param) {
		$prefix = $param["prefix"];
		$param_states = $param["states"];
		if ($r->parameter_exists($prefix."state_id")) {
			$r->change_property($prefix."state_id", VALUES_LIST, $param_states);
			if ( sizeof($param_states) <= 1) {
				$r->change_property($prefix."state_id", VALIDATION, false);
			}
		}
	}
	
	// set special tags
	foreach ($params as $code => $param) {
		$prefix = $param["prefix"];
		$param_country_id = $param["country_id"];
		$param_states = $param["states"];
		$province_show = $param["province"];
		if ($param_country_id && sizeof($param_states) > 1) {
			$t->set_var($prefix."state_id_control_style", "display: inline;");
			$t->set_var($prefix."state_id_required_style", "display: inline;");
			$t->set_var($prefix."state_id_comments_style", "display: none;");
			$t->set_var($prefix."province_style", "display: none;");
		} else if ($param_country_id && $province_show) {
			$t->set_var($prefix."state_style", "display: none;");
		} else {
			$t->set_var($prefix."state_id_control_style", "display: none;");
			if ($param_country_id) {
				$t->set_var($prefix."state_id_comments", NO_STATES_FOR_COUNTRY_MSG);
			} else {
				$t->set_var($prefix."state_id_comments", SELECT_COUNTRY_FIRST_MSG);
			}
			$t->set_var($prefix."state_id_comments_style", "display: inline;");
			$t->set_var($prefix."state_id_required_style", "display: none;");
			$t->set_var($prefix."province_style", "display: none;");
		}
	}

	return $states;
}

function get_js_states()
{
	global $db, $table_prefix;

	$states_js = "";
	$sql = " SELECT country_id, state_id, state_name FROM ".$table_prefix."states ";
	$db->query($sql);
	while ($db->next_record()) {
		$country_id = $db->f("country_id");
		$state_id = $db->f("state_id");
		$state_name = get_translation($db->f("state_name"));
		if ($states_js) { $states_js .= "#"; }
		$states_js .= $country_id."|".$state_id."|".prepare_js_value($state_name);
	}
	return $states_js;
}

?>