<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  support_parser.php                                       ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/

/*
$old_error_handler = set_error_handler("myErrorHandler");
function myErrorHandler($errno, $errstr, $errfile, $errline)
{
	switch ($errno) {
		case E_USER_ERROR:
			$msg  = "<b>My ERROR</b> [$errno] $errstr<br />\n";
			$msg .= "  Fatal error in line $errline of file $errfile";
			$msg .= ", PHP " . PHP_VERSION . " (" . PHP_OS . ")<br />\n";
			$msg .= "Aborting...<br />\n";
		case E_USER_WARNING:
			$msg  = "My WARNING> [$errno] $errstr<br />\n";
		case E_USER_NOTICE:
			$msg  = "<b>My NOTICE</b> [$errno] $errstr<br />\n";
		default:
			$msg  = "Unkown error type: [$errno] $errstr<br />\n";
  }

	mail("support@viart.com", "Email Parse Error", $msg);

}
*/

// get/set parameters 
if (!isset($save_email_copy)) { $save_email_copy = false; }
if (!isset($emails_folder))   { $emails_folder = "./"; }

$eol = get_eol();
$test = get_param("test");
if ($test) { $save_email_copy = false; }

if ($test) {
	$fp = fopen("../includes/test_message.txt", "r");
} else {
	$fp = fopen("php://stdin", "r");

	//-- save a copy of message
	if ($save_email_copy) {
		srand ((double) microtime() * 1000000);
		$random_value = rand();
		$copy_filename = $emails_folder . date("Y_m_d_H_i_s_",time()) . $random_value .".txt";
		$fw = fopen($copy_filename, 'a');
	}
}

if ($fp) {
	$headers = array();
	$headers["encoding"] = "";
	$headers["charset"] = "";
	$headers["attachment"] = false;
	$headers["inline"] = false;
	$headers["body"] = "";
	$headers["content-type-value"] = "";
	$header_received = false;

	$mail_headers = "";
	$mail_body_text = "";
	$mail_body_html = "";
	$charset = "";

	// receiving header
	while (!feof($fp) && !$header_received) {
		$line = fgets($fp, 4096);
		if ($save_email_copy) {
			fputs($fw, $line);
		}

		$mail_headers .= $line;
		if (preg_match("/^\s*$/", $line)) {
			$header_received = true;
		} else {
			if (preg_match("/^(\w[\w\-]*):(.*)$/", $line, $matches)) {
				$name = strtolower($matches[1]);
				$value = $matches[2];
			} else {
				$value = $line;
			}
			if (isset($headers[$name])) {
				$headers[$name] .= "\n".$value;
			} else {
				$headers[$name] = $value;
			}
		}
	}


	// check header fields
	// if the messages is auto-response then just ignoring such message
	if (isset($headers["x-autoresponder"]) 
		|| isset($headers["x-autoreply"]) 
		|| isset($headers["x-autorespond"]) 
		|| (isset($headers["auto-submitted"]) && strtolower($headers["auto-submitted"]) != "no") ) 
	{
		if ($save_email_copy) {
			fclose($fw);
			chmod($copy_filename, 0755);
		}
		fclose($fp);
		return;
	}

	// handle main header fields
	if (isset($headers["content-type"]) && preg_match("/^([^;\n\r]*)/s", $headers["content-type"], $match)) { 
		$headers["content-type-value"] = trim(strtolower($match[1])); 
		if (preg_match("/delsp=([^\s]+)/si", $headers["content-type"], $match)) {
			$headers["content-type-delsp"] = trim($match[1]);
		} 
		if (preg_match("/format=([^\s]+)/si", $headers["content-type"], $match)) {
			$headers["content-type-format"] = trim($match[1]);
		} 
		if (preg_match("/charset=([^\s]+)/si", $headers["content-type"], $match)) {
			$charset = trim($match[1]);
			$charset = strtolower(trim($charset, "\""));
			$headers["charset"] = $charset;
		} 
	}

	if (isset($headers["content-transfer-encoding"]) && preg_match("/^([^;\n\r]*)/s", $headers["content-transfer-encoding"], $match)) { 
		$headers["encoding"] = trim(strtolower($match[1])); 
	}
	if (isset($headers["content-disposition"]) && preg_match("/attachment/si", $headers["content-disposition"], $match)) { 
		$headers["attachment"] = true;
		// don't allow only attachment
		$headers["attachment-allowed"] = false;
	} else if (isset($headers["content-disposition"]) && preg_match("/inline/si", $headers["content-disposition"], $match)) { 
		$headers["inline"] = true;
	}

	$subject = ""; $from = ""; $from_user = ""; $from_email = ""; $to = ""; $to_emails = array();

	// get subject from header and remove support comments if available and trim the string
	$subject = isset($headers["subject"]) ? $headers["subject"] : "";
	$subject = preg_replace("/^\s*((Re(\[\d+\])?|FW(\[\d+\])?):\s*)+/i", "", $subject);
	$subject = preg_replace("/^Support\s*(Request|Ticket|Issue)\s*/i", "", $subject);
	$subject = preg_replace("/^:+\s*/i", "", $subject);
	$subject = trim($subject);
	if (!strlen($subject)) { $subject = "No Subject"; }
	decode_mail_header($subject, $subject_charset, $charset);

	// get sender information
	$from = isset($headers["from"]) ? $headers["from"] : "";
	if (preg_match("/(.*?)<(.*?)>/s", $from, $found)) {
		$from_user  = trim($found[1]);
		$from_email = trim($found[2]);
		if (!strlen($from_email)) {
			$from_email = "<>";
		}
	} else {
		$from_email = trim($from);
	}
	if (!strlen($from_user)) {
		if (preg_match("/^([^@]+)@/", $from_email, $match)) {
			$from_user = trim($match[1]);
		} else {
			$from_user = $from_email;
		}
	}
	// remove quotes from the begining and in the end
	if (preg_match("/^\"(.+)\"$/", $from_user, $match)) {
		$from_user = $match[1];
	}
	decode_mail_header($from_user, $from_user_charset, $charset);

	//-- determing possible accounts
	$mail_receivers = array(); $cc_emails = array(); $department_id = ""; $incoming_type_id = ""; $incoming_product_id = "";
	if (isset($account_address) && $account_address) { 
		$mail_receivers[] = $account_address;
	}

	// get receiver emails
	$to = isset($headers["to"]) ? $headers["to"] : "";
	$to_values = explode(",", $to);
	for ($i = 0; $i < sizeof($to_values); $i++) {
		$to_value = $to_values[$i];
		if (preg_match("/<([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)>/i", $to_value, $match)) {
			$mail_receivers[] = $match[1];
		} else if (preg_match("/\s*([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)\s*/i", $to_value, $match)) {
			$mail_receivers[] = trim($match[1]);
		}
	}

	// get receiver cc emails
	$cc = isset($headers["cc"]) ? $headers["cc"] : "";
	$cc_values = explode(",", $cc);
	for ($i = 0; $i < sizeof($cc_values); $i++) {
		$cc_value = $cc_values[$i];
		if (preg_match("/<([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)>/i", $cc_value, $match)) {
			$mail_receivers[] = $match[1];
		} else if (preg_match("/\s*([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)\s*/i", $cc_value, $match)) {
			$mail_receivers[] = trim($match[1]);
		}
	}

	if (sizeof($mail_receivers) > 0)	{
		$sql  = " SELECT * FROM " . $table_prefix . "support_departments ";
		for ($i = 0; $i < sizeof($mail_receivers); $i++) {
			if ($i == 0) {
				$sql .= " WHERE "; 
			} else {
				$sql .= " OR ";
			}
			$sql .= " incoming_account LIKE '%" . $db->tosql($mail_receivers[$i], TEXT, false) . "%'";
		}
		$db->query($sql);
		if ($db->next_record())
		{
			$department_id = $db->Record["dep_id"];
			$attachments_dir = $db->Record["attachments_dir"];
			$attachments_mask = $db->Record["attachments_mask"];
			$incoming_type_id = $db->Record["incoming_type_id"];
			$incoming_account = $db->Record["incoming_account"];
			$incoming_emails = array();
			$incoming_values = explode(",", $incoming_account);
			for ($i = 0; $i < sizeof($incoming_values); $i++) {
				$incoming_value = $incoming_values[$i];
				if (preg_match("/<([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)>/i", $incoming_value, $match)) {
					$incoming_emails[] = $match[1];
				} else if (preg_match("/\s*([^@]+@[^@]+(\.[^@]+)*\.[a-z]+)\s*/i", $incoming_value, $match)) {
					$incoming_emails[] = trim($match[1]);
				}
			}
			foreach($mail_receivers as $receiver_email) {
				if (!in_array($receiver_email, $incoming_emails)) {
					$cc_emails[] = $receiver_email;
				}
			}

			if (!strlen($incoming_type_id)) {
				$incoming_type_id = 0;
			}
			$incoming_product_id = $db->Record["incoming_product_id"];
			if (!strlen($incoming_product_id)) {
				$incoming_product_id = 0;
			}
			if (!$attachments_mask) {
			  $sql  = "SELECT setting_value FROM " . $table_prefix . "global_settings ";
				$sql .= "WHERE setting_type='support' AND setting_name='attachments_users_mask'";
				$attachments_mask = get_db_value($sql);
			}
			if (!$attachments_dir) {
			  $sql  = "SELECT setting_value FROM " . $table_prefix . "global_settings ";
				$sql .= "WHERE setting_type='support' AND setting_name='attachments_dir'";
				$attachments_dir = get_db_value($sql);
			}
		}
	}

	if (strlen($department_id)) {

		// check if message consist from multi parts
		$boundary = "";
		$content_type = isset($headers["content-type"]) ? $headers["content-type"] : "";
		if (preg_match("/boundary=\"([^\"]+)\"/i", $content_type, $match)) {
			$boundary = $match[1];
		} else if (preg_match("/boundary=([^\s]+)/i", $content_type, $match)) {
			$boundary = $match[1];
		} 
		
		// parsing messages
		$message_headers = array(); $messages = array(); 
		$msg_id = 0; $header_received = false;
		if (strlen($boundary)) {

			// if boundary exists check all parts of message
			$is_boundary = false;
			parse_multipart($boundary, false);

		} else {

			// the message has only one part
			$messages[0] = $headers;
			$messages[0]["body"] = "";

			while (!feof($fp)) {
				$line = fgets($fp, 4096);
				if ($save_email_copy) {
					fputs($fw, $line);
				}
				$messages[0]["body"] .= $line;
			}

			if ($messages[0]["encoding"] == "base64") { 
				$messages[0]["body"] = base64_decode($messages[0]["body"]);
			} else if ($messages[$msg_id]["encoding"] == "quoted-printable") {
				$messages[0]["body"] = quoted_printable_decode($messages[0]["body"]);
			}

			// if there is no content-type header check it from the mail body
			if ($messages[0]["content-type-value"] == "") {
				if (preg_match("/<html>/i", $messages[0]["body"])) {
					$messages[0]["content-type-value"] = "text/html";
				} else {
					$messages[0]["content-type-value"] = "text/plain";
				}
			}

		}
		
		if ($save_email_copy) { 
			fclose($fw); 
			chmod($copy_filename, 0755);
		}
		fclose($fp);

		//-- analyze parts of the message - getting the body 
		$body = ""; 

		$mail_body_text = "";
		$mail_body_html = "";

		// check for plain text copy
		foreach($messages as $msg_id => $message) {
			if (!$message["attachment"] && !$message["inline"] && $message["content-type-value"] == "text/plain") { 
				if ($mail_body_text) { $mail_body_text .= "--\n"; }
				$mail_body_text .= $message["body"];

			}
		}
		// check for HTML version 
		foreach($messages as $msg_id => $message) {
			if (!$message["attachment"] && !$message["inline"] && $message["content-type-value"] == "text/html") { 
				if ($mail_body_html) { $mail_body_html .= "<br><hr><br>"; }
				$mail_body_html .= $message["body"];
			}
		}

		// add inline messages to the end of messages
		foreach($messages as $msg_id => $message) {
			if ($message["inline"]) { 
				if ($message["content-type-value"] == "text/html") {
					// HTML inline message
					if ($mail_body_html) { $mail_body_html .= "<br><hr><br>"; }
					$mail_body_html .= $message["body"];

					if ($mail_body_text) { $mail_body_text .= "\n--\n"; }
					if ($mail_body_text) { 
						$inline_body = $message["body"];
						$inline_body = preg_replace("/<br\s*\/?>/i", $eol, $inline_body);
						$inline_body = preg_replace("/&nbsp;/i", " ", $inline_body);
						$inline_body = strip_tags($inline_body);
						$inline_body = preg_replace("/&gt;/i", ">", $inline_body);
						$inline_body = preg_replace("/&lt;/i", "<", $inline_body);
						$mail_body_text .= $inline_body;
					}
				} else {
					// Plain text inline message
					if ($mail_body_html) { $mail_body_html .= "<br><hr><br>"; }
					if ($mail_body_html) { $mail_body_html .= nl2br(htmlspecialchars($message["body"])); }

					if ($mail_body_text) { $mail_body_text .= "\n--\n"; }
					$mail_body_text .= $message["body"];
				}
			}
		}


		if ($mail_body_text) {
			$body = $mail_body_text;
		} else {
			$body = $mail_body_html;
			$body = preg_replace("/[\n\r]/", "", $body);
			$body = preg_replace("/<br\s*\/?>/i", $eol, $body);
			$body = preg_replace("/&nbsp;/i", " ", $body);
			$body = strip_tags($body);
			$body = preg_replace("/&gt;/i", ">", $body);
			$body = preg_replace("/&lt;/i", "<", $body);
		}

		// retrieve information about ticket number
		if (preg_match("/Ticket\s+ID\s+is\s+(\d+)/si", $body, $match)) { 
			$ticket_id = $match[1];
		} else if (preg_match("/Ticket\s+ID\:\s*(\d+)/si", $body, $match)) { 
			$ticket_id = $match[1];
		} else if (preg_match("/support_id=(\d+)/s", $body, $match)) {
			$ticket_id = $match[1];
		} else {
			$ticket_id = "";
		}

		$vc_param = "";
		if (strlen($ticket_id)) {
			// check vc parameter
			if (preg_match("/vc\:\s*([0-9a-f]{8,})/si", $body, $match)) {
				$vc_param = strtolower($match[1]);
			} else if (preg_match("/vc\=\s*([0-9a-f]{8,})/si", $body, $match)) {
				$vc_param = strtolower($match[1]);
			}
		}

		// remove everything after body limit
		$body = preg_replace("/\-+Ticket\-Body\-End.*/is", "", $body);
		// trim spaces from the end and begin
		$body = trim($body);
  
		$ticket_date = ""; $ticket_dep_id = ""; $ticket_user_email = ""; $ticket_mail_cc = ""; $ticket_mail_bcc = "";
		if (strlen($ticket_id)) {
			$sql = "SELECT support_id, dep_id, user_email, mail_cc, mail_bcc, date_added FROM " . $table_prefix ."support WHERE support_id=" . $db->tosql($ticket_id, INTEGER);
			$db->query($sql);
			if ($db->next_record()) { 
				// check confirmation parameter
				$ticket_dep_id = $db->f("dep_id");
				$ticket_user_email = $db->f("user_email");
				$ticket_mail_cc = $db->f("mail_cc");
				$ticket_mail_bcc = $db->f("mail_bcc");
				$ticket_date = $db->f("date_added", DATETIME);
				$vc_db = strtolower(md5($ticket_id.$ticket_date[3].$ticket_date[4].$ticket_date[5]));
				// compare only first part of vc parameter as sometime last symbols could be cut off
				if (substr($vc_db, 0, 8) != substr($vc_param, 0, 8)) {
					$ticket_id = "";
				}
			} else {
				$ticket_id = "";
			}
		}

		// convert messages to utf-8
		$body = convert_to_utf8($body, $charset);
		$mail_body_text = convert_to_utf8($mail_body_text, $charset);
		$mail_body_html = convert_to_utf8($mail_body_html, $charset);

		$message_id = 0; $from_admin_id = "";
		// save ticket information
		if (strlen($ticket_id))
		{
			// check if it's admin reply
			$sql  = " SELECT admin_id FROM " . $table_prefix ."admins ";
			$sql .= " WHERE email=" . $db->tosql($from_email, TEXT);
			$db->query($sql);
			if ($db->next_record()) {
				$from_admin_id = $db->f("admin_id");
			}
			// check if admin has permission to reply for this department
			if ($from_admin_id) {
				$sql  = " SELECT admin_id FROM " . $table_prefix ."support_users_departments ";
				$sql .= " WHERE admin_id=" . $db->tosql($from_admin_id, INTEGER);
				$sql .= " AND dep_id=" . $db->tosql($ticket_dep_id, INTEGER);
				$from_admin_id = get_db_value($sql);
			}

			if ($from_admin_id) {
				$is_user_reply = 0;
				// check admin status for reply message
				$sql = " SELECT status_id FROM " . $table_prefix . "support_statuses WHERE is_admin_reply=1 ";
				$db->query($sql);
				if($db->next_record()) {
					$reply_status_id = $db->f("status_id");
				} else {
					$sql  = " SELECT status_id FROM " . $table_prefix . "support_statuses ";
					$sql .= " WHERE is_operation=1 ";
					$sql .= " AND (is_closed IS NULL OR is_closed<>1) ";
					$sql .= " AND (is_internal IS NULL OR is_internal<>1) ";
					$db->query($sql);
					if($db->next_record()) {
						$reply_status_id = $db->f("status_id");
					} else {
						$reply_status_id = 0;
					}
				}
			} else {
				$is_user_reply = 1;
				// get user status for reply message
				$sql = " SELECT status_id FROM " . $table_prefix . "support_statuses WHERE is_user_reply=1 ";
				$db->query($sql);
				if($db->next_record()) {
					$reply_status_id = $db->f("status_id");
				} else {
					$sql = " SELECT status_id FROM " . $table_prefix . "support_statuses WHERE is_user_new=1 ";
					$db->query($sql);
					if($db->next_record()) {
						$reply_status_id = $db->f("status_id");
					} else {
						$reply_status_id = 0;
					}
				}
			}
			if (!$from_admin_id) { $from_admin_id = 0; } // use zero value if admin wasn't found

			$sql  = "INSERT INTO " . $table_prefix . "support_messages ";
			$sql .= " (support_id,is_user_reply,admin_id_assign_by,support_status_id,date_added,reply_from,reply_to,subject,";
			$sql .= " message_text,mail_headers,mail_body_text,mail_body_html) VALUES (";
			$sql .= $db->tosql($ticket_id, INTEGER) . ", ";
			$sql .= $db->tosql($is_user_reply, INTEGER) . ", ";
			$sql .= $db->tosql($from_admin_id, INTEGER, true, false) . ", ";
			$sql .= $db->tosql($reply_status_id, INTEGER) . ", ";
			$sql .= $db->tosql(va_time(), DATETIME) . ", ";
			$sql .= $db->tosql($from_email, TEXT) . ", ";
			$sql .= $db->tosql($to, TEXT) . ", ";
			$sql .= $db->tosql($subject, TEXT) . ", ";
			$sql .= $db->tosql($body, TEXT) . ", ";
			$sql .= $db->tosql($mail_headers, TEXT) . ", ";
			$sql .= $db->tosql($mail_body_text, TEXT) . ", ";
			$sql .= $db->tosql($mail_body_html, TEXT) . ") ";
			$db->query($sql);

			if ($db_type == "mysql") {
				$message_id = get_db_value(" SELECT LAST_INSERT_ID() ");
			} else if ($db_type == "access") {
				$message_id = get_db_value(" SELECT @@IDENTITY ");
			} else if ($db_type == "db2") {
				$message_id = get_db_value(" SELECT PREVVAL FOR seq_" . $table_prefix . "support_messages FROM " . $table_prefix . "support_messages ");
			} else {
				$sql  = " SELECT MAX(message_id) AS lid FROM " . $table_prefix . "support_messages ";
				$sql .= " WHERE support_id=" . $db->tosql($ticket_id, INTEGER);
				$message_id = get_db_value($sql);
			}
  
			$sql  = " UPDATE " . $table_prefix . "support SET ";
			$sql .= " admin_id_assign_to=0, ";
			$sql .= " admin_id_assign_by=" . $db->tosql($from_admin_id, INTEGER, true, false) . ", ";
			$sql .= " support_status_id=" . $db->tosql($reply_status_id, INTEGER) . ", ";
			$sql .= " date_modified=" . $db->tosql(va_time(), DATETIME);
			$sql .= " WHERE support_id=" . $ticket_id;
			$db->query($sql);
			$new_thread = false;
		}
		else
		{
			$ticket_date = va_time();
			// get status for new message
			$sql = " SELECT status_id FROM " . $table_prefix . "support_statuses WHERE is_user_new=1 ";
			$db->query($sql);
			if($db->next_record()) {
				$new_status_id = $db->f("status_id");
			} else {
				$sql = " SELECT status_id FROM " . $table_prefix . "support_statuses WHERE is_user_reply=1 ";
				$db->query($sql);
				if($db->next_record()) {
					$new_status_id = $db->f("status_id");
				} else {
					$new_status_id = 0;
				}
			}

			// get priority for new message
			$priority_id = 0;
			$sql  = " SELECT sp.priority_id, sup.priority_expiry ";
			$sql .= " FROM " . $table_prefix . "support_priorities sp, " . $table_prefix . "support_users_priorities sup ";
			$sql .= " WHERE sp.priority_id=sup.priority_id ";
			$sql .= " AND user_email=" . $db->tosql($from_email, TEXT);
			$db->query($sql);
			if($db->next_record()) {
				$priority_id = $db->f("priority_id");	
				$current_ts = va_timestamp();
				$priority_expiry = $db->f("priority_expiry", DATETIME);
				if (is_array($priority_expiry)) {
					$priority_expiry_ts = va_timestamp($priority_expiry); 
					if ($current_ts > $priority_expiry_ts) {
						// user rank expired
						$priority_id = 0;
					}
				}
			} 
			if (!$priority_id) {
				$sql  = " SELECT priority_id FROM " . $table_prefix . "support_priorities WHERE is_default=1 ";
				$db->query($sql);
				if ($db->next_record()) {
					$priority_id = $db->f("priority_id");	
				}
			}

			// check user_id for new message
			$sql  = " SELECT user_id FROM " . $table_prefix . "users ";
			$sql .= " WHERE email=" . $db->tosql($from_email, TEXT);
			$db->query($sql);
			if ($db->next_record()) {
				$user_id = $db->f("user_id");
			} else {
				$user_id = 0;
			}
  
			$ip   = get_ip();
			$sql  = "INSERT INTO " . $table_prefix . "support (";
			if ($db_type == "postgre") {
				$ticket_id = get_db_value(" SELECT NEXTVAL('seq_" . $table_prefix . "support') ");
				$sql .= " support_id, ";
			}
			$sql .= " site_id, date_modified,support_product_id,support_type_id,support_status_id,support_priority_id,date_added,dep_id,";
			$sql .= " user_id, user_name,user_email,remote_address,summary,description,mail_cc,mail_headers,mail_body_text,mail_body_html) VALUES (";
			if ($db_type == "postgre") {
				$sql .= $db->tosql($ticket_id, INTEGER) . ", ";
			}
			if (isset($site_id)) {
				$sql .= $db->tosql($site_id, INTEGER, true, false) . ", ";
			} else {
				$sql .= $db->tosql(1, INTEGER) . ", ";
			}
			$sql .= $db->tosql(va_time(), DATETIME) . ",";
			$sql .= $db->tosql($incoming_product_id, INTEGER) . ", ";
			$sql .= $db->tosql($incoming_type_id, INTEGER) . ", ";
			$sql .= $db->tosql($new_status_id, INTEGER) . ", ";
			$sql .= $db->tosql($priority_id, INTEGER) . ", ";
			$sql .= $db->tosql($ticket_date, DATETIME) . ", ";
			$sql .= $department_id . ", ";
			$sql .= $db->tosql($user_id, INTEGER) . ", ";
			$sql .= $db->tosql($from_user, TEXT) . ", ";
			$sql .= $db->tosql($from_email, TEXT) . ", ";
			$sql .= $db->tosql($ip, TEXT) . ", ";
			$sql .= $db->tosql($subject, TEXT) . ", ";
			$sql .= $db->tosql($body, TEXT) . ", ";
			if (sizeof($cc_emails) > 0)  {
				$sql .= $db->tosql(implode(", ", $cc_emails), TEXT) . ", ";
			} else {
				$sql .= "'', ";
			}
			$sql .= $db->tosql($mail_headers, TEXT) . ", ";
			$sql .= $db->tosql($mail_body_text, TEXT) . ", ";
			$sql .= $db->tosql($mail_body_html, TEXT) . ") ";
			$db->query($sql);
  
			if ($db_type == "mysql") {
				$ticket_id = get_db_value(" SELECT LAST_INSERT_ID() ");
			} else if ($db_type == "access") {
				$ticket_id = get_db_value(" SELECT @@IDENTITY ");
			} else if ($db_type == "db2") {
				$ticket_id = get_db_value(" SELECT PREVVAL FOR seq_" . $table_prefix . "support FROM " . $table_prefix . "support ");
			}
			$new_thread = true;
		}

		// save attachments
		$attachments = array();
		foreach($messages as $msg_id => $message) {
			if ($message["attachment"] && $message["attachment-allowed"]) { 
				$sql  = " INSERT INTO " . $table_prefix . "support_attachments (support_id, message_id, admin_id, attachment_status, date_added, file_name, file_path) ";
				$sql .= " VALUES (" . $ticket_id . ",";
				$sql .= $db->tosql($message_id, INTEGER) . ", ";
				$sql .= "0, 1, ";
				$sql .= $db->tosql(va_time(), DATETIME) . ", ";
				$sql .= $db->tosql($message["filename"], TEXT) . ", ";
				$sql .= $db->tosql($message["filepath"], TEXT) . ") ";
				$db->query($sql);
				$attachments[] = array($message["filename"], $message["filepath"]);
			}
		}

		// check helpdesk settings
		$support_settings = get_settings("support");
		$admin_notification = get_setting_value($support_settings, "admin_notification", 0);
		$site_url = get_setting_value($settings, "site_url", "");

		// prepare some data for sending
		$t = new VA_Template(".");
		$vc = md5($ticket_id . $ticket_date[3].$ticket_date[4].$ticket_date[5]);
		$ticket_url = $site_url . "support_messages.php?support_id=" . $ticket_id. "&vc=" . $vc;

		// send notification customer
		if ($message_id && $from_admin_id) {
			$user_subject = get_setting_value($support_settings, "user_subject", $subject);
			$user_message = get_setting_value($support_settings, "user_message", $body);

			$t->set_block("user_subject", $user_subject);
			$t->set_block("user_message", $user_message);

			$sql  = " SELECT outgoing_account FROM " . $table_prefix . "support_departments ";
			$sql .= " WHERE dep_id=" . $db->tosql($ticket_dep_id, INTEGER);
			$outgoing_account = get_db_value($sql);

			if (strlen($outgoing_account)) {
				$mail_from = $outgoing_account;
			} else {
				$mail_from = get_setting_value($support_settings, "user_mail_from", $settings["admin_email"]);
			}
			$mail_cc = get_setting_value($support_settings, "user_mail_cc");
			if ($ticket_mail_cc) {
				if ($mail_cc) { $mail_cc .= ", "; }
				$mail_cc .= $ticket_mail_cc;
			}
			$mail_cc = str_replace(";", ",", $mail_cc);
			$mail_bcc = get_setting_value($support_settings, "user_mail_bcc");
			if ($ticket_mail_bcc) {
				if ($mail_bcc) { $mail_bcc .= ", "; }
				$mail_bcc .= $ticket_mail_bcc;
			}
			$mail_bcc = str_replace(";", ",", $mail_bcc);
			// remove admin email from cc if he is answering this ticket
			if ($mail_cc) {
				$cc_values = explode(",", $mail_cc);
				foreach ($cc_values as $email_id => $email_value) {
					if (trim(strtolower($from_email)) == trim(strtolower($email_value))) {
						unset($cc_values[$email_id]);
					}
				}
				$mail_cc = implode(", ", $cc_values);
			}
			// remove admin email from bcc if he is answering this ticket
			if ($mail_bcc) {
				$bcc_values = explode(",", $mail_bcc);
				foreach ($bcc_values as $email_id => $email_value) {
					if (trim(strtolower($from_email)) == trim(strtolower($email_value))) {
						unset($bcc_values[$email_id]);
					}
				}
				$mail_bcc = implode(", ", $bcc_values);
			}

			$email_headers = array();
			$email_headers["from"] = $mail_from;
			$email_headers["cc"] = $mail_cc;
			$email_headers["bcc"] = $mail_bcc;
			$email_headers["reply_to"] = get_setting_value($support_settings, "user_mail_reply_to");
			$email_headers["return_path"] = get_setting_value($support_settings, "user_mail_return_path");
			$email_headers["mail_type"] = get_setting_value($support_settings, "user_message_type");
			$email_headers["Auto-Submitted"] = "auto-generated";

			$t->set_var("support_id", $ticket_id);
			$t->set_var("ticket_id", $ticket_id);
			$t->set_var("message_id", $message_id);
			$t->set_var("summary", $subject);
			$t->set_var("description", $body);
			$t->set_var("message_text", $body);
			$t->set_var("site_url", $site_url);
			$t->set_var("support_url", $ticket_url);
			$t->set_var("ticket_url", $ticket_url);
			$t->set_var("vc", $vc);
			$t->parse("user_subject", false);
			if ($email_headers["mail_type"]) {
				$t->set_var("summary", htmlspecialchars($subject));
				$t->set_var("description", nl2br(htmlspecialchars($body)));
				$t->set_var("message_text", nl2br(htmlspecialchars($body)));
			}
			$t->parse("user_message", false);

			$user_message = preg_replace("/\r\n|\r|\n/", $eol, $t->get_var("user_message"));
			va_mail($ticket_user_email, $t->get_var("user_subject"), $user_message, $email_headers, $attachments);
		}

		// send notification to administrator
		if (!$from_admin_id && $admin_notification) {
			$admin_subject = get_setting_value($support_settings, "admin_subject", $subject);
			$admin_message = get_setting_value($support_settings, "admin_message", $body);

			$t->set_block("admin_subject", $admin_subject);
			$t->set_block("admin_message", $admin_message);

			$mail_to = get_setting_value($support_settings, "admin_email", $settings["admin_email"]);
			$mail_to = str_replace(";", ",", $mail_to);
			$email_headers = array();
			$email_headers["from"] = get_setting_value($support_settings, "admin_mail_from", $settings["admin_email"]);
			$email_headers["cc"] = get_setting_value($support_settings, "cc_emails");
			$email_headers["bcc"] = get_setting_value($support_settings, "admin_mail_bcc");
			$email_headers["reply_to"] = get_setting_value($support_settings, "admin_mail_reply_to");
			$email_headers["return_path"] = get_setting_value($support_settings, "admin_mail_return_path");
			$email_headers["mail_type"] = get_setting_value($support_settings, "admin_message_type");
			$email_headers["Auto-Submitted"] = "auto-generated";

			$t->set_var("support_id", $ticket_id);
			$t->set_var("ticket_id", $ticket_id);
			$t->set_var("message_id", $message_id);
			$t->set_var("user_name", $from_user);
			$t->set_var("user_email", $from_email);
			$t->set_var("summary", $subject);
			$t->set_var("description", $body);
			$t->set_var("message_text", $body);
			$t->set_var("site_url", $site_url);
			$t->set_var("support_url", $ticket_url);
			$t->set_var("ticket_url", $ticket_url);
			$t->set_var("vc", $vc);
			$t->parse("admin_subject", false);
			if ($email_headers["mail_type"]) {
				$t->set_var("summary", htmlspecialchars($subject));
				$t->set_var("user_name", htmlspecialchars($from_user));
				$t->set_var("user_email", htmlspecialchars($from_email));
				$t->set_var("description", nl2br(htmlspecialchars($body)));
				$t->set_var("message_text", nl2br(htmlspecialchars($body)));
			}
			$t->parse("admin_message", false);

			$admin_message = preg_replace("/\r\n|\r|\n/", $eol, $t->get_var("admin_message"));
			va_mail($mail_to, $t->get_var("admin_subject"), $admin_message, $email_headers, $attachments);
		}
		// end sending notifications

	} else {
		// cannot find department to pipe
		if ($save_email_copy) {
			while (!feof($fp)) {
				$line = fgets($fp, 4096);
				fputs($fw, $line);
			}
			fclose($fw);
			chmod($copy_filename, 0755);
		}
		fclose($fp);

		$recipients     = $settings["admin_email"];
		$mail_subject   = "auto: ViArt SHOP Notification";
		$email_headers = array();
		$email_headers["from"] = $settings["admin_email"];
		$email_headers["Auto-Submitted"] = "auto-generated";
		$email_headers["Content-Type"] = "text/plain";
		
		$message  = "Can't find the appropriate Helpdesk Department to pipe email for account: ";
		$message .= "'" . join(", ", $mail_receivers) . "'" . $eol;
  
		va_mail($recipients, $mail_subject, $message, $email_headers);
	}

} else {
	// cannot read email message
	$recipients     = $settings["admin_email"];
	$mail_subject   = "auto: ViArt SHOP Notification";
	$email_headers = array();
	$email_headers["from"] = $settings["admin_email"];
	$email_headers["Auto-Submitted"] = "auto-generated";
	$email_headers["Content-Type"] = "text/plain";
	$message  = "Can't read the email message";
	va_mail($recipients, $mail_subject, $message, $email_headers);
}


function parse_multipart($boundary, $is_sub_boundary)
{
	global $fp, $fw, $save_email_copy, $charset;
	global $is_boundary, $header_received;
	global $message_headers, $messages, $msg_id;
	global $settings, $attachments_mask, $sub_attachments_dir, $attachments_dir;
	if (!isset($sub_attachments_dir)) { $sub_attachments_dir = ""; } // subpath to create a full path to attachments directory
	while (!feof($fp)) {
		$line = fgets($fp, 4096);
		if ($save_email_copy) { fputs($fw, $line); }

		if (!$is_boundary) {
			// check for first boundary
			if (trim($line) == $boundary || trim($line) == "--" . $boundary) {
				$is_boundary = true;
			} else if ($is_sub_boundary && trim($line) == "--".$boundary."--") {
				// check end of boundary for sub-patterns
				return;
			}
		} else if (!$header_received) {
			// get message header
			if (trim($line) == "") {
				$header_received = true;
				$sub_charset = "";
				$messages[$msg_id] = $message_headers;
				$messages[$msg_id]["charset"] = "";
				$messages[$msg_id]["encoding"] = "";
				$messages[$msg_id]["attachment"] = false;
				$messages[$msg_id]["inline"] = false;
				$messages[$msg_id]["body"] = "";
				$messages[$msg_id]["content-type-value"] = "";


				$sub_boundary = "";
				if (isset($message_headers["content-type"]) && preg_match("/^([^;\n\r]*)/s", $message_headers["content-type"], $match)) { 
					$messages[$msg_id]["content-type-value"] = trim(strtolower($match[1])); 
					if (preg_match("/delsp=([^\s]+)/si", $message_headers["content-type"], $match)) {
						$messages[$msg_id]["content-type-delsp"] = trim($match[1]);
					} 
					if (preg_match("/format=([^\s]+)/si", $message_headers["content-type"], $match)) {
						$messages[$msg_id]["content-type-format"] = trim($match[1]);
					} 
					// check if message consist from multi parts
					if (preg_match("/boundary=\"(.+)\"/i", $message_headers["content-type"], $match)) {
						$sub_boundary = $match[1];
					} else if (preg_match("/boundary=([^\s]+)/i", $message_headers["content-type"], $match)) {
						// trim any semicolons at the end of boundary
						$sub_boundary = rtrim($match[1], ";");
					} 
					if (preg_match("/charset=([^\s]+)/si", $message_headers["content-type"], $match)) {
						$sub_charset = trim($match[1]);
						$sub_charset = strtolower(trim($sub_charset, "\""));
						$messages[$msg_id]["charset"] = $sub_charset;
					} 
				}

				if (strlen($sub_boundary)) {
					$is_boundary = false; $header_received = false; $message_headers = array();
					parse_multipart($sub_boundary, true);
				} else {

					if (isset($message_headers["content-transfer-encoding"]) && preg_match("/^([^;\n\r]*)/s", $message_headers["content-transfer-encoding"], $match)) { 
						$messages[$msg_id]["encoding"] = trim(strtolower($match[1])); 
					}
					// check if the mail part is attachment
					if ((isset($message_headers["content-disposition"]) 
						&& (preg_match("/filename=/i", $message_headers["content-disposition"]) 
						|| preg_match("/attachment/si", $message_headers["content-disposition"], $match)))
						|| preg_match("/name=\"(.+)\"/si", $messages[$msg_id]["content-type"])
						|| preg_match("/name=([^\s]+)/si", $messages[$msg_id]["content-type"])) { 
						$messages[$msg_id]["attachment"] = true;
					} else if (isset($message_headers["content-disposition"]) && preg_match("/inline/si", $message_headers["content-disposition"], $match)) {
						// check if the mail part inline
						$messages[$msg_id]["inline"] = true;
					}
					// if the type of message not text or html consider it as attachment
					if ($messages[$msg_id]["content-type-value"] && $messages[$msg_id]["content-type-value"] != "text/plain"
						&& $messages[$msg_id]["content-type-value"] != "text/html") {
						$messages[$msg_id]["attachment"] = true;
					}
					// check attachment settings 
					if ($messages[$msg_id]["attachment"]) { //-- get the file name
						$messages[$msg_id]["filename"] = "";
						if (isset($message_headers["content-disposition"]) && preg_match("/filename=/i", $message_headers["content-disposition"])) {
							if (preg_match("/filename=[\s\t]*\"([^\"]+)\"/si", $message_headers["content-disposition"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]);
							} else if (preg_match("/filename=([^\s]+)/si", $message_headers["content-disposition"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]);
							}
						} else {
							if (preg_match("/name=[\s\t]*\"(.+)\"/si", $messages[$msg_id]["content-type"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]);
							} else if (preg_match("/name=([^\s]+)/si", $messages[$msg_id]["content-type"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]);
							} else if (preg_match("/^text\/([^\s]+)/i", $messages[$msg_id]["content-type-value"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]) . ".txt";
							} else if (preg_match("/^message\/([^\s]+)/i", $messages[$msg_id]["content-type-value"], $match)) {
								$messages[$msg_id]["filename"] = trim($match[1]) . ".txt";
							}
						}

						if (strlen($messages[$msg_id]["filename"])) {
							$filename_charset = "";
							$filename = $messages[$msg_id]["filename"];
							// try to decode filename
	            decode_mail_header($filename, $filename_charset, $charset);
							$filename = preg_replace("/[\\:\\/\\\\]/", "_", $filename);
							$messages[$msg_id]["filename"] = $filename;
						}
						// remove some symbols
						$messages[$msg_id]["filename"] = preg_replace("/[\n\t\r]/", "", $messages[$msg_id]["filename"]);
			  
						$messages[$msg_id]["attachment-allowed"] = false;
						if (strlen($messages[$msg_id]["filename"])) {
							$attachments_regexp = preg_replace("/\s/", "", $attachments_mask);
							$filename_check = $messages[$msg_id]["filename"];
							if (!preg_match("/\./", $filename_check)) {
								$filename_check .= ".";
							}
							$s = array("\\","^","\$",".","[","]","|","(",")","+","{","}");
							$r = array("\\\\","\\^","\\\$","\\.","\\[","\\]","\\|","\\(","\\)","\\+","\\{","\\}");
							$attachments_regexp = str_replace($s, $r, $attachments_regexp);
							$attachments_regexp = str_replace(array(",", ";", "*", "?"), array(")|(", ")|(", ".*", "."), $attachments_regexp);
							$attachments_regexp = "/^((" . $attachments_regexp . "))$/i";
  						if (preg_match($attachments_regexp, $filename_check)) {
								if (is_dir($sub_attachments_dir.$attachments_dir)) {
									$messages[$msg_id]["attachment-allowed"] = true;
									$filename = $messages[$msg_id]["filename"];

									// check for available name for filename
									$new_filename = $filename;
									$file_index = 0;
									while (file_exists($sub_attachments_dir.$attachments_dir . $new_filename)) {
										$file_index++;
										$delimiter_pos = strpos($filename, ".");
										if($delimiter_pos) {
											$new_filename = substr($filename, 0, $delimiter_pos) . "_" . $file_index . substr($filename, $delimiter_pos);
										} else {
											$new_filename = $index . "_" . $filename;
										}
									}
			          
									$filepath = $attachments_dir . $new_filename;
									$messages[$msg_id]["filepath"] = $filepath;
									$fa = fopen($sub_attachments_dir.$filepath, 'w');
								} else {
									// bad directory for attachments 
									$recipients     = $settings["admin_email"];
									$mail_subject   = "auto: ViArt SHOP Notification";
									$email_headers = array();
									$email_headers["from"] = $settings["admin_email"];
									$email_headers["Auto-Submitted"] = "auto-generated";
									$email_headers["Content-Type"] = "text/plain";
									
									$message  = "Directory for HelpDesk attachments cannot be found: ";
									$message .= "'" . $sub_attachments_dir.$attachments_dir . "'" . $eol;
	              
									va_mail($recipients, $mail_subject, $message, $email_headers);
								}
							}
						}
					}
				}

			} else {
				if (preg_match("/^(\w[\w\-]*):(.*)$/", $line, $matches)) {
					$name = strtolower($matches[1]);
					$value = $matches[2];
				} else {
					$value = $line;
				}
				if (isset($message_headers[$name])) {
					$message_headers[$name] .= "\n".$value;
				} else {
					$message_headers[$name] = $value;
				}
			}
		} else {
			if (trim($line) == $boundary || trim($line) == "--" . $boundary || trim($line) == "--".$boundary."--") {
				if ($messages[$msg_id]["attachment"]) {
					if ($messages[$msg_id]["attachment-allowed"]) {
						fclose($fa);
						chmod($sub_attachments_dir.$messages[$msg_id]["filepath"], 0755);
					}
				}
				$msg_id++;
				$message_headers = array();
				$header_received = false;
				if (trim($line) == "--".$boundary."--") {
					$is_boundary = false;
					if ($is_sub_boundary) {
						return;
					}
				}
			} else {
				if ($messages[$msg_id]["attachment"]) {
					if ($messages[$msg_id]["attachment-allowed"]) {
						if ($messages[$msg_id]["encoding"] == "base64") { 
							$line = base64_decode($line);
						} else if ($messages[$msg_id]["encoding"] == "quoted-printable") {
							$line = quoted_printable_decode($line);
						}
						fputs ($fa, $line);
						/*
						if ($messages[$msg_id]["content-type-value"] == "text/html" && $messages[$msg_id]["filename"] == "message.html") {
							$messages[$msg_id]["body"] .= $line;
						}//*/
					} 
				} else {
					if ($messages[$msg_id]["encoding"] == "base64") { 
						$line = base64_decode($line);
					} else if ($messages[$msg_id]["encoding"] == "quoted-printable") {
						$line = quoted_printable_decode($line);
					}
					$line = convert_to_utf8($line, $messages[$msg_id]["charset"]);
					$messages[$msg_id]["body"] .= $line;
				}
			}
		}
	}
}

function decode_mail_header(&$message, &$sub_charset, $charset) 
{
	if (preg_match("/=\?([\w\d\-]+)\?(\w)\?(.*)\?=/i", $message, $matches)) {
		$sub_charset = $matches[1];
		$encode_type = $matches[2];
		$message = $matches[3];
		if (strtoupper($encode_type) == "Q") {
			$message = quoted_printable_decode($message);
		} else if (strtoupper($encode_type) == "B") {
			$message = base64_decode($message);
		}
	}
	if ($sub_charset) {
		$message = convert_to_utf8($message, $sub_charset);
	} else {
		$message = convert_to_utf8($message, $charset);
	}

	return $message;
}

?>