<?php
/*
  ****************************************************************************
  ***                                                                      ***
  ***      ViArt Shop 5                                                    ***
  ***      File:  tabs_functions.php                                       ***
  ***      Built: Tue May 31 05:41:09 2016                                 ***
  ***      http://www.viart.com                                            ***
  ***                                                                      ***
  ****************************************************************************
*/


function parse_tabs($tabs, $current_tab = "", $default_class = "tab", $tabs_in_row = 0)
{
	global $t;
	$tab_row = 0; $tab_number = 0; $active_tab = false;
	if (!strlen($current_tab)) {
		$current_tab = get_param("tab");
		if (!strlen($current_tab)) { 
			foreach ($tabs as $tab_name => $tab_info) {
				$tab_show = isset($tab_info["show"]) ? $tab_info["show"] : true;
				if ($tab_show) {
					$current_tab = $tab_name;
					break; 
				}
			}
		} 
	}

	$tab_row = 0; $tab_number = 0; $active_tab = false;
	foreach ($tabs as $tab_name => $tab_info) {
		$tab_title = $tab_info["title"];
		$tab_show = isset($tab_info["show"]) ? $tab_info["show"] : true;
		if ($tab_show) {
			$tab_number++;
			$t->set_var("tab_id", "tab_" . $tab_name);
			$t->set_var("tab_name", $tab_name);
			$t->set_var("tab_title", $tab_title);
			if ($tab_name == $current_tab) {
				$active_tab = true;
				$t->set_var("tab_class", "tab-active tabActive");
				$t->set_var($tab_name . "_style", "display: block;");
				$t->set_var($tab_name . "_class", "tab-show");
			} else {
				$t->set_var("tab_class", $default_class);
				$t->set_var($tab_name . "_style", "display: none;");
				$t->set_var($tab_name . "_class", "tab-hide");
			}
			$t->parse("tabs", true);
			if ($tabs_in_row && $tab_number % $tabs_in_row == 0) {
				$tab_row++;
				$t->set_var("row_id", "tab_row_" . $tab_row);
				if ($active_tab) {
					$t->rparse("tabs_rows", true);
				} else {
					$t->parse("tabs_rows", true);
				}
				$t->set_var("tabs", "");
			}
		} else {
			// hide all related blocks in case if tab hidden
			$t->set_var($tab_name . "_style", "display: none;");
			$t->set_var($tab_name . "_class", "tab-hide");
		}
	}
	if ($tabs_in_row && $tab_number % $tabs_in_row != 0) {
		$tab_row++;
		$t->set_var("row_id", "tab_row_" . $tab_row);
		if ($active_tab) {
			$t->rparse("tabs_rows", true);
		} else {
			$t->parse("tabs_rows", true);
		}
	}
	$t->set_var("current_tab", $current_tab);
	$t->set_var("tab", $current_tab);
}

?>