// check key press events
document.onkeyup = function(evt) {
	evt = evt || window.event;
	docKeyUp(evt.keyCode);
};


function reloadBlock(pbId, htmlId, pbType)
{
	var url = "block.php?ajax=1&pb_id=" + encodeURIComponent(pbId);
	if (pbType) { url += "&pb_type=" + encodeURIComponent(pbType); }
	if (!htmlId) { htmlId = "pb_"+pbId; }
	callAjax(url, replaceBlock, htmlId);
}

function replaceBlock(blockContent, blockId)
{
	var oldBlockObj = document.getElementById(blockId);
	var parentObj = oldBlockObj.parentNode;
	var divObj = document.createElement('div'); 
	divObj.innerHTML = blockContent.trim(); 
	var newBlockObj = divObj.firstChild;
	parentObj.replaceChild(newBlockObj, oldBlockObj);
	if (newBlockObj.tagName == "LI") {
		vaNavLi(newBlockObj);
	} else {
		// check expand objects
		var jsObjs = newBlockObj.querySelectorAll("[data-js='expand']");
		for (var j = 0; j < jsObjs.length; j++) {
			vaExpandParse(jsObjs[j]);
		}
	}
	vaStopSpin(blockId);
}

function showMessageBlock(msgType, msgText, controlId)
{
	// delete popup block if it was initialized before
	hideMessageBlock();

	var controlObj = document.getElementById(controlId);
	var pageSize = getPageSize()
	var popupObj = document.createElement("div");
	popupObj.id = "messageBlock";
	if (msgType == "error") {
		popupObj.className = "errorbg";
	} else {
		popupObj.className = "messagebg";
	}

	popupObj.style.zIndex = "999";
	popupObj.style.position = "absolute";
	popupObj.style.border = "1px solid #CED7DF";
	popupObj.style.background= "#FFFFFF";
	popupObj.style.padding = "5px";
	popupObj.style.width = "300px";
	popupObj.style.whiteSpace = "normal";
	popupObj.style.textAlign = "left";
	popupObj.style.cursor = "pointer";
	popupObj.onclick = function() { hideMessageBlock(); };

	if (controlObj) {
		var msgLeft = findPosX(controlObj);
		var msgTop = findPosY(controlObj, true);
		popupObj.style.left = msgLeft+"px";
		popupObj.style.top  = msgTop+"px";
	} else {
		popupObj.style.left = pageSize[0]/2 - 150 + "px";
		popupObj.style.top  = pageSize[1]/2 - 20 + "px";
	}

	popupObj.innerHTML = msgText;
	document.body.insertBefore(popupObj, document.body.firstChild);
}

function showPopupBlock(msgText)
{
	// delete popup block if it was initialized before
	hidePopupBlock();

	var pageSize = getPageSize()
	var popupObj = document.createElement("div");
	popupObj.id = "popupBlock";
	popupObj.className = "popupBlock";
	popupObj.style.zIndex = "111";
	popupObj.style.position = "absolute";
	popupObj.style.left = "0px";
	popupObj.style.top = "0px";
	popupObj.style.backgroundColor = "rgba(0, 0, 0, 0.6)";
	popupObj.innerHTML = msgText;
	document.body.insertBefore(popupObj, document.body.firstChild);
	// check size for shadow background
	var fullSize = getPageSizeWithScroll();
	popupObj.style.width = fullSize[0]+"px";
	popupObj.style.height = fullSize[1]+"px";

	// move frame to the center
	var popupFrame = document.getElementById("popupFrame");
	var frameWidth = popupFrame.offsetWidth;
	var frameHeight = popupFrame.offsetHeight
	var frameLeft = (pageSize[0] - frameWidth)/2;
	var frameTop = (pageSize[1] - frameHeight)/2;
	if (frameLeft < 0) { frameLeft = 0; }
	if (frameTop < 0) { frameTop = 0; }
	// if page was scrolled move popup window to scrolled height
	if (document.body.scrollTop) { frameTop += document.body.scrollTop; }

	popupFrame.style.left = frameLeft + "px";
	popupFrame.style.top = frameTop + "px";

}

function hidePopupBlock()
{
	var popupObj = document.getElementById("popupBlock");
	if (popupObj) {
		var parentObj = popupObj.parentNode;
		parentObj.removeChild(popupObj);
	}
}


function hideMessageBlock()
{
	var messageObj = document.getElementById("messageBlock");
	if (messageObj) {
		var parentObj = messageObj.parentNode;
		parentObj.removeChild(messageObj);
	}
}


function docKeyUp(keyCode)
{
	if (keyCode == 27) {
		var messageObj = document.getElementById("messageBlock");
		var popupObj = document.getElementById("popupBlock");
		if (messageObj) {
			var parentObj = messageObj.parentNode;
			parentObj.removeChild(messageObj);
		} else if (popupObj) {
			var parentObj = popupObj.parentNode;
			parentObj.removeChild(popupObj);
		}
		// 
		var blackCloudObj = document.getElementById("black_cloud");
		if (blackCloudObj ) {
			hideBlack();
		}
	}
}