var userAgent = navigator.userAgent.toLowerCase();
var isIE = ((userAgent.indexOf("msie") != -1) && (userAgent.indexOf("opera") == -1) && (userAgent.indexOf("webtv") == -1));
var vaNavActive = [];

function findPosX(obj, addWidth)
{
	var curleft=0;
	if(addWidth){
		curleft+=obj.offsetWidth;
	}
	if(obj.offsetParent){
		while(obj.offsetParent){
			curleft+=obj.offsetLeft
			obj=obj.offsetParent;
		}
	}else if(obj.x){
		curleft += obj.x;
	}
	return curleft;
}

function findPosY(obj, addHeight)
{
	var curtop = 0;
	if (addHeight) {
		curtop += obj.offsetHeight;
	}
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		}
	}else if(obj.y) {
		curtop += obj.y;
	}
	return curtop;
}

function getMousePos(e) 
{
	var posX = 0;
	var posY = 0;
	if (!e) var e = window.event;
	if (e.pageX || e.pageY) {
		posX = e.pageX;
		posY = e.pageY;
	}	else if (e.clientX || e.clientY) 	{
		posX = e.clientX + document.body.scrollLeft
			+ document.documentElement.scrollLeft;
		posY = e.clientY + document.body.scrollTop
			+ document.documentElement.scrollTop;
	}
	var mousePos = new Array(posX, posY);
	return mousePos;
}

function getPageSize(){
  var w = 0, h = 0;
  if (window.innerWidth) { //Non-IE
    w = window.innerWidth;
    h = window.innerHeight;
  } else if (document.documentElement && (document.documentElement.clientWidth || document.documentElement.clientHeight)) {
    //IE 6+ in 'standards compliant mode'
    w = document.documentElement.clientWidth;
    h = document.documentElement.clientHeight;
  } else if ( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
    w = document.body.clientWidth;
    h = document.body.clientHeight;
  }

	var pageSize= new Array(w, h);    
	return pageSize;
}

function getPageSizeWithScroll()
{
	var xWithScroll = 0; var yWithScroll = 0; 
	if (document.body.scrollHeight > document.body.offsetHeight) { // all but Explorer Mac         
		yWithScroll = document.body.scrollHeight;         
		xWithScroll = document.body.scrollWidth;     
	} else { // works in Explorer 6 Strict, Mozilla (not FF) and Safari         
		yWithScroll = document.body.offsetHeight;         
		xWithScroll = document.body.offsetWidth;       
	}     

	var arrayPageSizeWithScroll = new Array(xWithScroll,yWithScroll);    
	return arrayPageSizeWithScroll; 
} 

function getScroll()
{
	var w = window.pageXOffset ||
		document.body.scrollLeft ||
		document.documentElement.scrollLeft;
	var h = window.pageYOffset ||
		document.body.scrollTop ||
		document.documentElement.scrollTop;
	var arrayScroll = new Array(w, h);    
	return arrayScroll;
}

// function to show more filter options
function popupBlock(linkName, blockName, imageName)
{                              	
	var linkObj = document.getElementById(linkName);
	var blockObj = document.getElementById(blockName);
	var imageObj = document.getElementById(imageName);

	if (blockObj.style.display == "none" || blockObj.style.display == "") {
		//blockObj.style.left = findPosX(linkObj, 0) + "px";
		//blockObj.style.top = findPosY(linkObj, 1) + "px";
		blockObj.style.display = "block";
		if (imageObj) {
			imageObj.src = "images/icons/minus_small.gif";
		}
	} else {
		blockObj.style.display = "none";
		if (imageObj) {
			imageObj.src = "images/icons/plus_small.gif";
		}
	}
}

function openPopup(pageUrl, width, height){
	var scrollbars="yes";
	var popupWin = window.open(pageUrl,'popupWin','toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=' + scrollbars + ',resizable=yes,width=' + width + ',height=' + height);
	popupWin.focus();
	return false;
}

function toggleMenu(){
	var headerBlock=document.getElementsByClassName("bk-header");
	var menuObj=headerBlock[0].getElementsByClassName("menu");
	var icoObj=headerBlock[0].getElementsByClassName("ico-menu");
	if (menuObj) {
		menuObj=menuObj[0];	
		icoObj=icoObj[0];	
		if (menuObj.style.display==""||menuObj.style.display=="none") {
			menuObj.style.display="block";
			icoObj.className="ico-menu ico-close";
		} else {
			menuObj.style.display="none";
			icoObj.className="ico-menu";
		}
	}
}

function expandBody(expandObj){
	var headObj = expandObj.parentNode;
	var blockObj = headObj.parentNode;
	var bodyObj = blockObj.getElementsByClassName("body")[0];
	if (expandObj.className == "expand") {
		headObj.className = "head head-open";
		expandObj.className = "expand expand-open";
		bodyObj.className = "body body-open";
	} else {
		headObj.className = "head";
		expandObj.className = "expand";
		bodyObj.className = "body";
	}

}

function vaInit()
{
	var jsObjs = document.querySelectorAll("[data-js]");
	for (var j = 0; j < jsObjs.length; j++) {
		var jsObj = jsObjs[j];
		var jsValue = jsObj.getAttribute("data-js").toLowerCase();
		var jsType = jsObj.hasAttribute("data-js-type") ? jsObj.getAttribute("data-js-type").toLowerCase() : "";
		if (jsValue == "nav" || jsValue == "navigation") {
			// add javascript to li > a elements
			vaNavParse(jsObj, jsType, 0);
		} else if (jsValue == "subscribe") {
			vaSubscribeParse(jsObj);
		} else if (jsValue == "expand") {
			vaExpandParse(jsObj, jsType);
		} else if (jsValue == "select") {
			vaSelectParse(jsObj);
			//vaExpandParse(jsObj);
		} else if (jsValue == "tree") {
			vaTreeParse(jsObj);
		} else if (jsValue == "tabs") {
			vaTabsParse(jsObj);
		}
	}
}

function vaParentJS(childElement)
{
	var parentObj = childElement; 
	var hasDataJS = parentObj.hasAttribute("data-js");
	while (!hasDataJS && parentObj) {
		parentObj = parentObj.parentNode;
		if (parentObj && parentObj.hasAttribute) { hasDataJS = parentObj.hasAttribute("data-js"); }
	}
	return parentObj;
}

function vaParentLI(liObj)
{
	var parentObj = liObj; 
	var tagName = parentObj.tagName;
	while (tagName != "LI" && parentObj) {
		parentObj = parentObj.parentNode;
		if (parentObj && parentObj.tagName) { tagName = parentObj.tagName; }
	}
	return parentObj;
}

function vaNavParse(parentUl, jsType, level)
{
	//var liObjs = ul.querySelectorAll(":scope > li"); // doesn't work in old browsers
	var liObjs = parentUl.childNodes;
	for (var l = 0; l < liObjs.length; l++) {	
 		var liObj = liObjs[l];
		if (liObj.nodeType == 1 && liObj.tagName == "LI") {
			// add event to li tag if it has ul child element
			var childUl = liObj.querySelector("ul");
			var liJsType = liObj.hasAttribute("data-js-type") ? liObj.getAttribute("data-js-type") : jsType;
			if (childUl) {
				var className = liObj.className;
				var regStopJs = /js-stop|stop-js/g;
				var regNoJs = /js-no|no-js/g;
				liObj.setAttribute("data-level", level);
				if (!regNoJs.test(className) && !liObj.jsAdded) {
					if (liJsType == "click") {
						liObj.addEventListener("click", function (event) { vaNavClick(this, event); }, false);
						// disable A tag click
						var childA = liObj.querySelector("a");
						if (childA) { childA.onclick = function() { return false; }; }
					} else {
						liObj.addEventListener("mouseover", function () { vaNavOver(this); }, false);
						liObj.addEventListener("mouseout", function () { vaNavOut(this); }, false);

						var expandObj = liObj.querySelector(".expand");
						expandObj.addEventListener("click", function (event) { vaNavClick(this, event); }, false);
					}
					liObj.jsAdded = true; // exclude double adding events
				}
				if (!regStopJs.test(className)) {
					vaNavParse(childUl, liJsType, (level + 1));
				}
			} else if (liJsType == "click") {
				// for last list element call onclick event to call stopPropagation
				//liObj.addEventListener("click", function (event) { vaNavClick(this, event); }, false);
				liObj.addEventListener("click", function (event) { event.stopPropagation(); }, false);
			}
		}
	}
}
function vaNavLi(liObj)
{
	// calculate level and check js type
	var dataLevel = 0; var jsType = "";
	var parentObj = liObj; 
	var hasDataJS = parentObj.hasAttribute("data-js");
	if (liObj.hasAttribute("data-js-type")) { jsType = liObj.getAttribute("data-js-type"); }
	while (!hasDataJS && parentObj) {
		parentObj = parentObj.parentNode;
		if (parentObj && parentObj.hasAttribute) { hasDataJS = parentObj.hasAttribute("data-js"); }
		if (parentObj.tagName == "LI") { dataLevel++; }
		if (jsType == "" && parentObj.hasAttribute("data-js-type")) { jsType = parentObj.getAttribute("data-js-type"); }
	}

	liObj.setAttribute("data-level", dataLevel);
	if (jsType == "click") {
		liObj.addEventListener("click", function (event) { vaNavClick(this, event); }, false);
		// disable A tag click
		var childA = liObj.querySelector("a");
		if (childA) { childA.onclick = function() { return false; }; }
	} else if (jsType == "hover") {
		liObj.addEventListener("mouseover", function () { vaNavOver(this); }, false);
		liObj.addEventListener("mouseout", function () { vaNavOut(this); }, false);
	}
}

function vaNavOver(liObj)
{
	// check for expand mode
	var parentUL = vaParentJS(liObj);
	var regExp = /expand-open/g;
	if (parentUL && parentUL.className && regExp.test(parentUL.className)) {
		// for expand mode don't use over effect
		return;
	}
	var level = liObj.getAttribute("data-level");
	if (vaNavActive[level] && vaNavActive[level].obj != liObj) {
		vaNavHide(level);
	} 
	var childUl = liObj.querySelector("ul");
	childUl.style.display = "block";
	var className = liObj.className;
	regExp = /nav-open/g;
	if (!regExp.test(className)) {
		liObj.className = (className + " nav-open").trim();
		// add nav-open to parent ul element
		var parentUl = liObj.parentNode;
		className = parentUl.className;
		parentUl.className = (className + " nav-open").trim();
	}
	if (vaNavActive[level]) {
		clearTimeout(vaNavActive[level].tid);
	}
	vaNavActive[level] = {"obj": liObj, "tid": null};
}

function vaNavOut(liObj)
{
	// check for expand mode
	var parentUL = vaParentJS(liObj);
	var regExp = /expand-open/g;
	if (parentUL && parentUL.className && regExp.test(parentUL.className)) {
		// for expand mode don't use over effect
		return;
	}
	var level = liObj.getAttribute("data-level");
	var tid = setTimeout(function() { vaNavHide(level); }, 1000);
	if (vaNavActive[level]) {
		// if event was run save tid for it
		vaNavActive[level].tid = tid;
	}
}

function vaNavClick(liObj, event)
{
	liObj = vaParentLI(liObj); 
	var className = liObj.className;
	var level = liObj.getAttribute("data-level");
	var childUl = liObj.querySelector("ul");
	if (!childUl) {
		// it the last element clicked so just ignore this click and call stopPropagation() so parent element doesn't close menu
		event.stopPropagation();
		return;
	}
	if (childUl.style.display && childUl.style.display == "block") {
		vaNavHide(level);
	} else {
		if (vaNavActive[level] && vaNavActive[level].obj != liObj) {
			vaNavHide(level);
		} 
		childUl.style.display = "block";
		var regExp = /nav-open/g;
		if (!regExp.test(className)) {
			liObj.className = (className + " nav-open").trim();
			// add nav-open to parent ul element
			var parentUl = liObj.parentNode;
			className = parentUl.className;
			parentUl.className = (className + " nav-open").trim();
		}
		vaNavActive[level] = {"obj": liObj, "tid": null};
		event.stopPropagation();
	}

}

function vaNavHide(level)
{
	for (var m = (vaNavActive.length - 1); m >= level; m--) {
		if (vaNavActive[m].tid) { clearTimeout(vaNavActive[m].tid); }
		var liObj = vaNavActive[m].obj;
		vaNavActive.pop();
		var childUl = liObj.querySelector("ul");
		childUl.style.display = "none";
		var className = liObj.className.replace(/nav-open/gi, "").trim();
		liObj.className = className;
		// remove nav-open from parent ul element
		var parentUl = liObj.parentNode;
		className = parentUl.className.replace(/nav-open/gi, "").trim();
		parentUl.className = className;
	}
}



function vaSubscribeParse(block)
{
	var field = block.querySelector("input[type=text]");
	field.addEventListener("keyup", function (e) { vaSubscribeField(e); }, false);
	var buttons = block.querySelectorAll("input[type=button]");
	for (var b = 0; b < buttons.length; b++) {
		buttons[b].addEventListener("click", function () { vaSubscribeButton(this); }, false);
	}
}

function vaSubscribeField(e)
{
	if (e.keyCode == 13) {
		var field = e.target;
		vaSubscribeEmail(field);
	}
}

function vaSubscribeButton(buttonObj)
{
	var parentObj = vaParentJS(buttonObj);
	var field = parentObj.querySelector("input[type=text]");
	vaSubscribeEmail(field);
}

function vaSubscribeEmail(field)
{
	var parentObj = vaParentJS(field);
	var errorBlock = parentObj.querySelector(".error-block");
	if (errorBlock) { errorBlock.style.display = "none"; }
	var successBlock = parentObj.querySelector(".success-block");
	if (successBlock) { successBlock.style.display = "none"; }
	var url = "ajax_subscribe.php?ajax=1&operation=subscribe&email=" + encodeURIComponent(field.value);
	callAjax(url, vaSubscribeResult, field);
}

function vaSubscribeResult(response, field)
{
	var data = JSON.parse(response);
	var parentObj = vaParentJS(field);
	var msgBlock = null;
	if (data.result == "error") {
		msgBlock = parentObj.querySelector(".error-block");
	} else {
		msgBlock = parentObj.querySelector(".success-block");
	}
	if (msgBlock) {
		msgBlock.style.display = "block";
		msgBlock.onclick = function() { this.style.display = "none" ;};
		var msgObj = msgBlock.querySelector(".message");
		if (msgObj) { msgObj.innerHTML = data.message; }
	}
}

function vaExpandParse(block, jsType)
{
	var links = block.querySelectorAll(".expand-link");
	if (links && links.length > 0) {
		for (var l = 0; l < links.length; l++) {
			if (jsType == "hover") {
				links[l].addEventListener("mouseover", function () { vaExpand(this, 'open'); }, false);
				links[l].addEventListener("mouseout", function () { vaExpand(this, 'hide'); }, false);
			} else {
				links[l].addEventListener("click", function () { vaExpand(this); }, false);
			}
		}
	} else {
		if (jsType == "hover") {
			block.addEventListener("mouseover", function () { vaExpand(this, 'open'); }, false);
			block.addEventListener("mouseout", function () { vaExpand(this, 'hide'); }, false);
		} else {
			block.addEventListener("click", function () { vaExpand(this); }, false);
		}
	}
}

function vaSelectParse(block)
{
	vaExpandParse(block);
	// add events to each option
	var options = block.querySelectorAll("[data-type='option']");
	if (options && options.length > 0) {
		for (var o = 0; o < options.length; o++) {
			options[o].addEventListener("click", function () { vaSelectOption(this); }, false);
		}
	} 
}

function vaTreeParse(parentUl)
{
	//var liObjs = ul.querySelectorAll(":scope > li"); // doesn't work in old browsers
	var liObjs = parentUl.childNodes;
	for (var l = 0; l < liObjs.length; l++) {	
 		var liObj = liObjs[l];
		if (liObj.nodeType == 1 && liObj.tagName == "LI") {
			// add event to li tag if it has ul child element or marked with nav-childs class
			var childUl = liObj.querySelector("ul");
			var className = liObj.className;
			var regExp = /childs/gi;
			var expandObj = liObj.querySelector(".expand");
			if ((childUl || regExp.test(liObj.className)) && expandObj) {
				expandObj.addEventListener("click", function (event) { vaTreeClick(this); }, false);
			}
			if (childUl) {
				vaTreeParse(childUl);
			}
		}
	}
}

function vaTreeClick(expandObj)
{
	var liObj = vaParentLI(expandObj); 
	var parentUL = vaParentJS(liObj);
	var id = liObj.getAttribute("data-id");
	var childUl = liObj.querySelector("ul");
	var regExp = /node-open/g;
	if (!regExp.test(liObj.className)) {
		liObj.className = (liObj.className + " node-open").trim();
		if (!childUl) {
			var url;
			if (parentUL.hasAttribute("data-script")) {
				url = parentUL.getAttribute("data-script");
			} else {
				url = "block.php";
			}
			url += "?ajax=1&id="+encodeURIComponent(id);
			if (parentUL.hasAttribute("data-pb-id")) {
				url += "&pb_id="+encodeURIComponent(parentUL.getAttribute("data-pb-id"));
			}
			if (parentUL.hasAttribute("data-type")) {
				url += "&type="+encodeURIComponent(parentUL.getAttribute("data-type"));
			}
			vaSpin(liObj.id); // show loading progress
			callAjax(url, vaTreeLoaded, liObj.id);
		}

	} else {
		liObj.className = liObj.className.replace(/node-open/gi, "").trim();
	}
}

function vaTreeLoaded(treeHTML, treeId)
{
	vaStopSpin(treeId);
	var treeObj= document.getElementById(treeId);
	treeObj.innerHTML += treeHTML;
	// add events to loaded tree elements
	var expandObj = treeObj.querySelector(".expand");
	if (expandObj) {
		expandObj.addEventListener("click", function (event) { vaTreeClick(this); }, false);
	}
	var childUl = treeObj.querySelector("ul");
	if (childUl) {
		vaTreeParse(childUl);
	}
}

function vaExpand(linkObj, expandType) 
{
	var expandObj = "";
	var parentObj = vaParentJS(linkObj);
	var jsType = parentObj.getAttribute("data-js").toLowerCase();
	if (jsType == "select") {
		expandObj = parentObj.querySelector("[data-type='options']");
	} else if (parentObj.hasAttribute("data-tag")) {
		var tagName = parentObj.getAttribute("data-tag");
		expandObj = parentObj.querySelector(tagName);
		if (!expandObj) {
			// try one level up
			var upParentObj = parentObj.parentNode;
			expandObj = upParentObj.querySelector(tagName);
		}
	} else if (parentObj.hasAttribute("data-class")) {
		var objClass = parentObj.getAttribute("data-class");
		expandObj = parentObj.querySelector("."+objClass);
		if (!expandObj) {
			// try one level up
			var upParentObj = parentObj.parentNode;
			expandObj = upParentObj.querySelector("."+objClass);
		}
	} else if (parentObj.hasAttribute("data-id")) {
		var objId = parentObj.getAttribute("data-id")
		expandObj = document.getElementById(objId);
	}
	if (expandObj) {
		// expand object found could open or close it
		var regExp = /expand-open/g;
		if (!expandType) {
			expandType = (regExp.test(expandObj.className)) ? "hide" : "open";
		}
		if (expandType== "open") {
			expandObj.className = (expandObj.className + " expand-open").trim();
			parentObj.className = (parentObj.className + " expand-open").trim();
		} else {
			expandObj.className = expandObj.className.replace(/expand-open/gi, "").trim();
			parentObj.className = parentObj.className.replace(/expand-open/gi, "").trim();
		}
	}
}

function vaSelectOption(optionObj)
{
	var parentObj = vaParentJS(optionObj);
	var formName = parentObj.getAttribute("data-form");
	var inputName = parentObj.getAttribute("data-input");
	var optionValue = optionObj.getAttribute("data-value");
	var optionDesc = optionObj.hasAttribute("data-desc") ? optionObj.getAttribute("data-desc") : optionObj.innerHTML;
	document.forms[formName].elements[inputName].value = optionValue;
	// check and call bind events
	var changeEvent = document.createEvent('Event');
	changeEvent.initEvent("change", false, true);
	document.forms[formName].elements[inputName].dispatchEvent(changeEvent);

	var selectedObj = parentObj.querySelector("[data-type='selected']");
	if (selectedObj) {
		selectedObj.innerHTML = optionDesc;
	}
}

function vaTabsParse(parentUL)
{
	// check active tab element
	var tabActive = ""; var formObj = ""; var tabData = "";
	var parentBlock = parentUL.parentNode;
	if (parentUL.hasAttribute("data-form")) {
		var formObj = document.forms[parentUL.getAttribute("data-form")];
		if (formObj) {
			if (formObj.tab) {
				tabActive = formObj.tab.value;
			} else {
				var tabObj = document.createElement("input");
				tabObj.type = "hidden";
				tabObj.name = "tab";
				formObj.appendChild(tabObj);
			}
		} else {
			parentUL.removeAttribute("data-form");
		}
	} 
	if (!parentUL.hasAttribute("data-form")) {
		tabActive = parentUL.hasAttribute("data-tab-active") ? parentUL.getAttribute("data-tab-active") : "";
	}
	var liObjs = parentUL.childNodes;
	for (var l = 0; l < liObjs.length; l++) {	
 		var liObj = liObjs[l];
		if (liObj.nodeType == 1 && liObj.tagName == "LI") {
			var tabName = liObj.getAttribute("data-tab");
			if (tabActive == "") { tabActive = tabName; }
			liObj.addEventListener("click", function () { vaTab(this); }, false);
			var aObj = liObj.querySelector("a");
			if (aObj) { aObj.onclick = function() { return false; }; }
			if (tabName == tabActive) {
				var regExp = /tab-active/g;
				if (!regExp.test(liObj.className)) {
					liObj.className = (liObj.className + " tab-active").trim();
				}
				tabData = document.getElementById(tabName+"_data");
				if (!tabData) { tabData = parentBlock.querySelector("."+tabName); }
				tabData.className = tabData.className.replace(/tab-show|tab-hide/gi, "").trim();
				tabData.className = (tabData.className + " tab-show").trim();
			} else {
				liObj.className = liObj.className.replace(/tab-active/gi, "").trim();
				tabData = document.getElementById(tabName+"_data");
				if (!tabData) { tabData = parentBlock.querySelector("."+tabName); }
				tabData.className = tabData.className.replace(/tab-show|tab-hide/gi, "").trim();
				tabData.className = (tabData.className + " tab-hide").trim();
			}
		}
	}
	if (formObj) {
		formObj.tab.value = tabActive;
	} else {
		parentUL.setAttribute("data-tab-active", tabActive);
	}
}

function vaTab(tabObj)
{
	var parentUL = vaParentJS(tabObj); 
	var parentBlock = parentUL.parentNode;
	var tabCurrent = ""; var formObj;
	if (parentUL.hasAttribute("data-form")) {
		formObj = document.forms[parentUL.getAttribute("data-form")];
		tabCurrent = formObj.tab.value;
	} else {
		tabCurrent = parentUL.getAttribute("data-tab-active");
	}
	var tabActive = tabObj.getAttribute("data-tab");
	if (tabActive == tabCurrent) { return false; }
	// update tabs
	var liObjs = parentUL.querySelectorAll("li")
	for (var l = 0; l < liObjs.length; l++) {	
 		var liObj = liObjs[l];
		var tabName = liObj.getAttribute("data-tab");
		if (tabName == tabActive) {
			var regExp = /tab-active/g;
			if (!regExp.test(liObj.className)) {
				liObj.className = (liObj.className + " tab-active").trim();
			}
		} else {
			liObj.className = liObj.className.replace(/tab-active/gi, "").trim();
		}
	}
	// hide old tab data
	var tabData = document.getElementById(tabCurrent+"_data");
	if (!tabData) { tabData = parentBlock.querySelector("."+tabCurrent); }
	tabData.className = tabData.className.replace(/tab-show|tab-hide/gi, "").trim();
	tabData.className = (tabData.className + " tab-hide").trim();
	// show new tab data
	tabData = document.getElementById(tabActive+"_data");
	if (!tabData) { tabData = parentBlock.querySelector("."+tabActive); }
	tabData.className = tabData.className.replace(/tab-show|tab-hide/gi, "").trim();
	tabData.className = (tabData.className + " tab-show").trim();
	// set new active tab
	if (formObj) {
		formObj.tab.value = tabActive;
	} else {
		parentUL.setAttribute("data-tab-active", tabActive);
	}
}


function vaSpin(parentObjId, someFunction, someParams)
{
	var parentObj = document.getElementById(parentObjId);
	var xPos = findPosX(parentObj);
	var yPos = findPosY(parentObj);
	var blockWidth = parentObj.offsetWidth;
	if (blockWidth == 0) { blockWidth = parseInt(window.getComputedStyle(parentObj,null).getPropertyValue("width")); }
	if (!blockWidth) { blockHeight = 100; }
	var blockHeight = parentObj.offsetHeight;
	if (blockHeight == 0) { blockHeight = parseInt(window.getComputedStyle(parentObj,null).getPropertyValue("height")); }
	if (!blockHeight) { blockHeight = 100; }

	// set relative position for parent object to set shadow and show progress
	parentObj.style.position = "relative";

	var shadowObj = document.createElement("div");
	shadowObj.id = "pb_shadow_" + parentObjId;
	shadowObj.style.zIndex = "999";
	shadowObj.style.position = "absolute";
	shadowObj.style.backgroundColor = "rgba(127,127,127,0.3)";
	shadowObj.style.textAlign = "center";
	shadowObj.style.left = "0";
	shadowObj.style.top  = "0";
	shadowObj.style.right = "0";
	shadowObj.style.bottom = "0";
	shadowObj.style.fontSize = "48px"; 
	/*
	shadowObj.style.width = blockWidth + "px";
	shadowObj.style.height = blockHeight + "px";//*/
	shadowObj.onclick    = function() { vaStopSpin(parentObjId, someFunction, someParams); };
	parentObj.insertBefore(shadowObj, parentObj.firstChild);

	var spinHeight = 16;
	if (blockHeight >= 40 && blockHeight <= 100) {
		spinHeight = Math.round(blockHeight / 2);
	} else if (blockHeight > 100) {
		spinHeight = Math.round(blockHeight / 4);
	}
	var spinObj = document.createElement("i");
	spinObj.className = "spin";
	spinObj.style.zIndex = "1000";
	spinObj.style.fontSize = spinHeight + "px";
	spinObj.style.position = "absolute";
	spinObj.style.left = Math.round((blockWidth-spinHeight)/2) + "px";
	spinObj.style.top  = Math.round((blockHeight-spinHeight)/2) + "px";
	shadowObj.appendChild(spinObj);
}

function vaStopSpin(parentObjId, someFunction, someParams)
{
	var parentObj = document.getElementById(parentObjId);
	if (parentObj) {
		var shadowObj = document.getElementById("pb_shadow_" + parentObjId);
		if (shadowObj) {
			parentObj.removeChild(shadowObj);
		}
	}
	if (someFunction) {
		someFunction(someParams);
	}
}


window.addEventListener("load", vaInit, false);