var speed = 20,
	defaultSpeed = 1, // specify slider scroll speed (larger is faster 1-10) 
	defaultDelay = 5000, // number in milliseconds 5000 - 5 seconds to show slide
	defaultDuration = 1000, // number in milliseconds 1000 - 1 second to change slides
	defaultNavType = 1, // navigator type for slider 1 - circles, 2 - page numbers, 3 - prev & next navigation
	defaultNavPos = "cb", // center bottom - default navigator position
	sliderSpeed = new Array(), 
	sliderOptions = new Array();

function initBlocks()
{
	var blockCode = "", sliderType = "", 
		transitionDelay = defaultDelay, transitionDuration = defaultDuration,
		navType = defaultNavType, navPos = defaultNavPos,
		foundBlocks = document.getElementsByName("block");
	for (var b = 0; b < foundBlocks.length; b++) {
		var formObj = foundBlocks[b],
			pbId = formObj.pb_id.value;
		if (formObj.block_code) {
			blockCode = formObj.block_code.value;
		}
		if (formObj.slider_type) {
			sliderType = formObj.slider_type.value;
		}
		// check transition delay
		if (formObj.transition_delay) {
			var delayParam = formObj.transition_delay.value;
			if (delayParam.match(/ms$/)) {
				transitionDelay = parseInt(delayParam.replace("ms", ""));
			} else {
				transitionDelay = parseInt(delayParam.replace("s", "")) * 1000;
			}
			if (isNaN(transitionDelay)) { transitionDelay = defaultDelay ; }
		}
		// check transition duration 
		if (formObj.transition_duration) {
			var durationParam = formObj.transition_duration.value;
			if (durationParam.match(/ms$/)) {
				transitionDuration = parseInt(durationParam.replace("ms", ""));
			} else {
				transitionDuration = parseInt(durationParam.replace("s", "")) * 1000;
			}
			if (isNaN(transitionDuration)) { transitionDuration = defaultDuration; }
		}
		// check navigation type
		if (formObj.nav_type && formObj.nav_type.value) {
			navType = formObj.nav_type.value;
			if (isNaN(navType)) { navType = defaultNavType; }
		}
		// check navigation position
		if (formObj.nav_pos && formObj.nav_pos.value) {
			navPos = formObj.nav_pos.value;
		}
	
		if (sliderType >= 1 && sliderType <= 4) {
			initSlider(pbId, sliderType, transitionDelay, transitionDuration, navType, navPos);
		} else if (sliderType == 5) {
			initSlider(pbId, sliderType, transitionDelay, transitionDuration, navType, navPos);
		}
	}
}

function initSlider(pbId, sliderType, transitionDelay, transitionDuration, navType, navPos)
{
	if (sliderType >= 1 && sliderType <= 4) {
		// create copy of block content
		var dataObj = document.getElementById("data_" + pbId),
			parentObj = dataObj.parentNode,
			dataTotalRecords = getCustomAttributeValue(dataObj, "data-total-records");
  
		parentObj.style.width = parentObj.offsetWidth+"px";
		parentObj.style.height = parentObj.offsetHeight+"px";
  
		dataObj.style.position = "absolute";
		dataObj.style.left = "0px";
		dataObj.style.top = "0px";

		//do not add any behavior if element is only one
		if(dataTotalRecords == 1) {return;}

		// create duplicate content to show slider 
		var secondObj = dataObj.cloneNode(true);
		secondObj.setAttribute("id", "second_data_" + pbId)	
		secondObj.style.position = "absolute";
		if (sliderType == 1) {
			secondObj.style.top = dataObj.offsetHeight + "px";
			secondObj.style.height = dataObj.offsetHeight + "px";		
		} else if (sliderType == 2) {
			secondObj.style.left = dataObj.offsetWidth + "px";
			secondObj.style.width = dataObj.offsetWidth + "px";		
		} else if (sliderType == 3) {
			secondObj.style.top = -dataObj.offsetHeight + "px";
			secondObj.style.height = dataObj.offsetHeight + "px";		
		} else if (sliderType == 4) {
			secondObj.style.left = -dataObj.offsetWidth + "px";
			secondObj.style.width = dataObj.offsetWidth + "px";		
		}
		parentObj.insertBefore(secondObj, dataObj.nextSibling);

		if (parentObj.attachEvent)	{
			parentObj.attachEvent('onmouseover', function (){ sliderSpeed[pbId] = 0;});
			parentObj.attachEvent('onmouseout', function (){ sliderSpeed[pbId] = defaultSpeed;});
		} else {
			parentObj.onmouseover = function (){ sliderSpeed[pbId] = 0; }; 
			parentObj.onmouseout = function (){ sliderSpeed[pbId] = defaultSpeed; };
		}
  
		sliderSpeed[pbId] = defaultSpeed;
		setTimeout("moveSlider("+pbId+","+sliderType+")", 500);
	} else if (sliderType == 5) {
		sliderOptions[pbId] = new Array();
		sliderOptions[pbId]["curItemId"] = 1;
		sliderOptions[pbId]["transitionDelay"] = transitionDelay;
		sliderOptions[pbId]["transitionDuration"] = transitionDuration;
		// check current object to set width and height for parent
		var curObj = document.getElementById("data_"+pbId+"_1");
		if (curObj) {
			var parentObj = curObj.parentNode;
			var parentWidth = parentObj.offsetWidth;
			var parentHeight = parentObj.offsetHeight;
			var containerObj = parentObj.parentNode;
			var containerWidth = containerObj.offsetWidth
			var containerHeight = containerObj.offsetHeight
			parentObj.style.width = containerWidth+"px";
			parentObj.style.height = containerHeight+"px";
		}

		// check maxId
		var itemObj = document.getElementById("data_" + pbId + "_1");
		var maxItemId = 1;
		do {
			sliderOptions[pbId]["maxItemId"] = maxItemId;
			maxItemId++;
			itemObj = document.getElementById("data_" + pbId + "_" + maxItemId);
		} while (itemObj);
		var totalSlides = maxItemId - 1;
		// add navigation buttons
		addSliderNavigation(pbId, totalSlides, navType, navPos);
		// activate slide show 
		sliderOptions[pbId]["function"] = setTimeout("slideShow("+pbId+")", sliderOptions[pbId]["transitionDelay"]);
	}
}

function addSliderNavigation(pbId, totalSlides, navType, navPos)
{
	var slideObj, parentObj = document.getElementById("pb_" + pbId);
	if (navType == 2) {
		var navObj = document.createElement("div");
		navObj.id = "slider-nav-"+pbId;
		navObj.className = "slider-nav pos-"+navPos;
		parentObj.appendChild(navObj);
		for (var s = 1; s <= totalSlides; s++) {
			var slideObj = document.createElement("a");
			slideObj.id = "slider-"+pbId+"-"+s;
			slideObj.setAttribute("data-slide", s);
			if (s == 1) {
				slideObj.className = "slide-number slide-active";
			} else {
				slideObj.className = "slide-number";
			}
			slideObj.onclick = function () { activateSlide(pbId, this); return false; };
			if (s < 10) {
				slideObj.innerHTML = "0"+s;
			} else {
				slideObj.innerHTML = s;
			}
			navObj.appendChild(slideObj);
		}
	} else {
		var maxLeft = parentObj.offsetWidth - 32;
		var maxTop = parentObj.offsetHeight - 32;
  
		// next link
		var aObj = document.createElement('a');
		aObj.id = "next_" + pbId;
		aObj.href = "#";
		aObj.onclick = function () { nextSlide(pbId); return false; };
		parentObj.appendChild(aObj);
  
		var imgObj = document.createElement('img');
		imgObj.src = "images/icons/slider-next.png";
		imgObj.border = "0";
		imgObj.style.position = "absolute";
		imgObj.style.left = maxLeft + "px";
		imgObj.style.top = maxTop + "px";
		aObj.appendChild(imgObj);
  
		// play link
		//maxLeft = maxLeft - 25;
		maxLeft = maxLeft - 32;
		aObj = document.createElement('a');
		aObj.id = "play_" + pbId;
		aObj.href = "#";
		aObj.onclick = function () { playSlideShow(pbId); return false; };
		aObj.style.display = "none";
		parentObj.appendChild(aObj);
  
		imgObj = document.createElement('img');
		imgObj.src = "images/icons/slider-play.png";
		imgObj.border = "0";
		imgObj.style.position = "absolute";
		imgObj.style.left = maxLeft + "px";
		imgObj.style.top = maxTop + "px";
		aObj.appendChild(imgObj);
  
		// pause link
		aObj = document.createElement('a');
		aObj.id = "pause_" + pbId;
		aObj.href = "#";
		aObj.onclick = function () { pauseSlideShow(pbId); return false; };
		parentObj.appendChild(aObj);
  
		imgObj = document.createElement('img');
		imgObj.src = "images/icons/slider-pause.png";
		imgObj.border = "0";
		imgObj.style.position = "absolute";
		imgObj.style.left = maxLeft + "px";
		imgObj.style.top = maxTop + "px";
		aObj.appendChild(imgObj);
  
		// prev link
		maxLeft = maxLeft - 32;
		aObj = document.createElement('a');
		aObj.id = "prev_" + pbId;
		aObj.href = "#";
		aObj.onclick = function () { prevSlide(pbId); return false; };
		parentObj.appendChild(aObj);
  
		imgObj = document.createElement('img');
		imgObj.src = "images/icons/slider-prev.png";
		imgObj.border = "0";
		imgObj.style.position = "absolute";
		imgObj.style.left = maxLeft + "px";
		imgObj.style.top = maxTop + "px";
		aObj.appendChild(imgObj);
	}
}

function changeObjects(pbId)
{
	var curObj = sliderOptions[pbId]["curObj"];
	var newObj = sliderOptions[pbId]["newObj"];
	var step = sliderOptions[pbId]["step"];
	var transitionDuration = sliderOptions[pbId]["transitionDuration"];
	var changeTimeout = Math.ceil(transitionDuration / 100);

	if (step == 100) {
		curObj.style.position = "absolute";
		newObj.style.position = "absolute";
		newObj.style.display = "block";
		// check navigator to change
		var curId = sliderOptions[pbId]["curItemId"];
		var curNavObj = document.getElementById("slider-"+pbId+"-"+curId);
		if (curNavObj && curNavObj.className) {
			curNavObj.className = curNavObj.className.replace(/slide-active/gi, "").trim();
		}
		var newId = sliderOptions[pbId]["newItemId"];
		var newNavObj = document.getElementById("slider-"+pbId+"-"+newId);
		if (newNavObj) {
			var className = newNavObj.className;
			var regExp = /slide-active/g;
			if (!regExp.test(className)) {
				newNavObj.className = (className + " slide-active").trim();
			}
		}
	}
	curObj.style.opacity = step/100;
	newObj.style.opacity = (100-step)/100;

	// decrease step number
	step = step - 1;
	sliderOptions[pbId]["step"] = step;
	if (step > 0) {
		sliderOptions[pbId]["change"] = setTimeout("changeObjects("+pbId+")", changeTimeout);
	} else {
		curObj.style.display = "none";
		newObj.style.display = "block";
		// remove opacity 
		curObj.style.opacity = "";
		newObj.style.opacity = "";

		sliderOptions[pbId]["curItemId"] = sliderOptions[pbId]["newItemId"];;

		var sliderType = sliderOptions[pbId]["sliderType"];
		if (sliderOptions[pbId]["transitionDelay"] > 0) {
			clearTimeout(sliderOptions[pbId]["change"]);
			sliderOptions[pbId]["function"] = setTimeout("slideShow("+pbId+")", sliderOptions[pbId]["transitionDelay"]);
		}
	}
}

function activateSlide(pbId, slideObj)
{
	clearTimeout(sliderOptions[pbId]["function"]);
	clearTimeout(sliderOptions[pbId]["change"]);
	var slideNumber = slideObj.getAttribute("data-slide");
	var curItemId = sliderOptions[pbId]["curItemId"];
	var newId = sliderOptions[pbId]["newItemId"];
	// check navigator to change
	var newNavObj = document.getElementById("slider-"+pbId+"-"+newId);
	if (newNavObj && newNavObj.className) {
		newNavObj.className = newNavObj.className.replace(/slide-active/gi, "").trim();
	}
	slideShow(pbId, slideNumber - curItemId);
}

function slideShow(pbId, increment)
{
	//if (increment != 1 && increment != -1) { increment = 1; }
	if (!increment || isNaN(increment)) { increment = 1; }
	var curItemId = sliderOptions[pbId]["curItemId"];
	var curObj = document.getElementById("data_" + pbId + "_" + curItemId);
	var maxItemId = sliderOptions[pbId]["maxItemId"];
	var newItemId = curItemId + increment;
	if (newItemId > maxItemId) { newItemId = 1; }
	if (newItemId < 1) { newItemId = maxItemId; }
	var newObj = document.getElementById("data_" + pbId + "_" + newItemId);
	if (!newObj && curItemId > 1) {
		if (increment == 1) {
			newItemId = 1;
		} else if (increment == -1) {
			newItemId = sliderOptions[pbId]["maxItemId"];
		}
		newObj = document.getElementById("data_" + pbId + "_" + newItemId);
	}
	if (newObj) {
		sliderOptions[pbId]["curObj"] = curObj;
		sliderOptions[pbId]["newObj"] = newObj;
		sliderOptions[pbId]["newItemId"] = newItemId;
		sliderOptions[pbId]["step"] = 100;
		sliderOptions[pbId]["change"] = setTimeout("changeObjects("+pbId+")", 20);
	}
}

function nextSlide(pbId)
{
	if (sliderOptions[pbId]["function"]) {
		clearTimeout(sliderOptions[pbId]["function"]);
	}
	slideShow(pbId);
}

function prevSlide(pbId)
{
	if (sliderOptions[pbId]["function"]) {
		clearTimeout(sliderOptions[pbId]["function"]);
	}
	slideShow(pbId, -1);
}


function playSlideShow(pbId)
{
	var playObj = document.getElementById("play_" + pbId);
	var pauseObj = document.getElementById("pause_" + pbId);
	playObj.style.display = "none";
	pauseObj.style.display = "inline";

	if (sliderOptions[pbId]["function"]) {
		clearTimeout(sliderOptions[pbId]["function"]);
	}
	sliderOptions[pbId]["transitionDelay"] = defaultDelay;
	sliderOptions[pbId]["function"] = setTimeout("slideShow("+pbId+")", sliderOptions[pbId]["transitionDelay"]);
}

function pauseSlideShow(pbId)
{
	var playObj = document.getElementById("play_" + pbId);
	var pauseObj = document.getElementById("pause_" + pbId);
	playObj.style.display = "inline";
	pauseObj.style.display = "none";

	sliderOptions[pbId]["transitionDelay"] = 0;
	if (sliderOptions[pbId]["function"]) {
		clearTimeout(sliderOptions[pbId]["function"]);
	}
}


function moveSlider(pbId, sliderType)
{
	var dataObj = document.getElementById("data_" + pbId);
	var secondObj = document.getElementById("second_data_" + pbId);

	var sliderWidth = dataObj.offsetWidth;
	var sliderHeight = dataObj.offsetHeight;

	if (sliderType == 1) {
		if (parseInt(dataObj.style.top) > (sliderHeight*(-1)+8)) 	//if slider hasn't reached the end of its height
			dataObj.style.top = parseInt(dataObj.style.top) - sliderSpeed[pbId]+"px" 	// move slider up
		else
			dataObj.style.top = parseInt(secondObj.style.top) + sliderHeight+"px"	 // reset to original position
		
		if (parseInt(secondObj.style.top) > (sliderHeight*(-1)+8))
			secondObj.style.top = parseInt(secondObj.style.top) - sliderSpeed[pbId] +"px"
		else
			secondObj.style.top = parseInt(dataObj.style.top) + sliderHeight+"px"
	} else if (sliderType == 2) {
		if (parseInt(dataObj.style.left) > (sliderWidth*(-1)+8))	 	// if slider hasn't reached the end of its width
			dataObj.style.left = parseInt(dataObj.style.left) - sliderSpeed[pbId] +"px"	 // move slider left
		else
			dataObj.style.left = parseInt(secondObj.style.left) + sliderWidth+"px"	// reset to original position
		
		if (parseInt(secondObj.style.left) > (sliderWidth*(-1)+8))
			secondObj.style.left = parseInt(secondObj.style.left) - sliderSpeed[pbId] +"px"
		else
			secondObj.style.left = parseInt(dataObj.style.left) + sliderWidth+"px"
	} else if (sliderType == 3) {
		if (parseInt(dataObj.style.top) < (sliderHeight + 8)) 	//if slider hasn't reached the end of its height
			dataObj.style.top = parseInt(dataObj.style.top) + sliderSpeed[pbId]+"px" 	// move slider up
		else
			dataObj.style.top = parseInt(secondObj.style.top) - sliderHeight+"px"	 // reset to original position
		
		if (parseInt(secondObj.style.top) < (sliderHeight +8))
			secondObj.style.top = parseInt(secondObj.style.top) + sliderSpeed[pbId] +"px"
		else
			secondObj.style.top = parseInt(dataObj.style.top) - sliderHeight+"px"
	} else if (sliderType == 4) {
		if (parseInt(dataObj.style.left) < (sliderWidth +8))	 	// if slider hasn't reached the end of its width
			dataObj.style.left = parseInt(dataObj.style.left) + sliderSpeed[pbId] +"px"	 // move slider left
		else
			dataObj.style.left = parseInt(secondObj.style.left) - sliderWidth+"px"	// reset to original position
		
		if (parseInt(secondObj.style.left) < (sliderWidth + 8))
			secondObj.style.left = parseInt(secondObj.style.left) + sliderSpeed[pbId] +"px"
		else
			secondObj.style.left = parseInt(dataObj.style.left) - sliderWidth+"px"
	}

	setTimeout("moveSlider("+pbId+","+sliderType+")", 30);
}

window.addEventListener("load", initBlocks, false);

function getCustomAttributeValue(ele, attr)
{
    var result = (ele.getAttribute && ele.getAttribute(attr)) || null;
    if( !result ) {
        var attrs = ele.attributes;
        var length = attrs.length;
        for(var i = 0; i < length; i++)
            if(attrs[i].nodeName === attr)
                result = attrs[i].nodeValue;
    }
    return result;
}