/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.MessageDialog;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProgressBar;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class IJ {
    public static boolean debugMode;
    public static boolean hideProcessStackDialog;
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static String osname;
    private static boolean isMac;
    private static boolean isWin;
    private static boolean isJava2;
    private static boolean altDown;
    private static boolean spaceDown;
    private static boolean macroRunning;
    private static Thread previousThread;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imageJ, Applet applet) {
        ij = imageJ;
        IJ.applet = applet;
        progressBar = ij.getProgressBar();
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static Object runPlugIn(String string, String string2) {
        return IJ.runPlugIn("", string, string2);
    }

    static Object runPlugIn(String string, String string2, String string3) {
        if (!string2.startsWith("ij")) {
            boolean bl = IJ.altKeyDown();
            return ij.runUserPlugIn(string, string2, string3, bl);
        }
        Object var3_4 = null;
        try {
            Class<?> clazz = Class.forName(string2);
            var3_4 = clazz.newInstance();
            if (var3_4 instanceof PlugIn) {
                ((PlugIn)var3_4).run(string3);
            } else {
                ij.runFilterPlugIn(var3_4, string, string3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IJ.write("Plugin not found: " + string2);
        }
        catch (InstantiationException instantiationException) {
            IJ.write("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.write("Unable to load plugin (acc)");
        }
        return var3_4;
    }

    public static void doCommand(String string) {
        if (ij != null) {
            ij.doCommand(string);
        }
    }

    public static void run(String string) {
        Macro.abort = false;
        Macro.setOptions(null);
        macroRunning = true;
        Executer executer = new Executer(string);
        executer.run();
        macroRunning = false;
        IJ.testAbort();
    }

    public static void run(String string, String string2) {
        Object object;
        Macro.abort = false;
        Macro.setOptions(string2);
        Thread thread = Thread.currentThread();
        if ((previousThread == null || thread != previousThread) && ((String)(object = thread.getName())).indexOf("-macro") < 0) {
            thread.setName(String.valueOf(object) + "-macro");
        }
        previousThread = thread;
        macroRunning = true;
        object = new Executer(string);
        ((Executer)object).run();
        macroRunning = false;
        Macro.setOptions(null);
        IJ.testAbort();
    }

    private static void testAbort() {
        if (Macro.abort) {
            throw new RuntimeException("Macro canceled");
        }
    }

    public static boolean macroRunning() {
        return macroRunning;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String string) {
        if (ij != null) {
            ij.showStatus(string);
        }
    }

    public static void write(String string) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.append(string);
        } else {
            System.out.println(string);
        }
    }

    public static void setColumnHeadings(String string) {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        if (textPanel != null) {
            textPanel.setColumnHeadings(string);
        }
    }

    public static boolean isResultsWindow() {
        return textPanel != null;
    }

    public static TextPanel getTextPanel() {
        if (textPanel == null && ij != null) {
            ij.showResults();
        }
        return textPanel;
    }

    public static void setTextPanel(TextPanel textPanel) {
        IJ.textPanel = textPanel;
    }

    public static void noImage() {
        IJ.showMessage("No Image", "There are no images open.");
        Macro.abort();
    }

    public static void outOfMemory(String string) {
        IJ.write("<<" + string + ": out of memory>>");
        Macro.abort();
    }

    public static void showProgress(double d) {
        if (progressBar != null) {
            progressBar.show(d);
        }
    }

    public static void showMessage(String string, String string2) {
        if (ij != null) {
            new MessageDialog((Frame)ij, string, string2);
        } else {
            System.out.println(string2);
        }
    }

    public static void showMessage(String string) {
        IJ.showMessage("Message", string);
    }

    public static void error(String string) {
        if (ij != null) {
            new MessageDialog((Frame)ij, "ImageJ", string);
        } else {
            System.out.println(string);
        }
        Macro.abort();
    }

    public static boolean showMessageWithCancel(String string, String string2) {
        GenericDialog genericDialog = new GenericDialog(string);
        genericDialog.addMessage(string2);
        genericDialog.showDialog();
        return genericDialog.wasCanceled() ^ true;
    }

    public static double getNumber(String string, double d) {
        Frame frame = WindowManager.getCurrentWindow();
        if (frame == null) {
            frame = ij;
        }
        GenericDialog genericDialog = new GenericDialog("Enter a Number", frame);
        genericDialog.addNumericField(string, d, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return -2.147483648E9;
        }
        return genericDialog.getNextNumber();
    }

    public static String getString(String string, String string2) {
        Frame frame = WindowManager.getCurrentWindow();
        if (frame == null) {
            frame = ij;
        }
        GenericDialog genericDialog = new GenericDialog("Enter a String", frame);
        genericDialog.addStringField(string, string2, 20);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return "";
        }
        return genericDialog.getNextString();
    }

    public static synchronized void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return "Memory: " + (l2 - l) / 1024L + "K";
    }

    public static void showTime(ImagePlus imagePlus, long l, String string) {
        IJ.showTime(imagePlus, l, string, 1);
    }

    static void showTime(ImagePlus imagePlus, long l, String string, int n) {
        long l2 = System.currentTimeMillis() - l;
        double d = (double)l2 / 1000.0;
        long l3 = imagePlus.getWidth() * imagePlus.getHeight();
        int n2 = (int)((double)l3 * (double)n / d);
        String string2 = n2 > 1000000000 ? "" : (n2 < 1000000 ? ", " + n2 + " pixels/second" : ", " + IJ.d2s((double)n2 / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(String.valueOf(string) + d + " seconds" + string2);
    }

    public static String d2s(double d) {
        return IJ.d2s(d, 2);
    }

    public static String d2s(double d, int n) {
        boolean bl;
        if (d == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.round(d * Math.pow(10.0, n));
        double d3 = d2 / Math.pow(10.0, n);
        if (bl) {
            d3 = -d3;
        }
        if (n != dfDigits) {
            switch (n) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                    break;
                }
            }
        }
        String string = df.format(d3);
        return string;
    }

    public static void register(Class clazz) {
        if (ij != null) {
            ij.register(clazz);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    public static void setKeyDown(int n) {
        switch (n) {
            case 18: {
                altDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static void setKeyUp(int n) {
        switch (n) {
            case 18: {
                altDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow imageWindow = WindowManager.getCurrentWindow();
                if (imageWindow == null) break;
                imageWindow.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static boolean isJava2() {
        return isJava2;
    }

    public static boolean versionLessThan(String string) {
        boolean bl;
        boolean bl2 = bl = "1.27g".compareTo(string) < 0;
        if (bl) {
            IJ.error("This plugin requires ImageJ " + string + " or later.");
        }
        return bl;
    }

    public static int setupDialog(ImagePlus imagePlus, int n) {
        if (imagePlus == null || IJ.ij.hotkey || hideProcessStackDialog) {
            return n;
        }
        int n2 = imagePlus.getStackSize();
        if (n2 > 1) {
            String string = Macro.getOptions();
            if (string != null) {
                if (string.indexOf("stack ") >= 0) {
                    return n + 32;
                }
                return n;
            }
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + n2 + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (yesNoCancelDialog.cancelPressed()) {
                return 4096;
            }
            if (yesNoCancelDialog.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return n + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return n;
    }

    public static void makeRectangle(int n, int n2, int n3, int n4) {
        IJ.getImage().setRoi(n, n2, n3, n4);
    }

    public static void makeOval(int n, int n2, int n3, int n4) {
        ImagePlus imagePlus = IJ.getImage();
        IJ.getImage().setRoi(new OvalRoi(n, n2, n3, n4, imagePlus));
    }

    public static void makeLine(int n, int n2, int n3, int n4) {
        ImagePlus imagePlus = IJ.getImage();
        IJ.getImage().setRoi(new Line(n, n2, n3, n4, imagePlus));
    }

    public static void setMinAndMax(double d, double d2) {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().setMinAndMax(d, d2);
        imagePlus.updateAndDraw();
    }

    public static void setThreshold(double d, double d2) {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().setThreshold(d, d2, 0);
        imagePlus.updateAndDraw();
    }

    public static void resetThreshold() {
        ImagePlus imagePlus = IJ.getImage();
        imagePlus.getProcessor().resetThreshold();
        imagePlus.updateAndDraw();
    }

    public static void selectWindow(String string) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            ImagePlus imagePlus = WindowManager.getImage(nArray[n]);
            if (imagePlus != null && imagePlus.getTitle().equals(string)) {
                ImageWindow imageWindow = imagePlus.getWindow();
                if (imageWindow != null) {
                    imageWindow.toFront();
                    IJ.wait(50);
                    WindowManager.setCurrentWindow(imageWindow);
                }
                return;
            }
            ++n;
        }
    }

    public static void setForegroundColor(int n, int n2, int n3) {
        Toolbar.setForegroundColor(new Color(n, n2, n3));
    }

    public static void setBackgroundColor(int n, int n2, int n3) {
        Toolbar.setBackgroundColor(new Color(n, n2, n3));
    }

    public static void setTool(int n) {
        Toolbar.getInstance().setTool(n);
    }

    public static int doWand(int n, int n2) {
        ImagePlus imagePlus = IJ.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Wand wand = new Wand(imageProcessor);
        double d = imageProcessor.getMinThreshold();
        if (d == -808080.0) {
            wand.autoOutline(n, n2);
        } else {
            wand.autoOutline(n, n2, (int)d, (int)imageProcessor.getMaxThreshold());
        }
        if (wand.npoints > 0) {
            PolygonRoi polygonRoi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, imagePlus, 4);
            imagePlus.setRoi(polygonRoi);
        }
        return wand.npoints;
    }

    private static ImagePlus getImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            throw new RuntimeException("Macro canceled");
        }
        return imagePlus;
    }

    static {
        osname = System.getProperty("os.name");
        isWin = osname.startsWith("Windows");
        isMac = !isWin && osname.startsWith("Mac");
        isJava2 = System.getProperty("java.version").startsWith("1.1") ^ true;
        df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        dfDigits = 2;
    }
}

