/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener {
    public static final String VERSION = "1.27g";
    private static final String IJ_X = "ij.x";
    private static final String IJ_Y = "ij.y";
    private static final String RESULTS_X = "results.x";
    private static final String RESULTS_Y = "results.y";
    private static final String RESULTS_WIDTH = "results.width";
    private static final String RESULTS_HEIGHT = "results.height";
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private static PluginClassLoader classLoader;
    private boolean notVerified = true;
    boolean hotkey;

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("ImageJ");
        this.applet = applet;
        String err1 = Prefs.load(this, applet);
        Menus m = new Menus(this, applet);
        String err2 = m.addMenuBar();
        m.installPopupMenu(this);
        this.notVerified = true;
        this.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        this.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(Color.lightGray);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(100, 18);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        this.statusBar.setSize(this.toolbar.getPreferredSize());
        this.add(this.statusBar);
        IJ.init(this, applet);
        IJ.showStatus("Version 1.27g (" + Menus.nPlugins + " commands)");
        this.addKeyListener(this);
        this.addWindowListener(this);
        Point loc = this.getPreferredLocation();
        Dimension tbSize = this.toolbar.getPreferredSize();
        int ijWidth = tbSize.width + 10;
        int ijHeight = 100;
        ((Component)this).setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        ((Component)this).setBounds(loc.x, loc.y, ijWidth, ijHeight);
        ((Component)this).setLocation(loc.x, loc.y);
        this.pack();
        this.setResizable(false);
        ((Component)this).setVisible(true);
        if (IJ.isMacintosh() && IJ.isJava2()) {
            this.pack();
        }
        if (err1 != null) {
            IJ.error(err1);
        }
        if (err2 != null) {
            IJ.error(err2);
        }
        if (IJ.isMacintosh()) {
            IJ.runPlugIn("QuitHandler", "");
        }
    }

    void showResults() {
        TextWindow resultsWindow = new TextWindow("Results", "", 300, 200);
        TextPanel textPanel = resultsWindow.getTextPanel();
        textPanel.addKeyListener(this);
        IJ.setTextPanel(textPanel);
    }

    void setIcon() {
        URL url = this.getClass().getResource("/microscope.gif");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {}
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int windowWidth;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int ijX = Prefs.getInt(IJ_X, -99);
        int ijY = Prefs.getInt(IJ_Y, -99);
        if (ijX != -99 && ijY != -99 && ijX < screenWidth - 75) {
            return new Point(ijX, ijY);
        }
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = screenWidth > 832 ? 0.8 : 0.9;
        int windowX = (int)(percent * (double)(screenWidth - (windowWidth = tbsize.width + 10)));
        if (windowX < 10) {
            windowX = 10;
        }
        int windowY = 32;
        return new Point(windowX, windowY);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String name) {
        new Executer(name, WindowManager.getCurrentImage());
    }

    void wrongType(int capabilities) {
        String s = "This command requires an image of type:\n \n";
        if ((capabilities & 1) != 0) {
            s = String.valueOf(s) + "    8-bit grayscale\n";
        }
        if ((capabilities & 2) != 0) {
            s = String.valueOf(s) + "    8-bit color\n";
        }
        if ((capabilities & 4) != 0) {
            s = String.valueOf(s) + "    16-bit grayscale\n";
        }
        if ((capabilities & 8) != 0) {
            s = String.valueOf(s) + "    32-bit (float) grayscale\n";
        }
        if ((capabilities & 0x10) != 0) {
            s = String.valueOf(s) + "    RGB color\n";
        }
        IJ.error(s);
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        ImageWindow win;
        boolean doesStacks;
        ImagePlus imp = WindowManager.getCurrentImage();
        int capabilities = ((PlugInFilter)theFilter).setup(arg, imp);
        if ((capabilities & 0x1000) != 0) {
            return;
        }
        if ((capabilities & 0x200) != 0) {
            ((PlugInFilter)theFilter).run(null);
            return;
        }
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if ((capabilities & 0x400) != 0 && imp.getRoi() == null) {
            IJ.error("Selection required");
            return;
        }
        if ((capabilities & 0x800) != 0 && imp.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        int type = imp.getType();
        switch (type) {
            case 0: {
                if ((capabilities & 1) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 3: {
                if ((capabilities & 2) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 1: {
                if ((capabilities & 4) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 2: {
                if ((capabilities & 8) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 4: {
                if ((capabilities & 0x10) != 0) break;
                this.wrongType(capabilities);
                return;
            }
        }
        int slices = imp.getStackSize();
        boolean bl = doesStacks = (capabilities & 0x20) != 0;
        if (!imp.lock()) {
            return;
        }
        imp.startTiming();
        IJ.showStatus(String.valueOf(cmd) + "...");
        ImageStack stack = null;
        if (slices > 1) {
            stack = imp.getStack();
        }
        int[] mask = null;
        float[] cTable = imp.getCalibration().getCTable();
        if (slices == 1 || !doesStacks) {
            ImageProcessor ip = imp.getProcessor();
            mask = imp.getMask();
            if ((capabilities & 0x100) != 0) {
                Undo.reset();
            } else {
                Undo.setup(1, imp);
                ip.snapshot();
            }
            ip.setMask(mask);
            ip.setCalibrationTable(cTable);
            ((PlugInFilter)theFilter).run(ip);
            if ((capabilities & 0x40) != 0) {
                ip.reset(mask);
            }
            IJ.showTime(imp, imp.getStartTime(), String.valueOf(cmd) + ": ", 1);
        } else {
            boolean doMasking;
            Undo.reset();
            int n = stack.getSize();
            int currentSlice = imp.getCurrentSlice();
            Rectangle r = null;
            Roi roi = imp.getRoi();
            if (roi != null && roi.getType() < 5) {
                r = roi.getBoundingRect();
            }
            mask = imp.getMask();
            ImageProcessor ip = imp.getProcessor();
            double minThreshold = ip.getMinThreshold();
            double maxThreshold = ip.getMaxThreshold();
            ip = stack.getProcessor(1);
            ip.setLineWidth(Line.getWidth());
            boolean bl2 = doMasking = roi != null && roi.getType() != 0 && (capabilities & 0x40) != 0;
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            boolean doGarbageCollection = IJ.isWindows() && !IJ.isJava2();
            int i = 1;
            while (i <= n) {
                ip.setPixels(stack.getPixels(i));
                ip.setRoi(r);
                ip.setMask(mask);
                ip.setCalibrationTable(cTable);
                if (doMasking) {
                    ip.snapshot();
                }
                ((PlugInFilter)theFilter).run(ip);
                if (doMasking) {
                    ip.reset(mask);
                }
                if (doGarbageCollection && i % 10 == 0) {
                    System.gc();
                }
                IJ.showProgress((double)i / (double)n);
                ++i;
            }
            if (roi != null) {
                imp.setRoi(roi);
            }
            IJ.showProgress(1.0);
            IJ.showTime(imp, imp.getStartTime(), String.valueOf(cmd) + ": ", n);
        }
        if ((capabilities & 0x80) == 0) {
            imp.changes = true;
            imp.updateAndDraw();
        }
        if ((win = imp.getWindow()) != null) {
            win.running = false;
        }
        imp.unlock();
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        PluginClassLoader loader;
        if (this.applet != null) {
            return null;
        }
        String pluginsDir = Menus.getPlugInsPath();
        if (pluginsDir == null) {
            return null;
        }
        if (this.notVerified) {
            IJ.runPlugIn("ij.plugin.ClassChecker", "");
            this.notVerified = false;
        }
        if (createNewLoader) {
            loader = new PluginClassLoader(pluginsDir);
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(pluginsDir);
            }
            loader = classLoader;
        }
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else if (thePlugIn instanceof PlugInFilter) {
                this.runFilterPlugIn(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!className.equals("QuitHandler")) {
                IJ.error("Plugin not found: " + className);
            }
        }
        catch (InstantiationException instantiationException) {
            IJ.error("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException illegalAccessException) {
            IJ.error("Unable to load plugin (acc)");
        }
        return thePlugIn;
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = String.valueOf(s) + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = String.valueOf(s) + "Control ";
        }
        if ((flags & 4) != 0) {
            s = String.valueOf(s) + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = String.valueOf(s) + "Alt ";
        }
        s = String.valueOf(s) + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            this.hotkey = false;
            if (cmd != null) {
                this.doCommand(cmd);
            }
            if (IJ.debugMode) {
                IJ.write("actionPerformed: " + cmd);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.write("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Roi roi;
        boolean isStack;
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        this.hotkey = false;
        if (keyCode == 17 || keyCode == 16) {
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.write("keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ") keyChar=\"" + keyChar + "\" (" + keyChar + ") " + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        String c = "";
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u007f' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        Hashtable shortcuts = Menus.getShortcuts();
        c = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        if (c == null) {
            switch (keyCode) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    c = "Clear";
                    this.hotkey = true;
                    break;
                }
                case 61: 
                case 187: {
                    c = "Start Animation [=]";
                    break;
                }
                case 47: 
                case 191: {
                    c = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    c = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    c = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Roi roi2 = null;
                    if (imp != null) {
                        roi2 = imp.getRoi();
                    }
                    if (roi2 == null) {
                        return;
                    }
                    if ((flags & 8) != 0) {
                        roi2.nudgeCorner(keyCode);
                    } else {
                        roi2.nudge(keyCode);
                    }
                    return;
                }
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    ImageWindow win;
                    Toolbar.getInstance().selectTool(keyCode);
                    if (imp == null || (win = imp.getWindow()) == null) break;
                    ImageCanvas ic = win.getCanvas();
                    Point loc = ic.getCursorLoc();
                    if (loc.x <= 0 || loc.y <= 0) break;
                    ic.setCursor(loc.x, loc.y);
                    break;
                }
                case 27: {
                    if (imp != null) {
                        imp.getWindow().running = false;
                    }
                    Macro.abort();
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (c != null && !c.equals("")) {
            if (c.equals("Fill")) {
                this.hotkey = true;
            }
            this.doCommand(c);
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        boolean quit = true;
        if (Menus.window.getItemCount() > 5) {
            quit = IJ.showMessageWithCancel("ImageJ", "Are you sure you want to quit ImageJ?");
        }
        if (quit) {
            this.doCommand("Quit");
        }
    }

    public void windowActivated(WindowEvent e) {
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    public void quit() {
        if (this.applet == null) {
            Prefs.savePreferences();
        }
        if (!WindowManager.closeAllWindows()) {
            return;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void savePreferences(Properties prefs) {
        Point loc = this.getLocation();
        ((Hashtable)prefs).put(IJ_X, Integer.toString(loc.x));
        ((Hashtable)prefs).put(IJ_Y, Integer.toString(loc.y));
    }

    public static void main(String[] args) {
        new ImageJ(null);
    }
}

