/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Macro;
import ij.Menus;
import ij.gui.FreehandRoi;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Properties;

public class ImagePlus
implements ImageObserver,
Measurements {
    public static final int GRAY8 = 0;
    public static final int GRAY16 = 1;
    public static final int GRAY32 = 2;
    public static final int COLOR_256 = 3;
    public static final int COLOR_RGB = 4;
    public boolean changes;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public String unit = "pixel";
    public String units = "pixels";
    public boolean sCalibrated;
    protected Image img;
    protected ImageProcessor ip;
    protected ImageWindow win;
    private ImageJ ij = IJ.getInstance();
    private String title;
    private String url;
    private FileInfo fileInfo;
    protected int width;
    protected int height;
    private int imageType = 0;
    private ImageStack stack;
    private int currentSlice;
    private Roi roi;
    protected boolean locked = false;
    private static int currentID = -1;
    private int ID;
    private static Component comp;
    private boolean imageLoaded;
    private int imageUpdateY;
    private int imageUpdateW;
    private Properties properties;
    private long startTime;
    private Calibration calibration;
    private static Calibration globalCalibration;
    static int counter;
    private Rectangle maskRect;
    private int maskCount;
    private int[] pvalue = new int[4];

    public ImagePlus() {
        this.ID = --currentID;
        this.title = "null";
    }

    public ImagePlus(String title, Image img) {
        this.title = title;
        this.ID = --currentID;
        if (img != null) {
            this.setImage(img);
        }
    }

    public ImagePlus(String title, ImageProcessor ip) {
        this.setProcessor(title, ip);
        this.ID = --currentID;
    }

    public ImagePlus(String pathOrURL) {
        Opener opener = new Opener();
        ImagePlus imp = null;
        boolean isURL = pathOrURL.indexOf("://") > 0;
        imp = isURL ? opener.openURL(pathOrURL) : opener.openImage(pathOrURL);
        if (imp != null) {
            if (imp.getStackSize() > 1) {
                this.setStack(imp.getTitle(), imp.getStack());
            } else {
                this.setProcessor(imp.getTitle(), imp.getProcessor());
            }
            if (isURL) {
                this.url = pathOrURL;
            }
            this.ID = --currentID;
        }
    }

    public ImagePlus(String title, ImageStack stack) {
        this.setStack(title, stack);
        this.ID = --currentID;
    }

    public synchronized boolean lock() {
        if (this.locked) {
            IJ.beep();
            IJ.showStatus("\"" + this.title + "\" is locked");
            if (IJ.macroRunning()) {
                IJ.error("Image is locked");
                Macro.abort();
            }
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.write(String.valueOf(this.title) + ": lock");
        }
        return true;
    }

    public synchronized boolean lockSilently() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        if (IJ.debugMode) {
            IJ.write(String.valueOf(this.title) + ": lock silently");
        }
        return true;
    }

    public synchronized void unlock() {
        this.locked = false;
        if (IJ.debugMode) {
            IJ.write(String.valueOf(this.title) + ": unlock");
        }
    }

    private void waitForImage(Image img) {
        if (comp == null && (comp = IJ.getInstance()) == null) {
            comp = new Frame();
        }
        this.imageLoaded = false;
        if (!comp.prepareImage(img, this)) {
            while (!this.imageLoaded) {
                IJ.wait(50);
                if (this.imageUpdateW <= 1) continue;
                double progress = (double)this.imageUpdateY / (double)this.imageUpdateW;
                if (!(progress < 1.0) && (progress = 1.0 - (progress - 1.0)) < 0.0) {
                    progress = 0.9;
                }
                IJ.showProgress(progress);
            }
            IJ.showProgress(1.0);
        }
    }

    public void draw() {
        if (this.win != null) {
            this.win.getCanvas().repaint();
        }
    }

    public void draw(int x, int y, int width, int height) {
        if (this.win != null) {
            ImageCanvas ic = this.win.getCanvas();
            double mag = ic.getMagnification();
            x = ic.screenX(x);
            y = ic.screenY(y);
            width = (int)((double)width * mag);
            height = (int)((double)height * mag);
            ic.repaint(x, y, width, height);
        }
    }

    public void updateAndDraw() {
        if (this.ip != null) {
            if (this.win != null) {
                this.win.getCanvas().setImageUpdated();
            }
            this.draw();
        }
    }

    public void repaintWindow() {
        if (this.win != null) {
            this.draw();
            this.win.repaint();
        }
    }

    public void updateAndRepaintWindow() {
        if (this.win != null) {
            this.updateAndDraw();
            this.win.repaint();
        }
    }

    public void updateImage() {
        if (this.ip != null) {
            this.img = this.ip.createImage();
        }
    }

    public void hide() {
        if (this.win == null) {
            return;
        }
        boolean unlocked = this.lockSilently();
        this.changes = false;
        this.win.close();
        this.win = null;
        if (unlocked) {
            this.unlock();
        }
    }

    public void show() {
        this.show("");
    }

    public void show(String statusMessage) {
        if (this.win != null) {
            return;
        }
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        if (this.img != null && this.width >= 0 && this.height >= 0) {
            this.win = this.stack != null && this.stack.getSize() > 1 ? new StackWindow(this) : new ImageWindow(this);
            this.draw();
            IJ.showStatus(statusMessage);
        }
    }

    public Image getImage() {
        if (this.img == null && this.ip != null) {
            this.img = this.ip.createImage();
        }
        return this.img;
    }

    public int getID() {
        return this.ID;
    }

    public void setImage(Image img) {
        this.roi = null;
        this.waitForImage(img);
        this.img = img;
        int newWidth = img.getWidth(this.ij);
        int newHeight = img.getHeight(this.ij);
        boolean dimensionsChanged = newWidth != this.width || newHeight != this.height;
        this.width = newWidth;
        this.height = newHeight;
        this.ip = null;
        this.stack = null;
        LookUpTable lut = new LookUpTable(img);
        int type = lut.getMapSize() > 0 ? (lut.isGrayscale() ? 0 : 3) : 4;
        this.setType(type);
        if (this.win != null) {
            if (dimensionsChanged) {
                this.win = new ImageWindow(this);
            } else {
                this.repaintWindow();
            }
        }
    }

    public void setProcessor(String title, ImageProcessor ip) {
        if (this.stack != null && this.stack.getSize() < 2) {
            this.stack = null;
        }
        this.setProcessor2(title, ip);
    }

    void setProcessor2(String title, ImageProcessor ip) {
        boolean dimensionsChanged;
        int stackSize;
        if (title != null) {
            this.title = title;
        }
        this.ip = ip;
        if (this.ij != null) {
            ip.setProgressBar(this.ij.getProgressBar());
        }
        if (this.stack != null && (stackSize = this.stack.getSize()) < this.currentSlice) {
            this.currentSlice = 1;
        }
        this.img = ip.createImage();
        boolean bl = dimensionsChanged = this.width != ip.getWidth() || this.height != ip.getHeight();
        if (dimensionsChanged) {
            this.roi = null;
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ColorProcessor ? 4 : (ip instanceof ShortProcessor ? 1 : 2));
        if (this.width == 0) {
            this.imageType = type;
        } else {
            this.setType(type);
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (this.win != null) {
            if (dimensionsChanged) {
                this.win = new ImageWindow(this);
            } else {
                this.repaintWindow();
            }
        }
    }

    public void setStack(String title, ImageStack stack) {
        ImageProcessor ip;
        boolean resetCurrentSlice;
        boolean stackSizeChanged;
        int stackSize = stack.getSize();
        boolean bl = stackSizeChanged = this.stack != null && stackSize != this.getStackSize();
        if (this.currentSlice < 1) {
            this.currentSlice = 1;
        }
        boolean bl2 = resetCurrentSlice = this.currentSlice > stackSize;
        if (resetCurrentSlice) {
            this.currentSlice = 1;
        }
        boolean dimensionsChanged = this.width != (ip = stack.getProcessor(this.currentSlice)).getWidth() || this.height != ip.getHeight();
        this.stack = stack;
        this.setProcessor2(title, ip);
        if (stackSize > 1 && this.win != null && (!(this.win instanceof StackWindow) || resetCurrentSlice || dimensionsChanged)) {
            this.win = new StackWindow(this);
        } else if (this.win != null) {
            this.repaintWindow();
        }
    }

    public void setFileInfo(FileInfo fi) {
        fi.pixels = null;
        this.fileInfo = fi;
    }

    public ImageWindow getWindow() {
        return this.win;
    }

    public void setWindow(ImageWindow win) {
        this.win = win;
    }

    public void setColor(Color c) {
        if (this.ip != null) {
            this.ip.setColor(c);
        }
    }

    void setupProcessor() {
        if (this.imageType == 4) {
            if (this.ip == null || this.ip instanceof ByteProcessor) {
                this.ip = new ColorProcessor(this.img);
                if (IJ.debugMode) {
                    IJ.write(String.valueOf(this.title) + ": new ColorProcessor");
                }
            }
        } else if (this.ip == null || this.ip instanceof ColorProcessor) {
            this.ip = new ByteProcessor(this.img);
            if (IJ.debugMode) {
                IJ.write(String.valueOf(this.title) + ": new ByteProcessor");
            }
        }
        if (this.roi != null && this.roi.getType() < 5) {
            this.ip.setRoi(this.roi.getBoundingRect());
        } else {
            this.ip.setRoi(null);
        }
    }

    public boolean isProcessor() {
        return this.ip != null;
    }

    public ImageProcessor getProcessor() {
        if (this.ip == null && this.img == null) {
            return null;
        }
        this.setupProcessor();
        this.ip.setLineWidth(Line.getWidth());
        if (this.ij != null) {
            this.ip.setProgressBar(this.ij.getProgressBar());
        }
        return this.ip;
    }

    public synchronized void trimProcessor() {
        if (this.ip != null && !this.locked) {
            if (this.ip != null && IJ.debugMode) {
                IJ.write(String.valueOf(this.title) + ": trimProcessor");
            }
            this.ip.setPixels(this.ip.getPixels());
        }
    }

    public void killProcessor() {
    }

    public int[] getMask() {
        int[] mask = null;
        if (this.roi != null && this.roi.getType() < 5) {
            if (this.ip != null && (mask = this.ip.getMask()) != null) {
                Rectangle r = this.roi.getBoundingRect();
                if (this.maskRect == null || r.width != this.maskRect.width || r.height != this.maskRect.height) {
                    mask = null;
                }
                if (this.roi instanceof PolygonRoi) {
                    if (this.maskCount != ((PolygonRoi)this.roi).getNCoordinates()) {
                        mask = null;
                    }
                } else if (this.roi instanceof TextRoi) {
                    mask = null;
                }
            }
            if (mask == null) {
                mask = this.roi.getMask();
            }
        }
        if (this.ip != null) {
            if (this.roi != null) {
                this.ip.setRoi(this.roi.getBoundingRect());
                this.ip.setMask(mask);
                this.maskRect = this.roi.getBoundingRect();
                this.maskCount = this.roi instanceof PolygonRoi ? ((PolygonRoi)this.roi).getNCoordinates() : 0;
            } else {
                this.ip.setMask(null);
            }
        }
        return mask;
    }

    public ImageStatistics getStatistics() {
        return this.getStatistics(27);
    }

    public ImageStatistics getStatistics(int mOptions) {
        return this.getStatistics(mOptions, 256);
    }

    public ImageStatistics getStatistics(int mOptions, int nBins) {
        this.setupProcessor();
        this.ip.setMask(this.getMask());
        this.ip.setHistogramSize(nBins);
        ImageStatistics stats = ImageStatistics.getStatistics(this.ip, mOptions, this.getCalibration());
        this.ip.setHistogramSize(256);
        return stats;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String getShortTitle() {
        String title = this.getTitle();
        int index = title.indexOf(32);
        if (index > -1) {
            title = title.substring(0, index);
        }
        return title;
    }

    public void setTitle(String title) {
        if (this.win != null) {
            Menus.updateWindowMenuItem(this.title, title);
            this.win.setTitle(title);
        }
        this.title = title;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStackSize() {
        if (this.stack == null) {
            return 1;
        }
        int slices = this.stack.getSize();
        if (slices == 0) {
            slices = 1;
        }
        return slices;
    }

    public int getType() {
        return this.imageType;
    }

    protected void setType(int type) {
        if (type < 0 || type > 4) {
            return;
        }
        int previousType = this.imageType;
        this.imageType = type;
        boolean bl = this.win != null && this.imageType != previousType;
        Menus.updateMenus();
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        ((Hashtable)this.properties).put(key, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return ((Hashtable)this.properties).get(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public LookUpTable createLut() {
        if (this.img != null) {
            return new LookUpTable(this.img);
        }
        return null;
    }

    public boolean isInvertedLut() {
        if (this.ip == null) {
            if (this.img == null) {
                return false;
            }
            this.setupProcessor();
        }
        return this.ip.isInvertedLut();
    }

    public int[] getPixel(int x, int y) {
        this.pvalue[3] = 0;
        this.pvalue[2] = 0;
        this.pvalue[1] = 0;
        this.pvalue[0] = 0;
        if (this.img == null) {
            return this.pvalue;
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                int index;
                if (this.ip != null) {
                    index = this.ip.getPixel(x, y);
                } else {
                    PixelGrabber pg = new PixelGrabber(this.img, x, y, 1, 1, false);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        return this.pvalue;
                    }
                    byte[] pixels8 = (byte[])pg.getPixels();
                    int n = index = pixels8 != null ? pixels8[0] & 0xFF : 0;
                }
                if (this.imageType != 3) {
                    this.pvalue[0] = index;
                    return this.pvalue;
                }
                this.pvalue[3] = index;
            }
            case 4: {
                int[] pixels32 = new int[1];
                if (this.win == null) break;
                ImageCanvas ic = this.win.getCanvas();
                PixelGrabber pg = new PixelGrabber(this.img, x, y, 1, 1, pixels32, 0, this.width);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    return this.pvalue;
                }
                int c = pixels32[0];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                this.pvalue[0] = r;
                this.pvalue[1] = g;
                this.pvalue[2] = b;
                break;
            }
            case 1: 
            case 2: {
                if (this.ip == null) break;
                this.pvalue[0] = this.ip.getPixel(x, y);
                break;
            }
        }
        return this.pvalue;
    }

    public ImageStack createEmptyStack() {
        ColorModel cm = this.ip != null ? this.ip.getColorModel() : this.createLut().getColorModel();
        return new ImageStack(this.width, this.height, cm);
    }

    public ImageStack getStack() {
        ImageStack s;
        if (this.stack == null) {
            s = this.createEmptyStack();
            s.addSlice(null, this.getProcessor());
        } else {
            s = this.stack;
            if (this.ip != null) {
                s.update(this.ip);
            }
        }
        if (this.roi != null) {
            s.setRoi(this.roi.getBoundingRect());
        }
        return s;
    }

    public int getCurrentSlice() {
        if (this.currentSlice == 0) {
            return 1;
        }
        return this.currentSlice;
    }

    public void killStack() {
        this.stack = null;
        this.trimProcessor();
    }

    public synchronized void setSlice(int index) {
        if (this.stack == null || index == this.currentSlice) {
            this.updateAndRepaintWindow();
            return;
        }
        if (index >= 1 && index <= this.stack.getSize()) {
            Roi roi = this.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (this.isProcessor()) {
                this.stack.setPixels(this.ip.getPixels(), this.currentSlice);
            }
            this.ip = this.getProcessor();
            this.currentSlice = index;
            Object pixels = this.stack.getPixels(this.currentSlice);
            if (pixels != null) {
                this.ip.setPixels(pixels);
            }
            if (this.win != null && this.win instanceof StackWindow) {
                ((StackWindow)this.win).updateSliceSelector();
            }
            if (IJ.spaceBarDown() && (this.imageType == 1 || this.imageType == 2)) {
                this.ip.resetMinAndMax();
                IJ.showStatus(String.valueOf(index) + ": min=" + this.ip.getMin() + ", max=" + this.ip.getMax());
            }
            this.updateAndRepaintWindow();
        }
    }

    void undoFilter() {
        if (this.ip != null) {
            this.ip.reset();
            this.updateAndDraw();
        }
    }

    public Roi getRoi() {
        return this.roi;
    }

    public void setRoi(Roi roi) {
        this.killRoi();
        this.roi = roi;
        if (this.ip != null) {
            this.ip.setRoi(roi.getBoundingRect());
            this.ip.setMask(null);
        }
        this.roi.setImage(this);
        this.draw();
    }

    public void setRoi(int x, int y, int width, int height) {
        this.setRoi(new Rectangle(x, y, width, height));
    }

    public void setRoi(Rectangle r) {
        if (r == null) {
            this.killRoi();
            return;
        }
        this.killRoi();
        this.roi = new Roi(r.x, r.y, r.width, r.height, this);
        if (this.ip != null) {
            this.ip.setRoi(r);
            this.ip.setMask(null);
        }
        this.draw();
    }

    public void createNewRoi(int x, int y) {
        this.killRoi();
        switch (Toolbar.getToolId()) {
            case 0: {
                this.roi = new Roi(x, y, this);
                break;
            }
            case 1: {
                this.roi = new OvalRoi(x, y, this);
                break;
            }
            case 2: 
            case 5: {
                this.roi = new PolygonRoi(x, y, this);
                break;
            }
            case 3: 
            case 6: {
                this.roi = new FreehandRoi(x, y, this);
                break;
            }
            case 4: {
                this.roi = new Line(x, y, this);
                break;
            }
            case 9: {
                this.roi = new TextRoi(x, y, this);
                break;
            }
        }
    }

    public void killRoi() {
        if (this.roi != null) {
            this.saveRoi();
            this.roi = null;
            if (this.ip != null) {
                this.ip.setRoi(null);
            }
            this.draw();
        }
    }

    void saveRoi() {
        if (this.roi != null) {
            this.roi.endPaste();
            Rectangle r = this.roi.getBoundingRect();
            if (r.width > 0 && r.height > 0) {
                Roi.previousRoi = this.roi;
                if (IJ.debugMode) {
                    IJ.write("saveRoi: " + this.roi);
                }
            }
        }
    }

    public void restoreRoi() {
        if (Roi.previousRoi != null) {
            Roi pRoi = Roi.previousRoi;
            Rectangle r = pRoi.getBoundingRect();
            if (r.width <= this.width || r.height <= this.height) {
                this.roi = (Roi)pRoi.clone();
                this.roi.setImage(this);
                if (r.x + r.width > this.width || r.y + r.height > this.height) {
                    this.roi.setLocation((this.width - r.width) / 2, (this.height - r.height) / 2);
                }
                this.draw();
            }
        }
    }

    void revert() {
        if (this.getStackSize() > 1) {
            return;
        }
        if (this.roi != null) {
            this.roi.endPaste();
        }
        this.trimProcessor();
        FileInfo fi = this.getOriginalFileInfo();
        if (fi != null && fi.fileFormat != 0) {
            new FileOpener(fi).revertToSaved(this);
        } else if (this.url != null) {
            IJ.showStatus("Loading: " + this.url);
            Opener opener = new Opener();
            try {
                ImagePlus imp = opener.openURL(this.url);
                if (imp != null) {
                    this.setProcessor(imp.getTitle(), imp.getProcessor());
                }
            }
            catch (Exception exception) {}
            if (this.getType() == 4 && this.getTitle().endsWith(".jpg")) {
                Opener.convertGrayJpegTo8Bits(this);
            }
        }
        this.repaintWindow();
        IJ.showStatus("");
    }

    public FileInfo getFileInfo() {
        FileInfo fi = new FileInfo();
        fi.width = this.width;
        fi.height = this.height;
        fi.nImages = this.getStackSize();
        fi.whiteIsZero = this.isInvertedLut();
        fi.intelByteOrder = false;
        this.setupProcessor();
        fi.pixels = fi.nImages == 1 ? this.ip.getPixels() : this.stack.getImageArray();
        Calibration cal = this.getCalibration();
        if (cal.scaled()) {
            fi.pixelWidth = cal.pixelWidth;
            fi.pixelHeight = cal.pixelHeight;
            fi.unit = cal.getUnit();
        }
        if (fi.nImages > 1) {
            fi.pixelDepth = cal.pixelDepth;
        }
        fi.frameInterval = cal.frameInterval;
        if (cal.calibrated()) {
            fi.calibrationFunction = cal.getFunction();
            fi.coefficients = cal.getCoefficients();
            fi.valueUnit = cal.getValueUnit();
        }
        switch (this.imageType) {
            case 0: 
            case 3: {
                LookUpTable lut = this.createLut();
                fi.fileType = this.imageType == 3 || !lut.isGrayscale() ? 5 : 0;
                fi.lutSize = lut.getMapSize();
                fi.reds = lut.getReds();
                fi.greens = lut.getGreens();
                fi.blues = lut.getBlues();
                break;
            }
            case 1: {
                fi.fileType = 2;
                break;
            }
            case 2: {
                fi.fileType = 4;
                break;
            }
            case 4: {
                fi.fileType = 6;
                break;
            }
        }
        return fi;
    }

    public FileInfo getOriginalFileInfo() {
        return this.fileInfo;
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        this.imageUpdateY = y;
        this.imageUpdateW = w;
        this.imageLoaded = (flags & 0xB0) != 0;
        return this.imageLoaded ^ true;
    }

    public void flush() {
        Object[] arrays;
        if (this.locked) {
            return;
        }
        if (this.ip != null) {
            this.ip.setPixels(null);
            this.ip = null;
        }
        if (this.stack != null && (arrays = this.stack.getImageArray()) != null) {
            int i = 0;
            while (i < arrays.length) {
                arrays[i] = null;
                ++i;
            }
        }
        this.img = null;
        System.gc();
    }

    public ImagePlus createImagePlus() {
        ImagePlus imp2 = new ImagePlus();
        imp2.setCalibration(this.getCalibration());
        return imp2;
    }

    public void copyScale(ImagePlus imp) {
        if (imp != null && globalCalibration == null) {
            this.setCalibration(imp.getCalibration());
        }
    }

    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Calibration getCalibration() {
        if (globalCalibration != null) {
            return globalCalibration;
        }
        if (this.calibration == null) {
            this.calibration = new Calibration(this);
        }
        return this.calibration;
    }

    public void setCalibration(Calibration cal) {
        this.calibration = cal == null ? null : cal.copy();
    }

    public void setGlobalCalibration(Calibration global) {
        globalCalibration = global == null ? null : global.copy();
    }

    public void mouseMoved(int x, int y) {
        IJ.showStatus(String.valueOf(this.getLocationAsString(x, y)) + this.getValueAsString(x, y));
    }

    public String getLocationAsString(int x, int y) {
        Calibration cal = this.getCalibration();
        if (cal.scaled()) {
            return " x=" + IJ.d2s(cal.getX(x)) + " (" + x + ")" + ", y=" + IJ.d2s(cal.getY(y)) + " (" + y + ")";
        }
        return " x=" + x + ", y=" + y;
    }

    private String getValueAsString(int x, int y) {
        Calibration cal = this.getCalibration();
        int[] v = this.getPixel(x, y);
        switch (this.getType()) {
            case 0: 
            case 1: {
                double cValue = cal.getCValue(v[0]);
                if (cValue == (double)v[0]) {
                    return ", value=" + v[0];
                }
                return ", value=" + IJ.d2s(cValue) + " (" + v[0] + ")";
            }
            case 2: {
                return ", value=" + Float.intBitsToFloat(v[0]);
            }
            case 3: {
                return ", index=" + v[3] + ", value=" + v[0] + "," + v[1] + "," + v[2];
            }
            case 4: {
                return ", value=" + v[0] + "," + v[1] + "," + v[2];
            }
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + " " + this.width + "x" + this.height + "x" + this.getStackSize();
    }
}

