/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ImageStack {
    static final int INITIAL_SIZE = 25;
    static final String outOfRange = "Argument out of range: ";
    private int nSlices = 0;
    private Object[] stack;
    private String[] label;
    private int width;
    private int height;
    private Rectangle roi;
    private ColorModel cm;
    private double min = Double.MAX_VALUE;
    private double max;
    private static boolean msgShown;

    public ImageStack(int width, int height) {
        this(width, height, null);
    }

    public ImageStack(int width, int height, ColorModel cm) {
        this.width = width;
        this.height = height;
        this.cm = cm;
        this.stack = new Object[25];
        this.label = new String[25];
        this.nSlices = 0;
    }

    public void addSlice(String sliceLabel, Object pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.stack.length) {
            Object[] tmp1 = new Object[this.nSlices * 2];
            System.arraycopy(this.stack, 0, tmp1, 0, this.nSlices);
            this.stack = tmp1;
            String[] tmp2 = new String[this.nSlices * 2];
            System.arraycopy(this.label, 0, tmp2, 0, this.nSlices);
            this.label = tmp2;
        }
        this.stack[this.nSlices - 1] = pixels;
        this.label[this.nSlices - 1] = sliceLabel;
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
        this.addSlice(sliceLabel, pixels);
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
        if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        if (this.nSlices == 0) {
            this.cm = ip.getColorModel();
            this.min = ip.getMin();
            this.max = ip.getMax();
        }
        this.addSlice(sliceLabel, ip.getPixels());
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
        if (n < 0 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.addSlice(sliceLabel, ip);
        Object tempSlice = this.stack[this.nSlices - 1];
        String tempLabel = this.label[this.nSlices - 1];
        int first = n > 0 ? n : 1;
        int i = this.nSlices - 1;
        while (i >= first) {
            this.stack[i] = this.stack[i - 1];
            this.label[i] = this.label[i - 1];
            --i;
        }
        this.stack[n] = tempSlice;
        this.label[n] = tempLabel;
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        int i = n;
        while (i < this.nSlices) {
            this.stack[i - 1] = this.stack[i];
            this.label[i - 1] = this.label[i];
            ++i;
        }
        this.stack[this.nSlices - 1] = null;
        this.label[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle roi) {
        this.roi = roi;
    }

    public Rectangle getRoi() {
        return this.roi;
    }

    public void update(ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.stack[n - 1];
    }

    public void setPixels(Object pixels, int n) {
        if (pixels == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.stack[n - 1] = pixels;
    }

    public Object[] getImageArray() {
        return this.stack;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.label[n - 1];
    }

    public void setSliceLabel(String label, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.label[n - 1] = label;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices == 0) {
            return null;
        }
        ImageProcessor ip = null;
        if (this.stack[0] instanceof byte[]) {
            ip = new ByteProcessor(this.width, this.height, (byte[])this.stack[n - 1], this.cm);
        } else if (this.stack[0] instanceof short[]) {
            ip = new ShortProcessor(this.width, this.height, (short[])this.stack[n - 1], this.cm);
        } else if (this.stack[0] instanceof int[]) {
            ip = new ColorProcessor(this.width, this.height, (int[])this.stack[n - 1]);
        } else if (this.stack[0] instanceof float[]) {
            ip = new FloatProcessor(this.width, this.height, (float[])this.stack[n - 1], this.cm);
        }
        if (this.min != Double.MAX_VALUE && ip != null && !(ip instanceof ColorProcessor)) {
            ip.setMinAndMax(this.min, this.max);
        }
        return ip;
    }

    public void setColorModel(ColorModel cm) {
        this.cm = cm;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isRGB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Red");
    }

    public boolean isHSB() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public void trim() {
        int n = (int)Math.round(Math.log(this.nSlices) + 1.0);
        int i = 0;
        while (i < n) {
            this.deleteLastSlice();
            System.gc();
            ++i;
        }
    }

    public String toString() {
        return "width=" + this.width + ", height=" + this.height + ", nSlices=" + this.nSlices + ", cm=" + this.cm;
    }
}

