/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.process.ImageProcessor;

public class Undo {
    public static final int NOTHING = 0;
    public static final int FILTER = 1;
    public static final int TYPE_CONVERSION = 2;
    public static final int PASTE = 3;
    public static final int COMPOUND_FILTER = 4;
    public static final int COMPOUND_FILTER_DONE = 5;
    private static int whatToUndo = 0;
    private static int imageID;
    private static ImageProcessor ipCopy;

    public static void setup(int what, ImagePlus imp) {
        ImageProcessor ip;
        if (imp == null) {
            Undo.reset();
            return;
        }
        if (what == 1 && whatToUndo == 4) {
            return;
        }
        if (what == 5) {
            if (whatToUndo == 4) {
                whatToUndo = what;
            }
            return;
        }
        whatToUndo = what;
        imageID = imp.getID();
        ipCopy = what == 2 ? imp.getProcessor() : (what == 4 ? ((ip = imp.getProcessor()) != null ? ip.duplicate() : null) : null);
    }

    public static void reset() {
        whatToUndo = 0;
        imageID = 0;
        ipCopy = null;
    }

    public static void undo() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imageID != imp.getID()) {
            Undo.reset();
            return;
        }
        switch (whatToUndo) {
            case 1: {
                ImageProcessor ip = imp.getProcessor();
                if (ip == null) break;
                ip.reset();
                imp.updateAndDraw();
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                if (ipCopy == null) break;
                imp.setProcessor(null, ipCopy);
                break;
            }
            case 3: {
                Roi roi = imp.getRoi();
                if (roi == null) break;
                roi.abortPaste();
                break;
            }
        }
        Undo.reset();
    }

    static {
        ipCopy = null;
    }
}

