/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import ij.plugin.Converter;
import ij.plugin.frame.Recorder;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector imageList = new Vector();
    private static Vector nonImageList = new Vector();
    private static ImageWindow currentWindow;
    private static Frame frontWindow;

    public static synchronized void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        WindowManager.setWindow(win);
        if (win == currentWindow || win == null || imageList.size() == 0) {
            return;
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null && imp.lockSilently()) {
            imp.trimProcessor();
            Image img = imp.getImage();
            if (img != null) {
                img.flush();
            }
            if (!Converter.newWindowCreated) {
                imp.saveRoi();
            }
            Converter.newWindowCreated = false;
            imp.unlock();
        }
        Undo.reset();
        currentWindow = !win.isClosed() && win.getImagePlus() != null ? win : null;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        return currentWindow;
    }

    static int getCurrentIndex() {
        return imageList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        return imageList.size();
    }

    public static synchronized int[] getIDList() {
        int nWindows = imageList.size();
        if (nWindows == 0) {
            return null;
        }
        int[] list = new int[nWindows];
        int i = 0;
        while (i < nWindows) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            list[i] = win.getImagePlus().getID();
            ++i;
        }
        return list;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (imageID >= 0) {
            return null;
        }
        ImagePlus imp = null;
        int i = 0;
        while (i < imageList.size()) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i);
            ImagePlus imp2 = win.getImagePlus();
            if (imageID == imp2.getID()) {
                imp = imp2;
                break;
            }
            ++i;
        }
        return imp;
    }

    public static synchronized void addWindow(Frame win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.addImageWindow((ImageWindow)win);
        } else {
            Menus.insertWindowMenuItem(win);
            nonImageList.addElement(win);
        }
    }

    private static void addImageWindow(ImageWindow win) {
        imageList.addElement(win);
        Menus.addWindowMenuItem(win.getImagePlus());
        WindowManager.setCurrentWindow(win);
    }

    public static synchronized void removeWindow(Frame win) {
        if (win == null) {
            return;
        }
        if (win instanceof ImageWindow) {
            WindowManager.removeImageWindow((ImageWindow)win);
        } else {
            int index = nonImageList.indexOf(win);
            if (index >= 0) {
                Menus.removeWindowMenuItem(index);
                nonImageList.removeElement(win);
            }
        }
    }

    private static void removeImageWindow(ImageWindow win) {
        int index = imageList.indexOf(win);
        if (index == -1) {
            return;
        }
        if (imageList.size() > 1) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = imageList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)imageList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        imageList.removeElementAt(index);
        int nonImageCount = nonImageList.size();
        if (nonImageCount > 0) {
            ++nonImageCount;
        }
        Menus.removeWindowMenuItem(nonImageCount + index);
        Menus.updateMenus();
        Undo.reset();
    }

    public static void setWindow(Frame win) {
        if (win == null) {
            return;
        }
        frontWindow = win;
    }

    public static synchronized boolean closeAllWindows() {
        while (imageList.size() > 0) {
            ImagePlus imp = ((ImageWindow)imageList.elementAt(0)).getImagePlus();
            if (!((ImageWindow)imageList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.write("putBehind");
        }
        if (imageList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = imageList.indexOf(currentWindow);
        if (--index < 0) {
            index = imageList.size() - 1;
        }
        ImageWindow win = (ImageWindow)imageList.elementAt(index);
        WindowManager.setCurrentWindow(win);
        win.toFront();
        Menus.updateMenus();
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        int i = 0;
        while (i < nonImageList.size()) {
            Frame win = (Frame)nonImageList.elementAt(i);
            String title = win.getTitle();
            if (menuItemLabel.equals(title)) {
                win.toFront();
                ((CheckboxMenuItem)item).setState(false);
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < imageList.size()) {
            ImageWindow win = (ImageWindow)imageList.elementAt(i2);
            String title = win.getImagePlus().getTitle();
            if (menuItemLabel.startsWith(title)) {
                int start;
                WindowManager.setCurrentWindow(win);
                win.toFront();
                int index = imageList.indexOf(win);
                int n = Menus.window.getItemCount();
                int j = start = 5 + Menus.windowMenuItems2;
                while (j < n) {
                    MenuItem mi = Menus.window.getItem(j);
                    ((CheckboxMenuItem)mi).setState(j - start == index);
                    ++j;
                }
                if (!Recorder.record) break;
                Recorder.record("selectWindow", title);
                break;
            }
            ++i2;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int i = 0;
            while (i < imageList.size()) {
                ImageWindow win = (ImageWindow)imageList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.write(String.valueOf(i) + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
                ++i;
            }
            IJ.write(" ");
        }
    }
}

