/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.Roi;
import ij.gui.SaveChangesDialog;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class ImageWindow
extends Frame
implements FocusListener,
WindowListener {
    protected ImagePlus imp;
    protected ImageJ ij;
    protected ImageCanvas ic;
    private double initialMagnification = 1.0;
    protected static ImagePlus clipboard;
    protected boolean closed;
    private static final int XINC = 8;
    private static final int YINC = 12;
    private static final int TEXT_GAP = 10;
    private static final int MENU_BAR_HEIGHT = 40;
    private static int xbase;
    private static int ybase;
    private static int xloc;
    private static int yloc;
    private static int count;
    public boolean running;
    private int j = 0;

    public ImageWindow(ImagePlus imagePlus) {
        this(imagePlus, new ImageCanvas(imagePlus));
    }

    public ImageWindow(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        super(imagePlus.getTitle());
        ((Component)this).setBackground(Color.white);
        this.setForeground(Color.black);
        this.ij = IJ.getInstance();
        this.imp = imagePlus;
        this.ic = imageCanvas;
        ImageWindow imageWindow = imagePlus.getWindow();
        this.setLayout(new ImageLayout(imageCanvas));
        this.add(imageCanvas);
        this.addFocusListener(this);
        this.addWindowListener(this);
        this.setResizable(true);
        WindowManager.addWindow(this);
        imagePlus.setWindow(this);
        if (imageWindow != null) {
            this.setLocationAndSize();
            Point point = imageWindow.getLocation();
            ((Component)this).setLocation(point.x, point.y);
            this.pack();
            ((Component)this).setVisible(true);
            boolean bl = imagePlus.lockSilently();
            boolean bl2 = imagePlus.changes;
            imagePlus.changes = false;
            imageWindow.close();
            imagePlus.changes = bl2;
            if (bl) {
                imagePlus.unlock();
            }
            WindowManager.setCurrentWindow(this);
        } else {
            Image image;
            this.setLocationAndSize();
            if (this.ij != null && (image = this.ij.getIconImage()) != null) {
                this.setIconImage(image);
            }
            this.pack();
            ((Component)this).setVisible(true);
        }
    }

    private void setLocationAndSize() {
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        if (WindowManager.getWindowCount() <= 1) {
            xbase = -1;
        }
        if (xbase == -1) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = this.ij != null ? this.ij.getBounds() : new Rectangle(10, 5, 0, 0);
            if (IJ.isMacintosh()) {
                rectangle.height += 24;
            }
            count = 0;
            xbase = 5;
            ybase = rectangle.y + rectangle.height;
            if (ybase > 140) {
                ybase = rectangle.height;
            }
            xloc = xbase;
            yloc = ybase;
        }
        int n3 = xloc;
        int n4 = yloc;
        xloc += 8;
        yloc += 12;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (++count % 6 == 0) {
            xloc = xbase;
            yloc = ybase;
        }
        int n5 = IJ.isWindows() ? 30 : 0;
        int n6 = this instanceof StackWindow ? 20 : 0;
        int n7 = dimension.height - 40 - n5 - n6;
        double d = 1.0;
        while ((double)(xbase + 32) + (double)n * d > (double)dimension.width || (double)ybase + (double)n2 * d > (double)n7) {
            d = ImageCanvas.getLowerZoomLevel(d);
        }
        this.ic.setMagnification(d);
        if (d < 1.0) {
            this.initialMagnification = d;
            this.ic.setDrawingSize((int)((double)n * d), (int)((double)n2 * d));
        }
        if ((double)n4 + (double)n2 * d > (double)n7) {
            n4 = ybase;
        }
        ((Component)this).setLocation(n3, n4);
    }

    public double getInitialMagnification() {
        return this.initialMagnification;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics graphics) {
        String string = "";
        Insets insets = super.getInsets();
        int n = this.imp.getStackSize();
        if (n > 1) {
            ImageStack imageStack = this.imp.getStack();
            int n2 = this.imp.getCurrentSlice();
            string = String.valueOf(string) + n2 + "/" + n;
            String string2 = imageStack.getSliceLabel(n2);
            if (string2 != null && string2.length() > 0) {
                string = String.valueOf(string) + " (" + string2 + ")";
            }
            if (this instanceof StackWindow && this.running) {
                graphics.drawString(string, 5, insets.top + 10);
                return;
            }
            string = String.valueOf(string) + "; ";
        }
        int n3 = this.imp.getType();
        Calibration calibration = this.imp.getCalibration();
        string = calibration.pixelWidth != 1.0 || calibration.pixelHeight != 1.0 ? String.valueOf(string) + IJ.d2s((double)this.imp.getWidth() * calibration.pixelWidth, 2) + "x" + IJ.d2s((double)this.imp.getHeight() * calibration.pixelHeight, 2) + " " + calibration.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : String.valueOf(string) + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int n4 = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (n3) {
            case 0: {
                string = String.valueOf(string) + "8-bit grayscale";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "16-bit grayscale";
                n4 *= 2;
                break;
            }
            case 2: {
                string = String.valueOf(string) + "32-bit grayscale";
                n4 *= 4;
                break;
            }
            case 3: {
                string = String.valueOf(string) + "8-bit color";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "RGB";
                n4 *= 4;
                break;
            }
        }
        string = String.valueOf(string) + "; " + n4 + "K";
        graphics.drawString(string, 5, insets.top + 10);
    }

    public void paint(Graphics graphics) {
        this.drawInfo(graphics);
        Point point = this.ic.getLocation();
        Dimension dimension = this.ic.getSize();
        graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
    }

    public boolean close() {
        boolean bl = this.running;
        this.running = false;
        if (bl) {
            IJ.wait(500);
        }
        if (this.imp.changes && IJ.getApplet() == null && !IJ.macroRunning()) {
            FileSaver fileSaver;
            SaveChangesDialog saveChangesDialog = new SaveChangesDialog((Frame)IJ.getInstance(), this.imp.getTitle());
            if (saveChangesDialog.cancelPressed()) {
                return false;
            }
            if (saveChangesDialog.savePressed() && !(fileSaver = new FileSaver(this.imp)).save()) {
                return false;
            }
        }
        if (WindowManager.getWindowCount() == 0) {
            xloc = 0;
            yloc = 0;
        }
        this.closed = true;
        WindowManager.removeWindow(this);
        ((Component)this).setVisible(false);
        this.dispose();
        this.imp.flush();
        return true;
    }

    public ImagePlus getImagePlus() {
        return this.imp;
    }

    void setImagePlus(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.repaint();
    }

    public ImageCanvas getCanvas() {
        return this.ic;
    }

    static ImagePlus getClipboard() {
        return clipboard;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void focusGained(FocusEvent focusEvent) {
        WindowManager.setCurrentWindow(this);
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (IJ.isMacintosh() && IJ.getInstance() != null) {
            this.setMenuBar(Menus.getMenuBar());
        }
        if (!this.closed) {
            WindowManager.setCurrentWindow(this);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (IJ.getInstance() != null) {
            WindowManager.setCurrentWindow(this);
            IJ.doCommand("Close");
        } else {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void copy(boolean bl) {
        Roi roi = this.imp.getRoi();
        String string = bl ? "Cut" : "Copy";
        IJ.showStatus(String.valueOf(string) + "ing...");
        ImageProcessor imageProcessor = this.imp.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        clipboard = new ImagePlus("Clipboard", imageProcessor2);
        if (roi != null && roi.getType() != 0) {
            clipboard.setRoi((Roi)roi.clone());
        }
        if (bl) {
            imageProcessor.snapshot();
            imageProcessor.setColor(Toolbar.getBackgroundColor());
            imageProcessor.fill();
            if (roi != null && roi.getType() != 0) {
                imageProcessor.reset(this.imp.getMask());
            }
            this.imp.setColor(Toolbar.getForegroundColor());
            Undo.setup(1, this.imp);
            this.imp.updateAndDraw();
        }
        int n = 1;
        switch (clipboard.getType()) {
            case 1: {
                n = 2;
                break;
            }
            case 2: 
            case 4: {
                n = 4;
            }
        }
        IJ.showStatus(String.valueOf(string) + ": " + clipboard.getWidth() * clipboard.getHeight() * n / 1024 + "k");
    }

    public void paste() {
        if (clipboard == null) {
            return;
        }
        int n = clipboard.getType();
        int n2 = this.imp.getType();
        boolean bl = false;
        if (n == 0 | n == 3 && n2 == 0 | n2 == 3) {
            bl = true;
        } else if (n == 4 | n == 0 | n == 3 && n2 == 4) {
            bl = true;
        } else if (n == 1 && n2 == 1) {
            bl = true;
        } else if (n == 2 && n2 == 2) {
            bl = true;
        }
        if (!bl) {
            IJ.error("Images must be the same type to paste.");
            return;
        }
        int n3 = clipboard.getWidth();
        int n4 = clipboard.getHeight();
        if (n3 > this.imp.getWidth() || n4 > this.imp.getHeight()) {
            IJ.error("Image is too large to paste.");
            return;
        }
        Roi roi = this.imp.getRoi();
        Rectangle rectangle = null;
        if (roi != null) {
            rectangle = roi.getBoundingRect();
        }
        if (rectangle == null || rectangle != null && (n3 != rectangle.width || n4 != rectangle.height)) {
            Rectangle rectangle2 = this.ic.getSrcRect();
            int n5 = rectangle2.x + rectangle2.width / 2;
            int n6 = rectangle2.y + rectangle2.height / 2;
            Roi roi2 = clipboard.getRoi();
            if (roi2 != null && roi2.getType() != 0) {
                roi2.setImage(this.imp);
                roi2.setLocation(n5 - n3 / 2, n6 - n4 / 2);
                this.imp.setRoi(roi2);
            } else {
                this.imp.setRoi(n5 - n3 / 2, n6 - n4 / 2, n3, n4);
            }
            roi = this.imp.getRoi();
        }
        roi.startPaste(clipboard);
        Undo.setup(3, this.imp);
        this.imp.changes = true;
    }

    public void mouseMoved(int n, int n2) {
        this.imp.mouseMoved(n, n2);
    }

    public String toString() {
        return this.imp.getTitle();
    }

    static {
        xbase = -1;
    }
}

