/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Graphics;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    private int x1R = 0;
    private int y1R = 0;
    private int x2R;
    private int y2R;
    private static int lineWidth = 1;

    public Line(int ox, int oy, ImagePlus imp) {
        super(ox, oy, imp);
        this.type = 5;
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, imp);
        this.grow(ox2, oy2);
        this.state = 3;
    }

    protected void grow(int xend, int yend) {
        if (xend < 0) {
            xend = 0;
        }
        if (yend < 0) {
            yend = 0;
        }
        if (xend > this.xMax) {
            xend = this.xMax;
        }
        if (yend > this.yMax) {
            yend = this.yMax;
        }
        int xstart = this.x + this.x1R;
        int ystart = this.y + this.y1R;
        this.x = Math.min(this.x + this.x1R, xend);
        this.y = Math.min(this.y + this.y1R, yend);
        this.x1R = xstart - this.x;
        this.y1R = ystart - this.y;
        this.x2R = xend - this.x;
        this.y2R = yend - this.y;
        this.width = Math.abs(this.x2R - this.x1R);
        this.height = Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    public void draw(Graphics g) {
        g.setColor(Roi.ROIColor);
        this.x1 = this.x + this.x1R;
        this.y1 = this.y + this.y1R;
        this.x2 = this.x + this.x2R;
        this.y2 = this.y + this.y2R;
        g.drawLine(this.ic.screenX(this.x1), this.ic.screenY(this.y1), this.ic.screenX(this.x2), this.ic.screenY(this.y2));
        IJ.showStatus(String.valueOf(this.imp.getLocationAsString(this.x2, this.y2)) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt((double)(this.x2 - this.x1) * cal.pixelWidth * (double)(this.x2 - this.x1) * cal.pixelWidth + (double)(this.y2 - this.y1) * cal.pixelHeight * (double)(this.y2 - this.y1) * cal.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    public double[] getPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        double[] line = ip.getLine(this.x1, this.y1, this.x2, this.y2);
        return line;
    }

    public void drawPixels() {
        ImageProcessor ip = this.imp.getProcessor();
        ip.moveTo(this.x1, this.y1);
        ip.lineTo(this.x2, this.y2);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        if (w < 1) {
            w = 1;
        }
        if (w > 99) {
            w = 99;
        }
        lineWidth = w;
    }

    public void nudgeCorner(int key) {
        switch (key) {
            case 38: {
                --this.y2R;
                break;
            }
            case 40: {
                ++this.y2R;
                break;
            }
            case 37: {
                --this.x2R;
                break;
            }
            case 39: {
                ++this.x2R;
                break;
            }
        }
        this.grow(this.x + this.x2R, this.y + this.y2R);
    }
}

