/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageReader {
    private FileInfo fi;
    private int width;
    private int height;
    private int skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;

    public ImageReader(FileInfo fi) {
        this.fi = fi;
        this.width = fi.width;
        this.height = fi.height;
        this.skipCount = fi.offset;
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream in) throws IOException {
        int totalRead = 0;
        byte[] pixels = new byte[this.nPixels];
        while (totalRead < this.byteCount) {
            int count = totalRead + this.bufferSize > this.nPixels ? this.nPixels - totalRead : this.bufferSize;
            int actuallyRead = in.read(pixels, totalRead, count);
            if (actuallyRead == -1) {
                this.eofError();
                break;
            }
            this.showProgress((double)(totalRead += actuallyRead) / (double)this.byteCount);
        }
        return pixels;
    }

    private void showProgress(double progress) {
        if (this.showProgressBar) {
            IJ.showProgress(progress);
        }
    }

    short[] read16bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        short[] pixels = new short[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int j;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    if (this.fi.fileType == 1) {
                        i = base;
                        while (i < pixels.length) {
                            pixels[i] = Short.MIN_VALUE;
                            ++i;
                        }
                    }
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)(((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF) + 32768);
                        ++i;
                        j += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)(((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF) + 32768);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    float[] read32bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int tmp;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            if (this.fi.intelByteOrder) {
                i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j + 3] & 0xFF) << 24 | (buffer[j + 2] & 0xFF) << 16 | (buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (float)tmp;
                    j += 4;
                    ++i;
                }
            } else {
                i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j] & 0xFF) << 24 | (buffer[j + 1] & 0xFF) << 16 | (buffer[j + 2] & 0xFF) << 8 | buffer[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (float)tmp;
                    j += 4;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readChunkyRGB(InputStream in) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            boolean bgr = this.fi.fileType == 10;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                if (this.bytesPerPixel == 4) {
                    // empty if block
                }
                int n = ++j;
                int r = buffer[n] & 0xFF;
                int n2 = ++j;
                int g = buffer[n2] & 0xFF;
                int n3 = ++j;
                ++j;
                int b = buffer[n3] & 0xFF;
                pixels[i] = bgr ? 0xFF000000 | b << 16 | g << 8 | r : 0xFF000000 | r << 16 | g << 8 | b;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readPlanarRGB(InputStream in) throws IOException {
        int planeSize = this.nPixels;
        byte[] buffer = new byte[planeSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        this.showProgress(0.12);
        int bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i = 0;
        while (i < planeSize) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
            ++i;
        }
        this.showProgress(0.37);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i2 = 0;
        while (i2 < planeSize) {
            int g = buffer[i2] & 0xFF;
            int n = i2++;
            pixels[n] = pixels[n] | g << 8;
        }
        this.showProgress(0.62);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i3 = 0;
        while (i3 < planeSize) {
            int b = buffer[i3] & 0xFF;
            int n = i3++;
            pixels[n] = pixels[n] | b;
        }
        this.showProgress(0.87);
        return pixels;
    }

    void skip(InputStream in) throws IOException {
        if (this.skipCount > 0) {
            int bytesRead = 0;
            int skipAttempts = 0;
            while (bytesRead < this.skipCount) {
                long count = in.skip(this.skipCount - bytesRead);
                if (count == -1L || ++skipAttempts > 5) break;
                bytesRead = (int)((long)bytesRead + count);
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream in) {
        try {
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    return this.read8bitImage(in);
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    return this.read16bitImage(in);
                }
                case 3: 
                case 4: {
                    this.bytesPerPixel = 4;
                    this.skip(in);
                    return this.read32bitImage(in);
                }
                case 6: 
                case 9: 
                case 10: {
                    this.bytesPerPixel = this.fi.fileType == 9 ? 4 : 3;
                    this.skip(in);
                    return this.readChunkyRGB(in);
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(in);
                    return this.readPlanarRGB(in);
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    byte[] bitmap = this.read8bitImage(in);
                    this.expandBitmap(bitmap);
                    return bitmap;
                }
            }
            return null;
        }
        catch (IOException e) {
            IJ.write(String.valueOf(String.valueOf(e)));
            return null;
        }
    }

    public Object readPixels(InputStream in, int skipCount) {
        this.skipCount = skipCount;
        this.showProgressBar = false;
        Object pixels = this.readPixels(in);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return pixels;
    }

    public Object readPixels(String url) {
        InputStream is;
        URL theURL;
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IJ.write(String.valueOf(String.valueOf(e)));
            return null;
        }
        try {
            is = theURL.openStream();
        }
        catch (IOException e) {
            IJ.write(String.valueOf(String.valueOf(e)));
            return null;
        }
        return this.readPixels(is);
    }

    void expandBitmap(byte[] pixels) {
        int scan = this.width / 8;
        int pad = this.width % 8;
        if (pad > 0) {
            ++scan;
        }
        int len = scan * this.height;
        byte[] bitmap = new byte[len];
        System.arraycopy(pixels, 0, bitmap, 0, len);
        int n = 0;
        int y = 0;
        while (y < this.height) {
            int offset = y * scan;
            int x = 0;
            while (x < scan) {
                if (n + 8 < this.width * this.height) {
                    int value1 = bitmap[offset + x] & 0xFF;
                    int i = 7;
                    while (i >= 0) {
                        int value2 = (value1 & 1 << i) != 0 ? 255 : 0;
                        pixels[n++] = (byte)value2;
                        --i;
                    }
                }
                ++x;
            }
            n -= pad > 0 ? 8 - pad : 0;
            ++y;
        }
    }
}

